/**
 * @licstart The following is the entire license notice for the
 * JavaScript code in this page
 *
 * Copyright 2023 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @licend The above is the entire license notice for the
 * JavaScript code in this page
 */

(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = root.pdfjsWorker = factory();
	else if(typeof define === 'function' && define.amd)
		define("pdfjs-dist/build/pdf.worker", [], () => { return (root.pdfjsWorker = factory()); });
	else if(typeof exports === 'object')
		exports["pdfjs-dist/build/pdf.worker"] = root.pdfjsWorker = factory();
	else
		root["pdfjs-dist/build/pdf.worker"] = root.pdfjsWorker = factory();
})(globalThis, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ([
/* 0 */,
/* 1 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

__w_pdfjs_require__(2);__w_pdfjs_require__(54);__w_pdfjs_require__(56);__w_pdfjs_require__(104);__w_pdfjs_require__(105);__w_pdfjs_require__(113);__w_pdfjs_require__(114);__w_pdfjs_require__(123);__w_pdfjs_require__(129);__w_pdfjs_require__(130);__w_pdfjs_require__(131);__w_pdfjs_require__(132);__w_pdfjs_require__(133);__w_pdfjs_require__(134);function _typeof(obj){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj;}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;},_typeof(obj);}Object.defineProperty(exports, "__esModule", ({value:true}));exports.WorkerTask=exports.WorkerMessageHandler=void 0;__w_pdfjs_require__(137);__w_pdfjs_require__(143);__w_pdfjs_require__(145);__w_pdfjs_require__(174);__w_pdfjs_require__(175);__w_pdfjs_require__(177);__w_pdfjs_require__(180);__w_pdfjs_require__(182);__w_pdfjs_require__(183);__w_pdfjs_require__(191);__w_pdfjs_require__(208);__w_pdfjs_require__(209);__w_pdfjs_require__(212);__w_pdfjs_require__(213);__w_pdfjs_require__(214);__w_pdfjs_require__(218);__w_pdfjs_require__(219);__w_pdfjs_require__(220);__w_pdfjs_require__(222);__w_pdfjs_require__(223);__w_pdfjs_require__(224);__w_pdfjs_require__(225);__w_pdfjs_require__(226);__w_pdfjs_require__(227);__w_pdfjs_require__(228);__w_pdfjs_require__(231);__w_pdfjs_require__(232);__w_pdfjs_require__(234);__w_pdfjs_require__(235);__w_pdfjs_require__(236);__w_pdfjs_require__(237);__w_pdfjs_require__(238);__w_pdfjs_require__(239);__w_pdfjs_require__(244);__w_pdfjs_require__(245);__w_pdfjs_require__(247);__w_pdfjs_require__(248);__w_pdfjs_require__(249);__w_pdfjs_require__(251);__w_pdfjs_require__(254);__w_pdfjs_require__(257);__w_pdfjs_require__(258);__w_pdfjs_require__(266);__w_pdfjs_require__(277);__w_pdfjs_require__(279);__w_pdfjs_require__(281);__w_pdfjs_require__(283);__w_pdfjs_require__(285);__w_pdfjs_require__(287);__w_pdfjs_require__(289);__w_pdfjs_require__(292);__w_pdfjs_require__(294);__w_pdfjs_require__(295);__w_pdfjs_require__(296);__w_pdfjs_require__(298);__w_pdfjs_require__(299);__w_pdfjs_require__(301);__w_pdfjs_require__(302);var _util=__w_pdfjs_require__(303);var _core_utils=__w_pdfjs_require__(342);var _primitives=__w_pdfjs_require__(349);var _pdf_manager=__w_pdfjs_require__(354);var _annotation=__w_pdfjs_require__(366);var _cleanup_helper=__w_pdfjs_require__(455);var _writer=__w_pdfjs_require__(448);var _message_handler=__w_pdfjs_require__(495);var _worker_stream=__w_pdfjs_require__(496);function _toArray(arr){return _arrayWithHoles(arr)||_iterableToArray(arr)||_unsupportedIterableToArray(arr)||_nonIterableRest();}function _iterableToArray(iter){if(typeof Symbol!=="undefined"&&iter[Symbol.iterator]!=null||iter["@@iterator"]!=null)return Array.from(iter);}function _regeneratorRuntime(){"use strict";/*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */_regeneratorRuntime=function _regeneratorRuntime(){return exports;};var exports={},Op=Object.prototype,hasOwn=Op.hasOwnProperty,defineProperty=Object.defineProperty||function(obj,key,desc){obj[key]=desc.value;},$Symbol="function"==typeof Symbol?Symbol:{},iteratorSymbol=$Symbol.iterator||"@@iterator",asyncIteratorSymbol=$Symbol.asyncIterator||"@@asyncIterator",toStringTagSymbol=$Symbol.toStringTag||"@@toStringTag";function define(obj,key,value){return Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}),obj[key];}try{define({},"");}catch(err){define=function define(obj,key,value){return obj[key]=value;};}function wrap(innerFn,outerFn,self,tryLocsList){var protoGenerator=outerFn&&outerFn.prototype instanceof Generator?outerFn:Generator,generator=Object.create(protoGenerator.prototype),context=new Context(tryLocsList||[]);return defineProperty(generator,"_invoke",{value:makeInvokeMethod(innerFn,self,context)}),generator;}function tryCatch(fn,obj,arg){try{return{type:"normal",arg:fn.call(obj,arg)};}catch(err){return{type:"throw",arg:err};}}exports.wrap=wrap;var ContinueSentinel={};function Generator(){}function GeneratorFunction(){}function GeneratorFunctionPrototype(){}var IteratorPrototype={};define(IteratorPrototype,iteratorSymbol,function(){return this;});var getProto=Object.getPrototypeOf,NativeIteratorPrototype=getProto&&getProto(getProto(values([])));NativeIteratorPrototype&&NativeIteratorPrototype!==Op&&hasOwn.call(NativeIteratorPrototype,iteratorSymbol)&&(IteratorPrototype=NativeIteratorPrototype);var Gp=GeneratorFunctionPrototype.prototype=Generator.prototype=Object.create(IteratorPrototype);function defineIteratorMethods(prototype){["next","throw","return"].forEach(function(method){define(prototype,method,function(arg){return this._invoke(method,arg);});});}function AsyncIterator(generator,PromiseImpl){function invoke(method,arg,resolve,reject){var record=tryCatch(generator[method],generator,arg);if("throw"!==record.type){var result=record.arg,value=result.value;return value&&"object"==_typeof(value)&&hasOwn.call(value,"__await")?PromiseImpl.resolve(value.__await).then(function(value){invoke("next",value,resolve,reject);},function(err){invoke("throw",err,resolve,reject);}):PromiseImpl.resolve(value).then(function(unwrapped){result.value=unwrapped,resolve(result);},function(error){return invoke("throw",error,resolve,reject);});}reject(record.arg);}var previousPromise;defineProperty(this,"_invoke",{value:function value(method,arg){function callInvokeWithMethodAndArg(){return new PromiseImpl(function(resolve,reject){invoke(method,arg,resolve,reject);});}return previousPromise=previousPromise?previousPromise.then(callInvokeWithMethodAndArg,callInvokeWithMethodAndArg):callInvokeWithMethodAndArg();}});}function makeInvokeMethod(innerFn,self,context){var state="suspendedStart";return function(method,arg){if("executing"===state)throw new Error("Generator is already running");if("completed"===state){if("throw"===method)throw arg;return doneResult();}for(context.method=method,context.arg=arg;;){var delegate=context.delegate;if(delegate){var delegateResult=maybeInvokeDelegate(delegate,context);if(delegateResult){if(delegateResult===ContinueSentinel)continue;return delegateResult;}}if("next"===context.method)context.sent=context._sent=context.arg;else if("throw"===context.method){if("suspendedStart"===state)throw state="completed",context.arg;context.dispatchException(context.arg);}else"return"===context.method&&context.abrupt("return",context.arg);state="executing";var record=tryCatch(innerFn,self,context);if("normal"===record.type){if(state=context.done?"completed":"suspendedYield",record.arg===ContinueSentinel)continue;return{value:record.arg,done:context.done};}"throw"===record.type&&(state="completed",context.method="throw",context.arg=record.arg);}};}function maybeInvokeDelegate(delegate,context){var methodName=context.method,method=delegate.iterator[methodName];if(undefined===method)return context.delegate=null,"throw"===methodName&&delegate.iterator.return&&(context.method="return",context.arg=undefined,maybeInvokeDelegate(delegate,context),"throw"===context.method)||"return"!==methodName&&(context.method="throw",context.arg=new TypeError("The iterator does not provide a '"+methodName+"' method")),ContinueSentinel;var record=tryCatch(method,delegate.iterator,context.arg);if("throw"===record.type)return context.method="throw",context.arg=record.arg,context.delegate=null,ContinueSentinel;var info=record.arg;return info?info.done?(context[delegate.resultName]=info.value,context.next=delegate.nextLoc,"return"!==context.method&&(context.method="next",context.arg=undefined),context.delegate=null,ContinueSentinel):info:(context.method="throw",context.arg=new TypeError("iterator result is not an object"),context.delegate=null,ContinueSentinel);}function pushTryEntry(locs){var entry={tryLoc:locs[0]};1 in locs&&(entry.catchLoc=locs[1]),2 in locs&&(entry.finallyLoc=locs[2],entry.afterLoc=locs[3]),this.tryEntries.push(entry);}function resetTryEntry(entry){var record=entry.completion||{};record.type="normal",delete record.arg,entry.completion=record;}function Context(tryLocsList){this.tryEntries=[{tryLoc:"root"}],tryLocsList.forEach(pushTryEntry,this),this.reset(!0);}function values(iterable){if(iterable){var iteratorMethod=iterable[iteratorSymbol];if(iteratorMethod)return iteratorMethod.call(iterable);if("function"==typeof iterable.next)return iterable;if(!isNaN(iterable.length)){var i=-1,next=function next(){for(;++i<iterable.length;)if(hasOwn.call(iterable,i))return next.value=iterable[i],next.done=!1,next;return next.value=undefined,next.done=!0,next;};return next.next=next;}}return{next:doneResult};}function doneResult(){return{value:undefined,done:!0};}return GeneratorFunction.prototype=GeneratorFunctionPrototype,defineProperty(Gp,"constructor",{value:GeneratorFunctionPrototype,configurable:!0}),defineProperty(GeneratorFunctionPrototype,"constructor",{value:GeneratorFunction,configurable:!0}),GeneratorFunction.displayName=define(GeneratorFunctionPrototype,toStringTagSymbol,"GeneratorFunction"),exports.isGeneratorFunction=function(genFun){var ctor="function"==typeof genFun&&genFun.constructor;return!!ctor&&(ctor===GeneratorFunction||"GeneratorFunction"===(ctor.displayName||ctor.name));},exports.mark=function(genFun){return Object.setPrototypeOf?Object.setPrototypeOf(genFun,GeneratorFunctionPrototype):(genFun.__proto__=GeneratorFunctionPrototype,define(genFun,toStringTagSymbol,"GeneratorFunction")),genFun.prototype=Object.create(Gp),genFun;},exports.awrap=function(arg){return{__await:arg};},defineIteratorMethods(AsyncIterator.prototype),define(AsyncIterator.prototype,asyncIteratorSymbol,function(){return this;}),exports.AsyncIterator=AsyncIterator,exports.async=function(innerFn,outerFn,self,tryLocsList,PromiseImpl){void 0===PromiseImpl&&(PromiseImpl=Promise);var iter=new AsyncIterator(wrap(innerFn,outerFn,self,tryLocsList),PromiseImpl);return exports.isGeneratorFunction(outerFn)?iter:iter.next().then(function(result){return result.done?result.value:iter.next();});},defineIteratorMethods(Gp),define(Gp,toStringTagSymbol,"Generator"),define(Gp,iteratorSymbol,function(){return this;}),define(Gp,"toString",function(){return"[object Generator]";}),exports.keys=function(val){var object=Object(val),keys=[];for(var key in object)keys.push(key);return keys.reverse(),function next(){for(;keys.length;){var key=keys.pop();if(key in object)return next.value=key,next.done=!1,next;}return next.done=!0,next;};},exports.values=values,Context.prototype={constructor:Context,reset:function reset(skipTempReset){if(this.prev=0,this.next=0,this.sent=this._sent=undefined,this.done=!1,this.delegate=null,this.method="next",this.arg=undefined,this.tryEntries.forEach(resetTryEntry),!skipTempReset)for(var name in this)"t"===name.charAt(0)&&hasOwn.call(this,name)&&!isNaN(+name.slice(1))&&(this[name]=undefined);},stop:function stop(){this.done=!0;var rootRecord=this.tryEntries[0].completion;if("throw"===rootRecord.type)throw rootRecord.arg;return this.rval;},dispatchException:function dispatchException(exception){if(this.done)throw exception;var context=this;function handle(loc,caught){return record.type="throw",record.arg=exception,context.next=loc,caught&&(context.method="next",context.arg=undefined),!!caught;}for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i],record=entry.completion;if("root"===entry.tryLoc)return handle("end");if(entry.tryLoc<=this.prev){var hasCatch=hasOwn.call(entry,"catchLoc"),hasFinally=hasOwn.call(entry,"finallyLoc");if(hasCatch&&hasFinally){if(this.prev<entry.catchLoc)return handle(entry.catchLoc,!0);if(this.prev<entry.finallyLoc)return handle(entry.finallyLoc);}else if(hasCatch){if(this.prev<entry.catchLoc)return handle(entry.catchLoc,!0);}else{if(!hasFinally)throw new Error("try statement without catch or finally");if(this.prev<entry.finallyLoc)return handle(entry.finallyLoc);}}}},abrupt:function abrupt(type,arg){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.tryLoc<=this.prev&&hasOwn.call(entry,"finallyLoc")&&this.prev<entry.finallyLoc){var finallyEntry=entry;break;}}finallyEntry&&("break"===type||"continue"===type)&&finallyEntry.tryLoc<=arg&&arg<=finallyEntry.finallyLoc&&(finallyEntry=null);var record=finallyEntry?finallyEntry.completion:{};return record.type=type,record.arg=arg,finallyEntry?(this.method="next",this.next=finallyEntry.finallyLoc,ContinueSentinel):this.complete(record);},complete:function complete(record,afterLoc){if("throw"===record.type)throw record.arg;return"break"===record.type||"continue"===record.type?this.next=record.arg:"return"===record.type?(this.rval=this.arg=record.arg,this.method="return",this.next="end"):"normal"===record.type&&afterLoc&&(this.next=afterLoc),ContinueSentinel;},finish:function finish(finallyLoc){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.finallyLoc===finallyLoc)return this.complete(entry.completion,entry.afterLoc),resetTryEntry(entry),ContinueSentinel;}},catch:function _catch(tryLoc){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.tryLoc===tryLoc){var record=entry.completion;if("throw"===record.type){var thrown=record.arg;resetTryEntry(entry);}return thrown;}}throw new Error("illegal catch attempt");},delegateYield:function delegateYield(iterable,resultName,nextLoc){return this.delegate={iterator:values(iterable),resultName:resultName,nextLoc:nextLoc},"next"===this.method&&(this.arg=undefined),ContinueSentinel;}},exports;}function _createForOfIteratorHelper(o,allowArrayLike){var it=typeof Symbol!=="undefined"&&o[Symbol.iterator]||o["@@iterator"];if(!it){if(Array.isArray(o)||(it=_unsupportedIterableToArray(o))||allowArrayLike&&o&&typeof o.length==="number"){if(it)o=it;var i=0;var F=function F(){};return{s:F,n:function n(){if(i>=o.length)return{done:true};return{done:false,value:o[i++]};},e:function e(_e2){throw _e2;},f:F};}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}var normalCompletion=true,didErr=false,err;return{s:function s(){it=it.call(o);},n:function n(){var step=it.next();normalCompletion=step.done;return step;},e:function e(_e3){didErr=true;err=_e3;},f:function f(){try{if(!normalCompletion&&it.return!=null)it.return();}finally{if(didErr)throw err;}}};}function _slicedToArray(arr,i){return _arrayWithHoles(arr)||_iterableToArrayLimit(arr,i)||_unsupportedIterableToArray(arr,i)||_nonIterableRest();}function _nonIterableRest(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}function _unsupportedIterableToArray(o,minLen){if(!o)return;if(typeof o==="string")return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);if(n==="Object"&&o.constructor)n=o.constructor.name;if(n==="Map"||n==="Set")return Array.from(o);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return _arrayLikeToArray(o,minLen);}function _arrayLikeToArray(arr,len){if(len==null||len>arr.length)len=arr.length;for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2;}function _iterableToArrayLimit(arr,i){var _i=null==arr?null:"undefined"!=typeof Symbol&&arr[Symbol.iterator]||arr["@@iterator"];if(null!=_i){var _s,_e,_x,_r,_arr=[],_n=!0,_d=!1;try{if(_x=(_i=_i.call(arr)).next,0===i){if(Object(_i)!==_i)return;_n=!1;}else for(;!(_n=(_s=_x.call(_i)).done)&&(_arr.push(_s.value),_arr.length!==i);_n=!0);}catch(err){_d=!0,_e=err;}finally{try{if(!_n&&null!=_i.return&&(_r=_i.return(),Object(_r)!==_r))return;}finally{if(_d)throw _e;}}return _arr;}}function _arrayWithHoles(arr){if(Array.isArray(arr))return arr;}function asyncGeneratorStep(gen,resolve,reject,_next,_throw,key,arg){try{var info=gen[key](arg);var value=info.value;}catch(error){reject(error);return;}if(info.done){resolve(value);}else{Promise.resolve(value).then(_next,_throw);}}function _asyncToGenerator(fn){return function(){var self=this,args=arguments;return new Promise(function(resolve,reject){var gen=fn.apply(self,args);function _next(value){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"next",value);}function _throw(err){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"throw",err);}_next(undefined);});};}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}}function _createClass(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);Object.defineProperty(Constructor,"prototype",{writable:false});return Constructor;}function _toPropertyKey(arg){var key=_toPrimitive(arg,"string");return _typeof(key)==="symbol"?key:String(key);}function _toPrimitive(input,hint){if(_typeof(input)!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(_typeof(res)!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.");}return(hint==="string"?String:Number)(input);}if(!Promise.allSettled){Promise.allSettled=function(promises){var mappedPromises=promises.filter(function(o){return!!o;}).map(function(p){return p.then(function(value){return{status:"fulfilled",value:value};}).catch(function(reason){return{status:"rejected",reason:reason};});});return Promise.all(mappedPromises);};}var WorkerTask=/*#__PURE__*/function(){function WorkerTask(name){_classCallCheck(this,WorkerTask);this.name=name;this.terminated=false;this._capability=new _util.PromiseCapability();}_createClass(WorkerTask,[{key:"finished",get:function get(){return this._capability.promise;}},{key:"finish",value:function finish(){this._capability.resolve();}},{key:"terminate",value:function terminate(){this.terminated=true;}},{key:"ensureNotTerminated",value:function ensureNotTerminated(){if(this.terminated){throw new Error("Worker task was terminated");}}}]);return WorkerTask;}();exports.WorkerTask=WorkerTask;var WorkerMessageHandler=/*#__PURE__*/function(){function WorkerMessageHandler(){_classCallCheck(this,WorkerMessageHandler);}_createClass(WorkerMessageHandler,null,[{key:"setup",value:function setup(handler,port){var testMessageProcessed=false;handler.on("test",function(data){if(testMessageProcessed){return;}testMessageProcessed=true;handler.send("test",data instanceof Uint8Array);});handler.on("configure",function(data){(0,_util.setVerbosityLevel)(data.verbosity);});handler.on("GetDocRequest",function(data){return WorkerMessageHandler.createDocumentHandler(data,port);});}},{key:"createDocumentHandler",value:function createDocumentHandler(docParams,port){var pdfManager;var terminated=false;var cancelXHRs=null;var WorkerTasks=new Set();var verbosity=(0,_util.getVerbosityLevel)();var _docParams=docParams,docId=_docParams.docId,apiVersion=_docParams.apiVersion;var workerVersion='3.11.438';if(apiVersion!==workerVersion){throw new Error("The API version \"".concat(apiVersion,"\" does not match ")+"the Worker version \"".concat(workerVersion,"\"."));}var enumerableProperties=[];for(var property in[]){enumerableProperties.push(property);}if(enumerableProperties.length){throw new Error("The `Array.prototype` contains unexpected enumerable properties: "+enumerableProperties.join(", ")+"; thus breaking e.g. `for...in` iteration of `Array`s.");}var workerHandlerName=docId+"_worker";var handler=new _message_handler.MessageHandler(workerHandlerName,docId,port);function ensureNotTerminated(){if(terminated){throw new Error("Worker was terminated");}}function startWorkerTask(task){WorkerTasks.add(task);}function finishWorkerTask(task){task.finish();WorkerTasks.delete(task);}function loadDocument(_x){return _loadDocument.apply(this,arguments);}function _loadDocument(){_loadDocument=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee2(recoveryMode){var isPureXfa,task,_yield$Promise$all,_yield$Promise$all2,numPages,fingerprints,htmlForXfa;return _regeneratorRuntime().wrap(function _callee2$(_context4){while(1)switch(_context4.prev=_context4.next){case 0:_context4.next=2;return pdfManager.ensureDoc("checkHeader");case 2:_context4.next=4;return pdfManager.ensureDoc("parseStartXRef");case 4:_context4.next=6;return pdfManager.ensureDoc("parse",[recoveryMode]);case 6:_context4.next=8;return pdfManager.ensureDoc("checkFirstPage",[recoveryMode]);case 8:_context4.next=10;return pdfManager.ensureDoc("checkLastPage",[recoveryMode]);case 10:_context4.next=12;return pdfManager.ensureDoc("isPureXfa");case 12:isPureXfa=_context4.sent;if(!isPureXfa){_context4.next=18;break;}task=new WorkerTask("loadXfaFonts");startWorkerTask(task);_context4.next=18;return Promise.all([pdfManager.loadXfaFonts(handler,task).catch(function(reason){}).then(function(){return finishWorkerTask(task);}),pdfManager.loadXfaImages()]);case 18:_context4.next=20;return Promise.all([pdfManager.ensureDoc("numPages"),pdfManager.ensureDoc("fingerprints")]);case 20:_yield$Promise$all=_context4.sent;_yield$Promise$all2=_slicedToArray(_yield$Promise$all,2);numPages=_yield$Promise$all2[0];fingerprints=_yield$Promise$all2[1];if(!isPureXfa){_context4.next=30;break;}_context4.next=27;return pdfManager.ensureDoc("htmlForXfa");case 27:_context4.t0=_context4.sent;_context4.next=31;break;case 30:_context4.t0=null;case 31:htmlForXfa=_context4.t0;return _context4.abrupt("return",{numPages:numPages,fingerprints:fingerprints,htmlForXfa:htmlForXfa});case 33:case"end":return _context4.stop();}},_callee2);}));return _loadDocument.apply(this,arguments);}function getPdfManager(_ref){var data=_ref.data,password=_ref.password,disableAutoFetch=_ref.disableAutoFetch,rangeChunkSize=_ref.rangeChunkSize,length=_ref.length,docBaseUrl=_ref.docBaseUrl,enableXfa=_ref.enableXfa,evaluatorOptions=_ref.evaluatorOptions;var pdfManagerArgs={source:null,disableAutoFetch:disableAutoFetch,docBaseUrl:docBaseUrl,docId:docId,enableXfa:enableXfa,evaluatorOptions:evaluatorOptions,handler:handler,length:length,password:password,rangeChunkSize:rangeChunkSize};var pdfManagerCapability=new _util.PromiseCapability();var newPdfManager;if(data){try{pdfManagerArgs.source=data;newPdfManager=new _pdf_manager.LocalPdfManager(pdfManagerArgs);pdfManagerCapability.resolve(newPdfManager);}catch(ex){pdfManagerCapability.reject(ex);}return pdfManagerCapability.promise;}var pdfStream,cachedChunks=[];try{pdfStream=new _worker_stream.PDFWorkerStream(handler);}catch(ex){pdfManagerCapability.reject(ex);return pdfManagerCapability.promise;}var fullRequest=pdfStream.getFullReader();fullRequest.headersReady.then(function(){if(!fullRequest.isRangeSupported){return;}pdfManagerArgs.source=pdfStream;pdfManagerArgs.length=fullRequest.contentLength;pdfManagerArgs.disableAutoFetch||(pdfManagerArgs.disableAutoFetch=fullRequest.isStreamingSupported);newPdfManager=new _pdf_manager.NetworkPdfManager(pdfManagerArgs);for(var _i=0,_cachedChunks=cachedChunks;_i<_cachedChunks.length;_i++){var chunk=_cachedChunks[_i];newPdfManager.sendProgressiveData(chunk);}cachedChunks=[];pdfManagerCapability.resolve(newPdfManager);cancelXHRs=null;}).catch(function(reason){pdfManagerCapability.reject(reason);cancelXHRs=null;});var loaded=0;var flushChunks=function flushChunks(){var pdfFile=(0,_core_utils.arrayBuffersToBytes)(cachedChunks);if(length&&pdfFile.length!==length){(0,_util.warn)("reported HTTP length is different from actual");}try{pdfManagerArgs.source=pdfFile;newPdfManager=new _pdf_manager.LocalPdfManager(pdfManagerArgs);pdfManagerCapability.resolve(newPdfManager);}catch(ex){pdfManagerCapability.reject(ex);}cachedChunks=[];};new Promise(function(resolve,reject){var readChunk=function readChunk(_ref2){var value=_ref2.value,done=_ref2.done;try{ensureNotTerminated();if(done){if(!newPdfManager){flushChunks();}cancelXHRs=null;return;}loaded+=value.byteLength;if(!fullRequest.isStreamingSupported){handler.send("DocProgress",{loaded:loaded,total:Math.max(loaded,fullRequest.contentLength||0)});}if(newPdfManager){newPdfManager.sendProgressiveData(value);}else{cachedChunks.push(value);}fullRequest.read().then(readChunk,reject);}catch(e){reject(e);}};fullRequest.read().then(readChunk,reject);}).catch(function(e){pdfManagerCapability.reject(e);cancelXHRs=null;});cancelXHRs=function cancelXHRs(reason){pdfStream.cancelAllRequests(reason);};return pdfManagerCapability.promise;}function setupDoc(data){function onSuccess(doc){ensureNotTerminated();handler.send("GetDoc",{pdfInfo:doc});}function onFailure(ex){ensureNotTerminated();if(ex instanceof _util.PasswordException){var task=new WorkerTask("PasswordException: response ".concat(ex.code));startWorkerTask(task);handler.sendWithPromise("PasswordRequest",ex).then(function(_ref3){var password=_ref3.password;finishWorkerTask(task);pdfManager.updatePassword(password);pdfManagerReady();}).catch(function(){finishWorkerTask(task);handler.send("DocException",ex);});}else if(ex instanceof _util.InvalidPDFException||ex instanceof _util.MissingPDFException||ex instanceof _util.UnexpectedResponseException||ex instanceof _util.UnknownErrorException){handler.send("DocException",ex);}else{handler.send("DocException",new _util.UnknownErrorException(ex.message,ex.toString()));}}function pdfManagerReady(){ensureNotTerminated();loadDocument(false).then(onSuccess,function(reason){ensureNotTerminated();if(!(reason instanceof _core_utils.XRefParseException)){onFailure(reason);return;}pdfManager.requestLoadedStream().then(function(){ensureNotTerminated();loadDocument(true).then(onSuccess,onFailure);});});}ensureNotTerminated();getPdfManager(data).then(function(newPdfManager){if(terminated){newPdfManager.terminate(new _util.AbortException("Worker was terminated."));throw new Error("Worker was terminated");}pdfManager=newPdfManager;pdfManager.requestLoadedStream(true).then(function(stream){handler.send("DataLoaded",{length:stream.bytes.byteLength});});}).then(pdfManagerReady,onFailure);}handler.on("GetPage",function(data){return pdfManager.getPage(data.pageIndex).then(function(page){return Promise.all([pdfManager.ensure(page,"rotate"),pdfManager.ensure(page,"ref"),pdfManager.ensure(page,"userUnit"),pdfManager.ensure(page,"view")]).then(function(_ref4){var _ref5=_slicedToArray(_ref4,4),rotate=_ref5[0],ref=_ref5[1],userUnit=_ref5[2],view=_ref5[3];return{rotate:rotate,ref:ref,userUnit:userUnit,view:view};});});});handler.on("GetPageIndex",function(data){var pageRef=_primitives.Ref.get(data.num,data.gen);return pdfManager.ensureCatalog("getPageIndex",[pageRef]);});handler.on("GetDestinations",function(data){return pdfManager.ensureCatalog("destinations");});handler.on("GetDestination",function(data){return pdfManager.ensureCatalog("getDestination",[data.id]);});handler.on("GetPageLabels",function(data){return pdfManager.ensureCatalog("pageLabels");});handler.on("GetPageLayout",function(data){return pdfManager.ensureCatalog("pageLayout");});handler.on("GetPageMode",function(data){return pdfManager.ensureCatalog("pageMode");});handler.on("GetViewerPreferences",function(data){return pdfManager.ensureCatalog("viewerPreferences");});handler.on("GetOpenAction",function(data){return pdfManager.ensureCatalog("openAction");});handler.on("GetAttachments",function(data){return pdfManager.ensureCatalog("attachments");});handler.on("GetDocJSActions",function(data){return pdfManager.ensureCatalog("jsActions");});handler.on("GetPageJSActions",function(_ref6){var pageIndex=_ref6.pageIndex;return pdfManager.getPage(pageIndex).then(function(page){return pdfManager.ensure(page,"jsActions");});});handler.on("GetOutline",function(data){return pdfManager.ensureCatalog("documentOutline");});handler.on("GetOptionalContentConfig",function(data){return pdfManager.ensureCatalog("optionalContentConfig");});handler.on("GetPermissions",function(data){return pdfManager.ensureCatalog("permissions");});handler.on("GetMetadata",function(data){return Promise.all([pdfManager.ensureDoc("documentInfo"),pdfManager.ensureCatalog("metadata")]);});handler.on("GetMarkInfo",function(data){return pdfManager.ensureCatalog("markInfo");});handler.on("GetData",function(data){return pdfManager.requestLoadedStream().then(function(stream){return stream.bytes;});});handler.on("GetAnnotations",function(_ref7){var pageIndex=_ref7.pageIndex,intent=_ref7.intent;return pdfManager.getPage(pageIndex).then(function(page){var task=new WorkerTask("GetAnnotations: page ".concat(pageIndex));startWorkerTask(task);return page.getAnnotationsData(handler,task,intent).then(function(data){finishWorkerTask(task);return data;},function(reason){finishWorkerTask(task);throw reason;});});});handler.on("GetFieldObjects",function(data){return pdfManager.ensureDoc("fieldObjects");});handler.on("HasJSActions",function(data){return pdfManager.ensureDoc("hasJSActions");});handler.on("GetCalculationOrderIds",function(data){return pdfManager.ensureDoc("calculationOrderIds");});handler.on("SaveDocument",/*#__PURE__*/function(){var _ref9=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee(_ref8){var isPureXfa,numPages,annotationStorage,filename,promises,newAnnotationsByPage,xref,imagePromises,_iterator,_step,_loop,_loop2,pageIndex;return _regeneratorRuntime().wrap(function _callee$(_context3){while(1)switch(_context3.prev=_context3.next){case 0:isPureXfa=_ref8.isPureXfa,numPages=_ref8.numPages,annotationStorage=_ref8.annotationStorage,filename=_ref8.filename;promises=[pdfManager.requestLoadedStream(),pdfManager.ensureCatalog("acroForm"),pdfManager.ensureCatalog("acroFormRef"),pdfManager.ensureDoc("startXRef"),pdfManager.ensureDoc("linearization")];newAnnotationsByPage=!isPureXfa?(0,_core_utils.getNewAnnotationsMap)(annotationStorage):null;_context3.next=5;return pdfManager.ensureDoc("xref");case 5:xref=_context3.sent;if(!newAnnotationsByPage){_context3.next=24;break;}imagePromises=_annotation.AnnotationFactory.generateImages(annotationStorage.values(),xref,pdfManager.evaluatorOptions.isOffscreenCanvasSupported);_iterator=_createForOfIteratorHelper(newAnnotationsByPage);_context3.prev=9;_loop=/*#__PURE__*/_regeneratorRuntime().mark(function _loop(){var _step$value,pageIndex,annotations;return _regeneratorRuntime().wrap(function _loop$(_context){while(1)switch(_context.prev=_context.next){case 0:_step$value=_slicedToArray(_step.value,2),pageIndex=_step$value[0],annotations=_step$value[1];promises.push(pdfManager.getPage(pageIndex).then(function(page){var task=new WorkerTask("Save (editor): page ".concat(pageIndex));return page.saveNewAnnotations(handler,task,annotations,imagePromises).finally(function(){finishWorkerTask(task);});}));case 2:case"end":return _context.stop();}},_loop);});_iterator.s();case 12:if((_step=_iterator.n()).done){_context3.next=16;break;}return _context3.delegateYield(_loop(),"t0",14);case 14:_context3.next=12;break;case 16:_context3.next=21;break;case 18:_context3.prev=18;_context3.t1=_context3["catch"](9);_iterator.e(_context3.t1);case 21:_context3.prev=21;_iterator.f();return _context3.finish(21);case 24:if(!isPureXfa){_context3.next=28;break;}promises.push(pdfManager.serializeXfaData(annotationStorage));_context3.next=35;break;case 28:_loop2=/*#__PURE__*/_regeneratorRuntime().mark(function _loop2(pageIndex){return _regeneratorRuntime().wrap(function _loop2$(_context2){while(1)switch(_context2.prev=_context2.next){case 0:promises.push(pdfManager.getPage(pageIndex).then(function(page){var task=new WorkerTask("Save: page ".concat(pageIndex));return page.save(handler,task,annotationStorage).finally(function(){finishWorkerTask(task);});}));case 1:case"end":return _context2.stop();}},_loop2);});pageIndex=0;case 30:if(!(pageIndex<numPages)){_context3.next=35;break;}return _context3.delegateYield(_loop2(pageIndex),"t2",32);case 32:pageIndex++;_context3.next=30;break;case 35:return _context3.abrupt("return",Promise.all(promises).then(function(_ref10){var _ref11=_toArray(_ref10),stream=_ref11[0],acroForm=_ref11[1],acroFormRef=_ref11[2],startXRef=_ref11[3],linearization=_ref11[4],refs=_ref11.slice(5);var newRefs=[];var xfaData=null;if(isPureXfa){xfaData=refs[0];if(!xfaData){return stream.bytes;}}else{newRefs=refs.flat(2);if(newRefs.length===0){return stream.bytes;}}var needAppearances=acroFormRef&&acroForm instanceof _primitives.Dict&&newRefs.some(function(ref){return ref.needAppearances;});var xfa=acroForm instanceof _primitives.Dict&&acroForm.get("XFA")||null;var xfaDatasetsRef=null;var hasXfaDatasetsEntry=false;if(Array.isArray(xfa)){for(var i=0,ii=xfa.length;i<ii;i+=2){if(xfa[i]==="datasets"){xfaDatasetsRef=xfa[i+1];hasXfaDatasetsEntry=true;}}if(xfaDatasetsRef===null){xfaDatasetsRef=xref.getNewTemporaryRef();}}else if(xfa){(0,_util.warn)("Unsupported XFA type.");}var newXrefInfo=Object.create(null);if(xref.trailer){var _xref$lastXRefStreamP;var infoObj=Object.create(null);var xrefInfo=xref.trailer.get("Info")||null;if(xrefInfo instanceof _primitives.Dict){xrefInfo.forEach(function(key,value){if(typeof value==="string"){infoObj[key]=(0,_util.stringToPDFString)(value);}});}newXrefInfo={rootRef:xref.trailer.getRaw("Root")||null,encryptRef:xref.trailer.getRaw("Encrypt")||null,newRef:xref.getNewTemporaryRef(),infoRef:xref.trailer.getRaw("Info")||null,info:infoObj,fileIds:xref.trailer.get("ID")||null,startXRef:linearization?startXRef:(_xref$lastXRefStreamP=xref.lastXRefStreamPos)!==null&&_xref$lastXRefStreamP!==void 0?_xref$lastXRefStreamP:startXRef,filename:filename};}return(0,_writer.incrementalUpdate)({originalData:stream.bytes,xrefInfo:newXrefInfo,newRefs:newRefs,xref:xref,hasXfa:!!xfa,xfaDatasetsRef:xfaDatasetsRef,hasXfaDatasetsEntry:hasXfaDatasetsEntry,needAppearances:needAppearances,acroFormRef:acroFormRef,acroForm:acroForm,xfaData:xfaData}).finally(function(){xref.resetNewTemporaryRef();});}));case 36:case"end":return _context3.stop();}},_callee,null,[[9,18,21,24]]);}));return function(_x2){return _ref9.apply(this,arguments);};}());handler.on("GetOperatorList",function(data,sink){var pageIndex=data.pageIndex;pdfManager.getPage(pageIndex).then(function(page){var task=new WorkerTask("GetOperatorList: page ".concat(pageIndex));startWorkerTask(task);var start=verbosity>=_util.VerbosityLevel.INFOS?Date.now():0;page.getOperatorList({handler:handler,sink:sink,task:task,intent:data.intent,cacheKey:data.cacheKey,annotationStorage:data.annotationStorage}).then(function(operatorListInfo){finishWorkerTask(task);if(start){(0,_util.info)("page=".concat(pageIndex+1," - getOperatorList: time=")+"".concat(Date.now()-start,"ms, len=").concat(operatorListInfo.length));}sink.close();},function(reason){finishWorkerTask(task);if(task.terminated){return;}sink.error(reason);});});});handler.on("GetTextContent",function(data,sink){var pageIndex=data.pageIndex,includeMarkedContent=data.includeMarkedContent,disableNormalization=data.disableNormalization;pdfManager.getPage(pageIndex).then(function(page){var task=new WorkerTask("GetTextContent: page "+pageIndex);startWorkerTask(task);var start=verbosity>=_util.VerbosityLevel.INFOS?Date.now():0;page.extractTextContent({handler:handler,task:task,sink:sink,includeMarkedContent:includeMarkedContent,disableNormalization:disableNormalization}).then(function(){finishWorkerTask(task);if(start){(0,_util.info)("page=".concat(pageIndex+1," - getTextContent: time=")+"".concat(Date.now()-start,"ms"));}sink.close();},function(reason){finishWorkerTask(task);if(task.terminated){return;}sink.error(reason);});});});handler.on("GetStructTree",function(data){return pdfManager.getPage(data.pageIndex).then(function(page){return pdfManager.ensure(page,"getStructTree");});});handler.on("FontFallback",function(data){return pdfManager.fontFallback(data.id,handler);});handler.on("Cleanup",function(data){return pdfManager.cleanup(true);});handler.on("Terminate",function(data){terminated=true;var waitOn=[];if(pdfManager){pdfManager.terminate(new _util.AbortException("Worker was terminated."));var cleanupPromise=pdfManager.cleanup();waitOn.push(cleanupPromise);pdfManager=null;}else{(0,_cleanup_helper.clearGlobalCaches)();}if(cancelXHRs){cancelXHRs(new _util.AbortException("Worker was terminated."));}var _iterator2=_createForOfIteratorHelper(WorkerTasks),_step2;try{for(_iterator2.s();!(_step2=_iterator2.n()).done;){var task=_step2.value;waitOn.push(task.finished);task.terminate();}}catch(err){_iterator2.e(err);}finally{_iterator2.f();}return Promise.all(waitOn).then(function(){handler.destroy();handler=null;});});handler.on("Ready",function(data){setupDoc(docParams);docParams=null;});handler.on("showUnverifiedSignatures",function wphReady(data){if(data){(0,_util.info)("showUnverifiedSignatures="+data+". This is an incompletely implemented feature. Signatures cannot be validated, so use it at own risk.");}self.showUnverifiedSignatures=data;});return workerHandlerName;}},{key:"initializeFromPort",value:function initializeFromPort(port){var handler=new _message_handler.MessageHandler("worker","main",port);WorkerMessageHandler.setup(handler,port);handler.send("ready",null);}}]);return WorkerMessageHandler;}();exports.WorkerMessageHandler=WorkerMessageHandler;function isMessagePort(maybePort){return typeof maybePort.postMessage==="function"&&"onmessage"in maybePort;}if(typeof window==="undefined"&&typeof self!=="undefined"&&isMessagePort(self)){WorkerMessageHandler.initializeFromPort(self);}

/***/ }),
/* 2 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var defineWellKnownSymbol = __w_pdfjs_require__(3);
var defineSymbolToPrimitive = __w_pdfjs_require__(43);
defineWellKnownSymbol('toPrimitive');
defineSymbolToPrimitive();

/***/ }),
/* 3 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var path = __w_pdfjs_require__(4);
var hasOwn = __w_pdfjs_require__(6);
var wrappedWellKnownSymbolModule = __w_pdfjs_require__(13);
var defineProperty = (__w_pdfjs_require__(24).f);
module.exports = function (NAME) {
 var Symbol = path.Symbol || (path.Symbol = {});
 if (!hasOwn(Symbol, NAME))
  defineProperty(Symbol, NAME, { value: wrappedWellKnownSymbolModule.f(NAME) });
};

/***/ }),
/* 4 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
module.exports = global;

/***/ }),
/* 5 */
/***/ (function(module) {


var check = function (it) {
 return it && it.Math == Math && it;
};
module.exports = check(typeof globalThis == 'object' && globalThis) || check(typeof window == 'object' && window) || check(typeof self == 'object' && self) || check(typeof global == 'object' && global) || (function () {
 return this;
}()) || this || Function('return this')();

/***/ }),
/* 6 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var toObject = __w_pdfjs_require__(10);
var hasOwnProperty = uncurryThis({}.hasOwnProperty);
module.exports = Object.hasOwn || function hasOwn(it, key) {
 return hasOwnProperty(toObject(it), key);
};

/***/ }),
/* 7 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var NATIVE_BIND = __w_pdfjs_require__(8);
var FunctionPrototype = Function.prototype;
var call = FunctionPrototype.call;
var uncurryThisWithBind = NATIVE_BIND && FunctionPrototype.bind.bind(call, call);
module.exports = NATIVE_BIND ? uncurryThisWithBind : function (fn) {
 return function () {
  return call.apply(fn, arguments);
 };
};

/***/ }),
/* 8 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var fails = __w_pdfjs_require__(9);
module.exports = !fails(function () {
 var test = function () {
 }.bind();
 return typeof test != 'function' || test.hasOwnProperty('prototype');
});

/***/ }),
/* 9 */
/***/ ((module) => {


module.exports = function (exec) {
 try {
  return !!exec();
 } catch (error) {
  return true;
 }
};

/***/ }),
/* 10 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var requireObjectCoercible = __w_pdfjs_require__(11);
var $Object = Object;
module.exports = function (argument) {
 return $Object(requireObjectCoercible(argument));
};

/***/ }),
/* 11 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var isNullOrUndefined = __w_pdfjs_require__(12);
var $TypeError = TypeError;
module.exports = function (it) {
 if (isNullOrUndefined(it))
  throw $TypeError("Can't call method on " + it);
 return it;
};

/***/ }),
/* 12 */
/***/ ((module) => {


module.exports = function (it) {
 return it === null || it === undefined;
};

/***/ }),
/* 13 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {


var wellKnownSymbol = __w_pdfjs_require__(14);
exports.f = wellKnownSymbol;

/***/ }),
/* 14 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var shared = __w_pdfjs_require__(15);
var hasOwn = __w_pdfjs_require__(6);
var uid = __w_pdfjs_require__(19);
var NATIVE_SYMBOL = __w_pdfjs_require__(20);
var USE_SYMBOL_AS_UID = __w_pdfjs_require__(23);
var Symbol = global.Symbol;
var WellKnownSymbolsStore = shared('wks');
var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol['for'] || Symbol : Symbol && Symbol.withoutSetter || uid;
module.exports = function (name) {
 if (!hasOwn(WellKnownSymbolsStore, name)) {
  WellKnownSymbolsStore[name] = NATIVE_SYMBOL && hasOwn(Symbol, name) ? Symbol[name] : createWellKnownSymbol('Symbol.' + name);
 }
 return WellKnownSymbolsStore[name];
};

/***/ }),
/* 15 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var IS_PURE = __w_pdfjs_require__(16);
var store = __w_pdfjs_require__(17);
(module.exports = function (key, value) {
 return store[key] || (store[key] = value !== undefined ? value : {});
})('versions', []).push({
 version: '3.32.0',
 mode: IS_PURE ? 'pure' : 'global',
 copyright: '© 2014-2023 Denis Pushkarev (zloirock.ru)',
 license: 'https://github.com/zloirock/core-js/blob/v3.32.0/LICENSE',
 source: 'https://github.com/zloirock/core-js'
});

/***/ }),
/* 16 */
/***/ ((module) => {


module.exports = false;

/***/ }),
/* 17 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var defineGlobalProperty = __w_pdfjs_require__(18);
var SHARED = '__core-js_shared__';
var store = global[SHARED] || defineGlobalProperty(SHARED, {});
module.exports = store;

/***/ }),
/* 18 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var defineProperty = Object.defineProperty;
module.exports = function (key, value) {
 try {
  defineProperty(global, key, {
   value: value,
   configurable: true,
   writable: true
  });
 } catch (error) {
  global[key] = value;
 }
 return value;
};

/***/ }),
/* 19 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var id = 0;
var postfix = Math.random();
var toString = uncurryThis(1.0.toString);
module.exports = function (key) {
 return 'Symbol(' + (key === undefined ? '' : key) + ')_' + toString(++id + postfix, 36);
};

/***/ }),
/* 20 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var V8_VERSION = __w_pdfjs_require__(21);
var fails = __w_pdfjs_require__(9);
var global = __w_pdfjs_require__(5);
var $String = global.String;
module.exports = !!Object.getOwnPropertySymbols && !fails(function () {
 var symbol = Symbol();
 return !$String(symbol) || !(Object(symbol) instanceof Symbol) || !Symbol.sham && V8_VERSION && V8_VERSION < 41;
});

/***/ }),
/* 21 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var userAgent = __w_pdfjs_require__(22);
var process = global.process;
var Deno = global.Deno;
var versions = process && process.versions || Deno && Deno.version;
var v8 = versions && versions.v8;
var match, version;
if (v8) {
 match = v8.split('.');
 version = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
}
if (!version && userAgent) {
 match = userAgent.match(/Edge\/(\d+)/);
 if (!match || match[1] >= 74) {
  match = userAgent.match(/Chrome\/(\d+)/);
  if (match)
   version = +match[1];
 }
}
module.exports = version;

/***/ }),
/* 22 */
/***/ ((module) => {


module.exports = typeof navigator != 'undefined' && String(navigator.userAgent) || '';

/***/ }),
/* 23 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var NATIVE_SYMBOL = __w_pdfjs_require__(20);
module.exports = NATIVE_SYMBOL && !Symbol.sham && typeof Symbol.iterator == 'symbol';

/***/ }),
/* 24 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {


var DESCRIPTORS = __w_pdfjs_require__(25);
var IE8_DOM_DEFINE = __w_pdfjs_require__(26);
var V8_PROTOTYPE_DEFINE_BUG = __w_pdfjs_require__(31);
var anObject = __w_pdfjs_require__(32);
var toPropertyKey = __w_pdfjs_require__(33);
var $TypeError = TypeError;
var $defineProperty = Object.defineProperty;
var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
var ENUMERABLE = 'enumerable';
var CONFIGURABLE = 'configurable';
var WRITABLE = 'writable';
exports.f = DESCRIPTORS ? V8_PROTOTYPE_DEFINE_BUG ? function defineProperty(O, P, Attributes) {
 anObject(O);
 P = toPropertyKey(P);
 anObject(Attributes);
 if (typeof O === 'function' && P === 'prototype' && 'value' in Attributes && WRITABLE in Attributes && !Attributes[WRITABLE]) {
  var current = $getOwnPropertyDescriptor(O, P);
  if (current && current[WRITABLE]) {
   O[P] = Attributes.value;
   Attributes = {
    configurable: CONFIGURABLE in Attributes ? Attributes[CONFIGURABLE] : current[CONFIGURABLE],
    enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
    writable: false
   };
  }
 }
 return $defineProperty(O, P, Attributes);
} : $defineProperty : function defineProperty(O, P, Attributes) {
 anObject(O);
 P = toPropertyKey(P);
 anObject(Attributes);
 if (IE8_DOM_DEFINE)
  try {
   return $defineProperty(O, P, Attributes);
  } catch (error) {
  }
 if ('get' in Attributes || 'set' in Attributes)
  throw $TypeError('Accessors not supported');
 if ('value' in Attributes)
  O[P] = Attributes.value;
 return O;
};

/***/ }),
/* 25 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var fails = __w_pdfjs_require__(9);
module.exports = !fails(function () {
 return Object.defineProperty({}, 1, {
  get: function () {
   return 7;
  }
 })[1] != 7;
});

/***/ }),
/* 26 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var DESCRIPTORS = __w_pdfjs_require__(25);
var fails = __w_pdfjs_require__(9);
var createElement = __w_pdfjs_require__(27);
module.exports = !DESCRIPTORS && !fails(function () {
 return Object.defineProperty(createElement('div'), 'a', {
  get: function () {
   return 7;
  }
 }).a != 7;
});

/***/ }),
/* 27 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var isObject = __w_pdfjs_require__(28);
var document = global.document;
var EXISTS = isObject(document) && isObject(document.createElement);
module.exports = function (it) {
 return EXISTS ? document.createElement(it) : {};
};

/***/ }),
/* 28 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var isCallable = __w_pdfjs_require__(29);
var $documentAll = __w_pdfjs_require__(30);
var documentAll = $documentAll.all;
module.exports = $documentAll.IS_HTMLDDA ? function (it) {
 return typeof it == 'object' ? it !== null : isCallable(it) || it === documentAll;
} : function (it) {
 return typeof it == 'object' ? it !== null : isCallable(it);
};

/***/ }),
/* 29 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $documentAll = __w_pdfjs_require__(30);
var documentAll = $documentAll.all;
module.exports = $documentAll.IS_HTMLDDA ? function (argument) {
 return typeof argument == 'function' || argument === documentAll;
} : function (argument) {
 return typeof argument == 'function';
};

/***/ }),
/* 30 */
/***/ ((module) => {


var documentAll = typeof document == 'object' && document.all;
var IS_HTMLDDA = typeof documentAll == 'undefined' && documentAll !== undefined;
module.exports = {
 all: documentAll,
 IS_HTMLDDA: IS_HTMLDDA
};

/***/ }),
/* 31 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var DESCRIPTORS = __w_pdfjs_require__(25);
var fails = __w_pdfjs_require__(9);
module.exports = DESCRIPTORS && fails(function () {
 return Object.defineProperty(function () {
 }, 'prototype', {
  value: 42,
  writable: false
 }).prototype != 42;
});

/***/ }),
/* 32 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var isObject = __w_pdfjs_require__(28);
var $String = String;
var $TypeError = TypeError;
module.exports = function (argument) {
 if (isObject(argument))
  return argument;
 throw $TypeError($String(argument) + ' is not an object');
};

/***/ }),
/* 33 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var toPrimitive = __w_pdfjs_require__(34);
var isSymbol = __w_pdfjs_require__(36);
module.exports = function (argument) {
 var key = toPrimitive(argument, 'string');
 return isSymbol(key) ? key : key + '';
};

/***/ }),
/* 34 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var call = __w_pdfjs_require__(35);
var isObject = __w_pdfjs_require__(28);
var isSymbol = __w_pdfjs_require__(36);
var getMethod = __w_pdfjs_require__(39);
var ordinaryToPrimitive = __w_pdfjs_require__(42);
var wellKnownSymbol = __w_pdfjs_require__(14);
var $TypeError = TypeError;
var TO_PRIMITIVE = wellKnownSymbol('toPrimitive');
module.exports = function (input, pref) {
 if (!isObject(input) || isSymbol(input))
  return input;
 var exoticToPrim = getMethod(input, TO_PRIMITIVE);
 var result;
 if (exoticToPrim) {
  if (pref === undefined)
   pref = 'default';
  result = call(exoticToPrim, input, pref);
  if (!isObject(result) || isSymbol(result))
   return result;
  throw $TypeError("Can't convert object to primitive value");
 }
 if (pref === undefined)
  pref = 'number';
 return ordinaryToPrimitive(input, pref);
};

/***/ }),
/* 35 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var NATIVE_BIND = __w_pdfjs_require__(8);
var call = Function.prototype.call;
module.exports = NATIVE_BIND ? call.bind(call) : function () {
 return call.apply(call, arguments);
};

/***/ }),
/* 36 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var getBuiltIn = __w_pdfjs_require__(37);
var isCallable = __w_pdfjs_require__(29);
var isPrototypeOf = __w_pdfjs_require__(38);
var USE_SYMBOL_AS_UID = __w_pdfjs_require__(23);
var $Object = Object;
module.exports = USE_SYMBOL_AS_UID ? function (it) {
 return typeof it == 'symbol';
} : function (it) {
 var $Symbol = getBuiltIn('Symbol');
 return isCallable($Symbol) && isPrototypeOf($Symbol.prototype, $Object(it));
};

/***/ }),
/* 37 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var isCallable = __w_pdfjs_require__(29);
var aFunction = function (argument) {
 return isCallable(argument) ? argument : undefined;
};
module.exports = function (namespace, method) {
 return arguments.length < 2 ? aFunction(global[namespace]) : global[namespace] && global[namespace][method];
};

/***/ }),
/* 38 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
module.exports = uncurryThis({}.isPrototypeOf);

/***/ }),
/* 39 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var aCallable = __w_pdfjs_require__(40);
var isNullOrUndefined = __w_pdfjs_require__(12);
module.exports = function (V, P) {
 var func = V[P];
 return isNullOrUndefined(func) ? undefined : aCallable(func);
};

/***/ }),
/* 40 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var isCallable = __w_pdfjs_require__(29);
var tryToString = __w_pdfjs_require__(41);
var $TypeError = TypeError;
module.exports = function (argument) {
 if (isCallable(argument))
  return argument;
 throw $TypeError(tryToString(argument) + ' is not a function');
};

/***/ }),
/* 41 */
/***/ ((module) => {


var $String = String;
module.exports = function (argument) {
 try {
  return $String(argument);
 } catch (error) {
  return 'Object';
 }
};

/***/ }),
/* 42 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var call = __w_pdfjs_require__(35);
var isCallable = __w_pdfjs_require__(29);
var isObject = __w_pdfjs_require__(28);
var $TypeError = TypeError;
module.exports = function (input, pref) {
 var fn, val;
 if (pref === 'string' && isCallable(fn = input.toString) && !isObject(val = call(fn, input)))
  return val;
 if (isCallable(fn = input.valueOf) && !isObject(val = call(fn, input)))
  return val;
 if (pref !== 'string' && isCallable(fn = input.toString) && !isObject(val = call(fn, input)))
  return val;
 throw $TypeError("Can't convert object to primitive value");
};

/***/ }),
/* 43 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var call = __w_pdfjs_require__(35);
var getBuiltIn = __w_pdfjs_require__(37);
var wellKnownSymbol = __w_pdfjs_require__(14);
var defineBuiltIn = __w_pdfjs_require__(44);
module.exports = function () {
 var Symbol = getBuiltIn('Symbol');
 var SymbolPrototype = Symbol && Symbol.prototype;
 var valueOf = SymbolPrototype && SymbolPrototype.valueOf;
 var TO_PRIMITIVE = wellKnownSymbol('toPrimitive');
 if (SymbolPrototype && !SymbolPrototype[TO_PRIMITIVE]) {
  defineBuiltIn(SymbolPrototype, TO_PRIMITIVE, function (hint) {
   return call(valueOf, this);
  }, { arity: 1 });
 }
};

/***/ }),
/* 44 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var isCallable = __w_pdfjs_require__(29);
var definePropertyModule = __w_pdfjs_require__(24);
var makeBuiltIn = __w_pdfjs_require__(45);
var defineGlobalProperty = __w_pdfjs_require__(18);
module.exports = function (O, key, value, options) {
 if (!options)
  options = {};
 var simple = options.enumerable;
 var name = options.name !== undefined ? options.name : key;
 if (isCallable(value))
  makeBuiltIn(value, name, options);
 if (options.global) {
  if (simple)
   O[key] = value;
  else
   defineGlobalProperty(key, value);
 } else {
  try {
   if (!options.unsafe)
    delete O[key];
   else if (O[key])
    simple = true;
  } catch (error) {
  }
  if (simple)
   O[key] = value;
  else
   definePropertyModule.f(O, key, {
    value: value,
    enumerable: false,
    configurable: !options.nonConfigurable,
    writable: !options.nonWritable
   });
 }
 return O;
};

/***/ }),
/* 45 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var fails = __w_pdfjs_require__(9);
var isCallable = __w_pdfjs_require__(29);
var hasOwn = __w_pdfjs_require__(6);
var DESCRIPTORS = __w_pdfjs_require__(25);
var CONFIGURABLE_FUNCTION_NAME = (__w_pdfjs_require__(46).CONFIGURABLE);
var inspectSource = __w_pdfjs_require__(47);
var InternalStateModule = __w_pdfjs_require__(48);
var enforceInternalState = InternalStateModule.enforce;
var getInternalState = InternalStateModule.get;
var $String = String;
var defineProperty = Object.defineProperty;
var stringSlice = uncurryThis(''.slice);
var replace = uncurryThis(''.replace);
var join = uncurryThis([].join);
var CONFIGURABLE_LENGTH = DESCRIPTORS && !fails(function () {
 return defineProperty(function () {
 }, 'length', { value: 8 }).length !== 8;
});
var TEMPLATE = String(String).split('String');
var makeBuiltIn = module.exports = function (value, name, options) {
 if (stringSlice($String(name), 0, 7) === 'Symbol(') {
  name = '[' + replace($String(name), /^Symbol\(([^)]*)\)/, '$1') + ']';
 }
 if (options && options.getter)
  name = 'get ' + name;
 if (options && options.setter)
  name = 'set ' + name;
 if (!hasOwn(value, 'name') || CONFIGURABLE_FUNCTION_NAME && value.name !== name) {
  if (DESCRIPTORS)
   defineProperty(value, 'name', {
    value: name,
    configurable: true
   });
  else
   value.name = name;
 }
 if (CONFIGURABLE_LENGTH && options && hasOwn(options, 'arity') && value.length !== options.arity) {
  defineProperty(value, 'length', { value: options.arity });
 }
 try {
  if (options && hasOwn(options, 'constructor') && options.constructor) {
   if (DESCRIPTORS)
    defineProperty(value, 'prototype', { writable: false });
  } else if (value.prototype)
   value.prototype = undefined;
 } catch (error) {
 }
 var state = enforceInternalState(value);
 if (!hasOwn(state, 'source')) {
  state.source = join(TEMPLATE, typeof name == 'string' ? name : '');
 }
 return value;
};
Function.prototype.toString = makeBuiltIn(function toString() {
 return isCallable(this) && getInternalState(this).source || inspectSource(this);
}, 'toString');

/***/ }),
/* 46 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var DESCRIPTORS = __w_pdfjs_require__(25);
var hasOwn = __w_pdfjs_require__(6);
var FunctionPrototype = Function.prototype;
var getDescriptor = DESCRIPTORS && Object.getOwnPropertyDescriptor;
var EXISTS = hasOwn(FunctionPrototype, 'name');
var PROPER = EXISTS && function something() {
}.name === 'something';
var CONFIGURABLE = EXISTS && (!DESCRIPTORS || DESCRIPTORS && getDescriptor(FunctionPrototype, 'name').configurable);
module.exports = {
 EXISTS: EXISTS,
 PROPER: PROPER,
 CONFIGURABLE: CONFIGURABLE
};

/***/ }),
/* 47 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var isCallable = __w_pdfjs_require__(29);
var store = __w_pdfjs_require__(17);
var functionToString = uncurryThis(Function.toString);
if (!isCallable(store.inspectSource)) {
 store.inspectSource = function (it) {
  return functionToString(it);
 };
}
module.exports = store.inspectSource;

/***/ }),
/* 48 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var NATIVE_WEAK_MAP = __w_pdfjs_require__(49);
var global = __w_pdfjs_require__(5);
var isObject = __w_pdfjs_require__(28);
var createNonEnumerableProperty = __w_pdfjs_require__(50);
var hasOwn = __w_pdfjs_require__(6);
var shared = __w_pdfjs_require__(17);
var sharedKey = __w_pdfjs_require__(52);
var hiddenKeys = __w_pdfjs_require__(53);
var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
var TypeError = global.TypeError;
var WeakMap = global.WeakMap;
var set, get, has;
var enforce = function (it) {
 return has(it) ? get(it) : set(it, {});
};
var getterFor = function (TYPE) {
 return function (it) {
  var state;
  if (!isObject(it) || (state = get(it)).type !== TYPE) {
   throw TypeError('Incompatible receiver, ' + TYPE + ' required');
  }
  return state;
 };
};
if (NATIVE_WEAK_MAP || shared.state) {
 var store = shared.state || (shared.state = new WeakMap());
 store.get = store.get;
 store.has = store.has;
 store.set = store.set;
 set = function (it, metadata) {
  if (store.has(it))
   throw TypeError(OBJECT_ALREADY_INITIALIZED);
  metadata.facade = it;
  store.set(it, metadata);
  return metadata;
 };
 get = function (it) {
  return store.get(it) || {};
 };
 has = function (it) {
  return store.has(it);
 };
} else {
 var STATE = sharedKey('state');
 hiddenKeys[STATE] = true;
 set = function (it, metadata) {
  if (hasOwn(it, STATE))
   throw TypeError(OBJECT_ALREADY_INITIALIZED);
  metadata.facade = it;
  createNonEnumerableProperty(it, STATE, metadata);
  return metadata;
 };
 get = function (it) {
  return hasOwn(it, STATE) ? it[STATE] : {};
 };
 has = function (it) {
  return hasOwn(it, STATE);
 };
}
module.exports = {
 set: set,
 get: get,
 has: has,
 enforce: enforce,
 getterFor: getterFor
};

/***/ }),
/* 49 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var isCallable = __w_pdfjs_require__(29);
var WeakMap = global.WeakMap;
module.exports = isCallable(WeakMap) && /native code/.test(String(WeakMap));

/***/ }),
/* 50 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var DESCRIPTORS = __w_pdfjs_require__(25);
var definePropertyModule = __w_pdfjs_require__(24);
var createPropertyDescriptor = __w_pdfjs_require__(51);
module.exports = DESCRIPTORS ? function (object, key, value) {
 return definePropertyModule.f(object, key, createPropertyDescriptor(1, value));
} : function (object, key, value) {
 object[key] = value;
 return object;
};

/***/ }),
/* 51 */
/***/ ((module) => {


module.exports = function (bitmap, value) {
 return {
  enumerable: !(bitmap & 1),
  configurable: !(bitmap & 2),
  writable: !(bitmap & 4),
  value: value
 };
};

/***/ }),
/* 52 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var shared = __w_pdfjs_require__(15);
var uid = __w_pdfjs_require__(19);
var keys = shared('keys');
module.exports = function (key) {
 return keys[key] || (keys[key] = uid(key));
};

/***/ }),
/* 53 */
/***/ ((module) => {


module.exports = {};

/***/ }),
/* 54 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var hasOwn = __w_pdfjs_require__(6);
var defineBuiltIn = __w_pdfjs_require__(44);
var dateToPrimitive = __w_pdfjs_require__(55);
var wellKnownSymbol = __w_pdfjs_require__(14);
var TO_PRIMITIVE = wellKnownSymbol('toPrimitive');
var DatePrototype = Date.prototype;
if (!hasOwn(DatePrototype, TO_PRIMITIVE)) {
 defineBuiltIn(DatePrototype, TO_PRIMITIVE, dateToPrimitive);
}

/***/ }),
/* 55 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var anObject = __w_pdfjs_require__(32);
var ordinaryToPrimitive = __w_pdfjs_require__(42);
var $TypeError = TypeError;
module.exports = function (hint) {
 anObject(this);
 if (hint === 'string' || hint === 'default')
  hint = 'string';
 else if (hint !== 'number')
  throw $TypeError('Incorrect hint');
 return ordinaryToPrimitive(this, hint);
};

/***/ }),
/* 56 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


__w_pdfjs_require__(57);
__w_pdfjs_require__(96);
__w_pdfjs_require__(98);
__w_pdfjs_require__(99);
__w_pdfjs_require__(103);

/***/ }),
/* 57 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var global = __w_pdfjs_require__(5);
var call = __w_pdfjs_require__(35);
var uncurryThis = __w_pdfjs_require__(7);
var IS_PURE = __w_pdfjs_require__(16);
var DESCRIPTORS = __w_pdfjs_require__(25);
var NATIVE_SYMBOL = __w_pdfjs_require__(20);
var fails = __w_pdfjs_require__(9);
var hasOwn = __w_pdfjs_require__(6);
var isPrototypeOf = __w_pdfjs_require__(38);
var anObject = __w_pdfjs_require__(32);
var toIndexedObject = __w_pdfjs_require__(61);
var toPropertyKey = __w_pdfjs_require__(33);
var $toString = __w_pdfjs_require__(77);
var createPropertyDescriptor = __w_pdfjs_require__(51);
var nativeObjectCreate = __w_pdfjs_require__(80);
var objectKeys = __w_pdfjs_require__(82);
var getOwnPropertyNamesModule = __w_pdfjs_require__(66);
var getOwnPropertyNamesExternal = __w_pdfjs_require__(84);
var getOwnPropertySymbolsModule = __w_pdfjs_require__(75);
var getOwnPropertyDescriptorModule = __w_pdfjs_require__(59);
var definePropertyModule = __w_pdfjs_require__(24);
var definePropertiesModule = __w_pdfjs_require__(81);
var propertyIsEnumerableModule = __w_pdfjs_require__(60);
var defineBuiltIn = __w_pdfjs_require__(44);
var defineBuiltInAccessor = __w_pdfjs_require__(87);
var shared = __w_pdfjs_require__(15);
var sharedKey = __w_pdfjs_require__(52);
var hiddenKeys = __w_pdfjs_require__(53);
var uid = __w_pdfjs_require__(19);
var wellKnownSymbol = __w_pdfjs_require__(14);
var wrappedWellKnownSymbolModule = __w_pdfjs_require__(13);
var defineWellKnownSymbol = __w_pdfjs_require__(3);
var defineSymbolToPrimitive = __w_pdfjs_require__(43);
var setToStringTag = __w_pdfjs_require__(88);
var InternalStateModule = __w_pdfjs_require__(48);
var $forEach = (__w_pdfjs_require__(89).forEach);
var HIDDEN = sharedKey('hidden');
var SYMBOL = 'Symbol';
var PROTOTYPE = 'prototype';
var setInternalState = InternalStateModule.set;
var getInternalState = InternalStateModule.getterFor(SYMBOL);
var ObjectPrototype = Object[PROTOTYPE];
var $Symbol = global.Symbol;
var SymbolPrototype = $Symbol && $Symbol[PROTOTYPE];
var TypeError = global.TypeError;
var QObject = global.QObject;
var nativeGetOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
var nativeDefineProperty = definePropertyModule.f;
var nativeGetOwnPropertyNames = getOwnPropertyNamesExternal.f;
var nativePropertyIsEnumerable = propertyIsEnumerableModule.f;
var push = uncurryThis([].push);
var AllSymbols = shared('symbols');
var ObjectPrototypeSymbols = shared('op-symbols');
var WellKnownSymbolsStore = shared('wks');
var USE_SETTER = !QObject || !QObject[PROTOTYPE] || !QObject[PROTOTYPE].findChild;
var setSymbolDescriptor = DESCRIPTORS && fails(function () {
 return nativeObjectCreate(nativeDefineProperty({}, 'a', {
  get: function () {
   return nativeDefineProperty(this, 'a', { value: 7 }).a;
  }
 })).a != 7;
}) ? function (O, P, Attributes) {
 var ObjectPrototypeDescriptor = nativeGetOwnPropertyDescriptor(ObjectPrototype, P);
 if (ObjectPrototypeDescriptor)
  delete ObjectPrototype[P];
 nativeDefineProperty(O, P, Attributes);
 if (ObjectPrototypeDescriptor && O !== ObjectPrototype) {
  nativeDefineProperty(ObjectPrototype, P, ObjectPrototypeDescriptor);
 }
} : nativeDefineProperty;
var wrap = function (tag, description) {
 var symbol = AllSymbols[tag] = nativeObjectCreate(SymbolPrototype);
 setInternalState(symbol, {
  type: SYMBOL,
  tag: tag,
  description: description
 });
 if (!DESCRIPTORS)
  symbol.description = description;
 return symbol;
};
var $defineProperty = function defineProperty(O, P, Attributes) {
 if (O === ObjectPrototype)
  $defineProperty(ObjectPrototypeSymbols, P, Attributes);
 anObject(O);
 var key = toPropertyKey(P);
 anObject(Attributes);
 if (hasOwn(AllSymbols, key)) {
  if (!Attributes.enumerable) {
   if (!hasOwn(O, HIDDEN))
    nativeDefineProperty(O, HIDDEN, createPropertyDescriptor(1, {}));
   O[HIDDEN][key] = true;
  } else {
   if (hasOwn(O, HIDDEN) && O[HIDDEN][key])
    O[HIDDEN][key] = false;
   Attributes = nativeObjectCreate(Attributes, { enumerable: createPropertyDescriptor(0, false) });
  }
  return setSymbolDescriptor(O, key, Attributes);
 }
 return nativeDefineProperty(O, key, Attributes);
};
var $defineProperties = function defineProperties(O, Properties) {
 anObject(O);
 var properties = toIndexedObject(Properties);
 var keys = objectKeys(properties).concat($getOwnPropertySymbols(properties));
 $forEach(keys, function (key) {
  if (!DESCRIPTORS || call($propertyIsEnumerable, properties, key))
   $defineProperty(O, key, properties[key]);
 });
 return O;
};
var $create = function create(O, Properties) {
 return Properties === undefined ? nativeObjectCreate(O) : $defineProperties(nativeObjectCreate(O), Properties);
};
var $propertyIsEnumerable = function propertyIsEnumerable(V) {
 var P = toPropertyKey(V);
 var enumerable = call(nativePropertyIsEnumerable, this, P);
 if (this === ObjectPrototype && hasOwn(AllSymbols, P) && !hasOwn(ObjectPrototypeSymbols, P))
  return false;
 return enumerable || !hasOwn(this, P) || !hasOwn(AllSymbols, P) || hasOwn(this, HIDDEN) && this[HIDDEN][P] ? enumerable : true;
};
var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(O, P) {
 var it = toIndexedObject(O);
 var key = toPropertyKey(P);
 if (it === ObjectPrototype && hasOwn(AllSymbols, key) && !hasOwn(ObjectPrototypeSymbols, key))
  return;
 var descriptor = nativeGetOwnPropertyDescriptor(it, key);
 if (descriptor && hasOwn(AllSymbols, key) && !(hasOwn(it, HIDDEN) && it[HIDDEN][key])) {
  descriptor.enumerable = true;
 }
 return descriptor;
};
var $getOwnPropertyNames = function getOwnPropertyNames(O) {
 var names = nativeGetOwnPropertyNames(toIndexedObject(O));
 var result = [];
 $forEach(names, function (key) {
  if (!hasOwn(AllSymbols, key) && !hasOwn(hiddenKeys, key))
   push(result, key);
 });
 return result;
};
var $getOwnPropertySymbols = function (O) {
 var IS_OBJECT_PROTOTYPE = O === ObjectPrototype;
 var names = nativeGetOwnPropertyNames(IS_OBJECT_PROTOTYPE ? ObjectPrototypeSymbols : toIndexedObject(O));
 var result = [];
 $forEach(names, function (key) {
  if (hasOwn(AllSymbols, key) && (!IS_OBJECT_PROTOTYPE || hasOwn(ObjectPrototype, key))) {
   push(result, AllSymbols[key]);
  }
 });
 return result;
};
if (!NATIVE_SYMBOL) {
 $Symbol = function Symbol() {
  if (isPrototypeOf(SymbolPrototype, this))
   throw TypeError('Symbol is not a constructor');
  var description = !arguments.length || arguments[0] === undefined ? undefined : $toString(arguments[0]);
  var tag = uid(description);
  var setter = function (value) {
   if (this === ObjectPrototype)
    call(setter, ObjectPrototypeSymbols, value);
   if (hasOwn(this, HIDDEN) && hasOwn(this[HIDDEN], tag))
    this[HIDDEN][tag] = false;
   setSymbolDescriptor(this, tag, createPropertyDescriptor(1, value));
  };
  if (DESCRIPTORS && USE_SETTER)
   setSymbolDescriptor(ObjectPrototype, tag, {
    configurable: true,
    set: setter
   });
  return wrap(tag, description);
 };
 SymbolPrototype = $Symbol[PROTOTYPE];
 defineBuiltIn(SymbolPrototype, 'toString', function toString() {
  return getInternalState(this).tag;
 });
 defineBuiltIn($Symbol, 'withoutSetter', function (description) {
  return wrap(uid(description), description);
 });
 propertyIsEnumerableModule.f = $propertyIsEnumerable;
 definePropertyModule.f = $defineProperty;
 definePropertiesModule.f = $defineProperties;
 getOwnPropertyDescriptorModule.f = $getOwnPropertyDescriptor;
 getOwnPropertyNamesModule.f = getOwnPropertyNamesExternal.f = $getOwnPropertyNames;
 getOwnPropertySymbolsModule.f = $getOwnPropertySymbols;
 wrappedWellKnownSymbolModule.f = function (name) {
  return wrap(wellKnownSymbol(name), name);
 };
 if (DESCRIPTORS) {
  defineBuiltInAccessor(SymbolPrototype, 'description', {
   configurable: true,
   get: function description() {
    return getInternalState(this).description;
   }
  });
  if (!IS_PURE) {
   defineBuiltIn(ObjectPrototype, 'propertyIsEnumerable', $propertyIsEnumerable, { unsafe: true });
  }
 }
}
$({
 global: true,
 constructor: true,
 wrap: true,
 forced: !NATIVE_SYMBOL,
 sham: !NATIVE_SYMBOL
}, { Symbol: $Symbol });
$forEach(objectKeys(WellKnownSymbolsStore), function (name) {
 defineWellKnownSymbol(name);
});
$({
 target: SYMBOL,
 stat: true,
 forced: !NATIVE_SYMBOL
}, {
 useSetter: function () {
  USE_SETTER = true;
 },
 useSimple: function () {
  USE_SETTER = false;
 }
});
$({
 target: 'Object',
 stat: true,
 forced: !NATIVE_SYMBOL,
 sham: !DESCRIPTORS
}, {
 create: $create,
 defineProperty: $defineProperty,
 defineProperties: $defineProperties,
 getOwnPropertyDescriptor: $getOwnPropertyDescriptor
});
$({
 target: 'Object',
 stat: true,
 forced: !NATIVE_SYMBOL
}, { getOwnPropertyNames: $getOwnPropertyNames });
defineSymbolToPrimitive();
setToStringTag($Symbol, SYMBOL);
hiddenKeys[HIDDEN] = true;

/***/ }),
/* 58 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var getOwnPropertyDescriptor = (__w_pdfjs_require__(59).f);
var createNonEnumerableProperty = __w_pdfjs_require__(50);
var defineBuiltIn = __w_pdfjs_require__(44);
var defineGlobalProperty = __w_pdfjs_require__(18);
var copyConstructorProperties = __w_pdfjs_require__(64);
var isForced = __w_pdfjs_require__(76);
module.exports = function (options, source) {
 var TARGET = options.target;
 var GLOBAL = options.global;
 var STATIC = options.stat;
 var FORCED, target, key, targetProperty, sourceProperty, descriptor;
 if (GLOBAL) {
  target = global;
 } else if (STATIC) {
  target = global[TARGET] || defineGlobalProperty(TARGET, {});
 } else {
  target = (global[TARGET] || {}).prototype;
 }
 if (target)
  for (key in source) {
   sourceProperty = source[key];
   if (options.dontCallGetSet) {
    descriptor = getOwnPropertyDescriptor(target, key);
    targetProperty = descriptor && descriptor.value;
   } else
    targetProperty = target[key];
   FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
   if (!FORCED && targetProperty !== undefined) {
    if (typeof sourceProperty == typeof targetProperty)
     continue;
    copyConstructorProperties(sourceProperty, targetProperty);
   }
   if (options.sham || targetProperty && targetProperty.sham) {
    createNonEnumerableProperty(sourceProperty, 'sham', true);
   }
   defineBuiltIn(target, key, sourceProperty, options);
  }
};

/***/ }),
/* 59 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {


var DESCRIPTORS = __w_pdfjs_require__(25);
var call = __w_pdfjs_require__(35);
var propertyIsEnumerableModule = __w_pdfjs_require__(60);
var createPropertyDescriptor = __w_pdfjs_require__(51);
var toIndexedObject = __w_pdfjs_require__(61);
var toPropertyKey = __w_pdfjs_require__(33);
var hasOwn = __w_pdfjs_require__(6);
var IE8_DOM_DEFINE = __w_pdfjs_require__(26);
var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
exports.f = DESCRIPTORS ? $getOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
 O = toIndexedObject(O);
 P = toPropertyKey(P);
 if (IE8_DOM_DEFINE)
  try {
   return $getOwnPropertyDescriptor(O, P);
  } catch (error) {
  }
 if (hasOwn(O, P))
  return createPropertyDescriptor(!call(propertyIsEnumerableModule.f, O, P), O[P]);
};

/***/ }),
/* 60 */
/***/ ((__unused_webpack_module, exports) => {


var $propertyIsEnumerable = {}.propertyIsEnumerable;
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
var NASHORN_BUG = getOwnPropertyDescriptor && !$propertyIsEnumerable.call({ 1: 2 }, 1);
exports.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
 var descriptor = getOwnPropertyDescriptor(this, V);
 return !!descriptor && descriptor.enumerable;
} : $propertyIsEnumerable;

/***/ }),
/* 61 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var IndexedObject = __w_pdfjs_require__(62);
var requireObjectCoercible = __w_pdfjs_require__(11);
module.exports = function (it) {
 return IndexedObject(requireObjectCoercible(it));
};

/***/ }),
/* 62 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var fails = __w_pdfjs_require__(9);
var classof = __w_pdfjs_require__(63);
var $Object = Object;
var split = uncurryThis(''.split);
module.exports = fails(function () {
 return !$Object('z').propertyIsEnumerable(0);
}) ? function (it) {
 return classof(it) == 'String' ? split(it, '') : $Object(it);
} : $Object;

/***/ }),
/* 63 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var toString = uncurryThis({}.toString);
var stringSlice = uncurryThis(''.slice);
module.exports = function (it) {
 return stringSlice(toString(it), 8, -1);
};

/***/ }),
/* 64 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var hasOwn = __w_pdfjs_require__(6);
var ownKeys = __w_pdfjs_require__(65);
var getOwnPropertyDescriptorModule = __w_pdfjs_require__(59);
var definePropertyModule = __w_pdfjs_require__(24);
module.exports = function (target, source, exceptions) {
 var keys = ownKeys(source);
 var defineProperty = definePropertyModule.f;
 var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
 for (var i = 0; i < keys.length; i++) {
  var key = keys[i];
  if (!hasOwn(target, key) && !(exceptions && hasOwn(exceptions, key))) {
   defineProperty(target, key, getOwnPropertyDescriptor(source, key));
  }
 }
};

/***/ }),
/* 65 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var getBuiltIn = __w_pdfjs_require__(37);
var uncurryThis = __w_pdfjs_require__(7);
var getOwnPropertyNamesModule = __w_pdfjs_require__(66);
var getOwnPropertySymbolsModule = __w_pdfjs_require__(75);
var anObject = __w_pdfjs_require__(32);
var concat = uncurryThis([].concat);
module.exports = getBuiltIn('Reflect', 'ownKeys') || function ownKeys(it) {
 var keys = getOwnPropertyNamesModule.f(anObject(it));
 var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
 return getOwnPropertySymbols ? concat(keys, getOwnPropertySymbols(it)) : keys;
};

/***/ }),
/* 66 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {


var internalObjectKeys = __w_pdfjs_require__(67);
var enumBugKeys = __w_pdfjs_require__(74);
var hiddenKeys = enumBugKeys.concat('length', 'prototype');
exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
 return internalObjectKeys(O, hiddenKeys);
};

/***/ }),
/* 67 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var hasOwn = __w_pdfjs_require__(6);
var toIndexedObject = __w_pdfjs_require__(61);
var indexOf = (__w_pdfjs_require__(68).indexOf);
var hiddenKeys = __w_pdfjs_require__(53);
var push = uncurryThis([].push);
module.exports = function (object, names) {
 var O = toIndexedObject(object);
 var i = 0;
 var result = [];
 var key;
 for (key in O)
  !hasOwn(hiddenKeys, key) && hasOwn(O, key) && push(result, key);
 while (names.length > i)
  if (hasOwn(O, key = names[i++])) {
   ~indexOf(result, key) || push(result, key);
  }
 return result;
};

/***/ }),
/* 68 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var toIndexedObject = __w_pdfjs_require__(61);
var toAbsoluteIndex = __w_pdfjs_require__(69);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var createMethod = function (IS_INCLUDES) {
 return function ($this, el, fromIndex) {
  var O = toIndexedObject($this);
  var length = lengthOfArrayLike(O);
  var index = toAbsoluteIndex(fromIndex, length);
  var value;
  if (IS_INCLUDES && el != el)
   while (length > index) {
    value = O[index++];
    if (value != value)
     return true;
   }
  else
   for (; length > index; index++) {
    if ((IS_INCLUDES || index in O) && O[index] === el)
     return IS_INCLUDES || index || 0;
   }
  return !IS_INCLUDES && -1;
 };
};
module.exports = {
 includes: createMethod(true),
 indexOf: createMethod(false)
};

/***/ }),
/* 69 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var toIntegerOrInfinity = __w_pdfjs_require__(70);
var max = Math.max;
var min = Math.min;
module.exports = function (index, length) {
 var integer = toIntegerOrInfinity(index);
 return integer < 0 ? max(integer + length, 0) : min(integer, length);
};

/***/ }),
/* 70 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var trunc = __w_pdfjs_require__(71);
module.exports = function (argument) {
 var number = +argument;
 return number !== number || number === 0 ? 0 : trunc(number);
};

/***/ }),
/* 71 */
/***/ ((module) => {


var ceil = Math.ceil;
var floor = Math.floor;
module.exports = Math.trunc || function trunc(x) {
 var n = +x;
 return (n > 0 ? floor : ceil)(n);
};

/***/ }),
/* 72 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var toLength = __w_pdfjs_require__(73);
module.exports = function (obj) {
 return toLength(obj.length);
};

/***/ }),
/* 73 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var toIntegerOrInfinity = __w_pdfjs_require__(70);
var min = Math.min;
module.exports = function (argument) {
 return argument > 0 ? min(toIntegerOrInfinity(argument), 0x1FFFFFFFFFFFFF) : 0;
};

/***/ }),
/* 74 */
/***/ ((module) => {


module.exports = [
 'constructor',
 'hasOwnProperty',
 'isPrototypeOf',
 'propertyIsEnumerable',
 'toLocaleString',
 'toString',
 'valueOf'
];

/***/ }),
/* 75 */
/***/ ((__unused_webpack_module, exports) => {


exports.f = Object.getOwnPropertySymbols;

/***/ }),
/* 76 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var fails = __w_pdfjs_require__(9);
var isCallable = __w_pdfjs_require__(29);
var replacement = /#|\.prototype\./;
var isForced = function (feature, detection) {
 var value = data[normalize(feature)];
 return value == POLYFILL ? true : value == NATIVE ? false : isCallable(detection) ? fails(detection) : !!detection;
};
var normalize = isForced.normalize = function (string) {
 return String(string).replace(replacement, '.').toLowerCase();
};
var data = isForced.data = {};
var NATIVE = isForced.NATIVE = 'N';
var POLYFILL = isForced.POLYFILL = 'P';
module.exports = isForced;

/***/ }),
/* 77 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var classof = __w_pdfjs_require__(78);
var $String = String;
module.exports = function (argument) {
 if (classof(argument) === 'Symbol')
  throw TypeError('Cannot convert a Symbol value to a string');
 return $String(argument);
};

/***/ }),
/* 78 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var TO_STRING_TAG_SUPPORT = __w_pdfjs_require__(79);
var isCallable = __w_pdfjs_require__(29);
var classofRaw = __w_pdfjs_require__(63);
var wellKnownSymbol = __w_pdfjs_require__(14);
var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var $Object = Object;
var CORRECT_ARGUMENTS = classofRaw((function () {
 return arguments;
}())) == 'Arguments';
var tryGet = function (it, key) {
 try {
  return it[key];
 } catch (error) {
 }
};
module.exports = TO_STRING_TAG_SUPPORT ? classofRaw : function (it) {
 var O, tag, result;
 return it === undefined ? 'Undefined' : it === null ? 'Null' : typeof (tag = tryGet(O = $Object(it), TO_STRING_TAG)) == 'string' ? tag : CORRECT_ARGUMENTS ? classofRaw(O) : (result = classofRaw(O)) == 'Object' && isCallable(O.callee) ? 'Arguments' : result;
};

/***/ }),
/* 79 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var wellKnownSymbol = __w_pdfjs_require__(14);
var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var test = {};
test[TO_STRING_TAG] = 'z';
module.exports = String(test) === '[object z]';

/***/ }),
/* 80 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var anObject = __w_pdfjs_require__(32);
var definePropertiesModule = __w_pdfjs_require__(81);
var enumBugKeys = __w_pdfjs_require__(74);
var hiddenKeys = __w_pdfjs_require__(53);
var html = __w_pdfjs_require__(83);
var documentCreateElement = __w_pdfjs_require__(27);
var sharedKey = __w_pdfjs_require__(52);
var GT = '>';
var LT = '<';
var PROTOTYPE = 'prototype';
var SCRIPT = 'script';
var IE_PROTO = sharedKey('IE_PROTO');
var EmptyConstructor = function () {
};
var scriptTag = function (content) {
 return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
};
var NullProtoObjectViaActiveX = function (activeXDocument) {
 activeXDocument.write(scriptTag(''));
 activeXDocument.close();
 var temp = activeXDocument.parentWindow.Object;
 activeXDocument = null;
 return temp;
};
var NullProtoObjectViaIFrame = function () {
 var iframe = documentCreateElement('iframe');
 var JS = 'java' + SCRIPT + ':';
 var iframeDocument;
 iframe.style.display = 'none';
 html.appendChild(iframe);
 iframe.src = String(JS);
 iframeDocument = iframe.contentWindow.document;
 iframeDocument.open();
 iframeDocument.write(scriptTag('document.F=Object'));
 iframeDocument.close();
 return iframeDocument.F;
};
var activeXDocument;
var NullProtoObject = function () {
 try {
  activeXDocument = new ActiveXObject('htmlfile');
 } catch (error) {
 }
 NullProtoObject = typeof document != 'undefined' ? document.domain && activeXDocument ? NullProtoObjectViaActiveX(activeXDocument) : NullProtoObjectViaIFrame() : NullProtoObjectViaActiveX(activeXDocument);
 var length = enumBugKeys.length;
 while (length--)
  delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];
 return NullProtoObject();
};
hiddenKeys[IE_PROTO] = true;
module.exports = Object.create || function create(O, Properties) {
 var result;
 if (O !== null) {
  EmptyConstructor[PROTOTYPE] = anObject(O);
  result = new EmptyConstructor();
  EmptyConstructor[PROTOTYPE] = null;
  result[IE_PROTO] = O;
 } else
  result = NullProtoObject();
 return Properties === undefined ? result : definePropertiesModule.f(result, Properties);
};

/***/ }),
/* 81 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {


var DESCRIPTORS = __w_pdfjs_require__(25);
var V8_PROTOTYPE_DEFINE_BUG = __w_pdfjs_require__(31);
var definePropertyModule = __w_pdfjs_require__(24);
var anObject = __w_pdfjs_require__(32);
var toIndexedObject = __w_pdfjs_require__(61);
var objectKeys = __w_pdfjs_require__(82);
exports.f = DESCRIPTORS && !V8_PROTOTYPE_DEFINE_BUG ? Object.defineProperties : function defineProperties(O, Properties) {
 anObject(O);
 var props = toIndexedObject(Properties);
 var keys = objectKeys(Properties);
 var length = keys.length;
 var index = 0;
 var key;
 while (length > index)
  definePropertyModule.f(O, key = keys[index++], props[key]);
 return O;
};

/***/ }),
/* 82 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var internalObjectKeys = __w_pdfjs_require__(67);
var enumBugKeys = __w_pdfjs_require__(74);
module.exports = Object.keys || function keys(O) {
 return internalObjectKeys(O, enumBugKeys);
};

/***/ }),
/* 83 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var getBuiltIn = __w_pdfjs_require__(37);
module.exports = getBuiltIn('document', 'documentElement');

/***/ }),
/* 84 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var classof = __w_pdfjs_require__(63);
var toIndexedObject = __w_pdfjs_require__(61);
var $getOwnPropertyNames = (__w_pdfjs_require__(66).f);
var arraySlice = __w_pdfjs_require__(85);
var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames ? Object.getOwnPropertyNames(window) : [];
var getWindowNames = function (it) {
 try {
  return $getOwnPropertyNames(it);
 } catch (error) {
  return arraySlice(windowNames);
 }
};
module.exports.f = function getOwnPropertyNames(it) {
 return windowNames && classof(it) == 'Window' ? getWindowNames(it) : $getOwnPropertyNames(toIndexedObject(it));
};

/***/ }),
/* 85 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var toAbsoluteIndex = __w_pdfjs_require__(69);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var createProperty = __w_pdfjs_require__(86);
var $Array = Array;
var max = Math.max;
module.exports = function (O, start, end) {
 var length = lengthOfArrayLike(O);
 var k = toAbsoluteIndex(start, length);
 var fin = toAbsoluteIndex(end === undefined ? length : end, length);
 var result = $Array(max(fin - k, 0));
 for (var n = 0; k < fin; k++, n++)
  createProperty(result, n, O[k]);
 result.length = n;
 return result;
};

/***/ }),
/* 86 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var toPropertyKey = __w_pdfjs_require__(33);
var definePropertyModule = __w_pdfjs_require__(24);
var createPropertyDescriptor = __w_pdfjs_require__(51);
module.exports = function (object, key, value) {
 var propertyKey = toPropertyKey(key);
 if (propertyKey in object)
  definePropertyModule.f(object, propertyKey, createPropertyDescriptor(0, value));
 else
  object[propertyKey] = value;
};

/***/ }),
/* 87 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var makeBuiltIn = __w_pdfjs_require__(45);
var defineProperty = __w_pdfjs_require__(24);
module.exports = function (target, name, descriptor) {
 if (descriptor.get)
  makeBuiltIn(descriptor.get, name, { getter: true });
 if (descriptor.set)
  makeBuiltIn(descriptor.set, name, { setter: true });
 return defineProperty.f(target, name, descriptor);
};

/***/ }),
/* 88 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var defineProperty = (__w_pdfjs_require__(24).f);
var hasOwn = __w_pdfjs_require__(6);
var wellKnownSymbol = __w_pdfjs_require__(14);
var TO_STRING_TAG = wellKnownSymbol('toStringTag');
module.exports = function (target, TAG, STATIC) {
 if (target && !STATIC)
  target = target.prototype;
 if (target && !hasOwn(target, TO_STRING_TAG)) {
  defineProperty(target, TO_STRING_TAG, {
   configurable: true,
   value: TAG
  });
 }
};

/***/ }),
/* 89 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var bind = __w_pdfjs_require__(90);
var uncurryThis = __w_pdfjs_require__(7);
var IndexedObject = __w_pdfjs_require__(62);
var toObject = __w_pdfjs_require__(10);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var arraySpeciesCreate = __w_pdfjs_require__(92);
var push = uncurryThis([].push);
var createMethod = function (TYPE) {
 var IS_MAP = TYPE == 1;
 var IS_FILTER = TYPE == 2;
 var IS_SOME = TYPE == 3;
 var IS_EVERY = TYPE == 4;
 var IS_FIND_INDEX = TYPE == 6;
 var IS_FILTER_REJECT = TYPE == 7;
 var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
 return function ($this, callbackfn, that, specificCreate) {
  var O = toObject($this);
  var self = IndexedObject(O);
  var boundFunction = bind(callbackfn, that);
  var length = lengthOfArrayLike(self);
  var index = 0;
  var create = specificCreate || arraySpeciesCreate;
  var target = IS_MAP ? create($this, length) : IS_FILTER || IS_FILTER_REJECT ? create($this, 0) : undefined;
  var value, result;
  for (; length > index; index++)
   if (NO_HOLES || index in self) {
    value = self[index];
    result = boundFunction(value, index, O);
    if (TYPE) {
     if (IS_MAP)
      target[index] = result;
     else if (result)
      switch (TYPE) {
      case 3:
       return true;
      case 5:
       return value;
      case 6:
       return index;
      case 2:
       push(target, value);
      }
     else
      switch (TYPE) {
      case 4:
       return false;
      case 7:
       push(target, value);
      }
    }
   }
  return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
 };
};
module.exports = {
 forEach: createMethod(0),
 map: createMethod(1),
 filter: createMethod(2),
 some: createMethod(3),
 every: createMethod(4),
 find: createMethod(5),
 findIndex: createMethod(6),
 filterReject: createMethod(7)
};

/***/ }),
/* 90 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(91);
var aCallable = __w_pdfjs_require__(40);
var NATIVE_BIND = __w_pdfjs_require__(8);
var bind = uncurryThis(uncurryThis.bind);
module.exports = function (fn, that) {
 aCallable(fn);
 return that === undefined ? fn : NATIVE_BIND ? bind(fn, that) : function () {
  return fn.apply(that, arguments);
 };
};

/***/ }),
/* 91 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var classofRaw = __w_pdfjs_require__(63);
var uncurryThis = __w_pdfjs_require__(7);
module.exports = function (fn) {
 if (classofRaw(fn) === 'Function')
  return uncurryThis(fn);
};

/***/ }),
/* 92 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var arraySpeciesConstructor = __w_pdfjs_require__(93);
module.exports = function (originalArray, length) {
 return new (arraySpeciesConstructor(originalArray))(length === 0 ? 0 : length);
};

/***/ }),
/* 93 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var isArray = __w_pdfjs_require__(94);
var isConstructor = __w_pdfjs_require__(95);
var isObject = __w_pdfjs_require__(28);
var wellKnownSymbol = __w_pdfjs_require__(14);
var SPECIES = wellKnownSymbol('species');
var $Array = Array;
module.exports = function (originalArray) {
 var C;
 if (isArray(originalArray)) {
  C = originalArray.constructor;
  if (isConstructor(C) && (C === $Array || isArray(C.prototype)))
   C = undefined;
  else if (isObject(C)) {
   C = C[SPECIES];
   if (C === null)
    C = undefined;
  }
 }
 return C === undefined ? $Array : C;
};

/***/ }),
/* 94 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var classof = __w_pdfjs_require__(63);
module.exports = Array.isArray || function isArray(argument) {
 return classof(argument) == 'Array';
};

/***/ }),
/* 95 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var fails = __w_pdfjs_require__(9);
var isCallable = __w_pdfjs_require__(29);
var classof = __w_pdfjs_require__(78);
var getBuiltIn = __w_pdfjs_require__(37);
var inspectSource = __w_pdfjs_require__(47);
var noop = function () {
};
var empty = [];
var construct = getBuiltIn('Reflect', 'construct');
var constructorRegExp = /^\s*(?:class|function)\b/;
var exec = uncurryThis(constructorRegExp.exec);
var INCORRECT_TO_STRING = !constructorRegExp.exec(noop);
var isConstructorModern = function isConstructor(argument) {
 if (!isCallable(argument))
  return false;
 try {
  construct(noop, empty, argument);
  return true;
 } catch (error) {
  return false;
 }
};
var isConstructorLegacy = function isConstructor(argument) {
 if (!isCallable(argument))
  return false;
 switch (classof(argument)) {
 case 'AsyncFunction':
 case 'GeneratorFunction':
 case 'AsyncGeneratorFunction':
  return false;
 }
 try {
  return INCORRECT_TO_STRING || !!exec(constructorRegExp, inspectSource(argument));
 } catch (error) {
  return true;
 }
};
isConstructorLegacy.sham = true;
module.exports = !construct || fails(function () {
 var called;
 return isConstructorModern(isConstructorModern.call) || !isConstructorModern(Object) || !isConstructorModern(function () {
  called = true;
 }) || called;
}) ? isConstructorLegacy : isConstructorModern;

/***/ }),
/* 96 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var getBuiltIn = __w_pdfjs_require__(37);
var hasOwn = __w_pdfjs_require__(6);
var toString = __w_pdfjs_require__(77);
var shared = __w_pdfjs_require__(15);
var NATIVE_SYMBOL_REGISTRY = __w_pdfjs_require__(97);
var StringToSymbolRegistry = shared('string-to-symbol-registry');
var SymbolToStringRegistry = shared('symbol-to-string-registry');
$({
 target: 'Symbol',
 stat: true,
 forced: !NATIVE_SYMBOL_REGISTRY
}, {
 'for': function (key) {
  var string = toString(key);
  if (hasOwn(StringToSymbolRegistry, string))
   return StringToSymbolRegistry[string];
  var symbol = getBuiltIn('Symbol')(string);
  StringToSymbolRegistry[string] = symbol;
  SymbolToStringRegistry[symbol] = string;
  return symbol;
 }
});

/***/ }),
/* 97 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var NATIVE_SYMBOL = __w_pdfjs_require__(20);
module.exports = NATIVE_SYMBOL && !!Symbol['for'] && !!Symbol.keyFor;

/***/ }),
/* 98 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var hasOwn = __w_pdfjs_require__(6);
var isSymbol = __w_pdfjs_require__(36);
var tryToString = __w_pdfjs_require__(41);
var shared = __w_pdfjs_require__(15);
var NATIVE_SYMBOL_REGISTRY = __w_pdfjs_require__(97);
var SymbolToStringRegistry = shared('symbol-to-string-registry');
$({
 target: 'Symbol',
 stat: true,
 forced: !NATIVE_SYMBOL_REGISTRY
}, {
 keyFor: function keyFor(sym) {
  if (!isSymbol(sym))
   throw TypeError(tryToString(sym) + ' is not a symbol');
  if (hasOwn(SymbolToStringRegistry, sym))
   return SymbolToStringRegistry[sym];
 }
});

/***/ }),
/* 99 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var getBuiltIn = __w_pdfjs_require__(37);
var apply = __w_pdfjs_require__(100);
var call = __w_pdfjs_require__(35);
var uncurryThis = __w_pdfjs_require__(7);
var fails = __w_pdfjs_require__(9);
var isCallable = __w_pdfjs_require__(29);
var isSymbol = __w_pdfjs_require__(36);
var arraySlice = __w_pdfjs_require__(101);
var getReplacerFunction = __w_pdfjs_require__(102);
var NATIVE_SYMBOL = __w_pdfjs_require__(20);
var $String = String;
var $stringify = getBuiltIn('JSON', 'stringify');
var exec = uncurryThis(/./.exec);
var charAt = uncurryThis(''.charAt);
var charCodeAt = uncurryThis(''.charCodeAt);
var replace = uncurryThis(''.replace);
var numberToString = uncurryThis(1.0.toString);
var tester = /[\uD800-\uDFFF]/g;
var low = /^[\uD800-\uDBFF]$/;
var hi = /^[\uDC00-\uDFFF]$/;
var WRONG_SYMBOLS_CONVERSION = !NATIVE_SYMBOL || fails(function () {
 var symbol = getBuiltIn('Symbol')();
 return $stringify([symbol]) != '[null]' || $stringify({ a: symbol }) != '{}' || $stringify(Object(symbol)) != '{}';
});
var ILL_FORMED_UNICODE = fails(function () {
 return $stringify('\uDF06\uD834') !== '"\\udf06\\ud834"' || $stringify('\uDEAD') !== '"\\udead"';
});
var stringifyWithSymbolsFix = function (it, replacer) {
 var args = arraySlice(arguments);
 var $replacer = getReplacerFunction(replacer);
 if (!isCallable($replacer) && (it === undefined || isSymbol(it)))
  return;
 args[1] = function (key, value) {
  if (isCallable($replacer))
   value = call($replacer, this, $String(key), value);
  if (!isSymbol(value))
   return value;
 };
 return apply($stringify, null, args);
};
var fixIllFormed = function (match, offset, string) {
 var prev = charAt(string, offset - 1);
 var next = charAt(string, offset + 1);
 if (exec(low, match) && !exec(hi, next) || exec(hi, match) && !exec(low, prev)) {
  return '\\u' + numberToString(charCodeAt(match, 0), 16);
 }
 return match;
};
if ($stringify) {
 $({
  target: 'JSON',
  stat: true,
  arity: 3,
  forced: WRONG_SYMBOLS_CONVERSION || ILL_FORMED_UNICODE
 }, {
  stringify: function stringify(it, replacer, space) {
   var args = arraySlice(arguments);
   var result = apply(WRONG_SYMBOLS_CONVERSION ? stringifyWithSymbolsFix : $stringify, null, args);
   return ILL_FORMED_UNICODE && typeof result == 'string' ? replace(result, tester, fixIllFormed) : result;
  }
 });
}

/***/ }),
/* 100 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var NATIVE_BIND = __w_pdfjs_require__(8);
var FunctionPrototype = Function.prototype;
var apply = FunctionPrototype.apply;
var call = FunctionPrototype.call;
module.exports = typeof Reflect == 'object' && Reflect.apply || (NATIVE_BIND ? call.bind(apply) : function () {
 return call.apply(apply, arguments);
});

/***/ }),
/* 101 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
module.exports = uncurryThis([].slice);

/***/ }),
/* 102 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var isArray = __w_pdfjs_require__(94);
var isCallable = __w_pdfjs_require__(29);
var classof = __w_pdfjs_require__(63);
var toString = __w_pdfjs_require__(77);
var push = uncurryThis([].push);
module.exports = function (replacer) {
 if (isCallable(replacer))
  return replacer;
 if (!isArray(replacer))
  return;
 var rawLength = replacer.length;
 var keys = [];
 for (var i = 0; i < rawLength; i++) {
  var element = replacer[i];
  if (typeof element == 'string')
   push(keys, element);
  else if (typeof element == 'number' || classof(element) == 'Number' || classof(element) == 'String')
   push(keys, toString(element));
 }
 var keysLength = keys.length;
 var root = true;
 return function (key, value) {
  if (root) {
   root = false;
   return value;
  }
  if (isArray(this))
   return value;
  for (var j = 0; j < keysLength; j++)
   if (keys[j] === key)
    return value;
 };
};

/***/ }),
/* 103 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var NATIVE_SYMBOL = __w_pdfjs_require__(20);
var fails = __w_pdfjs_require__(9);
var getOwnPropertySymbolsModule = __w_pdfjs_require__(75);
var toObject = __w_pdfjs_require__(10);
var FORCED = !NATIVE_SYMBOL || fails(function () {
 getOwnPropertySymbolsModule.f(1);
});
$({
 target: 'Object',
 stat: true,
 forced: FORCED
}, {
 getOwnPropertySymbols: function getOwnPropertySymbols(it) {
  var $getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
  return $getOwnPropertySymbols ? $getOwnPropertySymbols(toObject(it)) : [];
 }
});

/***/ }),
/* 104 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var DESCRIPTORS = __w_pdfjs_require__(25);
var global = __w_pdfjs_require__(5);
var uncurryThis = __w_pdfjs_require__(7);
var hasOwn = __w_pdfjs_require__(6);
var isCallable = __w_pdfjs_require__(29);
var isPrototypeOf = __w_pdfjs_require__(38);
var toString = __w_pdfjs_require__(77);
var defineBuiltInAccessor = __w_pdfjs_require__(87);
var copyConstructorProperties = __w_pdfjs_require__(64);
var NativeSymbol = global.Symbol;
var SymbolPrototype = NativeSymbol && NativeSymbol.prototype;
if (DESCRIPTORS && isCallable(NativeSymbol) && (!('description' in SymbolPrototype) || NativeSymbol().description !== undefined)) {
 var EmptyStringDescriptionStore = {};
 var SymbolWrapper = function Symbol() {
  var description = arguments.length < 1 || arguments[0] === undefined ? undefined : toString(arguments[0]);
  var result = isPrototypeOf(SymbolPrototype, this) ? new NativeSymbol(description) : description === undefined ? NativeSymbol() : NativeSymbol(description);
  if (description === '')
   EmptyStringDescriptionStore[result] = true;
  return result;
 };
 copyConstructorProperties(SymbolWrapper, NativeSymbol);
 SymbolWrapper.prototype = SymbolPrototype;
 SymbolPrototype.constructor = SymbolWrapper;
 var NATIVE_SYMBOL = String(NativeSymbol('test')) == 'Symbol(test)';
 var thisSymbolValue = uncurryThis(SymbolPrototype.valueOf);
 var symbolDescriptiveString = uncurryThis(SymbolPrototype.toString);
 var regexp = /^Symbol\((.*)\)[^)]+$/;
 var replace = uncurryThis(''.replace);
 var stringSlice = uncurryThis(''.slice);
 defineBuiltInAccessor(SymbolPrototype, 'description', {
  configurable: true,
  get: function description() {
   var symbol = thisSymbolValue(this);
   if (hasOwn(EmptyStringDescriptionStore, symbol))
    return '';
   var string = symbolDescriptiveString(symbol);
   var desc = NATIVE_SYMBOL ? stringSlice(string, 7, -1) : replace(string, regexp, '$1');
   return desc === '' ? undefined : desc;
  }
 });
 $({
  global: true,
  constructor: true,
  forced: true
 }, { Symbol: SymbolWrapper });
}

/***/ }),
/* 105 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var IS_PURE = __w_pdfjs_require__(16);
var DESCRIPTORS = __w_pdfjs_require__(25);
var global = __w_pdfjs_require__(5);
var path = __w_pdfjs_require__(4);
var uncurryThis = __w_pdfjs_require__(7);
var isForced = __w_pdfjs_require__(76);
var hasOwn = __w_pdfjs_require__(6);
var inheritIfRequired = __w_pdfjs_require__(106);
var isPrototypeOf = __w_pdfjs_require__(38);
var isSymbol = __w_pdfjs_require__(36);
var toPrimitive = __w_pdfjs_require__(34);
var fails = __w_pdfjs_require__(9);
var getOwnPropertyNames = (__w_pdfjs_require__(66).f);
var getOwnPropertyDescriptor = (__w_pdfjs_require__(59).f);
var defineProperty = (__w_pdfjs_require__(24).f);
var thisNumberValue = __w_pdfjs_require__(110);
var trim = (__w_pdfjs_require__(111).trim);
var NUMBER = 'Number';
var NativeNumber = global[NUMBER];
var PureNumberNamespace = path[NUMBER];
var NumberPrototype = NativeNumber.prototype;
var TypeError = global.TypeError;
var stringSlice = uncurryThis(''.slice);
var charCodeAt = uncurryThis(''.charCodeAt);
var toNumeric = function (value) {
 var primValue = toPrimitive(value, 'number');
 return typeof primValue == 'bigint' ? primValue : toNumber(primValue);
};
var toNumber = function (argument) {
 var it = toPrimitive(argument, 'number');
 var first, third, radix, maxCode, digits, length, index, code;
 if (isSymbol(it))
  throw TypeError('Cannot convert a Symbol value to a number');
 if (typeof it == 'string' && it.length > 2) {
  it = trim(it);
  first = charCodeAt(it, 0);
  if (first === 43 || first === 45) {
   third = charCodeAt(it, 2);
   if (third === 88 || third === 120)
    return NaN;
  } else if (first === 48) {
   switch (charCodeAt(it, 1)) {
   case 66:
   case 98:
    radix = 2;
    maxCode = 49;
    break;
   case 79:
   case 111:
    radix = 8;
    maxCode = 55;
    break;
   default:
    return +it;
   }
   digits = stringSlice(it, 2);
   length = digits.length;
   for (index = 0; index < length; index++) {
    code = charCodeAt(digits, index);
    if (code < 48 || code > maxCode)
     return NaN;
   }
   return parseInt(digits, radix);
  }
 }
 return +it;
};
var FORCED = isForced(NUMBER, !NativeNumber(' 0o1') || !NativeNumber('0b1') || NativeNumber('+0x1'));
var calledWithNew = function (dummy) {
 return isPrototypeOf(NumberPrototype, dummy) && fails(function () {
  thisNumberValue(dummy);
 });
};
var NumberWrapper = function Number(value) {
 var n = arguments.length < 1 ? 0 : NativeNumber(toNumeric(value));
 return calledWithNew(this) ? inheritIfRequired(Object(n), this, NumberWrapper) : n;
};
NumberWrapper.prototype = NumberPrototype;
if (FORCED && !IS_PURE)
 NumberPrototype.constructor = NumberWrapper;
$({
 global: true,
 constructor: true,
 wrap: true,
 forced: FORCED
}, { Number: NumberWrapper });
var copyConstructorProperties = function (target, source) {
 for (var keys = DESCRIPTORS ? getOwnPropertyNames(source) : ('MAX_VALUE,MIN_VALUE,NaN,NEGATIVE_INFINITY,POSITIVE_INFINITY,' + 'EPSILON,MAX_SAFE_INTEGER,MIN_SAFE_INTEGER,isFinite,isInteger,isNaN,isSafeInteger,parseFloat,parseInt,' + 'fromString,range').split(','), j = 0, key; keys.length > j; j++) {
  if (hasOwn(source, key = keys[j]) && !hasOwn(target, key)) {
   defineProperty(target, key, getOwnPropertyDescriptor(source, key));
  }
 }
};
if (IS_PURE && PureNumberNamespace)
 copyConstructorProperties(path[NUMBER], PureNumberNamespace);
if (FORCED || IS_PURE)
 copyConstructorProperties(path[NUMBER], NativeNumber);

/***/ }),
/* 106 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var isCallable = __w_pdfjs_require__(29);
var isObject = __w_pdfjs_require__(28);
var setPrototypeOf = __w_pdfjs_require__(107);
module.exports = function ($this, dummy, Wrapper) {
 var NewTarget, NewTargetPrototype;
 if (setPrototypeOf && isCallable(NewTarget = dummy.constructor) && NewTarget !== Wrapper && isObject(NewTargetPrototype = NewTarget.prototype) && NewTargetPrototype !== Wrapper.prototype)
  setPrototypeOf($this, NewTargetPrototype);
 return $this;
};

/***/ }),
/* 107 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThisAccessor = __w_pdfjs_require__(108);
var anObject = __w_pdfjs_require__(32);
var aPossiblePrototype = __w_pdfjs_require__(109);
module.exports = Object.setPrototypeOf || ('__proto__' in {} ? (function () {
 var CORRECT_SETTER = false;
 var test = {};
 var setter;
 try {
  setter = uncurryThisAccessor(Object.prototype, '__proto__', 'set');
  setter(test, []);
  CORRECT_SETTER = test instanceof Array;
 } catch (error) {
 }
 return function setPrototypeOf(O, proto) {
  anObject(O);
  aPossiblePrototype(proto);
  if (CORRECT_SETTER)
   setter(O, proto);
  else
   O.__proto__ = proto;
  return O;
 };
}()) : undefined);

/***/ }),
/* 108 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var aCallable = __w_pdfjs_require__(40);
module.exports = function (object, key, method) {
 try {
  return uncurryThis(aCallable(Object.getOwnPropertyDescriptor(object, key)[method]));
 } catch (error) {
 }
};

/***/ }),
/* 109 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var isCallable = __w_pdfjs_require__(29);
var $String = String;
var $TypeError = TypeError;
module.exports = function (argument) {
 if (typeof argument == 'object' || isCallable(argument))
  return argument;
 throw $TypeError("Can't set " + $String(argument) + ' as a prototype');
};

/***/ }),
/* 110 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
module.exports = uncurryThis(1.0.valueOf);

/***/ }),
/* 111 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var requireObjectCoercible = __w_pdfjs_require__(11);
var toString = __w_pdfjs_require__(77);
var whitespaces = __w_pdfjs_require__(112);
var replace = uncurryThis(''.replace);
var ltrim = RegExp('^[' + whitespaces + ']+');
var rtrim = RegExp('(^|[^' + whitespaces + '])[' + whitespaces + ']+$');
var createMethod = function (TYPE) {
 return function ($this) {
  var string = toString(requireObjectCoercible($this));
  if (TYPE & 1)
   string = replace(string, ltrim, '');
  if (TYPE & 2)
   string = replace(string, rtrim, '$1');
  return string;
 };
};
module.exports = {
 start: createMethod(1),
 end: createMethod(2),
 trim: createMethod(3)
};

/***/ }),
/* 112 */
/***/ ((module) => {


module.exports = '\u0009\u000A\u000B\u000C\u000D\u0020\u00A0\u1680\u2000\u2001\u2002' + '\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';

/***/ }),
/* 113 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var defineWellKnownSymbol = __w_pdfjs_require__(3);
defineWellKnownSymbol('iterator');

/***/ }),
/* 114 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var from = __w_pdfjs_require__(115);
var checkCorrectnessOfIteration = __w_pdfjs_require__(122);
var INCORRECT_ITERATION = !checkCorrectnessOfIteration(function (iterable) {
 Array.from(iterable);
});
$({
 target: 'Array',
 stat: true,
 forced: INCORRECT_ITERATION
}, { from: from });

/***/ }),
/* 115 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var bind = __w_pdfjs_require__(90);
var call = __w_pdfjs_require__(35);
var toObject = __w_pdfjs_require__(10);
var callWithSafeIterationClosing = __w_pdfjs_require__(116);
var isArrayIteratorMethod = __w_pdfjs_require__(118);
var isConstructor = __w_pdfjs_require__(95);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var createProperty = __w_pdfjs_require__(86);
var getIterator = __w_pdfjs_require__(120);
var getIteratorMethod = __w_pdfjs_require__(121);
var $Array = Array;
module.exports = function from(arrayLike) {
 var O = toObject(arrayLike);
 var IS_CONSTRUCTOR = isConstructor(this);
 var argumentsLength = arguments.length;
 var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
 var mapping = mapfn !== undefined;
 if (mapping)
  mapfn = bind(mapfn, argumentsLength > 2 ? arguments[2] : undefined);
 var iteratorMethod = getIteratorMethod(O);
 var index = 0;
 var length, result, step, iterator, next, value;
 if (iteratorMethod && !(this === $Array && isArrayIteratorMethod(iteratorMethod))) {
  iterator = getIterator(O, iteratorMethod);
  next = iterator.next;
  result = IS_CONSTRUCTOR ? new this() : [];
  for (; !(step = call(next, iterator)).done; index++) {
   value = mapping ? callWithSafeIterationClosing(iterator, mapfn, [
    step.value,
    index
   ], true) : step.value;
   createProperty(result, index, value);
  }
 } else {
  length = lengthOfArrayLike(O);
  result = IS_CONSTRUCTOR ? new this(length) : $Array(length);
  for (; length > index; index++) {
   value = mapping ? mapfn(O[index], index) : O[index];
   createProperty(result, index, value);
  }
 }
 result.length = index;
 return result;
};

/***/ }),
/* 116 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var anObject = __w_pdfjs_require__(32);
var iteratorClose = __w_pdfjs_require__(117);
module.exports = function (iterator, fn, value, ENTRIES) {
 try {
  return ENTRIES ? fn(anObject(value)[0], value[1]) : fn(value);
 } catch (error) {
  iteratorClose(iterator, 'throw', error);
 }
};

/***/ }),
/* 117 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var call = __w_pdfjs_require__(35);
var anObject = __w_pdfjs_require__(32);
var getMethod = __w_pdfjs_require__(39);
module.exports = function (iterator, kind, value) {
 var innerResult, innerError;
 anObject(iterator);
 try {
  innerResult = getMethod(iterator, 'return');
  if (!innerResult) {
   if (kind === 'throw')
    throw value;
   return value;
  }
  innerResult = call(innerResult, iterator);
 } catch (error) {
  innerError = true;
  innerResult = error;
 }
 if (kind === 'throw')
  throw value;
 if (innerError)
  throw innerResult;
 anObject(innerResult);
 return value;
};

/***/ }),
/* 118 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var wellKnownSymbol = __w_pdfjs_require__(14);
var Iterators = __w_pdfjs_require__(119);
var ITERATOR = wellKnownSymbol('iterator');
var ArrayPrototype = Array.prototype;
module.exports = function (it) {
 return it !== undefined && (Iterators.Array === it || ArrayPrototype[ITERATOR] === it);
};

/***/ }),
/* 119 */
/***/ ((module) => {


module.exports = {};

/***/ }),
/* 120 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var call = __w_pdfjs_require__(35);
var aCallable = __w_pdfjs_require__(40);
var anObject = __w_pdfjs_require__(32);
var tryToString = __w_pdfjs_require__(41);
var getIteratorMethod = __w_pdfjs_require__(121);
var $TypeError = TypeError;
module.exports = function (argument, usingIterator) {
 var iteratorMethod = arguments.length < 2 ? getIteratorMethod(argument) : usingIterator;
 if (aCallable(iteratorMethod))
  return anObject(call(iteratorMethod, argument));
 throw $TypeError(tryToString(argument) + ' is not iterable');
};

/***/ }),
/* 121 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var classof = __w_pdfjs_require__(78);
var getMethod = __w_pdfjs_require__(39);
var isNullOrUndefined = __w_pdfjs_require__(12);
var Iterators = __w_pdfjs_require__(119);
var wellKnownSymbol = __w_pdfjs_require__(14);
var ITERATOR = wellKnownSymbol('iterator');
module.exports = function (it) {
 if (!isNullOrUndefined(it))
  return getMethod(it, ITERATOR) || getMethod(it, '@@iterator') || Iterators[classof(it)];
};

/***/ }),
/* 122 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var wellKnownSymbol = __w_pdfjs_require__(14);
var ITERATOR = wellKnownSymbol('iterator');
var SAFE_CLOSING = false;
try {
 var called = 0;
 var iteratorWithReturn = {
  next: function () {
   return { done: !!called++ };
  },
  'return': function () {
   SAFE_CLOSING = true;
  }
 };
 iteratorWithReturn[ITERATOR] = function () {
  return this;
 };
 Array.from(iteratorWithReturn, function () {
  throw 2;
 });
} catch (error) {
}
module.exports = function (exec, SKIP_CLOSING) {
 if (!SKIP_CLOSING && !SAFE_CLOSING)
  return false;
 var ITERATION_SUPPORT = false;
 try {
  var object = {};
  object[ITERATOR] = function () {
   return {
    next: function () {
     return { done: ITERATION_SUPPORT = true };
    }
   };
  };
  exec(object);
 } catch (error) {
 }
 return ITERATION_SUPPORT;
};

/***/ }),
/* 123 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var exec = __w_pdfjs_require__(124);
$({
 target: 'RegExp',
 proto: true,
 forced: /./.exec !== exec
}, { exec: exec });

/***/ }),
/* 124 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var call = __w_pdfjs_require__(35);
var uncurryThis = __w_pdfjs_require__(7);
var toString = __w_pdfjs_require__(77);
var regexpFlags = __w_pdfjs_require__(125);
var stickyHelpers = __w_pdfjs_require__(126);
var shared = __w_pdfjs_require__(15);
var create = __w_pdfjs_require__(80);
var getInternalState = (__w_pdfjs_require__(48).get);
var UNSUPPORTED_DOT_ALL = __w_pdfjs_require__(127);
var UNSUPPORTED_NCG = __w_pdfjs_require__(128);
var nativeReplace = shared('native-string-replace', String.prototype.replace);
var nativeExec = RegExp.prototype.exec;
var patchedExec = nativeExec;
var charAt = uncurryThis(''.charAt);
var indexOf = uncurryThis(''.indexOf);
var replace = uncurryThis(''.replace);
var stringSlice = uncurryThis(''.slice);
var UPDATES_LAST_INDEX_WRONG = (function () {
 var re1 = /a/;
 var re2 = /b*/g;
 call(nativeExec, re1, 'a');
 call(nativeExec, re2, 'a');
 return re1.lastIndex !== 0 || re2.lastIndex !== 0;
}());
var UNSUPPORTED_Y = stickyHelpers.BROKEN_CARET;
var NPCG_INCLUDED = /()??/.exec('')[1] !== undefined;
var PATCH = UPDATES_LAST_INDEX_WRONG || NPCG_INCLUDED || UNSUPPORTED_Y || UNSUPPORTED_DOT_ALL || UNSUPPORTED_NCG;
if (PATCH) {
 patchedExec = function exec(string) {
  var re = this;
  var state = getInternalState(re);
  var str = toString(string);
  var raw = state.raw;
  var result, reCopy, lastIndex, match, i, object, group;
  if (raw) {
   raw.lastIndex = re.lastIndex;
   result = call(patchedExec, raw, str);
   re.lastIndex = raw.lastIndex;
   return result;
  }
  var groups = state.groups;
  var sticky = UNSUPPORTED_Y && re.sticky;
  var flags = call(regexpFlags, re);
  var source = re.source;
  var charsAdded = 0;
  var strCopy = str;
  if (sticky) {
   flags = replace(flags, 'y', '');
   if (indexOf(flags, 'g') === -1) {
    flags += 'g';
   }
   strCopy = stringSlice(str, re.lastIndex);
   if (re.lastIndex > 0 && (!re.multiline || re.multiline && charAt(str, re.lastIndex - 1) !== '\n')) {
    source = '(?: ' + source + ')';
    strCopy = ' ' + strCopy;
    charsAdded++;
   }
   reCopy = new RegExp('^(?:' + source + ')', flags);
  }
  if (NPCG_INCLUDED) {
   reCopy = new RegExp('^' + source + '$(?!\\s)', flags);
  }
  if (UPDATES_LAST_INDEX_WRONG)
   lastIndex = re.lastIndex;
  match = call(nativeExec, sticky ? reCopy : re, strCopy);
  if (sticky) {
   if (match) {
    match.input = stringSlice(match.input, charsAdded);
    match[0] = stringSlice(match[0], charsAdded);
    match.index = re.lastIndex;
    re.lastIndex += match[0].length;
   } else
    re.lastIndex = 0;
  } else if (UPDATES_LAST_INDEX_WRONG && match) {
   re.lastIndex = re.global ? match.index + match[0].length : lastIndex;
  }
  if (NPCG_INCLUDED && match && match.length > 1) {
   call(nativeReplace, match[0], reCopy, function () {
    for (i = 1; i < arguments.length - 2; i++) {
     if (arguments[i] === undefined)
      match[i] = undefined;
    }
   });
  }
  if (match && groups) {
   match.groups = object = create(null);
   for (i = 0; i < groups.length; i++) {
    group = groups[i];
    object[group[0]] = match[group[1]];
   }
  }
  return match;
 };
}
module.exports = patchedExec;

/***/ }),
/* 125 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var anObject = __w_pdfjs_require__(32);
module.exports = function () {
 var that = anObject(this);
 var result = '';
 if (that.hasIndices)
  result += 'd';
 if (that.global)
  result += 'g';
 if (that.ignoreCase)
  result += 'i';
 if (that.multiline)
  result += 'm';
 if (that.dotAll)
  result += 's';
 if (that.unicode)
  result += 'u';
 if (that.unicodeSets)
  result += 'v';
 if (that.sticky)
  result += 'y';
 return result;
};

/***/ }),
/* 126 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var fails = __w_pdfjs_require__(9);
var global = __w_pdfjs_require__(5);
var $RegExp = global.RegExp;
var UNSUPPORTED_Y = fails(function () {
 var re = $RegExp('a', 'y');
 re.lastIndex = 2;
 return re.exec('abcd') != null;
});
var MISSED_STICKY = UNSUPPORTED_Y || fails(function () {
 return !$RegExp('a', 'y').sticky;
});
var BROKEN_CARET = UNSUPPORTED_Y || fails(function () {
 var re = $RegExp('^r', 'gy');
 re.lastIndex = 2;
 return re.exec('str') != null;
});
module.exports = {
 BROKEN_CARET: BROKEN_CARET,
 MISSED_STICKY: MISSED_STICKY,
 UNSUPPORTED_Y: UNSUPPORTED_Y
};

/***/ }),
/* 127 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var fails = __w_pdfjs_require__(9);
var global = __w_pdfjs_require__(5);
var $RegExp = global.RegExp;
module.exports = fails(function () {
 var re = $RegExp('.', 's');
 return !(re.dotAll && re.exec('\n') && re.flags === 's');
});

/***/ }),
/* 128 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var fails = __w_pdfjs_require__(9);
var global = __w_pdfjs_require__(5);
var $RegExp = global.RegExp;
module.exports = fails(function () {
 var re = $RegExp('(?<a>b)', 'g');
 return re.exec('b').groups.a !== 'b' || 'b'.replace(re, '$<a>c') !== 'bc';
});

/***/ }),
/* 129 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


__w_pdfjs_require__(123);
var $ = __w_pdfjs_require__(58);
var call = __w_pdfjs_require__(35);
var isCallable = __w_pdfjs_require__(29);
var anObject = __w_pdfjs_require__(32);
var toString = __w_pdfjs_require__(77);
var DELEGATES_TO_EXEC = (function () {
 var execCalled = false;
 var re = /[ac]/;
 re.exec = function () {
  execCalled = true;
  return /./.exec.apply(this, arguments);
 };
 return re.test('abc') === true && execCalled;
}());
var nativeTest = /./.test;
$({
 target: 'RegExp',
 proto: true,
 forced: !DELEGATES_TO_EXEC
}, {
 test: function (S) {
  var R = anObject(this);
  var string = toString(S);
  var exec = R.exec;
  if (!isCallable(exec))
   return call(nativeTest, R, string);
  var result = call(exec, R, string);
  if (result === null)
   return false;
  anObject(result);
  return true;
 }
});

/***/ }),
/* 130 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var defineWellKnownSymbol = __w_pdfjs_require__(3);
defineWellKnownSymbol('asyncIterator');

/***/ }),
/* 131 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var getBuiltIn = __w_pdfjs_require__(37);
var defineWellKnownSymbol = __w_pdfjs_require__(3);
var setToStringTag = __w_pdfjs_require__(88);
defineWellKnownSymbol('toStringTag');
setToStringTag(getBuiltIn('Symbol'), 'Symbol');

/***/ }),
/* 132 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var setToStringTag = __w_pdfjs_require__(88);
setToStringTag(global.JSON, 'JSON', true);

/***/ }),
/* 133 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var setToStringTag = __w_pdfjs_require__(88);
setToStringTag(Math, 'Math', true);

/***/ }),
/* 134 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var fails = __w_pdfjs_require__(9);
var toObject = __w_pdfjs_require__(10);
var nativeGetPrototypeOf = __w_pdfjs_require__(135);
var CORRECT_PROTOTYPE_GETTER = __w_pdfjs_require__(136);
var FAILS_ON_PRIMITIVES = fails(function () {
 nativeGetPrototypeOf(1);
});
$({
 target: 'Object',
 stat: true,
 forced: FAILS_ON_PRIMITIVES,
 sham: !CORRECT_PROTOTYPE_GETTER
}, {
 getPrototypeOf: function getPrototypeOf(it) {
  return nativeGetPrototypeOf(toObject(it));
 }
});

/***/ }),
/* 135 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var hasOwn = __w_pdfjs_require__(6);
var isCallable = __w_pdfjs_require__(29);
var toObject = __w_pdfjs_require__(10);
var sharedKey = __w_pdfjs_require__(52);
var CORRECT_PROTOTYPE_GETTER = __w_pdfjs_require__(136);
var IE_PROTO = sharedKey('IE_PROTO');
var $Object = Object;
var ObjectPrototype = $Object.prototype;
module.exports = CORRECT_PROTOTYPE_GETTER ? $Object.getPrototypeOf : function (O) {
 var object = toObject(O);
 if (hasOwn(object, IE_PROTO))
  return object[IE_PROTO];
 var constructor = object.constructor;
 if (isCallable(constructor) && object instanceof constructor) {
  return constructor.prototype;
 }
 return object instanceof $Object ? ObjectPrototype : null;
};

/***/ }),
/* 136 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var fails = __w_pdfjs_require__(9);
module.exports = !fails(function () {
 function F() {
 }
 F.prototype.constructor = null;
 return Object.getPrototypeOf(new F()) !== F.prototype;
});

/***/ }),
/* 137 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var toIndexedObject = __w_pdfjs_require__(61);
var addToUnscopables = __w_pdfjs_require__(138);
var Iterators = __w_pdfjs_require__(119);
var InternalStateModule = __w_pdfjs_require__(48);
var defineProperty = (__w_pdfjs_require__(24).f);
var defineIterator = __w_pdfjs_require__(139);
var createIterResultObject = __w_pdfjs_require__(142);
var IS_PURE = __w_pdfjs_require__(16);
var DESCRIPTORS = __w_pdfjs_require__(25);
var ARRAY_ITERATOR = 'Array Iterator';
var setInternalState = InternalStateModule.set;
var getInternalState = InternalStateModule.getterFor(ARRAY_ITERATOR);
module.exports = defineIterator(Array, 'Array', function (iterated, kind) {
 setInternalState(this, {
  type: ARRAY_ITERATOR,
  target: toIndexedObject(iterated),
  index: 0,
  kind: kind
 });
}, function () {
 var state = getInternalState(this);
 var target = state.target;
 var kind = state.kind;
 var index = state.index++;
 if (!target || index >= target.length) {
  state.target = undefined;
  return createIterResultObject(undefined, true);
 }
 if (kind == 'keys')
  return createIterResultObject(index, false);
 if (kind == 'values')
  return createIterResultObject(target[index], false);
 return createIterResultObject([
  index,
  target[index]
 ], false);
}, 'values');
var values = Iterators.Arguments = Iterators.Array;
addToUnscopables('keys');
addToUnscopables('values');
addToUnscopables('entries');
if (!IS_PURE && DESCRIPTORS && values.name !== 'values')
 try {
  defineProperty(values, 'name', { value: 'values' });
 } catch (error) {
 }

/***/ }),
/* 138 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var wellKnownSymbol = __w_pdfjs_require__(14);
var create = __w_pdfjs_require__(80);
var defineProperty = (__w_pdfjs_require__(24).f);
var UNSCOPABLES = wellKnownSymbol('unscopables');
var ArrayPrototype = Array.prototype;
if (ArrayPrototype[UNSCOPABLES] == undefined) {
 defineProperty(ArrayPrototype, UNSCOPABLES, {
  configurable: true,
  value: create(null)
 });
}
module.exports = function (key) {
 ArrayPrototype[UNSCOPABLES][key] = true;
};

/***/ }),
/* 139 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var call = __w_pdfjs_require__(35);
var IS_PURE = __w_pdfjs_require__(16);
var FunctionName = __w_pdfjs_require__(46);
var isCallable = __w_pdfjs_require__(29);
var createIteratorConstructor = __w_pdfjs_require__(140);
var getPrototypeOf = __w_pdfjs_require__(135);
var setPrototypeOf = __w_pdfjs_require__(107);
var setToStringTag = __w_pdfjs_require__(88);
var createNonEnumerableProperty = __w_pdfjs_require__(50);
var defineBuiltIn = __w_pdfjs_require__(44);
var wellKnownSymbol = __w_pdfjs_require__(14);
var Iterators = __w_pdfjs_require__(119);
var IteratorsCore = __w_pdfjs_require__(141);
var PROPER_FUNCTION_NAME = FunctionName.PROPER;
var CONFIGURABLE_FUNCTION_NAME = FunctionName.CONFIGURABLE;
var IteratorPrototype = IteratorsCore.IteratorPrototype;
var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
var ITERATOR = wellKnownSymbol('iterator');
var KEYS = 'keys';
var VALUES = 'values';
var ENTRIES = 'entries';
var returnThis = function () {
 return this;
};
module.exports = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
 createIteratorConstructor(IteratorConstructor, NAME, next);
 var getIterationMethod = function (KIND) {
  if (KIND === DEFAULT && defaultIterator)
   return defaultIterator;
  if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype)
   return IterablePrototype[KIND];
  switch (KIND) {
  case KEYS:
   return function keys() {
    return new IteratorConstructor(this, KIND);
   };
  case VALUES:
   return function values() {
    return new IteratorConstructor(this, KIND);
   };
  case ENTRIES:
   return function entries() {
    return new IteratorConstructor(this, KIND);
   };
  }
  return function () {
   return new IteratorConstructor(this);
  };
 };
 var TO_STRING_TAG = NAME + ' Iterator';
 var INCORRECT_VALUES_NAME = false;
 var IterablePrototype = Iterable.prototype;
 var nativeIterator = IterablePrototype[ITERATOR] || IterablePrototype['@@iterator'] || DEFAULT && IterablePrototype[DEFAULT];
 var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
 var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
 var CurrentIteratorPrototype, methods, KEY;
 if (anyNativeIterator) {
  CurrentIteratorPrototype = getPrototypeOf(anyNativeIterator.call(new Iterable()));
  if (CurrentIteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
   if (!IS_PURE && getPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype) {
    if (setPrototypeOf) {
     setPrototypeOf(CurrentIteratorPrototype, IteratorPrototype);
    } else if (!isCallable(CurrentIteratorPrototype[ITERATOR])) {
     defineBuiltIn(CurrentIteratorPrototype, ITERATOR, returnThis);
    }
   }
   setToStringTag(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
   if (IS_PURE)
    Iterators[TO_STRING_TAG] = returnThis;
  }
 }
 if (PROPER_FUNCTION_NAME && DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
  if (!IS_PURE && CONFIGURABLE_FUNCTION_NAME) {
   createNonEnumerableProperty(IterablePrototype, 'name', VALUES);
  } else {
   INCORRECT_VALUES_NAME = true;
   defaultIterator = function values() {
    return call(nativeIterator, this);
   };
  }
 }
 if (DEFAULT) {
  methods = {
   values: getIterationMethod(VALUES),
   keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
   entries: getIterationMethod(ENTRIES)
  };
  if (FORCED)
   for (KEY in methods) {
    if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
     defineBuiltIn(IterablePrototype, KEY, methods[KEY]);
    }
   }
  else
   $({
    target: NAME,
    proto: true,
    forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME
   }, methods);
 }
 if ((!IS_PURE || FORCED) && IterablePrototype[ITERATOR] !== defaultIterator) {
  defineBuiltIn(IterablePrototype, ITERATOR, defaultIterator, { name: DEFAULT });
 }
 Iterators[NAME] = defaultIterator;
 return methods;
};

/***/ }),
/* 140 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var IteratorPrototype = (__w_pdfjs_require__(141).IteratorPrototype);
var create = __w_pdfjs_require__(80);
var createPropertyDescriptor = __w_pdfjs_require__(51);
var setToStringTag = __w_pdfjs_require__(88);
var Iterators = __w_pdfjs_require__(119);
var returnThis = function () {
 return this;
};
module.exports = function (IteratorConstructor, NAME, next, ENUMERABLE_NEXT) {
 var TO_STRING_TAG = NAME + ' Iterator';
 IteratorConstructor.prototype = create(IteratorPrototype, { next: createPropertyDescriptor(+!ENUMERABLE_NEXT, next) });
 setToStringTag(IteratorConstructor, TO_STRING_TAG, false, true);
 Iterators[TO_STRING_TAG] = returnThis;
 return IteratorConstructor;
};

/***/ }),
/* 141 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var fails = __w_pdfjs_require__(9);
var isCallable = __w_pdfjs_require__(29);
var isObject = __w_pdfjs_require__(28);
var create = __w_pdfjs_require__(80);
var getPrototypeOf = __w_pdfjs_require__(135);
var defineBuiltIn = __w_pdfjs_require__(44);
var wellKnownSymbol = __w_pdfjs_require__(14);
var IS_PURE = __w_pdfjs_require__(16);
var ITERATOR = wellKnownSymbol('iterator');
var BUGGY_SAFARI_ITERATORS = false;
var IteratorPrototype, PrototypeOfArrayIteratorPrototype, arrayIterator;
if ([].keys) {
 arrayIterator = [].keys();
 if (!('next' in arrayIterator))
  BUGGY_SAFARI_ITERATORS = true;
 else {
  PrototypeOfArrayIteratorPrototype = getPrototypeOf(getPrototypeOf(arrayIterator));
  if (PrototypeOfArrayIteratorPrototype !== Object.prototype)
   IteratorPrototype = PrototypeOfArrayIteratorPrototype;
 }
}
var NEW_ITERATOR_PROTOTYPE = !isObject(IteratorPrototype) || fails(function () {
 var test = {};
 return IteratorPrototype[ITERATOR].call(test) !== test;
});
if (NEW_ITERATOR_PROTOTYPE)
 IteratorPrototype = {};
else if (IS_PURE)
 IteratorPrototype = create(IteratorPrototype);
if (!isCallable(IteratorPrototype[ITERATOR])) {
 defineBuiltIn(IteratorPrototype, ITERATOR, function () {
  return this;
 });
}
module.exports = {
 IteratorPrototype: IteratorPrototype,
 BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS
};

/***/ }),
/* 142 */
/***/ ((module) => {


module.exports = function (value, done) {
 return {
  value: value,
  done: done
 };
};

/***/ }),
/* 143 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var TO_STRING_TAG_SUPPORT = __w_pdfjs_require__(79);
var defineBuiltIn = __w_pdfjs_require__(44);
var toString = __w_pdfjs_require__(144);
if (!TO_STRING_TAG_SUPPORT) {
 defineBuiltIn(Object.prototype, 'toString', toString, { unsafe: true });
}

/***/ }),
/* 144 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var TO_STRING_TAG_SUPPORT = __w_pdfjs_require__(79);
var classof = __w_pdfjs_require__(78);
module.exports = TO_STRING_TAG_SUPPORT ? {}.toString : function toString() {
 return '[object ' + classof(this) + ']';
};

/***/ }),
/* 145 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


__w_pdfjs_require__(146);
__w_pdfjs_require__(166);
__w_pdfjs_require__(169);
__w_pdfjs_require__(170);
__w_pdfjs_require__(171);
__w_pdfjs_require__(172);

/***/ }),
/* 146 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var IS_PURE = __w_pdfjs_require__(16);
var IS_NODE = __w_pdfjs_require__(147);
var global = __w_pdfjs_require__(5);
var call = __w_pdfjs_require__(35);
var defineBuiltIn = __w_pdfjs_require__(44);
var setPrototypeOf = __w_pdfjs_require__(107);
var setToStringTag = __w_pdfjs_require__(88);
var setSpecies = __w_pdfjs_require__(148);
var aCallable = __w_pdfjs_require__(40);
var isCallable = __w_pdfjs_require__(29);
var isObject = __w_pdfjs_require__(28);
var anInstance = __w_pdfjs_require__(149);
var speciesConstructor = __w_pdfjs_require__(150);
var task = (__w_pdfjs_require__(152).set);
var microtask = __w_pdfjs_require__(155);
var hostReportErrors = __w_pdfjs_require__(159);
var perform = __w_pdfjs_require__(160);
var Queue = __w_pdfjs_require__(156);
var InternalStateModule = __w_pdfjs_require__(48);
var NativePromiseConstructor = __w_pdfjs_require__(161);
var PromiseConstructorDetection = __w_pdfjs_require__(162);
var newPromiseCapabilityModule = __w_pdfjs_require__(165);
var PROMISE = 'Promise';
var FORCED_PROMISE_CONSTRUCTOR = PromiseConstructorDetection.CONSTRUCTOR;
var NATIVE_PROMISE_REJECTION_EVENT = PromiseConstructorDetection.REJECTION_EVENT;
var NATIVE_PROMISE_SUBCLASSING = PromiseConstructorDetection.SUBCLASSING;
var getInternalPromiseState = InternalStateModule.getterFor(PROMISE);
var setInternalState = InternalStateModule.set;
var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;
var PromiseConstructor = NativePromiseConstructor;
var PromisePrototype = NativePromisePrototype;
var TypeError = global.TypeError;
var document = global.document;
var process = global.process;
var newPromiseCapability = newPromiseCapabilityModule.f;
var newGenericPromiseCapability = newPromiseCapability;
var DISPATCH_EVENT = !!(document && document.createEvent && global.dispatchEvent);
var UNHANDLED_REJECTION = 'unhandledrejection';
var REJECTION_HANDLED = 'rejectionhandled';
var PENDING = 0;
var FULFILLED = 1;
var REJECTED = 2;
var HANDLED = 1;
var UNHANDLED = 2;
var Internal, OwnPromiseCapability, PromiseWrapper, nativeThen;
var isThenable = function (it) {
 var then;
 return isObject(it) && isCallable(then = it.then) ? then : false;
};
var callReaction = function (reaction, state) {
 var value = state.value;
 var ok = state.state == FULFILLED;
 var handler = ok ? reaction.ok : reaction.fail;
 var resolve = reaction.resolve;
 var reject = reaction.reject;
 var domain = reaction.domain;
 var result, then, exited;
 try {
  if (handler) {
   if (!ok) {
    if (state.rejection === UNHANDLED)
     onHandleUnhandled(state);
    state.rejection = HANDLED;
   }
   if (handler === true)
    result = value;
   else {
    if (domain)
     domain.enter();
    result = handler(value);
    if (domain) {
     domain.exit();
     exited = true;
    }
   }
   if (result === reaction.promise) {
    reject(TypeError('Promise-chain cycle'));
   } else if (then = isThenable(result)) {
    call(then, result, resolve, reject);
   } else
    resolve(result);
  } else
   reject(value);
 } catch (error) {
  if (domain && !exited)
   domain.exit();
  reject(error);
 }
};
var notify = function (state, isReject) {
 if (state.notified)
  return;
 state.notified = true;
 microtask(function () {
  var reactions = state.reactions;
  var reaction;
  while (reaction = reactions.get()) {
   callReaction(reaction, state);
  }
  state.notified = false;
  if (isReject && !state.rejection)
   onUnhandled(state);
 });
};
var dispatchEvent = function (name, promise, reason) {
 var event, handler;
 if (DISPATCH_EVENT) {
  event = document.createEvent('Event');
  event.promise = promise;
  event.reason = reason;
  event.initEvent(name, false, true);
  global.dispatchEvent(event);
 } else
  event = {
   promise: promise,
   reason: reason
  };
 if (!NATIVE_PROMISE_REJECTION_EVENT && (handler = global['on' + name]))
  handler(event);
 else if (name === UNHANDLED_REJECTION)
  hostReportErrors('Unhandled promise rejection', reason);
};
var onUnhandled = function (state) {
 call(task, global, function () {
  var promise = state.facade;
  var value = state.value;
  var IS_UNHANDLED = isUnhandled(state);
  var result;
  if (IS_UNHANDLED) {
   result = perform(function () {
    if (IS_NODE) {
     process.emit('unhandledRejection', value, promise);
    } else
     dispatchEvent(UNHANDLED_REJECTION, promise, value);
   });
   state.rejection = IS_NODE || isUnhandled(state) ? UNHANDLED : HANDLED;
   if (result.error)
    throw result.value;
  }
 });
};
var isUnhandled = function (state) {
 return state.rejection !== HANDLED && !state.parent;
};
var onHandleUnhandled = function (state) {
 call(task, global, function () {
  var promise = state.facade;
  if (IS_NODE) {
   process.emit('rejectionHandled', promise);
  } else
   dispatchEvent(REJECTION_HANDLED, promise, state.value);
 });
};
var bind = function (fn, state, unwrap) {
 return function (value) {
  fn(state, value, unwrap);
 };
};
var internalReject = function (state, value, unwrap) {
 if (state.done)
  return;
 state.done = true;
 if (unwrap)
  state = unwrap;
 state.value = value;
 state.state = REJECTED;
 notify(state, true);
};
var internalResolve = function (state, value, unwrap) {
 if (state.done)
  return;
 state.done = true;
 if (unwrap)
  state = unwrap;
 try {
  if (state.facade === value)
   throw TypeError("Promise can't be resolved itself");
  var then = isThenable(value);
  if (then) {
   microtask(function () {
    var wrapper = { done: false };
    try {
     call(then, value, bind(internalResolve, wrapper, state), bind(internalReject, wrapper, state));
    } catch (error) {
     internalReject(wrapper, error, state);
    }
   });
  } else {
   state.value = value;
   state.state = FULFILLED;
   notify(state, false);
  }
 } catch (error) {
  internalReject({ done: false }, error, state);
 }
};
if (FORCED_PROMISE_CONSTRUCTOR) {
 PromiseConstructor = function Promise(executor) {
  anInstance(this, PromisePrototype);
  aCallable(executor);
  call(Internal, this);
  var state = getInternalPromiseState(this);
  try {
   executor(bind(internalResolve, state), bind(internalReject, state));
  } catch (error) {
   internalReject(state, error);
  }
 };
 PromisePrototype = PromiseConstructor.prototype;
 Internal = function Promise(executor) {
  setInternalState(this, {
   type: PROMISE,
   done: false,
   notified: false,
   parent: false,
   reactions: new Queue(),
   rejection: false,
   state: PENDING,
   value: undefined
  });
 };
 Internal.prototype = defineBuiltIn(PromisePrototype, 'then', function then(onFulfilled, onRejected) {
  var state = getInternalPromiseState(this);
  var reaction = newPromiseCapability(speciesConstructor(this, PromiseConstructor));
  state.parent = true;
  reaction.ok = isCallable(onFulfilled) ? onFulfilled : true;
  reaction.fail = isCallable(onRejected) && onRejected;
  reaction.domain = IS_NODE ? process.domain : undefined;
  if (state.state == PENDING)
   state.reactions.add(reaction);
  else
   microtask(function () {
    callReaction(reaction, state);
   });
  return reaction.promise;
 });
 OwnPromiseCapability = function () {
  var promise = new Internal();
  var state = getInternalPromiseState(promise);
  this.promise = promise;
  this.resolve = bind(internalResolve, state);
  this.reject = bind(internalReject, state);
 };
 newPromiseCapabilityModule.f = newPromiseCapability = function (C) {
  return C === PromiseConstructor || C === PromiseWrapper ? new OwnPromiseCapability(C) : newGenericPromiseCapability(C);
 };
 if (!IS_PURE && isCallable(NativePromiseConstructor) && NativePromisePrototype !== Object.prototype) {
  nativeThen = NativePromisePrototype.then;
  if (!NATIVE_PROMISE_SUBCLASSING) {
   defineBuiltIn(NativePromisePrototype, 'then', function then(onFulfilled, onRejected) {
    var that = this;
    return new PromiseConstructor(function (resolve, reject) {
     call(nativeThen, that, resolve, reject);
    }).then(onFulfilled, onRejected);
   }, { unsafe: true });
  }
  try {
   delete NativePromisePrototype.constructor;
  } catch (error) {
  }
  if (setPrototypeOf) {
   setPrototypeOf(NativePromisePrototype, PromisePrototype);
  }
 }
}
$({
 global: true,
 constructor: true,
 wrap: true,
 forced: FORCED_PROMISE_CONSTRUCTOR
}, { Promise: PromiseConstructor });
setToStringTag(PromiseConstructor, PROMISE, false, true);
setSpecies(PROMISE);

/***/ }),
/* 147 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var classof = __w_pdfjs_require__(63);
module.exports = typeof process != 'undefined' && classof(process) == 'process';

/***/ }),
/* 148 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var getBuiltIn = __w_pdfjs_require__(37);
var defineBuiltInAccessor = __w_pdfjs_require__(87);
var wellKnownSymbol = __w_pdfjs_require__(14);
var DESCRIPTORS = __w_pdfjs_require__(25);
var SPECIES = wellKnownSymbol('species');
module.exports = function (CONSTRUCTOR_NAME) {
 var Constructor = getBuiltIn(CONSTRUCTOR_NAME);
 if (DESCRIPTORS && Constructor && !Constructor[SPECIES]) {
  defineBuiltInAccessor(Constructor, SPECIES, {
   configurable: true,
   get: function () {
    return this;
   }
  });
 }
};

/***/ }),
/* 149 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var isPrototypeOf = __w_pdfjs_require__(38);
var $TypeError = TypeError;
module.exports = function (it, Prototype) {
 if (isPrototypeOf(Prototype, it))
  return it;
 throw $TypeError('Incorrect invocation');
};

/***/ }),
/* 150 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var anObject = __w_pdfjs_require__(32);
var aConstructor = __w_pdfjs_require__(151);
var isNullOrUndefined = __w_pdfjs_require__(12);
var wellKnownSymbol = __w_pdfjs_require__(14);
var SPECIES = wellKnownSymbol('species');
module.exports = function (O, defaultConstructor) {
 var C = anObject(O).constructor;
 var S;
 return C === undefined || isNullOrUndefined(S = anObject(C)[SPECIES]) ? defaultConstructor : aConstructor(S);
};

/***/ }),
/* 151 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var isConstructor = __w_pdfjs_require__(95);
var tryToString = __w_pdfjs_require__(41);
var $TypeError = TypeError;
module.exports = function (argument) {
 if (isConstructor(argument))
  return argument;
 throw $TypeError(tryToString(argument) + ' is not a constructor');
};

/***/ }),
/* 152 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var apply = __w_pdfjs_require__(100);
var bind = __w_pdfjs_require__(90);
var isCallable = __w_pdfjs_require__(29);
var hasOwn = __w_pdfjs_require__(6);
var fails = __w_pdfjs_require__(9);
var html = __w_pdfjs_require__(83);
var arraySlice = __w_pdfjs_require__(101);
var createElement = __w_pdfjs_require__(27);
var validateArgumentsLength = __w_pdfjs_require__(153);
var IS_IOS = __w_pdfjs_require__(154);
var IS_NODE = __w_pdfjs_require__(147);
var set = global.setImmediate;
var clear = global.clearImmediate;
var process = global.process;
var Dispatch = global.Dispatch;
var Function = global.Function;
var MessageChannel = global.MessageChannel;
var String = global.String;
var counter = 0;
var queue = {};
var ONREADYSTATECHANGE = 'onreadystatechange';
var $location, defer, channel, port;
fails(function () {
 $location = global.location;
});
var run = function (id) {
 if (hasOwn(queue, id)) {
  var fn = queue[id];
  delete queue[id];
  fn();
 }
};
var runner = function (id) {
 return function () {
  run(id);
 };
};
var eventListener = function (event) {
 run(event.data);
};
var globalPostMessageDefer = function (id) {
 global.postMessage(String(id), $location.protocol + '//' + $location.host);
};
if (!set || !clear) {
 set = function setImmediate(handler) {
  validateArgumentsLength(arguments.length, 1);
  var fn = isCallable(handler) ? handler : Function(handler);
  var args = arraySlice(arguments, 1);
  queue[++counter] = function () {
   apply(fn, undefined, args);
  };
  defer(counter);
  return counter;
 };
 clear = function clearImmediate(id) {
  delete queue[id];
 };
 if (IS_NODE) {
  defer = function (id) {
   process.nextTick(runner(id));
  };
 } else if (Dispatch && Dispatch.now) {
  defer = function (id) {
   Dispatch.now(runner(id));
  };
 } else if (MessageChannel && !IS_IOS) {
  channel = new MessageChannel();
  port = channel.port2;
  channel.port1.onmessage = eventListener;
  defer = bind(port.postMessage, port);
 } else if (global.addEventListener && isCallable(global.postMessage) && !global.importScripts && $location && $location.protocol !== 'file:' && !fails(globalPostMessageDefer)) {
  defer = globalPostMessageDefer;
  global.addEventListener('message', eventListener, false);
 } else if (ONREADYSTATECHANGE in createElement('script')) {
  defer = function (id) {
   html.appendChild(createElement('script'))[ONREADYSTATECHANGE] = function () {
    html.removeChild(this);
    run(id);
   };
  };
 } else {
  defer = function (id) {
   setTimeout(runner(id), 0);
  };
 }
}
module.exports = {
 set: set,
 clear: clear
};

/***/ }),
/* 153 */
/***/ ((module) => {


var $TypeError = TypeError;
module.exports = function (passed, required) {
 if (passed < required)
  throw $TypeError('Not enough arguments');
 return passed;
};

/***/ }),
/* 154 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var userAgent = __w_pdfjs_require__(22);
module.exports = /(?:ipad|iphone|ipod).*applewebkit/i.test(userAgent);

/***/ }),
/* 155 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var bind = __w_pdfjs_require__(90);
var getOwnPropertyDescriptor = (__w_pdfjs_require__(59).f);
var macrotask = (__w_pdfjs_require__(152).set);
var Queue = __w_pdfjs_require__(156);
var IS_IOS = __w_pdfjs_require__(154);
var IS_IOS_PEBBLE = __w_pdfjs_require__(157);
var IS_WEBOS_WEBKIT = __w_pdfjs_require__(158);
var IS_NODE = __w_pdfjs_require__(147);
var MutationObserver = global.MutationObserver || global.WebKitMutationObserver;
var document = global.document;
var process = global.process;
var Promise = global.Promise;
var queueMicrotaskDescriptor = getOwnPropertyDescriptor(global, 'queueMicrotask');
var microtask = queueMicrotaskDescriptor && queueMicrotaskDescriptor.value;
var notify, toggle, node, promise, then;
if (!microtask) {
 var queue = new Queue();
 var flush = function () {
  var parent, fn;
  if (IS_NODE && (parent = process.domain))
   parent.exit();
  while (fn = queue.get())
   try {
    fn();
   } catch (error) {
    if (queue.head)
     notify();
    throw error;
   }
  if (parent)
   parent.enter();
 };
 if (!IS_IOS && !IS_NODE && !IS_WEBOS_WEBKIT && MutationObserver && document) {
  toggle = true;
  node = document.createTextNode('');
  new MutationObserver(flush).observe(node, { characterData: true });
  notify = function () {
   node.data = toggle = !toggle;
  };
 } else if (!IS_IOS_PEBBLE && Promise && Promise.resolve) {
  promise = Promise.resolve(undefined);
  promise.constructor = Promise;
  then = bind(promise.then, promise);
  notify = function () {
   then(flush);
  };
 } else if (IS_NODE) {
  notify = function () {
   process.nextTick(flush);
  };
 } else {
  macrotask = bind(macrotask, global);
  notify = function () {
   macrotask(flush);
  };
 }
 microtask = function (fn) {
  if (!queue.head)
   notify();
  queue.add(fn);
 };
}
module.exports = microtask;

/***/ }),
/* 156 */
/***/ ((module) => {


var Queue = function () {
 this.head = null;
 this.tail = null;
};
Queue.prototype = {
 add: function (item) {
  var entry = {
   item: item,
   next: null
  };
  var tail = this.tail;
  if (tail)
   tail.next = entry;
  else
   this.head = entry;
  this.tail = entry;
 },
 get: function () {
  var entry = this.head;
  if (entry) {
   var next = this.head = entry.next;
   if (next === null)
    this.tail = null;
   return entry.item;
  }
 }
};
module.exports = Queue;

/***/ }),
/* 157 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var userAgent = __w_pdfjs_require__(22);
module.exports = /ipad|iphone|ipod/i.test(userAgent) && typeof Pebble != 'undefined';

/***/ }),
/* 158 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var userAgent = __w_pdfjs_require__(22);
module.exports = /web0s(?!.*chrome)/i.test(userAgent);

/***/ }),
/* 159 */
/***/ ((module) => {


module.exports = function (a, b) {
 try {
  arguments.length == 1 ? console.error(a) : console.error(a, b);
 } catch (error) {
 }
};

/***/ }),
/* 160 */
/***/ ((module) => {


module.exports = function (exec) {
 try {
  return {
   error: false,
   value: exec()
  };
 } catch (error) {
  return {
   error: true,
   value: error
  };
 }
};

/***/ }),
/* 161 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
module.exports = global.Promise;

/***/ }),
/* 162 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var NativePromiseConstructor = __w_pdfjs_require__(161);
var isCallable = __w_pdfjs_require__(29);
var isForced = __w_pdfjs_require__(76);
var inspectSource = __w_pdfjs_require__(47);
var wellKnownSymbol = __w_pdfjs_require__(14);
var IS_BROWSER = __w_pdfjs_require__(163);
var IS_DENO = __w_pdfjs_require__(164);
var IS_PURE = __w_pdfjs_require__(16);
var V8_VERSION = __w_pdfjs_require__(21);
var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;
var SPECIES = wellKnownSymbol('species');
var SUBCLASSING = false;
var NATIVE_PROMISE_REJECTION_EVENT = isCallable(global.PromiseRejectionEvent);
var FORCED_PROMISE_CONSTRUCTOR = isForced('Promise', function () {
 var PROMISE_CONSTRUCTOR_SOURCE = inspectSource(NativePromiseConstructor);
 var GLOBAL_CORE_JS_PROMISE = PROMISE_CONSTRUCTOR_SOURCE !== String(NativePromiseConstructor);
 if (!GLOBAL_CORE_JS_PROMISE && V8_VERSION === 66)
  return true;
 if (IS_PURE && !(NativePromisePrototype['catch'] && NativePromisePrototype['finally']))
  return true;
 if (!V8_VERSION || V8_VERSION < 51 || !/native code/.test(PROMISE_CONSTRUCTOR_SOURCE)) {
  var promise = new NativePromiseConstructor(function (resolve) {
   resolve(1);
  });
  var FakePromise = function (exec) {
   exec(function () {
   }, function () {
   });
  };
  var constructor = promise.constructor = {};
  constructor[SPECIES] = FakePromise;
  SUBCLASSING = promise.then(function () {
  }) instanceof FakePromise;
  if (!SUBCLASSING)
   return true;
 }
 return !GLOBAL_CORE_JS_PROMISE && (IS_BROWSER || IS_DENO) && !NATIVE_PROMISE_REJECTION_EVENT;
});
module.exports = {
 CONSTRUCTOR: FORCED_PROMISE_CONSTRUCTOR,
 REJECTION_EVENT: NATIVE_PROMISE_REJECTION_EVENT,
 SUBCLASSING: SUBCLASSING
};

/***/ }),
/* 163 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var IS_DENO = __w_pdfjs_require__(164);
var IS_NODE = __w_pdfjs_require__(147);
module.exports = !IS_DENO && !IS_NODE && typeof window == 'object' && typeof document == 'object';

/***/ }),
/* 164 */
/***/ ((module) => {


module.exports = typeof Deno == 'object' && Deno && typeof Deno.version == 'object';

/***/ }),
/* 165 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var aCallable = __w_pdfjs_require__(40);
var $TypeError = TypeError;
var PromiseCapability = function (C) {
 var resolve, reject;
 this.promise = new C(function ($$resolve, $$reject) {
  if (resolve !== undefined || reject !== undefined)
   throw $TypeError('Bad Promise constructor');
  resolve = $$resolve;
  reject = $$reject;
 });
 this.resolve = aCallable(resolve);
 this.reject = aCallable(reject);
};
module.exports.f = function (C) {
 return new PromiseCapability(C);
};

/***/ }),
/* 166 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var call = __w_pdfjs_require__(35);
var aCallable = __w_pdfjs_require__(40);
var newPromiseCapabilityModule = __w_pdfjs_require__(165);
var perform = __w_pdfjs_require__(160);
var iterate = __w_pdfjs_require__(167);
var PROMISE_STATICS_INCORRECT_ITERATION = __w_pdfjs_require__(168);
$({
 target: 'Promise',
 stat: true,
 forced: PROMISE_STATICS_INCORRECT_ITERATION
}, {
 all: function all(iterable) {
  var C = this;
  var capability = newPromiseCapabilityModule.f(C);
  var resolve = capability.resolve;
  var reject = capability.reject;
  var result = perform(function () {
   var $promiseResolve = aCallable(C.resolve);
   var values = [];
   var counter = 0;
   var remaining = 1;
   iterate(iterable, function (promise) {
    var index = counter++;
    var alreadyCalled = false;
    remaining++;
    call($promiseResolve, C, promise).then(function (value) {
     if (alreadyCalled)
      return;
     alreadyCalled = true;
     values[index] = value;
     --remaining || resolve(values);
    }, reject);
   });
   --remaining || resolve(values);
  });
  if (result.error)
   reject(result.value);
  return capability.promise;
 }
});

/***/ }),
/* 167 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var bind = __w_pdfjs_require__(90);
var call = __w_pdfjs_require__(35);
var anObject = __w_pdfjs_require__(32);
var tryToString = __w_pdfjs_require__(41);
var isArrayIteratorMethod = __w_pdfjs_require__(118);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var isPrototypeOf = __w_pdfjs_require__(38);
var getIterator = __w_pdfjs_require__(120);
var getIteratorMethod = __w_pdfjs_require__(121);
var iteratorClose = __w_pdfjs_require__(117);
var $TypeError = TypeError;
var Result = function (stopped, result) {
 this.stopped = stopped;
 this.result = result;
};
var ResultPrototype = Result.prototype;
module.exports = function (iterable, unboundFunction, options) {
 var that = options && options.that;
 var AS_ENTRIES = !!(options && options.AS_ENTRIES);
 var IS_RECORD = !!(options && options.IS_RECORD);
 var IS_ITERATOR = !!(options && options.IS_ITERATOR);
 var INTERRUPTED = !!(options && options.INTERRUPTED);
 var fn = bind(unboundFunction, that);
 var iterator, iterFn, index, length, result, next, step;
 var stop = function (condition) {
  if (iterator)
   iteratorClose(iterator, 'normal', condition);
  return new Result(true, condition);
 };
 var callFn = function (value) {
  if (AS_ENTRIES) {
   anObject(value);
   return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
  }
  return INTERRUPTED ? fn(value, stop) : fn(value);
 };
 if (IS_RECORD) {
  iterator = iterable.iterator;
 } else if (IS_ITERATOR) {
  iterator = iterable;
 } else {
  iterFn = getIteratorMethod(iterable);
  if (!iterFn)
   throw $TypeError(tryToString(iterable) + ' is not iterable');
  if (isArrayIteratorMethod(iterFn)) {
   for (index = 0, length = lengthOfArrayLike(iterable); length > index; index++) {
    result = callFn(iterable[index]);
    if (result && isPrototypeOf(ResultPrototype, result))
     return result;
   }
   return new Result(false);
  }
  iterator = getIterator(iterable, iterFn);
 }
 next = IS_RECORD ? iterable.next : iterator.next;
 while (!(step = call(next, iterator)).done) {
  try {
   result = callFn(step.value);
  } catch (error) {
   iteratorClose(iterator, 'throw', error);
  }
  if (typeof result == 'object' && result && isPrototypeOf(ResultPrototype, result))
   return result;
 }
 return new Result(false);
};

/***/ }),
/* 168 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var NativePromiseConstructor = __w_pdfjs_require__(161);
var checkCorrectnessOfIteration = __w_pdfjs_require__(122);
var FORCED_PROMISE_CONSTRUCTOR = (__w_pdfjs_require__(162).CONSTRUCTOR);
module.exports = FORCED_PROMISE_CONSTRUCTOR || !checkCorrectnessOfIteration(function (iterable) {
 NativePromiseConstructor.all(iterable).then(undefined, function () {
 });
});

/***/ }),
/* 169 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var IS_PURE = __w_pdfjs_require__(16);
var FORCED_PROMISE_CONSTRUCTOR = (__w_pdfjs_require__(162).CONSTRUCTOR);
var NativePromiseConstructor = __w_pdfjs_require__(161);
var getBuiltIn = __w_pdfjs_require__(37);
var isCallable = __w_pdfjs_require__(29);
var defineBuiltIn = __w_pdfjs_require__(44);
var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;
$({
 target: 'Promise',
 proto: true,
 forced: FORCED_PROMISE_CONSTRUCTOR,
 real: true
}, {
 'catch': function (onRejected) {
  return this.then(undefined, onRejected);
 }
});
if (!IS_PURE && isCallable(NativePromiseConstructor)) {
 var method = getBuiltIn('Promise').prototype['catch'];
 if (NativePromisePrototype['catch'] !== method) {
  defineBuiltIn(NativePromisePrototype, 'catch', method, { unsafe: true });
 }
}

/***/ }),
/* 170 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var call = __w_pdfjs_require__(35);
var aCallable = __w_pdfjs_require__(40);
var newPromiseCapabilityModule = __w_pdfjs_require__(165);
var perform = __w_pdfjs_require__(160);
var iterate = __w_pdfjs_require__(167);
var PROMISE_STATICS_INCORRECT_ITERATION = __w_pdfjs_require__(168);
$({
 target: 'Promise',
 stat: true,
 forced: PROMISE_STATICS_INCORRECT_ITERATION
}, {
 race: function race(iterable) {
  var C = this;
  var capability = newPromiseCapabilityModule.f(C);
  var reject = capability.reject;
  var result = perform(function () {
   var $promiseResolve = aCallable(C.resolve);
   iterate(iterable, function (promise) {
    call($promiseResolve, C, promise).then(capability.resolve, reject);
   });
  });
  if (result.error)
   reject(result.value);
  return capability.promise;
 }
});

/***/ }),
/* 171 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var call = __w_pdfjs_require__(35);
var newPromiseCapabilityModule = __w_pdfjs_require__(165);
var FORCED_PROMISE_CONSTRUCTOR = (__w_pdfjs_require__(162).CONSTRUCTOR);
$({
 target: 'Promise',
 stat: true,
 forced: FORCED_PROMISE_CONSTRUCTOR
}, {
 reject: function reject(r) {
  var capability = newPromiseCapabilityModule.f(this);
  call(capability.reject, undefined, r);
  return capability.promise;
 }
});

/***/ }),
/* 172 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var getBuiltIn = __w_pdfjs_require__(37);
var IS_PURE = __w_pdfjs_require__(16);
var NativePromiseConstructor = __w_pdfjs_require__(161);
var FORCED_PROMISE_CONSTRUCTOR = (__w_pdfjs_require__(162).CONSTRUCTOR);
var promiseResolve = __w_pdfjs_require__(173);
var PromiseConstructorWrapper = getBuiltIn('Promise');
var CHECK_WRAPPER = IS_PURE && !FORCED_PROMISE_CONSTRUCTOR;
$({
 target: 'Promise',
 stat: true,
 forced: IS_PURE || FORCED_PROMISE_CONSTRUCTOR
}, {
 resolve: function resolve(x) {
  return promiseResolve(CHECK_WRAPPER && this === PromiseConstructorWrapper ? NativePromiseConstructor : this, x);
 }
});

/***/ }),
/* 173 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var anObject = __w_pdfjs_require__(32);
var isObject = __w_pdfjs_require__(28);
var newPromiseCapability = __w_pdfjs_require__(165);
module.exports = function (C, x) {
 anObject(C);
 if (isObject(x) && x.constructor === C)
  return x;
 var promiseCapability = newPromiseCapability.f(C);
 var resolve = promiseCapability.resolve;
 resolve(x);
 return promiseCapability.promise;
};

/***/ }),
/* 174 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var call = __w_pdfjs_require__(35);
var aCallable = __w_pdfjs_require__(40);
var newPromiseCapabilityModule = __w_pdfjs_require__(165);
var perform = __w_pdfjs_require__(160);
var iterate = __w_pdfjs_require__(167);
var PROMISE_STATICS_INCORRECT_ITERATION = __w_pdfjs_require__(168);
$({
 target: 'Promise',
 stat: true,
 forced: PROMISE_STATICS_INCORRECT_ITERATION
}, {
 allSettled: function allSettled(iterable) {
  var C = this;
  var capability = newPromiseCapabilityModule.f(C);
  var resolve = capability.resolve;
  var reject = capability.reject;
  var result = perform(function () {
   var promiseResolve = aCallable(C.resolve);
   var values = [];
   var counter = 0;
   var remaining = 1;
   iterate(iterable, function (promise) {
    var index = counter++;
    var alreadyCalled = false;
    remaining++;
    call(promiseResolve, C, promise).then(function (value) {
     if (alreadyCalled)
      return;
     alreadyCalled = true;
     values[index] = {
      status: 'fulfilled',
      value: value
     };
     --remaining || resolve(values);
    }, function (error) {
     if (alreadyCalled)
      return;
     alreadyCalled = true;
     values[index] = {
      status: 'rejected',
      reason: error
     };
     --remaining || resolve(values);
    });
   });
   --remaining || resolve(values);
  });
  if (result.error)
   reject(result.value);
  return capability.promise;
 }
});

/***/ }),
/* 175 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var charAt = (__w_pdfjs_require__(176).charAt);
var toString = __w_pdfjs_require__(77);
var InternalStateModule = __w_pdfjs_require__(48);
var defineIterator = __w_pdfjs_require__(139);
var createIterResultObject = __w_pdfjs_require__(142);
var STRING_ITERATOR = 'String Iterator';
var setInternalState = InternalStateModule.set;
var getInternalState = InternalStateModule.getterFor(STRING_ITERATOR);
defineIterator(String, 'String', function (iterated) {
 setInternalState(this, {
  type: STRING_ITERATOR,
  string: toString(iterated),
  index: 0
 });
}, function next() {
 var state = getInternalState(this);
 var string = state.string;
 var index = state.index;
 var point;
 if (index >= string.length)
  return createIterResultObject(undefined, true);
 point = charAt(string, index);
 state.index += point.length;
 return createIterResultObject(point, false);
});

/***/ }),
/* 176 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var toIntegerOrInfinity = __w_pdfjs_require__(70);
var toString = __w_pdfjs_require__(77);
var requireObjectCoercible = __w_pdfjs_require__(11);
var charAt = uncurryThis(''.charAt);
var charCodeAt = uncurryThis(''.charCodeAt);
var stringSlice = uncurryThis(''.slice);
var createMethod = function (CONVERT_TO_STRING) {
 return function ($this, pos) {
  var S = toString(requireObjectCoercible($this));
  var position = toIntegerOrInfinity(pos);
  var size = S.length;
  var first, second;
  if (position < 0 || position >= size)
   return CONVERT_TO_STRING ? '' : undefined;
  first = charCodeAt(S, position);
  return first < 0xD800 || first > 0xDBFF || position + 1 === size || (second = charCodeAt(S, position + 1)) < 0xDC00 || second > 0xDFFF ? CONVERT_TO_STRING ? charAt(S, position) : first : CONVERT_TO_STRING ? stringSlice(S, position, position + 2) : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
 };
};
module.exports = {
 codeAt: createMethod(false),
 charAt: createMethod(true)
};

/***/ }),
/* 177 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var DOMIterables = __w_pdfjs_require__(178);
var DOMTokenListPrototype = __w_pdfjs_require__(179);
var ArrayIteratorMethods = __w_pdfjs_require__(137);
var createNonEnumerableProperty = __w_pdfjs_require__(50);
var wellKnownSymbol = __w_pdfjs_require__(14);
var ITERATOR = wellKnownSymbol('iterator');
var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var ArrayValues = ArrayIteratorMethods.values;
var handlePrototype = function (CollectionPrototype, COLLECTION_NAME) {
 if (CollectionPrototype) {
  if (CollectionPrototype[ITERATOR] !== ArrayValues)
   try {
    createNonEnumerableProperty(CollectionPrototype, ITERATOR, ArrayValues);
   } catch (error) {
    CollectionPrototype[ITERATOR] = ArrayValues;
   }
  if (!CollectionPrototype[TO_STRING_TAG]) {
   createNonEnumerableProperty(CollectionPrototype, TO_STRING_TAG, COLLECTION_NAME);
  }
  if (DOMIterables[COLLECTION_NAME])
   for (var METHOD_NAME in ArrayIteratorMethods) {
    if (CollectionPrototype[METHOD_NAME] !== ArrayIteratorMethods[METHOD_NAME])
     try {
      createNonEnumerableProperty(CollectionPrototype, METHOD_NAME, ArrayIteratorMethods[METHOD_NAME]);
     } catch (error) {
      CollectionPrototype[METHOD_NAME] = ArrayIteratorMethods[METHOD_NAME];
     }
   }
 }
};
for (var COLLECTION_NAME in DOMIterables) {
 handlePrototype(global[COLLECTION_NAME] && global[COLLECTION_NAME].prototype, COLLECTION_NAME);
}
handlePrototype(DOMTokenListPrototype, 'DOMTokenList');

/***/ }),
/* 178 */
/***/ ((module) => {


module.exports = {
 CSSRuleList: 0,
 CSSStyleDeclaration: 0,
 CSSValueList: 0,
 ClientRectList: 0,
 DOMRectList: 0,
 DOMStringList: 0,
 DOMTokenList: 1,
 DataTransferItemList: 0,
 FileList: 0,
 HTMLAllCollection: 0,
 HTMLCollection: 0,
 HTMLFormElement: 0,
 HTMLSelectElement: 0,
 MediaList: 0,
 MimeTypeArray: 0,
 NamedNodeMap: 0,
 NodeList: 1,
 PaintRequestList: 0,
 Plugin: 0,
 PluginArray: 0,
 SVGLengthList: 0,
 SVGNumberList: 0,
 SVGPathSegList: 0,
 SVGPointList: 0,
 SVGStringList: 0,
 SVGTransformList: 0,
 SourceBufferList: 0,
 StyleSheetList: 0,
 TextTrackCueList: 0,
 TextTrackList: 0,
 TouchList: 0
};

/***/ }),
/* 179 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var documentCreateElement = __w_pdfjs_require__(27);
var classList = documentCreateElement('span').classList;
var DOMTokenListPrototype = classList && classList.constructor && classList.constructor.prototype;
module.exports = DOMTokenListPrototype === Object.prototype ? undefined : DOMTokenListPrototype;

/***/ }),
/* 180 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var $map = (__w_pdfjs_require__(89).map);
var arrayMethodHasSpeciesSupport = __w_pdfjs_require__(181);
var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('map');
$({
 target: 'Array',
 proto: true,
 forced: !HAS_SPECIES_SUPPORT
}, {
 map: function map(callbackfn) {
  return $map(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
 }
});

/***/ }),
/* 181 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var fails = __w_pdfjs_require__(9);
var wellKnownSymbol = __w_pdfjs_require__(14);
var V8_VERSION = __w_pdfjs_require__(21);
var SPECIES = wellKnownSymbol('species');
module.exports = function (METHOD_NAME) {
 return V8_VERSION >= 51 || !fails(function () {
  var array = [];
  var constructor = array.constructor = {};
  constructor[SPECIES] = function () {
   return { foo: 1 };
  };
  return array[METHOD_NAME](Boolean).foo !== 1;
 });
};

/***/ }),
/* 182 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var $filter = (__w_pdfjs_require__(89).filter);
var arrayMethodHasSpeciesSupport = __w_pdfjs_require__(181);
var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('filter');
$({
 target: 'Array',
 proto: true,
 forced: !HAS_SPECIES_SUPPORT
}, {
 filter: function filter(callbackfn) {
  return $filter(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
 }
});

/***/ }),
/* 183 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var global = __w_pdfjs_require__(5);
var apply = __w_pdfjs_require__(100);
var wrapErrorConstructorWithCause = __w_pdfjs_require__(184);
var WEB_ASSEMBLY = 'WebAssembly';
var WebAssembly = global[WEB_ASSEMBLY];
var FORCED = Error('e', { cause: 7 }).cause !== 7;
var exportGlobalErrorCauseWrapper = function (ERROR_NAME, wrapper) {
 var O = {};
 O[ERROR_NAME] = wrapErrorConstructorWithCause(ERROR_NAME, wrapper, FORCED);
 $({
  global: true,
  constructor: true,
  arity: 1,
  forced: FORCED
 }, O);
};
var exportWebAssemblyErrorCauseWrapper = function (ERROR_NAME, wrapper) {
 if (WebAssembly && WebAssembly[ERROR_NAME]) {
  var O = {};
  O[ERROR_NAME] = wrapErrorConstructorWithCause(WEB_ASSEMBLY + '.' + ERROR_NAME, wrapper, FORCED);
  $({
   target: WEB_ASSEMBLY,
   stat: true,
   constructor: true,
   arity: 1,
   forced: FORCED
  }, O);
 }
};
exportGlobalErrorCauseWrapper('Error', function (init) {
 return function Error(message) {
  return apply(init, this, arguments);
 };
});
exportGlobalErrorCauseWrapper('EvalError', function (init) {
 return function EvalError(message) {
  return apply(init, this, arguments);
 };
});
exportGlobalErrorCauseWrapper('RangeError', function (init) {
 return function RangeError(message) {
  return apply(init, this, arguments);
 };
});
exportGlobalErrorCauseWrapper('ReferenceError', function (init) {
 return function ReferenceError(message) {
  return apply(init, this, arguments);
 };
});
exportGlobalErrorCauseWrapper('SyntaxError', function (init) {
 return function SyntaxError(message) {
  return apply(init, this, arguments);
 };
});
exportGlobalErrorCauseWrapper('TypeError', function (init) {
 return function TypeError(message) {
  return apply(init, this, arguments);
 };
});
exportGlobalErrorCauseWrapper('URIError', function (init) {
 return function URIError(message) {
  return apply(init, this, arguments);
 };
});
exportWebAssemblyErrorCauseWrapper('CompileError', function (init) {
 return function CompileError(message) {
  return apply(init, this, arguments);
 };
});
exportWebAssemblyErrorCauseWrapper('LinkError', function (init) {
 return function LinkError(message) {
  return apply(init, this, arguments);
 };
});
exportWebAssemblyErrorCauseWrapper('RuntimeError', function (init) {
 return function RuntimeError(message) {
  return apply(init, this, arguments);
 };
});

/***/ }),
/* 184 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var getBuiltIn = __w_pdfjs_require__(37);
var hasOwn = __w_pdfjs_require__(6);
var createNonEnumerableProperty = __w_pdfjs_require__(50);
var isPrototypeOf = __w_pdfjs_require__(38);
var setPrototypeOf = __w_pdfjs_require__(107);
var copyConstructorProperties = __w_pdfjs_require__(64);
var proxyAccessor = __w_pdfjs_require__(185);
var inheritIfRequired = __w_pdfjs_require__(106);
var normalizeStringArgument = __w_pdfjs_require__(186);
var installErrorCause = __w_pdfjs_require__(187);
var installErrorStack = __w_pdfjs_require__(188);
var DESCRIPTORS = __w_pdfjs_require__(25);
var IS_PURE = __w_pdfjs_require__(16);
module.exports = function (FULL_NAME, wrapper, FORCED, IS_AGGREGATE_ERROR) {
 var STACK_TRACE_LIMIT = 'stackTraceLimit';
 var OPTIONS_POSITION = IS_AGGREGATE_ERROR ? 2 : 1;
 var path = FULL_NAME.split('.');
 var ERROR_NAME = path[path.length - 1];
 var OriginalError = getBuiltIn.apply(null, path);
 if (!OriginalError)
  return;
 var OriginalErrorPrototype = OriginalError.prototype;
 if (!IS_PURE && hasOwn(OriginalErrorPrototype, 'cause'))
  delete OriginalErrorPrototype.cause;
 if (!FORCED)
  return OriginalError;
 var BaseError = getBuiltIn('Error');
 var WrappedError = wrapper(function (a, b) {
  var message = normalizeStringArgument(IS_AGGREGATE_ERROR ? b : a, undefined);
  var result = IS_AGGREGATE_ERROR ? new OriginalError(a) : new OriginalError();
  if (message !== undefined)
   createNonEnumerableProperty(result, 'message', message);
  installErrorStack(result, WrappedError, result.stack, 2);
  if (this && isPrototypeOf(OriginalErrorPrototype, this))
   inheritIfRequired(result, this, WrappedError);
  if (arguments.length > OPTIONS_POSITION)
   installErrorCause(result, arguments[OPTIONS_POSITION]);
  return result;
 });
 WrappedError.prototype = OriginalErrorPrototype;
 if (ERROR_NAME !== 'Error') {
  if (setPrototypeOf)
   setPrototypeOf(WrappedError, BaseError);
  else
   copyConstructorProperties(WrappedError, BaseError, { name: true });
 } else if (DESCRIPTORS && STACK_TRACE_LIMIT in OriginalError) {
  proxyAccessor(WrappedError, OriginalError, STACK_TRACE_LIMIT);
  proxyAccessor(WrappedError, OriginalError, 'prepareStackTrace');
 }
 copyConstructorProperties(WrappedError, OriginalError);
 if (!IS_PURE)
  try {
   if (OriginalErrorPrototype.name !== ERROR_NAME) {
    createNonEnumerableProperty(OriginalErrorPrototype, 'name', ERROR_NAME);
   }
   OriginalErrorPrototype.constructor = WrappedError;
  } catch (error) {
  }
 return WrappedError;
};

/***/ }),
/* 185 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var defineProperty = (__w_pdfjs_require__(24).f);
module.exports = function (Target, Source, key) {
 key in Target || defineProperty(Target, key, {
  configurable: true,
  get: function () {
   return Source[key];
  },
  set: function (it) {
   Source[key] = it;
  }
 });
};

/***/ }),
/* 186 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var toString = __w_pdfjs_require__(77);
module.exports = function (argument, $default) {
 return argument === undefined ? arguments.length < 2 ? '' : $default : toString(argument);
};

/***/ }),
/* 187 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var isObject = __w_pdfjs_require__(28);
var createNonEnumerableProperty = __w_pdfjs_require__(50);
module.exports = function (O, options) {
 if (isObject(options) && 'cause' in options) {
  createNonEnumerableProperty(O, 'cause', options.cause);
 }
};

/***/ }),
/* 188 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var createNonEnumerableProperty = __w_pdfjs_require__(50);
var clearErrorStack = __w_pdfjs_require__(189);
var ERROR_STACK_INSTALLABLE = __w_pdfjs_require__(190);
var captureStackTrace = Error.captureStackTrace;
module.exports = function (error, C, stack, dropEntries) {
 if (ERROR_STACK_INSTALLABLE) {
  if (captureStackTrace)
   captureStackTrace(error, C);
  else
   createNonEnumerableProperty(error, 'stack', clearErrorStack(stack, dropEntries));
 }
};

/***/ }),
/* 189 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var $Error = Error;
var replace = uncurryThis(''.replace);
var TEST = function (arg) {
 return String($Error(arg).stack);
}('zxcasd');
var V8_OR_CHAKRA_STACK_ENTRY = /\n\s*at [^:]*:[^\n]*/;
var IS_V8_OR_CHAKRA_STACK = V8_OR_CHAKRA_STACK_ENTRY.test(TEST);
module.exports = function (stack, dropEntries) {
 if (IS_V8_OR_CHAKRA_STACK && typeof stack == 'string' && !$Error.prepareStackTrace) {
  while (dropEntries--)
   stack = replace(stack, V8_OR_CHAKRA_STACK_ENTRY, '');
 }
 return stack;
};

/***/ }),
/* 190 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var fails = __w_pdfjs_require__(9);
var createPropertyDescriptor = __w_pdfjs_require__(51);
module.exports = !fails(function () {
 var error = Error('a');
 if (!('stack' in error))
  return true;
 Object.defineProperty(error, 'stack', createPropertyDescriptor(1, 7));
 return error.stack !== 7;
});

/***/ }),
/* 191 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var createTypedArrayConstructor = __w_pdfjs_require__(192);
createTypedArrayConstructor('Uint8', function (init) {
 return function Uint8Array(data, byteOffset, length) {
  return init(this, data, byteOffset, length);
 };
});

/***/ }),
/* 192 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var global = __w_pdfjs_require__(5);
var call = __w_pdfjs_require__(35);
var DESCRIPTORS = __w_pdfjs_require__(25);
var TYPED_ARRAYS_CONSTRUCTORS_REQUIRES_WRAPPERS = __w_pdfjs_require__(193);
var ArrayBufferViewCore = __w_pdfjs_require__(194);
var ArrayBufferModule = __w_pdfjs_require__(196);
var anInstance = __w_pdfjs_require__(149);
var createPropertyDescriptor = __w_pdfjs_require__(51);
var createNonEnumerableProperty = __w_pdfjs_require__(50);
var isIntegralNumber = __w_pdfjs_require__(201);
var toLength = __w_pdfjs_require__(73);
var toIndex = __w_pdfjs_require__(198);
var toOffset = __w_pdfjs_require__(202);
var toUint8Clamped = __w_pdfjs_require__(204);
var toPropertyKey = __w_pdfjs_require__(33);
var hasOwn = __w_pdfjs_require__(6);
var classof = __w_pdfjs_require__(78);
var isObject = __w_pdfjs_require__(28);
var isSymbol = __w_pdfjs_require__(36);
var create = __w_pdfjs_require__(80);
var isPrototypeOf = __w_pdfjs_require__(38);
var setPrototypeOf = __w_pdfjs_require__(107);
var getOwnPropertyNames = (__w_pdfjs_require__(66).f);
var typedArrayFrom = __w_pdfjs_require__(205);
var forEach = (__w_pdfjs_require__(89).forEach);
var setSpecies = __w_pdfjs_require__(148);
var defineBuiltInAccessor = __w_pdfjs_require__(87);
var definePropertyModule = __w_pdfjs_require__(24);
var getOwnPropertyDescriptorModule = __w_pdfjs_require__(59);
var InternalStateModule = __w_pdfjs_require__(48);
var inheritIfRequired = __w_pdfjs_require__(106);
var getInternalState = InternalStateModule.get;
var setInternalState = InternalStateModule.set;
var enforceInternalState = InternalStateModule.enforce;
var nativeDefineProperty = definePropertyModule.f;
var nativeGetOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
var RangeError = global.RangeError;
var ArrayBuffer = ArrayBufferModule.ArrayBuffer;
var ArrayBufferPrototype = ArrayBuffer.prototype;
var DataView = ArrayBufferModule.DataView;
var NATIVE_ARRAY_BUFFER_VIEWS = ArrayBufferViewCore.NATIVE_ARRAY_BUFFER_VIEWS;
var TYPED_ARRAY_TAG = ArrayBufferViewCore.TYPED_ARRAY_TAG;
var TypedArray = ArrayBufferViewCore.TypedArray;
var TypedArrayPrototype = ArrayBufferViewCore.TypedArrayPrototype;
var aTypedArrayConstructor = ArrayBufferViewCore.aTypedArrayConstructor;
var isTypedArray = ArrayBufferViewCore.isTypedArray;
var BYTES_PER_ELEMENT = 'BYTES_PER_ELEMENT';
var WRONG_LENGTH = 'Wrong length';
var fromList = function (C, list) {
 aTypedArrayConstructor(C);
 var index = 0;
 var length = list.length;
 var result = new C(length);
 while (length > index)
  result[index] = list[index++];
 return result;
};
var addGetter = function (it, key) {
 defineBuiltInAccessor(it, key, {
  configurable: true,
  get: function () {
   return getInternalState(this)[key];
  }
 });
};
var isArrayBuffer = function (it) {
 var klass;
 return isPrototypeOf(ArrayBufferPrototype, it) || (klass = classof(it)) == 'ArrayBuffer' || klass == 'SharedArrayBuffer';
};
var isTypedArrayIndex = function (target, key) {
 return isTypedArray(target) && !isSymbol(key) && key in target && isIntegralNumber(+key) && key >= 0;
};
var wrappedGetOwnPropertyDescriptor = function getOwnPropertyDescriptor(target, key) {
 key = toPropertyKey(key);
 return isTypedArrayIndex(target, key) ? createPropertyDescriptor(2, target[key]) : nativeGetOwnPropertyDescriptor(target, key);
};
var wrappedDefineProperty = function defineProperty(target, key, descriptor) {
 key = toPropertyKey(key);
 if (isTypedArrayIndex(target, key) && isObject(descriptor) && hasOwn(descriptor, 'value') && !hasOwn(descriptor, 'get') && !hasOwn(descriptor, 'set') && !descriptor.configurable && (!hasOwn(descriptor, 'writable') || descriptor.writable) && (!hasOwn(descriptor, 'enumerable') || descriptor.enumerable)) {
  target[key] = descriptor.value;
  return target;
 }
 return nativeDefineProperty(target, key, descriptor);
};
if (DESCRIPTORS) {
 if (!NATIVE_ARRAY_BUFFER_VIEWS) {
  getOwnPropertyDescriptorModule.f = wrappedGetOwnPropertyDescriptor;
  definePropertyModule.f = wrappedDefineProperty;
  addGetter(TypedArrayPrototype, 'buffer');
  addGetter(TypedArrayPrototype, 'byteOffset');
  addGetter(TypedArrayPrototype, 'byteLength');
  addGetter(TypedArrayPrototype, 'length');
 }
 $({
  target: 'Object',
  stat: true,
  forced: !NATIVE_ARRAY_BUFFER_VIEWS
 }, {
  getOwnPropertyDescriptor: wrappedGetOwnPropertyDescriptor,
  defineProperty: wrappedDefineProperty
 });
 module.exports = function (TYPE, wrapper, CLAMPED) {
  var BYTES = TYPE.match(/\d+/)[0] / 8;
  var CONSTRUCTOR_NAME = TYPE + (CLAMPED ? 'Clamped' : '') + 'Array';
  var GETTER = 'get' + TYPE;
  var SETTER = 'set' + TYPE;
  var NativeTypedArrayConstructor = global[CONSTRUCTOR_NAME];
  var TypedArrayConstructor = NativeTypedArrayConstructor;
  var TypedArrayConstructorPrototype = TypedArrayConstructor && TypedArrayConstructor.prototype;
  var exported = {};
  var getter = function (that, index) {
   var data = getInternalState(that);
   return data.view[GETTER](index * BYTES + data.byteOffset, true);
  };
  var setter = function (that, index, value) {
   var data = getInternalState(that);
   data.view[SETTER](index * BYTES + data.byteOffset, CLAMPED ? toUint8Clamped(value) : value, true);
  };
  var addElement = function (that, index) {
   nativeDefineProperty(that, index, {
    get: function () {
     return getter(this, index);
    },
    set: function (value) {
     return setter(this, index, value);
    },
    enumerable: true
   });
  };
  if (!NATIVE_ARRAY_BUFFER_VIEWS) {
   TypedArrayConstructor = wrapper(function (that, data, offset, $length) {
    anInstance(that, TypedArrayConstructorPrototype);
    var index = 0;
    var byteOffset = 0;
    var buffer, byteLength, length;
    if (!isObject(data)) {
     length = toIndex(data);
     byteLength = length * BYTES;
     buffer = new ArrayBuffer(byteLength);
    } else if (isArrayBuffer(data)) {
     buffer = data;
     byteOffset = toOffset(offset, BYTES);
     var $len = data.byteLength;
     if ($length === undefined) {
      if ($len % BYTES)
       throw RangeError(WRONG_LENGTH);
      byteLength = $len - byteOffset;
      if (byteLength < 0)
       throw RangeError(WRONG_LENGTH);
     } else {
      byteLength = toLength($length) * BYTES;
      if (byteLength + byteOffset > $len)
       throw RangeError(WRONG_LENGTH);
     }
     length = byteLength / BYTES;
    } else if (isTypedArray(data)) {
     return fromList(TypedArrayConstructor, data);
    } else {
     return call(typedArrayFrom, TypedArrayConstructor, data);
    }
    setInternalState(that, {
     buffer: buffer,
     byteOffset: byteOffset,
     byteLength: byteLength,
     length: length,
     view: new DataView(buffer)
    });
    while (index < length)
     addElement(that, index++);
   });
   if (setPrototypeOf)
    setPrototypeOf(TypedArrayConstructor, TypedArray);
   TypedArrayConstructorPrototype = TypedArrayConstructor.prototype = create(TypedArrayPrototype);
  } else if (TYPED_ARRAYS_CONSTRUCTORS_REQUIRES_WRAPPERS) {
   TypedArrayConstructor = wrapper(function (dummy, data, typedArrayOffset, $length) {
    anInstance(dummy, TypedArrayConstructorPrototype);
    return inheritIfRequired((function () {
     if (!isObject(data))
      return new NativeTypedArrayConstructor(toIndex(data));
     if (isArrayBuffer(data))
      return $length !== undefined ? new NativeTypedArrayConstructor(data, toOffset(typedArrayOffset, BYTES), $length) : typedArrayOffset !== undefined ? new NativeTypedArrayConstructor(data, toOffset(typedArrayOffset, BYTES)) : new NativeTypedArrayConstructor(data);
     if (isTypedArray(data))
      return fromList(TypedArrayConstructor, data);
     return call(typedArrayFrom, TypedArrayConstructor, data);
    }()), dummy, TypedArrayConstructor);
   });
   if (setPrototypeOf)
    setPrototypeOf(TypedArrayConstructor, TypedArray);
   forEach(getOwnPropertyNames(NativeTypedArrayConstructor), function (key) {
    if (!(key in TypedArrayConstructor)) {
     createNonEnumerableProperty(TypedArrayConstructor, key, NativeTypedArrayConstructor[key]);
    }
   });
   TypedArrayConstructor.prototype = TypedArrayConstructorPrototype;
  }
  if (TypedArrayConstructorPrototype.constructor !== TypedArrayConstructor) {
   createNonEnumerableProperty(TypedArrayConstructorPrototype, 'constructor', TypedArrayConstructor);
  }
  enforceInternalState(TypedArrayConstructorPrototype).TypedArrayConstructor = TypedArrayConstructor;
  if (TYPED_ARRAY_TAG) {
   createNonEnumerableProperty(TypedArrayConstructorPrototype, TYPED_ARRAY_TAG, CONSTRUCTOR_NAME);
  }
  var FORCED = TypedArrayConstructor != NativeTypedArrayConstructor;
  exported[CONSTRUCTOR_NAME] = TypedArrayConstructor;
  $({
   global: true,
   constructor: true,
   forced: FORCED,
   sham: !NATIVE_ARRAY_BUFFER_VIEWS
  }, exported);
  if (!(BYTES_PER_ELEMENT in TypedArrayConstructor)) {
   createNonEnumerableProperty(TypedArrayConstructor, BYTES_PER_ELEMENT, BYTES);
  }
  if (!(BYTES_PER_ELEMENT in TypedArrayConstructorPrototype)) {
   createNonEnumerableProperty(TypedArrayConstructorPrototype, BYTES_PER_ELEMENT, BYTES);
  }
  setSpecies(CONSTRUCTOR_NAME);
 };
} else
 module.exports = function () {
 };

/***/ }),
/* 193 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var fails = __w_pdfjs_require__(9);
var checkCorrectnessOfIteration = __w_pdfjs_require__(122);
var NATIVE_ARRAY_BUFFER_VIEWS = (__w_pdfjs_require__(194).NATIVE_ARRAY_BUFFER_VIEWS);
var ArrayBuffer = global.ArrayBuffer;
var Int8Array = global.Int8Array;
module.exports = !NATIVE_ARRAY_BUFFER_VIEWS || !fails(function () {
 Int8Array(1);
}) || !fails(function () {
 new Int8Array(-1);
}) || !checkCorrectnessOfIteration(function (iterable) {
 new Int8Array();
 new Int8Array(null);
 new Int8Array(1.5);
 new Int8Array(iterable);
}, true) || fails(function () {
 return new Int8Array(new ArrayBuffer(2), 1, undefined).length !== 1;
});

/***/ }),
/* 194 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var NATIVE_ARRAY_BUFFER = __w_pdfjs_require__(195);
var DESCRIPTORS = __w_pdfjs_require__(25);
var global = __w_pdfjs_require__(5);
var isCallable = __w_pdfjs_require__(29);
var isObject = __w_pdfjs_require__(28);
var hasOwn = __w_pdfjs_require__(6);
var classof = __w_pdfjs_require__(78);
var tryToString = __w_pdfjs_require__(41);
var createNonEnumerableProperty = __w_pdfjs_require__(50);
var defineBuiltIn = __w_pdfjs_require__(44);
var defineBuiltInAccessor = __w_pdfjs_require__(87);
var isPrototypeOf = __w_pdfjs_require__(38);
var getPrototypeOf = __w_pdfjs_require__(135);
var setPrototypeOf = __w_pdfjs_require__(107);
var wellKnownSymbol = __w_pdfjs_require__(14);
var uid = __w_pdfjs_require__(19);
var InternalStateModule = __w_pdfjs_require__(48);
var enforceInternalState = InternalStateModule.enforce;
var getInternalState = InternalStateModule.get;
var Int8Array = global.Int8Array;
var Int8ArrayPrototype = Int8Array && Int8Array.prototype;
var Uint8ClampedArray = global.Uint8ClampedArray;
var Uint8ClampedArrayPrototype = Uint8ClampedArray && Uint8ClampedArray.prototype;
var TypedArray = Int8Array && getPrototypeOf(Int8Array);
var TypedArrayPrototype = Int8ArrayPrototype && getPrototypeOf(Int8ArrayPrototype);
var ObjectPrototype = Object.prototype;
var TypeError = global.TypeError;
var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var TYPED_ARRAY_TAG = uid('TYPED_ARRAY_TAG');
var TYPED_ARRAY_CONSTRUCTOR = 'TypedArrayConstructor';
var NATIVE_ARRAY_BUFFER_VIEWS = NATIVE_ARRAY_BUFFER && !!setPrototypeOf && classof(global.opera) !== 'Opera';
var TYPED_ARRAY_TAG_REQUIRED = false;
var NAME, Constructor, Prototype;
var TypedArrayConstructorsList = {
 Int8Array: 1,
 Uint8Array: 1,
 Uint8ClampedArray: 1,
 Int16Array: 2,
 Uint16Array: 2,
 Int32Array: 4,
 Uint32Array: 4,
 Float32Array: 4,
 Float64Array: 8
};
var BigIntArrayConstructorsList = {
 BigInt64Array: 8,
 BigUint64Array: 8
};
var isView = function isView(it) {
 if (!isObject(it))
  return false;
 var klass = classof(it);
 return klass === 'DataView' || hasOwn(TypedArrayConstructorsList, klass) || hasOwn(BigIntArrayConstructorsList, klass);
};
var getTypedArrayConstructor = function (it) {
 var proto = getPrototypeOf(it);
 if (!isObject(proto))
  return;
 var state = getInternalState(proto);
 return state && hasOwn(state, TYPED_ARRAY_CONSTRUCTOR) ? state[TYPED_ARRAY_CONSTRUCTOR] : getTypedArrayConstructor(proto);
};
var isTypedArray = function (it) {
 if (!isObject(it))
  return false;
 var klass = classof(it);
 return hasOwn(TypedArrayConstructorsList, klass) || hasOwn(BigIntArrayConstructorsList, klass);
};
var aTypedArray = function (it) {
 if (isTypedArray(it))
  return it;
 throw TypeError('Target is not a typed array');
};
var aTypedArrayConstructor = function (C) {
 if (isCallable(C) && (!setPrototypeOf || isPrototypeOf(TypedArray, C)))
  return C;
 throw TypeError(tryToString(C) + ' is not a typed array constructor');
};
var exportTypedArrayMethod = function (KEY, property, forced, options) {
 if (!DESCRIPTORS)
  return;
 if (forced)
  for (var ARRAY in TypedArrayConstructorsList) {
   var TypedArrayConstructor = global[ARRAY];
   if (TypedArrayConstructor && hasOwn(TypedArrayConstructor.prototype, KEY))
    try {
     delete TypedArrayConstructor.prototype[KEY];
    } catch (error) {
     try {
      TypedArrayConstructor.prototype[KEY] = property;
     } catch (error2) {
     }
    }
  }
 if (!TypedArrayPrototype[KEY] || forced) {
  defineBuiltIn(TypedArrayPrototype, KEY, forced ? property : NATIVE_ARRAY_BUFFER_VIEWS && Int8ArrayPrototype[KEY] || property, options);
 }
};
var exportTypedArrayStaticMethod = function (KEY, property, forced) {
 var ARRAY, TypedArrayConstructor;
 if (!DESCRIPTORS)
  return;
 if (setPrototypeOf) {
  if (forced)
   for (ARRAY in TypedArrayConstructorsList) {
    TypedArrayConstructor = global[ARRAY];
    if (TypedArrayConstructor && hasOwn(TypedArrayConstructor, KEY))
     try {
      delete TypedArrayConstructor[KEY];
     } catch (error) {
     }
   }
  if (!TypedArray[KEY] || forced) {
   try {
    return defineBuiltIn(TypedArray, KEY, forced ? property : NATIVE_ARRAY_BUFFER_VIEWS && TypedArray[KEY] || property);
   } catch (error) {
   }
  } else
   return;
 }
 for (ARRAY in TypedArrayConstructorsList) {
  TypedArrayConstructor = global[ARRAY];
  if (TypedArrayConstructor && (!TypedArrayConstructor[KEY] || forced)) {
   defineBuiltIn(TypedArrayConstructor, KEY, property);
  }
 }
};
for (NAME in TypedArrayConstructorsList) {
 Constructor = global[NAME];
 Prototype = Constructor && Constructor.prototype;
 if (Prototype)
  enforceInternalState(Prototype)[TYPED_ARRAY_CONSTRUCTOR] = Constructor;
 else
  NATIVE_ARRAY_BUFFER_VIEWS = false;
}
for (NAME in BigIntArrayConstructorsList) {
 Constructor = global[NAME];
 Prototype = Constructor && Constructor.prototype;
 if (Prototype)
  enforceInternalState(Prototype)[TYPED_ARRAY_CONSTRUCTOR] = Constructor;
}
if (!NATIVE_ARRAY_BUFFER_VIEWS || !isCallable(TypedArray) || TypedArray === Function.prototype) {
 TypedArray = function TypedArray() {
  throw TypeError('Incorrect invocation');
 };
 if (NATIVE_ARRAY_BUFFER_VIEWS)
  for (NAME in TypedArrayConstructorsList) {
   if (global[NAME])
    setPrototypeOf(global[NAME], TypedArray);
  }
}
if (!NATIVE_ARRAY_BUFFER_VIEWS || !TypedArrayPrototype || TypedArrayPrototype === ObjectPrototype) {
 TypedArrayPrototype = TypedArray.prototype;
 if (NATIVE_ARRAY_BUFFER_VIEWS)
  for (NAME in TypedArrayConstructorsList) {
   if (global[NAME])
    setPrototypeOf(global[NAME].prototype, TypedArrayPrototype);
  }
}
if (NATIVE_ARRAY_BUFFER_VIEWS && getPrototypeOf(Uint8ClampedArrayPrototype) !== TypedArrayPrototype) {
 setPrototypeOf(Uint8ClampedArrayPrototype, TypedArrayPrototype);
}
if (DESCRIPTORS && !hasOwn(TypedArrayPrototype, TO_STRING_TAG)) {
 TYPED_ARRAY_TAG_REQUIRED = true;
 defineBuiltInAccessor(TypedArrayPrototype, TO_STRING_TAG, {
  configurable: true,
  get: function () {
   return isObject(this) ? this[TYPED_ARRAY_TAG] : undefined;
  }
 });
 for (NAME in TypedArrayConstructorsList)
  if (global[NAME]) {
   createNonEnumerableProperty(global[NAME], TYPED_ARRAY_TAG, NAME);
  }
}
module.exports = {
 NATIVE_ARRAY_BUFFER_VIEWS: NATIVE_ARRAY_BUFFER_VIEWS,
 TYPED_ARRAY_TAG: TYPED_ARRAY_TAG_REQUIRED && TYPED_ARRAY_TAG,
 aTypedArray: aTypedArray,
 aTypedArrayConstructor: aTypedArrayConstructor,
 exportTypedArrayMethod: exportTypedArrayMethod,
 exportTypedArrayStaticMethod: exportTypedArrayStaticMethod,
 getTypedArrayConstructor: getTypedArrayConstructor,
 isView: isView,
 isTypedArray: isTypedArray,
 TypedArray: TypedArray,
 TypedArrayPrototype: TypedArrayPrototype
};

/***/ }),
/* 195 */
/***/ ((module) => {


module.exports = typeof ArrayBuffer != 'undefined' && typeof DataView != 'undefined';

/***/ }),
/* 196 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var uncurryThis = __w_pdfjs_require__(7);
var DESCRIPTORS = __w_pdfjs_require__(25);
var NATIVE_ARRAY_BUFFER = __w_pdfjs_require__(195);
var FunctionName = __w_pdfjs_require__(46);
var createNonEnumerableProperty = __w_pdfjs_require__(50);
var defineBuiltInAccessor = __w_pdfjs_require__(87);
var defineBuiltIns = __w_pdfjs_require__(197);
var fails = __w_pdfjs_require__(9);
var anInstance = __w_pdfjs_require__(149);
var toIntegerOrInfinity = __w_pdfjs_require__(70);
var toLength = __w_pdfjs_require__(73);
var toIndex = __w_pdfjs_require__(198);
var IEEE754 = __w_pdfjs_require__(199);
var getPrototypeOf = __w_pdfjs_require__(135);
var setPrototypeOf = __w_pdfjs_require__(107);
var getOwnPropertyNames = (__w_pdfjs_require__(66).f);
var arrayFill = __w_pdfjs_require__(200);
var arraySlice = __w_pdfjs_require__(85);
var setToStringTag = __w_pdfjs_require__(88);
var InternalStateModule = __w_pdfjs_require__(48);
var PROPER_FUNCTION_NAME = FunctionName.PROPER;
var CONFIGURABLE_FUNCTION_NAME = FunctionName.CONFIGURABLE;
var ARRAY_BUFFER = 'ArrayBuffer';
var DATA_VIEW = 'DataView';
var PROTOTYPE = 'prototype';
var WRONG_LENGTH = 'Wrong length';
var WRONG_INDEX = 'Wrong index';
var getInternalArrayBufferState = InternalStateModule.getterFor(ARRAY_BUFFER);
var getInternalDataViewState = InternalStateModule.getterFor(DATA_VIEW);
var setInternalState = InternalStateModule.set;
var NativeArrayBuffer = global[ARRAY_BUFFER];
var $ArrayBuffer = NativeArrayBuffer;
var ArrayBufferPrototype = $ArrayBuffer && $ArrayBuffer[PROTOTYPE];
var $DataView = global[DATA_VIEW];
var DataViewPrototype = $DataView && $DataView[PROTOTYPE];
var ObjectPrototype = Object.prototype;
var Array = global.Array;
var RangeError = global.RangeError;
var fill = uncurryThis(arrayFill);
var reverse = uncurryThis([].reverse);
var packIEEE754 = IEEE754.pack;
var unpackIEEE754 = IEEE754.unpack;
var packInt8 = function (number) {
 return [number & 0xFF];
};
var packInt16 = function (number) {
 return [
  number & 0xFF,
  number >> 8 & 0xFF
 ];
};
var packInt32 = function (number) {
 return [
  number & 0xFF,
  number >> 8 & 0xFF,
  number >> 16 & 0xFF,
  number >> 24 & 0xFF
 ];
};
var unpackInt32 = function (buffer) {
 return buffer[3] << 24 | buffer[2] << 16 | buffer[1] << 8 | buffer[0];
};
var packFloat32 = function (number) {
 return packIEEE754(number, 23, 4);
};
var packFloat64 = function (number) {
 return packIEEE754(number, 52, 8);
};
var addGetter = function (Constructor, key, getInternalState) {
 defineBuiltInAccessor(Constructor[PROTOTYPE], key, {
  configurable: true,
  get: function () {
   return getInternalState(this)[key];
  }
 });
};
var get = function (view, count, index, isLittleEndian) {
 var store = getInternalDataViewState(view);
 var intIndex = toIndex(index);
 var boolIsLittleEndian = !!isLittleEndian;
 if (intIndex + count > store.byteLength)
  throw RangeError(WRONG_INDEX);
 var bytes = store.bytes;
 var start = intIndex + store.byteOffset;
 var pack = arraySlice(bytes, start, start + count);
 return boolIsLittleEndian ? pack : reverse(pack);
};
var set = function (view, count, index, conversion, value, isLittleEndian) {
 var store = getInternalDataViewState(view);
 var intIndex = toIndex(index);
 var pack = conversion(+value);
 var boolIsLittleEndian = !!isLittleEndian;
 if (intIndex + count > store.byteLength)
  throw RangeError(WRONG_INDEX);
 var bytes = store.bytes;
 var start = intIndex + store.byteOffset;
 for (var i = 0; i < count; i++)
  bytes[start + i] = pack[boolIsLittleEndian ? i : count - i - 1];
};
if (!NATIVE_ARRAY_BUFFER) {
 $ArrayBuffer = function ArrayBuffer(length) {
  anInstance(this, ArrayBufferPrototype);
  var byteLength = toIndex(length);
  setInternalState(this, {
   type: ARRAY_BUFFER,
   bytes: fill(Array(byteLength), 0),
   byteLength: byteLength
  });
  if (!DESCRIPTORS) {
   this.byteLength = byteLength;
   this.detached = false;
  }
 };
 ArrayBufferPrototype = $ArrayBuffer[PROTOTYPE];
 $DataView = function DataView(buffer, byteOffset, byteLength) {
  anInstance(this, DataViewPrototype);
  anInstance(buffer, ArrayBufferPrototype);
  var bufferState = getInternalArrayBufferState(buffer);
  var bufferLength = bufferState.byteLength;
  var offset = toIntegerOrInfinity(byteOffset);
  if (offset < 0 || offset > bufferLength)
   throw RangeError('Wrong offset');
  byteLength = byteLength === undefined ? bufferLength - offset : toLength(byteLength);
  if (offset + byteLength > bufferLength)
   throw RangeError(WRONG_LENGTH);
  setInternalState(this, {
   type: DATA_VIEW,
   buffer: buffer,
   byteLength: byteLength,
   byteOffset: offset,
   bytes: bufferState.bytes
  });
  if (!DESCRIPTORS) {
   this.buffer = buffer;
   this.byteLength = byteLength;
   this.byteOffset = offset;
  }
 };
 DataViewPrototype = $DataView[PROTOTYPE];
 if (DESCRIPTORS) {
  addGetter($ArrayBuffer, 'byteLength', getInternalArrayBufferState);
  addGetter($DataView, 'buffer', getInternalDataViewState);
  addGetter($DataView, 'byteLength', getInternalDataViewState);
  addGetter($DataView, 'byteOffset', getInternalDataViewState);
 }
 defineBuiltIns(DataViewPrototype, {
  getInt8: function getInt8(byteOffset) {
   return get(this, 1, byteOffset)[0] << 24 >> 24;
  },
  getUint8: function getUint8(byteOffset) {
   return get(this, 1, byteOffset)[0];
  },
  getInt16: function getInt16(byteOffset) {
   var bytes = get(this, 2, byteOffset, arguments.length > 1 ? arguments[1] : false);
   return (bytes[1] << 8 | bytes[0]) << 16 >> 16;
  },
  getUint16: function getUint16(byteOffset) {
   var bytes = get(this, 2, byteOffset, arguments.length > 1 ? arguments[1] : false);
   return bytes[1] << 8 | bytes[0];
  },
  getInt32: function getInt32(byteOffset) {
   return unpackInt32(get(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : false));
  },
  getUint32: function getUint32(byteOffset) {
   return unpackInt32(get(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : false)) >>> 0;
  },
  getFloat32: function getFloat32(byteOffset) {
   return unpackIEEE754(get(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : false), 23);
  },
  getFloat64: function getFloat64(byteOffset) {
   return unpackIEEE754(get(this, 8, byteOffset, arguments.length > 1 ? arguments[1] : false), 52);
  },
  setInt8: function setInt8(byteOffset, value) {
   set(this, 1, byteOffset, packInt8, value);
  },
  setUint8: function setUint8(byteOffset, value) {
   set(this, 1, byteOffset, packInt8, value);
  },
  setInt16: function setInt16(byteOffset, value) {
   set(this, 2, byteOffset, packInt16, value, arguments.length > 2 ? arguments[2] : false);
  },
  setUint16: function setUint16(byteOffset, value) {
   set(this, 2, byteOffset, packInt16, value, arguments.length > 2 ? arguments[2] : false);
  },
  setInt32: function setInt32(byteOffset, value) {
   set(this, 4, byteOffset, packInt32, value, arguments.length > 2 ? arguments[2] : false);
  },
  setUint32: function setUint32(byteOffset, value) {
   set(this, 4, byteOffset, packInt32, value, arguments.length > 2 ? arguments[2] : false);
  },
  setFloat32: function setFloat32(byteOffset, value) {
   set(this, 4, byteOffset, packFloat32, value, arguments.length > 2 ? arguments[2] : false);
  },
  setFloat64: function setFloat64(byteOffset, value) {
   set(this, 8, byteOffset, packFloat64, value, arguments.length > 2 ? arguments[2] : false);
  }
 });
} else {
 var INCORRECT_ARRAY_BUFFER_NAME = PROPER_FUNCTION_NAME && NativeArrayBuffer.name !== ARRAY_BUFFER;
 if (!fails(function () {
   NativeArrayBuffer(1);
  }) || !fails(function () {
   new NativeArrayBuffer(-1);
  }) || fails(function () {
   new NativeArrayBuffer();
   new NativeArrayBuffer(1.5);
   new NativeArrayBuffer(NaN);
   return NativeArrayBuffer.length != 1 || INCORRECT_ARRAY_BUFFER_NAME && !CONFIGURABLE_FUNCTION_NAME;
  })) {
  $ArrayBuffer = function ArrayBuffer(length) {
   anInstance(this, ArrayBufferPrototype);
   return new NativeArrayBuffer(toIndex(length));
  };
  $ArrayBuffer[PROTOTYPE] = ArrayBufferPrototype;
  for (var keys = getOwnPropertyNames(NativeArrayBuffer), j = 0, key; keys.length > j;) {
   if (!((key = keys[j++]) in $ArrayBuffer)) {
    createNonEnumerableProperty($ArrayBuffer, key, NativeArrayBuffer[key]);
   }
  }
  ArrayBufferPrototype.constructor = $ArrayBuffer;
 } else if (INCORRECT_ARRAY_BUFFER_NAME && CONFIGURABLE_FUNCTION_NAME) {
  createNonEnumerableProperty(NativeArrayBuffer, 'name', ARRAY_BUFFER);
 }
 if (setPrototypeOf && getPrototypeOf(DataViewPrototype) !== ObjectPrototype) {
  setPrototypeOf(DataViewPrototype, ObjectPrototype);
 }
 var testView = new $DataView(new $ArrayBuffer(2));
 var $setInt8 = uncurryThis(DataViewPrototype.setInt8);
 testView.setInt8(0, 2147483648);
 testView.setInt8(1, 2147483649);
 if (testView.getInt8(0) || !testView.getInt8(1))
  defineBuiltIns(DataViewPrototype, {
   setInt8: function setInt8(byteOffset, value) {
    $setInt8(this, byteOffset, value << 24 >> 24);
   },
   setUint8: function setUint8(byteOffset, value) {
    $setInt8(this, byteOffset, value << 24 >> 24);
   }
  }, { unsafe: true });
}
setToStringTag($ArrayBuffer, ARRAY_BUFFER);
setToStringTag($DataView, DATA_VIEW);
module.exports = {
 ArrayBuffer: $ArrayBuffer,
 DataView: $DataView
};

/***/ }),
/* 197 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var defineBuiltIn = __w_pdfjs_require__(44);
module.exports = function (target, src, options) {
 for (var key in src)
  defineBuiltIn(target, key, src[key], options);
 return target;
};

/***/ }),
/* 198 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var toIntegerOrInfinity = __w_pdfjs_require__(70);
var toLength = __w_pdfjs_require__(73);
var $RangeError = RangeError;
module.exports = function (it) {
 if (it === undefined)
  return 0;
 var number = toIntegerOrInfinity(it);
 var length = toLength(number);
 if (number !== length)
  throw $RangeError('Wrong length or index');
 return length;
};

/***/ }),
/* 199 */
/***/ ((module) => {


var $Array = Array;
var abs = Math.abs;
var pow = Math.pow;
var floor = Math.floor;
var log = Math.log;
var LN2 = Math.LN2;
var pack = function (number, mantissaLength, bytes) {
 var buffer = $Array(bytes);
 var exponentLength = bytes * 8 - mantissaLength - 1;
 var eMax = (1 << exponentLength) - 1;
 var eBias = eMax >> 1;
 var rt = mantissaLength === 23 ? pow(2, -24) - pow(2, -77) : 0;
 var sign = number < 0 || number === 0 && 1 / number < 0 ? 1 : 0;
 var index = 0;
 var exponent, mantissa, c;
 number = abs(number);
 if (number != number || number === Infinity) {
  mantissa = number != number ? 1 : 0;
  exponent = eMax;
 } else {
  exponent = floor(log(number) / LN2);
  c = pow(2, -exponent);
  if (number * c < 1) {
   exponent--;
   c *= 2;
  }
  if (exponent + eBias >= 1) {
   number += rt / c;
  } else {
   number += rt * pow(2, 1 - eBias);
  }
  if (number * c >= 2) {
   exponent++;
   c /= 2;
  }
  if (exponent + eBias >= eMax) {
   mantissa = 0;
   exponent = eMax;
  } else if (exponent + eBias >= 1) {
   mantissa = (number * c - 1) * pow(2, mantissaLength);
   exponent = exponent + eBias;
  } else {
   mantissa = number * pow(2, eBias - 1) * pow(2, mantissaLength);
   exponent = 0;
  }
 }
 while (mantissaLength >= 8) {
  buffer[index++] = mantissa & 255;
  mantissa /= 256;
  mantissaLength -= 8;
 }
 exponent = exponent << mantissaLength | mantissa;
 exponentLength += mantissaLength;
 while (exponentLength > 0) {
  buffer[index++] = exponent & 255;
  exponent /= 256;
  exponentLength -= 8;
 }
 buffer[--index] |= sign * 128;
 return buffer;
};
var unpack = function (buffer, mantissaLength) {
 var bytes = buffer.length;
 var exponentLength = bytes * 8 - mantissaLength - 1;
 var eMax = (1 << exponentLength) - 1;
 var eBias = eMax >> 1;
 var nBits = exponentLength - 7;
 var index = bytes - 1;
 var sign = buffer[index--];
 var exponent = sign & 127;
 var mantissa;
 sign >>= 7;
 while (nBits > 0) {
  exponent = exponent * 256 + buffer[index--];
  nBits -= 8;
 }
 mantissa = exponent & (1 << -nBits) - 1;
 exponent >>= -nBits;
 nBits += mantissaLength;
 while (nBits > 0) {
  mantissa = mantissa * 256 + buffer[index--];
  nBits -= 8;
 }
 if (exponent === 0) {
  exponent = 1 - eBias;
 } else if (exponent === eMax) {
  return mantissa ? NaN : sign ? -Infinity : Infinity;
 } else {
  mantissa = mantissa + pow(2, mantissaLength);
  exponent = exponent - eBias;
 }
 return (sign ? -1 : 1) * mantissa * pow(2, exponent - mantissaLength);
};
module.exports = {
 pack: pack,
 unpack: unpack
};

/***/ }),
/* 200 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var toObject = __w_pdfjs_require__(10);
var toAbsoluteIndex = __w_pdfjs_require__(69);
var lengthOfArrayLike = __w_pdfjs_require__(72);
module.exports = function fill(value) {
 var O = toObject(this);
 var length = lengthOfArrayLike(O);
 var argumentsLength = arguments.length;
 var index = toAbsoluteIndex(argumentsLength > 1 ? arguments[1] : undefined, length);
 var end = argumentsLength > 2 ? arguments[2] : undefined;
 var endPos = end === undefined ? length : toAbsoluteIndex(end, length);
 while (endPos > index)
  O[index++] = value;
 return O;
};

/***/ }),
/* 201 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var isObject = __w_pdfjs_require__(28);
var floor = Math.floor;
module.exports = Number.isInteger || function isInteger(it) {
 return !isObject(it) && isFinite(it) && floor(it) === it;
};

/***/ }),
/* 202 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var toPositiveInteger = __w_pdfjs_require__(203);
var $RangeError = RangeError;
module.exports = function (it, BYTES) {
 var offset = toPositiveInteger(it);
 if (offset % BYTES)
  throw $RangeError('Wrong offset');
 return offset;
};

/***/ }),
/* 203 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var toIntegerOrInfinity = __w_pdfjs_require__(70);
var $RangeError = RangeError;
module.exports = function (it) {
 var result = toIntegerOrInfinity(it);
 if (result < 0)
  throw $RangeError("The argument can't be less than 0");
 return result;
};

/***/ }),
/* 204 */
/***/ ((module) => {


var round = Math.round;
module.exports = function (it) {
 var value = round(it);
 return value < 0 ? 0 : value > 0xFF ? 0xFF : value & 0xFF;
};

/***/ }),
/* 205 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var bind = __w_pdfjs_require__(90);
var call = __w_pdfjs_require__(35);
var aConstructor = __w_pdfjs_require__(151);
var toObject = __w_pdfjs_require__(10);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var getIterator = __w_pdfjs_require__(120);
var getIteratorMethod = __w_pdfjs_require__(121);
var isArrayIteratorMethod = __w_pdfjs_require__(118);
var isBigIntArray = __w_pdfjs_require__(206);
var aTypedArrayConstructor = (__w_pdfjs_require__(194).aTypedArrayConstructor);
var toBigInt = __w_pdfjs_require__(207);
module.exports = function from(source) {
 var C = aConstructor(this);
 var O = toObject(source);
 var argumentsLength = arguments.length;
 var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
 var mapping = mapfn !== undefined;
 var iteratorMethod = getIteratorMethod(O);
 var i, length, result, thisIsBigIntArray, value, step, iterator, next;
 if (iteratorMethod && !isArrayIteratorMethod(iteratorMethod)) {
  iterator = getIterator(O, iteratorMethod);
  next = iterator.next;
  O = [];
  while (!(step = call(next, iterator)).done) {
   O.push(step.value);
  }
 }
 if (mapping && argumentsLength > 2) {
  mapfn = bind(mapfn, arguments[2]);
 }
 length = lengthOfArrayLike(O);
 result = new (aTypedArrayConstructor(C))(length);
 thisIsBigIntArray = isBigIntArray(result);
 for (i = 0; length > i; i++) {
  value = mapping ? mapfn(O[i], i) : O[i];
  result[i] = thisIsBigIntArray ? toBigInt(value) : +value;
 }
 return result;
};

/***/ }),
/* 206 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var classof = __w_pdfjs_require__(78);
module.exports = function (it) {
 var klass = classof(it);
 return klass == 'BigInt64Array' || klass == 'BigUint64Array';
};

/***/ }),
/* 207 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var toPrimitive = __w_pdfjs_require__(34);
var $TypeError = TypeError;
module.exports = function (argument) {
 var prim = toPrimitive(argument, 'number');
 if (typeof prim == 'number')
  throw $TypeError("Can't convert number to bigint");
 return BigInt(prim);
};

/***/ }),
/* 208 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var toIntegerOrInfinity = __w_pdfjs_require__(70);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
exportTypedArrayMethod('at', function at(index) {
 var O = aTypedArray(this);
 var len = lengthOfArrayLike(O);
 var relativeIndex = toIntegerOrInfinity(index);
 var k = relativeIndex >= 0 ? relativeIndex : len + relativeIndex;
 return k < 0 || k >= len ? undefined : O[k];
});

/***/ }),
/* 209 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var ArrayBufferViewCore = __w_pdfjs_require__(194);
var $ArrayCopyWithin = __w_pdfjs_require__(210);
var u$ArrayCopyWithin = uncurryThis($ArrayCopyWithin);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
exportTypedArrayMethod('copyWithin', function copyWithin(target, start) {
 return u$ArrayCopyWithin(aTypedArray(this), target, start, arguments.length > 2 ? arguments[2] : undefined);
});

/***/ }),
/* 210 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var toObject = __w_pdfjs_require__(10);
var toAbsoluteIndex = __w_pdfjs_require__(69);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var deletePropertyOrThrow = __w_pdfjs_require__(211);
var min = Math.min;
module.exports = [].copyWithin || function copyWithin(target, start) {
 var O = toObject(this);
 var len = lengthOfArrayLike(O);
 var to = toAbsoluteIndex(target, len);
 var from = toAbsoluteIndex(start, len);
 var end = arguments.length > 2 ? arguments[2] : undefined;
 var count = min((end === undefined ? len : toAbsoluteIndex(end, len)) - from, len - to);
 var inc = 1;
 if (from < to && to < from + count) {
  inc = -1;
  from += count - 1;
  to += count - 1;
 }
 while (count-- > 0) {
  if (from in O)
   O[to] = O[from];
  else
   deletePropertyOrThrow(O, to);
  to += inc;
  from += inc;
 }
 return O;
};

/***/ }),
/* 211 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var tryToString = __w_pdfjs_require__(41);
var $TypeError = TypeError;
module.exports = function (O, P) {
 if (!delete O[P])
  throw $TypeError('Cannot delete property ' + tryToString(P) + ' of ' + tryToString(O));
};

/***/ }),
/* 212 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var $every = (__w_pdfjs_require__(89).every);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
exportTypedArrayMethod('every', function every(callbackfn) {
 return $every(aTypedArray(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
});

/***/ }),
/* 213 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var $fill = __w_pdfjs_require__(200);
var toBigInt = __w_pdfjs_require__(207);
var classof = __w_pdfjs_require__(78);
var call = __w_pdfjs_require__(35);
var uncurryThis = __w_pdfjs_require__(7);
var fails = __w_pdfjs_require__(9);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
var slice = uncurryThis(''.slice);
var CONVERSION_BUG = fails(function () {
 var count = 0;
 new Int8Array(2).fill({
  valueOf: function () {
   return count++;
  }
 });
 return count !== 1;
});
exportTypedArrayMethod('fill', function fill(value) {
 var length = arguments.length;
 aTypedArray(this);
 var actualValue = slice(classof(this), 0, 3) === 'Big' ? toBigInt(value) : +value;
 return call($fill, this, actualValue, length > 1 ? arguments[1] : undefined, length > 2 ? arguments[2] : undefined);
}, CONVERSION_BUG);

/***/ }),
/* 214 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var $filter = (__w_pdfjs_require__(89).filter);
var fromSpeciesAndList = __w_pdfjs_require__(215);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
exportTypedArrayMethod('filter', function filter(callbackfn) {
 var list = $filter(aTypedArray(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
 return fromSpeciesAndList(this, list);
});

/***/ }),
/* 215 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var arrayFromConstructorAndList = __w_pdfjs_require__(216);
var typedArraySpeciesConstructor = __w_pdfjs_require__(217);
module.exports = function (instance, list) {
 return arrayFromConstructorAndList(typedArraySpeciesConstructor(instance), list);
};

/***/ }),
/* 216 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var lengthOfArrayLike = __w_pdfjs_require__(72);
module.exports = function (Constructor, list) {
 var index = 0;
 var length = lengthOfArrayLike(list);
 var result = new Constructor(length);
 while (length > index)
  result[index] = list[index++];
 return result;
};

/***/ }),
/* 217 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var speciesConstructor = __w_pdfjs_require__(150);
var aTypedArrayConstructor = ArrayBufferViewCore.aTypedArrayConstructor;
var getTypedArrayConstructor = ArrayBufferViewCore.getTypedArrayConstructor;
module.exports = function (originalArray) {
 return aTypedArrayConstructor(speciesConstructor(originalArray, getTypedArrayConstructor(originalArray)));
};

/***/ }),
/* 218 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var $find = (__w_pdfjs_require__(89).find);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
exportTypedArrayMethod('find', function find(predicate) {
 return $find(aTypedArray(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
});

/***/ }),
/* 219 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var $findIndex = (__w_pdfjs_require__(89).findIndex);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
exportTypedArrayMethod('findIndex', function findIndex(predicate) {
 return $findIndex(aTypedArray(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
});

/***/ }),
/* 220 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var $findLast = (__w_pdfjs_require__(221).findLast);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
exportTypedArrayMethod('findLast', function findLast(predicate) {
 return $findLast(aTypedArray(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
});

/***/ }),
/* 221 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var bind = __w_pdfjs_require__(90);
var IndexedObject = __w_pdfjs_require__(62);
var toObject = __w_pdfjs_require__(10);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var createMethod = function (TYPE) {
 var IS_FIND_LAST_INDEX = TYPE == 1;
 return function ($this, callbackfn, that) {
  var O = toObject($this);
  var self = IndexedObject(O);
  var boundFunction = bind(callbackfn, that);
  var index = lengthOfArrayLike(self);
  var value, result;
  while (index-- > 0) {
   value = self[index];
   result = boundFunction(value, index, O);
   if (result)
    switch (TYPE) {
    case 0:
     return value;
    case 1:
     return index;
    }
  }
  return IS_FIND_LAST_INDEX ? -1 : undefined;
 };
};
module.exports = {
 findLast: createMethod(0),
 findLastIndex: createMethod(1)
};

/***/ }),
/* 222 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var $findLastIndex = (__w_pdfjs_require__(221).findLastIndex);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
exportTypedArrayMethod('findLastIndex', function findLastIndex(predicate) {
 return $findLastIndex(aTypedArray(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
});

/***/ }),
/* 223 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var $forEach = (__w_pdfjs_require__(89).forEach);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
exportTypedArrayMethod('forEach', function forEach(callbackfn) {
 $forEach(aTypedArray(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
});

/***/ }),
/* 224 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var $includes = (__w_pdfjs_require__(68).includes);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
exportTypedArrayMethod('includes', function includes(searchElement) {
 return $includes(aTypedArray(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);
});

/***/ }),
/* 225 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var $indexOf = (__w_pdfjs_require__(68).indexOf);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
exportTypedArrayMethod('indexOf', function indexOf(searchElement) {
 return $indexOf(aTypedArray(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);
});

/***/ }),
/* 226 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var fails = __w_pdfjs_require__(9);
var uncurryThis = __w_pdfjs_require__(7);
var ArrayBufferViewCore = __w_pdfjs_require__(194);
var ArrayIterators = __w_pdfjs_require__(137);
var wellKnownSymbol = __w_pdfjs_require__(14);
var ITERATOR = wellKnownSymbol('iterator');
var Uint8Array = global.Uint8Array;
var arrayValues = uncurryThis(ArrayIterators.values);
var arrayKeys = uncurryThis(ArrayIterators.keys);
var arrayEntries = uncurryThis(ArrayIterators.entries);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
var TypedArrayPrototype = Uint8Array && Uint8Array.prototype;
var GENERIC = !fails(function () {
 TypedArrayPrototype[ITERATOR].call([1]);
});
var ITERATOR_IS_VALUES = !!TypedArrayPrototype && TypedArrayPrototype.values && TypedArrayPrototype[ITERATOR] === TypedArrayPrototype.values && TypedArrayPrototype.values.name === 'values';
var typedArrayValues = function values() {
 return arrayValues(aTypedArray(this));
};
exportTypedArrayMethod('entries', function entries() {
 return arrayEntries(aTypedArray(this));
}, GENERIC);
exportTypedArrayMethod('keys', function keys() {
 return arrayKeys(aTypedArray(this));
}, GENERIC);
exportTypedArrayMethod('values', typedArrayValues, GENERIC || !ITERATOR_IS_VALUES, { name: 'values' });
exportTypedArrayMethod(ITERATOR, typedArrayValues, GENERIC || !ITERATOR_IS_VALUES, { name: 'values' });

/***/ }),
/* 227 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var uncurryThis = __w_pdfjs_require__(7);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
var $join = uncurryThis([].join);
exportTypedArrayMethod('join', function join(separator) {
 return $join(aTypedArray(this), separator);
});

/***/ }),
/* 228 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var apply = __w_pdfjs_require__(100);
var $lastIndexOf = __w_pdfjs_require__(229);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
exportTypedArrayMethod('lastIndexOf', function lastIndexOf(searchElement) {
 var length = arguments.length;
 return apply($lastIndexOf, aTypedArray(this), length > 1 ? [
  searchElement,
  arguments[1]
 ] : [searchElement]);
});

/***/ }),
/* 229 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var apply = __w_pdfjs_require__(100);
var toIndexedObject = __w_pdfjs_require__(61);
var toIntegerOrInfinity = __w_pdfjs_require__(70);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var arrayMethodIsStrict = __w_pdfjs_require__(230);
var min = Math.min;
var $lastIndexOf = [].lastIndexOf;
var NEGATIVE_ZERO = !!$lastIndexOf && 1 / [1].lastIndexOf(1, -0) < 0;
var STRICT_METHOD = arrayMethodIsStrict('lastIndexOf');
var FORCED = NEGATIVE_ZERO || !STRICT_METHOD;
module.exports = FORCED ? function lastIndexOf(searchElement) {
 if (NEGATIVE_ZERO)
  return apply($lastIndexOf, this, arguments) || 0;
 var O = toIndexedObject(this);
 var length = lengthOfArrayLike(O);
 var index = length - 1;
 if (arguments.length > 1)
  index = min(index, toIntegerOrInfinity(arguments[1]));
 if (index < 0)
  index = length + index;
 for (; index >= 0; index--)
  if (index in O && O[index] === searchElement)
   return index || 0;
 return -1;
} : $lastIndexOf;

/***/ }),
/* 230 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var fails = __w_pdfjs_require__(9);
module.exports = function (METHOD_NAME, argument) {
 var method = [][METHOD_NAME];
 return !!method && fails(function () {
  method.call(null, argument || function () {
   return 1;
  }, 1);
 });
};

/***/ }),
/* 231 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var $map = (__w_pdfjs_require__(89).map);
var typedArraySpeciesConstructor = __w_pdfjs_require__(217);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
exportTypedArrayMethod('map', function map(mapfn) {
 return $map(aTypedArray(this), mapfn, arguments.length > 1 ? arguments[1] : undefined, function (O, length) {
  return new (typedArraySpeciesConstructor(O))(length);
 });
});

/***/ }),
/* 232 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var $reduce = (__w_pdfjs_require__(233).left);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
exportTypedArrayMethod('reduce', function reduce(callbackfn) {
 var length = arguments.length;
 return $reduce(aTypedArray(this), callbackfn, length, length > 1 ? arguments[1] : undefined);
});

/***/ }),
/* 233 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var aCallable = __w_pdfjs_require__(40);
var toObject = __w_pdfjs_require__(10);
var IndexedObject = __w_pdfjs_require__(62);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var $TypeError = TypeError;
var createMethod = function (IS_RIGHT) {
 return function (that, callbackfn, argumentsLength, memo) {
  aCallable(callbackfn);
  var O = toObject(that);
  var self = IndexedObject(O);
  var length = lengthOfArrayLike(O);
  var index = IS_RIGHT ? length - 1 : 0;
  var i = IS_RIGHT ? -1 : 1;
  if (argumentsLength < 2)
   while (true) {
    if (index in self) {
     memo = self[index];
     index += i;
     break;
    }
    index += i;
    if (IS_RIGHT ? index < 0 : length <= index) {
     throw $TypeError('Reduce of empty array with no initial value');
    }
   }
  for (; IS_RIGHT ? index >= 0 : length > index; index += i)
   if (index in self) {
    memo = callbackfn(memo, self[index], index, O);
   }
  return memo;
 };
};
module.exports = {
 left: createMethod(false),
 right: createMethod(true)
};

/***/ }),
/* 234 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var $reduceRight = (__w_pdfjs_require__(233).right);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
exportTypedArrayMethod('reduceRight', function reduceRight(callbackfn) {
 var length = arguments.length;
 return $reduceRight(aTypedArray(this), callbackfn, length, length > 1 ? arguments[1] : undefined);
});

/***/ }),
/* 235 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
var floor = Math.floor;
exportTypedArrayMethod('reverse', function reverse() {
 var that = this;
 var length = aTypedArray(that).length;
 var middle = floor(length / 2);
 var index = 0;
 var value;
 while (index < middle) {
  value = that[index];
  that[index++] = that[--length];
  that[length] = value;
 }
 return that;
});

/***/ }),
/* 236 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var call = __w_pdfjs_require__(35);
var ArrayBufferViewCore = __w_pdfjs_require__(194);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var toOffset = __w_pdfjs_require__(202);
var toIndexedObject = __w_pdfjs_require__(10);
var fails = __w_pdfjs_require__(9);
var RangeError = global.RangeError;
var Int8Array = global.Int8Array;
var Int8ArrayPrototype = Int8Array && Int8Array.prototype;
var $set = Int8ArrayPrototype && Int8ArrayPrototype.set;
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
var WORKS_WITH_OBJECTS_AND_GENERIC_ON_TYPED_ARRAYS = !fails(function () {
 var array = new Uint8ClampedArray(2);
 call($set, array, {
  length: 1,
  0: 3
 }, 1);
 return array[1] !== 3;
});
var TO_OBJECT_BUG = WORKS_WITH_OBJECTS_AND_GENERIC_ON_TYPED_ARRAYS && ArrayBufferViewCore.NATIVE_ARRAY_BUFFER_VIEWS && fails(function () {
 var array = new Int8Array(2);
 array.set(1);
 array.set('2', 1);
 return array[0] !== 0 || array[1] !== 2;
});
exportTypedArrayMethod('set', function set(arrayLike) {
 aTypedArray(this);
 var offset = toOffset(arguments.length > 1 ? arguments[1] : undefined, 1);
 var src = toIndexedObject(arrayLike);
 if (WORKS_WITH_OBJECTS_AND_GENERIC_ON_TYPED_ARRAYS)
  return call($set, this, src, offset);
 var length = this.length;
 var len = lengthOfArrayLike(src);
 var index = 0;
 if (len + offset > length)
  throw RangeError('Wrong length');
 while (index < len)
  this[offset + index] = src[index++];
}, !WORKS_WITH_OBJECTS_AND_GENERIC_ON_TYPED_ARRAYS || TO_OBJECT_BUG);

/***/ }),
/* 237 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var typedArraySpeciesConstructor = __w_pdfjs_require__(217);
var fails = __w_pdfjs_require__(9);
var arraySlice = __w_pdfjs_require__(101);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
var FORCED = fails(function () {
 new Int8Array(1).slice();
});
exportTypedArrayMethod('slice', function slice(start, end) {
 var list = arraySlice(aTypedArray(this), start, end);
 var C = typedArraySpeciesConstructor(this);
 var index = 0;
 var length = list.length;
 var result = new C(length);
 while (length > index)
  result[index] = list[index++];
 return result;
}, FORCED);

/***/ }),
/* 238 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var $some = (__w_pdfjs_require__(89).some);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
exportTypedArrayMethod('some', function some(callbackfn) {
 return $some(aTypedArray(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
});

/***/ }),
/* 239 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var uncurryThis = __w_pdfjs_require__(91);
var fails = __w_pdfjs_require__(9);
var aCallable = __w_pdfjs_require__(40);
var internalSort = __w_pdfjs_require__(240);
var ArrayBufferViewCore = __w_pdfjs_require__(194);
var FF = __w_pdfjs_require__(241);
var IE_OR_EDGE = __w_pdfjs_require__(242);
var V8 = __w_pdfjs_require__(21);
var WEBKIT = __w_pdfjs_require__(243);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
var Uint16Array = global.Uint16Array;
var nativeSort = Uint16Array && uncurryThis(Uint16Array.prototype.sort);
var ACCEPT_INCORRECT_ARGUMENTS = !!nativeSort && !(fails(function () {
 nativeSort(new Uint16Array(2), null);
}) && fails(function () {
 nativeSort(new Uint16Array(2), {});
}));
var STABLE_SORT = !!nativeSort && !fails(function () {
 if (V8)
  return V8 < 74;
 if (FF)
  return FF < 67;
 if (IE_OR_EDGE)
  return true;
 if (WEBKIT)
  return WEBKIT < 602;
 var array = new Uint16Array(516);
 var expected = Array(516);
 var index, mod;
 for (index = 0; index < 516; index++) {
  mod = index % 4;
  array[index] = 515 - index;
  expected[index] = index - 2 * mod + 3;
 }
 nativeSort(array, function (a, b) {
  return (a / 4 | 0) - (b / 4 | 0);
 });
 for (index = 0; index < 516; index++) {
  if (array[index] !== expected[index])
   return true;
 }
});
var getSortCompare = function (comparefn) {
 return function (x, y) {
  if (comparefn !== undefined)
   return +comparefn(x, y) || 0;
  if (y !== y)
   return -1;
  if (x !== x)
   return 1;
  if (x === 0 && y === 0)
   return 1 / x > 0 && 1 / y < 0 ? 1 : -1;
  return x > y;
 };
};
exportTypedArrayMethod('sort', function sort(comparefn) {
 if (comparefn !== undefined)
  aCallable(comparefn);
 if (STABLE_SORT)
  return nativeSort(this, comparefn);
 return internalSort(aTypedArray(this), getSortCompare(comparefn));
}, !STABLE_SORT || ACCEPT_INCORRECT_ARGUMENTS);

/***/ }),
/* 240 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var arraySlice = __w_pdfjs_require__(85);
var floor = Math.floor;
var mergeSort = function (array, comparefn) {
 var length = array.length;
 var middle = floor(length / 2);
 return length < 8 ? insertionSort(array, comparefn) : merge(array, mergeSort(arraySlice(array, 0, middle), comparefn), mergeSort(arraySlice(array, middle), comparefn), comparefn);
};
var insertionSort = function (array, comparefn) {
 var length = array.length;
 var i = 1;
 var element, j;
 while (i < length) {
  j = i;
  element = array[i];
  while (j && comparefn(array[j - 1], element) > 0) {
   array[j] = array[--j];
  }
  if (j !== i++)
   array[j] = element;
 }
 return array;
};
var merge = function (array, left, right, comparefn) {
 var llength = left.length;
 var rlength = right.length;
 var lindex = 0;
 var rindex = 0;
 while (lindex < llength || rindex < rlength) {
  array[lindex + rindex] = lindex < llength && rindex < rlength ? comparefn(left[lindex], right[rindex]) <= 0 ? left[lindex++] : right[rindex++] : lindex < llength ? left[lindex++] : right[rindex++];
 }
 return array;
};
module.exports = mergeSort;

/***/ }),
/* 241 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var userAgent = __w_pdfjs_require__(22);
var firefox = userAgent.match(/firefox\/(\d+)/i);
module.exports = !!firefox && +firefox[1];

/***/ }),
/* 242 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var UA = __w_pdfjs_require__(22);
module.exports = /MSIE|Trident/.test(UA);

/***/ }),
/* 243 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var userAgent = __w_pdfjs_require__(22);
var webkit = userAgent.match(/AppleWebKit\/(\d+)\./);
module.exports = !!webkit && +webkit[1];

/***/ }),
/* 244 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var apply = __w_pdfjs_require__(100);
var ArrayBufferViewCore = __w_pdfjs_require__(194);
var fails = __w_pdfjs_require__(9);
var arraySlice = __w_pdfjs_require__(101);
var Int8Array = global.Int8Array;
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
var $toLocaleString = [].toLocaleString;
var TO_LOCALE_STRING_BUG = !!Int8Array && fails(function () {
 $toLocaleString.call(new Int8Array(1));
});
var FORCED = fails(function () {
 return [
  1,
  2
 ].toLocaleString() != new Int8Array([
  1,
  2
 ]).toLocaleString();
}) || !fails(function () {
 Int8Array.prototype.toLocaleString.call([
  1,
  2
 ]);
});
exportTypedArrayMethod('toLocaleString', function toLocaleString() {
 return apply($toLocaleString, TO_LOCALE_STRING_BUG ? arraySlice(aTypedArray(this)) : aTypedArray(this), arraySlice(arguments));
}, FORCED);

/***/ }),
/* 245 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var arrayToReversed = __w_pdfjs_require__(246);
var ArrayBufferViewCore = __w_pdfjs_require__(194);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
var getTypedArrayConstructor = ArrayBufferViewCore.getTypedArrayConstructor;
exportTypedArrayMethod('toReversed', function toReversed() {
 return arrayToReversed(aTypedArray(this), getTypedArrayConstructor(this));
});

/***/ }),
/* 246 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var lengthOfArrayLike = __w_pdfjs_require__(72);
module.exports = function (O, C) {
 var len = lengthOfArrayLike(O);
 var A = new C(len);
 var k = 0;
 for (; k < len; k++)
  A[k] = O[len - k - 1];
 return A;
};

/***/ }),
/* 247 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var ArrayBufferViewCore = __w_pdfjs_require__(194);
var uncurryThis = __w_pdfjs_require__(7);
var aCallable = __w_pdfjs_require__(40);
var arrayFromConstructorAndList = __w_pdfjs_require__(216);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var getTypedArrayConstructor = ArrayBufferViewCore.getTypedArrayConstructor;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
var sort = uncurryThis(ArrayBufferViewCore.TypedArrayPrototype.sort);
exportTypedArrayMethod('toSorted', function toSorted(compareFn) {
 if (compareFn !== undefined)
  aCallable(compareFn);
 var O = aTypedArray(this);
 var A = arrayFromConstructorAndList(getTypedArrayConstructor(O), O);
 return sort(A, compareFn);
});

/***/ }),
/* 248 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var exportTypedArrayMethod = (__w_pdfjs_require__(194).exportTypedArrayMethod);
var fails = __w_pdfjs_require__(9);
var global = __w_pdfjs_require__(5);
var uncurryThis = __w_pdfjs_require__(7);
var Uint8Array = global.Uint8Array;
var Uint8ArrayPrototype = Uint8Array && Uint8Array.prototype || {};
var arrayToString = [].toString;
var join = uncurryThis([].join);
if (fails(function () {
  arrayToString.call({});
 })) {
 arrayToString = function toString() {
  return join(this);
 };
}
var IS_NOT_ARRAY_METHOD = Uint8ArrayPrototype.toString != arrayToString;
exportTypedArrayMethod('toString', arrayToString, IS_NOT_ARRAY_METHOD);

/***/ }),
/* 249 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var arrayWith = __w_pdfjs_require__(250);
var ArrayBufferViewCore = __w_pdfjs_require__(194);
var isBigIntArray = __w_pdfjs_require__(206);
var toIntegerOrInfinity = __w_pdfjs_require__(70);
var toBigInt = __w_pdfjs_require__(207);
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var getTypedArrayConstructor = ArrayBufferViewCore.getTypedArrayConstructor;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
var PROPER_ORDER = !!(function () {
 try {
  new Int8Array(1)['with'](2, {
   valueOf: function () {
    throw 8;
   }
  });
 } catch (error) {
  return error === 8;
 }
}());
exportTypedArrayMethod('with', {
 'with': function (index, value) {
  var O = aTypedArray(this);
  var relativeIndex = toIntegerOrInfinity(index);
  var actualValue = isBigIntArray(O) ? toBigInt(value) : +value;
  return arrayWith(O, getTypedArrayConstructor(O), relativeIndex, actualValue);
 }
}['with'], !PROPER_ORDER);

/***/ }),
/* 250 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var lengthOfArrayLike = __w_pdfjs_require__(72);
var toIntegerOrInfinity = __w_pdfjs_require__(70);
var $RangeError = RangeError;
module.exports = function (O, C, index, value) {
 var len = lengthOfArrayLike(O);
 var relativeIndex = toIntegerOrInfinity(index);
 var actualIndex = relativeIndex < 0 ? len + relativeIndex : relativeIndex;
 if (actualIndex >= len || actualIndex < 0)
  throw $RangeError('Incorrect index');
 var A = new C(len);
 var k = 0;
 for (; k < len; k++)
  A[k] = k === actualIndex ? value : O[k];
 return A;
};

/***/ }),
/* 251 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var DESCRIPTORS = __w_pdfjs_require__(25);
var defineBuiltInAccessor = __w_pdfjs_require__(87);
var isDetached = __w_pdfjs_require__(252);
var ArrayBufferPrototype = ArrayBuffer.prototype;
if (DESCRIPTORS && !('detached' in ArrayBufferPrototype)) {
 defineBuiltInAccessor(ArrayBufferPrototype, 'detached', {
  configurable: true,
  get: function detached() {
   return isDetached(this);
  }
 });
}

/***/ }),
/* 252 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var arrayBufferByteLength = __w_pdfjs_require__(253);
var slice = uncurryThis(ArrayBuffer.prototype.slice);
module.exports = function (O) {
 if (arrayBufferByteLength(O) !== 0)
  return false;
 try {
  slice(O, 0, 0);
  return false;
 } catch (error) {
  return true;
 }
};

/***/ }),
/* 253 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThisAccessor = __w_pdfjs_require__(108);
var classof = __w_pdfjs_require__(63);
var $TypeError = TypeError;
module.exports = uncurryThisAccessor(ArrayBuffer.prototype, 'byteLength', 'get') || function (O) {
 if (classof(O) != 'ArrayBuffer')
  throw $TypeError('ArrayBuffer expected');
 return O.byteLength;
};

/***/ }),
/* 254 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var $transfer = __w_pdfjs_require__(255);
if ($transfer)
 $({
  target: 'ArrayBuffer',
  proto: true
 }, {
  transfer: function transfer() {
   return $transfer(this, arguments.length ? arguments[0] : undefined, true);
  }
 });

/***/ }),
/* 255 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var uncurryThis = __w_pdfjs_require__(7);
var uncurryThisAccessor = __w_pdfjs_require__(108);
var toIndex = __w_pdfjs_require__(198);
var isDetached = __w_pdfjs_require__(252);
var arrayBufferByteLength = __w_pdfjs_require__(253);
var PROPER_TRANSFER = __w_pdfjs_require__(256);
var TypeError = global.TypeError;
var structuredClone = global.structuredClone;
var ArrayBuffer = global.ArrayBuffer;
var DataView = global.DataView;
var min = Math.min;
var ArrayBufferPrototype = ArrayBuffer.prototype;
var DataViewPrototype = DataView.prototype;
var slice = uncurryThis(ArrayBufferPrototype.slice);
var isResizable = uncurryThisAccessor(ArrayBufferPrototype, 'resizable', 'get');
var maxByteLength = uncurryThisAccessor(ArrayBufferPrototype, 'maxByteLength', 'get');
var getInt8 = uncurryThis(DataViewPrototype.getInt8);
var setInt8 = uncurryThis(DataViewPrototype.setInt8);
module.exports = PROPER_TRANSFER && function (arrayBuffer, newLength, preserveResizability) {
 var byteLength = arrayBufferByteLength(arrayBuffer);
 var newByteLength = newLength === undefined ? byteLength : toIndex(newLength);
 var fixedLength = !isResizable || !isResizable(arrayBuffer);
 if (isDetached(arrayBuffer))
  throw TypeError('ArrayBuffer is detached');
 var newBuffer = structuredClone(arrayBuffer, { transfer: [arrayBuffer] });
 if (byteLength == newByteLength && (preserveResizability || fixedLength))
  return newBuffer;
 if (byteLength >= newByteLength && (!preserveResizability || fixedLength))
  return slice(newBuffer, 0, newByteLength);
 var options = preserveResizability && !fixedLength && maxByteLength ? { maxByteLength: maxByteLength(newBuffer) } : undefined;
 var newNewBuffer = new ArrayBuffer(newByteLength, options);
 var a = new DataView(newBuffer);
 var b = new DataView(newNewBuffer);
 var copyLength = min(newByteLength, byteLength);
 for (var i = 0; i < copyLength; i++)
  setInt8(b, i, getInt8(a, i));
 return newNewBuffer;
};

/***/ }),
/* 256 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var fails = __w_pdfjs_require__(9);
var V8 = __w_pdfjs_require__(21);
var IS_BROWSER = __w_pdfjs_require__(163);
var IS_DENO = __w_pdfjs_require__(164);
var IS_NODE = __w_pdfjs_require__(147);
var structuredClone = global.structuredClone;
module.exports = !!structuredClone && !fails(function () {
 if (IS_DENO && V8 > 92 || IS_NODE && V8 > 94 || IS_BROWSER && V8 > 97)
  return false;
 var buffer = new ArrayBuffer(8);
 var clone = structuredClone(buffer, { transfer: [buffer] });
 return buffer.byteLength != 0 || clone.byteLength != 8;
});

/***/ }),
/* 257 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var $transfer = __w_pdfjs_require__(255);
if ($transfer)
 $({
  target: 'ArrayBuffer',
  proto: true
 }, {
  transferToFixedLength: function transferToFixedLength() {
   return $transfer(this, arguments.length ? arguments[0] : undefined, false);
  }
 });

/***/ }),
/* 258 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


__w_pdfjs_require__(259);

/***/ }),
/* 259 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var collection = __w_pdfjs_require__(260);
var collectionStrong = __w_pdfjs_require__(265);
collection('Set', function (init) {
 return function Set() {
  return init(this, arguments.length ? arguments[0] : undefined);
 };
}, collectionStrong);

/***/ }),
/* 260 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var global = __w_pdfjs_require__(5);
var uncurryThis = __w_pdfjs_require__(7);
var isForced = __w_pdfjs_require__(76);
var defineBuiltIn = __w_pdfjs_require__(44);
var InternalMetadataModule = __w_pdfjs_require__(261);
var iterate = __w_pdfjs_require__(167);
var anInstance = __w_pdfjs_require__(149);
var isCallable = __w_pdfjs_require__(29);
var isNullOrUndefined = __w_pdfjs_require__(12);
var isObject = __w_pdfjs_require__(28);
var fails = __w_pdfjs_require__(9);
var checkCorrectnessOfIteration = __w_pdfjs_require__(122);
var setToStringTag = __w_pdfjs_require__(88);
var inheritIfRequired = __w_pdfjs_require__(106);
module.exports = function (CONSTRUCTOR_NAME, wrapper, common) {
 var IS_MAP = CONSTRUCTOR_NAME.indexOf('Map') !== -1;
 var IS_WEAK = CONSTRUCTOR_NAME.indexOf('Weak') !== -1;
 var ADDER = IS_MAP ? 'set' : 'add';
 var NativeConstructor = global[CONSTRUCTOR_NAME];
 var NativePrototype = NativeConstructor && NativeConstructor.prototype;
 var Constructor = NativeConstructor;
 var exported = {};
 var fixMethod = function (KEY) {
  var uncurriedNativeMethod = uncurryThis(NativePrototype[KEY]);
  defineBuiltIn(NativePrototype, KEY, KEY == 'add' ? function add(value) {
   uncurriedNativeMethod(this, value === 0 ? 0 : value);
   return this;
  } : KEY == 'delete' ? function (key) {
   return IS_WEAK && !isObject(key) ? false : uncurriedNativeMethod(this, key === 0 ? 0 : key);
  } : KEY == 'get' ? function get(key) {
   return IS_WEAK && !isObject(key) ? undefined : uncurriedNativeMethod(this, key === 0 ? 0 : key);
  } : KEY == 'has' ? function has(key) {
   return IS_WEAK && !isObject(key) ? false : uncurriedNativeMethod(this, key === 0 ? 0 : key);
  } : function set(key, value) {
   uncurriedNativeMethod(this, key === 0 ? 0 : key, value);
   return this;
  });
 };
 var REPLACE = isForced(CONSTRUCTOR_NAME, !isCallable(NativeConstructor) || !(IS_WEAK || NativePrototype.forEach && !fails(function () {
  new NativeConstructor().entries().next();
 })));
 if (REPLACE) {
  Constructor = common.getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER);
  InternalMetadataModule.enable();
 } else if (isForced(CONSTRUCTOR_NAME, true)) {
  var instance = new Constructor();
  var HASNT_CHAINING = instance[ADDER](IS_WEAK ? {} : -0, 1) != instance;
  var THROWS_ON_PRIMITIVES = fails(function () {
   instance.has(1);
  });
  var ACCEPT_ITERABLES = checkCorrectnessOfIteration(function (iterable) {
   new NativeConstructor(iterable);
  });
  var BUGGY_ZERO = !IS_WEAK && fails(function () {
   var $instance = new NativeConstructor();
   var index = 5;
   while (index--)
    $instance[ADDER](index, index);
   return !$instance.has(-0);
  });
  if (!ACCEPT_ITERABLES) {
   Constructor = wrapper(function (dummy, iterable) {
    anInstance(dummy, NativePrototype);
    var that = inheritIfRequired(new NativeConstructor(), dummy, Constructor);
    if (!isNullOrUndefined(iterable))
     iterate(iterable, that[ADDER], {
      that: that,
      AS_ENTRIES: IS_MAP
     });
    return that;
   });
   Constructor.prototype = NativePrototype;
   NativePrototype.constructor = Constructor;
  }
  if (THROWS_ON_PRIMITIVES || BUGGY_ZERO) {
   fixMethod('delete');
   fixMethod('has');
   IS_MAP && fixMethod('get');
  }
  if (BUGGY_ZERO || HASNT_CHAINING)
   fixMethod(ADDER);
  if (IS_WEAK && NativePrototype.clear)
   delete NativePrototype.clear;
 }
 exported[CONSTRUCTOR_NAME] = Constructor;
 $({
  global: true,
  constructor: true,
  forced: Constructor != NativeConstructor
 }, exported);
 setToStringTag(Constructor, CONSTRUCTOR_NAME);
 if (!IS_WEAK)
  common.setStrong(Constructor, CONSTRUCTOR_NAME, IS_MAP);
 return Constructor;
};

/***/ }),
/* 261 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var uncurryThis = __w_pdfjs_require__(7);
var hiddenKeys = __w_pdfjs_require__(53);
var isObject = __w_pdfjs_require__(28);
var hasOwn = __w_pdfjs_require__(6);
var defineProperty = (__w_pdfjs_require__(24).f);
var getOwnPropertyNamesModule = __w_pdfjs_require__(66);
var getOwnPropertyNamesExternalModule = __w_pdfjs_require__(84);
var isExtensible = __w_pdfjs_require__(262);
var uid = __w_pdfjs_require__(19);
var FREEZING = __w_pdfjs_require__(264);
var REQUIRED = false;
var METADATA = uid('meta');
var id = 0;
var setMetadata = function (it) {
 defineProperty(it, METADATA, {
  value: {
   objectID: 'O' + id++,
   weakData: {}
  }
 });
};
var fastKey = function (it, create) {
 if (!isObject(it))
  return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
 if (!hasOwn(it, METADATA)) {
  if (!isExtensible(it))
   return 'F';
  if (!create)
   return 'E';
  setMetadata(it);
 }
 return it[METADATA].objectID;
};
var getWeakData = function (it, create) {
 if (!hasOwn(it, METADATA)) {
  if (!isExtensible(it))
   return true;
  if (!create)
   return false;
  setMetadata(it);
 }
 return it[METADATA].weakData;
};
var onFreeze = function (it) {
 if (FREEZING && REQUIRED && isExtensible(it) && !hasOwn(it, METADATA))
  setMetadata(it);
 return it;
};
var enable = function () {
 meta.enable = function () {
 };
 REQUIRED = true;
 var getOwnPropertyNames = getOwnPropertyNamesModule.f;
 var splice = uncurryThis([].splice);
 var test = {};
 test[METADATA] = 1;
 if (getOwnPropertyNames(test).length) {
  getOwnPropertyNamesModule.f = function (it) {
   var result = getOwnPropertyNames(it);
   for (var i = 0, length = result.length; i < length; i++) {
    if (result[i] === METADATA) {
     splice(result, i, 1);
     break;
    }
   }
   return result;
  };
  $({
   target: 'Object',
   stat: true,
   forced: true
  }, { getOwnPropertyNames: getOwnPropertyNamesExternalModule.f });
 }
};
var meta = module.exports = {
 enable: enable,
 fastKey: fastKey,
 getWeakData: getWeakData,
 onFreeze: onFreeze
};
hiddenKeys[METADATA] = true;

/***/ }),
/* 262 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var fails = __w_pdfjs_require__(9);
var isObject = __w_pdfjs_require__(28);
var classof = __w_pdfjs_require__(63);
var ARRAY_BUFFER_NON_EXTENSIBLE = __w_pdfjs_require__(263);
var $isExtensible = Object.isExtensible;
var FAILS_ON_PRIMITIVES = fails(function () {
 $isExtensible(1);
});
module.exports = FAILS_ON_PRIMITIVES || ARRAY_BUFFER_NON_EXTENSIBLE ? function isExtensible(it) {
 if (!isObject(it))
  return false;
 if (ARRAY_BUFFER_NON_EXTENSIBLE && classof(it) == 'ArrayBuffer')
  return false;
 return $isExtensible ? $isExtensible(it) : true;
} : $isExtensible;

/***/ }),
/* 263 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var fails = __w_pdfjs_require__(9);
module.exports = fails(function () {
 if (typeof ArrayBuffer == 'function') {
  var buffer = new ArrayBuffer(8);
  if (Object.isExtensible(buffer))
   Object.defineProperty(buffer, 'a', { value: 8 });
 }
});

/***/ }),
/* 264 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var fails = __w_pdfjs_require__(9);
module.exports = !fails(function () {
 return Object.isExtensible(Object.preventExtensions({}));
});

/***/ }),
/* 265 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var create = __w_pdfjs_require__(80);
var defineBuiltInAccessor = __w_pdfjs_require__(87);
var defineBuiltIns = __w_pdfjs_require__(197);
var bind = __w_pdfjs_require__(90);
var anInstance = __w_pdfjs_require__(149);
var isNullOrUndefined = __w_pdfjs_require__(12);
var iterate = __w_pdfjs_require__(167);
var defineIterator = __w_pdfjs_require__(139);
var createIterResultObject = __w_pdfjs_require__(142);
var setSpecies = __w_pdfjs_require__(148);
var DESCRIPTORS = __w_pdfjs_require__(25);
var fastKey = (__w_pdfjs_require__(261).fastKey);
var InternalStateModule = __w_pdfjs_require__(48);
var setInternalState = InternalStateModule.set;
var internalStateGetterFor = InternalStateModule.getterFor;
module.exports = {
 getConstructor: function (wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
  var Constructor = wrapper(function (that, iterable) {
   anInstance(that, Prototype);
   setInternalState(that, {
    type: CONSTRUCTOR_NAME,
    index: create(null),
    first: undefined,
    last: undefined,
    size: 0
   });
   if (!DESCRIPTORS)
    that.size = 0;
   if (!isNullOrUndefined(iterable))
    iterate(iterable, that[ADDER], {
     that: that,
     AS_ENTRIES: IS_MAP
    });
  });
  var Prototype = Constructor.prototype;
  var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);
  var define = function (that, key, value) {
   var state = getInternalState(that);
   var entry = getEntry(that, key);
   var previous, index;
   if (entry) {
    entry.value = value;
   } else {
    state.last = entry = {
     index: index = fastKey(key, true),
     key: key,
     value: value,
     previous: previous = state.last,
     next: undefined,
     removed: false
    };
    if (!state.first)
     state.first = entry;
    if (previous)
     previous.next = entry;
    if (DESCRIPTORS)
     state.size++;
    else
     that.size++;
    if (index !== 'F')
     state.index[index] = entry;
   }
   return that;
  };
  var getEntry = function (that, key) {
   var state = getInternalState(that);
   var index = fastKey(key);
   var entry;
   if (index !== 'F')
    return state.index[index];
   for (entry = state.first; entry; entry = entry.next) {
    if (entry.key == key)
     return entry;
   }
  };
  defineBuiltIns(Prototype, {
   clear: function clear() {
    var that = this;
    var state = getInternalState(that);
    var data = state.index;
    var entry = state.first;
    while (entry) {
     entry.removed = true;
     if (entry.previous)
      entry.previous = entry.previous.next = undefined;
     delete data[entry.index];
     entry = entry.next;
    }
    state.first = state.last = undefined;
    if (DESCRIPTORS)
     state.size = 0;
    else
     that.size = 0;
   },
   'delete': function (key) {
    var that = this;
    var state = getInternalState(that);
    var entry = getEntry(that, key);
    if (entry) {
     var next = entry.next;
     var prev = entry.previous;
     delete state.index[entry.index];
     entry.removed = true;
     if (prev)
      prev.next = next;
     if (next)
      next.previous = prev;
     if (state.first == entry)
      state.first = next;
     if (state.last == entry)
      state.last = prev;
     if (DESCRIPTORS)
      state.size--;
     else
      that.size--;
    }
    return !!entry;
   },
   forEach: function forEach(callbackfn) {
    var state = getInternalState(this);
    var boundFunction = bind(callbackfn, arguments.length > 1 ? arguments[1] : undefined);
    var entry;
    while (entry = entry ? entry.next : state.first) {
     boundFunction(entry.value, entry.key, this);
     while (entry && entry.removed)
      entry = entry.previous;
    }
   },
   has: function has(key) {
    return !!getEntry(this, key);
   }
  });
  defineBuiltIns(Prototype, IS_MAP ? {
   get: function get(key) {
    var entry = getEntry(this, key);
    return entry && entry.value;
   },
   set: function set(key, value) {
    return define(this, key === 0 ? 0 : key, value);
   }
  } : {
   add: function add(value) {
    return define(this, value = value === 0 ? 0 : value, value);
   }
  });
  if (DESCRIPTORS)
   defineBuiltInAccessor(Prototype, 'size', {
    configurable: true,
    get: function () {
     return getInternalState(this).size;
    }
   });
  return Constructor;
 },
 setStrong: function (Constructor, CONSTRUCTOR_NAME, IS_MAP) {
  var ITERATOR_NAME = CONSTRUCTOR_NAME + ' Iterator';
  var getInternalCollectionState = internalStateGetterFor(CONSTRUCTOR_NAME);
  var getInternalIteratorState = internalStateGetterFor(ITERATOR_NAME);
  defineIterator(Constructor, CONSTRUCTOR_NAME, function (iterated, kind) {
   setInternalState(this, {
    type: ITERATOR_NAME,
    target: iterated,
    state: getInternalCollectionState(iterated),
    kind: kind,
    last: undefined
   });
  }, function () {
   var state = getInternalIteratorState(this);
   var kind = state.kind;
   var entry = state.last;
   while (entry && entry.removed)
    entry = entry.previous;
   if (!state.target || !(state.last = entry = entry ? entry.next : state.state.first)) {
    state.target = undefined;
    return createIterResultObject(undefined, true);
   }
   if (kind == 'keys')
    return createIterResultObject(entry.key, false);
   if (kind == 'values')
    return createIterResultObject(entry.value, false);
   return createIterResultObject([
    entry.key,
    entry.value
   ], false);
  }, IS_MAP ? 'entries' : 'values', !IS_MAP, true);
  setSpecies(CONSTRUCTOR_NAME);
 }
};

/***/ }),
/* 266 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var difference = __w_pdfjs_require__(267);
var setMethodAcceptSetLike = __w_pdfjs_require__(276);
$({
 target: 'Set',
 proto: true,
 real: true,
 forced: !setMethodAcceptSetLike('difference')
}, { difference: difference });

/***/ }),
/* 267 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var aSet = __w_pdfjs_require__(268);
var SetHelpers = __w_pdfjs_require__(269);
var clone = __w_pdfjs_require__(270);
var size = __w_pdfjs_require__(273);
var getSetRecord = __w_pdfjs_require__(274);
var iterateSet = __w_pdfjs_require__(271);
var iterateSimple = __w_pdfjs_require__(272);
var has = SetHelpers.has;
var remove = SetHelpers.remove;
module.exports = function difference(other) {
 var O = aSet(this);
 var otherRec = getSetRecord(other);
 var result = clone(O);
 if (size(O) <= otherRec.size)
  iterateSet(O, function (e) {
   if (otherRec.includes(e))
    remove(result, e);
  });
 else
  iterateSimple(otherRec.getIterator(), function (e) {
   if (has(O, e))
    remove(result, e);
  });
 return result;
};

/***/ }),
/* 268 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var has = (__w_pdfjs_require__(269).has);
module.exports = function (it) {
 has(it);
 return it;
};

/***/ }),
/* 269 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var SetPrototype = Set.prototype;
module.exports = {
 Set: Set,
 add: uncurryThis(SetPrototype.add),
 has: uncurryThis(SetPrototype.has),
 remove: uncurryThis(SetPrototype['delete']),
 proto: SetPrototype
};

/***/ }),
/* 270 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var SetHelpers = __w_pdfjs_require__(269);
var iterate = __w_pdfjs_require__(271);
var Set = SetHelpers.Set;
var add = SetHelpers.add;
module.exports = function (set) {
 var result = new Set();
 iterate(set, function (it) {
  add(result, it);
 });
 return result;
};

/***/ }),
/* 271 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var iterateSimple = __w_pdfjs_require__(272);
var SetHelpers = __w_pdfjs_require__(269);
var Set = SetHelpers.Set;
var SetPrototype = SetHelpers.proto;
var forEach = uncurryThis(SetPrototype.forEach);
var keys = uncurryThis(SetPrototype.keys);
var next = keys(new Set()).next;
module.exports = function (set, fn, interruptible) {
 return interruptible ? iterateSimple({
  iterator: keys(set),
  next: next
 }, fn) : forEach(set, fn);
};

/***/ }),
/* 272 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var call = __w_pdfjs_require__(35);
module.exports = function (record, fn, ITERATOR_INSTEAD_OF_RECORD) {
 var iterator = ITERATOR_INSTEAD_OF_RECORD ? record : record.iterator;
 var next = record.next;
 var step, result;
 while (!(step = call(next, iterator)).done) {
  result = fn(step.value);
  if (result !== undefined)
   return result;
 }
};

/***/ }),
/* 273 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThisAccessor = __w_pdfjs_require__(108);
var SetHelpers = __w_pdfjs_require__(269);
module.exports = uncurryThisAccessor(SetHelpers.proto, 'size', 'get') || function (set) {
 return set.size;
};

/***/ }),
/* 274 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var aCallable = __w_pdfjs_require__(40);
var anObject = __w_pdfjs_require__(32);
var call = __w_pdfjs_require__(35);
var toIntegerOrInfinity = __w_pdfjs_require__(70);
var getIteratorDirect = __w_pdfjs_require__(275);
var INVALID_SIZE = 'Invalid size';
var $RangeError = RangeError;
var $TypeError = TypeError;
var max = Math.max;
var SetRecord = function (set, size, has, keys) {
 this.set = set;
 this.size = size;
 this.has = has;
 this.keys = keys;
};
SetRecord.prototype = {
 getIterator: function () {
  return getIteratorDirect(anObject(call(this.keys, this.set)));
 },
 includes: function (it) {
  return call(this.has, this.set, it);
 }
};
module.exports = function (obj) {
 anObject(obj);
 var numSize = +obj.size;
 if (numSize != numSize)
  throw $TypeError(INVALID_SIZE);
 var intSize = toIntegerOrInfinity(numSize);
 if (intSize < 0)
  throw $RangeError(INVALID_SIZE);
 return new SetRecord(obj, max(intSize, 0), aCallable(obj.has), aCallable(obj.keys));
};

/***/ }),
/* 275 */
/***/ ((module) => {


module.exports = function (obj) {
 return {
  iterator: obj,
  next: obj.next,
  done: false
 };
};

/***/ }),
/* 276 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var getBuiltIn = __w_pdfjs_require__(37);
var createSetLike = function (size) {
 return {
  size: size,
  has: function () {
   return false;
  },
  keys: function () {
   return {
    next: function () {
     return { done: true };
    }
   };
  }
 };
};
module.exports = function (name) {
 var Set = getBuiltIn('Set');
 try {
  new Set()[name](createSetLike(0));
  try {
   new Set()[name](createSetLike(-1));
   return false;
  } catch (error2) {
   return true;
  }
 } catch (error) {
  return false;
 }
};

/***/ }),
/* 277 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var fails = __w_pdfjs_require__(9);
var intersection = __w_pdfjs_require__(278);
var setMethodAcceptSetLike = __w_pdfjs_require__(276);
var INCORRECT = !setMethodAcceptSetLike('intersection') || fails(function () {
 return Array.from(new Set([
  1,
  2,
  3
 ]).intersection(new Set([
  3,
  2
 ]))) != '3,2';
});
$({
 target: 'Set',
 proto: true,
 real: true,
 forced: INCORRECT
}, { intersection: intersection });

/***/ }),
/* 278 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var aSet = __w_pdfjs_require__(268);
var SetHelpers = __w_pdfjs_require__(269);
var size = __w_pdfjs_require__(273);
var getSetRecord = __w_pdfjs_require__(274);
var iterateSet = __w_pdfjs_require__(271);
var iterateSimple = __w_pdfjs_require__(272);
var Set = SetHelpers.Set;
var add = SetHelpers.add;
var has = SetHelpers.has;
module.exports = function intersection(other) {
 var O = aSet(this);
 var otherRec = getSetRecord(other);
 var result = new Set();
 if (size(O) > otherRec.size) {
  iterateSimple(otherRec.getIterator(), function (e) {
   if (has(O, e))
    add(result, e);
  });
 } else {
  iterateSet(O, function (e) {
   if (otherRec.includes(e))
    add(result, e);
  });
 }
 return result;
};

/***/ }),
/* 279 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var isDisjointFrom = __w_pdfjs_require__(280);
var setMethodAcceptSetLike = __w_pdfjs_require__(276);
$({
 target: 'Set',
 proto: true,
 real: true,
 forced: !setMethodAcceptSetLike('isDisjointFrom')
}, { isDisjointFrom: isDisjointFrom });

/***/ }),
/* 280 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var aSet = __w_pdfjs_require__(268);
var has = (__w_pdfjs_require__(269).has);
var size = __w_pdfjs_require__(273);
var getSetRecord = __w_pdfjs_require__(274);
var iterateSet = __w_pdfjs_require__(271);
var iterateSimple = __w_pdfjs_require__(272);
var iteratorClose = __w_pdfjs_require__(117);
module.exports = function isDisjointFrom(other) {
 var O = aSet(this);
 var otherRec = getSetRecord(other);
 if (size(O) <= otherRec.size)
  return iterateSet(O, function (e) {
   if (otherRec.includes(e))
    return false;
  }, true) !== false;
 var iterator = otherRec.getIterator();
 return iterateSimple(iterator, function (e) {
  if (has(O, e))
   return iteratorClose(iterator, 'normal', false);
 }) !== false;
};

/***/ }),
/* 281 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var isSubsetOf = __w_pdfjs_require__(282);
var setMethodAcceptSetLike = __w_pdfjs_require__(276);
$({
 target: 'Set',
 proto: true,
 real: true,
 forced: !setMethodAcceptSetLike('isSubsetOf')
}, { isSubsetOf: isSubsetOf });

/***/ }),
/* 282 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var aSet = __w_pdfjs_require__(268);
var size = __w_pdfjs_require__(273);
var iterate = __w_pdfjs_require__(271);
var getSetRecord = __w_pdfjs_require__(274);
module.exports = function isSubsetOf(other) {
 var O = aSet(this);
 var otherRec = getSetRecord(other);
 if (size(O) > otherRec.size)
  return false;
 return iterate(O, function (e) {
  if (!otherRec.includes(e))
   return false;
 }, true) !== false;
};

/***/ }),
/* 283 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var isSupersetOf = __w_pdfjs_require__(284);
var setMethodAcceptSetLike = __w_pdfjs_require__(276);
$({
 target: 'Set',
 proto: true,
 real: true,
 forced: !setMethodAcceptSetLike('isSupersetOf')
}, { isSupersetOf: isSupersetOf });

/***/ }),
/* 284 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var aSet = __w_pdfjs_require__(268);
var has = (__w_pdfjs_require__(269).has);
var size = __w_pdfjs_require__(273);
var getSetRecord = __w_pdfjs_require__(274);
var iterateSimple = __w_pdfjs_require__(272);
var iteratorClose = __w_pdfjs_require__(117);
module.exports = function isSupersetOf(other) {
 var O = aSet(this);
 var otherRec = getSetRecord(other);
 if (size(O) < otherRec.size)
  return false;
 var iterator = otherRec.getIterator();
 return iterateSimple(iterator, function (e) {
  if (!has(O, e))
   return iteratorClose(iterator, 'normal', false);
 }) !== false;
};

/***/ }),
/* 285 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var symmetricDifference = __w_pdfjs_require__(286);
var setMethodAcceptSetLike = __w_pdfjs_require__(276);
$({
 target: 'Set',
 proto: true,
 real: true,
 forced: !setMethodAcceptSetLike('symmetricDifference')
}, { symmetricDifference: symmetricDifference });

/***/ }),
/* 286 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var aSet = __w_pdfjs_require__(268);
var SetHelpers = __w_pdfjs_require__(269);
var clone = __w_pdfjs_require__(270);
var getSetRecord = __w_pdfjs_require__(274);
var iterateSimple = __w_pdfjs_require__(272);
var add = SetHelpers.add;
var has = SetHelpers.has;
var remove = SetHelpers.remove;
module.exports = function symmetricDifference(other) {
 var O = aSet(this);
 var keysIter = getSetRecord(other).getIterator();
 var result = clone(O);
 iterateSimple(keysIter, function (e) {
  if (has(O, e))
   remove(result, e);
  else
   add(result, e);
 });
 return result;
};

/***/ }),
/* 287 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var union = __w_pdfjs_require__(288);
var setMethodAcceptSetLike = __w_pdfjs_require__(276);
$({
 target: 'Set',
 proto: true,
 real: true,
 forced: !setMethodAcceptSetLike('union')
}, { union: union });

/***/ }),
/* 288 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var aSet = __w_pdfjs_require__(268);
var add = (__w_pdfjs_require__(269).add);
var clone = __w_pdfjs_require__(270);
var getSetRecord = __w_pdfjs_require__(274);
var iterateSimple = __w_pdfjs_require__(272);
module.exports = function union(other) {
 var O = aSet(this);
 var keysIter = getSetRecord(other).getIterator();
 var result = clone(O);
 iterateSimple(keysIter, function (it) {
  add(result, it);
 });
 return result;
};

/***/ }),
/* 289 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var toObject = __w_pdfjs_require__(10);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var setArrayLength = __w_pdfjs_require__(290);
var doesNotExceedSafeInteger = __w_pdfjs_require__(291);
var fails = __w_pdfjs_require__(9);
var INCORRECT_TO_LENGTH = fails(function () {
 return [].push.call({ length: 0x100000000 }, 1) !== 4294967297;
});
var properErrorOnNonWritableLength = function () {
 try {
  Object.defineProperty([], 'length', { writable: false }).push();
 } catch (error) {
  return error instanceof TypeError;
 }
};
var FORCED = INCORRECT_TO_LENGTH || !properErrorOnNonWritableLength();
$({
 target: 'Array',
 proto: true,
 arity: 1,
 forced: FORCED
}, {
 push: function push(item) {
  var O = toObject(this);
  var len = lengthOfArrayLike(O);
  var argCount = arguments.length;
  doesNotExceedSafeInteger(len + argCount);
  for (var i = 0; i < argCount; i++) {
   O[len] = arguments[i];
   len++;
  }
  setArrayLength(O, len);
  return len;
 }
});

/***/ }),
/* 290 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var DESCRIPTORS = __w_pdfjs_require__(25);
var isArray = __w_pdfjs_require__(94);
var $TypeError = TypeError;
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
var SILENT_ON_NON_WRITABLE_LENGTH_SET = DESCRIPTORS && !(function () {
 if (this !== undefined)
  return true;
 try {
  Object.defineProperty([], 'length', { writable: false }).length = 1;
 } catch (error) {
  return error instanceof TypeError;
 }
}());
module.exports = SILENT_ON_NON_WRITABLE_LENGTH_SET ? function (O, length) {
 if (isArray(O) && !getOwnPropertyDescriptor(O, 'length').writable) {
  throw $TypeError('Cannot set read only .length');
 }
 return O.length = length;
} : function (O, length) {
 return O.length = length;
};

/***/ }),
/* 291 */
/***/ ((module) => {


var $TypeError = TypeError;
var MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFF;
module.exports = function (it) {
 if (it > MAX_SAFE_INTEGER)
  throw $TypeError('Maximum allowed index exceeded');
 return it;
};

/***/ }),
/* 292 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var PROPER_FUNCTION_NAME = (__w_pdfjs_require__(46).PROPER);
var defineBuiltIn = __w_pdfjs_require__(44);
var anObject = __w_pdfjs_require__(32);
var $toString = __w_pdfjs_require__(77);
var fails = __w_pdfjs_require__(9);
var getRegExpFlags = __w_pdfjs_require__(293);
var TO_STRING = 'toString';
var RegExpPrototype = RegExp.prototype;
var nativeToString = RegExpPrototype[TO_STRING];
var NOT_GENERIC = fails(function () {
 return nativeToString.call({
  source: 'a',
  flags: 'b'
 }) != '/a/b';
});
var INCORRECT_NAME = PROPER_FUNCTION_NAME && nativeToString.name != TO_STRING;
if (NOT_GENERIC || INCORRECT_NAME) {
 defineBuiltIn(RegExp.prototype, TO_STRING, function toString() {
  var R = anObject(this);
  var pattern = $toString(R.source);
  var flags = $toString(getRegExpFlags(R));
  return '/' + pattern + '/' + flags;
 }, { unsafe: true });
}

/***/ }),
/* 293 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var call = __w_pdfjs_require__(35);
var hasOwn = __w_pdfjs_require__(6);
var isPrototypeOf = __w_pdfjs_require__(38);
var regExpFlags = __w_pdfjs_require__(125);
var RegExpPrototype = RegExp.prototype;
module.exports = function (R) {
 var flags = R.flags;
 return flags === undefined && !('flags' in RegExpPrototype) && !hasOwn(R, 'flags') && isPrototypeOf(RegExpPrototype, R) ? call(regExpFlags, R) : flags;
};

/***/ }),
/* 294 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var IS_PURE = __w_pdfjs_require__(16);
var NativePromiseConstructor = __w_pdfjs_require__(161);
var fails = __w_pdfjs_require__(9);
var getBuiltIn = __w_pdfjs_require__(37);
var isCallable = __w_pdfjs_require__(29);
var speciesConstructor = __w_pdfjs_require__(150);
var promiseResolve = __w_pdfjs_require__(173);
var defineBuiltIn = __w_pdfjs_require__(44);
var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;
var NON_GENERIC = !!NativePromiseConstructor && fails(function () {
 NativePromisePrototype['finally'].call({
  then: function () {
  }
 }, function () {
 });
});
$({
 target: 'Promise',
 proto: true,
 real: true,
 forced: NON_GENERIC
}, {
 'finally': function (onFinally) {
  var C = speciesConstructor(this, getBuiltIn('Promise'));
  var isFunction = isCallable(onFinally);
  return this.then(isFunction ? function (x) {
   return promiseResolve(C, onFinally()).then(function () {
    return x;
   });
  } : onFinally, isFunction ? function (e) {
   return promiseResolve(C, onFinally()).then(function () {
    throw e;
   });
  } : onFinally);
 }
});
if (!IS_PURE && isCallable(NativePromiseConstructor)) {
 var method = getBuiltIn('Promise').prototype['finally'];
 if (NativePromisePrototype['finally'] !== method) {
  defineBuiltIn(NativePromisePrototype, 'finally', method, { unsafe: true });
 }
}

/***/ }),
/* 295 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var isArray = __w_pdfjs_require__(94);
var isConstructor = __w_pdfjs_require__(95);
var isObject = __w_pdfjs_require__(28);
var toAbsoluteIndex = __w_pdfjs_require__(69);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var toIndexedObject = __w_pdfjs_require__(61);
var createProperty = __w_pdfjs_require__(86);
var wellKnownSymbol = __w_pdfjs_require__(14);
var arrayMethodHasSpeciesSupport = __w_pdfjs_require__(181);
var nativeSlice = __w_pdfjs_require__(101);
var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('slice');
var SPECIES = wellKnownSymbol('species');
var $Array = Array;
var max = Math.max;
$({
 target: 'Array',
 proto: true,
 forced: !HAS_SPECIES_SUPPORT
}, {
 slice: function slice(start, end) {
  var O = toIndexedObject(this);
  var length = lengthOfArrayLike(O);
  var k = toAbsoluteIndex(start, length);
  var fin = toAbsoluteIndex(end === undefined ? length : end, length);
  var Constructor, result, n;
  if (isArray(O)) {
   Constructor = O.constructor;
   if (isConstructor(Constructor) && (Constructor === $Array || isArray(Constructor.prototype))) {
    Constructor = undefined;
   } else if (isObject(Constructor)) {
    Constructor = Constructor[SPECIES];
    if (Constructor === null)
     Constructor = undefined;
   }
   if (Constructor === $Array || Constructor === undefined) {
    return nativeSlice(O, k, fin);
   }
  }
  result = new (Constructor === undefined ? $Array : Constructor)(max(fin - k, 0));
  for (n = 0; k < fin; k++, n++)
   if (k in O)
    createProperty(result, n, O[k]);
  result.length = n;
  return result;
 }
});

/***/ }),
/* 296 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var flattenIntoArray = __w_pdfjs_require__(297);
var toObject = __w_pdfjs_require__(10);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var toIntegerOrInfinity = __w_pdfjs_require__(70);
var arraySpeciesCreate = __w_pdfjs_require__(92);
$({
 target: 'Array',
 proto: true
}, {
 flat: function flat() {
  var depthArg = arguments.length ? arguments[0] : undefined;
  var O = toObject(this);
  var sourceLen = lengthOfArrayLike(O);
  var A = arraySpeciesCreate(O, 0);
  A.length = flattenIntoArray(A, O, O, sourceLen, 0, depthArg === undefined ? 1 : toIntegerOrInfinity(depthArg));
  return A;
 }
});

/***/ }),
/* 297 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var isArray = __w_pdfjs_require__(94);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var doesNotExceedSafeInteger = __w_pdfjs_require__(291);
var bind = __w_pdfjs_require__(90);
var flattenIntoArray = function (target, original, source, sourceLen, start, depth, mapper, thisArg) {
 var targetIndex = start;
 var sourceIndex = 0;
 var mapFn = mapper ? bind(mapper, thisArg) : false;
 var element, elementLen;
 while (sourceIndex < sourceLen) {
  if (sourceIndex in source) {
   element = mapFn ? mapFn(source[sourceIndex], sourceIndex, original) : source[sourceIndex];
   if (depth > 0 && isArray(element)) {
    elementLen = lengthOfArrayLike(element);
    targetIndex = flattenIntoArray(target, original, element, elementLen, targetIndex, depth - 1) - 1;
   } else {
    doesNotExceedSafeInteger(targetIndex + 1);
    target[targetIndex] = element;
   }
   targetIndex++;
  }
  sourceIndex++;
 }
 return targetIndex;
};
module.exports = flattenIntoArray;

/***/ }),
/* 298 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var addToUnscopables = __w_pdfjs_require__(138);
addToUnscopables('flat');

/***/ }),
/* 299 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var DOMIterables = __w_pdfjs_require__(178);
var DOMTokenListPrototype = __w_pdfjs_require__(179);
var forEach = __w_pdfjs_require__(300);
var createNonEnumerableProperty = __w_pdfjs_require__(50);
var handlePrototype = function (CollectionPrototype) {
 if (CollectionPrototype && CollectionPrototype.forEach !== forEach)
  try {
   createNonEnumerableProperty(CollectionPrototype, 'forEach', forEach);
  } catch (error) {
   CollectionPrototype.forEach = forEach;
  }
};
for (var COLLECTION_NAME in DOMIterables) {
 if (DOMIterables[COLLECTION_NAME]) {
  handlePrototype(global[COLLECTION_NAME] && global[COLLECTION_NAME].prototype);
 }
}
handlePrototype(DOMTokenListPrototype);

/***/ }),
/* 300 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $forEach = (__w_pdfjs_require__(89).forEach);
var arrayMethodIsStrict = __w_pdfjs_require__(230);
var STRICT_METHOD = arrayMethodIsStrict('forEach');
module.exports = !STRICT_METHOD ? function forEach(callbackfn) {
 return $forEach(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
} : [].forEach;

/***/ }),
/* 301 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var fails = __w_pdfjs_require__(9);
var isArray = __w_pdfjs_require__(94);
var isObject = __w_pdfjs_require__(28);
var toObject = __w_pdfjs_require__(10);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var doesNotExceedSafeInteger = __w_pdfjs_require__(291);
var createProperty = __w_pdfjs_require__(86);
var arraySpeciesCreate = __w_pdfjs_require__(92);
var arrayMethodHasSpeciesSupport = __w_pdfjs_require__(181);
var wellKnownSymbol = __w_pdfjs_require__(14);
var V8_VERSION = __w_pdfjs_require__(21);
var IS_CONCAT_SPREADABLE = wellKnownSymbol('isConcatSpreadable');
var IS_CONCAT_SPREADABLE_SUPPORT = V8_VERSION >= 51 || !fails(function () {
 var array = [];
 array[IS_CONCAT_SPREADABLE] = false;
 return array.concat()[0] !== array;
});
var isConcatSpreadable = function (O) {
 if (!isObject(O))
  return false;
 var spreadable = O[IS_CONCAT_SPREADABLE];
 return spreadable !== undefined ? !!spreadable : isArray(O);
};
var FORCED = !IS_CONCAT_SPREADABLE_SUPPORT || !arrayMethodHasSpeciesSupport('concat');
$({
 target: 'Array',
 proto: true,
 arity: 1,
 forced: FORCED
}, {
 concat: function concat(arg) {
  var O = toObject(this);
  var A = arraySpeciesCreate(O, 0);
  var n = 0;
  var i, k, length, len, E;
  for (i = -1, length = arguments.length; i < length; i++) {
   E = i === -1 ? O : arguments[i];
   if (isConcatSpreadable(E)) {
    len = lengthOfArrayLike(E);
    doesNotExceedSafeInteger(n + len);
    for (k = 0; k < len; k++, n++)
     if (k in E)
      createProperty(A, n, E[k]);
   } else {
    doesNotExceedSafeInteger(n + 1);
    createProperty(A, n++, E);
   }
  }
  A.length = n;
  return A;
 }
});

/***/ }),
/* 302 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var global = __w_pdfjs_require__(5);
var defineBuiltInAccessor = __w_pdfjs_require__(87);
var DESCRIPTORS = __w_pdfjs_require__(25);
var $TypeError = TypeError;
var defineProperty = Object.defineProperty;
var INCORRECT_VALUE = global.self !== global;
try {
 if (DESCRIPTORS) {
  var descriptor = Object.getOwnPropertyDescriptor(global, 'self');
  if (INCORRECT_VALUE || !descriptor || !descriptor.get || !descriptor.enumerable) {
   defineBuiltInAccessor(global, 'self', {
    get: function self() {
     return global;
    },
    set: function self(value) {
     if (this !== global)
      throw $TypeError('Illegal invocation');
     defineProperty(global, 'self', {
      value: value,
      writable: true,
      configurable: true,
      enumerable: true
     });
    },
    configurable: true,
    enumerable: true
   });
  }
 } else
  $({
   global: true,
   simple: true,
   forced: INCORRECT_VALUE
  }, { self: global });
} catch (error) {
}

/***/ }),
/* 303 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

__w_pdfjs_require__(134);__w_pdfjs_require__(304);__w_pdfjs_require__(305);__w_pdfjs_require__(2);__w_pdfjs_require__(54);__w_pdfjs_require__(114);__w_pdfjs_require__(129);Object.defineProperty(exports, "__esModule", ({value:true}));exports.VerbosityLevel=exports.Util=exports.UnknownErrorException=exports.UnexpectedResponseException=exports.TextRenderingMode=exports.RenderingIntentFlag=exports.PromiseCapability=exports.PermissionFlag=exports.PasswordResponses=exports.PasswordException=exports.PageActionEventType=exports.OPS=exports.MissingPDFException=exports.MAX_IMAGE_SIZE_TO_CACHE=exports.LINE_FACTOR=exports.LINE_DESCENT_FACTOR=exports.InvalidPDFException=exports.ImageKind=exports.IDENTITY_MATRIX=exports.FormatError=exports.FeatureTest=exports.FONT_IDENTITY_MATRIX=exports.DocumentActionEventType=exports.CMapCompressionType=exports.BaseException=exports.BASELINE_FACTOR=exports.AnnotationType=exports.AnnotationReplyType=exports.AnnotationMode=exports.AnnotationFlag=exports.AnnotationFieldFlag=exports.AnnotationEditorType=exports.AnnotationEditorPrefix=exports.AnnotationEditorParamsType=exports.AnnotationBorderStyleType=exports.AnnotationActionEventType=exports.AbortException=void 0;exports.assert=assert;exports.bytesToString=bytesToString;exports.createValidAbsoluteUrl=createValidAbsoluteUrl;exports.getModificationDate=getModificationDate;exports.getUuid=getUuid;exports.getVerbosityLevel=getVerbosityLevel;exports.info=info;exports.isArrayBuffer=isArrayBuffer;exports.isArrayEqual=isArrayEqual;exports.isNodeJS=void 0;exports.normalizeUnicode=normalizeUnicode;exports.objectFromMap=objectFromMap;exports.objectSize=objectSize;exports.setVerbosityLevel=setVerbosityLevel;exports.shadow=shadow;exports.string32=string32;exports.stringToBytes=stringToBytes;exports.stringToPDFString=stringToPDFString;exports.stringToUTF8String=stringToUTF8String;exports.unreachable=unreachable;exports.utf8StringToString=utf8StringToString;exports.warn=warn;__w_pdfjs_require__(105);__w_pdfjs_require__(302);__w_pdfjs_require__(307);__w_pdfjs_require__(183);__w_pdfjs_require__(308);__w_pdfjs_require__(123);__w_pdfjs_require__(312);__w_pdfjs_require__(137);__w_pdfjs_require__(143);__w_pdfjs_require__(175);__w_pdfjs_require__(177);__w_pdfjs_require__(316);__w_pdfjs_require__(322);__w_pdfjs_require__(323);__w_pdfjs_require__(324);__w_pdfjs_require__(325);__w_pdfjs_require__(289);__w_pdfjs_require__(191);__w_pdfjs_require__(208);__w_pdfjs_require__(209);__w_pdfjs_require__(212);__w_pdfjs_require__(213);__w_pdfjs_require__(214);__w_pdfjs_require__(218);__w_pdfjs_require__(219);__w_pdfjs_require__(220);__w_pdfjs_require__(222);__w_pdfjs_require__(223);__w_pdfjs_require__(224);__w_pdfjs_require__(225);__w_pdfjs_require__(226);__w_pdfjs_require__(227);__w_pdfjs_require__(228);__w_pdfjs_require__(231);__w_pdfjs_require__(232);__w_pdfjs_require__(234);__w_pdfjs_require__(235);__w_pdfjs_require__(236);__w_pdfjs_require__(237);__w_pdfjs_require__(238);__w_pdfjs_require__(239);__w_pdfjs_require__(244);__w_pdfjs_require__(245);__w_pdfjs_require__(247);__w_pdfjs_require__(248);__w_pdfjs_require__(249);__w_pdfjs_require__(251);__w_pdfjs_require__(254);__w_pdfjs_require__(257);__w_pdfjs_require__(326);__w_pdfjs_require__(327);__w_pdfjs_require__(328);__w_pdfjs_require__(329);__w_pdfjs_require__(180);__w_pdfjs_require__(330);__w_pdfjs_require__(292);__w_pdfjs_require__(301);__w_pdfjs_require__(295);__w_pdfjs_require__(145);__w_pdfjs_require__(334);__w_pdfjs_require__(336);__w_pdfjs_require__(338);__w_pdfjs_require__(56);__w_pdfjs_require__(104);__w_pdfjs_require__(113);__w_pdfjs_require__(339);function _classPrivateFieldInitSpec(obj,privateMap,value){_checkPrivateRedeclaration(obj,privateMap);privateMap.set(obj,value);}function _checkPrivateRedeclaration(obj,privateCollection){if(privateCollection.has(obj)){throw new TypeError("Cannot initialize the same private elements twice on an object");}}function _classPrivateFieldGet(receiver,privateMap){var descriptor=_classExtractFieldDescriptor(receiver,privateMap,"get");return _classApplyDescriptorGet(receiver,descriptor);}function _classApplyDescriptorGet(receiver,descriptor){if(descriptor.get){return descriptor.get.call(receiver);}return descriptor.value;}function _classPrivateFieldSet(receiver,privateMap,value){var descriptor=_classExtractFieldDescriptor(receiver,privateMap,"set");_classApplyDescriptorSet(receiver,descriptor,value);return value;}function _classExtractFieldDescriptor(receiver,privateMap,action){if(!privateMap.has(receiver)){throw new TypeError("attempted to "+action+" private field on non-instance");}return privateMap.get(receiver);}function _classApplyDescriptorSet(receiver,descriptor,value){if(descriptor.set){descriptor.set.call(receiver,value);}else{if(!descriptor.writable){throw new TypeError("attempted to set read only private field");}descriptor.value=value;}}function _toConsumableArray(arr){return _arrayWithoutHoles(arr)||_iterableToArray(arr)||_unsupportedIterableToArray(arr)||_nonIterableSpread();}function _nonIterableSpread(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}function _iterableToArray(iter){if(typeof Symbol!=="undefined"&&iter[Symbol.iterator]!=null||iter["@@iterator"]!=null)return Array.from(iter);}function _arrayWithoutHoles(arr){if(Array.isArray(arr))return _arrayLikeToArray(arr);}function _slicedToArray(arr,i){return _arrayWithHoles(arr)||_iterableToArrayLimit(arr,i)||_unsupportedIterableToArray(arr,i)||_nonIterableRest();}function _nonIterableRest(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}function _iterableToArrayLimit(arr,i){var _i=null==arr?null:"undefined"!=typeof Symbol&&arr[Symbol.iterator]||arr["@@iterator"];if(null!=_i){var _s,_e,_x,_r,_arr=[],_n=!0,_d=!1;try{if(_x=(_i=_i.call(arr)).next,0===i){if(Object(_i)!==_i)return;_n=!1;}else for(;!(_n=(_s=_x.call(_i)).done)&&(_arr.push(_s.value),_arr.length!==i);_n=!0);}catch(err){_d=!0,_e=err;}finally{try{if(!_n&&null!=_i.return&&(_r=_i.return(),Object(_r)!==_r))return;}finally{if(_d)throw _e;}}return _arr;}}function _arrayWithHoles(arr){if(Array.isArray(arr))return arr;}function _createForOfIteratorHelper(o,allowArrayLike){var it=typeof Symbol!=="undefined"&&o[Symbol.iterator]||o["@@iterator"];if(!it){if(Array.isArray(o)||(it=_unsupportedIterableToArray(o))||allowArrayLike&&o&&typeof o.length==="number"){if(it)o=it;var i=0;var F=function F(){};return{s:F,n:function n(){if(i>=o.length)return{done:true};return{done:false,value:o[i++]};},e:function e(_e2){throw _e2;},f:F};}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}var normalCompletion=true,didErr=false,err;return{s:function s(){it=it.call(o);},n:function n(){var step=it.next();normalCompletion=step.done;return step;},e:function e(_e3){didErr=true;err=_e3;},f:function f(){try{if(!normalCompletion&&it.return!=null)it.return();}finally{if(didErr)throw err;}}};}function _unsupportedIterableToArray(o,minLen){if(!o)return;if(typeof o==="string")return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);if(n==="Object"&&o.constructor)n=o.constructor.name;if(n==="Map"||n==="Set")return Array.from(o);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return _arrayLikeToArray(o,minLen);}function _arrayLikeToArray(arr,len){if(len==null||len>arr.length)len=arr.length;for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2;}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}}function _createClass(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);Object.defineProperty(Constructor,"prototype",{writable:false});return Constructor;}function _toPropertyKey(arg){var key=_toPrimitive(arg,"string");return _typeof(key)==="symbol"?key:String(key);}function _toPrimitive(input,hint){if(_typeof(input)!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(_typeof(res)!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.");}return(hint==="string"?String:Number)(input);}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function");}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:true,configurable:true}});Object.defineProperty(subClass,"prototype",{writable:false});if(superClass)_setPrototypeOf(subClass,superClass);}function _setPrototypeOf(o,p){_setPrototypeOf=Object.setPrototypeOf?Object.setPrototypeOf.bind():function _setPrototypeOf(o,p){o.__proto__=p;return o;};return _setPrototypeOf(o,p);}function _createSuper(Derived){var hasNativeReflectConstruct=_isNativeReflectConstruct();return function _createSuperInternal(){var Super=_getPrototypeOf(Derived),result;if(hasNativeReflectConstruct){var NewTarget=_getPrototypeOf(this).constructor;result=Reflect.construct(Super,arguments,NewTarget);}else{result=Super.apply(this,arguments);}return _possibleConstructorReturn(this,result);};}function _possibleConstructorReturn(self,call){if(call&&(_typeof(call)==="object"||typeof call==="function")){return call;}else if(call!==void 0){throw new TypeError("Derived constructors may only return object or undefined");}return _assertThisInitialized(self);}function _assertThisInitialized(self){if(self===void 0){throw new ReferenceError("this hasn't been initialised - super() hasn't been called");}return self;}function _isNativeReflectConstruct(){if(typeof Reflect==="undefined"||!Reflect.construct)return false;if(Reflect.construct.sham)return false;if(typeof Proxy==="function")return true;try{Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}));return true;}catch(e){return false;}}function _getPrototypeOf(o){_getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf.bind():function _getPrototypeOf(o){return o.__proto__||Object.getPrototypeOf(o);};return _getPrototypeOf(o);}function _typeof(obj){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj;}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;},_typeof(obj);}var isNodeJS=(typeof process==="undefined"?"undefined":_typeof(process))==="object"&&process+""==="[object process]"&&!process.versions.nw&&!(process.versions.electron&&process.type&&process.type!=="browser");exports.isNodeJS=isNodeJS;var IDENTITY_MATRIX=[1,0,0,1,0,0];exports.IDENTITY_MATRIX=IDENTITY_MATRIX;var FONT_IDENTITY_MATRIX=[0.001,0,0,0.001,0,0];exports.FONT_IDENTITY_MATRIX=FONT_IDENTITY_MATRIX;var MAX_IMAGE_SIZE_TO_CACHE=10e6;exports.MAX_IMAGE_SIZE_TO_CACHE=MAX_IMAGE_SIZE_TO_CACHE;var LINE_FACTOR=1.35;exports.LINE_FACTOR=LINE_FACTOR;var LINE_DESCENT_FACTOR=0.35;exports.LINE_DESCENT_FACTOR=LINE_DESCENT_FACTOR;var BASELINE_FACTOR=LINE_DESCENT_FACTOR/LINE_FACTOR;exports.BASELINE_FACTOR=BASELINE_FACTOR;var RenderingIntentFlag={ANY:0x01,DISPLAY:0x02,PRINT:0x04,SAVE:0x08,ANNOTATIONS_FORMS:0x10,ANNOTATIONS_STORAGE:0x20,ANNOTATIONS_DISABLE:0x40,OPLIST:0x100};exports.RenderingIntentFlag=RenderingIntentFlag;var AnnotationMode={DISABLE:0,ENABLE:1,ENABLE_FORMS:2,ENABLE_STORAGE:3};exports.AnnotationMode=AnnotationMode;var AnnotationEditorPrefix="pdfjs_internal_editor_";exports.AnnotationEditorPrefix=AnnotationEditorPrefix;var AnnotationEditorType={DISABLE:-1,NONE:0,FREETEXT:3,STAMP:13,INK:15};exports.AnnotationEditorType=AnnotationEditorType;var AnnotationEditorParamsType={RESIZE:1,CREATE:2,FREETEXT_SIZE:11,FREETEXT_COLOR:12,FREETEXT_OPACITY:13,INK_COLOR:21,INK_THICKNESS:22,INK_OPACITY:23};exports.AnnotationEditorParamsType=AnnotationEditorParamsType;var PermissionFlag={PRINT:0x04,MODIFY_CONTENTS:0x08,COPY:0x10,MODIFY_ANNOTATIONS:0x20,FILL_INTERACTIVE_FORMS:0x100,COPY_FOR_ACCESSIBILITY:0x200,ASSEMBLE:0x400,PRINT_HIGH_QUALITY:0x800};exports.PermissionFlag=PermissionFlag;var TextRenderingMode={FILL:0,STROKE:1,FILL_STROKE:2,INVISIBLE:3,FILL_ADD_TO_PATH:4,STROKE_ADD_TO_PATH:5,FILL_STROKE_ADD_TO_PATH:6,ADD_TO_PATH:7,FILL_STROKE_MASK:3,ADD_TO_PATH_FLAG:4};exports.TextRenderingMode=TextRenderingMode;var ImageKind={GRAYSCALE_1BPP:1,RGB_24BPP:2,RGBA_32BPP:3};exports.ImageKind=ImageKind;var AnnotationType={TEXT:1,LINK:2,FREETEXT:3,LINE:4,SQUARE:5,CIRCLE:6,POLYGON:7,POLYLINE:8,HIGHLIGHT:9,UNDERLINE:10,SQUIGGLY:11,STRIKEOUT:12,STAMP:13,CARET:14,INK:15,POPUP:16,FILEATTACHMENT:17,SOUND:18,MOVIE:19,WIDGET:20,SCREEN:21,PRINTERMARK:22,TRAPNET:23,WATERMARK:24,THREED:25,REDACT:26};exports.AnnotationType=AnnotationType;var AnnotationReplyType={GROUP:"Group",REPLY:"R"};exports.AnnotationReplyType=AnnotationReplyType;var AnnotationFlag={INVISIBLE:0x01,HIDDEN:0x02,PRINT:0x04,NOZOOM:0x08,NOROTATE:0x10,NOVIEW:0x20,READONLY:0x40,LOCKED:0x80,TOGGLENOVIEW:0x100,LOCKEDCONTENTS:0x200};exports.AnnotationFlag=AnnotationFlag;var AnnotationFieldFlag={READONLY:0x0000001,REQUIRED:0x0000002,NOEXPORT:0x0000004,MULTILINE:0x0001000,PASSWORD:0x0002000,NOTOGGLETOOFF:0x0004000,RADIO:0x0008000,PUSHBUTTON:0x0010000,COMBO:0x0020000,EDIT:0x0040000,SORT:0x0080000,FILESELECT:0x0100000,MULTISELECT:0x0200000,DONOTSPELLCHECK:0x0400000,DONOTSCROLL:0x0800000,COMB:0x1000000,RICHTEXT:0x2000000,RADIOSINUNISON:0x2000000,COMMITONSELCHANGE:0x4000000};exports.AnnotationFieldFlag=AnnotationFieldFlag;var AnnotationBorderStyleType={SOLID:1,DASHED:2,BEVELED:3,INSET:4,UNDERLINE:5};exports.AnnotationBorderStyleType=AnnotationBorderStyleType;var AnnotationActionEventType={E:"Mouse Enter",X:"Mouse Exit",D:"Mouse Down",U:"Mouse Up",Fo:"Focus",Bl:"Blur",PO:"PageOpen",PC:"PageClose",PV:"PageVisible",PI:"PageInvisible",K:"Keystroke",F:"Format",V:"Validate",C:"Calculate"};exports.AnnotationActionEventType=AnnotationActionEventType;var DocumentActionEventType={WC:"WillClose",WS:"WillSave",DS:"DidSave",WP:"WillPrint",DP:"DidPrint"};exports.DocumentActionEventType=DocumentActionEventType;var PageActionEventType={O:"PageOpen",C:"PageClose"};exports.PageActionEventType=PageActionEventType;var VerbosityLevel={ERRORS:0,WARNINGS:1,INFOS:5};exports.VerbosityLevel=VerbosityLevel;var CMapCompressionType={NONE:0,BINARY:1};exports.CMapCompressionType=CMapCompressionType;var OPS={dependency:1,setLineWidth:2,setLineCap:3,setLineJoin:4,setMiterLimit:5,setDash:6,setRenderingIntent:7,setFlatness:8,setGState:9,save:10,restore:11,transform:12,moveTo:13,lineTo:14,curveTo:15,curveTo2:16,curveTo3:17,closePath:18,rectangle:19,stroke:20,closeStroke:21,fill:22,eoFill:23,fillStroke:24,eoFillStroke:25,closeFillStroke:26,closeEOFillStroke:27,endPath:28,clip:29,eoClip:30,beginText:31,endText:32,setCharSpacing:33,setWordSpacing:34,setHScale:35,setLeading:36,setFont:37,setTextRenderingMode:38,setTextRise:39,moveText:40,setLeadingMoveText:41,setTextMatrix:42,nextLine:43,showText:44,showSpacedText:45,nextLineShowText:46,nextLineSetSpacingShowText:47,setCharWidth:48,setCharWidthAndBounds:49,setStrokeColorSpace:50,setFillColorSpace:51,setStrokeColor:52,setStrokeColorN:53,setFillColor:54,setFillColorN:55,setStrokeGray:56,setFillGray:57,setStrokeRGBColor:58,setFillRGBColor:59,setStrokeCMYKColor:60,setFillCMYKColor:61,shadingFill:62,beginInlineImage:63,beginImageData:64,endInlineImage:65,paintXObject:66,markPoint:67,markPointProps:68,beginMarkedContent:69,beginMarkedContentProps:70,endMarkedContent:71,beginCompat:72,endCompat:73,paintFormXObjectBegin:74,paintFormXObjectEnd:75,beginGroup:76,endGroup:77,beginAnnotation:80,endAnnotation:81,paintImageMaskXObject:83,paintImageMaskXObjectGroup:84,paintImageXObject:85,paintInlineImageXObject:86,paintInlineImageXObjectGroup:87,paintImageXObjectRepeat:88,paintImageMaskXObjectRepeat:89,paintSolidColorImageMask:90,constructPath:91};exports.OPS=OPS;var PasswordResponses={NEED_PASSWORD:1,INCORRECT_PASSWORD:2};exports.PasswordResponses=PasswordResponses;var verbosity=VerbosityLevel.WARNINGS;function setVerbosityLevel(level){if(Number.isInteger(level)){verbosity=level;}}function getVerbosityLevel(){return verbosity;}function info(msg){if(verbosity>=VerbosityLevel.INFOS){if(typeof WorkerGlobalScope!=="undefined"&&self instanceof WorkerGlobalScope){console.log("Info: ".concat(msg));}else if(Window&&globalThis.ngxConsole){globalThis.ngxConsole.log("Info: ".concat(msg));}else{console.log("Info: ".concat(msg));}}}function warn(msg){if(verbosity>=VerbosityLevel.WARNINGS){if(typeof WorkerGlobalScope!=="undefined"&&self instanceof WorkerGlobalScope){console.log("Warning: ".concat(msg));}else if(Window&&globalThis.ngxConsole){globalThis.ngxConsole.log("Warning: ".concat(msg));}else{console.log("Warning: ".concat(msg));}}}function unreachable(msg){throw new Error(msg);}function assert(cond,msg){if(!cond){unreachable(msg);}}function _isValidProtocol(url){switch(url===null||url===void 0?void 0:url.protocol){case"http:":case"https:":case"ftp:":case"mailto:":case"tel:":case"capacitor":return true;default:return false;}}function createValidAbsoluteUrl(url){var baseUrl=arguments.length>1&&arguments[1]!==undefined?arguments[1]:null;var options=arguments.length>2&&arguments[2]!==undefined?arguments[2]:null;if(!url){return null;}try{if(options&&typeof url==="string"){if(options.addDefaultProtocol&&url.startsWith("www.")){var dots=url.match(/\./g);if((dots===null||dots===void 0?void 0:dots.length)>=2){url="http://".concat(url);}}if(options.tryConvertEncoding){try{url=stringToUTF8String(url);}catch(_unused){}}}var absoluteUrl=baseUrl?new URL(url,baseUrl):new URL(url);if(_isValidProtocol(absoluteUrl)){return absoluteUrl;}}catch(_unused2){}return null;}function shadow(obj,prop,value){var nonSerializable=arguments.length>3&&arguments[3]!==undefined?arguments[3]:false;Object.defineProperty(obj,prop,{value:value,enumerable:!nonSerializable,configurable:true,writable:false});return value;}var BaseException=function BaseExceptionClosure(){function BaseException(message,name){if(this.constructor===BaseException){unreachable("Cannot initialize BaseException.");}this.message=message;this.name=name;}BaseException.prototype=new Error();BaseException.constructor=BaseException;return BaseException;}();exports.BaseException=BaseException;var PasswordException=/*#__PURE__*/function(_BaseException){_inherits(PasswordException,_BaseException);var _super=_createSuper(PasswordException);function PasswordException(msg,code){var _this;_classCallCheck(this,PasswordException);_this=_super.call(this,msg,"PasswordException");_this.code=code;return _this;}return _createClass(PasswordException);}(BaseException);exports.PasswordException=PasswordException;var UnknownErrorException=/*#__PURE__*/function(_BaseException2){_inherits(UnknownErrorException,_BaseException2);var _super2=_createSuper(UnknownErrorException);function UnknownErrorException(msg,details){var _this2;_classCallCheck(this,UnknownErrorException);_this2=_super2.call(this,msg,"UnknownErrorException");_this2.details=details;return _this2;}return _createClass(UnknownErrorException);}(BaseException);exports.UnknownErrorException=UnknownErrorException;var InvalidPDFException=/*#__PURE__*/function(_BaseException3){_inherits(InvalidPDFException,_BaseException3);var _super3=_createSuper(InvalidPDFException);function InvalidPDFException(msg){_classCallCheck(this,InvalidPDFException);return _super3.call(this,msg,"InvalidPDFException");}return _createClass(InvalidPDFException);}(BaseException);exports.InvalidPDFException=InvalidPDFException;var MissingPDFException=/*#__PURE__*/function(_BaseException4){_inherits(MissingPDFException,_BaseException4);var _super4=_createSuper(MissingPDFException);function MissingPDFException(msg){_classCallCheck(this,MissingPDFException);return _super4.call(this,msg,"MissingPDFException");}return _createClass(MissingPDFException);}(BaseException);exports.MissingPDFException=MissingPDFException;var UnexpectedResponseException=/*#__PURE__*/function(_BaseException5){_inherits(UnexpectedResponseException,_BaseException5);var _super5=_createSuper(UnexpectedResponseException);function UnexpectedResponseException(msg,status){var _this3;_classCallCheck(this,UnexpectedResponseException);_this3=_super5.call(this,msg,"UnexpectedResponseException");_this3.status=status;return _this3;}return _createClass(UnexpectedResponseException);}(BaseException);exports.UnexpectedResponseException=UnexpectedResponseException;var FormatError=/*#__PURE__*/function(_BaseException6){_inherits(FormatError,_BaseException6);var _super6=_createSuper(FormatError);function FormatError(msg){_classCallCheck(this,FormatError);return _super6.call(this,msg,"FormatError");}return _createClass(FormatError);}(BaseException);exports.FormatError=FormatError;var AbortException=/*#__PURE__*/function(_BaseException7){_inherits(AbortException,_BaseException7);var _super7=_createSuper(AbortException);function AbortException(msg){_classCallCheck(this,AbortException);return _super7.call(this,msg,"AbortException");}return _createClass(AbortException);}(BaseException);exports.AbortException=AbortException;function bytesToString(bytes){if(_typeof(bytes)!=="object"||(bytes===null||bytes===void 0?void 0:bytes.length)===undefined){unreachable("Invalid argument for bytesToString");}var length=bytes.length;var MAX_ARGUMENT_COUNT=8192;if(length<MAX_ARGUMENT_COUNT){return String.fromCharCode.apply(null,bytes);}var strBuf=[];for(var i=0;i<length;i+=MAX_ARGUMENT_COUNT){var chunkEnd=Math.min(i+MAX_ARGUMENT_COUNT,length);var chunk=bytes.subarray(i,chunkEnd);strBuf.push(String.fromCharCode.apply(null,chunk));}return strBuf.join("");}function stringToBytes(str){if(typeof str!=="string"){unreachable("Invalid argument for stringToBytes");}var length=str.length;var bytes=new Uint8Array(length);for(var i=0;i<length;++i){bytes[i]=str.charCodeAt(i)&0xff;}return bytes;}function string32(value){return String.fromCharCode(value>>24&0xff,value>>16&0xff,value>>8&0xff,value&0xff);}function objectSize(obj){return Object.keys(obj).length;}function objectFromMap(map){var obj=Object.create(null);var _iterator=_createForOfIteratorHelper(map),_step;try{for(_iterator.s();!(_step=_iterator.n()).done;){var _step$value=_slicedToArray(_step.value,2),key=_step$value[0],value=_step$value[1];obj[key]=value;}}catch(err){_iterator.e(err);}finally{_iterator.f();}return obj;}function isLittleEndian(){var buffer8=new Uint8Array(4);buffer8[0]=1;var view32=new Uint32Array(buffer8.buffer,0,1);return view32[0]===1;}function isEvalSupported(){try{new Function("");return true;}catch(_unused3){return false;}}var FeatureTest=/*#__PURE__*/function(){function FeatureTest(){_classCallCheck(this,FeatureTest);}_createClass(FeatureTest,null,[{key:"isLittleEndian",get:function get(){return shadow(this,"isLittleEndian",isLittleEndian());}},{key:"isEvalSupported",get:function get(){return shadow(this,"isEvalSupported",isEvalSupported());}},{key:"isOffscreenCanvasSupported",get:function get(){return shadow(this,"isOffscreenCanvasSupported",typeof OffscreenCanvas!=="undefined");}},{key:"platform",get:function get(){if(typeof navigator==="undefined"){return shadow(this,"platform",{isWin:false,isMac:false});}return shadow(this,"platform",{isWin:navigator.platform.includes("Win"),isMac:navigator.platform.includes("Mac")});}},{key:"isCSSRoundSupported",get:function get(){var _globalThis$CSS,_globalThis$CSS$suppo;return shadow(this,"isCSSRoundSupported",(_globalThis$CSS=globalThis.CSS)===null||_globalThis$CSS===void 0||(_globalThis$CSS$suppo=_globalThis$CSS.supports)===null||_globalThis$CSS$suppo===void 0?void 0:_globalThis$CSS$suppo.call(_globalThis$CSS,"width: round(1.5px, 1px)"));}}]);return FeatureTest;}();exports.FeatureTest=FeatureTest;var hexNumbers=_toConsumableArray(Array(256).keys()).map(function(n){return n.toString(16).padStart(2,"0");});var Util=/*#__PURE__*/function(){function Util(){_classCallCheck(this,Util);}_createClass(Util,null,[{key:"makeHexColor",value:function makeHexColor(r,g,b){return"#".concat(hexNumbers[r]).concat(hexNumbers[g]).concat(hexNumbers[b]);}},{key:"scaleMinMax",value:function scaleMinMax(transform,minMax){var temp;if(transform[0]){if(transform[0]<0){temp=minMax[0];minMax[0]=minMax[1];minMax[1]=temp;}minMax[0]*=transform[0];minMax[1]*=transform[0];if(transform[3]<0){temp=minMax[2];minMax[2]=minMax[3];minMax[3]=temp;}minMax[2]*=transform[3];minMax[3]*=transform[3];}else{temp=minMax[0];minMax[0]=minMax[2];minMax[2]=temp;temp=minMax[1];minMax[1]=minMax[3];minMax[3]=temp;if(transform[1]<0){temp=minMax[2];minMax[2]=minMax[3];minMax[3]=temp;}minMax[2]*=transform[1];minMax[3]*=transform[1];if(transform[2]<0){temp=minMax[0];minMax[0]=minMax[1];minMax[1]=temp;}minMax[0]*=transform[2];minMax[1]*=transform[2];}minMax[0]+=transform[4];minMax[1]+=transform[4];minMax[2]+=transform[5];minMax[3]+=transform[5];}},{key:"transform",value:function transform(m1,m2){return[m1[0]*m2[0]+m1[2]*m2[1],m1[1]*m2[0]+m1[3]*m2[1],m1[0]*m2[2]+m1[2]*m2[3],m1[1]*m2[2]+m1[3]*m2[3],m1[0]*m2[4]+m1[2]*m2[5]+m1[4],m1[1]*m2[4]+m1[3]*m2[5]+m1[5]];}},{key:"applyTransform",value:function applyTransform(p,m){var xt=p[0]*m[0]+p[1]*m[2]+m[4];var yt=p[0]*m[1]+p[1]*m[3]+m[5];return[xt,yt];}},{key:"applyInverseTransform",value:function applyInverseTransform(p,m){var d=m[0]*m[3]-m[1]*m[2];var xt=(p[0]*m[3]-p[1]*m[2]+m[2]*m[5]-m[4]*m[3])/d;var yt=(-p[0]*m[1]+p[1]*m[0]+m[4]*m[1]-m[5]*m[0])/d;return[xt,yt];}},{key:"getAxialAlignedBoundingBox",value:function getAxialAlignedBoundingBox(r,m){var p1=this.applyTransform(r,m);var p2=this.applyTransform(r.slice(2,4),m);var p3=this.applyTransform([r[0],r[3]],m);var p4=this.applyTransform([r[2],r[1]],m);return[Math.min(p1[0],p2[0],p3[0],p4[0]),Math.min(p1[1],p2[1],p3[1],p4[1]),Math.max(p1[0],p2[0],p3[0],p4[0]),Math.max(p1[1],p2[1],p3[1],p4[1])];}},{key:"inverseTransform",value:function inverseTransform(m){var d=m[0]*m[3]-m[1]*m[2];return[m[3]/d,-m[1]/d,-m[2]/d,m[0]/d,(m[2]*m[5]-m[4]*m[3])/d,(m[4]*m[1]-m[5]*m[0])/d];}},{key:"singularValueDecompose2dScale",value:function singularValueDecompose2dScale(m){var transpose=[m[0],m[2],m[1],m[3]];var a=m[0]*transpose[0]+m[1]*transpose[2];var b=m[0]*transpose[1]+m[1]*transpose[3];var c=m[2]*transpose[0]+m[3]*transpose[2];var d=m[2]*transpose[1]+m[3]*transpose[3];var first=(a+d)/2;var second=Math.sqrt(Math.pow(a+d,2)-4*(a*d-c*b))/2;var sx=first+second||1;var sy=first-second||1;return[Math.sqrt(sx),Math.sqrt(sy)];}},{key:"normalizeRect",value:function normalizeRect(rect){var r=rect.slice(0);if(rect[0]>rect[2]){r[0]=rect[2];r[2]=rect[0];}if(rect[1]>rect[3]){r[1]=rect[3];r[3]=rect[1];}return r;}},{key:"intersect",value:function intersect(rect1,rect2){var xLow=Math.max(Math.min(rect1[0],rect1[2]),Math.min(rect2[0],rect2[2]));var xHigh=Math.min(Math.max(rect1[0],rect1[2]),Math.max(rect2[0],rect2[2]));if(xLow>xHigh){return null;}var yLow=Math.max(Math.min(rect1[1],rect1[3]),Math.min(rect2[1],rect2[3]));var yHigh=Math.min(Math.max(rect1[1],rect1[3]),Math.max(rect2[1],rect2[3]));if(yLow>yHigh){return null;}return[xLow,yLow,xHigh,yHigh];}},{key:"bezierBoundingBox",value:function bezierBoundingBox(x0,y0,x1,y1,x2,y2,x3,y3){var tvalues=[],bounds=[[],[]];var a,b,c,t,t1,t2,b2ac,sqrtb2ac;for(var i=0;i<2;++i){if(i===0){b=6*x0-12*x1+6*x2;a=-3*x0+9*x1-9*x2+3*x3;c=3*x1-3*x0;}else{b=6*y0-12*y1+6*y2;a=-3*y0+9*y1-9*y2+3*y3;c=3*y1-3*y0;}if(Math.abs(a)<1e-12){if(Math.abs(b)<1e-12){continue;}t=-c/b;if(0<t&&t<1){tvalues.push(t);}continue;}b2ac=b*b-4*c*a;sqrtb2ac=Math.sqrt(b2ac);if(b2ac<0){continue;}t1=(-b+sqrtb2ac)/(2*a);if(0<t1&&t1<1){tvalues.push(t1);}t2=(-b-sqrtb2ac)/(2*a);if(0<t2&&t2<1){tvalues.push(t2);}}var j=tvalues.length,mt;var jlen=j;while(j--){t=tvalues[j];mt=1-t;bounds[0][j]=mt*mt*mt*x0+3*mt*mt*t*x1+3*mt*t*t*x2+t*t*t*x3;bounds[1][j]=mt*mt*mt*y0+3*mt*mt*t*y1+3*mt*t*t*y2+t*t*t*y3;}bounds[0][jlen]=x0;bounds[1][jlen]=y0;bounds[0][jlen+1]=x3;bounds[1][jlen+1]=y3;bounds[0].length=bounds[1].length=jlen+2;return[Math.min.apply(Math,_toConsumableArray(bounds[0])),Math.min.apply(Math,_toConsumableArray(bounds[1])),Math.max.apply(Math,_toConsumableArray(bounds[0])),Math.max.apply(Math,_toConsumableArray(bounds[1]))];}}]);return Util;}();exports.Util=Util;var PDFStringTranslateTable=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0x2d8,0x2c7,0x2c6,0x2d9,0x2dd,0x2db,0x2da,0x2dc,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0x2022,0x2020,0x2021,0x2026,0x2014,0x2013,0x192,0x2044,0x2039,0x203a,0x2212,0x2030,0x201e,0x201c,0x201d,0x2018,0x2019,0x201a,0x2122,0xfb01,0xfb02,0x141,0x152,0x160,0x178,0x17d,0x131,0x142,0x153,0x161,0x17e,0,0x20ac];function stringToPDFString(str){if(str[0]>="\xEF"){var encoding;if(str[0]==="\xFE"&&str[1]==="\xFF"){encoding="utf-16be";}else if(str[0]==="\xFF"&&str[1]==="\xFE"){encoding="utf-16le";}else if(str[0]==="\xEF"&&str[1]==="\xBB"&&str[2]==="\xBF"){encoding="utf-8";}if(encoding){try{var decoder=new TextDecoder(encoding,{fatal:true});var buffer=stringToBytes(str);return decoder.decode(buffer);}catch(ex){warn("stringToPDFString: \"".concat(ex,"\"."));}}}var strBuf=[];for(var i=0,ii=str.length;i<ii;i++){var code=PDFStringTranslateTable[str.charCodeAt(i)];strBuf.push(code?String.fromCharCode(code):str.charAt(i));}return strBuf.join("");}function stringToUTF8String(str){return decodeURIComponent(escape(str));}function utf8StringToString(str){return unescape(encodeURIComponent(str));}function isArrayBuffer(v){return _typeof(v)==="object"&&(v===null||v===void 0?void 0:v.byteLength)!==undefined;}function isArrayEqual(arr1,arr2){if(arr1.length!==arr2.length){return false;}for(var i=0,ii=arr1.length;i<ii;i++){if(arr1[i]!==arr2[i]){return false;}}return true;}function getModificationDate(){var date=arguments.length>0&&arguments[0]!==undefined?arguments[0]:new Date();var buffer=[date.getUTCFullYear().toString(),(date.getUTCMonth()+1).toString().padStart(2,"0"),date.getUTCDate().toString().padStart(2,"0"),date.getUTCHours().toString().padStart(2,"0"),date.getUTCMinutes().toString().padStart(2,"0"),date.getUTCSeconds().toString().padStart(2,"0")];return buffer.join("");}var _settled=/*#__PURE__*/new WeakMap();var PromiseCapability=/*#__PURE__*/function(){function PromiseCapability(){var _this4=this;_classCallCheck(this,PromiseCapability);_classPrivateFieldInitSpec(this,_settled,{writable:true,value:false});this.promise=new Promise(function(resolve,reject){_this4.resolve=function(data){_classPrivateFieldSet(_this4,_settled,true);resolve(data);};_this4.reject=function(reason){_classPrivateFieldSet(_this4,_settled,true);reject(reason);};});}_createClass(PromiseCapability,[{key:"settled",get:function get(){return _classPrivateFieldGet(this,_settled);}}]);return PromiseCapability;}();exports.PromiseCapability=PromiseCapability;var NormalizeRegex=null;var NormalizationMap=null;function normalizeUnicode(str){if(!NormalizeRegex){NormalizeRegex=/([\xA0\xB5\u037E\u0EB3\u2000-\u200A\u202F\u2126\uFB00-\uFB04\uFB06\uFB20-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBA1\uFBA4-\uFBA9\uFBAE-\uFBB1\uFBD3-\uFBDC\uFBDE-\uFBE7\uFBEA-\uFBF8\uFBFC\uFBFD\uFC00-\uFC5D\uFC64-\uFCF1\uFCF5-\uFD3D\uFD88\uFDF4\uFDFA\uFDFB\uFE71\uFE77\uFE79\uFE7B\uFE7D]+)|(\uFB05+)/g;NormalizationMap=new Map([["ﬅ","ſt"]]);}return str.replaceAll(NormalizeRegex,function(_,p1,p2){return p1?p1.normalize("NFKC"):NormalizationMap.get(p2);});}function getUuid(){var _crypto,_crypto2;if(typeof crypto!=="undefined"&&typeof((_crypto=crypto)===null||_crypto===void 0?void 0:_crypto.randomUUID)==="function"){return crypto.randomUUID();}var buf=new Uint8Array(32);if(typeof crypto!=="undefined"&&typeof((_crypto2=crypto)===null||_crypto2===void 0?void 0:_crypto2.getRandomValues)==="function"){crypto.getRandomValues(buf);}else{for(var i=0;i<32;i++){buf[i]=Math.floor(Math.random()*255);}}return bytesToString(buf);}

/***/ }),
/* 304 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var global = __w_pdfjs_require__(5);
var setToStringTag = __w_pdfjs_require__(88);
$({ global: true }, { Reflect: {} });
setToStringTag(global.Reflect, 'Reflect', true);

/***/ }),
/* 305 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var getBuiltIn = __w_pdfjs_require__(37);
var apply = __w_pdfjs_require__(100);
var bind = __w_pdfjs_require__(306);
var aConstructor = __w_pdfjs_require__(151);
var anObject = __w_pdfjs_require__(32);
var isObject = __w_pdfjs_require__(28);
var create = __w_pdfjs_require__(80);
var fails = __w_pdfjs_require__(9);
var nativeConstruct = getBuiltIn('Reflect', 'construct');
var ObjectPrototype = Object.prototype;
var push = [].push;
var NEW_TARGET_BUG = fails(function () {
 function F() {
 }
 return !(nativeConstruct(function () {
 }, [], F) instanceof F);
});
var ARGS_BUG = !fails(function () {
 nativeConstruct(function () {
 });
});
var FORCED = NEW_TARGET_BUG || ARGS_BUG;
$({
 target: 'Reflect',
 stat: true,
 forced: FORCED,
 sham: FORCED
}, {
 construct: function construct(Target, args) {
  aConstructor(Target);
  anObject(args);
  var newTarget = arguments.length < 3 ? Target : aConstructor(arguments[2]);
  if (ARGS_BUG && !NEW_TARGET_BUG)
   return nativeConstruct(Target, args, newTarget);
  if (Target == newTarget) {
   switch (args.length) {
   case 0:
    return new Target();
   case 1:
    return new Target(args[0]);
   case 2:
    return new Target(args[0], args[1]);
   case 3:
    return new Target(args[0], args[1], args[2]);
   case 4:
    return new Target(args[0], args[1], args[2], args[3]);
   }
   var $args = [null];
   apply(push, $args, args);
   return new (apply(bind, Target, $args))();
  }
  var proto = newTarget.prototype;
  var instance = create(isObject(proto) ? proto : ObjectPrototype);
  var result = apply(Target, instance, args);
  return isObject(result) ? result : instance;
 }
});

/***/ }),
/* 306 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var aCallable = __w_pdfjs_require__(40);
var isObject = __w_pdfjs_require__(28);
var hasOwn = __w_pdfjs_require__(6);
var arraySlice = __w_pdfjs_require__(101);
var NATIVE_BIND = __w_pdfjs_require__(8);
var $Function = Function;
var concat = uncurryThis([].concat);
var join = uncurryThis([].join);
var factories = {};
var construct = function (C, argsLength, args) {
 if (!hasOwn(factories, argsLength)) {
  for (var list = [], i = 0; i < argsLength; i++)
   list[i] = 'a[' + i + ']';
  factories[argsLength] = $Function('C,a', 'return new C(' + join(list, ',') + ')');
 }
 return factories[argsLength](C, args);
};
module.exports = NATIVE_BIND ? $Function.bind : function bind(that) {
 var F = aCallable(this);
 var Prototype = F.prototype;
 var partArgs = arraySlice(arguments, 1);
 var boundFunction = function bound() {
  var args = concat(partArgs, arraySlice(arguments));
  return this instanceof boundFunction ? construct(F, args.length, args) : F.apply(that, args);
 };
 if (isObject(Prototype))
  boundFunction.prototype = Prototype;
 return boundFunction;
};

/***/ }),
/* 307 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var global = __w_pdfjs_require__(5);
$({
 global: true,
 forced: global.globalThis !== global
}, { globalThis: global });

/***/ }),
/* 308 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var uncurryThis = __w_pdfjs_require__(91);
var getOwnPropertyDescriptor = (__w_pdfjs_require__(59).f);
var toLength = __w_pdfjs_require__(73);
var toString = __w_pdfjs_require__(77);
var notARegExp = __w_pdfjs_require__(309);
var requireObjectCoercible = __w_pdfjs_require__(11);
var correctIsRegExpLogic = __w_pdfjs_require__(311);
var IS_PURE = __w_pdfjs_require__(16);
var nativeStartsWith = uncurryThis(''.startsWith);
var stringSlice = uncurryThis(''.slice);
var min = Math.min;
var CORRECT_IS_REGEXP_LOGIC = correctIsRegExpLogic('startsWith');
var MDN_POLYFILL_BUG = !IS_PURE && !CORRECT_IS_REGEXP_LOGIC && !!(function () {
 var descriptor = getOwnPropertyDescriptor(String.prototype, 'startsWith');
 return descriptor && !descriptor.writable;
}());
$({
 target: 'String',
 proto: true,
 forced: !MDN_POLYFILL_BUG && !CORRECT_IS_REGEXP_LOGIC
}, {
 startsWith: function startsWith(searchString) {
  var that = toString(requireObjectCoercible(this));
  notARegExp(searchString);
  var index = toLength(min(arguments.length > 1 ? arguments[1] : undefined, that.length));
  var search = toString(searchString);
  return nativeStartsWith ? nativeStartsWith(that, search, index) : stringSlice(that, index, index + search.length) === search;
 }
});

/***/ }),
/* 309 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var isRegExp = __w_pdfjs_require__(310);
var $TypeError = TypeError;
module.exports = function (it) {
 if (isRegExp(it)) {
  throw $TypeError("The method doesn't accept regular expressions");
 }
 return it;
};

/***/ }),
/* 310 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var isObject = __w_pdfjs_require__(28);
var classof = __w_pdfjs_require__(63);
var wellKnownSymbol = __w_pdfjs_require__(14);
var MATCH = wellKnownSymbol('match');
module.exports = function (it) {
 var isRegExp;
 return isObject(it) && ((isRegExp = it[MATCH]) !== undefined ? !!isRegExp : classof(it) == 'RegExp');
};

/***/ }),
/* 311 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var wellKnownSymbol = __w_pdfjs_require__(14);
var MATCH = wellKnownSymbol('match');
module.exports = function (METHOD_NAME) {
 var regexp = /./;
 try {
  '/./'[METHOD_NAME](regexp);
 } catch (error1) {
  try {
   regexp[MATCH] = false;
   return '/./'[METHOD_NAME](regexp);
  } catch (error2) {
  }
 }
 return false;
};

/***/ }),
/* 312 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var call = __w_pdfjs_require__(35);
var fixRegExpWellKnownSymbolLogic = __w_pdfjs_require__(313);
var anObject = __w_pdfjs_require__(32);
var isNullOrUndefined = __w_pdfjs_require__(12);
var toLength = __w_pdfjs_require__(73);
var toString = __w_pdfjs_require__(77);
var requireObjectCoercible = __w_pdfjs_require__(11);
var getMethod = __w_pdfjs_require__(39);
var advanceStringIndex = __w_pdfjs_require__(314);
var regExpExec = __w_pdfjs_require__(315);
fixRegExpWellKnownSymbolLogic('match', function (MATCH, nativeMatch, maybeCallNative) {
 return [
  function match(regexp) {
   var O = requireObjectCoercible(this);
   var matcher = isNullOrUndefined(regexp) ? undefined : getMethod(regexp, MATCH);
   return matcher ? call(matcher, regexp, O) : new RegExp(regexp)[MATCH](toString(O));
  },
  function (string) {
   var rx = anObject(this);
   var S = toString(string);
   var res = maybeCallNative(nativeMatch, rx, S);
   if (res.done)
    return res.value;
   if (!rx.global)
    return regExpExec(rx, S);
   var fullUnicode = rx.unicode;
   rx.lastIndex = 0;
   var A = [];
   var n = 0;
   var result;
   while ((result = regExpExec(rx, S)) !== null) {
    var matchStr = toString(result[0]);
    A[n] = matchStr;
    if (matchStr === '')
     rx.lastIndex = advanceStringIndex(S, toLength(rx.lastIndex), fullUnicode);
    n++;
   }
   return n === 0 ? null : A;
  }
 ];
});

/***/ }),
/* 313 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


__w_pdfjs_require__(123);
var uncurryThis = __w_pdfjs_require__(91);
var defineBuiltIn = __w_pdfjs_require__(44);
var regexpExec = __w_pdfjs_require__(124);
var fails = __w_pdfjs_require__(9);
var wellKnownSymbol = __w_pdfjs_require__(14);
var createNonEnumerableProperty = __w_pdfjs_require__(50);
var SPECIES = wellKnownSymbol('species');
var RegExpPrototype = RegExp.prototype;
module.exports = function (KEY, exec, FORCED, SHAM) {
 var SYMBOL = wellKnownSymbol(KEY);
 var DELEGATES_TO_SYMBOL = !fails(function () {
  var O = {};
  O[SYMBOL] = function () {
   return 7;
  };
  return ''[KEY](O) != 7;
 });
 var DELEGATES_TO_EXEC = DELEGATES_TO_SYMBOL && !fails(function () {
  var execCalled = false;
  var re = /a/;
  if (KEY === 'split') {
   re = {};
   re.constructor = {};
   re.constructor[SPECIES] = function () {
    return re;
   };
   re.flags = '';
   re[SYMBOL] = /./[SYMBOL];
  }
  re.exec = function () {
   execCalled = true;
   return null;
  };
  re[SYMBOL]('');
  return !execCalled;
 });
 if (!DELEGATES_TO_SYMBOL || !DELEGATES_TO_EXEC || FORCED) {
  var uncurriedNativeRegExpMethod = uncurryThis(/./[SYMBOL]);
  var methods = exec(SYMBOL, ''[KEY], function (nativeMethod, regexp, str, arg2, forceStringMethod) {
   var uncurriedNativeMethod = uncurryThis(nativeMethod);
   var $exec = regexp.exec;
   if ($exec === regexpExec || $exec === RegExpPrototype.exec) {
    if (DELEGATES_TO_SYMBOL && !forceStringMethod) {
     return {
      done: true,
      value: uncurriedNativeRegExpMethod(regexp, str, arg2)
     };
    }
    return {
     done: true,
     value: uncurriedNativeMethod(str, regexp, arg2)
    };
   }
   return { done: false };
  });
  defineBuiltIn(String.prototype, KEY, methods[0]);
  defineBuiltIn(RegExpPrototype, SYMBOL, methods[1]);
 }
 if (SHAM)
  createNonEnumerableProperty(RegExpPrototype[SYMBOL], 'sham', true);
};

/***/ }),
/* 314 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var charAt = (__w_pdfjs_require__(176).charAt);
module.exports = function (S, index, unicode) {
 return index + (unicode ? charAt(S, index).length : 1);
};

/***/ }),
/* 315 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var call = __w_pdfjs_require__(35);
var anObject = __w_pdfjs_require__(32);
var isCallable = __w_pdfjs_require__(29);
var classof = __w_pdfjs_require__(63);
var regexpExec = __w_pdfjs_require__(124);
var $TypeError = TypeError;
module.exports = function (R, S) {
 var exec = R.exec;
 if (isCallable(exec)) {
  var result = call(exec, R, S);
  if (result !== null)
   anObject(result);
  return result;
 }
 if (classof(R) === 'RegExp')
  return call(regexpExec, R, S);
 throw $TypeError('RegExp#exec called on incompatible receiver');
};

/***/ }),
/* 316 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


__w_pdfjs_require__(317);

/***/ }),
/* 317 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


__w_pdfjs_require__(175);
var $ = __w_pdfjs_require__(58);
var DESCRIPTORS = __w_pdfjs_require__(25);
var USE_NATIVE_URL = __w_pdfjs_require__(318);
var global = __w_pdfjs_require__(5);
var bind = __w_pdfjs_require__(90);
var uncurryThis = __w_pdfjs_require__(7);
var defineBuiltIn = __w_pdfjs_require__(44);
var defineBuiltInAccessor = __w_pdfjs_require__(87);
var anInstance = __w_pdfjs_require__(149);
var hasOwn = __w_pdfjs_require__(6);
var assign = __w_pdfjs_require__(319);
var arrayFrom = __w_pdfjs_require__(115);
var arraySlice = __w_pdfjs_require__(85);
var codeAt = (__w_pdfjs_require__(176).codeAt);
var toASCII = __w_pdfjs_require__(320);
var $toString = __w_pdfjs_require__(77);
var setToStringTag = __w_pdfjs_require__(88);
var validateArgumentsLength = __w_pdfjs_require__(153);
var URLSearchParamsModule = __w_pdfjs_require__(321);
var InternalStateModule = __w_pdfjs_require__(48);
var setInternalState = InternalStateModule.set;
var getInternalURLState = InternalStateModule.getterFor('URL');
var URLSearchParams = URLSearchParamsModule.URLSearchParams;
var getInternalSearchParamsState = URLSearchParamsModule.getState;
var NativeURL = global.URL;
var TypeError = global.TypeError;
var parseInt = global.parseInt;
var floor = Math.floor;
var pow = Math.pow;
var charAt = uncurryThis(''.charAt);
var exec = uncurryThis(/./.exec);
var join = uncurryThis([].join);
var numberToString = uncurryThis(1.0.toString);
var pop = uncurryThis([].pop);
var push = uncurryThis([].push);
var replace = uncurryThis(''.replace);
var shift = uncurryThis([].shift);
var split = uncurryThis(''.split);
var stringSlice = uncurryThis(''.slice);
var toLowerCase = uncurryThis(''.toLowerCase);
var unshift = uncurryThis([].unshift);
var INVALID_AUTHORITY = 'Invalid authority';
var INVALID_SCHEME = 'Invalid scheme';
var INVALID_HOST = 'Invalid host';
var INVALID_PORT = 'Invalid port';
var ALPHA = /[a-z]/i;
var ALPHANUMERIC = /[\d+-.a-z]/i;
var DIGIT = /\d/;
var HEX_START = /^0x/i;
var OCT = /^[0-7]+$/;
var DEC = /^\d+$/;
var HEX = /^[\da-f]+$/i;
var FORBIDDEN_HOST_CODE_POINT = /[\0\t\n\r #%/:<>?@[\\\]^|]/;
var FORBIDDEN_HOST_CODE_POINT_EXCLUDING_PERCENT = /[\0\t\n\r #/:<>?@[\\\]^|]/;
var LEADING_C0_CONTROL_OR_SPACE = /^[\u0000-\u0020]+/;
var TRAILING_C0_CONTROL_OR_SPACE = /(^|[^\u0000-\u0020])[\u0000-\u0020]+$/;
var TAB_AND_NEW_LINE = /[\t\n\r]/g;
var EOF;
var parseIPv4 = function (input) {
 var parts = split(input, '.');
 var partsLength, numbers, index, part, radix, number, ipv4;
 if (parts.length && parts[parts.length - 1] == '') {
  parts.length--;
 }
 partsLength = parts.length;
 if (partsLength > 4)
  return input;
 numbers = [];
 for (index = 0; index < partsLength; index++) {
  part = parts[index];
  if (part == '')
   return input;
  radix = 10;
  if (part.length > 1 && charAt(part, 0) == '0') {
   radix = exec(HEX_START, part) ? 16 : 8;
   part = stringSlice(part, radix == 8 ? 1 : 2);
  }
  if (part === '') {
   number = 0;
  } else {
   if (!exec(radix == 10 ? DEC : radix == 8 ? OCT : HEX, part))
    return input;
   number = parseInt(part, radix);
  }
  push(numbers, number);
 }
 for (index = 0; index < partsLength; index++) {
  number = numbers[index];
  if (index == partsLength - 1) {
   if (number >= pow(256, 5 - partsLength))
    return null;
  } else if (number > 255)
   return null;
 }
 ipv4 = pop(numbers);
 for (index = 0; index < numbers.length; index++) {
  ipv4 += numbers[index] * pow(256, 3 - index);
 }
 return ipv4;
};
var parseIPv6 = function (input) {
 var address = [
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0
 ];
 var pieceIndex = 0;
 var compress = null;
 var pointer = 0;
 var value, length, numbersSeen, ipv4Piece, number, swaps, swap;
 var chr = function () {
  return charAt(input, pointer);
 };
 if (chr() == ':') {
  if (charAt(input, 1) != ':')
   return;
  pointer += 2;
  pieceIndex++;
  compress = pieceIndex;
 }
 while (chr()) {
  if (pieceIndex == 8)
   return;
  if (chr() == ':') {
   if (compress !== null)
    return;
   pointer++;
   pieceIndex++;
   compress = pieceIndex;
   continue;
  }
  value = length = 0;
  while (length < 4 && exec(HEX, chr())) {
   value = value * 16 + parseInt(chr(), 16);
   pointer++;
   length++;
  }
  if (chr() == '.') {
   if (length == 0)
    return;
   pointer -= length;
   if (pieceIndex > 6)
    return;
   numbersSeen = 0;
   while (chr()) {
    ipv4Piece = null;
    if (numbersSeen > 0) {
     if (chr() == '.' && numbersSeen < 4)
      pointer++;
     else
      return;
    }
    if (!exec(DIGIT, chr()))
     return;
    while (exec(DIGIT, chr())) {
     number = parseInt(chr(), 10);
     if (ipv4Piece === null)
      ipv4Piece = number;
     else if (ipv4Piece == 0)
      return;
     else
      ipv4Piece = ipv4Piece * 10 + number;
     if (ipv4Piece > 255)
      return;
     pointer++;
    }
    address[pieceIndex] = address[pieceIndex] * 256 + ipv4Piece;
    numbersSeen++;
    if (numbersSeen == 2 || numbersSeen == 4)
     pieceIndex++;
   }
   if (numbersSeen != 4)
    return;
   break;
  } else if (chr() == ':') {
   pointer++;
   if (!chr())
    return;
  } else if (chr())
   return;
  address[pieceIndex++] = value;
 }
 if (compress !== null) {
  swaps = pieceIndex - compress;
  pieceIndex = 7;
  while (pieceIndex != 0 && swaps > 0) {
   swap = address[pieceIndex];
   address[pieceIndex--] = address[compress + swaps - 1];
   address[compress + --swaps] = swap;
  }
 } else if (pieceIndex != 8)
  return;
 return address;
};
var findLongestZeroSequence = function (ipv6) {
 var maxIndex = null;
 var maxLength = 1;
 var currStart = null;
 var currLength = 0;
 var index = 0;
 for (; index < 8; index++) {
  if (ipv6[index] !== 0) {
   if (currLength > maxLength) {
    maxIndex = currStart;
    maxLength = currLength;
   }
   currStart = null;
   currLength = 0;
  } else {
   if (currStart === null)
    currStart = index;
   ++currLength;
  }
 }
 if (currLength > maxLength) {
  maxIndex = currStart;
  maxLength = currLength;
 }
 return maxIndex;
};
var serializeHost = function (host) {
 var result, index, compress, ignore0;
 if (typeof host == 'number') {
  result = [];
  for (index = 0; index < 4; index++) {
   unshift(result, host % 256);
   host = floor(host / 256);
  }
  return join(result, '.');
 } else if (typeof host == 'object') {
  result = '';
  compress = findLongestZeroSequence(host);
  for (index = 0; index < 8; index++) {
   if (ignore0 && host[index] === 0)
    continue;
   if (ignore0)
    ignore0 = false;
   if (compress === index) {
    result += index ? ':' : '::';
    ignore0 = true;
   } else {
    result += numberToString(host[index], 16);
    if (index < 7)
     result += ':';
   }
  }
  return '[' + result + ']';
 }
 return host;
};
var C0ControlPercentEncodeSet = {};
var fragmentPercentEncodeSet = assign({}, C0ControlPercentEncodeSet, {
 ' ': 1,
 '"': 1,
 '<': 1,
 '>': 1,
 '`': 1
});
var pathPercentEncodeSet = assign({}, fragmentPercentEncodeSet, {
 '#': 1,
 '?': 1,
 '{': 1,
 '}': 1
});
var userinfoPercentEncodeSet = assign({}, pathPercentEncodeSet, {
 '/': 1,
 ':': 1,
 ';': 1,
 '=': 1,
 '@': 1,
 '[': 1,
 '\\': 1,
 ']': 1,
 '^': 1,
 '|': 1
});
var percentEncode = function (chr, set) {
 var code = codeAt(chr, 0);
 return code > 0x20 && code < 0x7F && !hasOwn(set, chr) ? chr : encodeURIComponent(chr);
};
var specialSchemes = {
 ftp: 21,
 file: null,
 http: 80,
 https: 443,
 ws: 80,
 wss: 443
};
var isWindowsDriveLetter = function (string, normalized) {
 var second;
 return string.length == 2 && exec(ALPHA, charAt(string, 0)) && ((second = charAt(string, 1)) == ':' || !normalized && second == '|');
};
var startsWithWindowsDriveLetter = function (string) {
 var third;
 return string.length > 1 && isWindowsDriveLetter(stringSlice(string, 0, 2)) && (string.length == 2 || ((third = charAt(string, 2)) === '/' || third === '\\' || third === '?' || third === '#'));
};
var isSingleDot = function (segment) {
 return segment === '.' || toLowerCase(segment) === '%2e';
};
var isDoubleDot = function (segment) {
 segment = toLowerCase(segment);
 return segment === '..' || segment === '%2e.' || segment === '.%2e' || segment === '%2e%2e';
};
var SCHEME_START = {};
var SCHEME = {};
var NO_SCHEME = {};
var SPECIAL_RELATIVE_OR_AUTHORITY = {};
var PATH_OR_AUTHORITY = {};
var RELATIVE = {};
var RELATIVE_SLASH = {};
var SPECIAL_AUTHORITY_SLASHES = {};
var SPECIAL_AUTHORITY_IGNORE_SLASHES = {};
var AUTHORITY = {};
var HOST = {};
var HOSTNAME = {};
var PORT = {};
var FILE = {};
var FILE_SLASH = {};
var FILE_HOST = {};
var PATH_START = {};
var PATH = {};
var CANNOT_BE_A_BASE_URL_PATH = {};
var QUERY = {};
var FRAGMENT = {};
var URLState = function (url, isBase, base) {
 var urlString = $toString(url);
 var baseState, failure, searchParams;
 if (isBase) {
  failure = this.parse(urlString);
  if (failure)
   throw TypeError(failure);
  this.searchParams = null;
 } else {
  if (base !== undefined)
   baseState = new URLState(base, true);
  failure = this.parse(urlString, null, baseState);
  if (failure)
   throw TypeError(failure);
  searchParams = getInternalSearchParamsState(new URLSearchParams());
  searchParams.bindURL(this);
  this.searchParams = searchParams;
 }
};
URLState.prototype = {
 type: 'URL',
 parse: function (input, stateOverride, base) {
  var url = this;
  var state = stateOverride || SCHEME_START;
  var pointer = 0;
  var buffer = '';
  var seenAt = false;
  var seenBracket = false;
  var seenPasswordToken = false;
  var codePoints, chr, bufferCodePoints, failure;
  input = $toString(input);
  if (!stateOverride) {
   url.scheme = '';
   url.username = '';
   url.password = '';
   url.host = null;
   url.port = null;
   url.path = [];
   url.query = null;
   url.fragment = null;
   url.cannotBeABaseURL = false;
   input = replace(input, LEADING_C0_CONTROL_OR_SPACE, '');
   input = replace(input, TRAILING_C0_CONTROL_OR_SPACE, '$1');
  }
  input = replace(input, TAB_AND_NEW_LINE, '');
  codePoints = arrayFrom(input);
  while (pointer <= codePoints.length) {
   chr = codePoints[pointer];
   switch (state) {
   case SCHEME_START:
    if (chr && exec(ALPHA, chr)) {
     buffer += toLowerCase(chr);
     state = SCHEME;
    } else if (!stateOverride) {
     state = NO_SCHEME;
     continue;
    } else
     return INVALID_SCHEME;
    break;
   case SCHEME:
    if (chr && (exec(ALPHANUMERIC, chr) || chr == '+' || chr == '-' || chr == '.')) {
     buffer += toLowerCase(chr);
    } else if (chr == ':') {
     if (stateOverride && (url.isSpecial() != hasOwn(specialSchemes, buffer) || buffer == 'file' && (url.includesCredentials() || url.port !== null) || url.scheme == 'file' && !url.host))
      return;
     url.scheme = buffer;
     if (stateOverride) {
      if (url.isSpecial() && specialSchemes[url.scheme] == url.port)
       url.port = null;
      return;
     }
     buffer = '';
     if (url.scheme == 'file') {
      state = FILE;
     } else if (url.isSpecial() && base && base.scheme == url.scheme) {
      state = SPECIAL_RELATIVE_OR_AUTHORITY;
     } else if (url.isSpecial()) {
      state = SPECIAL_AUTHORITY_SLASHES;
     } else if (codePoints[pointer + 1] == '/') {
      state = PATH_OR_AUTHORITY;
      pointer++;
     } else {
      url.cannotBeABaseURL = true;
      push(url.path, '');
      state = CANNOT_BE_A_BASE_URL_PATH;
     }
    } else if (!stateOverride) {
     buffer = '';
     state = NO_SCHEME;
     pointer = 0;
     continue;
    } else
     return INVALID_SCHEME;
    break;
   case NO_SCHEME:
    if (!base || base.cannotBeABaseURL && chr != '#')
     return INVALID_SCHEME;
    if (base.cannotBeABaseURL && chr == '#') {
     url.scheme = base.scheme;
     url.path = arraySlice(base.path);
     url.query = base.query;
     url.fragment = '';
     url.cannotBeABaseURL = true;
     state = FRAGMENT;
     break;
    }
    state = base.scheme == 'file' ? FILE : RELATIVE;
    continue;
   case SPECIAL_RELATIVE_OR_AUTHORITY:
    if (chr == '/' && codePoints[pointer + 1] == '/') {
     state = SPECIAL_AUTHORITY_IGNORE_SLASHES;
     pointer++;
    } else {
     state = RELATIVE;
     continue;
    }
    break;
   case PATH_OR_AUTHORITY:
    if (chr == '/') {
     state = AUTHORITY;
     break;
    } else {
     state = PATH;
     continue;
    }
   case RELATIVE:
    url.scheme = base.scheme;
    if (chr == EOF) {
     url.username = base.username;
     url.password = base.password;
     url.host = base.host;
     url.port = base.port;
     url.path = arraySlice(base.path);
     url.query = base.query;
    } else if (chr == '/' || chr == '\\' && url.isSpecial()) {
     state = RELATIVE_SLASH;
    } else if (chr == '?') {
     url.username = base.username;
     url.password = base.password;
     url.host = base.host;
     url.port = base.port;
     url.path = arraySlice(base.path);
     url.query = '';
     state = QUERY;
    } else if (chr == '#') {
     url.username = base.username;
     url.password = base.password;
     url.host = base.host;
     url.port = base.port;
     url.path = arraySlice(base.path);
     url.query = base.query;
     url.fragment = '';
     state = FRAGMENT;
    } else {
     url.username = base.username;
     url.password = base.password;
     url.host = base.host;
     url.port = base.port;
     url.path = arraySlice(base.path);
     url.path.length--;
     state = PATH;
     continue;
    }
    break;
   case RELATIVE_SLASH:
    if (url.isSpecial() && (chr == '/' || chr == '\\')) {
     state = SPECIAL_AUTHORITY_IGNORE_SLASHES;
    } else if (chr == '/') {
     state = AUTHORITY;
    } else {
     url.username = base.username;
     url.password = base.password;
     url.host = base.host;
     url.port = base.port;
     state = PATH;
     continue;
    }
    break;
   case SPECIAL_AUTHORITY_SLASHES:
    state = SPECIAL_AUTHORITY_IGNORE_SLASHES;
    if (chr != '/' || charAt(buffer, pointer + 1) != '/')
     continue;
    pointer++;
    break;
   case SPECIAL_AUTHORITY_IGNORE_SLASHES:
    if (chr != '/' && chr != '\\') {
     state = AUTHORITY;
     continue;
    }
    break;
   case AUTHORITY:
    if (chr == '@') {
     if (seenAt)
      buffer = '%40' + buffer;
     seenAt = true;
     bufferCodePoints = arrayFrom(buffer);
     for (var i = 0; i < bufferCodePoints.length; i++) {
      var codePoint = bufferCodePoints[i];
      if (codePoint == ':' && !seenPasswordToken) {
       seenPasswordToken = true;
       continue;
      }
      var encodedCodePoints = percentEncode(codePoint, userinfoPercentEncodeSet);
      if (seenPasswordToken)
       url.password += encodedCodePoints;
      else
       url.username += encodedCodePoints;
     }
     buffer = '';
    } else if (chr == EOF || chr == '/' || chr == '?' || chr == '#' || chr == '\\' && url.isSpecial()) {
     if (seenAt && buffer == '')
      return INVALID_AUTHORITY;
     pointer -= arrayFrom(buffer).length + 1;
     buffer = '';
     state = HOST;
    } else
     buffer += chr;
    break;
   case HOST:
   case HOSTNAME:
    if (stateOverride && url.scheme == 'file') {
     state = FILE_HOST;
     continue;
    } else if (chr == ':' && !seenBracket) {
     if (buffer == '')
      return INVALID_HOST;
     failure = url.parseHost(buffer);
     if (failure)
      return failure;
     buffer = '';
     state = PORT;
     if (stateOverride == HOSTNAME)
      return;
    } else if (chr == EOF || chr == '/' || chr == '?' || chr == '#' || chr == '\\' && url.isSpecial()) {
     if (url.isSpecial() && buffer == '')
      return INVALID_HOST;
     if (stateOverride && buffer == '' && (url.includesCredentials() || url.port !== null))
      return;
     failure = url.parseHost(buffer);
     if (failure)
      return failure;
     buffer = '';
     state = PATH_START;
     if (stateOverride)
      return;
     continue;
    } else {
     if (chr == '[')
      seenBracket = true;
     else if (chr == ']')
      seenBracket = false;
     buffer += chr;
    }
    break;
   case PORT:
    if (exec(DIGIT, chr)) {
     buffer += chr;
    } else if (chr == EOF || chr == '/' || chr == '?' || chr == '#' || chr == '\\' && url.isSpecial() || stateOverride) {
     if (buffer != '') {
      var port = parseInt(buffer, 10);
      if (port > 0xFFFF)
       return INVALID_PORT;
      url.port = url.isSpecial() && port === specialSchemes[url.scheme] ? null : port;
      buffer = '';
     }
     if (stateOverride)
      return;
     state = PATH_START;
     continue;
    } else
     return INVALID_PORT;
    break;
   case FILE:
    url.scheme = 'file';
    if (chr == '/' || chr == '\\')
     state = FILE_SLASH;
    else if (base && base.scheme == 'file') {
     if (chr == EOF) {
      url.host = base.host;
      url.path = arraySlice(base.path);
      url.query = base.query;
     } else if (chr == '?') {
      url.host = base.host;
      url.path = arraySlice(base.path);
      url.query = '';
      state = QUERY;
     } else if (chr == '#') {
      url.host = base.host;
      url.path = arraySlice(base.path);
      url.query = base.query;
      url.fragment = '';
      state = FRAGMENT;
     } else {
      if (!startsWithWindowsDriveLetter(join(arraySlice(codePoints, pointer), ''))) {
       url.host = base.host;
       url.path = arraySlice(base.path);
       url.shortenPath();
      }
      state = PATH;
      continue;
     }
    } else {
     state = PATH;
     continue;
    }
    break;
   case FILE_SLASH:
    if (chr == '/' || chr == '\\') {
     state = FILE_HOST;
     break;
    }
    if (base && base.scheme == 'file' && !startsWithWindowsDriveLetter(join(arraySlice(codePoints, pointer), ''))) {
     if (isWindowsDriveLetter(base.path[0], true))
      push(url.path, base.path[0]);
     else
      url.host = base.host;
    }
    state = PATH;
    continue;
   case FILE_HOST:
    if (chr == EOF || chr == '/' || chr == '\\' || chr == '?' || chr == '#') {
     if (!stateOverride && isWindowsDriveLetter(buffer)) {
      state = PATH;
     } else if (buffer == '') {
      url.host = '';
      if (stateOverride)
       return;
      state = PATH_START;
     } else {
      failure = url.parseHost(buffer);
      if (failure)
       return failure;
      if (url.host == 'localhost')
       url.host = '';
      if (stateOverride)
       return;
      buffer = '';
      state = PATH_START;
     }
     continue;
    } else
     buffer += chr;
    break;
   case PATH_START:
    if (url.isSpecial()) {
     state = PATH;
     if (chr != '/' && chr != '\\')
      continue;
    } else if (!stateOverride && chr == '?') {
     url.query = '';
     state = QUERY;
    } else if (!stateOverride && chr == '#') {
     url.fragment = '';
     state = FRAGMENT;
    } else if (chr != EOF) {
     state = PATH;
     if (chr != '/')
      continue;
    }
    break;
   case PATH:
    if (chr == EOF || chr == '/' || chr == '\\' && url.isSpecial() || !stateOverride && (chr == '?' || chr == '#')) {
     if (isDoubleDot(buffer)) {
      url.shortenPath();
      if (chr != '/' && !(chr == '\\' && url.isSpecial())) {
       push(url.path, '');
      }
     } else if (isSingleDot(buffer)) {
      if (chr != '/' && !(chr == '\\' && url.isSpecial())) {
       push(url.path, '');
      }
     } else {
      if (url.scheme == 'file' && !url.path.length && isWindowsDriveLetter(buffer)) {
       if (url.host)
        url.host = '';
       buffer = charAt(buffer, 0) + ':';
      }
      push(url.path, buffer);
     }
     buffer = '';
     if (url.scheme == 'file' && (chr == EOF || chr == '?' || chr == '#')) {
      while (url.path.length > 1 && url.path[0] === '') {
       shift(url.path);
      }
     }
     if (chr == '?') {
      url.query = '';
      state = QUERY;
     } else if (chr == '#') {
      url.fragment = '';
      state = FRAGMENT;
     }
    } else {
     buffer += percentEncode(chr, pathPercentEncodeSet);
    }
    break;
   case CANNOT_BE_A_BASE_URL_PATH:
    if (chr == '?') {
     url.query = '';
     state = QUERY;
    } else if (chr == '#') {
     url.fragment = '';
     state = FRAGMENT;
    } else if (chr != EOF) {
     url.path[0] += percentEncode(chr, C0ControlPercentEncodeSet);
    }
    break;
   case QUERY:
    if (!stateOverride && chr == '#') {
     url.fragment = '';
     state = FRAGMENT;
    } else if (chr != EOF) {
     if (chr == "'" && url.isSpecial())
      url.query += '%27';
     else if (chr == '#')
      url.query += '%23';
     else
      url.query += percentEncode(chr, C0ControlPercentEncodeSet);
    }
    break;
   case FRAGMENT:
    if (chr != EOF)
     url.fragment += percentEncode(chr, fragmentPercentEncodeSet);
    break;
   }
   pointer++;
  }
 },
 parseHost: function (input) {
  var result, codePoints, index;
  if (charAt(input, 0) == '[') {
   if (charAt(input, input.length - 1) != ']')
    return INVALID_HOST;
   result = parseIPv6(stringSlice(input, 1, -1));
   if (!result)
    return INVALID_HOST;
   this.host = result;
  } else if (!this.isSpecial()) {
   if (exec(FORBIDDEN_HOST_CODE_POINT_EXCLUDING_PERCENT, input))
    return INVALID_HOST;
   result = '';
   codePoints = arrayFrom(input);
   for (index = 0; index < codePoints.length; index++) {
    result += percentEncode(codePoints[index], C0ControlPercentEncodeSet);
   }
   this.host = result;
  } else {
   input = toASCII(input);
   if (exec(FORBIDDEN_HOST_CODE_POINT, input))
    return INVALID_HOST;
   result = parseIPv4(input);
   if (result === null)
    return INVALID_HOST;
   this.host = result;
  }
 },
 cannotHaveUsernamePasswordPort: function () {
  return !this.host || this.cannotBeABaseURL || this.scheme == 'file';
 },
 includesCredentials: function () {
  return this.username != '' || this.password != '';
 },
 isSpecial: function () {
  return hasOwn(specialSchemes, this.scheme);
 },
 shortenPath: function () {
  var path = this.path;
  var pathSize = path.length;
  if (pathSize && (this.scheme != 'file' || pathSize != 1 || !isWindowsDriveLetter(path[0], true))) {
   path.length--;
  }
 },
 serialize: function () {
  var url = this;
  var scheme = url.scheme;
  var username = url.username;
  var password = url.password;
  var host = url.host;
  var port = url.port;
  var path = url.path;
  var query = url.query;
  var fragment = url.fragment;
  var output = scheme + ':';
  if (host !== null) {
   output += '//';
   if (url.includesCredentials()) {
    output += username + (password ? ':' + password : '') + '@';
   }
   output += serializeHost(host);
   if (port !== null)
    output += ':' + port;
  } else if (scheme == 'file')
   output += '//';
  output += url.cannotBeABaseURL ? path[0] : path.length ? '/' + join(path, '/') : '';
  if (query !== null)
   output += '?' + query;
  if (fragment !== null)
   output += '#' + fragment;
  return output;
 },
 setHref: function (href) {
  var failure = this.parse(href);
  if (failure)
   throw TypeError(failure);
  this.searchParams.update();
 },
 getOrigin: function () {
  var scheme = this.scheme;
  var port = this.port;
  if (scheme == 'blob')
   try {
    return new URLConstructor(scheme.path[0]).origin;
   } catch (error) {
    return 'null';
   }
  if (scheme == 'file' || !this.isSpecial())
   return 'null';
  return scheme + '://' + serializeHost(this.host) + (port !== null ? ':' + port : '');
 },
 getProtocol: function () {
  return this.scheme + ':';
 },
 setProtocol: function (protocol) {
  this.parse($toString(protocol) + ':', SCHEME_START);
 },
 getUsername: function () {
  return this.username;
 },
 setUsername: function (username) {
  var codePoints = arrayFrom($toString(username));
  if (this.cannotHaveUsernamePasswordPort())
   return;
  this.username = '';
  for (var i = 0; i < codePoints.length; i++) {
   this.username += percentEncode(codePoints[i], userinfoPercentEncodeSet);
  }
 },
 getPassword: function () {
  return this.password;
 },
 setPassword: function (password) {
  var codePoints = arrayFrom($toString(password));
  if (this.cannotHaveUsernamePasswordPort())
   return;
  this.password = '';
  for (var i = 0; i < codePoints.length; i++) {
   this.password += percentEncode(codePoints[i], userinfoPercentEncodeSet);
  }
 },
 getHost: function () {
  var host = this.host;
  var port = this.port;
  return host === null ? '' : port === null ? serializeHost(host) : serializeHost(host) + ':' + port;
 },
 setHost: function (host) {
  if (this.cannotBeABaseURL)
   return;
  this.parse(host, HOST);
 },
 getHostname: function () {
  var host = this.host;
  return host === null ? '' : serializeHost(host);
 },
 setHostname: function (hostname) {
  if (this.cannotBeABaseURL)
   return;
  this.parse(hostname, HOSTNAME);
 },
 getPort: function () {
  var port = this.port;
  return port === null ? '' : $toString(port);
 },
 setPort: function (port) {
  if (this.cannotHaveUsernamePasswordPort())
   return;
  port = $toString(port);
  if (port == '')
   this.port = null;
  else
   this.parse(port, PORT);
 },
 getPathname: function () {
  var path = this.path;
  return this.cannotBeABaseURL ? path[0] : path.length ? '/' + join(path, '/') : '';
 },
 setPathname: function (pathname) {
  if (this.cannotBeABaseURL)
   return;
  this.path = [];
  this.parse(pathname, PATH_START);
 },
 getSearch: function () {
  var query = this.query;
  return query ? '?' + query : '';
 },
 setSearch: function (search) {
  search = $toString(search);
  if (search == '') {
   this.query = null;
  } else {
   if ('?' == charAt(search, 0))
    search = stringSlice(search, 1);
   this.query = '';
   this.parse(search, QUERY);
  }
  this.searchParams.update();
 },
 getSearchParams: function () {
  return this.searchParams.facade;
 },
 getHash: function () {
  var fragment = this.fragment;
  return fragment ? '#' + fragment : '';
 },
 setHash: function (hash) {
  hash = $toString(hash);
  if (hash == '') {
   this.fragment = null;
   return;
  }
  if ('#' == charAt(hash, 0))
   hash = stringSlice(hash, 1);
  this.fragment = '';
  this.parse(hash, FRAGMENT);
 },
 update: function () {
  this.query = this.searchParams.serialize() || null;
 }
};
var URLConstructor = function URL(url) {
 var that = anInstance(this, URLPrototype);
 var base = validateArgumentsLength(arguments.length, 1) > 1 ? arguments[1] : undefined;
 var state = setInternalState(that, new URLState(url, false, base));
 if (!DESCRIPTORS) {
  that.href = state.serialize();
  that.origin = state.getOrigin();
  that.protocol = state.getProtocol();
  that.username = state.getUsername();
  that.password = state.getPassword();
  that.host = state.getHost();
  that.hostname = state.getHostname();
  that.port = state.getPort();
  that.pathname = state.getPathname();
  that.search = state.getSearch();
  that.searchParams = state.getSearchParams();
  that.hash = state.getHash();
 }
};
var URLPrototype = URLConstructor.prototype;
var accessorDescriptor = function (getter, setter) {
 return {
  get: function () {
   return getInternalURLState(this)[getter]();
  },
  set: setter && function (value) {
   return getInternalURLState(this)[setter](value);
  },
  configurable: true,
  enumerable: true
 };
};
if (DESCRIPTORS) {
 defineBuiltInAccessor(URLPrototype, 'href', accessorDescriptor('serialize', 'setHref'));
 defineBuiltInAccessor(URLPrototype, 'origin', accessorDescriptor('getOrigin'));
 defineBuiltInAccessor(URLPrototype, 'protocol', accessorDescriptor('getProtocol', 'setProtocol'));
 defineBuiltInAccessor(URLPrototype, 'username', accessorDescriptor('getUsername', 'setUsername'));
 defineBuiltInAccessor(URLPrototype, 'password', accessorDescriptor('getPassword', 'setPassword'));
 defineBuiltInAccessor(URLPrototype, 'host', accessorDescriptor('getHost', 'setHost'));
 defineBuiltInAccessor(URLPrototype, 'hostname', accessorDescriptor('getHostname', 'setHostname'));
 defineBuiltInAccessor(URLPrototype, 'port', accessorDescriptor('getPort', 'setPort'));
 defineBuiltInAccessor(URLPrototype, 'pathname', accessorDescriptor('getPathname', 'setPathname'));
 defineBuiltInAccessor(URLPrototype, 'search', accessorDescriptor('getSearch', 'setSearch'));
 defineBuiltInAccessor(URLPrototype, 'searchParams', accessorDescriptor('getSearchParams'));
 defineBuiltInAccessor(URLPrototype, 'hash', accessorDescriptor('getHash', 'setHash'));
}
defineBuiltIn(URLPrototype, 'toJSON', function toJSON() {
 return getInternalURLState(this).serialize();
}, { enumerable: true });
defineBuiltIn(URLPrototype, 'toString', function toString() {
 return getInternalURLState(this).serialize();
}, { enumerable: true });
if (NativeURL) {
 var nativeCreateObjectURL = NativeURL.createObjectURL;
 var nativeRevokeObjectURL = NativeURL.revokeObjectURL;
 if (nativeCreateObjectURL)
  defineBuiltIn(URLConstructor, 'createObjectURL', bind(nativeCreateObjectURL, NativeURL));
 if (nativeRevokeObjectURL)
  defineBuiltIn(URLConstructor, 'revokeObjectURL', bind(nativeRevokeObjectURL, NativeURL));
}
setToStringTag(URLConstructor, 'URL');
$({
 global: true,
 constructor: true,
 forced: !USE_NATIVE_URL,
 sham: !DESCRIPTORS
}, { URL: URLConstructor });

/***/ }),
/* 318 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var fails = __w_pdfjs_require__(9);
var wellKnownSymbol = __w_pdfjs_require__(14);
var DESCRIPTORS = __w_pdfjs_require__(25);
var IS_PURE = __w_pdfjs_require__(16);
var ITERATOR = wellKnownSymbol('iterator');
module.exports = !fails(function () {
 var url = new URL('b?a=1&b=2&c=3', 'http://a');
 var params = url.searchParams;
 var params2 = new URLSearchParams('a=1&a=2&b=3');
 var result = '';
 url.pathname = 'c%20d';
 params.forEach(function (value, key) {
  params['delete']('b');
  result += key + value;
 });
 params2['delete']('a', 2);
 params2['delete']('b', undefined);
 return IS_PURE && (!url.toJSON || !params2.has('a', 1) || params2.has('a', 2) || !params2.has('a', undefined) || params2.has('b')) || !params.size && (IS_PURE || !DESCRIPTORS) || !params.sort || url.href !== 'http://a/c%20d?a=1&c=3' || params.get('c') !== '3' || String(new URLSearchParams('?a=1')) !== 'a=1' || !params[ITERATOR] || new URL('https://a@b').username !== 'a' || new URLSearchParams(new URLSearchParams('a=b')).get('a') !== 'b' || new URL('http://тест').host !== 'xn--e1aybc' || new URL('http://a#б').hash !== '#%D0%B1' || result !== 'a1c3' || new URL('http://x', undefined).host !== 'x';
});

/***/ }),
/* 319 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var DESCRIPTORS = __w_pdfjs_require__(25);
var uncurryThis = __w_pdfjs_require__(7);
var call = __w_pdfjs_require__(35);
var fails = __w_pdfjs_require__(9);
var objectKeys = __w_pdfjs_require__(82);
var getOwnPropertySymbolsModule = __w_pdfjs_require__(75);
var propertyIsEnumerableModule = __w_pdfjs_require__(60);
var toObject = __w_pdfjs_require__(10);
var IndexedObject = __w_pdfjs_require__(62);
var $assign = Object.assign;
var defineProperty = Object.defineProperty;
var concat = uncurryThis([].concat);
module.exports = !$assign || fails(function () {
 if (DESCRIPTORS && $assign({ b: 1 }, $assign(defineProperty({}, 'a', {
   enumerable: true,
   get: function () {
    defineProperty(this, 'b', {
     value: 3,
     enumerable: false
    });
   }
  }), { b: 2 })).b !== 1)
  return true;
 var A = {};
 var B = {};
 var symbol = Symbol();
 var alphabet = 'abcdefghijklmnopqrst';
 A[symbol] = 7;
 alphabet.split('').forEach(function (chr) {
  B[chr] = chr;
 });
 return $assign({}, A)[symbol] != 7 || objectKeys($assign({}, B)).join('') != alphabet;
}) ? function assign(target, source) {
 var T = toObject(target);
 var argumentsLength = arguments.length;
 var index = 1;
 var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
 var propertyIsEnumerable = propertyIsEnumerableModule.f;
 while (argumentsLength > index) {
  var S = IndexedObject(arguments[index++]);
  var keys = getOwnPropertySymbols ? concat(objectKeys(S), getOwnPropertySymbols(S)) : objectKeys(S);
  var length = keys.length;
  var j = 0;
  var key;
  while (length > j) {
   key = keys[j++];
   if (!DESCRIPTORS || call(propertyIsEnumerable, S, key))
    T[key] = S[key];
  }
 }
 return T;
} : $assign;

/***/ }),
/* 320 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var maxInt = 2147483647;
var base = 36;
var tMin = 1;
var tMax = 26;
var skew = 38;
var damp = 700;
var initialBias = 72;
var initialN = 128;
var delimiter = '-';
var regexNonASCII = /[^\0-\u007E]/;
var regexSeparators = /[.\u3002\uFF0E\uFF61]/g;
var OVERFLOW_ERROR = 'Overflow: input needs wider integers to process';
var baseMinusTMin = base - tMin;
var $RangeError = RangeError;
var exec = uncurryThis(regexSeparators.exec);
var floor = Math.floor;
var fromCharCode = String.fromCharCode;
var charCodeAt = uncurryThis(''.charCodeAt);
var join = uncurryThis([].join);
var push = uncurryThis([].push);
var replace = uncurryThis(''.replace);
var split = uncurryThis(''.split);
var toLowerCase = uncurryThis(''.toLowerCase);
var ucs2decode = function (string) {
 var output = [];
 var counter = 0;
 var length = string.length;
 while (counter < length) {
  var value = charCodeAt(string, counter++);
  if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
   var extra = charCodeAt(string, counter++);
   if ((extra & 0xFC00) == 0xDC00) {
    push(output, ((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
   } else {
    push(output, value);
    counter--;
   }
  } else {
   push(output, value);
  }
 }
 return output;
};
var digitToBasic = function (digit) {
 return digit + 22 + 75 * (digit < 26);
};
var adapt = function (delta, numPoints, firstTime) {
 var k = 0;
 delta = firstTime ? floor(delta / damp) : delta >> 1;
 delta += floor(delta / numPoints);
 while (delta > baseMinusTMin * tMax >> 1) {
  delta = floor(delta / baseMinusTMin);
  k += base;
 }
 return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
};
var encode = function (input) {
 var output = [];
 input = ucs2decode(input);
 var inputLength = input.length;
 var n = initialN;
 var delta = 0;
 var bias = initialBias;
 var i, currentValue;
 for (i = 0; i < input.length; i++) {
  currentValue = input[i];
  if (currentValue < 0x80) {
   push(output, fromCharCode(currentValue));
  }
 }
 var basicLength = output.length;
 var handledCPCount = basicLength;
 if (basicLength) {
  push(output, delimiter);
 }
 while (handledCPCount < inputLength) {
  var m = maxInt;
  for (i = 0; i < input.length; i++) {
   currentValue = input[i];
   if (currentValue >= n && currentValue < m) {
    m = currentValue;
   }
  }
  var handledCPCountPlusOne = handledCPCount + 1;
  if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
   throw $RangeError(OVERFLOW_ERROR);
  }
  delta += (m - n) * handledCPCountPlusOne;
  n = m;
  for (i = 0; i < input.length; i++) {
   currentValue = input[i];
   if (currentValue < n && ++delta > maxInt) {
    throw $RangeError(OVERFLOW_ERROR);
   }
   if (currentValue == n) {
    var q = delta;
    var k = base;
    while (true) {
     var t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
     if (q < t)
      break;
     var qMinusT = q - t;
     var baseMinusT = base - t;
     push(output, fromCharCode(digitToBasic(t + qMinusT % baseMinusT)));
     q = floor(qMinusT / baseMinusT);
     k += base;
    }
    push(output, fromCharCode(digitToBasic(q)));
    bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
    delta = 0;
    handledCPCount++;
   }
  }
  delta++;
  n++;
 }
 return join(output, '');
};
module.exports = function (input) {
 var encoded = [];
 var labels = split(replace(toLowerCase(input), regexSeparators, '\u002E'), '.');
 var i, label;
 for (i = 0; i < labels.length; i++) {
  label = labels[i];
  push(encoded, exec(regexNonASCII, label) ? 'xn--' + encode(label) : label);
 }
 return join(encoded, '.');
};

/***/ }),
/* 321 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


__w_pdfjs_require__(137);
var $ = __w_pdfjs_require__(58);
var global = __w_pdfjs_require__(5);
var call = __w_pdfjs_require__(35);
var uncurryThis = __w_pdfjs_require__(7);
var DESCRIPTORS = __w_pdfjs_require__(25);
var USE_NATIVE_URL = __w_pdfjs_require__(318);
var defineBuiltIn = __w_pdfjs_require__(44);
var defineBuiltInAccessor = __w_pdfjs_require__(87);
var defineBuiltIns = __w_pdfjs_require__(197);
var setToStringTag = __w_pdfjs_require__(88);
var createIteratorConstructor = __w_pdfjs_require__(140);
var InternalStateModule = __w_pdfjs_require__(48);
var anInstance = __w_pdfjs_require__(149);
var isCallable = __w_pdfjs_require__(29);
var hasOwn = __w_pdfjs_require__(6);
var bind = __w_pdfjs_require__(90);
var classof = __w_pdfjs_require__(78);
var anObject = __w_pdfjs_require__(32);
var isObject = __w_pdfjs_require__(28);
var $toString = __w_pdfjs_require__(77);
var create = __w_pdfjs_require__(80);
var createPropertyDescriptor = __w_pdfjs_require__(51);
var getIterator = __w_pdfjs_require__(120);
var getIteratorMethod = __w_pdfjs_require__(121);
var validateArgumentsLength = __w_pdfjs_require__(153);
var wellKnownSymbol = __w_pdfjs_require__(14);
var arraySort = __w_pdfjs_require__(240);
var ITERATOR = wellKnownSymbol('iterator');
var URL_SEARCH_PARAMS = 'URLSearchParams';
var URL_SEARCH_PARAMS_ITERATOR = URL_SEARCH_PARAMS + 'Iterator';
var setInternalState = InternalStateModule.set;
var getInternalParamsState = InternalStateModule.getterFor(URL_SEARCH_PARAMS);
var getInternalIteratorState = InternalStateModule.getterFor(URL_SEARCH_PARAMS_ITERATOR);
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
var safeGetBuiltIn = function (name) {
 if (!DESCRIPTORS)
  return global[name];
 var descriptor = getOwnPropertyDescriptor(global, name);
 return descriptor && descriptor.value;
};
var nativeFetch = safeGetBuiltIn('fetch');
var NativeRequest = safeGetBuiltIn('Request');
var Headers = safeGetBuiltIn('Headers');
var RequestPrototype = NativeRequest && NativeRequest.prototype;
var HeadersPrototype = Headers && Headers.prototype;
var RegExp = global.RegExp;
var TypeError = global.TypeError;
var decodeURIComponent = global.decodeURIComponent;
var encodeURIComponent = global.encodeURIComponent;
var charAt = uncurryThis(''.charAt);
var join = uncurryThis([].join);
var push = uncurryThis([].push);
var replace = uncurryThis(''.replace);
var shift = uncurryThis([].shift);
var splice = uncurryThis([].splice);
var split = uncurryThis(''.split);
var stringSlice = uncurryThis(''.slice);
var plus = /\+/g;
var sequences = Array(4);
var percentSequence = function (bytes) {
 return sequences[bytes - 1] || (sequences[bytes - 1] = RegExp('((?:%[\\da-f]{2}){' + bytes + '})', 'gi'));
};
var percentDecode = function (sequence) {
 try {
  return decodeURIComponent(sequence);
 } catch (error) {
  return sequence;
 }
};
var deserialize = function (it) {
 var result = replace(it, plus, ' ');
 var bytes = 4;
 try {
  return decodeURIComponent(result);
 } catch (error) {
  while (bytes) {
   result = replace(result, percentSequence(bytes--), percentDecode);
  }
  return result;
 }
};
var find = /[!'()~]|%20/g;
var replacements = {
 '!': '%21',
 "'": '%27',
 '(': '%28',
 ')': '%29',
 '~': '%7E',
 '%20': '+'
};
var replacer = function (match) {
 return replacements[match];
};
var serialize = function (it) {
 return replace(encodeURIComponent(it), find, replacer);
};
var URLSearchParamsIterator = createIteratorConstructor(function Iterator(params, kind) {
 setInternalState(this, {
  type: URL_SEARCH_PARAMS_ITERATOR,
  iterator: getIterator(getInternalParamsState(params).entries),
  kind: kind
 });
}, 'Iterator', function next() {
 var state = getInternalIteratorState(this);
 var kind = state.kind;
 var step = state.iterator.next();
 var entry = step.value;
 if (!step.done) {
  step.value = kind === 'keys' ? entry.key : kind === 'values' ? entry.value : [
   entry.key,
   entry.value
  ];
 }
 return step;
}, true);
var URLSearchParamsState = function (init) {
 this.entries = [];
 this.url = null;
 if (init !== undefined) {
  if (isObject(init))
   this.parseObject(init);
  else
   this.parseQuery(typeof init == 'string' ? charAt(init, 0) === '?' ? stringSlice(init, 1) : init : $toString(init));
 }
};
URLSearchParamsState.prototype = {
 type: URL_SEARCH_PARAMS,
 bindURL: function (url) {
  this.url = url;
  this.update();
 },
 parseObject: function (object) {
  var iteratorMethod = getIteratorMethod(object);
  var iterator, next, step, entryIterator, entryNext, first, second;
  if (iteratorMethod) {
   iterator = getIterator(object, iteratorMethod);
   next = iterator.next;
   while (!(step = call(next, iterator)).done) {
    entryIterator = getIterator(anObject(step.value));
    entryNext = entryIterator.next;
    if ((first = call(entryNext, entryIterator)).done || (second = call(entryNext, entryIterator)).done || !call(entryNext, entryIterator).done)
     throw TypeError('Expected sequence with length 2');
    push(this.entries, {
     key: $toString(first.value),
     value: $toString(second.value)
    });
   }
  } else
   for (var key in object)
    if (hasOwn(object, key)) {
     push(this.entries, {
      key: key,
      value: $toString(object[key])
     });
    }
 },
 parseQuery: function (query) {
  if (query) {
   var attributes = split(query, '&');
   var index = 0;
   var attribute, entry;
   while (index < attributes.length) {
    attribute = attributes[index++];
    if (attribute.length) {
     entry = split(attribute, '=');
     push(this.entries, {
      key: deserialize(shift(entry)),
      value: deserialize(join(entry, '='))
     });
    }
   }
  }
 },
 serialize: function () {
  var entries = this.entries;
  var result = [];
  var index = 0;
  var entry;
  while (index < entries.length) {
   entry = entries[index++];
   push(result, serialize(entry.key) + '=' + serialize(entry.value));
  }
  return join(result, '&');
 },
 update: function () {
  this.entries.length = 0;
  this.parseQuery(this.url.query);
 },
 updateURL: function () {
  if (this.url)
   this.url.update();
 }
};
var URLSearchParamsConstructor = function URLSearchParams() {
 anInstance(this, URLSearchParamsPrototype);
 var init = arguments.length > 0 ? arguments[0] : undefined;
 var state = setInternalState(this, new URLSearchParamsState(init));
 if (!DESCRIPTORS)
  this.size = state.entries.length;
};
var URLSearchParamsPrototype = URLSearchParamsConstructor.prototype;
defineBuiltIns(URLSearchParamsPrototype, {
 append: function append(name, value) {
  var state = getInternalParamsState(this);
  validateArgumentsLength(arguments.length, 2);
  push(state.entries, {
   key: $toString(name),
   value: $toString(value)
  });
  if (!DESCRIPTORS)
   this.length++;
  state.updateURL();
 },
 'delete': function (name) {
  var state = getInternalParamsState(this);
  var length = validateArgumentsLength(arguments.length, 1);
  var entries = state.entries;
  var key = $toString(name);
  var $value = length < 2 ? undefined : arguments[1];
  var value = $value === undefined ? $value : $toString($value);
  var index = 0;
  while (index < entries.length) {
   var entry = entries[index];
   if (entry.key === key && (value === undefined || entry.value === value)) {
    splice(entries, index, 1);
    if (value !== undefined)
     break;
   } else
    index++;
  }
  if (!DESCRIPTORS)
   this.size = entries.length;
  state.updateURL();
 },
 get: function get(name) {
  var entries = getInternalParamsState(this).entries;
  validateArgumentsLength(arguments.length, 1);
  var key = $toString(name);
  var index = 0;
  for (; index < entries.length; index++) {
   if (entries[index].key === key)
    return entries[index].value;
  }
  return null;
 },
 getAll: function getAll(name) {
  var entries = getInternalParamsState(this).entries;
  validateArgumentsLength(arguments.length, 1);
  var key = $toString(name);
  var result = [];
  var index = 0;
  for (; index < entries.length; index++) {
   if (entries[index].key === key)
    push(result, entries[index].value);
  }
  return result;
 },
 has: function has(name) {
  var entries = getInternalParamsState(this).entries;
  var length = validateArgumentsLength(arguments.length, 1);
  var key = $toString(name);
  var $value = length < 2 ? undefined : arguments[1];
  var value = $value === undefined ? $value : $toString($value);
  var index = 0;
  while (index < entries.length) {
   var entry = entries[index++];
   if (entry.key === key && (value === undefined || entry.value === value))
    return true;
  }
  return false;
 },
 set: function set(name, value) {
  var state = getInternalParamsState(this);
  validateArgumentsLength(arguments.length, 1);
  var entries = state.entries;
  var found = false;
  var key = $toString(name);
  var val = $toString(value);
  var index = 0;
  var entry;
  for (; index < entries.length; index++) {
   entry = entries[index];
   if (entry.key === key) {
    if (found)
     splice(entries, index--, 1);
    else {
     found = true;
     entry.value = val;
    }
   }
  }
  if (!found)
   push(entries, {
    key: key,
    value: val
   });
  if (!DESCRIPTORS)
   this.size = entries.length;
  state.updateURL();
 },
 sort: function sort() {
  var state = getInternalParamsState(this);
  arraySort(state.entries, function (a, b) {
   return a.key > b.key ? 1 : -1;
  });
  state.updateURL();
 },
 forEach: function forEach(callback) {
  var entries = getInternalParamsState(this).entries;
  var boundFunction = bind(callback, arguments.length > 1 ? arguments[1] : undefined);
  var index = 0;
  var entry;
  while (index < entries.length) {
   entry = entries[index++];
   boundFunction(entry.value, entry.key, this);
  }
 },
 keys: function keys() {
  return new URLSearchParamsIterator(this, 'keys');
 },
 values: function values() {
  return new URLSearchParamsIterator(this, 'values');
 },
 entries: function entries() {
  return new URLSearchParamsIterator(this, 'entries');
 }
}, { enumerable: true });
defineBuiltIn(URLSearchParamsPrototype, ITERATOR, URLSearchParamsPrototype.entries, { name: 'entries' });
defineBuiltIn(URLSearchParamsPrototype, 'toString', function toString() {
 return getInternalParamsState(this).serialize();
}, { enumerable: true });
if (DESCRIPTORS)
 defineBuiltInAccessor(URLSearchParamsPrototype, 'size', {
  get: function size() {
   return getInternalParamsState(this).entries.length;
  },
  configurable: true,
  enumerable: true
 });
setToStringTag(URLSearchParamsConstructor, URL_SEARCH_PARAMS);
$({
 global: true,
 constructor: true,
 forced: !USE_NATIVE_URL
}, { URLSearchParams: URLSearchParamsConstructor });
if (!USE_NATIVE_URL && isCallable(Headers)) {
 var headersHas = uncurryThis(HeadersPrototype.has);
 var headersSet = uncurryThis(HeadersPrototype.set);
 var wrapRequestOptions = function (init) {
  if (isObject(init)) {
   var body = init.body;
   var headers;
   if (classof(body) === URL_SEARCH_PARAMS) {
    headers = init.headers ? new Headers(init.headers) : new Headers();
    if (!headersHas(headers, 'content-type')) {
     headersSet(headers, 'content-type', 'application/x-www-form-urlencoded;charset=UTF-8');
    }
    return create(init, {
     body: createPropertyDescriptor(0, $toString(body)),
     headers: createPropertyDescriptor(0, headers)
    });
   }
  }
  return init;
 };
 if (isCallable(nativeFetch)) {
  $({
   global: true,
   enumerable: true,
   dontCallGetSet: true,
   forced: true
  }, {
   fetch: function fetch(input) {
    return nativeFetch(input, arguments.length > 1 ? wrapRequestOptions(arguments[1]) : {});
   }
  });
 }
 if (isCallable(NativeRequest)) {
  var RequestConstructor = function Request(input) {
   anInstance(this, RequestPrototype);
   return new NativeRequest(input, arguments.length > 1 ? wrapRequestOptions(arguments[1]) : {});
  };
  RequestPrototype.constructor = RequestConstructor;
  RequestConstructor.prototype = RequestPrototype;
  $({
   global: true,
   constructor: true,
   dontCallGetSet: true,
   forced: true
  }, { Request: RequestConstructor });
 }
}
module.exports = {
 URLSearchParams: URLSearchParamsConstructor,
 getState: getInternalParamsState
};

/***/ }),
/* 322 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


__w_pdfjs_require__(321);

/***/ }),
/* 323 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var defineBuiltIn = __w_pdfjs_require__(44);
var uncurryThis = __w_pdfjs_require__(7);
var toString = __w_pdfjs_require__(77);
var validateArgumentsLength = __w_pdfjs_require__(153);
var $URLSearchParams = URLSearchParams;
var URLSearchParamsPrototype = $URLSearchParams.prototype;
var append = uncurryThis(URLSearchParamsPrototype.append);
var $delete = uncurryThis(URLSearchParamsPrototype['delete']);
var forEach = uncurryThis(URLSearchParamsPrototype.forEach);
var push = uncurryThis([].push);
var params = new $URLSearchParams('a=1&a=2&b=3');
params['delete']('a', 1);
params['delete']('b', undefined);
if (params + '' !== 'a=2') {
 defineBuiltIn(URLSearchParamsPrototype, 'delete', function (name) {
  var length = arguments.length;
  var $value = length < 2 ? undefined : arguments[1];
  if (length && $value === undefined)
   return $delete(this, name);
  var entries = [];
  forEach(this, function (v, k) {
   push(entries, {
    key: k,
    value: v
   });
  });
  validateArgumentsLength(length, 1);
  var key = toString(name);
  var value = toString($value);
  var index = 0;
  var dindex = 0;
  var found = false;
  var entriesLength = entries.length;
  var entry;
  while (index < entriesLength) {
   entry = entries[index++];
   if (found || entry.key === key) {
    found = true;
    $delete(this, entry.key);
   } else
    dindex++;
  }
  while (dindex < entriesLength) {
   entry = entries[dindex++];
   if (!(entry.key === key && entry.value === value))
    append(this, entry.key, entry.value);
  }
 }, {
  enumerable: true,
  unsafe: true
 });
}

/***/ }),
/* 324 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var defineBuiltIn = __w_pdfjs_require__(44);
var uncurryThis = __w_pdfjs_require__(7);
var toString = __w_pdfjs_require__(77);
var validateArgumentsLength = __w_pdfjs_require__(153);
var $URLSearchParams = URLSearchParams;
var URLSearchParamsPrototype = $URLSearchParams.prototype;
var getAll = uncurryThis(URLSearchParamsPrototype.getAll);
var $has = uncurryThis(URLSearchParamsPrototype.has);
var params = new $URLSearchParams('a=1');
if (params.has('a', 2) || !params.has('a', undefined)) {
 defineBuiltIn(URLSearchParamsPrototype, 'has', function has(name) {
  var length = arguments.length;
  var $value = length < 2 ? undefined : arguments[1];
  if (length && $value === undefined)
   return $has(this, name);
  var values = getAll(this, name);
  validateArgumentsLength(length, 1);
  var value = toString($value);
  var index = 0;
  while (index < values.length) {
   if (values[index++] === value)
    return true;
  }
  return false;
 }, {
  enumerable: true,
  unsafe: true
 });
}

/***/ }),
/* 325 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var DESCRIPTORS = __w_pdfjs_require__(25);
var uncurryThis = __w_pdfjs_require__(7);
var defineBuiltInAccessor = __w_pdfjs_require__(87);
var URLSearchParamsPrototype = URLSearchParams.prototype;
var forEach = uncurryThis(URLSearchParamsPrototype.forEach);
if (DESCRIPTORS && !('size' in URLSearchParamsPrototype)) {
 defineBuiltInAccessor(URLSearchParamsPrototype, 'size', {
  get: function size() {
   var count = 0;
   forEach(this, function () {
    count++;
   });
   return count;
  },
  configurable: true,
  enumerable: true
 });
}

/***/ }),
/* 326 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var toObject = __w_pdfjs_require__(10);
var nativeKeys = __w_pdfjs_require__(82);
var fails = __w_pdfjs_require__(9);
var FAILS_ON_PRIMITIVES = fails(function () {
 nativeKeys(1);
});
$({
 target: 'Object',
 stat: true,
 forced: FAILS_ON_PRIMITIVES
}, {
 keys: function keys(it) {
  return nativeKeys(toObject(it));
 }
});

/***/ }),
/* 327 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var createTypedArrayConstructor = __w_pdfjs_require__(192);
createTypedArrayConstructor('Uint32', function (init) {
 return function Uint32Array(data, byteOffset, length) {
  return init(this, data, byteOffset, length);
 };
});

/***/ }),
/* 328 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var $includes = (__w_pdfjs_require__(68).includes);
var fails = __w_pdfjs_require__(9);
var addToUnscopables = __w_pdfjs_require__(138);
var BROKEN_ON_SPARSE = fails(function () {
 return !Array(1).includes();
});
$({
 target: 'Array',
 proto: true,
 forced: BROKEN_ON_SPARSE
}, {
 includes: function includes(el) {
  return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
 }
});
addToUnscopables('includes');

/***/ }),
/* 329 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var uncurryThis = __w_pdfjs_require__(7);
var notARegExp = __w_pdfjs_require__(309);
var requireObjectCoercible = __w_pdfjs_require__(11);
var toString = __w_pdfjs_require__(77);
var correctIsRegExpLogic = __w_pdfjs_require__(311);
var stringIndexOf = uncurryThis(''.indexOf);
$({
 target: 'String',
 proto: true,
 forced: !correctIsRegExpLogic('includes')
}, {
 includes: function includes(searchString) {
  return !!~stringIndexOf(toString(requireObjectCoercible(this)), toString(notARegExp(searchString)), arguments.length > 1 ? arguments[1] : undefined);
 }
});

/***/ }),
/* 330 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var $padStart = (__w_pdfjs_require__(331).start);
var WEBKIT_BUG = __w_pdfjs_require__(333);
$({
 target: 'String',
 proto: true,
 forced: WEBKIT_BUG
}, {
 padStart: function padStart(maxLength) {
  return $padStart(this, maxLength, arguments.length > 1 ? arguments[1] : undefined);
 }
});

/***/ }),
/* 331 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var toLength = __w_pdfjs_require__(73);
var toString = __w_pdfjs_require__(77);
var $repeat = __w_pdfjs_require__(332);
var requireObjectCoercible = __w_pdfjs_require__(11);
var repeat = uncurryThis($repeat);
var stringSlice = uncurryThis(''.slice);
var ceil = Math.ceil;
var createMethod = function (IS_END) {
 return function ($this, maxLength, fillString) {
  var S = toString(requireObjectCoercible($this));
  var intMaxLength = toLength(maxLength);
  var stringLength = S.length;
  var fillStr = fillString === undefined ? ' ' : toString(fillString);
  var fillLen, stringFiller;
  if (intMaxLength <= stringLength || fillStr == '')
   return S;
  fillLen = intMaxLength - stringLength;
  stringFiller = repeat(fillStr, ceil(fillLen / fillStr.length));
  if (stringFiller.length > fillLen)
   stringFiller = stringSlice(stringFiller, 0, fillLen);
  return IS_END ? S + stringFiller : stringFiller + S;
 };
};
module.exports = {
 start: createMethod(false),
 end: createMethod(true)
};

/***/ }),
/* 332 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var toIntegerOrInfinity = __w_pdfjs_require__(70);
var toString = __w_pdfjs_require__(77);
var requireObjectCoercible = __w_pdfjs_require__(11);
var $RangeError = RangeError;
module.exports = function repeat(count) {
 var str = toString(requireObjectCoercible(this));
 var result = '';
 var n = toIntegerOrInfinity(count);
 if (n < 0 || n == Infinity)
  throw $RangeError('Wrong number of repetitions');
 for (; n > 0; (n >>>= 1) && (str += str))
  if (n & 1)
   result += str;
 return result;
};

/***/ }),
/* 333 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var userAgent = __w_pdfjs_require__(22);
module.exports = /Version\/10(?:\.\d+){1,2}(?: [\w./]+)?(?: Mobile\/\w+)? Safari\//.test(userAgent);

/***/ }),
/* 334 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


__w_pdfjs_require__(335);

/***/ }),
/* 335 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var collection = __w_pdfjs_require__(260);
var collectionStrong = __w_pdfjs_require__(265);
collection('Map', function (init) {
 return function Map() {
  return init(this, arguments.length ? arguments[0] : undefined);
 };
}, collectionStrong);

/***/ }),
/* 336 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var apply = __w_pdfjs_require__(100);
var call = __w_pdfjs_require__(35);
var uncurryThis = __w_pdfjs_require__(7);
var fixRegExpWellKnownSymbolLogic = __w_pdfjs_require__(313);
var fails = __w_pdfjs_require__(9);
var anObject = __w_pdfjs_require__(32);
var isCallable = __w_pdfjs_require__(29);
var isNullOrUndefined = __w_pdfjs_require__(12);
var toIntegerOrInfinity = __w_pdfjs_require__(70);
var toLength = __w_pdfjs_require__(73);
var toString = __w_pdfjs_require__(77);
var requireObjectCoercible = __w_pdfjs_require__(11);
var advanceStringIndex = __w_pdfjs_require__(314);
var getMethod = __w_pdfjs_require__(39);
var getSubstitution = __w_pdfjs_require__(337);
var regExpExec = __w_pdfjs_require__(315);
var wellKnownSymbol = __w_pdfjs_require__(14);
var REPLACE = wellKnownSymbol('replace');
var max = Math.max;
var min = Math.min;
var concat = uncurryThis([].concat);
var push = uncurryThis([].push);
var stringIndexOf = uncurryThis(''.indexOf);
var stringSlice = uncurryThis(''.slice);
var maybeToString = function (it) {
 return it === undefined ? it : String(it);
};
var REPLACE_KEEPS_$0 = (function () {
 return 'a'.replace(/./, '$0') === '$0';
}());
var REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE = (function () {
 if (/./[REPLACE]) {
  return /./[REPLACE]('a', '$0') === '';
 }
 return false;
}());
var REPLACE_SUPPORTS_NAMED_GROUPS = !fails(function () {
 var re = /./;
 re.exec = function () {
  var result = [];
  result.groups = { a: '7' };
  return result;
 };
 return ''.replace(re, '$<a>') !== '7';
});
fixRegExpWellKnownSymbolLogic('replace', function (_, nativeReplace, maybeCallNative) {
 var UNSAFE_SUBSTITUTE = REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE ? '$' : '$0';
 return [
  function replace(searchValue, replaceValue) {
   var O = requireObjectCoercible(this);
   var replacer = isNullOrUndefined(searchValue) ? undefined : getMethod(searchValue, REPLACE);
   return replacer ? call(replacer, searchValue, O, replaceValue) : call(nativeReplace, toString(O), searchValue, replaceValue);
  },
  function (string, replaceValue) {
   var rx = anObject(this);
   var S = toString(string);
   if (typeof replaceValue == 'string' && stringIndexOf(replaceValue, UNSAFE_SUBSTITUTE) === -1 && stringIndexOf(replaceValue, '$<') === -1) {
    var res = maybeCallNative(nativeReplace, rx, S, replaceValue);
    if (res.done)
     return res.value;
   }
   var functionalReplace = isCallable(replaceValue);
   if (!functionalReplace)
    replaceValue = toString(replaceValue);
   var global = rx.global;
   if (global) {
    var fullUnicode = rx.unicode;
    rx.lastIndex = 0;
   }
   var results = [];
   while (true) {
    var result = regExpExec(rx, S);
    if (result === null)
     break;
    push(results, result);
    if (!global)
     break;
    var matchStr = toString(result[0]);
    if (matchStr === '')
     rx.lastIndex = advanceStringIndex(S, toLength(rx.lastIndex), fullUnicode);
   }
   var accumulatedResult = '';
   var nextSourcePosition = 0;
   for (var i = 0; i < results.length; i++) {
    result = results[i];
    var matched = toString(result[0]);
    var position = max(min(toIntegerOrInfinity(result.index), S.length), 0);
    var captures = [];
    for (var j = 1; j < result.length; j++)
     push(captures, maybeToString(result[j]));
    var namedCaptures = result.groups;
    if (functionalReplace) {
     var replacerArgs = concat([matched], captures, position, S);
     if (namedCaptures !== undefined)
      push(replacerArgs, namedCaptures);
     var replacement = toString(apply(replaceValue, undefined, replacerArgs));
    } else {
     replacement = getSubstitution(matched, S, position, captures, namedCaptures, replaceValue);
    }
    if (position >= nextSourcePosition) {
     accumulatedResult += stringSlice(S, nextSourcePosition, position) + replacement;
     nextSourcePosition = position + matched.length;
    }
   }
   return accumulatedResult + stringSlice(S, nextSourcePosition);
  }
 ];
}, !REPLACE_SUPPORTS_NAMED_GROUPS || !REPLACE_KEEPS_$0 || REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE);

/***/ }),
/* 337 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var toObject = __w_pdfjs_require__(10);
var floor = Math.floor;
var charAt = uncurryThis(''.charAt);
var replace = uncurryThis(''.replace);
var stringSlice = uncurryThis(''.slice);
var SUBSTITUTION_SYMBOLS = /\$([$&'`]|\d{1,2}|<[^>]*>)/g;
var SUBSTITUTION_SYMBOLS_NO_NAMED = /\$([$&'`]|\d{1,2})/g;
module.exports = function (matched, str, position, captures, namedCaptures, replacement) {
 var tailPos = position + matched.length;
 var m = captures.length;
 var symbols = SUBSTITUTION_SYMBOLS_NO_NAMED;
 if (namedCaptures !== undefined) {
  namedCaptures = toObject(namedCaptures);
  symbols = SUBSTITUTION_SYMBOLS;
 }
 return replace(replacement, symbols, function (match, ch) {
  var capture;
  switch (charAt(ch, 0)) {
  case '$':
   return '$';
  case '&':
   return matched;
  case '`':
   return stringSlice(str, 0, position);
  case "'":
   return stringSlice(str, tailPos);
  case '<':
   capture = namedCaptures[stringSlice(ch, 1, -1)];
   break;
  default:
   var n = +ch;
   if (n === 0)
    return match;
   if (n > m) {
    var f = floor(n / 10);
    if (f === 0)
     return match;
    if (f <= m)
     return captures[f - 1] === undefined ? charAt(ch, 1) : captures[f - 1] + charAt(ch, 1);
    return match;
   }
   capture = captures[n - 1];
  }
  return capture === undefined ? '' : capture;
 });
};

/***/ }),
/* 338 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var call = __w_pdfjs_require__(35);
var uncurryThis = __w_pdfjs_require__(7);
var requireObjectCoercible = __w_pdfjs_require__(11);
var isCallable = __w_pdfjs_require__(29);
var isNullOrUndefined = __w_pdfjs_require__(12);
var isRegExp = __w_pdfjs_require__(310);
var toString = __w_pdfjs_require__(77);
var getMethod = __w_pdfjs_require__(39);
var getRegExpFlags = __w_pdfjs_require__(293);
var getSubstitution = __w_pdfjs_require__(337);
var wellKnownSymbol = __w_pdfjs_require__(14);
var IS_PURE = __w_pdfjs_require__(16);
var REPLACE = wellKnownSymbol('replace');
var $TypeError = TypeError;
var indexOf = uncurryThis(''.indexOf);
var replace = uncurryThis(''.replace);
var stringSlice = uncurryThis(''.slice);
var max = Math.max;
var stringIndexOf = function (string, searchValue, fromIndex) {
 if (fromIndex > string.length)
  return -1;
 if (searchValue === '')
  return fromIndex;
 return indexOf(string, searchValue, fromIndex);
};
$({
 target: 'String',
 proto: true
}, {
 replaceAll: function replaceAll(searchValue, replaceValue) {
  var O = requireObjectCoercible(this);
  var IS_REG_EXP, flags, replacer, string, searchString, functionalReplace, searchLength, advanceBy, replacement;
  var position = 0;
  var endOfLastMatch = 0;
  var result = '';
  if (!isNullOrUndefined(searchValue)) {
   IS_REG_EXP = isRegExp(searchValue);
   if (IS_REG_EXP) {
    flags = toString(requireObjectCoercible(getRegExpFlags(searchValue)));
    if (!~indexOf(flags, 'g'))
     throw $TypeError('`.replaceAll` does not allow non-global regexes');
   }
   replacer = getMethod(searchValue, REPLACE);
   if (replacer) {
    return call(replacer, searchValue, O, replaceValue);
   } else if (IS_PURE && IS_REG_EXP) {
    return replace(toString(O), searchValue, replaceValue);
   }
  }
  string = toString(O);
  searchString = toString(searchValue);
  functionalReplace = isCallable(replaceValue);
  if (!functionalReplace)
   replaceValue = toString(replaceValue);
  searchLength = searchString.length;
  advanceBy = max(1, searchLength);
  position = stringIndexOf(string, searchString, 0);
  while (position !== -1) {
   replacement = functionalReplace ? toString(replaceValue(searchString, position, string)) : getSubstitution(searchString, string, position, [], undefined, replaceValue);
   result += stringSlice(string, endOfLastMatch, position) + replacement;
   endOfLastMatch = position + searchLength;
   position = stringIndexOf(string, searchString, position + advanceBy);
  }
  if (endOfLastMatch < string.length) {
   result += stringSlice(string, endOfLastMatch);
  }
  return result;
 }
});

/***/ }),
/* 339 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


__w_pdfjs_require__(340);

/***/ }),
/* 340 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var FREEZING = __w_pdfjs_require__(264);
var global = __w_pdfjs_require__(5);
var uncurryThis = __w_pdfjs_require__(7);
var defineBuiltIns = __w_pdfjs_require__(197);
var InternalMetadataModule = __w_pdfjs_require__(261);
var collection = __w_pdfjs_require__(260);
var collectionWeak = __w_pdfjs_require__(341);
var isObject = __w_pdfjs_require__(28);
var enforceInternalState = (__w_pdfjs_require__(48).enforce);
var fails = __w_pdfjs_require__(9);
var NATIVE_WEAK_MAP = __w_pdfjs_require__(49);
var $Object = Object;
var isArray = Array.isArray;
var isExtensible = $Object.isExtensible;
var isFrozen = $Object.isFrozen;
var isSealed = $Object.isSealed;
var freeze = $Object.freeze;
var seal = $Object.seal;
var FROZEN = {};
var SEALED = {};
var IS_IE11 = !global.ActiveXObject && 'ActiveXObject' in global;
var InternalWeakMap;
var wrapper = function (init) {
 return function WeakMap() {
  return init(this, arguments.length ? arguments[0] : undefined);
 };
};
var $WeakMap = collection('WeakMap', wrapper, collectionWeak);
var WeakMapPrototype = $WeakMap.prototype;
var nativeSet = uncurryThis(WeakMapPrototype.set);
var hasMSEdgeFreezingBug = function () {
 return FREEZING && fails(function () {
  var frozenArray = freeze([]);
  nativeSet(new $WeakMap(), frozenArray, 1);
  return !isFrozen(frozenArray);
 });
};
if (NATIVE_WEAK_MAP)
 if (IS_IE11) {
  InternalWeakMap = collectionWeak.getConstructor(wrapper, 'WeakMap', true);
  InternalMetadataModule.enable();
  var nativeDelete = uncurryThis(WeakMapPrototype['delete']);
  var nativeHas = uncurryThis(WeakMapPrototype.has);
  var nativeGet = uncurryThis(WeakMapPrototype.get);
  defineBuiltIns(WeakMapPrototype, {
   'delete': function (key) {
    if (isObject(key) && !isExtensible(key)) {
     var state = enforceInternalState(this);
     if (!state.frozen)
      state.frozen = new InternalWeakMap();
     return nativeDelete(this, key) || state.frozen['delete'](key);
    }
    return nativeDelete(this, key);
   },
   has: function has(key) {
    if (isObject(key) && !isExtensible(key)) {
     var state = enforceInternalState(this);
     if (!state.frozen)
      state.frozen = new InternalWeakMap();
     return nativeHas(this, key) || state.frozen.has(key);
    }
    return nativeHas(this, key);
   },
   get: function get(key) {
    if (isObject(key) && !isExtensible(key)) {
     var state = enforceInternalState(this);
     if (!state.frozen)
      state.frozen = new InternalWeakMap();
     return nativeHas(this, key) ? nativeGet(this, key) : state.frozen.get(key);
    }
    return nativeGet(this, key);
   },
   set: function set(key, value) {
    if (isObject(key) && !isExtensible(key)) {
     var state = enforceInternalState(this);
     if (!state.frozen)
      state.frozen = new InternalWeakMap();
     nativeHas(this, key) ? nativeSet(this, key, value) : state.frozen.set(key, value);
    } else
     nativeSet(this, key, value);
    return this;
   }
  });
 } else if (hasMSEdgeFreezingBug()) {
  defineBuiltIns(WeakMapPrototype, {
   set: function set(key, value) {
    var arrayIntegrityLevel;
    if (isArray(key)) {
     if (isFrozen(key))
      arrayIntegrityLevel = FROZEN;
     else if (isSealed(key))
      arrayIntegrityLevel = SEALED;
    }
    nativeSet(this, key, value);
    if (arrayIntegrityLevel == FROZEN)
     freeze(key);
    if (arrayIntegrityLevel == SEALED)
     seal(key);
    return this;
   }
  });
 }

/***/ }),
/* 341 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var uncurryThis = __w_pdfjs_require__(7);
var defineBuiltIns = __w_pdfjs_require__(197);
var getWeakData = (__w_pdfjs_require__(261).getWeakData);
var anInstance = __w_pdfjs_require__(149);
var anObject = __w_pdfjs_require__(32);
var isNullOrUndefined = __w_pdfjs_require__(12);
var isObject = __w_pdfjs_require__(28);
var iterate = __w_pdfjs_require__(167);
var ArrayIterationModule = __w_pdfjs_require__(89);
var hasOwn = __w_pdfjs_require__(6);
var InternalStateModule = __w_pdfjs_require__(48);
var setInternalState = InternalStateModule.set;
var internalStateGetterFor = InternalStateModule.getterFor;
var find = ArrayIterationModule.find;
var findIndex = ArrayIterationModule.findIndex;
var splice = uncurryThis([].splice);
var id = 0;
var uncaughtFrozenStore = function (state) {
 return state.frozen || (state.frozen = new UncaughtFrozenStore());
};
var UncaughtFrozenStore = function () {
 this.entries = [];
};
var findUncaughtFrozen = function (store, key) {
 return find(store.entries, function (it) {
  return it[0] === key;
 });
};
UncaughtFrozenStore.prototype = {
 get: function (key) {
  var entry = findUncaughtFrozen(this, key);
  if (entry)
   return entry[1];
 },
 has: function (key) {
  return !!findUncaughtFrozen(this, key);
 },
 set: function (key, value) {
  var entry = findUncaughtFrozen(this, key);
  if (entry)
   entry[1] = value;
  else
   this.entries.push([
    key,
    value
   ]);
 },
 'delete': function (key) {
  var index = findIndex(this.entries, function (it) {
   return it[0] === key;
  });
  if (~index)
   splice(this.entries, index, 1);
  return !!~index;
 }
};
module.exports = {
 getConstructor: function (wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
  var Constructor = wrapper(function (that, iterable) {
   anInstance(that, Prototype);
   setInternalState(that, {
    type: CONSTRUCTOR_NAME,
    id: id++,
    frozen: undefined
   });
   if (!isNullOrUndefined(iterable))
    iterate(iterable, that[ADDER], {
     that: that,
     AS_ENTRIES: IS_MAP
    });
  });
  var Prototype = Constructor.prototype;
  var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);
  var define = function (that, key, value) {
   var state = getInternalState(that);
   var data = getWeakData(anObject(key), true);
   if (data === true)
    uncaughtFrozenStore(state).set(key, value);
   else
    data[state.id] = value;
   return that;
  };
  defineBuiltIns(Prototype, {
   'delete': function (key) {
    var state = getInternalState(this);
    if (!isObject(key))
     return false;
    var data = getWeakData(key);
    if (data === true)
     return uncaughtFrozenStore(state)['delete'](key);
    return data && hasOwn(data, state.id) && delete data[state.id];
   },
   has: function has(key) {
    var state = getInternalState(this);
    if (!isObject(key))
     return false;
    var data = getWeakData(key);
    if (data === true)
     return uncaughtFrozenStore(state).has(key);
    return data && hasOwn(data, state.id);
   }
  });
  defineBuiltIns(Prototype, IS_MAP ? {
   get: function get(key) {
    var state = getInternalState(this);
    if (isObject(key)) {
     var data = getWeakData(key);
     if (data === true)
      return uncaughtFrozenStore(state).get(key);
     return data ? data[state.id] : undefined;
    }
   },
   set: function set(key, value) {
    return define(this, key, value);
   }
  } : {
   add: function add(value) {
    return define(this, value, true);
   }
  });
  return Constructor;
 }
};

/***/ }),
/* 342 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

function _typeof(obj){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj;}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;},_typeof(obj);}__w_pdfjs_require__(304);__w_pdfjs_require__(305);__w_pdfjs_require__(2);__w_pdfjs_require__(54);__w_pdfjs_require__(56);__w_pdfjs_require__(104);__w_pdfjs_require__(114);__w_pdfjs_require__(113);Object.defineProperty(exports, "__esModule", ({value:true}));exports.XRefParseException=exports.XRefEntryException=exports.ParserEOFException=exports.PDF_VERSION_REGEXP=exports.MissingDataException=void 0;exports.arrayBuffersToBytes=arrayBuffersToBytes;exports.collectActions=collectActions;exports.encodeToXmlString=encodeToXmlString;exports.escapePDFName=escapePDFName;exports.escapeString=escapeString;exports.getInheritableProperty=getInheritableProperty;exports.getLookupTableFactory=getLookupTableFactory;exports.getNewAnnotationsMap=getNewAnnotationsMap;exports.getRotationMatrix=getRotationMatrix;exports.isAscii=isAscii;exports.isWhiteSpace=isWhiteSpace;exports.log2=log2;exports.numberToString=numberToString;exports.parseXFAPath=parseXFAPath;exports.readInt8=readInt8;exports.readUint16=readUint16;exports.readUint32=readUint32;exports.recoverJsURL=recoverJsURL;exports.stringToUTF16HexString=stringToUTF16HexString;exports.stringToUTF16String=stringToUTF16String;exports.toRomanNumerals=toRomanNumerals;exports.validateCSSFont=validateCSSFont;exports.validateFontName=validateFontName;__w_pdfjs_require__(301);__w_pdfjs_require__(134);__w_pdfjs_require__(137);__w_pdfjs_require__(143);__w_pdfjs_require__(191);__w_pdfjs_require__(208);__w_pdfjs_require__(209);__w_pdfjs_require__(212);__w_pdfjs_require__(213);__w_pdfjs_require__(214);__w_pdfjs_require__(218);__w_pdfjs_require__(219);__w_pdfjs_require__(220);__w_pdfjs_require__(222);__w_pdfjs_require__(223);__w_pdfjs_require__(224);__w_pdfjs_require__(225);__w_pdfjs_require__(226);__w_pdfjs_require__(227);__w_pdfjs_require__(228);__w_pdfjs_require__(231);__w_pdfjs_require__(232);__w_pdfjs_require__(234);__w_pdfjs_require__(235);__w_pdfjs_require__(236);__w_pdfjs_require__(237);__w_pdfjs_require__(238);__w_pdfjs_require__(239);__w_pdfjs_require__(244);__w_pdfjs_require__(245);__w_pdfjs_require__(247);__w_pdfjs_require__(248);__w_pdfjs_require__(249);__w_pdfjs_require__(251);__w_pdfjs_require__(254);__w_pdfjs_require__(257);__w_pdfjs_require__(289);__w_pdfjs_require__(105);__w_pdfjs_require__(343);__w_pdfjs_require__(180);__w_pdfjs_require__(123);__w_pdfjs_require__(312);__w_pdfjs_require__(292);__w_pdfjs_require__(336);__w_pdfjs_require__(338);__w_pdfjs_require__(344);__w_pdfjs_require__(345);__w_pdfjs_require__(346);__w_pdfjs_require__(347);__w_pdfjs_require__(129);__w_pdfjs_require__(295);__w_pdfjs_require__(348);__w_pdfjs_require__(258);__w_pdfjs_require__(175);__w_pdfjs_require__(266);__w_pdfjs_require__(277);__w_pdfjs_require__(279);__w_pdfjs_require__(281);__w_pdfjs_require__(283);__w_pdfjs_require__(285);__w_pdfjs_require__(287);__w_pdfjs_require__(177);__w_pdfjs_require__(334);__w_pdfjs_require__(308);__w_pdfjs_require__(330);__w_pdfjs_require__(183);var _util=__w_pdfjs_require__(303);var _primitives=__w_pdfjs_require__(349);var _base_stream=__w_pdfjs_require__(353);function _slicedToArray(arr,i){return _arrayWithHoles(arr)||_iterableToArrayLimit(arr,i)||_unsupportedIterableToArray(arr,i)||_nonIterableRest();}function _nonIterableRest(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}function _iterableToArrayLimit(arr,i){var _i=null==arr?null:"undefined"!=typeof Symbol&&arr[Symbol.iterator]||arr["@@iterator"];if(null!=_i){var _s,_e,_x,_r,_arr=[],_n=!0,_d=!1;try{if(_x=(_i=_i.call(arr)).next,0===i){if(Object(_i)!==_i)return;_n=!1;}else for(;!(_n=(_s=_x.call(_i)).done)&&(_arr.push(_s.value),_arr.length!==i);_n=!0);}catch(err){_d=!0,_e=err;}finally{try{if(!_n&&null!=_i.return&&(_r=_i.return(),Object(_r)!==_r))return;}finally{if(_d)throw _e;}}return _arr;}}function _arrayWithHoles(arr){if(Array.isArray(arr))return arr;}function _createForOfIteratorHelper(o,allowArrayLike){var it=typeof Symbol!=="undefined"&&o[Symbol.iterator]||o["@@iterator"];if(!it){if(Array.isArray(o)||(it=_unsupportedIterableToArray(o))||allowArrayLike&&o&&typeof o.length==="number"){if(it)o=it;var i=0;var F=function F(){};return{s:F,n:function n(){if(i>=o.length)return{done:true};return{done:false,value:o[i++]};},e:function e(_e2){throw _e2;},f:F};}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}var normalCompletion=true,didErr=false,err;return{s:function s(){it=it.call(o);},n:function n(){var step=it.next();normalCompletion=step.done;return step;},e:function e(_e3){didErr=true;err=_e3;},f:function f(){try{if(!normalCompletion&&it.return!=null)it.return();}finally{if(didErr)throw err;}}};}function _unsupportedIterableToArray(o,minLen){if(!o)return;if(typeof o==="string")return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);if(n==="Object"&&o.constructor)n=o.constructor.name;if(n==="Map"||n==="Set")return Array.from(o);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return _arrayLikeToArray(o,minLen);}function _arrayLikeToArray(arr,len){if(len==null||len>arr.length)len=arr.length;for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2;}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}}function _createClass(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);Object.defineProperty(Constructor,"prototype",{writable:false});return Constructor;}function _toPropertyKey(arg){var key=_toPrimitive(arg,"string");return _typeof(key)==="symbol"?key:String(key);}function _toPrimitive(input,hint){if(_typeof(input)!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(_typeof(res)!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.");}return(hint==="string"?String:Number)(input);}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function");}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:true,configurable:true}});Object.defineProperty(subClass,"prototype",{writable:false});if(superClass)_setPrototypeOf(subClass,superClass);}function _setPrototypeOf(o,p){_setPrototypeOf=Object.setPrototypeOf?Object.setPrototypeOf.bind():function _setPrototypeOf(o,p){o.__proto__=p;return o;};return _setPrototypeOf(o,p);}function _createSuper(Derived){var hasNativeReflectConstruct=_isNativeReflectConstruct();return function _createSuperInternal(){var Super=_getPrototypeOf(Derived),result;if(hasNativeReflectConstruct){var NewTarget=_getPrototypeOf(this).constructor;result=Reflect.construct(Super,arguments,NewTarget);}else{result=Super.apply(this,arguments);}return _possibleConstructorReturn(this,result);};}function _possibleConstructorReturn(self,call){if(call&&(_typeof(call)==="object"||typeof call==="function")){return call;}else if(call!==void 0){throw new TypeError("Derived constructors may only return object or undefined");}return _assertThisInitialized(self);}function _assertThisInitialized(self){if(self===void 0){throw new ReferenceError("this hasn't been initialised - super() hasn't been called");}return self;}function _isNativeReflectConstruct(){if(typeof Reflect==="undefined"||!Reflect.construct)return false;if(Reflect.construct.sham)return false;if(typeof Proxy==="function")return true;try{Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}));return true;}catch(e){return false;}}function _getPrototypeOf(o){_getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf.bind():function _getPrototypeOf(o){return o.__proto__||Object.getPrototypeOf(o);};return _getPrototypeOf(o);}var PDF_VERSION_REGEXP=/^[1-9]\.\d$/;exports.PDF_VERSION_REGEXP=PDF_VERSION_REGEXP;function getLookupTableFactory(initializer){var lookup;return function(){if(initializer){lookup=Object.create(null);initializer(lookup);initializer=null;}return lookup;};}var MissingDataException=/*#__PURE__*/function(_BaseException){_inherits(MissingDataException,_BaseException);var _super=_createSuper(MissingDataException);function MissingDataException(begin,end){var _this;_classCallCheck(this,MissingDataException);_this=_super.call(this,"Missing data [".concat(begin,", ").concat(end,")"),"MissingDataException");_this.begin=begin;_this.end=end;return _this;}return _createClass(MissingDataException);}(_util.BaseException);exports.MissingDataException=MissingDataException;var ParserEOFException=/*#__PURE__*/function(_BaseException2){_inherits(ParserEOFException,_BaseException2);var _super2=_createSuper(ParserEOFException);function ParserEOFException(msg){_classCallCheck(this,ParserEOFException);return _super2.call(this,msg,"ParserEOFException");}return _createClass(ParserEOFException);}(_util.BaseException);exports.ParserEOFException=ParserEOFException;var XRefEntryException=/*#__PURE__*/function(_BaseException3){_inherits(XRefEntryException,_BaseException3);var _super3=_createSuper(XRefEntryException);function XRefEntryException(msg){_classCallCheck(this,XRefEntryException);return _super3.call(this,msg,"XRefEntryException");}return _createClass(XRefEntryException);}(_util.BaseException);exports.XRefEntryException=XRefEntryException;var XRefParseException=/*#__PURE__*/function(_BaseException4){_inherits(XRefParseException,_BaseException4);var _super4=_createSuper(XRefParseException);function XRefParseException(msg){_classCallCheck(this,XRefParseException);return _super4.call(this,msg,"XRefParseException");}return _createClass(XRefParseException);}(_util.BaseException);exports.XRefParseException=XRefParseException;function arrayBuffersToBytes(arr){var length=arr.length;if(length===0){return new Uint8Array(0);}if(length===1){return new Uint8Array(arr[0]);}var dataLength=0;for(var i=0;i<length;i++){dataLength+=arr[i].byteLength;}var data=new Uint8Array(dataLength);var pos=0;for(var _i=0;_i<length;_i++){var item=new Uint8Array(arr[_i]);data.set(item,pos);pos+=item.byteLength;}return data;}function getInheritableProperty(_ref){var dict=_ref.dict,key=_ref.key,_ref$getArray=_ref.getArray,getArray=_ref$getArray===void 0?false:_ref$getArray,_ref$stopWhenFound=_ref.stopWhenFound,stopWhenFound=_ref$stopWhenFound===void 0?true:_ref$stopWhenFound;var values;var visited=new _primitives.RefSet();while(dict instanceof _primitives.Dict&&!(dict.objId&&visited.has(dict.objId))){if(dict.objId){visited.put(dict.objId);}var value=getArray?dict.getArray(key):dict.get(key);if(value!==undefined){if(stopWhenFound){return value;}(values||(values=[])).push(value);}dict=dict.get("Parent");}return values;}var ROMAN_NUMBER_MAP=["","C","CC","CCC","CD","D","DC","DCC","DCCC","CM","","X","XX","XXX","XL","L","LX","LXX","LXXX","XC","","I","II","III","IV","V","VI","VII","VIII","IX"];function toRomanNumerals(number){var lowerCase=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;(0,_util.assert)(Number.isInteger(number)&&number>0,"The number should be a positive integer.");var romanBuf=[];var pos;while(number>=1000){number-=1000;romanBuf.push("M");}pos=number/100|0;number%=100;romanBuf.push(ROMAN_NUMBER_MAP[pos]);pos=number/10|0;number%=10;romanBuf.push(ROMAN_NUMBER_MAP[10+pos]);romanBuf.push(ROMAN_NUMBER_MAP[20+number]);var romanStr=romanBuf.join("");return lowerCase?romanStr.toLowerCase():romanStr;}function log2(x){if(x<=0){return 0;}return Math.ceil(Math.log2(x));}function readInt8(data,offset){return data[offset]<<24>>24;}function readUint16(data,offset){return data[offset]<<8|data[offset+1];}function readUint32(data,offset){return(data[offset]<<24|data[offset+1]<<16|data[offset+2]<<8|data[offset+3])>>>0;}function isWhiteSpace(ch){return ch===0x20||ch===0x09||ch===0x0d||ch===0x0a;}function parseXFAPath(path){var positionPattern=/(.+)\[(\d+)\]$/;return path.split(".").map(function(component){var m=component.match(positionPattern);if(m){return{name:m[1],pos:parseInt(m[2],10)};}return{name:component,pos:0};});}function escapePDFName(str){var buffer=[];var start=0;for(var i=0,ii=str.length;i<ii;i++){var char=str.charCodeAt(i);if(char<0x21||char>0x7e||char===0x23||char===0x28||char===0x29||char===0x3c||char===0x3e||char===0x5b||char===0x5d||char===0x7b||char===0x7d||char===0x2f||char===0x25){if(start<i){buffer.push(str.substring(start,i));}buffer.push("#".concat(char.toString(16)));start=i+1;}}if(buffer.length===0){return str;}if(start<str.length){buffer.push(str.substring(start,str.length));}return buffer.join("");}function escapeString(str){return str.replaceAll(/([()\\\n\r])/g,function(match){if(match==="\n"){return"\\n";}else if(match==="\r"){return"\\r";}return"\\".concat(match);});}function _collectJS(entry,xref,list,parents){if(!entry){return;}var parent=null;if(entry instanceof _primitives.Ref){if(parents.has(entry)){return;}parent=entry;parents.put(parent);entry=xref.fetch(entry);}if(Array.isArray(entry)){var _iterator=_createForOfIteratorHelper(entry),_step;try{for(_iterator.s();!(_step=_iterator.n()).done;){var element=_step.value;_collectJS(element,xref,list,parents);}}catch(err){_iterator.e(err);}finally{_iterator.f();}}else if(entry instanceof _primitives.Dict){if((0,_primitives.isName)(entry.get("S"),"JavaScript")){var js=entry.get("JS");var code;if(js instanceof _base_stream.BaseStream){code=js.getString();}else if(typeof js==="string"){code=js;}code&&(code=(0,_util.stringToPDFString)(code).replaceAll("\x00",""));if(code){list.push(code);}}_collectJS(entry.getRaw("Next"),xref,list,parents);}if(parent){parents.remove(parent);}}function collectActions(xref,dict,eventType){var actions=Object.create(null);var additionalActionsDicts=getInheritableProperty({dict:dict,key:"AA",stopWhenFound:false});if(additionalActionsDicts){for(var i=additionalActionsDicts.length-1;i>=0;i--){var additionalActions=additionalActionsDicts[i];if(!(additionalActions instanceof _primitives.Dict)){continue;}var _iterator2=_createForOfIteratorHelper(additionalActions.getKeys()),_step2;try{for(_iterator2.s();!(_step2=_iterator2.n()).done;){var key=_step2.value;var action=eventType[key];if(!action){continue;}var actionDict=additionalActions.getRaw(key);var parents=new _primitives.RefSet();var list=[];_collectJS(actionDict,xref,list,parents);if(list.length>0){actions[action]=list;}}}catch(err){_iterator2.e(err);}finally{_iterator2.f();}}}if(dict.has("A")){var _actionDict=dict.get("A");var _parents=new _primitives.RefSet();var _list=[];_collectJS(_actionDict,xref,_list,_parents);if(_list.length>0){actions.Action=_list;}}return(0,_util.objectSize)(actions)>0?actions:null;}var XMLEntities={0x3c:"&lt;",0x3e:"&gt;",0x26:"&amp;",0x22:"&quot;",0x27:"&apos;"};function encodeToXmlString(str){var buffer=[];var start=0;for(var i=0,ii=str.length;i<ii;i++){var char=str.codePointAt(i);if(0x20<=char&&char<=0x7e){var entity=XMLEntities[char];if(entity){if(start<i){buffer.push(str.substring(start,i));}buffer.push(entity);start=i+1;}}else{if(start<i){buffer.push(str.substring(start,i));}buffer.push("&#x".concat(char.toString(16).toUpperCase(),";"));if(char>0xd7ff&&(char<0xe000||char>0xfffd)){i++;}start=i+1;}}if(buffer.length===0){return str;}if(start<str.length){buffer.push(str.substring(start,str.length));}return buffer.join("");}function validateFontName(fontFamily){var mustWarn=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;var m=/^("|').*("|')$/.exec(fontFamily);if(m&&m[1]===m[2]){var re=new RegExp("[^\\\\]".concat(m[1]));if(re.test(fontFamily.slice(1,-1))){if(mustWarn){(0,_util.warn)("FontFamily contains unescaped ".concat(m[1],": ").concat(fontFamily,"."));}return false;}}else{var _iterator3=_createForOfIteratorHelper(fontFamily.split(/[ \t]+/)),_step3;try{for(_iterator3.s();!(_step3=_iterator3.n()).done;){var ident=_step3.value;if(/^(\d|(-(\d|-)))/.test(ident)||!/^[\w-\\]+$/.test(ident)){if(mustWarn){(0,_util.warn)("FontFamily contains invalid <custom-ident>: ".concat(fontFamily,"."));}return false;}}}catch(err){_iterator3.e(err);}finally{_iterator3.f();}}return true;}function validateCSSFont(cssFontInfo){var DEFAULT_CSS_FONT_OBLIQUE="14";var DEFAULT_CSS_FONT_WEIGHT="400";var CSS_FONT_WEIGHT_VALUES=new Set(["100","200","300","400","500","600","700","800","900","1000","normal","bold","bolder","lighter"]);var fontFamily=cssFontInfo.fontFamily,fontWeight=cssFontInfo.fontWeight,italicAngle=cssFontInfo.italicAngle;if(!validateFontName(fontFamily,true)){return false;}var weight=fontWeight?fontWeight.toString():"";cssFontInfo.fontWeight=CSS_FONT_WEIGHT_VALUES.has(weight)?weight:DEFAULT_CSS_FONT_WEIGHT;var angle=parseFloat(italicAngle);cssFontInfo.italicAngle=isNaN(angle)||angle<-90||angle>90?DEFAULT_CSS_FONT_OBLIQUE:italicAngle.toString();return true;}function recoverJsURL(str){var URL_OPEN_METHODS=["app.launchURL","window.open","xfa.host.gotoURL"];var regex=new RegExp("^\\s*("+URL_OPEN_METHODS.join("|").replaceAll(".","\\.")+")\\((?:'|\")([^'\"]*)(?:'|\")(?:,\\s*(\\w+)\\)|\\))","i");var jsUrl=regex.exec(str);if(jsUrl!==null&&jsUrl!==void 0&&jsUrl[2]){var url=jsUrl[2];var newWindow=false;if(jsUrl[3]==="true"&&jsUrl[1]==="app.launchURL"){newWindow=true;}return{url:url,newWindow:newWindow};}return null;}function numberToString(value){if(Number.isInteger(value)){return value.toString();}var roundedValue=Math.round(value*100);if(roundedValue%100===0){return(roundedValue/100).toString();}if(roundedValue%10===0){return value.toFixed(1);}return value.toFixed(2);}function getNewAnnotationsMap(annotationStorage){if(!annotationStorage){return null;}var newAnnotationsByPage=new Map();var _iterator4=_createForOfIteratorHelper(annotationStorage),_step4;try{for(_iterator4.s();!(_step4=_iterator4.n()).done;){var _step4$value=_slicedToArray(_step4.value,2),key=_step4$value[0],value=_step4$value[1];if(!key.startsWith(_util.AnnotationEditorPrefix)){continue;}var annotations=newAnnotationsByPage.get(value.pageIndex);if(!annotations){annotations=[];newAnnotationsByPage.set(value.pageIndex,annotations);}annotations.push(value);}}catch(err){_iterator4.e(err);}finally{_iterator4.f();}return newAnnotationsByPage.size>0?newAnnotationsByPage:null;}function isAscii(str){return /^[\x00-\x7F]*$/.test(str);}function stringToUTF16HexString(str){var buf=[];for(var i=0,ii=str.length;i<ii;i++){var char=str.charCodeAt(i);buf.push((char>>8&0xff).toString(16).padStart(2,"0"),(char&0xff).toString(16).padStart(2,"0"));}return buf.join("");}function stringToUTF16String(str){var bigEndian=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;var buf=[];if(bigEndian){buf.push("\xFE\xFF");}for(var i=0,ii=str.length;i<ii;i++){var char=str.charCodeAt(i);buf.push(String.fromCharCode(char>>8&0xff),String.fromCharCode(char&0xff));}return buf.join("");}function getRotationMatrix(rotation,width,height){switch(rotation){case 90:return[0,1,-1,0,width,0];case 180:return[-1,0,0,-1,width,height];case 270:return[0,-1,1,0,0,height];default:throw new Error("Invalid rotation");}}

/***/ }),
/* 343 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var log = Math.log;
var LN2 = Math.LN2;
$({
 target: 'Math',
 stat: true
}, {
 log2: function log2(x) {
  return log(x) / LN2;
 }
});

/***/ }),
/* 344 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var codeAt = (__w_pdfjs_require__(176).codeAt);
$({
 target: 'String',
 proto: true
}, {
 codePointAt: function codePointAt(pos) {
  return codeAt(this, pos);
 }
});

/***/ }),
/* 345 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var DESCRIPTORS = __w_pdfjs_require__(25);
var global = __w_pdfjs_require__(5);
var uncurryThis = __w_pdfjs_require__(7);
var isForced = __w_pdfjs_require__(76);
var inheritIfRequired = __w_pdfjs_require__(106);
var createNonEnumerableProperty = __w_pdfjs_require__(50);
var getOwnPropertyNames = (__w_pdfjs_require__(66).f);
var isPrototypeOf = __w_pdfjs_require__(38);
var isRegExp = __w_pdfjs_require__(310);
var toString = __w_pdfjs_require__(77);
var getRegExpFlags = __w_pdfjs_require__(293);
var stickyHelpers = __w_pdfjs_require__(126);
var proxyAccessor = __w_pdfjs_require__(185);
var defineBuiltIn = __w_pdfjs_require__(44);
var fails = __w_pdfjs_require__(9);
var hasOwn = __w_pdfjs_require__(6);
var enforceInternalState = (__w_pdfjs_require__(48).enforce);
var setSpecies = __w_pdfjs_require__(148);
var wellKnownSymbol = __w_pdfjs_require__(14);
var UNSUPPORTED_DOT_ALL = __w_pdfjs_require__(127);
var UNSUPPORTED_NCG = __w_pdfjs_require__(128);
var MATCH = wellKnownSymbol('match');
var NativeRegExp = global.RegExp;
var RegExpPrototype = NativeRegExp.prototype;
var SyntaxError = global.SyntaxError;
var exec = uncurryThis(RegExpPrototype.exec);
var charAt = uncurryThis(''.charAt);
var replace = uncurryThis(''.replace);
var stringIndexOf = uncurryThis(''.indexOf);
var stringSlice = uncurryThis(''.slice);
var IS_NCG = /^\?<[^\s\d!#%&*+<=>@^][^\s!#%&*+<=>@^]*>/;
var re1 = /a/g;
var re2 = /a/g;
var CORRECT_NEW = new NativeRegExp(re1) !== re1;
var MISSED_STICKY = stickyHelpers.MISSED_STICKY;
var UNSUPPORTED_Y = stickyHelpers.UNSUPPORTED_Y;
var BASE_FORCED = DESCRIPTORS && (!CORRECT_NEW || MISSED_STICKY || UNSUPPORTED_DOT_ALL || UNSUPPORTED_NCG || fails(function () {
 re2[MATCH] = false;
 return NativeRegExp(re1) != re1 || NativeRegExp(re2) == re2 || NativeRegExp(re1, 'i') != '/a/i';
}));
var handleDotAll = function (string) {
 var length = string.length;
 var index = 0;
 var result = '';
 var brackets = false;
 var chr;
 for (; index <= length; index++) {
  chr = charAt(string, index);
  if (chr === '\\') {
   result += chr + charAt(string, ++index);
   continue;
  }
  if (!brackets && chr === '.') {
   result += '[\\s\\S]';
  } else {
   if (chr === '[') {
    brackets = true;
   } else if (chr === ']') {
    brackets = false;
   }
   result += chr;
  }
 }
 return result;
};
var handleNCG = function (string) {
 var length = string.length;
 var index = 0;
 var result = '';
 var named = [];
 var names = {};
 var brackets = false;
 var ncg = false;
 var groupid = 0;
 var groupname = '';
 var chr;
 for (; index <= length; index++) {
  chr = charAt(string, index);
  if (chr === '\\') {
   chr = chr + charAt(string, ++index);
  } else if (chr === ']') {
   brackets = false;
  } else if (!brackets)
   switch (true) {
   case chr === '[':
    brackets = true;
    break;
   case chr === '(':
    if (exec(IS_NCG, stringSlice(string, index + 1))) {
     index += 2;
     ncg = true;
    }
    result += chr;
    groupid++;
    continue;
   case chr === '>' && ncg:
    if (groupname === '' || hasOwn(names, groupname)) {
     throw new SyntaxError('Invalid capture group name');
    }
    names[groupname] = true;
    named[named.length] = [
     groupname,
     groupid
    ];
    ncg = false;
    groupname = '';
    continue;
   }
  if (ncg)
   groupname += chr;
  else
   result += chr;
 }
 return [
  result,
  named
 ];
};
if (isForced('RegExp', BASE_FORCED)) {
 var RegExpWrapper = function RegExp(pattern, flags) {
  var thisIsRegExp = isPrototypeOf(RegExpPrototype, this);
  var patternIsRegExp = isRegExp(pattern);
  var flagsAreUndefined = flags === undefined;
  var groups = [];
  var rawPattern = pattern;
  var rawFlags, dotAll, sticky, handled, result, state;
  if (!thisIsRegExp && patternIsRegExp && flagsAreUndefined && pattern.constructor === RegExpWrapper) {
   return pattern;
  }
  if (patternIsRegExp || isPrototypeOf(RegExpPrototype, pattern)) {
   pattern = pattern.source;
   if (flagsAreUndefined)
    flags = getRegExpFlags(rawPattern);
  }
  pattern = pattern === undefined ? '' : toString(pattern);
  flags = flags === undefined ? '' : toString(flags);
  rawPattern = pattern;
  if (UNSUPPORTED_DOT_ALL && 'dotAll' in re1) {
   dotAll = !!flags && stringIndexOf(flags, 's') > -1;
   if (dotAll)
    flags = replace(flags, /s/g, '');
  }
  rawFlags = flags;
  if (MISSED_STICKY && 'sticky' in re1) {
   sticky = !!flags && stringIndexOf(flags, 'y') > -1;
   if (sticky && UNSUPPORTED_Y)
    flags = replace(flags, /y/g, '');
  }
  if (UNSUPPORTED_NCG) {
   handled = handleNCG(pattern);
   pattern = handled[0];
   groups = handled[1];
  }
  result = inheritIfRequired(NativeRegExp(pattern, flags), thisIsRegExp ? this : RegExpPrototype, RegExpWrapper);
  if (dotAll || sticky || groups.length) {
   state = enforceInternalState(result);
   if (dotAll) {
    state.dotAll = true;
    state.raw = RegExpWrapper(handleDotAll(pattern), rawFlags);
   }
   if (sticky)
    state.sticky = true;
   if (groups.length)
    state.groups = groups;
  }
  if (pattern !== rawPattern)
   try {
    createNonEnumerableProperty(result, 'source', rawPattern === '' ? '(?:)' : rawPattern);
   } catch (error) {
   }
  return result;
 };
 for (var keys = getOwnPropertyNames(NativeRegExp), index = 0; keys.length > index;) {
  proxyAccessor(RegExpWrapper, NativeRegExp, keys[index++]);
 }
 RegExpPrototype.constructor = RegExpWrapper;
 RegExpWrapper.prototype = RegExpPrototype;
 defineBuiltIn(global, 'RegExp', RegExpWrapper, { constructor: true });
}
setSpecies('RegExp');

/***/ }),
/* 346 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var DESCRIPTORS = __w_pdfjs_require__(25);
var UNSUPPORTED_DOT_ALL = __w_pdfjs_require__(127);
var classof = __w_pdfjs_require__(63);
var defineBuiltInAccessor = __w_pdfjs_require__(87);
var getInternalState = (__w_pdfjs_require__(48).get);
var RegExpPrototype = RegExp.prototype;
var $TypeError = TypeError;
if (DESCRIPTORS && UNSUPPORTED_DOT_ALL) {
 defineBuiltInAccessor(RegExpPrototype, 'dotAll', {
  configurable: true,
  get: function dotAll() {
   if (this === RegExpPrototype)
    return undefined;
   if (classof(this) === 'RegExp') {
    return !!getInternalState(this).dotAll;
   }
   throw $TypeError('Incompatible receiver, RegExp required');
  }
 });
}

/***/ }),
/* 347 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var DESCRIPTORS = __w_pdfjs_require__(25);
var MISSED_STICKY = (__w_pdfjs_require__(126).MISSED_STICKY);
var classof = __w_pdfjs_require__(63);
var defineBuiltInAccessor = __w_pdfjs_require__(87);
var getInternalState = (__w_pdfjs_require__(48).get);
var RegExpPrototype = RegExp.prototype;
var $TypeError = TypeError;
if (DESCRIPTORS && MISSED_STICKY) {
 defineBuiltInAccessor(RegExpPrototype, 'sticky', {
  configurable: true,
  get: function sticky() {
   if (this === RegExpPrototype)
    return;
   if (classof(this) === 'RegExp') {
    return !!getInternalState(this).sticky;
   }
   throw $TypeError('Incompatible receiver, RegExp required');
  }
 });
}

/***/ }),
/* 348 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var apply = __w_pdfjs_require__(100);
var call = __w_pdfjs_require__(35);
var uncurryThis = __w_pdfjs_require__(7);
var fixRegExpWellKnownSymbolLogic = __w_pdfjs_require__(313);
var anObject = __w_pdfjs_require__(32);
var isNullOrUndefined = __w_pdfjs_require__(12);
var isRegExp = __w_pdfjs_require__(310);
var requireObjectCoercible = __w_pdfjs_require__(11);
var speciesConstructor = __w_pdfjs_require__(150);
var advanceStringIndex = __w_pdfjs_require__(314);
var toLength = __w_pdfjs_require__(73);
var toString = __w_pdfjs_require__(77);
var getMethod = __w_pdfjs_require__(39);
var arraySlice = __w_pdfjs_require__(85);
var callRegExpExec = __w_pdfjs_require__(315);
var regexpExec = __w_pdfjs_require__(124);
var stickyHelpers = __w_pdfjs_require__(126);
var fails = __w_pdfjs_require__(9);
var UNSUPPORTED_Y = stickyHelpers.UNSUPPORTED_Y;
var MAX_UINT32 = 0xFFFFFFFF;
var min = Math.min;
var $push = [].push;
var exec = uncurryThis(/./.exec);
var push = uncurryThis($push);
var stringSlice = uncurryThis(''.slice);
var SPLIT_WORKS_WITH_OVERWRITTEN_EXEC = !fails(function () {
 var re = /(?:)/;
 var originalExec = re.exec;
 re.exec = function () {
  return originalExec.apply(this, arguments);
 };
 var result = 'ab'.split(re);
 return result.length !== 2 || result[0] !== 'a' || result[1] !== 'b';
});
fixRegExpWellKnownSymbolLogic('split', function (SPLIT, nativeSplit, maybeCallNative) {
 var internalSplit;
 if ('abbc'.split(/(b)*/)[1] == 'c' || 'test'.split(/(?:)/, -1).length != 4 || 'ab'.split(/(?:ab)*/).length != 2 || '.'.split(/(.?)(.?)/).length != 4 || '.'.split(/()()/).length > 1 || ''.split(/.?/).length) {
  internalSplit = function (separator, limit) {
   var string = toString(requireObjectCoercible(this));
   var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
   if (lim === 0)
    return [];
   if (separator === undefined)
    return [string];
   if (!isRegExp(separator)) {
    return call(nativeSplit, string, separator, lim);
   }
   var output = [];
   var flags = (separator.ignoreCase ? 'i' : '') + (separator.multiline ? 'm' : '') + (separator.unicode ? 'u' : '') + (separator.sticky ? 'y' : '');
   var lastLastIndex = 0;
   var separatorCopy = new RegExp(separator.source, flags + 'g');
   var match, lastIndex, lastLength;
   while (match = call(regexpExec, separatorCopy, string)) {
    lastIndex = separatorCopy.lastIndex;
    if (lastIndex > lastLastIndex) {
     push(output, stringSlice(string, lastLastIndex, match.index));
     if (match.length > 1 && match.index < string.length)
      apply($push, output, arraySlice(match, 1));
     lastLength = match[0].length;
     lastLastIndex = lastIndex;
     if (output.length >= lim)
      break;
    }
    if (separatorCopy.lastIndex === match.index)
     separatorCopy.lastIndex++;
   }
   if (lastLastIndex === string.length) {
    if (lastLength || !exec(separatorCopy, ''))
     push(output, '');
   } else
    push(output, stringSlice(string, lastLastIndex));
   return output.length > lim ? arraySlice(output, 0, lim) : output;
  };
 } else if ('0'.split(undefined, 0).length) {
  internalSplit = function (separator, limit) {
   return separator === undefined && limit === 0 ? [] : call(nativeSplit, this, separator, limit);
  };
 } else
  internalSplit = nativeSplit;
 return [
  function split(separator, limit) {
   var O = requireObjectCoercible(this);
   var splitter = isNullOrUndefined(separator) ? undefined : getMethod(separator, SPLIT);
   return splitter ? call(splitter, separator, O, limit) : call(internalSplit, toString(O), separator, limit);
  },
  function (string, limit) {
   var rx = anObject(this);
   var S = toString(string);
   var res = maybeCallNative(internalSplit, rx, S, limit, internalSplit !== nativeSplit);
   if (res.done)
    return res.value;
   var C = speciesConstructor(rx, RegExp);
   var unicodeMatching = rx.unicode;
   var flags = (rx.ignoreCase ? 'i' : '') + (rx.multiline ? 'm' : '') + (rx.unicode ? 'u' : '') + (UNSUPPORTED_Y ? 'g' : 'y');
   var splitter = new C(UNSUPPORTED_Y ? '^(?:' + rx.source + ')' : rx, flags);
   var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
   if (lim === 0)
    return [];
   if (S.length === 0)
    return callRegExpExec(splitter, S) === null ? [S] : [];
   var p = 0;
   var q = 0;
   var A = [];
   while (q < S.length) {
    splitter.lastIndex = UNSUPPORTED_Y ? 0 : q;
    var z = callRegExpExec(splitter, UNSUPPORTED_Y ? stringSlice(S, q) : S);
    var e;
    if (z === null || (e = min(toLength(splitter.lastIndex + (UNSUPPORTED_Y ? q : 0)), S.length)) === p) {
     q = advanceStringIndex(S, q, unicodeMatching);
    } else {
     push(A, stringSlice(S, p, q));
     if (A.length === lim)
      return A;
     for (var i = 1; i <= z.length - 1; i++) {
      push(A, z[i]);
      if (A.length === lim)
       return A;
     }
     q = p = e;
    }
   }
   push(A, stringSlice(S, p));
   return A;
  }
 ];
}, !SPLIT_WORKS_WITH_OVERWRITTEN_EXEC, UNSUPPORTED_Y);

/***/ }),
/* 349 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

__w_pdfjs_require__(2);__w_pdfjs_require__(54);__w_pdfjs_require__(183);__w_pdfjs_require__(105);__w_pdfjs_require__(145);__w_pdfjs_require__(130);__w_pdfjs_require__(131);__w_pdfjs_require__(132);__w_pdfjs_require__(133);__w_pdfjs_require__(134);__w_pdfjs_require__(299);__w_pdfjs_require__(114);__w_pdfjs_require__(129);function _typeof(obj){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj;}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;},_typeof(obj);}Object.defineProperty(exports, "__esModule", ({value:true}));exports.RefSetCache=exports.RefSet=exports.Ref=exports.Name=exports.EOF=exports.Dict=exports.Cmd=exports.CIRCULAR_REF=void 0;exports.clearPrimitiveCaches=clearPrimitiveCaches;exports.isCmd=isCmd;exports.isDict=isDict;exports.isName=isName;exports.isRefsEqual=isRefsEqual;__w_pdfjs_require__(56);__w_pdfjs_require__(104);__w_pdfjs_require__(143);__w_pdfjs_require__(326);__w_pdfjs_require__(295);__w_pdfjs_require__(350);__w_pdfjs_require__(137);__w_pdfjs_require__(334);__w_pdfjs_require__(175);__w_pdfjs_require__(177);__w_pdfjs_require__(352);__w_pdfjs_require__(289);__w_pdfjs_require__(301);__w_pdfjs_require__(123);__w_pdfjs_require__(258);__w_pdfjs_require__(266);__w_pdfjs_require__(277);__w_pdfjs_require__(279);__w_pdfjs_require__(281);__w_pdfjs_require__(283);__w_pdfjs_require__(285);__w_pdfjs_require__(287);__w_pdfjs_require__(292);__w_pdfjs_require__(113);var _util=__w_pdfjs_require__(303);function _slicedToArray(arr,i){return _arrayWithHoles(arr)||_iterableToArrayLimit(arr,i)||_unsupportedIterableToArray(arr,i)||_nonIterableRest();}function _nonIterableRest(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}function _iterableToArrayLimit(arr,i){var _i=null==arr?null:"undefined"!=typeof Symbol&&arr[Symbol.iterator]||arr["@@iterator"];if(null!=_i){var _s,_e,_x,_r,_arr=[],_n=!0,_d=!1;try{if(_x=(_i=_i.call(arr)).next,0===i){if(Object(_i)!==_i)return;_n=!1;}else for(;!(_n=(_s=_x.call(_i)).done)&&(_arr.push(_s.value),_arr.length!==i);_n=!0);}catch(err){_d=!0,_e=err;}finally{try{if(!_n&&null!=_i.return&&(_r=_i.return(),Object(_r)!==_r))return;}finally{if(_d)throw _e;}}return _arr;}}function _arrayWithHoles(arr){if(Array.isArray(arr))return arr;}function _createForOfIteratorHelper(o,allowArrayLike){var it=typeof Symbol!=="undefined"&&o[Symbol.iterator]||o["@@iterator"];if(!it){if(Array.isArray(o)||(it=_unsupportedIterableToArray(o))||allowArrayLike&&o&&typeof o.length==="number"){if(it)o=it;var i=0;var F=function F(){};return{s:F,n:function n(){if(i>=o.length)return{done:true};return{done:false,value:o[i++]};},e:function e(_e2){throw _e2;},f:F};}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}var normalCompletion=true,didErr=false,err;return{s:function s(){it=it.call(o);},n:function n(){var step=it.next();normalCompletion=step.done;return step;},e:function e(_e3){didErr=true;err=_e3;},f:function f(){try{if(!normalCompletion&&it.return!=null)it.return();}finally{if(didErr)throw err;}}};}function _unsupportedIterableToArray(o,minLen){if(!o)return;if(typeof o==="string")return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);if(n==="Object"&&o.constructor)n=o.constructor.name;if(n==="Map"||n==="Set")return Array.from(o);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return _arrayLikeToArray(o,minLen);}function _arrayLikeToArray(arr,len){if(len==null||len>arr.length)len=arr.length;for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2;}function _regeneratorRuntime(){"use strict";/*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */_regeneratorRuntime=function _regeneratorRuntime(){return exports;};var exports={},Op=Object.prototype,hasOwn=Op.hasOwnProperty,defineProperty=Object.defineProperty||function(obj,key,desc){obj[key]=desc.value;},$Symbol="function"==typeof Symbol?Symbol:{},iteratorSymbol=$Symbol.iterator||"@@iterator",asyncIteratorSymbol=$Symbol.asyncIterator||"@@asyncIterator",toStringTagSymbol=$Symbol.toStringTag||"@@toStringTag";function define(obj,key,value){return Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}),obj[key];}try{define({},"");}catch(err){define=function define(obj,key,value){return obj[key]=value;};}function wrap(innerFn,outerFn,self,tryLocsList){var protoGenerator=outerFn&&outerFn.prototype instanceof Generator?outerFn:Generator,generator=Object.create(protoGenerator.prototype),context=new Context(tryLocsList||[]);return defineProperty(generator,"_invoke",{value:makeInvokeMethod(innerFn,self,context)}),generator;}function tryCatch(fn,obj,arg){try{return{type:"normal",arg:fn.call(obj,arg)};}catch(err){return{type:"throw",arg:err};}}exports.wrap=wrap;var ContinueSentinel={};function Generator(){}function GeneratorFunction(){}function GeneratorFunctionPrototype(){}var IteratorPrototype={};define(IteratorPrototype,iteratorSymbol,function(){return this;});var getProto=Object.getPrototypeOf,NativeIteratorPrototype=getProto&&getProto(getProto(values([])));NativeIteratorPrototype&&NativeIteratorPrototype!==Op&&hasOwn.call(NativeIteratorPrototype,iteratorSymbol)&&(IteratorPrototype=NativeIteratorPrototype);var Gp=GeneratorFunctionPrototype.prototype=Generator.prototype=Object.create(IteratorPrototype);function defineIteratorMethods(prototype){["next","throw","return"].forEach(function(method){define(prototype,method,function(arg){return this._invoke(method,arg);});});}function AsyncIterator(generator,PromiseImpl){function invoke(method,arg,resolve,reject){var record=tryCatch(generator[method],generator,arg);if("throw"!==record.type){var result=record.arg,value=result.value;return value&&"object"==_typeof(value)&&hasOwn.call(value,"__await")?PromiseImpl.resolve(value.__await).then(function(value){invoke("next",value,resolve,reject);},function(err){invoke("throw",err,resolve,reject);}):PromiseImpl.resolve(value).then(function(unwrapped){result.value=unwrapped,resolve(result);},function(error){return invoke("throw",error,resolve,reject);});}reject(record.arg);}var previousPromise;defineProperty(this,"_invoke",{value:function value(method,arg){function callInvokeWithMethodAndArg(){return new PromiseImpl(function(resolve,reject){invoke(method,arg,resolve,reject);});}return previousPromise=previousPromise?previousPromise.then(callInvokeWithMethodAndArg,callInvokeWithMethodAndArg):callInvokeWithMethodAndArg();}});}function makeInvokeMethod(innerFn,self,context){var state="suspendedStart";return function(method,arg){if("executing"===state)throw new Error("Generator is already running");if("completed"===state){if("throw"===method)throw arg;return doneResult();}for(context.method=method,context.arg=arg;;){var delegate=context.delegate;if(delegate){var delegateResult=maybeInvokeDelegate(delegate,context);if(delegateResult){if(delegateResult===ContinueSentinel)continue;return delegateResult;}}if("next"===context.method)context.sent=context._sent=context.arg;else if("throw"===context.method){if("suspendedStart"===state)throw state="completed",context.arg;context.dispatchException(context.arg);}else"return"===context.method&&context.abrupt("return",context.arg);state="executing";var record=tryCatch(innerFn,self,context);if("normal"===record.type){if(state=context.done?"completed":"suspendedYield",record.arg===ContinueSentinel)continue;return{value:record.arg,done:context.done};}"throw"===record.type&&(state="completed",context.method="throw",context.arg=record.arg);}};}function maybeInvokeDelegate(delegate,context){var methodName=context.method,method=delegate.iterator[methodName];if(undefined===method)return context.delegate=null,"throw"===methodName&&delegate.iterator.return&&(context.method="return",context.arg=undefined,maybeInvokeDelegate(delegate,context),"throw"===context.method)||"return"!==methodName&&(context.method="throw",context.arg=new TypeError("The iterator does not provide a '"+methodName+"' method")),ContinueSentinel;var record=tryCatch(method,delegate.iterator,context.arg);if("throw"===record.type)return context.method="throw",context.arg=record.arg,context.delegate=null,ContinueSentinel;var info=record.arg;return info?info.done?(context[delegate.resultName]=info.value,context.next=delegate.nextLoc,"return"!==context.method&&(context.method="next",context.arg=undefined),context.delegate=null,ContinueSentinel):info:(context.method="throw",context.arg=new TypeError("iterator result is not an object"),context.delegate=null,ContinueSentinel);}function pushTryEntry(locs){var entry={tryLoc:locs[0]};1 in locs&&(entry.catchLoc=locs[1]),2 in locs&&(entry.finallyLoc=locs[2],entry.afterLoc=locs[3]),this.tryEntries.push(entry);}function resetTryEntry(entry){var record=entry.completion||{};record.type="normal",delete record.arg,entry.completion=record;}function Context(tryLocsList){this.tryEntries=[{tryLoc:"root"}],tryLocsList.forEach(pushTryEntry,this),this.reset(!0);}function values(iterable){if(iterable){var iteratorMethod=iterable[iteratorSymbol];if(iteratorMethod)return iteratorMethod.call(iterable);if("function"==typeof iterable.next)return iterable;if(!isNaN(iterable.length)){var i=-1,next=function next(){for(;++i<iterable.length;)if(hasOwn.call(iterable,i))return next.value=iterable[i],next.done=!1,next;return next.value=undefined,next.done=!0,next;};return next.next=next;}}return{next:doneResult};}function doneResult(){return{value:undefined,done:!0};}return GeneratorFunction.prototype=GeneratorFunctionPrototype,defineProperty(Gp,"constructor",{value:GeneratorFunctionPrototype,configurable:!0}),defineProperty(GeneratorFunctionPrototype,"constructor",{value:GeneratorFunction,configurable:!0}),GeneratorFunction.displayName=define(GeneratorFunctionPrototype,toStringTagSymbol,"GeneratorFunction"),exports.isGeneratorFunction=function(genFun){var ctor="function"==typeof genFun&&genFun.constructor;return!!ctor&&(ctor===GeneratorFunction||"GeneratorFunction"===(ctor.displayName||ctor.name));},exports.mark=function(genFun){return Object.setPrototypeOf?Object.setPrototypeOf(genFun,GeneratorFunctionPrototype):(genFun.__proto__=GeneratorFunctionPrototype,define(genFun,toStringTagSymbol,"GeneratorFunction")),genFun.prototype=Object.create(Gp),genFun;},exports.awrap=function(arg){return{__await:arg};},defineIteratorMethods(AsyncIterator.prototype),define(AsyncIterator.prototype,asyncIteratorSymbol,function(){return this;}),exports.AsyncIterator=AsyncIterator,exports.async=function(innerFn,outerFn,self,tryLocsList,PromiseImpl){void 0===PromiseImpl&&(PromiseImpl=Promise);var iter=new AsyncIterator(wrap(innerFn,outerFn,self,tryLocsList),PromiseImpl);return exports.isGeneratorFunction(outerFn)?iter:iter.next().then(function(result){return result.done?result.value:iter.next();});},defineIteratorMethods(Gp),define(Gp,toStringTagSymbol,"Generator"),define(Gp,iteratorSymbol,function(){return this;}),define(Gp,"toString",function(){return"[object Generator]";}),exports.keys=function(val){var object=Object(val),keys=[];for(var key in object)keys.push(key);return keys.reverse(),function next(){for(;keys.length;){var key=keys.pop();if(key in object)return next.value=key,next.done=!1,next;}return next.done=!0,next;};},exports.values=values,Context.prototype={constructor:Context,reset:function reset(skipTempReset){if(this.prev=0,this.next=0,this.sent=this._sent=undefined,this.done=!1,this.delegate=null,this.method="next",this.arg=undefined,this.tryEntries.forEach(resetTryEntry),!skipTempReset)for(var name in this)"t"===name.charAt(0)&&hasOwn.call(this,name)&&!isNaN(+name.slice(1))&&(this[name]=undefined);},stop:function stop(){this.done=!0;var rootRecord=this.tryEntries[0].completion;if("throw"===rootRecord.type)throw rootRecord.arg;return this.rval;},dispatchException:function dispatchException(exception){if(this.done)throw exception;var context=this;function handle(loc,caught){return record.type="throw",record.arg=exception,context.next=loc,caught&&(context.method="next",context.arg=undefined),!!caught;}for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i],record=entry.completion;if("root"===entry.tryLoc)return handle("end");if(entry.tryLoc<=this.prev){var hasCatch=hasOwn.call(entry,"catchLoc"),hasFinally=hasOwn.call(entry,"finallyLoc");if(hasCatch&&hasFinally){if(this.prev<entry.catchLoc)return handle(entry.catchLoc,!0);if(this.prev<entry.finallyLoc)return handle(entry.finallyLoc);}else if(hasCatch){if(this.prev<entry.catchLoc)return handle(entry.catchLoc,!0);}else{if(!hasFinally)throw new Error("try statement without catch or finally");if(this.prev<entry.finallyLoc)return handle(entry.finallyLoc);}}}},abrupt:function abrupt(type,arg){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.tryLoc<=this.prev&&hasOwn.call(entry,"finallyLoc")&&this.prev<entry.finallyLoc){var finallyEntry=entry;break;}}finallyEntry&&("break"===type||"continue"===type)&&finallyEntry.tryLoc<=arg&&arg<=finallyEntry.finallyLoc&&(finallyEntry=null);var record=finallyEntry?finallyEntry.completion:{};return record.type=type,record.arg=arg,finallyEntry?(this.method="next",this.next=finallyEntry.finallyLoc,ContinueSentinel):this.complete(record);},complete:function complete(record,afterLoc){if("throw"===record.type)throw record.arg;return"break"===record.type||"continue"===record.type?this.next=record.arg:"return"===record.type?(this.rval=this.arg=record.arg,this.method="return",this.next="end"):"normal"===record.type&&afterLoc&&(this.next=afterLoc),ContinueSentinel;},finish:function finish(finallyLoc){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.finallyLoc===finallyLoc)return this.complete(entry.completion,entry.afterLoc),resetTryEntry(entry),ContinueSentinel;}},catch:function _catch(tryLoc){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.tryLoc===tryLoc){var record=entry.completion;if("throw"===record.type){var thrown=record.arg;resetTryEntry(entry);}return thrown;}}throw new Error("illegal catch attempt");},delegateYield:function delegateYield(iterable,resultName,nextLoc){return this.delegate={iterator:values(iterable),resultName:resultName,nextLoc:nextLoc},"next"===this.method&&(this.arg=undefined),ContinueSentinel;}},exports;}function asyncGeneratorStep(gen,resolve,reject,_next,_throw,key,arg){try{var info=gen[key](arg);var value=info.value;}catch(error){reject(error);return;}if(info.done){resolve(value);}else{Promise.resolve(value).then(_next,_throw);}}function _asyncToGenerator(fn){return function(){var self=this,args=arguments;return new Promise(function(resolve,reject){var gen=fn.apply(self,args);function _next(value){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"next",value);}function _throw(err){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"throw",err);}_next(undefined);});};}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}}function _createClass(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);Object.defineProperty(Constructor,"prototype",{writable:false});return Constructor;}function _toPropertyKey(arg){var key=_toPrimitive(arg,"string");return _typeof(key)==="symbol"?key:String(key);}function _toPrimitive(input,hint){if(_typeof(input)!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(_typeof(res)!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.");}return(hint==="string"?String:Number)(input);}var CIRCULAR_REF=Symbol("CIRCULAR_REF");exports.CIRCULAR_REF=CIRCULAR_REF;var EOF=Symbol("EOF");exports.EOF=EOF;var CmdCache=Object.create(null);var NameCache=Object.create(null);var RefCache=Object.create(null);function clearPrimitiveCaches(){CmdCache=Object.create(null);NameCache=Object.create(null);RefCache=Object.create(null);}var Name=/*#__PURE__*/function(){function Name(name){_classCallCheck(this,Name);this.name=name;}_createClass(Name,null,[{key:"get",value:function get(name){var _NameCache;return(_NameCache=NameCache)[name]||(_NameCache[name]=new Name(name));}}]);return Name;}();exports.Name=Name;var Cmd=/*#__PURE__*/function(){function Cmd(cmd){_classCallCheck(this,Cmd);this.cmd=cmd;}_createClass(Cmd,null,[{key:"get",value:function get(cmd){var _CmdCache;return(_CmdCache=CmdCache)[cmd]||(_CmdCache[cmd]=new Cmd(cmd));}}]);return Cmd;}();exports.Cmd=Cmd;var nonSerializable=function nonSerializableClosure(){return nonSerializable;};var Dict=/*#__PURE__*/function(){function Dict(){var xref=arguments.length>0&&arguments[0]!==undefined?arguments[0]:null;_classCallCheck(this,Dict);this._map=Object.create(null);this.xref=xref;this.objId=null;this.suppressEncryption=false;this.__nonSerializable__=nonSerializable;}_createClass(Dict,[{key:"assignXref",value:function assignXref(newXref){this.xref=newXref;}},{key:"size",get:function get(){return Object.keys(this._map).length;}},{key:"get",value:function get(key1,key2,key3){var value=this._map[key1];if(value===undefined&&key2!==undefined){value=this._map[key2];if(value===undefined&&key3!==undefined){value=this._map[key3];}}if(value instanceof Ref&&this.xref){return this.xref.fetch(value,this.suppressEncryption);}return value;}},{key:"getAsync",value:function(){var _getAsync=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee(key1,key2,key3){var value;return _regeneratorRuntime().wrap(function _callee$(_context){while(1)switch(_context.prev=_context.next){case 0:value=this._map[key1];if(value===undefined&&key2!==undefined){value=this._map[key2];if(value===undefined&&key3!==undefined){value=this._map[key3];}}if(!(value instanceof Ref&&this.xref)){_context.next=4;break;}return _context.abrupt("return",this.xref.fetchAsync(value,this.suppressEncryption));case 4:return _context.abrupt("return",value);case 5:case"end":return _context.stop();}},_callee,this);}));function getAsync(_x,_x2,_x3){return _getAsync.apply(this,arguments);}return getAsync;}()},{key:"getArray",value:function getArray(key1,key2,key3){var value=this._map[key1];if(value===undefined&&key2!==undefined){value=this._map[key2];if(value===undefined&&key3!==undefined){value=this._map[key3];}}if(value instanceof Ref&&this.xref){value=this.xref.fetch(value,this.suppressEncryption);}if(Array.isArray(value)){value=value.slice();for(var i=0,ii=value.length;i<ii;i++){if(value[i]instanceof Ref&&this.xref){value[i]=this.xref.fetch(value[i],this.suppressEncryption);}}}return value;}},{key:"getRaw",value:function getRaw(key){return this._map[key];}},{key:"getKeys",value:function getKeys(){return Object.keys(this._map);}},{key:"getRawValues",value:function getRawValues(){return Object.values(this._map);}},{key:"set",value:function set(key,value){this._map[key]=value;}},{key:"has",value:function has(key){return this._map[key]!==undefined;}},{key:"forEach",value:function forEach(callback){for(var key in this._map){callback(key,this.get(key));}}}],[{key:"empty",get:function get(){var emptyDict=new Dict(null);emptyDict.set=function(key,value){(0,_util.unreachable)("Should not call `set` on the empty dictionary.");};return(0,_util.shadow)(this,"empty",emptyDict);}},{key:"merge",value:function merge(_ref){var xref=_ref.xref,dictArray=_ref.dictArray,_ref$mergeSubDicts=_ref.mergeSubDicts,mergeSubDicts=_ref$mergeSubDicts===void 0?false:_ref$mergeSubDicts;var mergedDict=new Dict(xref),properties=new Map();var _iterator=_createForOfIteratorHelper(dictArray),_step;try{for(_iterator.s();!(_step=_iterator.n()).done;){var dict=_step.value;if(!(dict instanceof Dict)){continue;}for(var _i=0,_Object$entries=Object.entries(dict._map);_i<_Object$entries.length;_i++){var _Object$entries$_i=_slicedToArray(_Object$entries[_i],2),key=_Object$entries$_i[0],value=_Object$entries$_i[1];var property=properties.get(key);if(property===undefined){property=[];properties.set(key,property);}else if(!mergeSubDicts||!(value instanceof Dict)){continue;}property.push(value);}}}catch(err){_iterator.e(err);}finally{_iterator.f();}var _iterator2=_createForOfIteratorHelper(properties),_step2;try{for(_iterator2.s();!(_step2=_iterator2.n()).done;){var _step2$value=_slicedToArray(_step2.value,2),name=_step2$value[0],values=_step2$value[1];if(values.length===1||!(values[0]instanceof Dict)){mergedDict._map[name]=values[0];continue;}var subDict=new Dict(xref);var _iterator3=_createForOfIteratorHelper(values),_step3;try{for(_iterator3.s();!(_step3=_iterator3.n()).done;){var _dict=_step3.value;for(var _i2=0,_Object$entries2=Object.entries(_dict._map);_i2<_Object$entries2.length;_i2++){var _Object$entries2$_i=_slicedToArray(_Object$entries2[_i2],2),_key=_Object$entries2$_i[0],_value=_Object$entries2$_i[1];if(subDict._map[_key]===undefined){subDict._map[_key]=_value;}}}}catch(err){_iterator3.e(err);}finally{_iterator3.f();}if(subDict.size>0){mergedDict._map[name]=subDict;}}}catch(err){_iterator2.e(err);}finally{_iterator2.f();}properties.clear();return mergedDict.size>0?mergedDict:Dict.empty;}}]);return Dict;}();exports.Dict=Dict;var Ref=/*#__PURE__*/function(){function Ref(num,gen){_classCallCheck(this,Ref);this.num=num;this.gen=gen;}_createClass(Ref,[{key:"toString",value:function toString(){if(this.gen===0){return"".concat(this.num,"R");}return"".concat(this.num,"R").concat(this.gen);}}],[{key:"fromString",value:function fromString(str){var ref=RefCache[str];if(ref){return ref;}var m=/^(\d+)R(\d*)$/.exec(str);if(!m||m[1]==="0"){return null;}return RefCache[str]=new Ref(parseInt(m[1]),!m[2]?0:parseInt(m[2]));}},{key:"get",value:function get(num,gen){var _RefCache;var key=gen===0?"".concat(num,"R"):"".concat(num,"R").concat(gen);return(_RefCache=RefCache)[key]||(_RefCache[key]=new Ref(num,gen));}}]);return Ref;}();exports.Ref=Ref;var RefSet=/*#__PURE__*/function(_Symbol$iterator){function RefSet(){var parent=arguments.length>0&&arguments[0]!==undefined?arguments[0]:null;_classCallCheck(this,RefSet);this._set=new Set(parent===null||parent===void 0?void 0:parent._set);}_createClass(RefSet,[{key:"has",value:function has(ref){return this._set.has(ref.toString());}},{key:"put",value:function put(ref){this._set.add(ref.toString());}},{key:"remove",value:function remove(ref){this._set.delete(ref.toString());}},{key:_Symbol$iterator,value:function value(){return this._set.values();}},{key:"clear",value:function clear(){this._set.clear();}}]);return RefSet;}(Symbol.iterator);exports.RefSet=RefSet;var RefSetCache=/*#__PURE__*/function(_Symbol$iterator2){function RefSetCache(){_classCallCheck(this,RefSetCache);this._map=new Map();}_createClass(RefSetCache,[{key:"size",get:function get(){return this._map.size;}},{key:"get",value:function get(ref){return this._map.get(ref.toString());}},{key:"has",value:function has(ref){return this._map.has(ref.toString());}},{key:"put",value:function put(ref,obj){this._map.set(ref.toString(),obj);}},{key:"putAlias",value:function putAlias(ref,aliasRef){this._map.set(ref.toString(),this.get(aliasRef));}},{key:_Symbol$iterator2,value:function value(){return this._map.values();}},{key:"clear",value:function clear(){this._map.clear();}}]);return RefSetCache;}(Symbol.iterator);exports.RefSetCache=RefSetCache;function isName(v,name){return v instanceof Name&&(name===undefined||v.name===name);}function isCmd(v,cmd){return v instanceof Cmd&&(cmd===undefined||v.cmd===cmd);}function isDict(v,type){return v instanceof Dict&&(type===undefined||isName(v.get("Type"),type));}function isRefsEqual(v1,v2){return v1.num===v2.num&&v1.gen===v2.gen;}

/***/ }),
/* 350 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var $values = (__w_pdfjs_require__(351).values);
$({
 target: 'Object',
 stat: true
}, {
 values: function values(O) {
  return $values(O);
 }
});

/***/ }),
/* 351 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var DESCRIPTORS = __w_pdfjs_require__(25);
var fails = __w_pdfjs_require__(9);
var uncurryThis = __w_pdfjs_require__(7);
var objectGetPrototypeOf = __w_pdfjs_require__(135);
var objectKeys = __w_pdfjs_require__(82);
var toIndexedObject = __w_pdfjs_require__(61);
var $propertyIsEnumerable = (__w_pdfjs_require__(60).f);
var propertyIsEnumerable = uncurryThis($propertyIsEnumerable);
var push = uncurryThis([].push);
var IE_BUG = DESCRIPTORS && fails(function () {
 var O = Object.create(null);
 O[2] = 2;
 return !propertyIsEnumerable(O, 2);
});
var createMethod = function (TO_ENTRIES) {
 return function (it) {
  var O = toIndexedObject(it);
  var keys = objectKeys(O);
  var IE_WORKAROUND = IE_BUG && objectGetPrototypeOf(O) === null;
  var length = keys.length;
  var i = 0;
  var result = [];
  var key;
  while (length > i) {
   key = keys[i++];
   if (!DESCRIPTORS || (IE_WORKAROUND ? key in O : propertyIsEnumerable(O, key))) {
    push(result, TO_ENTRIES ? [
     key,
     O[key]
    ] : O[key]);
   }
  }
  return result;
 };
};
module.exports = {
 entries: createMethod(true),
 values: createMethod(false)
};

/***/ }),
/* 352 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var $entries = (__w_pdfjs_require__(351).entries);
$({
 target: 'Object',
 stat: true
}, {
 entries: function entries(O) {
  return $entries(O);
 }
});

/***/ }),
/* 353 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

__w_pdfjs_require__(113);__w_pdfjs_require__(137);__w_pdfjs_require__(175);__w_pdfjs_require__(177);Object.defineProperty(exports, "__esModule", ({value:true}));exports.BaseStream=void 0;__w_pdfjs_require__(2);__w_pdfjs_require__(54);__w_pdfjs_require__(56);__w_pdfjs_require__(104);__w_pdfjs_require__(143);__w_pdfjs_require__(183);__w_pdfjs_require__(105);var _util=__w_pdfjs_require__(303);function _typeof(obj){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj;}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;},_typeof(obj);}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}}function _createClass(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);Object.defineProperty(Constructor,"prototype",{writable:false});return Constructor;}function _toPropertyKey(arg){var key=_toPrimitive(arg,"string");return _typeof(key)==="symbol"?key:String(key);}function _toPrimitive(input,hint){if(_typeof(input)!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(_typeof(res)!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.");}return(hint==="string"?String:Number)(input);}var BaseStream=/*#__PURE__*/function(){function BaseStream(){_classCallCheck(this,BaseStream);if(this.constructor===BaseStream){(0,_util.unreachable)("Cannot initialize BaseStream.");}}_createClass(BaseStream,[{key:"length",get:function get(){(0,_util.unreachable)("Abstract getter `length` accessed");}},{key:"isEmpty",get:function get(){(0,_util.unreachable)("Abstract getter `isEmpty` accessed");}},{key:"isDataLoaded",get:function get(){return(0,_util.shadow)(this,"isDataLoaded",true);}},{key:"getByte",value:function getByte(){(0,_util.unreachable)("Abstract method `getByte` called");}},{key:"getBytes",value:function getBytes(length){(0,_util.unreachable)("Abstract method `getBytes` called");}},{key:"peekByte",value:function peekByte(){var peekedByte=this.getByte();if(peekedByte!==-1){this.pos--;}return peekedByte;}},{key:"peekBytes",value:function peekBytes(length){var bytes=this.getBytes(length);this.pos-=bytes.length;return bytes;}},{key:"getUint16",value:function getUint16(){var b0=this.getByte();var b1=this.getByte();if(b0===-1||b1===-1){return-1;}return(b0<<8)+b1;}},{key:"getInt32",value:function getInt32(){var b0=this.getByte();var b1=this.getByte();var b2=this.getByte();var b3=this.getByte();return(b0<<24)+(b1<<16)+(b2<<8)+b3;}},{key:"getByteRange",value:function getByteRange(begin,end){(0,_util.unreachable)("Abstract method `getByteRange` called");}},{key:"getString",value:function getString(length){return(0,_util.bytesToString)(this.getBytes(length));}},{key:"skip",value:function skip(n){this.pos+=n||1;}},{key:"reset",value:function reset(){(0,_util.unreachable)("Abstract method `reset` called");}},{key:"moveStart",value:function moveStart(){(0,_util.unreachable)("Abstract method `moveStart` called");}},{key:"makeSubStream",value:function makeSubStream(start,length){var dict=arguments.length>2&&arguments[2]!==undefined?arguments[2]:null;(0,_util.unreachable)("Abstract method `makeSubStream` called");}},{key:"getBaseStreams",value:function getBaseStreams(){return null;}}]);return BaseStream;}();exports.BaseStream=BaseStream;

/***/ }),
/* 354 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

__w_pdfjs_require__(113);__w_pdfjs_require__(137);__w_pdfjs_require__(175);__w_pdfjs_require__(177);__w_pdfjs_require__(130);__w_pdfjs_require__(131);__w_pdfjs_require__(132);__w_pdfjs_require__(133);__w_pdfjs_require__(134);__w_pdfjs_require__(289);__w_pdfjs_require__(299);__w_pdfjs_require__(295);__w_pdfjs_require__(304);__w_pdfjs_require__(305);Object.defineProperty(exports, "__esModule", ({value:true}));exports.NetworkPdfManager=exports.LocalPdfManager=void 0;__w_pdfjs_require__(2);__w_pdfjs_require__(54);__w_pdfjs_require__(56);__w_pdfjs_require__(104);__w_pdfjs_require__(143);__w_pdfjs_require__(183);__w_pdfjs_require__(105);__w_pdfjs_require__(145);var _util=__w_pdfjs_require__(303);var _chunked_stream=__w_pdfjs_require__(355);var _core_utils=__w_pdfjs_require__(342);var _document=__w_pdfjs_require__(358);var _stream=__w_pdfjs_require__(357);function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function");}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:true,configurable:true}});Object.defineProperty(subClass,"prototype",{writable:false});if(superClass)_setPrototypeOf(subClass,superClass);}function _setPrototypeOf(o,p){_setPrototypeOf=Object.setPrototypeOf?Object.setPrototypeOf.bind():function _setPrototypeOf(o,p){o.__proto__=p;return o;};return _setPrototypeOf(o,p);}function _createSuper(Derived){var hasNativeReflectConstruct=_isNativeReflectConstruct();return function _createSuperInternal(){var Super=_getPrototypeOf(Derived),result;if(hasNativeReflectConstruct){var NewTarget=_getPrototypeOf(this).constructor;result=Reflect.construct(Super,arguments,NewTarget);}else{result=Super.apply(this,arguments);}return _possibleConstructorReturn(this,result);};}function _possibleConstructorReturn(self,call){if(call&&(_typeof(call)==="object"||typeof call==="function")){return call;}else if(call!==void 0){throw new TypeError("Derived constructors may only return object or undefined");}return _assertThisInitialized(self);}function _assertThisInitialized(self){if(self===void 0){throw new ReferenceError("this hasn't been initialised - super() hasn't been called");}return self;}function _isNativeReflectConstruct(){if(typeof Reflect==="undefined"||!Reflect.construct)return false;if(Reflect.construct.sham)return false;if(typeof Proxy==="function")return true;try{Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}));return true;}catch(e){return false;}}function _getPrototypeOf(o){_getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf.bind():function _getPrototypeOf(o){return o.__proto__||Object.getPrototypeOf(o);};return _getPrototypeOf(o);}function _typeof(obj){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj;}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;},_typeof(obj);}function _regeneratorRuntime(){"use strict";/*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */_regeneratorRuntime=function _regeneratorRuntime(){return exports;};var exports={},Op=Object.prototype,hasOwn=Op.hasOwnProperty,defineProperty=Object.defineProperty||function(obj,key,desc){obj[key]=desc.value;},$Symbol="function"==typeof Symbol?Symbol:{},iteratorSymbol=$Symbol.iterator||"@@iterator",asyncIteratorSymbol=$Symbol.asyncIterator||"@@asyncIterator",toStringTagSymbol=$Symbol.toStringTag||"@@toStringTag";function define(obj,key,value){return Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}),obj[key];}try{define({},"");}catch(err){define=function define(obj,key,value){return obj[key]=value;};}function wrap(innerFn,outerFn,self,tryLocsList){var protoGenerator=outerFn&&outerFn.prototype instanceof Generator?outerFn:Generator,generator=Object.create(protoGenerator.prototype),context=new Context(tryLocsList||[]);return defineProperty(generator,"_invoke",{value:makeInvokeMethod(innerFn,self,context)}),generator;}function tryCatch(fn,obj,arg){try{return{type:"normal",arg:fn.call(obj,arg)};}catch(err){return{type:"throw",arg:err};}}exports.wrap=wrap;var ContinueSentinel={};function Generator(){}function GeneratorFunction(){}function GeneratorFunctionPrototype(){}var IteratorPrototype={};define(IteratorPrototype,iteratorSymbol,function(){return this;});var getProto=Object.getPrototypeOf,NativeIteratorPrototype=getProto&&getProto(getProto(values([])));NativeIteratorPrototype&&NativeIteratorPrototype!==Op&&hasOwn.call(NativeIteratorPrototype,iteratorSymbol)&&(IteratorPrototype=NativeIteratorPrototype);var Gp=GeneratorFunctionPrototype.prototype=Generator.prototype=Object.create(IteratorPrototype);function defineIteratorMethods(prototype){["next","throw","return"].forEach(function(method){define(prototype,method,function(arg){return this._invoke(method,arg);});});}function AsyncIterator(generator,PromiseImpl){function invoke(method,arg,resolve,reject){var record=tryCatch(generator[method],generator,arg);if("throw"!==record.type){var result=record.arg,value=result.value;return value&&"object"==_typeof(value)&&hasOwn.call(value,"__await")?PromiseImpl.resolve(value.__await).then(function(value){invoke("next",value,resolve,reject);},function(err){invoke("throw",err,resolve,reject);}):PromiseImpl.resolve(value).then(function(unwrapped){result.value=unwrapped,resolve(result);},function(error){return invoke("throw",error,resolve,reject);});}reject(record.arg);}var previousPromise;defineProperty(this,"_invoke",{value:function value(method,arg){function callInvokeWithMethodAndArg(){return new PromiseImpl(function(resolve,reject){invoke(method,arg,resolve,reject);});}return previousPromise=previousPromise?previousPromise.then(callInvokeWithMethodAndArg,callInvokeWithMethodAndArg):callInvokeWithMethodAndArg();}});}function makeInvokeMethod(innerFn,self,context){var state="suspendedStart";return function(method,arg){if("executing"===state)throw new Error("Generator is already running");if("completed"===state){if("throw"===method)throw arg;return doneResult();}for(context.method=method,context.arg=arg;;){var delegate=context.delegate;if(delegate){var delegateResult=maybeInvokeDelegate(delegate,context);if(delegateResult){if(delegateResult===ContinueSentinel)continue;return delegateResult;}}if("next"===context.method)context.sent=context._sent=context.arg;else if("throw"===context.method){if("suspendedStart"===state)throw state="completed",context.arg;context.dispatchException(context.arg);}else"return"===context.method&&context.abrupt("return",context.arg);state="executing";var record=tryCatch(innerFn,self,context);if("normal"===record.type){if(state=context.done?"completed":"suspendedYield",record.arg===ContinueSentinel)continue;return{value:record.arg,done:context.done};}"throw"===record.type&&(state="completed",context.method="throw",context.arg=record.arg);}};}function maybeInvokeDelegate(delegate,context){var methodName=context.method,method=delegate.iterator[methodName];if(undefined===method)return context.delegate=null,"throw"===methodName&&delegate.iterator.return&&(context.method="return",context.arg=undefined,maybeInvokeDelegate(delegate,context),"throw"===context.method)||"return"!==methodName&&(context.method="throw",context.arg=new TypeError("The iterator does not provide a '"+methodName+"' method")),ContinueSentinel;var record=tryCatch(method,delegate.iterator,context.arg);if("throw"===record.type)return context.method="throw",context.arg=record.arg,context.delegate=null,ContinueSentinel;var info=record.arg;return info?info.done?(context[delegate.resultName]=info.value,context.next=delegate.nextLoc,"return"!==context.method&&(context.method="next",context.arg=undefined),context.delegate=null,ContinueSentinel):info:(context.method="throw",context.arg=new TypeError("iterator result is not an object"),context.delegate=null,ContinueSentinel);}function pushTryEntry(locs){var entry={tryLoc:locs[0]};1 in locs&&(entry.catchLoc=locs[1]),2 in locs&&(entry.finallyLoc=locs[2],entry.afterLoc=locs[3]),this.tryEntries.push(entry);}function resetTryEntry(entry){var record=entry.completion||{};record.type="normal",delete record.arg,entry.completion=record;}function Context(tryLocsList){this.tryEntries=[{tryLoc:"root"}],tryLocsList.forEach(pushTryEntry,this),this.reset(!0);}function values(iterable){if(iterable){var iteratorMethod=iterable[iteratorSymbol];if(iteratorMethod)return iteratorMethod.call(iterable);if("function"==typeof iterable.next)return iterable;if(!isNaN(iterable.length)){var i=-1,next=function next(){for(;++i<iterable.length;)if(hasOwn.call(iterable,i))return next.value=iterable[i],next.done=!1,next;return next.value=undefined,next.done=!0,next;};return next.next=next;}}return{next:doneResult};}function doneResult(){return{value:undefined,done:!0};}return GeneratorFunction.prototype=GeneratorFunctionPrototype,defineProperty(Gp,"constructor",{value:GeneratorFunctionPrototype,configurable:!0}),defineProperty(GeneratorFunctionPrototype,"constructor",{value:GeneratorFunction,configurable:!0}),GeneratorFunction.displayName=define(GeneratorFunctionPrototype,toStringTagSymbol,"GeneratorFunction"),exports.isGeneratorFunction=function(genFun){var ctor="function"==typeof genFun&&genFun.constructor;return!!ctor&&(ctor===GeneratorFunction||"GeneratorFunction"===(ctor.displayName||ctor.name));},exports.mark=function(genFun){return Object.setPrototypeOf?Object.setPrototypeOf(genFun,GeneratorFunctionPrototype):(genFun.__proto__=GeneratorFunctionPrototype,define(genFun,toStringTagSymbol,"GeneratorFunction")),genFun.prototype=Object.create(Gp),genFun;},exports.awrap=function(arg){return{__await:arg};},defineIteratorMethods(AsyncIterator.prototype),define(AsyncIterator.prototype,asyncIteratorSymbol,function(){return this;}),exports.AsyncIterator=AsyncIterator,exports.async=function(innerFn,outerFn,self,tryLocsList,PromiseImpl){void 0===PromiseImpl&&(PromiseImpl=Promise);var iter=new AsyncIterator(wrap(innerFn,outerFn,self,tryLocsList),PromiseImpl);return exports.isGeneratorFunction(outerFn)?iter:iter.next().then(function(result){return result.done?result.value:iter.next();});},defineIteratorMethods(Gp),define(Gp,toStringTagSymbol,"Generator"),define(Gp,iteratorSymbol,function(){return this;}),define(Gp,"toString",function(){return"[object Generator]";}),exports.keys=function(val){var object=Object(val),keys=[];for(var key in object)keys.push(key);return keys.reverse(),function next(){for(;keys.length;){var key=keys.pop();if(key in object)return next.value=key,next.done=!1,next;}return next.done=!0,next;};},exports.values=values,Context.prototype={constructor:Context,reset:function reset(skipTempReset){if(this.prev=0,this.next=0,this.sent=this._sent=undefined,this.done=!1,this.delegate=null,this.method="next",this.arg=undefined,this.tryEntries.forEach(resetTryEntry),!skipTempReset)for(var name in this)"t"===name.charAt(0)&&hasOwn.call(this,name)&&!isNaN(+name.slice(1))&&(this[name]=undefined);},stop:function stop(){this.done=!0;var rootRecord=this.tryEntries[0].completion;if("throw"===rootRecord.type)throw rootRecord.arg;return this.rval;},dispatchException:function dispatchException(exception){if(this.done)throw exception;var context=this;function handle(loc,caught){return record.type="throw",record.arg=exception,context.next=loc,caught&&(context.method="next",context.arg=undefined),!!caught;}for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i],record=entry.completion;if("root"===entry.tryLoc)return handle("end");if(entry.tryLoc<=this.prev){var hasCatch=hasOwn.call(entry,"catchLoc"),hasFinally=hasOwn.call(entry,"finallyLoc");if(hasCatch&&hasFinally){if(this.prev<entry.catchLoc)return handle(entry.catchLoc,!0);if(this.prev<entry.finallyLoc)return handle(entry.finallyLoc);}else if(hasCatch){if(this.prev<entry.catchLoc)return handle(entry.catchLoc,!0);}else{if(!hasFinally)throw new Error("try statement without catch or finally");if(this.prev<entry.finallyLoc)return handle(entry.finallyLoc);}}}},abrupt:function abrupt(type,arg){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.tryLoc<=this.prev&&hasOwn.call(entry,"finallyLoc")&&this.prev<entry.finallyLoc){var finallyEntry=entry;break;}}finallyEntry&&("break"===type||"continue"===type)&&finallyEntry.tryLoc<=arg&&arg<=finallyEntry.finallyLoc&&(finallyEntry=null);var record=finallyEntry?finallyEntry.completion:{};return record.type=type,record.arg=arg,finallyEntry?(this.method="next",this.next=finallyEntry.finallyLoc,ContinueSentinel):this.complete(record);},complete:function complete(record,afterLoc){if("throw"===record.type)throw record.arg;return"break"===record.type||"continue"===record.type?this.next=record.arg:"return"===record.type?(this.rval=this.arg=record.arg,this.method="return",this.next="end"):"normal"===record.type&&afterLoc&&(this.next=afterLoc),ContinueSentinel;},finish:function finish(finallyLoc){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.finallyLoc===finallyLoc)return this.complete(entry.completion,entry.afterLoc),resetTryEntry(entry),ContinueSentinel;}},catch:function _catch(tryLoc){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.tryLoc===tryLoc){var record=entry.completion;if("throw"===record.type){var thrown=record.arg;resetTryEntry(entry);}return thrown;}}throw new Error("illegal catch attempt");},delegateYield:function delegateYield(iterable,resultName,nextLoc){return this.delegate={iterator:values(iterable),resultName:resultName,nextLoc:nextLoc},"next"===this.method&&(this.arg=undefined),ContinueSentinel;}},exports;}function asyncGeneratorStep(gen,resolve,reject,_next,_throw,key,arg){try{var info=gen[key](arg);var value=info.value;}catch(error){reject(error);return;}if(info.done){resolve(value);}else{Promise.resolve(value).then(_next,_throw);}}function _asyncToGenerator(fn){return function(){var self=this,args=arguments;return new Promise(function(resolve,reject){var gen=fn.apply(self,args);function _next(value){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"next",value);}function _throw(err){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"throw",err);}_next(undefined);});};}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}}function _createClass(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);Object.defineProperty(Constructor,"prototype",{writable:false});return Constructor;}function _toPropertyKey(arg){var key=_toPrimitive(arg,"string");return _typeof(key)==="symbol"?key:String(key);}function _toPrimitive(input,hint){if(_typeof(input)!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(_typeof(res)!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.");}return(hint==="string"?String:Number)(input);}function parseDocBaseUrl(url){if(url){var absoluteUrl=(0,_util.createValidAbsoluteUrl)(url);if(absoluteUrl){return absoluteUrl.href;}(0,_util.warn)("Invalid absolute docBaseUrl: \"".concat(url,"\"."));}return null;}var BasePdfManager=/*#__PURE__*/function(){function BasePdfManager(args){var _args$evaluatorOption;_classCallCheck(this,BasePdfManager);if(this.constructor===BasePdfManager){(0,_util.unreachable)("Cannot initialize BasePdfManager.");}this._docBaseUrl=parseDocBaseUrl(args.docBaseUrl);this._docId=args.docId;this._password=args.password;this.enableXfa=args.enableXfa;(_args$evaluatorOption=args.evaluatorOptions).isOffscreenCanvasSupported&&(_args$evaluatorOption.isOffscreenCanvasSupported=_util.FeatureTest.isOffscreenCanvasSupported);this.evaluatorOptions=args.evaluatorOptions;}_createClass(BasePdfManager,[{key:"docId",get:function get(){return this._docId;}},{key:"password",get:function get(){return this._password;}},{key:"docBaseUrl",get:function get(){var catalog=this.pdfDocument.catalog;return(0,_util.shadow)(this,"docBaseUrl",catalog.baseUrl||this._docBaseUrl);}},{key:"ensureDoc",value:function ensureDoc(prop,args){return this.ensure(this.pdfDocument,prop,args);}},{key:"ensureXRef",value:function ensureXRef(prop,args){return this.ensure(this.pdfDocument.xref,prop,args);}},{key:"ensureCatalog",value:function ensureCatalog(prop,args){return this.ensure(this.pdfDocument.catalog,prop,args);}},{key:"getPage",value:function getPage(pageIndex){return this.pdfDocument.getPage(pageIndex);}},{key:"fontFallback",value:function fontFallback(id,handler){return this.pdfDocument.fontFallback(id,handler);}},{key:"loadXfaFonts",value:function loadXfaFonts(handler,task){return this.pdfDocument.loadXfaFonts(handler,task);}},{key:"loadXfaImages",value:function loadXfaImages(){return this.pdfDocument.loadXfaImages();}},{key:"serializeXfaData",value:function serializeXfaData(annotationStorage){return this.pdfDocument.serializeXfaData(annotationStorage);}},{key:"cleanup",value:function cleanup(){var manuallyTriggered=arguments.length>0&&arguments[0]!==undefined?arguments[0]:false;return this.pdfDocument.cleanup(manuallyTriggered);}},{key:"ensure",value:function(){var _ensure=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee(obj,prop,args){return _regeneratorRuntime().wrap(function _callee$(_context){while(1)switch(_context.prev=_context.next){case 0:(0,_util.unreachable)("Abstract method `ensure` called");case 1:case"end":return _context.stop();}},_callee);}));function ensure(_x,_x2,_x3){return _ensure.apply(this,arguments);}return ensure;}()},{key:"requestRange",value:function requestRange(begin,end){(0,_util.unreachable)("Abstract method `requestRange` called");}},{key:"requestLoadedStream",value:function requestLoadedStream(){var noFetch=arguments.length>0&&arguments[0]!==undefined?arguments[0]:false;(0,_util.unreachable)("Abstract method `requestLoadedStream` called");}},{key:"sendProgressiveData",value:function sendProgressiveData(chunk){(0,_util.unreachable)("Abstract method `sendProgressiveData` called");}},{key:"updatePassword",value:function updatePassword(password){this._password=password;}},{key:"terminate",value:function terminate(reason){(0,_util.unreachable)("Abstract method `terminate` called");}}]);return BasePdfManager;}();var LocalPdfManager=/*#__PURE__*/function(_BasePdfManager){_inherits(LocalPdfManager,_BasePdfManager);var _super=_createSuper(LocalPdfManager);function LocalPdfManager(args){var _this;_classCallCheck(this,LocalPdfManager);_this=_super.call(this,args);var stream=new _stream.Stream(args.source);_this.pdfDocument=new _document.PDFDocument(_assertThisInitialized(_this),stream);_this._loadedStreamPromise=Promise.resolve(stream);return _this;}_createClass(LocalPdfManager,[{key:"ensure",value:function(){var _ensure2=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee2(obj,prop,args){var value;return _regeneratorRuntime().wrap(function _callee2$(_context2){while(1)switch(_context2.prev=_context2.next){case 0:value=obj[prop];if(!(typeof value==="function")){_context2.next=3;break;}return _context2.abrupt("return",value.apply(obj,args));case 3:return _context2.abrupt("return",value);case 4:case"end":return _context2.stop();}},_callee2);}));function ensure(_x4,_x5,_x6){return _ensure2.apply(this,arguments);}return ensure;}()},{key:"requestRange",value:function requestRange(begin,end){return Promise.resolve();}},{key:"requestLoadedStream",value:function requestLoadedStream(){var noFetch=arguments.length>0&&arguments[0]!==undefined?arguments[0]:false;return this._loadedStreamPromise;}},{key:"terminate",value:function terminate(reason){}}]);return LocalPdfManager;}(BasePdfManager);exports.LocalPdfManager=LocalPdfManager;var NetworkPdfManager=/*#__PURE__*/function(_BasePdfManager2){_inherits(NetworkPdfManager,_BasePdfManager2);var _super2=_createSuper(NetworkPdfManager);function NetworkPdfManager(args){var _this2;_classCallCheck(this,NetworkPdfManager);_this2=_super2.call(this,args);_this2.streamManager=new _chunked_stream.ChunkedStreamManager(args.source,{msgHandler:args.handler,length:args.length,disableAutoFetch:args.disableAutoFetch,rangeChunkSize:args.rangeChunkSize});_this2.pdfDocument=new _document.PDFDocument(_assertThisInitialized(_this2),_this2.streamManager.getStream());return _this2;}_createClass(NetworkPdfManager,[{key:"ensure",value:function(){var _ensure3=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee3(obj,prop,args){var value;return _regeneratorRuntime().wrap(function _callee3$(_context3){while(1)switch(_context3.prev=_context3.next){case 0:_context3.prev=0;value=obj[prop];if(!(typeof value==="function")){_context3.next=4;break;}return _context3.abrupt("return",value.apply(obj,args));case 4:return _context3.abrupt("return",value);case 7:_context3.prev=7;_context3.t0=_context3["catch"](0);if(_context3.t0 instanceof _core_utils.MissingDataException){_context3.next=11;break;}throw _context3.t0;case 11:_context3.next=13;return this.requestRange(_context3.t0.begin,_context3.t0.end);case 13:return _context3.abrupt("return",this.ensure(obj,prop,args));case 14:case"end":return _context3.stop();}},_callee3,this,[[0,7]]);}));function ensure(_x7,_x8,_x9){return _ensure3.apply(this,arguments);}return ensure;}()},{key:"requestRange",value:function requestRange(begin,end){return this.streamManager.requestRange(begin,end);}},{key:"requestLoadedStream",value:function requestLoadedStream(){var noFetch=arguments.length>0&&arguments[0]!==undefined?arguments[0]:false;return this.streamManager.requestAllChunks(noFetch);}},{key:"sendProgressiveData",value:function sendProgressiveData(chunk){this.streamManager.onReceiveData({chunk:chunk});}},{key:"terminate",value:function terminate(reason){this.streamManager.abort(reason);}}]);return NetworkPdfManager;}(BasePdfManager);exports.NetworkPdfManager=NetworkPdfManager;

/***/ }),
/* 355 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

function _typeof(obj){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj;}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;},_typeof(obj);}__w_pdfjs_require__(304);__w_pdfjs_require__(305);__w_pdfjs_require__(2);__w_pdfjs_require__(54);__w_pdfjs_require__(56);__w_pdfjs_require__(104);__w_pdfjs_require__(295);__w_pdfjs_require__(292);__w_pdfjs_require__(114);__w_pdfjs_require__(123);__w_pdfjs_require__(129);__w_pdfjs_require__(113);Object.defineProperty(exports, "__esModule", ({value:true}));exports.ChunkedStreamManager=exports.ChunkedStream=void 0;__w_pdfjs_require__(137);__w_pdfjs_require__(143);__w_pdfjs_require__(191);__w_pdfjs_require__(208);__w_pdfjs_require__(209);__w_pdfjs_require__(212);__w_pdfjs_require__(213);__w_pdfjs_require__(214);__w_pdfjs_require__(218);__w_pdfjs_require__(219);__w_pdfjs_require__(220);__w_pdfjs_require__(222);__w_pdfjs_require__(223);__w_pdfjs_require__(224);__w_pdfjs_require__(225);__w_pdfjs_require__(226);__w_pdfjs_require__(227);__w_pdfjs_require__(228);__w_pdfjs_require__(231);__w_pdfjs_require__(232);__w_pdfjs_require__(234);__w_pdfjs_require__(235);__w_pdfjs_require__(236);__w_pdfjs_require__(237);__w_pdfjs_require__(238);__w_pdfjs_require__(239);__w_pdfjs_require__(244);__w_pdfjs_require__(245);__w_pdfjs_require__(247);__w_pdfjs_require__(248);__w_pdfjs_require__(249);__w_pdfjs_require__(251);__w_pdfjs_require__(254);__w_pdfjs_require__(257);__w_pdfjs_require__(258);__w_pdfjs_require__(175);__w_pdfjs_require__(266);__w_pdfjs_require__(277);__w_pdfjs_require__(279);__w_pdfjs_require__(281);__w_pdfjs_require__(283);__w_pdfjs_require__(285);__w_pdfjs_require__(287);__w_pdfjs_require__(177);__w_pdfjs_require__(289);__w_pdfjs_require__(183);__w_pdfjs_require__(134);__w_pdfjs_require__(334);__w_pdfjs_require__(145);__w_pdfjs_require__(356);__w_pdfjs_require__(328);__w_pdfjs_require__(105);var _core_utils=__w_pdfjs_require__(342);var _util=__w_pdfjs_require__(303);var _stream=__w_pdfjs_require__(357);function _createForOfIteratorHelper(o,allowArrayLike){var it=typeof Symbol!=="undefined"&&o[Symbol.iterator]||o["@@iterator"];if(!it){if(Array.isArray(o)||(it=_unsupportedIterableToArray(o))||allowArrayLike&&o&&typeof o.length==="number"){if(it)o=it;var i=0;var F=function F(){};return{s:F,n:function n(){if(i>=o.length)return{done:true};return{done:false,value:o[i++]};},e:function e(_e){throw _e;},f:F};}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}var normalCompletion=true,didErr=false,err;return{s:function s(){it=it.call(o);},n:function n(){var step=it.next();normalCompletion=step.done;return step;},e:function e(_e2){didErr=true;err=_e2;},f:function f(){try{if(!normalCompletion&&it.return!=null)it.return();}finally{if(didErr)throw err;}}};}function _unsupportedIterableToArray(o,minLen){if(!o)return;if(typeof o==="string")return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);if(n==="Object"&&o.constructor)n=o.constructor.name;if(n==="Map"||n==="Set")return Array.from(o);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return _arrayLikeToArray(o,minLen);}function _arrayLikeToArray(arr,len){if(len==null||len>arr.length)len=arr.length;for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2;}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}}function _createClass(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);Object.defineProperty(Constructor,"prototype",{writable:false});return Constructor;}function _toPropertyKey(arg){var key=_toPrimitive(arg,"string");return _typeof(key)==="symbol"?key:String(key);}function _toPrimitive(input,hint){if(_typeof(input)!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(_typeof(res)!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.");}return(hint==="string"?String:Number)(input);}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function");}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:true,configurable:true}});Object.defineProperty(subClass,"prototype",{writable:false});if(superClass)_setPrototypeOf(subClass,superClass);}function _setPrototypeOf(o,p){_setPrototypeOf=Object.setPrototypeOf?Object.setPrototypeOf.bind():function _setPrototypeOf(o,p){o.__proto__=p;return o;};return _setPrototypeOf(o,p);}function _createSuper(Derived){var hasNativeReflectConstruct=_isNativeReflectConstruct();return function _createSuperInternal(){var Super=_getPrototypeOf(Derived),result;if(hasNativeReflectConstruct){var NewTarget=_getPrototypeOf(this).constructor;result=Reflect.construct(Super,arguments,NewTarget);}else{result=Super.apply(this,arguments);}return _possibleConstructorReturn(this,result);};}function _possibleConstructorReturn(self,call){if(call&&(_typeof(call)==="object"||typeof call==="function")){return call;}else if(call!==void 0){throw new TypeError("Derived constructors may only return object or undefined");}return _assertThisInitialized(self);}function _assertThisInitialized(self){if(self===void 0){throw new ReferenceError("this hasn't been initialised - super() hasn't been called");}return self;}function _isNativeReflectConstruct(){if(typeof Reflect==="undefined"||!Reflect.construct)return false;if(Reflect.construct.sham)return false;if(typeof Proxy==="function")return true;try{Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}));return true;}catch(e){return false;}}function _getPrototypeOf(o){_getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf.bind():function _getPrototypeOf(o){return o.__proto__||Object.getPrototypeOf(o);};return _getPrototypeOf(o);}var ChunkedStream=/*#__PURE__*/function(_Stream){_inherits(ChunkedStream,_Stream);var _super=_createSuper(ChunkedStream);function ChunkedStream(length,chunkSize,manager){var _this;_classCallCheck(this,ChunkedStream);_this=_super.call(this,new Uint8Array(length),0,length,null);_this.chunkSize=chunkSize;_this._loadedChunks=new Set();_this.numChunks=Math.ceil(length/chunkSize);_this.manager=manager;_this.progressiveDataLength=0;_this.lastSuccessfulEnsureByteChunk=-1;return _this;}_createClass(ChunkedStream,[{key:"getMissingChunks",value:function getMissingChunks(){var chunks=[];for(var chunk=0,n=this.numChunks;chunk<n;++chunk){if(!this._loadedChunks.has(chunk)){chunks.push(chunk);}}return chunks;}},{key:"numChunksLoaded",get:function get(){return this._loadedChunks.size;}},{key:"isDataLoaded",get:function get(){return this.numChunksLoaded===this.numChunks;}},{key:"onReceiveData",value:function onReceiveData(begin,chunk){var chunkSize=this.chunkSize;if(begin%chunkSize!==0){throw new Error("Bad begin offset: ".concat(begin));}var end=begin+chunk.byteLength;if(end%chunkSize!==0&&end!==this.bytes.length){throw new Error("Bad end offset: ".concat(end));}this.bytes.set(new Uint8Array(chunk),begin);var beginChunk=Math.floor(begin/chunkSize);var endChunk=Math.floor((end-1)/chunkSize)+1;for(var curChunk=beginChunk;curChunk<endChunk;++curChunk){this._loadedChunks.add(curChunk);}}},{key:"onReceiveProgressiveData",value:function onReceiveProgressiveData(data){var position=this.progressiveDataLength;var beginChunk=Math.floor(position/this.chunkSize);this.bytes.set(new Uint8Array(data),position);position+=data.byteLength;this.progressiveDataLength=position;var endChunk=position>=this.end?this.numChunks:Math.floor(position/this.chunkSize);for(var curChunk=beginChunk;curChunk<endChunk;++curChunk){this._loadedChunks.add(curChunk);}}},{key:"ensureByte",value:function ensureByte(pos){if(pos<this.progressiveDataLength){return;}var chunk=Math.floor(pos/this.chunkSize);if(chunk>this.numChunks){return;}if(chunk===this.lastSuccessfulEnsureByteChunk){return;}if(!this._loadedChunks.has(chunk)){throw new _core_utils.MissingDataException(pos,pos+1);}this.lastSuccessfulEnsureByteChunk=chunk;}},{key:"ensureRange",value:function ensureRange(begin,end){if(begin>=end){return;}if(end<=this.progressiveDataLength){return;}var beginChunk=Math.floor(begin/this.chunkSize);if(beginChunk>this.numChunks){return;}var endChunk=Math.min(Math.floor((end-1)/this.chunkSize)+1,this.numChunks);for(var chunk=beginChunk;chunk<endChunk;++chunk){if(!this._loadedChunks.has(chunk)){throw new _core_utils.MissingDataException(begin,end);}}}},{key:"nextEmptyChunk",value:function nextEmptyChunk(beginChunk){var numChunks=this.numChunks;for(var i=0;i<numChunks;++i){var chunk=(beginChunk+i)%numChunks;if(!this._loadedChunks.has(chunk)){return chunk;}}return null;}},{key:"hasChunk",value:function hasChunk(chunk){return this._loadedChunks.has(chunk);}},{key:"getByte",value:function getByte(){var pos=this.pos;if(pos>=this.end){return-1;}if(pos>=this.progressiveDataLength){this.ensureByte(pos);}return this.bytes[this.pos++];}},{key:"getBytes",value:function getBytes(length){var bytes=this.bytes;var pos=this.pos;var strEnd=this.end;if(!length){if(strEnd>this.progressiveDataLength){this.ensureRange(pos,strEnd);}return bytes.subarray(pos,strEnd);}var end=pos+length;if(end>strEnd){end=strEnd;}if(end>this.progressiveDataLength){this.ensureRange(pos,end);}this.pos=end;return bytes.subarray(pos,end);}},{key:"getByteRange",value:function getByteRange(begin,end){if(begin<0){begin=0;}if(end>this.end){end=this.end;}if(end>this.progressiveDataLength){this.ensureRange(begin,end);}return this.bytes.subarray(begin,end);}},{key:"makeSubStream",value:function makeSubStream(start,length){var dict=arguments.length>2&&arguments[2]!==undefined?arguments[2]:null;if(length){if(start+length>this.progressiveDataLength){this.ensureRange(start,start+length);}}else if(start>=this.progressiveDataLength){this.ensureByte(start);}function ChunkedStreamSubstream(){}ChunkedStreamSubstream.prototype=Object.create(this);ChunkedStreamSubstream.prototype.getMissingChunks=function(){var chunkSize=this.chunkSize;var beginChunk=Math.floor(this.start/chunkSize);var endChunk=Math.floor((this.end-1)/chunkSize)+1;var missingChunks=[];for(var chunk=beginChunk;chunk<endChunk;++chunk){if(!this._loadedChunks.has(chunk)){missingChunks.push(chunk);}}return missingChunks;};Object.defineProperty(ChunkedStreamSubstream.prototype,"isDataLoaded",{get:function get(){if(this.numChunksLoaded===this.numChunks){return true;}return this.getMissingChunks().length===0;},configurable:true});var subStream=new ChunkedStreamSubstream();subStream.pos=subStream.start=start;subStream.end=start+length||this.end;subStream.dict=dict;return subStream;}},{key:"getBaseStreams",value:function getBaseStreams(){return[this];}}]);return ChunkedStream;}(_stream.Stream);exports.ChunkedStream=ChunkedStream;var ChunkedStreamManager=/*#__PURE__*/function(){function ChunkedStreamManager(pdfNetworkStream,args){_classCallCheck(this,ChunkedStreamManager);this.length=args.length;this.chunkSize=args.rangeChunkSize;this.stream=new ChunkedStream(this.length,this.chunkSize,this);this.pdfNetworkStream=pdfNetworkStream;this.disableAutoFetch=args.disableAutoFetch;this.msgHandler=args.msgHandler;this.currRequestId=0;this._chunksNeededByRequest=new Map();this._requestsByChunk=new Map();this._promisesByRequest=new Map();this.progressiveDataLength=0;this.aborted=false;this._loadedStreamCapability=new _util.PromiseCapability();}_createClass(ChunkedStreamManager,[{key:"sendRequest",value:function sendRequest(begin,end){var _this2=this;var rangeReader=this.pdfNetworkStream.getRangeReader(begin,end);if(!rangeReader.isStreamingSupported){rangeReader.onProgress=this.onProgress.bind(this);}var chunks=[],loaded=0;return new Promise(function(resolve,reject){var readChunk=function readChunk(_ref){var value=_ref.value,done=_ref.done;try{if(done){var chunkData=(0,_core_utils.arrayBuffersToBytes)(chunks);chunks=null;resolve(chunkData);return;}loaded+=value.byteLength;if(rangeReader.isStreamingSupported){_this2.onProgress({loaded:loaded});}chunks.push(value);rangeReader.read().then(readChunk,reject);}catch(e){reject(e);}};rangeReader.read().then(readChunk,reject);}).then(function(data){if(_this2.aborted){return;}_this2.onReceiveData({chunk:data,begin:begin});});}},{key:"requestAllChunks",value:function requestAllChunks(){var noFetch=arguments.length>0&&arguments[0]!==undefined?arguments[0]:false;if(!noFetch){var missingChunks=this.stream.getMissingChunks();this._requestChunks(missingChunks);}return this._loadedStreamCapability.promise;}},{key:"_requestChunks",value:function _requestChunks(chunks){var _this3=this;var requestId=this.currRequestId++;var chunksNeeded=new Set();this._chunksNeededByRequest.set(requestId,chunksNeeded);var _iterator=_createForOfIteratorHelper(chunks),_step;try{for(_iterator.s();!(_step=_iterator.n()).done;){var chunk=_step.value;if(!this.stream.hasChunk(chunk)){chunksNeeded.add(chunk);}}}catch(err){_iterator.e(err);}finally{_iterator.f();}if(chunksNeeded.size===0){return Promise.resolve();}var capability=new _util.PromiseCapability();this._promisesByRequest.set(requestId,capability);var chunksToRequest=[];var _iterator2=_createForOfIteratorHelper(chunksNeeded),_step2;try{for(_iterator2.s();!(_step2=_iterator2.n()).done;){var _chunk=_step2.value;var requestIds=this._requestsByChunk.get(_chunk);if(!requestIds){requestIds=[];this._requestsByChunk.set(_chunk,requestIds);chunksToRequest.push(_chunk);}requestIds.push(requestId);}}catch(err){_iterator2.e(err);}finally{_iterator2.f();}if(chunksToRequest.length>0){var groupedChunksToRequest=this.groupChunks(chunksToRequest);var _iterator3=_createForOfIteratorHelper(groupedChunksToRequest),_step3;try{for(_iterator3.s();!(_step3=_iterator3.n()).done;){var groupedChunk=_step3.value;var begin=groupedChunk.beginChunk*this.chunkSize;var end=Math.min(groupedChunk.endChunk*this.chunkSize,this.length);this.sendRequest(begin,end).catch(capability.reject);}}catch(err){_iterator3.e(err);}finally{_iterator3.f();}}return capability.promise.catch(function(reason){if(_this3.aborted){return;}throw reason;});}},{key:"getStream",value:function getStream(){return this.stream;}},{key:"requestRange",value:function requestRange(begin,end){end=Math.min(end,this.length);var beginChunk=this.getBeginChunk(begin);var endChunk=this.getEndChunk(end);var chunks=[];for(var chunk=beginChunk;chunk<endChunk;++chunk){chunks.push(chunk);}return this._requestChunks(chunks);}},{key:"requestRanges",value:function requestRanges(){var ranges=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];var chunksToRequest=[];var _iterator4=_createForOfIteratorHelper(ranges),_step4;try{for(_iterator4.s();!(_step4=_iterator4.n()).done;){var range=_step4.value;var beginChunk=this.getBeginChunk(range.begin);var endChunk=this.getEndChunk(range.end);for(var chunk=beginChunk;chunk<endChunk;++chunk){if(!chunksToRequest.includes(chunk)){chunksToRequest.push(chunk);}}}}catch(err){_iterator4.e(err);}finally{_iterator4.f();}chunksToRequest.sort(function(a,b){return a-b;});return this._requestChunks(chunksToRequest);}},{key:"groupChunks",value:function groupChunks(chunks){var groupedChunks=[];var beginChunk=-1;var prevChunk=-1;for(var i=0,ii=chunks.length;i<ii;++i){var chunk=chunks[i];if(beginChunk<0){beginChunk=chunk;}if(prevChunk>=0&&prevChunk+1!==chunk){groupedChunks.push({beginChunk:beginChunk,endChunk:prevChunk+1});beginChunk=chunk;}if(i+1===chunks.length){groupedChunks.push({beginChunk:beginChunk,endChunk:chunk+1});}prevChunk=chunk;}return groupedChunks;}},{key:"onProgress",value:function onProgress(args){this.msgHandler.send("DocProgress",{loaded:this.stream.numChunksLoaded*this.chunkSize+args.loaded,total:this.length});}},{key:"onReceiveData",value:function onReceiveData(args){var chunk=args.chunk;var isProgressive=args.begin===undefined;var begin=isProgressive?this.progressiveDataLength:args.begin;var end=begin+chunk.byteLength;var beginChunk=Math.floor(begin/this.chunkSize);var endChunk=end<this.length?Math.floor(end/this.chunkSize):Math.ceil(end/this.chunkSize);if(isProgressive){this.stream.onReceiveProgressiveData(chunk);this.progressiveDataLength=end;}else{this.stream.onReceiveData(begin,chunk);}if(this.stream.isDataLoaded){this._loadedStreamCapability.resolve(this.stream);}var loadedRequests=[];for(var curChunk=beginChunk;curChunk<endChunk;++curChunk){var requestIds=this._requestsByChunk.get(curChunk);if(!requestIds){continue;}this._requestsByChunk.delete(curChunk);var _iterator5=_createForOfIteratorHelper(requestIds),_step5;try{for(_iterator5.s();!(_step5=_iterator5.n()).done;){var requestId=_step5.value;var chunksNeeded=this._chunksNeededByRequest.get(requestId);if(chunksNeeded.has(curChunk)){chunksNeeded.delete(curChunk);}if(chunksNeeded.size>0){continue;}loadedRequests.push(requestId);}}catch(err){_iterator5.e(err);}finally{_iterator5.f();}}if(!this.disableAutoFetch&&this._requestsByChunk.size===0){var nextEmptyChunk;if(this.stream.numChunksLoaded===1){var lastChunk=this.stream.numChunks-1;if(!this.stream.hasChunk(lastChunk)){nextEmptyChunk=lastChunk;}}else{nextEmptyChunk=this.stream.nextEmptyChunk(endChunk);}if(Number.isInteger(nextEmptyChunk)){this._requestChunks([nextEmptyChunk]);}}for(var _i=0,_loadedRequests=loadedRequests;_i<_loadedRequests.length;_i++){var _requestId=_loadedRequests[_i];var capability=this._promisesByRequest.get(_requestId);this._promisesByRequest.delete(_requestId);capability.resolve();}this.msgHandler.send("DocProgress",{loaded:this.stream.numChunksLoaded*this.chunkSize,total:this.length});}},{key:"onError",value:function onError(err){this._loadedStreamCapability.reject(err);}},{key:"getBeginChunk",value:function getBeginChunk(begin){return Math.floor(begin/this.chunkSize);}},{key:"getEndChunk",value:function getEndChunk(end){return Math.floor((end-1)/this.chunkSize)+1;}},{key:"abort",value:function abort(reason){var _this$pdfNetworkStrea;this.aborted=true;(_this$pdfNetworkStrea=this.pdfNetworkStream)===null||_this$pdfNetworkStrea===void 0?void 0:_this$pdfNetworkStrea.cancelAllRequests(reason);var _iterator6=_createForOfIteratorHelper(this._promisesByRequest.values()),_step6;try{for(_iterator6.s();!(_step6=_iterator6.n()).done;){var capability=_step6.value;capability.reject(reason);}}catch(err){_iterator6.e(err);}finally{_iterator6.f();}}}]);return ChunkedStreamManager;}();exports.ChunkedStreamManager=ChunkedStreamManager;

/***/ }),
/* 356 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var uncurryThis = __w_pdfjs_require__(7);
var aCallable = __w_pdfjs_require__(40);
var toObject = __w_pdfjs_require__(10);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var deletePropertyOrThrow = __w_pdfjs_require__(211);
var toString = __w_pdfjs_require__(77);
var fails = __w_pdfjs_require__(9);
var internalSort = __w_pdfjs_require__(240);
var arrayMethodIsStrict = __w_pdfjs_require__(230);
var FF = __w_pdfjs_require__(241);
var IE_OR_EDGE = __w_pdfjs_require__(242);
var V8 = __w_pdfjs_require__(21);
var WEBKIT = __w_pdfjs_require__(243);
var test = [];
var nativeSort = uncurryThis(test.sort);
var push = uncurryThis(test.push);
var FAILS_ON_UNDEFINED = fails(function () {
 test.sort(undefined);
});
var FAILS_ON_NULL = fails(function () {
 test.sort(null);
});
var STRICT_METHOD = arrayMethodIsStrict('sort');
var STABLE_SORT = !fails(function () {
 if (V8)
  return V8 < 70;
 if (FF && FF > 3)
  return;
 if (IE_OR_EDGE)
  return true;
 if (WEBKIT)
  return WEBKIT < 603;
 var result = '';
 var code, chr, value, index;
 for (code = 65; code < 76; code++) {
  chr = String.fromCharCode(code);
  switch (code) {
  case 66:
  case 69:
  case 70:
  case 72:
   value = 3;
   break;
  case 68:
  case 71:
   value = 4;
   break;
  default:
   value = 2;
  }
  for (index = 0; index < 47; index++) {
   test.push({
    k: chr + index,
    v: value
   });
  }
 }
 test.sort(function (a, b) {
  return b.v - a.v;
 });
 for (index = 0; index < test.length; index++) {
  chr = test[index].k.charAt(0);
  if (result.charAt(result.length - 1) !== chr)
   result += chr;
 }
 return result !== 'DGBEFHACIJK';
});
var FORCED = FAILS_ON_UNDEFINED || !FAILS_ON_NULL || !STRICT_METHOD || !STABLE_SORT;
var getSortCompare = function (comparefn) {
 return function (x, y) {
  if (y === undefined)
   return -1;
  if (x === undefined)
   return 1;
  if (comparefn !== undefined)
   return +comparefn(x, y) || 0;
  return toString(x) > toString(y) ? 1 : -1;
 };
};
$({
 target: 'Array',
 proto: true,
 forced: FORCED
}, {
 sort: function sort(comparefn) {
  if (comparefn !== undefined)
   aCallable(comparefn);
  var array = toObject(this);
  if (STABLE_SORT)
   return comparefn === undefined ? nativeSort(array) : nativeSort(array, comparefn);
  var items = [];
  var arrayLength = lengthOfArrayLike(array);
  var itemsLength, index;
  for (index = 0; index < arrayLength; index++) {
   if (index in array)
    push(items, array[index]);
  }
  internalSort(items, getSortCompare(comparefn));
  itemsLength = lengthOfArrayLike(items);
  index = 0;
  while (index < itemsLength)
   array[index] = items[index++];
  while (index < arrayLength)
   deletePropertyOrThrow(array, index++);
  return array;
 }
});

/***/ }),
/* 357 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

function _typeof(obj){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj;}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;},_typeof(obj);}__w_pdfjs_require__(304);__w_pdfjs_require__(305);__w_pdfjs_require__(183);__w_pdfjs_require__(2);__w_pdfjs_require__(54);__w_pdfjs_require__(56);__w_pdfjs_require__(104);__w_pdfjs_require__(105);__w_pdfjs_require__(113);__w_pdfjs_require__(175);__w_pdfjs_require__(177);Object.defineProperty(exports, "__esModule", ({value:true}));exports.StringStream=exports.Stream=exports.NullStream=void 0;__w_pdfjs_require__(137);__w_pdfjs_require__(143);__w_pdfjs_require__(191);__w_pdfjs_require__(208);__w_pdfjs_require__(209);__w_pdfjs_require__(212);__w_pdfjs_require__(213);__w_pdfjs_require__(214);__w_pdfjs_require__(218);__w_pdfjs_require__(219);__w_pdfjs_require__(220);__w_pdfjs_require__(222);__w_pdfjs_require__(223);__w_pdfjs_require__(224);__w_pdfjs_require__(225);__w_pdfjs_require__(226);__w_pdfjs_require__(227);__w_pdfjs_require__(228);__w_pdfjs_require__(231);__w_pdfjs_require__(232);__w_pdfjs_require__(234);__w_pdfjs_require__(235);__w_pdfjs_require__(236);__w_pdfjs_require__(237);__w_pdfjs_require__(238);__w_pdfjs_require__(239);__w_pdfjs_require__(244);__w_pdfjs_require__(245);__w_pdfjs_require__(247);__w_pdfjs_require__(248);__w_pdfjs_require__(249);__w_pdfjs_require__(251);__w_pdfjs_require__(254);__w_pdfjs_require__(257);__w_pdfjs_require__(134);var _base_stream=__w_pdfjs_require__(353);var _util=__w_pdfjs_require__(303);function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}}function _createClass(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);Object.defineProperty(Constructor,"prototype",{writable:false});return Constructor;}function _toPropertyKey(arg){var key=_toPrimitive(arg,"string");return _typeof(key)==="symbol"?key:String(key);}function _toPrimitive(input,hint){if(_typeof(input)!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(_typeof(res)!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.");}return(hint==="string"?String:Number)(input);}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function");}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:true,configurable:true}});Object.defineProperty(subClass,"prototype",{writable:false});if(superClass)_setPrototypeOf(subClass,superClass);}function _setPrototypeOf(o,p){_setPrototypeOf=Object.setPrototypeOf?Object.setPrototypeOf.bind():function _setPrototypeOf(o,p){o.__proto__=p;return o;};return _setPrototypeOf(o,p);}function _createSuper(Derived){var hasNativeReflectConstruct=_isNativeReflectConstruct();return function _createSuperInternal(){var Super=_getPrototypeOf(Derived),result;if(hasNativeReflectConstruct){var NewTarget=_getPrototypeOf(this).constructor;result=Reflect.construct(Super,arguments,NewTarget);}else{result=Super.apply(this,arguments);}return _possibleConstructorReturn(this,result);};}function _possibleConstructorReturn(self,call){if(call&&(_typeof(call)==="object"||typeof call==="function")){return call;}else if(call!==void 0){throw new TypeError("Derived constructors may only return object or undefined");}return _assertThisInitialized(self);}function _assertThisInitialized(self){if(self===void 0){throw new ReferenceError("this hasn't been initialised - super() hasn't been called");}return self;}function _isNativeReflectConstruct(){if(typeof Reflect==="undefined"||!Reflect.construct)return false;if(Reflect.construct.sham)return false;if(typeof Proxy==="function")return true;try{Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}));return true;}catch(e){return false;}}function _getPrototypeOf(o){_getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf.bind():function _getPrototypeOf(o){return o.__proto__||Object.getPrototypeOf(o);};return _getPrototypeOf(o);}var Stream=/*#__PURE__*/function(_BaseStream){_inherits(Stream,_BaseStream);var _super=_createSuper(Stream);function Stream(arrayBuffer,start,length,dict){var _this;_classCallCheck(this,Stream);_this=_super.call(this);_this.bytes=arrayBuffer instanceof Uint8Array?arrayBuffer:new Uint8Array(arrayBuffer);_this.start=start||0;_this.pos=_this.start;_this.end=start+length||_this.bytes.length;_this.dict=dict;return _this;}_createClass(Stream,[{key:"length",get:function get(){return this.end-this.start;}},{key:"isEmpty",get:function get(){return this.length===0;}},{key:"getByte",value:function getByte(){if(this.pos>=this.end){return-1;}return this.bytes[this.pos++];}},{key:"getBytes",value:function getBytes(length){var bytes=this.bytes;var pos=this.pos;var strEnd=this.end;if(!length){return bytes.subarray(pos,strEnd);}var end=pos+length;if(end>strEnd){end=strEnd;}this.pos=end;return bytes.subarray(pos,end);}},{key:"getByteRange",value:function getByteRange(begin,end){if(begin<0){begin=0;}if(end>this.end){end=this.end;}return this.bytes.subarray(begin,end);}},{key:"reset",value:function reset(){this.pos=this.start;}},{key:"moveStart",value:function moveStart(){this.start=this.pos;}},{key:"makeSubStream",value:function makeSubStream(start,length){var dict=arguments.length>2&&arguments[2]!==undefined?arguments[2]:null;return new Stream(this.bytes.buffer,start,length,dict);}}]);return Stream;}(_base_stream.BaseStream);exports.Stream=Stream;var StringStream=/*#__PURE__*/function(_Stream){_inherits(StringStream,_Stream);var _super2=_createSuper(StringStream);function StringStream(str){_classCallCheck(this,StringStream);return _super2.call(this,(0,_util.stringToBytes)(str));}return _createClass(StringStream);}(Stream);exports.StringStream=StringStream;var NullStream=/*#__PURE__*/function(_Stream2){_inherits(NullStream,_Stream2);var _super3=_createSuper(NullStream);function NullStream(){_classCallCheck(this,NullStream);return _super3.call(this,new Uint8Array(0));}return _createClass(NullStream);}(Stream);exports.NullStream=NullStream;

/***/ }),
/* 358 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

__w_pdfjs_require__(2);__w_pdfjs_require__(54);__w_pdfjs_require__(56);__w_pdfjs_require__(104);__w_pdfjs_require__(134);__w_pdfjs_require__(304);__w_pdfjs_require__(305);__w_pdfjs_require__(114);__w_pdfjs_require__(113);__w_pdfjs_require__(130);__w_pdfjs_require__(131);__w_pdfjs_require__(132);__w_pdfjs_require__(133);Object.defineProperty(exports, "__esModule", ({value:true}));exports.Page=exports.PDFDocument=void 0;__w_pdfjs_require__(301);__w_pdfjs_require__(143);__w_pdfjs_require__(292);__w_pdfjs_require__(183);__w_pdfjs_require__(182);__w_pdfjs_require__(289);__w_pdfjs_require__(137);__w_pdfjs_require__(145);__w_pdfjs_require__(175);__w_pdfjs_require__(177);__w_pdfjs_require__(258);__w_pdfjs_require__(266);__w_pdfjs_require__(277);__w_pdfjs_require__(279);__w_pdfjs_require__(281);__w_pdfjs_require__(283);__w_pdfjs_require__(285);__w_pdfjs_require__(287);__w_pdfjs_require__(295);__w_pdfjs_require__(308);__w_pdfjs_require__(359);__w_pdfjs_require__(360);__w_pdfjs_require__(191);__w_pdfjs_require__(208);__w_pdfjs_require__(209);__w_pdfjs_require__(212);__w_pdfjs_require__(213);__w_pdfjs_require__(214);__w_pdfjs_require__(218);__w_pdfjs_require__(219);__w_pdfjs_require__(220);__w_pdfjs_require__(222);__w_pdfjs_require__(223);__w_pdfjs_require__(224);__w_pdfjs_require__(225);__w_pdfjs_require__(226);__w_pdfjs_require__(227);__w_pdfjs_require__(228);__w_pdfjs_require__(231);__w_pdfjs_require__(232);__w_pdfjs_require__(234);__w_pdfjs_require__(235);__w_pdfjs_require__(236);__w_pdfjs_require__(237);__w_pdfjs_require__(238);__w_pdfjs_require__(239);__w_pdfjs_require__(244);__w_pdfjs_require__(245);__w_pdfjs_require__(247);__w_pdfjs_require__(248);__w_pdfjs_require__(249);__w_pdfjs_require__(251);__w_pdfjs_require__(254);__w_pdfjs_require__(257);__w_pdfjs_require__(334);__w_pdfjs_require__(123);__w_pdfjs_require__(129);__w_pdfjs_require__(352);__w_pdfjs_require__(361);__w_pdfjs_require__(362);__w_pdfjs_require__(299);__w_pdfjs_require__(336);__w_pdfjs_require__(338);__w_pdfjs_require__(363);__w_pdfjs_require__(330);__w_pdfjs_require__(105);__w_pdfjs_require__(350);__w_pdfjs_require__(364);var _util=__w_pdfjs_require__(303);var _annotation2=__w_pdfjs_require__(366);var _core_utils=__w_pdfjs_require__(342);var _primitives=__w_pdfjs_require__(349);var _xfa_fonts=__w_pdfjs_require__(430);var _base_stream=__w_pdfjs_require__(353);var _crypto=__w_pdfjs_require__(450);var _catalog=__w_pdfjs_require__(453);var _cleanup_helper=__w_pdfjs_require__(455);var _dataset_reader=__w_pdfjs_require__(493);var _parser=__w_pdfjs_require__(391);var _stream=__w_pdfjs_require__(357);var _object_loader=__w_pdfjs_require__(459);var _operator_list=__w_pdfjs_require__(446);var _evaluator=__w_pdfjs_require__(382);var _decode_stream=__w_pdfjs_require__(393);var _struct_tree=__w_pdfjs_require__(458);var _writer=__w_pdfjs_require__(448);var _factory=__w_pdfjs_require__(460);var _xref=__w_pdfjs_require__(494);function _typeof(obj){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj;}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;},_typeof(obj);}function _defineProperty(obj,key,value){key=_toPropertyKey(key);if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true});}else{obj[key]=value;}return obj;}function _slicedToArray(arr,i){return _arrayWithHoles(arr)||_iterableToArrayLimit(arr,i)||_unsupportedIterableToArray(arr,i)||_nonIterableRest();}function _nonIterableRest(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}function _iterableToArrayLimit(arr,i){var _i=null==arr?null:"undefined"!=typeof Symbol&&arr[Symbol.iterator]||arr["@@iterator"];if(null!=_i){var _s,_e,_x,_r,_arr=[],_n=!0,_d=!1;try{if(_x=(_i=_i.call(arr)).next,0===i){if(Object(_i)!==_i)return;_n=!1;}else for(;!(_n=(_s=_x.call(_i)).done)&&(_arr.push(_s.value),_arr.length!==i);_n=!0);}catch(err){_d=!0,_e=err;}finally{try{if(!_n&&null!=_i.return&&(_r=_i.return(),Object(_r)!==_r))return;}finally{if(_d)throw _e;}}return _arr;}}function _arrayWithHoles(arr){if(Array.isArray(arr))return arr;}function _regeneratorRuntime(){"use strict";/*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */_regeneratorRuntime=function _regeneratorRuntime(){return exports;};var exports={},Op=Object.prototype,hasOwn=Op.hasOwnProperty,defineProperty=Object.defineProperty||function(obj,key,desc){obj[key]=desc.value;},$Symbol="function"==typeof Symbol?Symbol:{},iteratorSymbol=$Symbol.iterator||"@@iterator",asyncIteratorSymbol=$Symbol.asyncIterator||"@@asyncIterator",toStringTagSymbol=$Symbol.toStringTag||"@@toStringTag";function define(obj,key,value){return Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}),obj[key];}try{define({},"");}catch(err){define=function define(obj,key,value){return obj[key]=value;};}function wrap(innerFn,outerFn,self,tryLocsList){var protoGenerator=outerFn&&outerFn.prototype instanceof Generator?outerFn:Generator,generator=Object.create(protoGenerator.prototype),context=new Context(tryLocsList||[]);return defineProperty(generator,"_invoke",{value:makeInvokeMethod(innerFn,self,context)}),generator;}function tryCatch(fn,obj,arg){try{return{type:"normal",arg:fn.call(obj,arg)};}catch(err){return{type:"throw",arg:err};}}exports.wrap=wrap;var ContinueSentinel={};function Generator(){}function GeneratorFunction(){}function GeneratorFunctionPrototype(){}var IteratorPrototype={};define(IteratorPrototype,iteratorSymbol,function(){return this;});var getProto=Object.getPrototypeOf,NativeIteratorPrototype=getProto&&getProto(getProto(values([])));NativeIteratorPrototype&&NativeIteratorPrototype!==Op&&hasOwn.call(NativeIteratorPrototype,iteratorSymbol)&&(IteratorPrototype=NativeIteratorPrototype);var Gp=GeneratorFunctionPrototype.prototype=Generator.prototype=Object.create(IteratorPrototype);function defineIteratorMethods(prototype){["next","throw","return"].forEach(function(method){define(prototype,method,function(arg){return this._invoke(method,arg);});});}function AsyncIterator(generator,PromiseImpl){function invoke(method,arg,resolve,reject){var record=tryCatch(generator[method],generator,arg);if("throw"!==record.type){var result=record.arg,value=result.value;return value&&"object"==_typeof(value)&&hasOwn.call(value,"__await")?PromiseImpl.resolve(value.__await).then(function(value){invoke("next",value,resolve,reject);},function(err){invoke("throw",err,resolve,reject);}):PromiseImpl.resolve(value).then(function(unwrapped){result.value=unwrapped,resolve(result);},function(error){return invoke("throw",error,resolve,reject);});}reject(record.arg);}var previousPromise;defineProperty(this,"_invoke",{value:function value(method,arg){function callInvokeWithMethodAndArg(){return new PromiseImpl(function(resolve,reject){invoke(method,arg,resolve,reject);});}return previousPromise=previousPromise?previousPromise.then(callInvokeWithMethodAndArg,callInvokeWithMethodAndArg):callInvokeWithMethodAndArg();}});}function makeInvokeMethod(innerFn,self,context){var state="suspendedStart";return function(method,arg){if("executing"===state)throw new Error("Generator is already running");if("completed"===state){if("throw"===method)throw arg;return doneResult();}for(context.method=method,context.arg=arg;;){var delegate=context.delegate;if(delegate){var delegateResult=maybeInvokeDelegate(delegate,context);if(delegateResult){if(delegateResult===ContinueSentinel)continue;return delegateResult;}}if("next"===context.method)context.sent=context._sent=context.arg;else if("throw"===context.method){if("suspendedStart"===state)throw state="completed",context.arg;context.dispatchException(context.arg);}else"return"===context.method&&context.abrupt("return",context.arg);state="executing";var record=tryCatch(innerFn,self,context);if("normal"===record.type){if(state=context.done?"completed":"suspendedYield",record.arg===ContinueSentinel)continue;return{value:record.arg,done:context.done};}"throw"===record.type&&(state="completed",context.method="throw",context.arg=record.arg);}};}function maybeInvokeDelegate(delegate,context){var methodName=context.method,method=delegate.iterator[methodName];if(undefined===method)return context.delegate=null,"throw"===methodName&&delegate.iterator.return&&(context.method="return",context.arg=undefined,maybeInvokeDelegate(delegate,context),"throw"===context.method)||"return"!==methodName&&(context.method="throw",context.arg=new TypeError("The iterator does not provide a '"+methodName+"' method")),ContinueSentinel;var record=tryCatch(method,delegate.iterator,context.arg);if("throw"===record.type)return context.method="throw",context.arg=record.arg,context.delegate=null,ContinueSentinel;var info=record.arg;return info?info.done?(context[delegate.resultName]=info.value,context.next=delegate.nextLoc,"return"!==context.method&&(context.method="next",context.arg=undefined),context.delegate=null,ContinueSentinel):info:(context.method="throw",context.arg=new TypeError("iterator result is not an object"),context.delegate=null,ContinueSentinel);}function pushTryEntry(locs){var entry={tryLoc:locs[0]};1 in locs&&(entry.catchLoc=locs[1]),2 in locs&&(entry.finallyLoc=locs[2],entry.afterLoc=locs[3]),this.tryEntries.push(entry);}function resetTryEntry(entry){var record=entry.completion||{};record.type="normal",delete record.arg,entry.completion=record;}function Context(tryLocsList){this.tryEntries=[{tryLoc:"root"}],tryLocsList.forEach(pushTryEntry,this),this.reset(!0);}function values(iterable){if(iterable){var iteratorMethod=iterable[iteratorSymbol];if(iteratorMethod)return iteratorMethod.call(iterable);if("function"==typeof iterable.next)return iterable;if(!isNaN(iterable.length)){var i=-1,next=function next(){for(;++i<iterable.length;)if(hasOwn.call(iterable,i))return next.value=iterable[i],next.done=!1,next;return next.value=undefined,next.done=!0,next;};return next.next=next;}}return{next:doneResult};}function doneResult(){return{value:undefined,done:!0};}return GeneratorFunction.prototype=GeneratorFunctionPrototype,defineProperty(Gp,"constructor",{value:GeneratorFunctionPrototype,configurable:!0}),defineProperty(GeneratorFunctionPrototype,"constructor",{value:GeneratorFunction,configurable:!0}),GeneratorFunction.displayName=define(GeneratorFunctionPrototype,toStringTagSymbol,"GeneratorFunction"),exports.isGeneratorFunction=function(genFun){var ctor="function"==typeof genFun&&genFun.constructor;return!!ctor&&(ctor===GeneratorFunction||"GeneratorFunction"===(ctor.displayName||ctor.name));},exports.mark=function(genFun){return Object.setPrototypeOf?Object.setPrototypeOf(genFun,GeneratorFunctionPrototype):(genFun.__proto__=GeneratorFunctionPrototype,define(genFun,toStringTagSymbol,"GeneratorFunction")),genFun.prototype=Object.create(Gp),genFun;},exports.awrap=function(arg){return{__await:arg};},defineIteratorMethods(AsyncIterator.prototype),define(AsyncIterator.prototype,asyncIteratorSymbol,function(){return this;}),exports.AsyncIterator=AsyncIterator,exports.async=function(innerFn,outerFn,self,tryLocsList,PromiseImpl){void 0===PromiseImpl&&(PromiseImpl=Promise);var iter=new AsyncIterator(wrap(innerFn,outerFn,self,tryLocsList),PromiseImpl);return exports.isGeneratorFunction(outerFn)?iter:iter.next().then(function(result){return result.done?result.value:iter.next();});},defineIteratorMethods(Gp),define(Gp,toStringTagSymbol,"Generator"),define(Gp,iteratorSymbol,function(){return this;}),define(Gp,"toString",function(){return"[object Generator]";}),exports.keys=function(val){var object=Object(val),keys=[];for(var key in object)keys.push(key);return keys.reverse(),function next(){for(;keys.length;){var key=keys.pop();if(key in object)return next.value=key,next.done=!1,next;}return next.done=!0,next;};},exports.values=values,Context.prototype={constructor:Context,reset:function reset(skipTempReset){if(this.prev=0,this.next=0,this.sent=this._sent=undefined,this.done=!1,this.delegate=null,this.method="next",this.arg=undefined,this.tryEntries.forEach(resetTryEntry),!skipTempReset)for(var name in this)"t"===name.charAt(0)&&hasOwn.call(this,name)&&!isNaN(+name.slice(1))&&(this[name]=undefined);},stop:function stop(){this.done=!0;var rootRecord=this.tryEntries[0].completion;if("throw"===rootRecord.type)throw rootRecord.arg;return this.rval;},dispatchException:function dispatchException(exception){if(this.done)throw exception;var context=this;function handle(loc,caught){return record.type="throw",record.arg=exception,context.next=loc,caught&&(context.method="next",context.arg=undefined),!!caught;}for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i],record=entry.completion;if("root"===entry.tryLoc)return handle("end");if(entry.tryLoc<=this.prev){var hasCatch=hasOwn.call(entry,"catchLoc"),hasFinally=hasOwn.call(entry,"finallyLoc");if(hasCatch&&hasFinally){if(this.prev<entry.catchLoc)return handle(entry.catchLoc,!0);if(this.prev<entry.finallyLoc)return handle(entry.finallyLoc);}else if(hasCatch){if(this.prev<entry.catchLoc)return handle(entry.catchLoc,!0);}else{if(!hasFinally)throw new Error("try statement without catch or finally");if(this.prev<entry.finallyLoc)return handle(entry.finallyLoc);}}}},abrupt:function abrupt(type,arg){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.tryLoc<=this.prev&&hasOwn.call(entry,"finallyLoc")&&this.prev<entry.finallyLoc){var finallyEntry=entry;break;}}finallyEntry&&("break"===type||"continue"===type)&&finallyEntry.tryLoc<=arg&&arg<=finallyEntry.finallyLoc&&(finallyEntry=null);var record=finallyEntry?finallyEntry.completion:{};return record.type=type,record.arg=arg,finallyEntry?(this.method="next",this.next=finallyEntry.finallyLoc,ContinueSentinel):this.complete(record);},complete:function complete(record,afterLoc){if("throw"===record.type)throw record.arg;return"break"===record.type||"continue"===record.type?this.next=record.arg:"return"===record.type?(this.rval=this.arg=record.arg,this.method="return",this.next="end"):"normal"===record.type&&afterLoc&&(this.next=afterLoc),ContinueSentinel;},finish:function finish(finallyLoc){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.finallyLoc===finallyLoc)return this.complete(entry.completion,entry.afterLoc),resetTryEntry(entry),ContinueSentinel;}},catch:function _catch(tryLoc){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.tryLoc===tryLoc){var record=entry.completion;if("throw"===record.type){var thrown=record.arg;resetTryEntry(entry);}return thrown;}}throw new Error("illegal catch attempt");},delegateYield:function delegateYield(iterable,resultName,nextLoc){return this.delegate={iterator:values(iterable),resultName:resultName,nextLoc:nextLoc},"next"===this.method&&(this.arg=undefined),ContinueSentinel;}},exports;}function _toConsumableArray(arr){return _arrayWithoutHoles(arr)||_iterableToArray(arr)||_unsupportedIterableToArray(arr)||_nonIterableSpread();}function _nonIterableSpread(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}function _iterableToArray(iter){if(typeof Symbol!=="undefined"&&iter[Symbol.iterator]!=null||iter["@@iterator"]!=null)return Array.from(iter);}function _arrayWithoutHoles(arr){if(Array.isArray(arr))return _arrayLikeToArray(arr);}function _createForOfIteratorHelper(o,allowArrayLike){var it=typeof Symbol!=="undefined"&&o[Symbol.iterator]||o["@@iterator"];if(!it){if(Array.isArray(o)||(it=_unsupportedIterableToArray(o))||allowArrayLike&&o&&typeof o.length==="number"){if(it)o=it;var i=0;var F=function F(){};return{s:F,n:function n(){if(i>=o.length)return{done:true};return{done:false,value:o[i++]};},e:function e(_e2){throw _e2;},f:F};}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}var normalCompletion=true,didErr=false,err;return{s:function s(){it=it.call(o);},n:function n(){var step=it.next();normalCompletion=step.done;return step;},e:function e(_e3){didErr=true;err=_e3;},f:function f(){try{if(!normalCompletion&&it.return!=null)it.return();}finally{if(didErr)throw err;}}};}function _unsupportedIterableToArray(o,minLen){if(!o)return;if(typeof o==="string")return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);if(n==="Object"&&o.constructor)n=o.constructor.name;if(n==="Map"||n==="Set")return Array.from(o);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return _arrayLikeToArray(o,minLen);}function _arrayLikeToArray(arr,len){if(len==null||len>arr.length)len=arr.length;for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2;}function asyncGeneratorStep(gen,resolve,reject,_next,_throw,key,arg){try{var info=gen[key](arg);var value=info.value;}catch(error){reject(error);return;}if(info.done){resolve(value);}else{Promise.resolve(value).then(_next,_throw);}}function _asyncToGenerator(fn){return function(){var self=this,args=arguments;return new Promise(function(resolve,reject){var gen=fn.apply(self,args);function _next(value){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"next",value);}function _throw(err){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"throw",err);}_next(undefined);});};}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function");}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:true,configurable:true}});Object.defineProperty(subClass,"prototype",{writable:false});if(superClass)_setPrototypeOf(subClass,superClass);}function _setPrototypeOf(o,p){_setPrototypeOf=Object.setPrototypeOf?Object.setPrototypeOf.bind():function _setPrototypeOf(o,p){o.__proto__=p;return o;};return _setPrototypeOf(o,p);}function _createSuper(Derived){var hasNativeReflectConstruct=_isNativeReflectConstruct();return function _createSuperInternal(){var Super=_getPrototypeOf(Derived),result;if(hasNativeReflectConstruct){var NewTarget=_getPrototypeOf(this).constructor;result=Reflect.construct(Super,arguments,NewTarget);}else{result=Super.apply(this,arguments);}return _possibleConstructorReturn(this,result);};}function _possibleConstructorReturn(self,call){if(call&&(_typeof(call)==="object"||typeof call==="function")){return call;}else if(call!==void 0){throw new TypeError("Derived constructors may only return object or undefined");}return _assertThisInitialized(self);}function _assertThisInitialized(self){if(self===void 0){throw new ReferenceError("this hasn't been initialised - super() hasn't been called");}return self;}function _isNativeReflectConstruct(){if(typeof Reflect==="undefined"||!Reflect.construct)return false;if(Reflect.construct.sham)return false;if(typeof Proxy==="function")return true;try{Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}));return true;}catch(e){return false;}}function _getPrototypeOf(o){_getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf.bind():function _getPrototypeOf(o){return o.__proto__||Object.getPrototypeOf(o);};return _getPrototypeOf(o);}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}}function _createClass(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);Object.defineProperty(Constructor,"prototype",{writable:false});return Constructor;}function _toPropertyKey(arg){var key=_toPrimitive(arg,"string");return _typeof(key)==="symbol"?key:String(key);}function _toPrimitive(input,hint){if(_typeof(input)!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(_typeof(res)!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.");}return(hint==="string"?String:Number)(input);}function _classPrivateMethodInitSpec(obj,privateSet){_checkPrivateRedeclaration(obj,privateSet);privateSet.add(obj);}function _checkPrivateRedeclaration(obj,privateCollection){if(privateCollection.has(obj)){throw new TypeError("Cannot initialize the same private elements twice on an object");}}function _classPrivateMethodGet(receiver,privateSet,fn){if(!privateSet.has(receiver)){throw new TypeError("attempted to get private field on non-instance");}return fn;}var DEFAULT_USER_UNIT=1.0;var LETTER_SIZE_MEDIABOX=[0,0,612,792];var _replaceIdByRef=/*#__PURE__*/new WeakSet();var Page=/*#__PURE__*/function(){function Page(_ref2){var pdfManager=_ref2.pdfManager,xref=_ref2.xref,pageIndex=_ref2.pageIndex,pageDict=_ref2.pageDict,_ref=_ref2.ref,globalIdFactory=_ref2.globalIdFactory,fontCache=_ref2.fontCache,builtInCMapCache=_ref2.builtInCMapCache,standardFontDataCache=_ref2.standardFontDataCache,globalImageCache=_ref2.globalImageCache,systemFontCache=_ref2.systemFontCache,nonBlendModesSet=_ref2.nonBlendModesSet,xfaFactory=_ref2.xfaFactory;_classCallCheck(this,Page);_classPrivateMethodInitSpec(this,_replaceIdByRef);this.pdfManager=pdfManager;this.pageIndex=pageIndex;this.pageDict=pageDict;this.xref=xref;this.ref=_ref;this.fontCache=fontCache;this.builtInCMapCache=builtInCMapCache;this.standardFontDataCache=standardFontDataCache;this.globalImageCache=globalImageCache;this.systemFontCache=systemFontCache;this.nonBlendModesSet=nonBlendModesSet;this.evaluatorOptions=pdfManager.evaluatorOptions;this.resourcesPromise=null;this.xfaFactory=xfaFactory;var idCounters={obj:0};this._localIdFactory=/*#__PURE__*/function(_globalIdFactory){_inherits(_class,_globalIdFactory);var _super=_createSuper(_class);function _class(){_classCallCheck(this,_class);return _super.apply(this,arguments);}_createClass(_class,null,[{key:"createObjId",value:function createObjId(){return"p".concat(pageIndex,"_").concat(++idCounters.obj);}},{key:"getPageObjId",value:function getPageObjId(){return"p".concat(_ref.toString());}}]);return _class;}(globalIdFactory);}_createClass(Page,[{key:"_getInheritableProperty",value:function _getInheritableProperty(key){var getArray=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;var value=(0,_core_utils.getInheritableProperty)({dict:this.pageDict,key:key,getArray:getArray,stopWhenFound:false});if(!Array.isArray(value)){return value;}if(value.length===1||!(value[0]instanceof _primitives.Dict)){return value[0];}return _primitives.Dict.merge({xref:this.xref,dictArray:value});}},{key:"content",get:function get(){return this.pageDict.getArray("Contents");}},{key:"resources",get:function get(){var resources=this._getInheritableProperty("Resources");return(0,_util.shadow)(this,"resources",resources instanceof _primitives.Dict?resources:_primitives.Dict.empty);}},{key:"_getBoundingBox",value:function _getBoundingBox(name){if(this.xfaData){return this.xfaData.bbox;}var box=this._getInheritableProperty(name,true);if(Array.isArray(box)&&box.length===4){box=_util.Util.normalizeRect(box);if(box[2]-box[0]>0&&box[3]-box[1]>0){return box;}(0,_util.warn)("Empty, or invalid, /".concat(name," entry."));}return null;}},{key:"mediaBox",get:function get(){return(0,_util.shadow)(this,"mediaBox",this._getBoundingBox("MediaBox")||LETTER_SIZE_MEDIABOX);}},{key:"cropBox",get:function get(){return(0,_util.shadow)(this,"cropBox",this._getBoundingBox("CropBox")||this.mediaBox);}},{key:"userUnit",get:function get(){var obj=this.pageDict.get("UserUnit");if(typeof obj!=="number"||obj<=0){obj=DEFAULT_USER_UNIT;}return(0,_util.shadow)(this,"userUnit",obj);}},{key:"view",get:function get(){var cropBox=this.cropBox,mediaBox=this.mediaBox;if(cropBox!==mediaBox&&!(0,_util.isArrayEqual)(cropBox,mediaBox)){var box=_util.Util.intersect(cropBox,mediaBox);if(box&&box[2]-box[0]>0&&box[3]-box[1]>0){return(0,_util.shadow)(this,"view",box);}(0,_util.warn)("Empty /CropBox and /MediaBox intersection.");}return(0,_util.shadow)(this,"view",mediaBox);}},{key:"rotate",get:function get(){var rotate=this._getInheritableProperty("Rotate")||0;if(rotate%90!==0){rotate=0;}else if(rotate>=360){rotate%=360;}else if(rotate<0){rotate=(rotate%360+360)%360;}return(0,_util.shadow)(this,"rotate",rotate);}},{key:"_onSubStreamError",value:function _onSubStreamError(reason,objId){if(this.evaluatorOptions.ignoreErrors){(0,_util.warn)("getContentStream - ignoring sub-stream (".concat(objId,"): \"").concat(reason,"\"."));return;}throw reason;}},{key:"getContentStream",value:function getContentStream(){var _this=this;return this.pdfManager.ensure(this,"content").then(function(content){if(content instanceof _base_stream.BaseStream){return content;}if(Array.isArray(content)){return new _decode_stream.StreamsSequenceStream(content,_this._onSubStreamError.bind(_this));}return new _stream.NullStream();});}},{key:"xfaData",get:function get(){return(0,_util.shadow)(this,"xfaData",this.xfaFactory?{bbox:this.xfaFactory.getBoundingBox(this.pageIndex)}:null);}},{key:"saveNewAnnotations",value:function(){var _saveNewAnnotations=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee(handler,task,annotations,imagePromises){var partialEvaluator,deletedAnnotations,existingAnnotations,pageDict,annotationsArray,newData,_iterator,_step,ref,savedDict,buffer,transform,objects;return _regeneratorRuntime().wrap(function _callee$(_context){while(1)switch(_context.prev=_context.next){case 0:if(!this.xfaFactory){_context.next=2;break;}throw new Error("XFA: Cannot save new annotations.");case 2:partialEvaluator=new _evaluator.PartialEvaluator({xref:this.xref,handler:handler,pageIndex:this.pageIndex,idFactory:this._localIdFactory,fontCache:this.fontCache,builtInCMapCache:this.builtInCMapCache,standardFontDataCache:this.standardFontDataCache,globalImageCache:this.globalImageCache,systemFontCache:this.systemFontCache,options:this.evaluatorOptions});deletedAnnotations=new _primitives.RefSet();existingAnnotations=new _primitives.RefSet();_classPrivateMethodGet(this,_replaceIdByRef,_replaceIdByRef2).call(this,annotations,deletedAnnotations,existingAnnotations);pageDict=this.pageDict;annotationsArray=this.annotations.filter(function(a){return!(a instanceof _primitives.Ref&&deletedAnnotations.has(a));});_context.next=10;return _annotation2.AnnotationFactory.saveNewAnnotations(partialEvaluator,task,annotations,imagePromises);case 10:newData=_context.sent;_iterator=_createForOfIteratorHelper(newData.annotations);try{for(_iterator.s();!(_step=_iterator.n()).done;){ref=_step.value.ref;if(ref instanceof _primitives.Ref&&!existingAnnotations.has(ref)){annotationsArray.push(ref);}}}catch(err){_iterator.e(err);}finally{_iterator.f();}savedDict=pageDict.get("Annots");pageDict.set("Annots",annotationsArray);buffer=[];transform=null;if(this.xref.encrypt){transform=this.xref.encrypt.createCipherTransform(this.ref.num,this.ref.gen);}_context.next=20;return(0,_writer.writeObject)(this.ref,pageDict,buffer,transform);case 20:if(savedDict){pageDict.set("Annots",savedDict);}objects=newData.dependencies;objects.push.apply(objects,[{ref:this.ref,data:buffer.join("")}].concat(_toConsumableArray(newData.annotations)));return _context.abrupt("return",objects);case 24:case"end":return _context.stop();}},_callee,this);}));function saveNewAnnotations(_x,_x2,_x3,_x4){return _saveNewAnnotations.apply(this,arguments);}return saveNewAnnotations;}()},{key:"save",value:function save(handler,task,annotationStorage){var partialEvaluator=new _evaluator.PartialEvaluator({xref:this.xref,handler:handler,pageIndex:this.pageIndex,idFactory:this._localIdFactory,fontCache:this.fontCache,builtInCMapCache:this.builtInCMapCache,standardFontDataCache:this.standardFontDataCache,globalImageCache:this.globalImageCache,systemFontCache:this.systemFontCache,options:this.evaluatorOptions});return this._parsedAnnotations.then(function(annotations){var newRefsPromises=[];var _iterator2=_createForOfIteratorHelper(annotations),_step2;try{for(_iterator2.s();!(_step2=_iterator2.n()).done;){var annotation=_step2.value;if(!annotation.mustBePrinted(annotationStorage)){continue;}newRefsPromises.push(annotation.save(partialEvaluator,task,annotationStorage).catch(function(reason){(0,_util.warn)("save - ignoring annotation data during "+"\"".concat(task.name,"\" task: \"").concat(reason,"\"."));return null;}));}}catch(err){_iterator2.e(err);}finally{_iterator2.f();}return Promise.all(newRefsPromises).then(function(newRefs){return newRefs.filter(function(newRef){return!!newRef;});});});}},{key:"loadResources",value:function loadResources(keys){var _this2=this;if(!this.resourcesPromise){this.resourcesPromise=this.pdfManager.ensure(this,"resources");}return this.resourcesPromise.then(function(){var objectLoader=new _object_loader.ObjectLoader(_this2.resources,keys,_this2.xref);return objectLoader.load();});}},{key:"getOperatorList",value:function getOperatorList(_ref3){var _this3=this;var handler=_ref3.handler,sink=_ref3.sink,task=_ref3.task,intent=_ref3.intent,cacheKey=_ref3.cacheKey,_ref3$annotationStora=_ref3.annotationStorage,annotationStorage=_ref3$annotationStora===void 0?null:_ref3$annotationStora;var contentStreamPromise=this.getContentStream();var resourcesPromise=this.loadResources(["ColorSpace","ExtGState","Font","Pattern","Properties","Shading","XObject"]);var partialEvaluator=new _evaluator.PartialEvaluator({xref:this.xref,handler:handler,pageIndex:this.pageIndex,idFactory:this._localIdFactory,fontCache:this.fontCache,builtInCMapCache:this.builtInCMapCache,standardFontDataCache:this.standardFontDataCache,globalImageCache:this.globalImageCache,systemFontCache:this.systemFontCache,options:this.evaluatorOptions});var newAnnotationsByPage=!this.xfaFactory?(0,_core_utils.getNewAnnotationsMap)(annotationStorage):null;var deletedAnnotations=null;var newAnnotationsPromise=Promise.resolve(null);if(newAnnotationsByPage){var imagePromises;var newAnnotations=newAnnotationsByPage.get(this.pageIndex);if(newAnnotations){var missingBitmaps=new Set();var _iterator3=_createForOfIteratorHelper(newAnnotations),_step3;try{for(_iterator3.s();!(_step3=_iterator3.n()).done;){var _step3$value=_step3.value,bitmapId=_step3$value.bitmapId,bitmap=_step3$value.bitmap;if(bitmapId&&!bitmap&&!missingBitmaps.has(bitmapId)){missingBitmaps.add(bitmapId);}}}catch(err){_iterator3.e(err);}finally{_iterator3.f();}var isOffscreenCanvasSupported=this.evaluatorOptions.isOffscreenCanvasSupported;if(missingBitmaps.size>0){var annotationWithBitmaps=newAnnotations.slice();var _iterator4=_createForOfIteratorHelper(annotationStorage),_step4;try{for(_iterator4.s();!(_step4=_iterator4.n()).done;){var _step4$value=_slicedToArray(_step4.value,2),key=_step4$value[0],annotation=_step4$value[1];if(!key.startsWith(_util.AnnotationEditorPrefix)){continue;}if(annotation.bitmap&&missingBitmaps.has(annotation.bitmapId)){annotationWithBitmaps.push(annotation);}}}catch(err){_iterator4.e(err);}finally{_iterator4.f();}imagePromises=_annotation2.AnnotationFactory.generateImages(annotationWithBitmaps,this.xref,isOffscreenCanvasSupported);}else{imagePromises=_annotation2.AnnotationFactory.generateImages(newAnnotations,this.xref,isOffscreenCanvasSupported);}deletedAnnotations=new _primitives.RefSet();_classPrivateMethodGet(this,_replaceIdByRef,_replaceIdByRef2).call(this,newAnnotations,deletedAnnotations,null);newAnnotationsPromise=_annotation2.AnnotationFactory.printNewAnnotations(partialEvaluator,task,newAnnotations,imagePromises);}}var dataPromises=Promise.all([contentStreamPromise,resourcesPromise]);var pageListPromise=dataPromises.then(function(_ref4){var _ref5=_slicedToArray(_ref4,1),contentStream=_ref5[0];var opList=new _operator_list.OperatorList(intent,sink);handler.send("StartRenderPage",{transparency:partialEvaluator.hasBlendModes(_this3.resources,_this3.nonBlendModesSet),pageIndex:_this3.pageIndex,cacheKey:cacheKey});return partialEvaluator.getOperatorList({stream:contentStream,task:task,resources:_this3.resources,operatorList:opList}).then(function(){return opList;});});return Promise.all([pageListPromise,this._parsedAnnotations,newAnnotationsPromise]).then(function(_ref6){var _ref7=_slicedToArray(_ref6,3),pageOpList=_ref7[0],annotations=_ref7[1],newAnnotations=_ref7[2];if(newAnnotations){annotations=annotations.filter(function(a){return!(a.ref&&deletedAnnotations.has(a.ref));});var _loop=function _loop(_i2,_ii){var newAnnotation=newAnnotations[_i2];if(newAnnotation.refToReplace){var j=annotations.findIndex(function(a){return a.ref&&(0,_primitives.isRefsEqual)(a.ref,newAnnotation.refToReplace);});if(j>=0){annotations.splice(j,1,newAnnotation);newAnnotations.splice(_i2--,1);_ii--;}}i=_i2,ii=_ii;};for(var i=0,ii=newAnnotations.length;i<ii;i++){_loop(i,ii);}annotations=annotations.concat(newAnnotations);}if(annotations.length===0||intent&_util.RenderingIntentFlag.ANNOTATIONS_DISABLE){pageOpList.flush(true);return{length:pageOpList.totalLength};}var renderForms=!!(intent&_util.RenderingIntentFlag.ANNOTATIONS_FORMS),intentAny=!!(intent&_util.RenderingIntentFlag.ANY),intentDisplay=!!(intent&_util.RenderingIntentFlag.DISPLAY),intentPrint=!!(intent&_util.RenderingIntentFlag.PRINT);var opListPromises=[];var _iterator5=_createForOfIteratorHelper(annotations),_step5;try{for(_iterator5.s();!(_step5=_iterator5.n()).done;){var _annotation=_step5.value;if(intentAny||intentDisplay&&_annotation.mustBeViewed(annotationStorage,renderForms)||intentPrint&&_annotation.mustBePrinted(annotationStorage)){opListPromises.push(_annotation.getOperatorList(partialEvaluator,task,intent,renderForms,annotationStorage).catch(function(reason){(0,_util.warn)("getOperatorList - ignoring annotation data during "+"\"".concat(task.name,"\" task: \"").concat(reason,"\"."));return{opList:null,separateForm:false,separateCanvas:false};}));}}}catch(err){_iterator5.e(err);}finally{_iterator5.f();}return Promise.all(opListPromises).then(function(opLists){var form=false,canvas=false;var _iterator6=_createForOfIteratorHelper(opLists),_step6;try{for(_iterator6.s();!(_step6=_iterator6.n()).done;){var _step6$value=_step6.value,opList=_step6$value.opList,separateForm=_step6$value.separateForm,separateCanvas=_step6$value.separateCanvas;pageOpList.addOpList(opList);form||(form=separateForm);canvas||(canvas=separateCanvas);}}catch(err){_iterator6.e(err);}finally{_iterator6.f();}pageOpList.flush(true,{form:form,canvas:canvas});return{length:pageOpList.totalLength};});});}},{key:"extractTextContent",value:function extractTextContent(_ref8){var _this4=this;var handler=_ref8.handler,task=_ref8.task,includeMarkedContent=_ref8.includeMarkedContent,disableNormalization=_ref8.disableNormalization,sink=_ref8.sink;var contentStreamPromise=this.getContentStream();var resourcesPromise=this.loadResources(["ExtGState","Font","Properties","XObject"]);var dataPromises=Promise.all([contentStreamPromise,resourcesPromise]);return dataPromises.then(function(_ref9){var _ref10=_slicedToArray(_ref9,1),contentStream=_ref10[0];var partialEvaluator=new _evaluator.PartialEvaluator({xref:_this4.xref,handler:handler,pageIndex:_this4.pageIndex,idFactory:_this4._localIdFactory,fontCache:_this4.fontCache,builtInCMapCache:_this4.builtInCMapCache,standardFontDataCache:_this4.standardFontDataCache,globalImageCache:_this4.globalImageCache,systemFontCache:_this4.systemFontCache,options:_this4.evaluatorOptions});return partialEvaluator.getTextContent({stream:contentStream,task:task,resources:_this4.resources,includeMarkedContent:includeMarkedContent,disableNormalization:disableNormalization,sink:sink,viewBox:_this4.view});});}},{key:"getStructTree",value:function(){var _getStructTree=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee2(){var structTreeRoot,structTree;return _regeneratorRuntime().wrap(function _callee2$(_context2){while(1)switch(_context2.prev=_context2.next){case 0:_context2.next=2;return this.pdfManager.ensureCatalog("structTreeRoot");case 2:structTreeRoot=_context2.sent;if(structTreeRoot){_context2.next=5;break;}return _context2.abrupt("return",null);case 5:_context2.next=7;return this.pdfManager.ensure(this,"_parseStructTree",[structTreeRoot]);case 7:structTree=_context2.sent;return _context2.abrupt("return",structTree.serializable);case 9:case"end":return _context2.stop();}},_callee2,this);}));function getStructTree(){return _getStructTree.apply(this,arguments);}return getStructTree;}()},{key:"_parseStructTree",value:function _parseStructTree(structTreeRoot){var tree=new _struct_tree.StructTreePage(structTreeRoot,this.pageDict);tree.parse();return tree;}},{key:"getAnnotationsData",value:function(){var _getAnnotationsData=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee3(handler,task,intent){var annotations,annotationsData,textContentPromises,partialEvaluator,intentAny,intentDisplay,intentPrint,_iterator7,_step7,annotation,isVisible;return _regeneratorRuntime().wrap(function _callee3$(_context3){while(1)switch(_context3.prev=_context3.next){case 0:_context3.next=2;return this._parsedAnnotations;case 2:annotations=_context3.sent;if(!(annotations.length===0)){_context3.next=5;break;}return _context3.abrupt("return",[]);case 5:annotationsData=[],textContentPromises=[];intentAny=!!(intent&_util.RenderingIntentFlag.ANY),intentDisplay=!!(intent&_util.RenderingIntentFlag.DISPLAY),intentPrint=!!(intent&_util.RenderingIntentFlag.PRINT);_iterator7=_createForOfIteratorHelper(annotations);try{for(_iterator7.s();!(_step7=_iterator7.n()).done;){annotation=_step7.value;isVisible=intentAny||intentDisplay&&annotation.viewable;if(isVisible||intentPrint&&annotation.printable){annotationsData.push(annotation.data);}if(annotation.hasTextContent&&isVisible){partialEvaluator||(partialEvaluator=new _evaluator.PartialEvaluator({xref:this.xref,handler:handler,pageIndex:this.pageIndex,idFactory:this._localIdFactory,fontCache:this.fontCache,builtInCMapCache:this.builtInCMapCache,standardFontDataCache:this.standardFontDataCache,globalImageCache:this.globalImageCache,systemFontCache:this.systemFontCache,options:this.evaluatorOptions}));textContentPromises.push(annotation.extractTextContent(partialEvaluator,task,[-Infinity,-Infinity,Infinity,Infinity]).catch(function(reason){(0,_util.warn)("getAnnotationsData - ignoring textContent during \"".concat(task.name,"\" task: \"").concat(reason,"\"."));}));}}}catch(err){_iterator7.e(err);}finally{_iterator7.f();}_context3.next=11;return Promise.all(textContentPromises);case 11:return _context3.abrupt("return",annotationsData);case 12:case"end":return _context3.stop();}},_callee3,this);}));function getAnnotationsData(_x5,_x6,_x7){return _getAnnotationsData.apply(this,arguments);}return getAnnotationsData;}()},{key:"annotations",get:function get(){var annots=this._getInheritableProperty("Annots");return(0,_util.shadow)(this,"annotations",Array.isArray(annots)?annots:[]);}},{key:"_parsedAnnotations",get:function get(){var _this5=this;var parsedAnnotations=this.pdfManager.ensure(this,"annotations").then(function(){var annotationPromises=[];var _iterator8=_createForOfIteratorHelper(_this5.annotations),_step8;try{for(_iterator8.s();!(_step8=_iterator8.n()).done;){var annotationRef=_step8.value;annotationPromises.push(_annotation2.AnnotationFactory.create(_this5.xref,annotationRef,_this5.pdfManager,_this5._localIdFactory,false).catch(function(reason){(0,_util.warn)("_parsedAnnotations: \"".concat(reason,"\"."));return null;}));}}catch(err){_iterator8.e(err);}finally{_iterator8.f();}return Promise.all(annotationPromises).then(function(annotations){if(annotations.length===0){return annotations;}var sortedAnnotations=[];var popupAnnotations;var _iterator9=_createForOfIteratorHelper(annotations),_step9;try{for(_iterator9.s();!(_step9=_iterator9.n()).done;){var annotation=_step9.value;if(!annotation){continue;}if(annotation instanceof _annotation2.PopupAnnotation){(popupAnnotations||(popupAnnotations=[])).push(annotation);continue;}sortedAnnotations.push(annotation);}}catch(err){_iterator9.e(err);}finally{_iterator9.f();}if(popupAnnotations){sortedAnnotations.push.apply(sortedAnnotations,_toConsumableArray(popupAnnotations));}return sortedAnnotations;});});return(0,_util.shadow)(this,"_parsedAnnotations",parsedAnnotations);}},{key:"jsActions",get:function get(){var actions=(0,_core_utils.collectActions)(this.xref,this.pageDict,_util.PageActionEventType);return(0,_util.shadow)(this,"jsActions",actions);}}]);return Page;}();exports.Page=Page;function _replaceIdByRef2(annotations,deletedAnnotations,existingAnnotations){var _iterator21=_createForOfIteratorHelper(annotations),_step21;try{for(_iterator21.s();!(_step21=_iterator21.n()).done;){var annotation=_step21.value;if(annotation.id){var ref=_primitives.Ref.fromString(annotation.id);if(!ref){(0,_util.warn)("A non-linked annotation cannot be modified: ".concat(annotation.id));continue;}if(annotation.deleted){deletedAnnotations.put(ref);continue;}existingAnnotations===null||existingAnnotations===void 0?void 0:existingAnnotations.put(ref);annotation.ref=ref;delete annotation.id;}}}catch(err){_iterator21.e(err);}finally{_iterator21.f();}}var PDF_HEADER_SIGNATURE=new Uint8Array([0x25,0x50,0x44,0x46,0x2d]);var STARTXREF_SIGNATURE=new Uint8Array([0x73,0x74,0x61,0x72,0x74,0x78,0x72,0x65,0x66]);var ENDOBJ_SIGNATURE=new Uint8Array([0x65,0x6e,0x64,0x6f,0x62,0x6a]);var FINGERPRINT_FIRST_BYTES=1024;var EMPTY_FINGERPRINT="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";function find(stream,signature){var limit=arguments.length>2&&arguments[2]!==undefined?arguments[2]:1024;var backwards=arguments.length>3&&arguments[3]!==undefined?arguments[3]:false;var signatureLength=signature.length;var scanBytes=stream.peekBytes(limit);var scanLength=scanBytes.length-signatureLength;if(scanLength<=0){return false;}if(backwards){var signatureEnd=signatureLength-1;var pos=scanBytes.length-1;while(pos>=signatureEnd){var j=0;while(j<signatureLength&&scanBytes[pos-j]===signature[signatureEnd-j]){j++;}if(j>=signatureLength){stream.pos+=pos-signatureEnd;return true;}pos--;}}else{var _pos=0;while(_pos<=scanLength){var _j=0;while(_j<signatureLength&&scanBytes[_pos+_j]===signature[_j]){_j++;}if(_j>=signatureLength){stream.pos+=_pos;return true;}_pos++;}}return false;}var PDFDocument=/*#__PURE__*/function(){function PDFDocument(pdfManager,stream){_classCallCheck(this,PDFDocument);if(stream.length<=0){throw new _util.InvalidPDFException("The PDF file is empty, i.e. its size is zero bytes.");}this.pdfManager=pdfManager;this.stream=stream;this.xref=new _xref.XRef(stream,pdfManager);this._pagePromises=new Map();this._version=null;var idCounters={font:0};this._globalIdFactory=/*#__PURE__*/function(){function _class2(){_classCallCheck(this,_class2);}_createClass(_class2,null,[{key:"getDocId",value:function getDocId(){return"g_".concat(pdfManager.docId);}},{key:"createFontId",value:function createFontId(){return"f".concat(++idCounters.font);}},{key:"createObjId",value:function createObjId(){(0,_util.unreachable)("Abstract method `createObjId` called.");}},{key:"getPageObjId",value:function getPageObjId(){(0,_util.unreachable)("Abstract method `getPageObjId` called.");}}]);return _class2;}();}_createClass(PDFDocument,[{key:"parse",value:function parse(recoveryMode){this.xref.parse(recoveryMode);this.catalog=new _catalog.Catalog(this.pdfManager,this.xref);}},{key:"linearization",get:function get(){var linearization=null;try{linearization=_parser.Linearization.create(this.stream);}catch(err){if(err instanceof _core_utils.MissingDataException){throw err;}(0,_util.info)(err);}return(0,_util.shadow)(this,"linearization",linearization);}},{key:"startXRef",get:function get(){var stream=this.stream;var startXRef=0;if(this.linearization){stream.reset();if(find(stream,ENDOBJ_SIGNATURE)){startXRef=stream.pos+6-stream.start;}}else{var step=1024;var startXRefLength=STARTXREF_SIGNATURE.length;var found=false,pos=stream.end;while(!found&&pos>0){pos-=step-startXRefLength;if(pos<0){pos=0;}stream.pos=pos;found=find(stream,STARTXREF_SIGNATURE,step,true);}if(found){stream.skip(9);var ch;do{ch=stream.getByte();}while((0,_core_utils.isWhiteSpace)(ch));var str="";while(ch>=0x20&&ch<=0x39){str+=String.fromCharCode(ch);ch=stream.getByte();}startXRef=parseInt(str,10);if(isNaN(startXRef)){startXRef=0;}}}return(0,_util.shadow)(this,"startXRef",startXRef);}},{key:"checkHeader",value:function checkHeader(){var stream=this.stream;stream.reset();if(!find(stream,PDF_HEADER_SIGNATURE)){return;}stream.moveStart();stream.skip(PDF_HEADER_SIGNATURE.length);var version="",ch;while((ch=stream.getByte())>0x20&&version.length<7){version+=String.fromCharCode(ch);}if(_core_utils.PDF_VERSION_REGEXP.test(version)){this._version=version;}else{(0,_util.warn)("Invalid PDF header version: ".concat(version));}}},{key:"parseStartXRef",value:function parseStartXRef(){this.xref.setStartXRef(this.startXRef);}},{key:"numPages",get:function get(){var num=0;if(this.catalog.hasActualNumPages){num=this.catalog.numPages;}else if(this.xfaFactory){num=this.xfaFactory.getNumPages();}else if(this.linearization){num=this.linearization.numPages;}else{num=this.catalog.numPages;}return(0,_util.shadow)(this,"numPages",num);}},{key:"_hasOnlyDocumentSignatures",value:function _hasOnlyDocumentSignatures(fields){var _this6=this;var recursionDepth=arguments.length>1&&arguments[1]!==undefined?arguments[1]:0;var RECURSION_LIMIT=10;if(!Array.isArray(fields)){return false;}return fields.every(function(field){field=_this6.xref.fetchIfRef(field);if(!(field instanceof _primitives.Dict)){return false;}if(field.has("Kids")){if(++recursionDepth>RECURSION_LIMIT){(0,_util.warn)("_hasOnlyDocumentSignatures: maximum recursion depth reached");return false;}return _this6._hasOnlyDocumentSignatures(field.get("Kids"),recursionDepth);}var isSignature=(0,_primitives.isName)(field.get("FT"),"Sig");var rectangle=field.get("Rect");var isInvisible=Array.isArray(rectangle)&&rectangle.every(function(value){return value===0;});return isSignature&&isInvisible;});}},{key:"_xfaStreams",get:function get(){var acroForm=this.catalog.acroForm;if(!acroForm){return null;}var xfa=acroForm.get("XFA");var entries={"xdp:xdp":"",template:"",datasets:"",config:"",connectionSet:"",localeSet:"",stylesheet:"","/xdp:xdp":""};if(xfa instanceof _base_stream.BaseStream&&!xfa.isEmpty){entries["xdp:xdp"]=xfa;return entries;}if(!Array.isArray(xfa)||xfa.length===0){return null;}for(var i=0,ii=xfa.length;i<ii;i+=2){var name=void 0;if(i===0){name="xdp:xdp";}else if(i===ii-2){name="/xdp:xdp";}else{name=xfa[i];}if(!entries.hasOwnProperty(name)){continue;}var data=this.xref.fetchIfRef(xfa[i+1]);if(!(data instanceof _base_stream.BaseStream)||data.isEmpty){continue;}entries[name]=data;}return entries;}},{key:"xfaDatasets",get:function get(){var streams=this._xfaStreams;if(!streams){return(0,_util.shadow)(this,"xfaDatasets",null);}for(var _i3=0,_arr2=["datasets","xdp:xdp"];_i3<_arr2.length;_i3++){var key=_arr2[_i3];var stream=streams[key];if(!stream){continue;}try{var str=(0,_util.stringToUTF8String)(stream.getString());var data=_defineProperty({},key,str);return(0,_util.shadow)(this,"xfaDatasets",new _dataset_reader.DatasetReader(data));}catch(_unused){(0,_util.warn)("XFA - Invalid utf-8 string.");break;}}return(0,_util.shadow)(this,"xfaDatasets",null);}},{key:"xfaData",get:function get(){var streams=this._xfaStreams;if(!streams){return null;}var data=Object.create(null);for(var _i4=0,_Object$entries=Object.entries(streams);_i4<_Object$entries.length;_i4++){var _Object$entries$_i=_slicedToArray(_Object$entries[_i4],2),key=_Object$entries$_i[0],stream=_Object$entries$_i[1];if(!stream){continue;}try{data[key]=(0,_util.stringToUTF8String)(stream.getString());}catch(_unused2){(0,_util.warn)("XFA - Invalid utf-8 string.");return null;}}return data;}},{key:"xfaFactory",get:function get(){var data;if(this.pdfManager.enableXfa&&this.catalog.needsRendering&&this.formInfo.hasXfa&&!this.formInfo.hasAcroForm){data=this.xfaData;}return(0,_util.shadow)(this,"xfaFactory",data?new _factory.XFAFactory(data):null);}},{key:"isPureXfa",get:function get(){return this.xfaFactory?this.xfaFactory.isValid():false;}},{key:"htmlForXfa",get:function get(){return this.xfaFactory?this.xfaFactory.getPages():null;}},{key:"loadXfaImages",value:function(){var _loadXfaImages=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee4(){var xfaImagesDict,keys,objectLoader,xfaImages,_iterator10,_step10,key,stream;return _regeneratorRuntime().wrap(function _callee4$(_context4){while(1)switch(_context4.prev=_context4.next){case 0:_context4.next=2;return this.pdfManager.ensureCatalog("xfaImages");case 2:xfaImagesDict=_context4.sent;if(xfaImagesDict){_context4.next=5;break;}return _context4.abrupt("return");case 5:keys=xfaImagesDict.getKeys();objectLoader=new _object_loader.ObjectLoader(xfaImagesDict,keys,this.xref);_context4.next=9;return objectLoader.load();case 9:xfaImages=new Map();_iterator10=_createForOfIteratorHelper(keys);try{for(_iterator10.s();!(_step10=_iterator10.n()).done;){key=_step10.value;stream=xfaImagesDict.get(key);if(stream instanceof _base_stream.BaseStream){xfaImages.set(key,stream.getBytes());}}}catch(err){_iterator10.e(err);}finally{_iterator10.f();}this.xfaFactory.setImages(xfaImages);case 13:case"end":return _context4.stop();}},_callee4,this);}));function loadXfaImages(){return _loadXfaImages.apply(this,arguments);}return loadXfaImages;}()},{key:"loadXfaFonts",value:function(){var _loadXfaFonts=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee5(handler,task){var acroForm,resources,objectLoader,fontRes,options,partialEvaluator,operatorList,pdfFonts,initialState,fonts,promises,_iterator11,_step11,_step11$value,fontName,font,descriptor,fontFamily,fontWeight,italicAngle,cssFontInfo,missingFonts,reallyMissingFonts,_iterator12,_step12,missing,_iterator13,_step13,_missing,_i5,_arr3,fontInfo,name,dict;return _regeneratorRuntime().wrap(function _callee5$(_context5){while(1)switch(_context5.prev=_context5.next){case 0:_context5.next=2;return this.pdfManager.ensureCatalog("acroForm");case 2:acroForm=_context5.sent;if(acroForm){_context5.next=5;break;}return _context5.abrupt("return");case 5:_context5.next=7;return acroForm.getAsync("DR");case 7:resources=_context5.sent;if(resources instanceof _primitives.Dict){_context5.next=10;break;}return _context5.abrupt("return");case 10:objectLoader=new _object_loader.ObjectLoader(resources,["Font"],this.xref);_context5.next=13;return objectLoader.load();case 13:fontRes=resources.get("Font");if(fontRes instanceof _primitives.Dict){_context5.next=16;break;}return _context5.abrupt("return");case 16:options=Object.assign(Object.create(null),this.pdfManager.evaluatorOptions);options.useSystemFonts=false;partialEvaluator=new _evaluator.PartialEvaluator({xref:this.xref,handler:handler,pageIndex:-1,idFactory:this._globalIdFactory,fontCache:this.catalog.fontCache,builtInCMapCache:this.catalog.builtInCMapCache,standardFontDataCache:this.catalog.standardFontDataCache,options:options});operatorList=new _operator_list.OperatorList();pdfFonts=[];_context5.t0=function clone(){return this;};initialState={get font(){return pdfFonts.at(-1);},set font(font){pdfFonts.push(font);},clone:_context5.t0};fonts=new Map();fontRes.forEach(function(fontName,font){fonts.set(fontName,font);});promises=[];_iterator11=_createForOfIteratorHelper(fonts);_context5.prev=27;_iterator11.s();case 29:if((_step11=_iterator11.n()).done){_context5.next=44;break;}_step11$value=_slicedToArray(_step11.value,2),fontName=_step11$value[0],font=_step11$value[1];descriptor=font.get("FontDescriptor");if(descriptor instanceof _primitives.Dict){_context5.next=34;break;}return _context5.abrupt("continue",42);case 34:fontFamily=descriptor.get("FontFamily");fontFamily=fontFamily.replaceAll(/[ ]+(\d)/g,"$1");fontWeight=descriptor.get("FontWeight");italicAngle=-descriptor.get("ItalicAngle");cssFontInfo={fontFamily:fontFamily,fontWeight:fontWeight,italicAngle:italicAngle};if((0,_core_utils.validateCSSFont)(cssFontInfo)){_context5.next=41;break;}return _context5.abrupt("continue",42);case 41:promises.push(partialEvaluator.handleSetFont(resources,[_primitives.Name.get(fontName),1],null,operatorList,task,initialState,null,cssFontInfo).catch(function(reason){(0,_util.warn)("loadXfaFonts: \"".concat(reason,"\"."));return null;}));case 42:_context5.next=29;break;case 44:_context5.next=49;break;case 46:_context5.prev=46;_context5.t1=_context5["catch"](27);_iterator11.e(_context5.t1);case 49:_context5.prev=49;_iterator11.f();return _context5.finish(49);case 52:_context5.next=54;return Promise.all(promises);case 54:missingFonts=this.xfaFactory.setFonts(pdfFonts);if(missingFonts){_context5.next=57;break;}return _context5.abrupt("return");case 57:options.ignoreErrors=true;promises.length=0;pdfFonts.length=0;reallyMissingFonts=new Set();_iterator12=_createForOfIteratorHelper(missingFonts);try{for(_iterator12.s();!(_step12=_iterator12.n()).done;){missing=_step12.value;if(!(0,_xfa_fonts.getXfaFontName)("".concat(missing,"-Regular"))){reallyMissingFonts.add(missing);}}}catch(err){_iterator12.e(err);}finally{_iterator12.f();}if(reallyMissingFonts.size){missingFonts.push("PdfJS-Fallback");}_iterator13=_createForOfIteratorHelper(missingFonts);_context5.prev=65;_iterator13.s();case 67:if((_step13=_iterator13.n()).done){_context5.next=74;break;}_missing=_step13.value;if(!reallyMissingFonts.has(_missing)){_context5.next=71;break;}return _context5.abrupt("continue",72);case 71:for(_i5=0,_arr3=[{name:"Regular",fontWeight:400,italicAngle:0},{name:"Bold",fontWeight:700,italicAngle:0},{name:"Italic",fontWeight:400,italicAngle:12},{name:"BoldItalic",fontWeight:700,italicAngle:12}];_i5<_arr3.length;_i5++){fontInfo=_arr3[_i5];name="".concat(_missing,"-").concat(fontInfo.name);dict=(0,_xfa_fonts.getXfaFontDict)(name);promises.push(partialEvaluator.handleSetFont(resources,[_primitives.Name.get(name),1],null,operatorList,task,initialState,dict,{fontFamily:_missing,fontWeight:fontInfo.fontWeight,italicAngle:fontInfo.italicAngle}).catch(function(reason){(0,_util.warn)("loadXfaFonts: \"".concat(reason,"\"."));return null;}));}case 72:_context5.next=67;break;case 74:_context5.next=79;break;case 76:_context5.prev=76;_context5.t2=_context5["catch"](65);_iterator13.e(_context5.t2);case 79:_context5.prev=79;_iterator13.f();return _context5.finish(79);case 82:_context5.next=84;return Promise.all(promises);case 84:this.xfaFactory.appendFonts(pdfFonts,reallyMissingFonts);case 85:case"end":return _context5.stop();}},_callee5,this,[[27,46,49,52],[65,76,79,82]]);}));function loadXfaFonts(_x8,_x9){return _loadXfaFonts.apply(this,arguments);}return loadXfaFonts;}()},{key:"serializeXfaData",value:function(){var _serializeXfaData=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee6(annotationStorage){return _regeneratorRuntime().wrap(function _callee6$(_context6){while(1)switch(_context6.prev=_context6.next){case 0:return _context6.abrupt("return",this.xfaFactory?this.xfaFactory.serializeData(annotationStorage):null);case 1:case"end":return _context6.stop();}},_callee6,this);}));function serializeXfaData(_x10){return _serializeXfaData.apply(this,arguments);}return serializeXfaData;}()},{key:"version",get:function get(){return this.catalog.version||this._version;}},{key:"formInfo",get:function get(){var formInfo={hasFields:false,hasAcroForm:false,hasXfa:false,hasSignatures:false};var acroForm=this.catalog.acroForm;if(!acroForm){return(0,_util.shadow)(this,"formInfo",formInfo);}try{var fields=acroForm.get("Fields");var hasFields=Array.isArray(fields)&&fields.length>0;formInfo.hasFields=hasFields;var xfa=acroForm.get("XFA");formInfo.hasXfa=Array.isArray(xfa)&&xfa.length>0||xfa instanceof _base_stream.BaseStream&&!xfa.isEmpty;var sigFlags=acroForm.get("SigFlags");var hasSignatures=!!(sigFlags&0x1);var hasOnlyDocumentSignatures=hasSignatures&&this._hasOnlyDocumentSignatures(fields);formInfo.hasAcroForm=hasFields&&!hasOnlyDocumentSignatures;formInfo.hasSignatures=hasSignatures;}catch(ex){if(ex instanceof _core_utils.MissingDataException){throw ex;}(0,_util.warn)("Cannot fetch form information: \"".concat(ex,"\"."));}return(0,_util.shadow)(this,"formInfo",formInfo);}},{key:"documentInfo",get:function get(){var docInfo={PDFFormatVersion:this.version,Language:this.catalog.lang,EncryptFilterName:this.xref.encrypt?this.xref.encrypt.filterName:null,IsLinearized:!!this.linearization,IsAcroFormPresent:this.formInfo.hasAcroForm,IsXFAPresent:this.formInfo.hasXfa,IsCollectionPresent:!!this.catalog.collection,IsSignaturesPresent:this.formInfo.hasSignatures};var infoDict;try{infoDict=this.xref.trailer.get("Info");}catch(err){if(err instanceof _core_utils.MissingDataException){throw err;}(0,_util.info)("The document information dictionary is invalid.");}if(!(infoDict instanceof _primitives.Dict)){return(0,_util.shadow)(this,"documentInfo",docInfo);}var _iterator14=_createForOfIteratorHelper(infoDict.getKeys()),_step14;try{for(_iterator14.s();!(_step14=_iterator14.n()).done;){var key=_step14.value;var value=infoDict.get(key);switch(key){case"Title":case"Author":case"Subject":case"Keywords":case"Creator":case"Producer":case"CreationDate":case"ModDate":if(typeof value==="string"){docInfo[key]=(0,_util.stringToPDFString)(value);continue;}break;case"Trapped":if(value instanceof _primitives.Name){docInfo[key]=value;continue;}break;default:var customValue=void 0;switch(_typeof(value)){case"string":customValue=(0,_util.stringToPDFString)(value);break;case"number":case"boolean":customValue=value;break;default:if(value instanceof _primitives.Name){customValue=value;}break;}if(customValue===undefined){(0,_util.warn)("Bad value, for custom key \"".concat(key,"\", in Info: ").concat(value,"."));continue;}if(!docInfo.Custom){docInfo.Custom=Object.create(null);}docInfo.Custom[key]=customValue;continue;}(0,_util.warn)("Bad value, for key \"".concat(key,"\", in Info: ").concat(value,"."));}}catch(err){_iterator14.e(err);}finally{_iterator14.f();}return(0,_util.shadow)(this,"documentInfo",docInfo);}},{key:"fingerprints",get:function get(){function validate(data){return typeof data==="string"&&data.length>0&&data!==EMPTY_FINGERPRINT;}function hexString(hash){var buf=[];var _iterator15=_createForOfIteratorHelper(hash),_step15;try{for(_iterator15.s();!(_step15=_iterator15.n()).done;){var num=_step15.value;var hex=num.toString(16);buf.push(hex.padStart(2,"0"));}}catch(err){_iterator15.e(err);}finally{_iterator15.f();}return buf.join("");}var idArray=this.xref.trailer.get("ID");var hashOriginal,hashModified;if(Array.isArray(idArray)&&validate(idArray[0])){hashOriginal=(0,_util.stringToBytes)(idArray[0]);if(idArray[1]!==idArray[0]&&validate(idArray[1])){hashModified=(0,_util.stringToBytes)(idArray[1]);}}else{hashOriginal=(0,_crypto.calculateMD5)(this.stream.getByteRange(0,FINGERPRINT_FIRST_BYTES),0,FINGERPRINT_FIRST_BYTES);}return(0,_util.shadow)(this,"fingerprints",[hexString(hashOriginal),hashModified?hexString(hashModified):null]);}},{key:"_getLinearizationPage",value:function(){var _getLinearizationPage2=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee7(pageIndex){var catalog,linearization,xref,ref,obj,type;return _regeneratorRuntime().wrap(function _callee7$(_context7){while(1)switch(_context7.prev=_context7.next){case 0:catalog=this.catalog,linearization=this.linearization,xref=this.xref;ref=_primitives.Ref.get(linearization.objectNumberFirst,0);_context7.prev=2;_context7.next=5;return xref.fetchAsync(ref);case 5:obj=_context7.sent;if(!(obj instanceof _primitives.Dict)){_context7.next=16;break;}type=obj.getRaw("Type");if(!(type instanceof _primitives.Ref)){_context7.next=12;break;}_context7.next=11;return xref.fetchAsync(type);case 11:type=_context7.sent;case 12:if(!((0,_primitives.isName)(type,"Page")||!obj.has("Type")&&!obj.has("Kids"))){_context7.next=16;break;}if(!catalog.pageKidsCountCache.has(ref)){catalog.pageKidsCountCache.put(ref,1);}if(!catalog.pageIndexCache.has(ref)){catalog.pageIndexCache.put(ref,0);}return _context7.abrupt("return",[obj,ref]);case 16:throw new _util.FormatError("The Linearization dictionary doesn't point to a valid Page dictionary.");case 19:_context7.prev=19;_context7.t0=_context7["catch"](2);(0,_util.warn)("_getLinearizationPage: \"".concat(_context7.t0.message,"\"."));return _context7.abrupt("return",catalog.getPageDict(pageIndex));case 23:case"end":return _context7.stop();}},_callee7,this,[[2,19]]);}));function _getLinearizationPage(_x11){return _getLinearizationPage2.apply(this,arguments);}return _getLinearizationPage;}()},{key:"getPage",value:function getPage(pageIndex){var _this7=this;var cachedPromise=this._pagePromises.get(pageIndex);if(cachedPromise){return cachedPromise;}var catalog=this.catalog,linearization=this.linearization,xfaFactory=this.xfaFactory;var promise;if(xfaFactory){promise=Promise.resolve([_primitives.Dict.empty,null]);}else if((linearization===null||linearization===void 0?void 0:linearization.pageFirst)===pageIndex){promise=this._getLinearizationPage(pageIndex);}else{promise=catalog.getPageDict(pageIndex);}promise=promise.then(function(_ref11){var _ref12=_slicedToArray(_ref11,2),pageDict=_ref12[0],ref=_ref12[1];return new Page({pdfManager:_this7.pdfManager,xref:_this7.xref,pageIndex:pageIndex,pageDict:pageDict,ref:ref,globalIdFactory:_this7._globalIdFactory,fontCache:catalog.fontCache,builtInCMapCache:catalog.builtInCMapCache,standardFontDataCache:catalog.standardFontDataCache,globalImageCache:catalog.globalImageCache,systemFontCache:catalog.systemFontCache,nonBlendModesSet:catalog.nonBlendModesSet,xfaFactory:xfaFactory});});this._pagePromises.set(pageIndex,promise);return promise;}},{key:"checkFirstPage",value:function(){var _checkFirstPage=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee8(){var recoveryMode,_args8=arguments;return _regeneratorRuntime().wrap(function _callee8$(_context8){while(1)switch(_context8.prev=_context8.next){case 0:recoveryMode=_args8.length>0&&_args8[0]!==undefined?_args8[0]:false;if(!recoveryMode){_context8.next=3;break;}return _context8.abrupt("return");case 3:_context8.prev=3;_context8.next=6;return this.getPage(0);case 6:_context8.next=15;break;case 8:_context8.prev=8;_context8.t0=_context8["catch"](3);if(!(_context8.t0 instanceof _core_utils.XRefEntryException)){_context8.next=15;break;}this._pagePromises.delete(0);_context8.next=14;return this.cleanup();case 14:throw new _core_utils.XRefParseException();case 15:case"end":return _context8.stop();}},_callee8,this,[[3,8]]);}));function checkFirstPage(){return _checkFirstPage.apply(this,arguments);}return checkFirstPage;}()},{key:"checkLastPage",value:function(){var _checkLastPage=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee9(){var recoveryMode,catalog,pdfManager,numPages,pagesTree,_iterator16,_step16,_step16$value,pageIndex,_step16$value$,pageDict,ref,promise,_args9=arguments;return _regeneratorRuntime().wrap(function _callee9$(_context9){while(1)switch(_context9.prev=_context9.next){case 0:recoveryMode=_args9.length>0&&_args9[0]!==undefined?_args9[0]:false;catalog=this.catalog,pdfManager=this.pdfManager;catalog.setActualNumPages();_context9.prev=3;_context9.next=6;return Promise.all([pdfManager.ensureDoc("xfaFactory"),pdfManager.ensureDoc("linearization"),pdfManager.ensureCatalog("numPages")]);case 6:if(!this.xfaFactory){_context9.next=10;break;}return _context9.abrupt("return");case 10:if(this.linearization){numPages=this.linearization.numPages;}else{numPages=catalog.numPages;}case 11:if(Number.isInteger(numPages)){_context9.next=15;break;}throw new _util.FormatError("Page count is not an integer.");case 15:if(!(numPages<=1)){_context9.next=17;break;}return _context9.abrupt("return");case 17:_context9.next=19;return this.getPage(numPages-1);case 19:_context9.next=44;break;case 21:_context9.prev=21;_context9.t0=_context9["catch"](3);this._pagePromises.delete(numPages-1);_context9.next=26;return this.cleanup();case 26:if(!(_context9.t0 instanceof _core_utils.XRefEntryException&&!recoveryMode)){_context9.next=28;break;}throw new _core_utils.XRefParseException();case 28:(0,_util.warn)("checkLastPage - invalid /Pages tree /Count: ".concat(numPages,"."));_context9.prev=29;_context9.next=32;return catalog.getAllPageDicts(recoveryMode);case 32:pagesTree=_context9.sent;_context9.next=41;break;case 35:_context9.prev=35;_context9.t1=_context9["catch"](29);if(!(_context9.t1 instanceof _core_utils.XRefEntryException&&!recoveryMode)){_context9.next=39;break;}throw new _core_utils.XRefParseException();case 39:catalog.setActualNumPages(1);return _context9.abrupt("return");case 41:_iterator16=_createForOfIteratorHelper(pagesTree);try{for(_iterator16.s();!(_step16=_iterator16.n()).done;){_step16$value=_slicedToArray(_step16.value,2),pageIndex=_step16$value[0],_step16$value$=_slicedToArray(_step16$value[1],2),pageDict=_step16$value$[0],ref=_step16$value$[1];promise=void 0;if(pageDict instanceof Error){promise=Promise.reject(pageDict);promise.catch(function(){});}else{promise=Promise.resolve(new Page({pdfManager:pdfManager,xref:this.xref,pageIndex:pageIndex,pageDict:pageDict,ref:ref,globalIdFactory:this._globalIdFactory,fontCache:catalog.fontCache,builtInCMapCache:catalog.builtInCMapCache,standardFontDataCache:catalog.standardFontDataCache,globalImageCache:catalog.globalImageCache,systemFontCache:catalog.systemFontCache,nonBlendModesSet:catalog.nonBlendModesSet,xfaFactory:null}));}this._pagePromises.set(pageIndex,promise);}}catch(err){_iterator16.e(err);}finally{_iterator16.f();}catalog.setActualNumPages(pagesTree.size);case 44:case"end":return _context9.stop();}},_callee9,this,[[3,21],[29,35]]);}));function checkLastPage(){return _checkLastPage.apply(this,arguments);}return checkLastPage;}()},{key:"fontFallback",value:function fontFallback(id,handler){return this.catalog.fontFallback(id,handler);}},{key:"cleanup",value:function(){var _cleanup=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee10(){var manuallyTriggered,_args10=arguments;return _regeneratorRuntime().wrap(function _callee10$(_context10){while(1)switch(_context10.prev=_context10.next){case 0:manuallyTriggered=_args10.length>0&&_args10[0]!==undefined?_args10[0]:false;return _context10.abrupt("return",this.catalog?this.catalog.cleanup(manuallyTriggered):(0,_cleanup_helper.clearGlobalCaches)());case 2:case"end":return _context10.stop();}},_callee10,this);}));function cleanup(){return _cleanup.apply(this,arguments);}return cleanup;}()},{key:"_collectFieldObjects",value:function _collectFieldObjects(name,fieldRef,promises){var field=this.xref.fetchIfRef(fieldRef);if(field.has("T")){var partName=(0,_util.stringToPDFString)(field.get("T"));name=name===""?partName:"".concat(name,".").concat(partName);}if(!promises.has(name)){promises.set(name,[]);}promises.get(name).push(_annotation2.AnnotationFactory.create(this.xref,fieldRef,this.pdfManager,this._localIdFactory,true).then(function(annotation){return annotation===null||annotation===void 0?void 0:annotation.getFieldObject();}).catch(function(reason){(0,_util.warn)("_collectFieldObjects: \"".concat(reason,"\"."));return null;}));if(field.has("Kids")){var kids=field.get("Kids");var _iterator17=_createForOfIteratorHelper(kids),_step17;try{for(_iterator17.s();!(_step17=_iterator17.n()).done;){var kid=_step17.value;this._collectFieldObjects(name,kid,promises);}}catch(err){_iterator17.e(err);}finally{_iterator17.f();}}}},{key:"fieldObjects",get:function get(){if(!this.formInfo.hasFields){return(0,_util.shadow)(this,"fieldObjects",Promise.resolve(null));}var allFields=Object.create(null);var fieldPromises=new Map();var _iterator18=_createForOfIteratorHelper(this.catalog.acroForm.get("Fields")),_step18;try{for(_iterator18.s();!(_step18=_iterator18.n()).done;){var fieldRef=_step18.value;this._collectFieldObjects("",fieldRef,fieldPromises);}}catch(err){_iterator18.e(err);}finally{_iterator18.f();}var allPromises=[];var _iterator19=_createForOfIteratorHelper(fieldPromises),_step19;try{var _loop2=function _loop2(){var _step19$value=_slicedToArray(_step19.value,2),name=_step19$value[0],promises=_step19$value[1];allPromises.push(Promise.all(promises).then(function(fields){fields=fields.filter(function(field){return!!field;});if(fields.length>0){allFields[name]=fields;}}));};for(_iterator19.s();!(_step19=_iterator19.n()).done;){_loop2();}}catch(err){_iterator19.e(err);}finally{_iterator19.f();}return(0,_util.shadow)(this,"fieldObjects",Promise.all(allPromises).then(function(){return allFields;}));}},{key:"hasJSActions",get:function get(){var promise=this.pdfManager.ensureDoc("_parseHasJSActions");return(0,_util.shadow)(this,"hasJSActions",promise);}},{key:"_parseHasJSActions",value:function(){var _parseHasJSActions2=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee11(){var _yield$Promise$all,_yield$Promise$all2,catalogJsActions,fieldObjects;return _regeneratorRuntime().wrap(function _callee11$(_context11){while(1)switch(_context11.prev=_context11.next){case 0:_context11.next=2;return Promise.all([this.pdfManager.ensureCatalog("jsActions"),this.pdfManager.ensureDoc("fieldObjects")]);case 2:_yield$Promise$all=_context11.sent;_yield$Promise$all2=_slicedToArray(_yield$Promise$all,2);catalogJsActions=_yield$Promise$all2[0];fieldObjects=_yield$Promise$all2[1];if(!catalogJsActions){_context11.next=8;break;}return _context11.abrupt("return",true);case 8:if(!fieldObjects){_context11.next=10;break;}return _context11.abrupt("return",Object.values(fieldObjects).some(function(fieldObject){return fieldObject.some(function(object){return object.actions!==null;});}));case 10:return _context11.abrupt("return",false);case 11:case"end":return _context11.stop();}},_callee11,this);}));function _parseHasJSActions(){return _parseHasJSActions2.apply(this,arguments);}return _parseHasJSActions;}()},{key:"calculationOrderIds",get:function get(){var acroForm=this.catalog.acroForm;if(!(acroForm!==null&&acroForm!==void 0&&acroForm.has("CO"))){return(0,_util.shadow)(this,"calculationOrderIds",null);}var calculationOrder=acroForm.get("CO");if(!Array.isArray(calculationOrder)||calculationOrder.length===0){return(0,_util.shadow)(this,"calculationOrderIds",null);}var ids=[];var _iterator20=_createForOfIteratorHelper(calculationOrder),_step20;try{for(_iterator20.s();!(_step20=_iterator20.n()).done;){var id=_step20.value;if(id instanceof _primitives.Ref){ids.push(id.toString());}}}catch(err){_iterator20.e(err);}finally{_iterator20.f();}if(ids.length===0){return(0,_util.shadow)(this,"calculationOrderIds",null);}return(0,_util.shadow)(this,"calculationOrderIds",ids);}}]);return PDFDocument;}();exports.PDFDocument=PDFDocument;

/***/ }),
/* 359 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var $findIndex = (__w_pdfjs_require__(89).findIndex);
var addToUnscopables = __w_pdfjs_require__(138);
var FIND_INDEX = 'findIndex';
var SKIPS_HOLES = true;
if (FIND_INDEX in [])
 Array(1)[FIND_INDEX](function () {
  SKIPS_HOLES = false;
 });
$({
 target: 'Array',
 proto: true,
 forced: SKIPS_HOLES
}, {
 findIndex: function findIndex(callbackfn) {
  return $findIndex(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
 }
});
addToUnscopables(FIND_INDEX);

/***/ }),
/* 360 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var toObject = __w_pdfjs_require__(10);
var toAbsoluteIndex = __w_pdfjs_require__(69);
var toIntegerOrInfinity = __w_pdfjs_require__(70);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var setArrayLength = __w_pdfjs_require__(290);
var doesNotExceedSafeInteger = __w_pdfjs_require__(291);
var arraySpeciesCreate = __w_pdfjs_require__(92);
var createProperty = __w_pdfjs_require__(86);
var deletePropertyOrThrow = __w_pdfjs_require__(211);
var arrayMethodHasSpeciesSupport = __w_pdfjs_require__(181);
var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('splice');
var max = Math.max;
var min = Math.min;
$({
 target: 'Array',
 proto: true,
 forced: !HAS_SPECIES_SUPPORT
}, {
 splice: function splice(start, deleteCount) {
  var O = toObject(this);
  var len = lengthOfArrayLike(O);
  var actualStart = toAbsoluteIndex(start, len);
  var argumentsLength = arguments.length;
  var insertCount, actualDeleteCount, A, k, from, to;
  if (argumentsLength === 0) {
   insertCount = actualDeleteCount = 0;
  } else if (argumentsLength === 1) {
   insertCount = 0;
   actualDeleteCount = len - actualStart;
  } else {
   insertCount = argumentsLength - 2;
   actualDeleteCount = min(max(toIntegerOrInfinity(deleteCount), 0), len - actualStart);
  }
  doesNotExceedSafeInteger(len + insertCount - actualDeleteCount);
  A = arraySpeciesCreate(O, actualDeleteCount);
  for (k = 0; k < actualDeleteCount; k++) {
   from = actualStart + k;
   if (from in O)
    createProperty(A, k, O[from]);
  }
  A.length = actualDeleteCount;
  if (insertCount < actualDeleteCount) {
   for (k = actualStart; k < len - actualDeleteCount; k++) {
    from = k + actualDeleteCount;
    to = k + insertCount;
    if (from in O)
     O[to] = O[from];
    else
     deletePropertyOrThrow(O, to);
   }
   for (k = len; k > len - actualDeleteCount + insertCount; k--)
    deletePropertyOrThrow(O, k - 1);
  } else if (insertCount > actualDeleteCount) {
   for (k = len - actualDeleteCount; k > actualStart; k--) {
    from = k + actualDeleteCount - 1;
    to = k + insertCount - 1;
    if (from in O)
     O[to] = O[from];
    else
     deletePropertyOrThrow(O, to);
   }
  }
  for (k = 0; k < insertCount; k++) {
   O[k + actualStart] = arguments[k + 2];
  }
  setArrayLength(O, len - actualDeleteCount + insertCount);
  return A;
 }
});

/***/ }),
/* 361 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var assign = __w_pdfjs_require__(319);
$({
 target: 'Object',
 stat: true,
 arity: 2,
 forced: Object.assign !== assign
}, { assign: assign });

/***/ }),
/* 362 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var toObject = __w_pdfjs_require__(10);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var toIntegerOrInfinity = __w_pdfjs_require__(70);
var addToUnscopables = __w_pdfjs_require__(138);
$({
 target: 'Array',
 proto: true
}, {
 at: function at(index) {
  var O = toObject(this);
  var len = lengthOfArrayLike(O);
  var relativeIndex = toIntegerOrInfinity(index);
  var k = relativeIndex >= 0 ? relativeIndex : len + relativeIndex;
  return k < 0 || k >= len ? undefined : O[k];
 }
});
addToUnscopables('at');

/***/ }),
/* 363 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var uncurryThis = __w_pdfjs_require__(7);
var requireObjectCoercible = __w_pdfjs_require__(11);
var toIntegerOrInfinity = __w_pdfjs_require__(70);
var toString = __w_pdfjs_require__(77);
var fails = __w_pdfjs_require__(9);
var charAt = uncurryThis(''.charAt);
var FORCED = fails(function () {
 return '𠮷'.at(-2) !== '\uD842';
});
$({
 target: 'String',
 proto: true,
 forced: FORCED
}, {
 at: function at(index) {
  var S = toString(requireObjectCoercible(this));
  var len = S.length;
  var relativeIndex = toIntegerOrInfinity(index);
  var k = relativeIndex >= 0 ? relativeIndex : len + relativeIndex;
  return k < 0 || k >= len ? undefined : charAt(S, k);
 }
});

/***/ }),
/* 364 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


__w_pdfjs_require__(365);

/***/ }),
/* 365 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var collection = __w_pdfjs_require__(260);
var collectionWeak = __w_pdfjs_require__(341);
collection('WeakSet', function (init) {
 return function WeakSet() {
  return init(this, arguments.length ? arguments[0] : undefined);
 };
}, collectionWeak);

/***/ }),
/* 366 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

__w_pdfjs_require__(113);__w_pdfjs_require__(129);__w_pdfjs_require__(130);__w_pdfjs_require__(131);__w_pdfjs_require__(132);__w_pdfjs_require__(133);__w_pdfjs_require__(134);__w_pdfjs_require__(299);__w_pdfjs_require__(304);__w_pdfjs_require__(305);__w_pdfjs_require__(367);__w_pdfjs_require__(369);Object.defineProperty(exports, "__esModule", ({value:true}));exports.PopupAnnotation=exports.MarkupAnnotation=exports.AnnotationFactory=exports.AnnotationBorderStyle=exports.Annotation=void 0;exports.getQuadPoints=getQuadPoints;__w_pdfjs_require__(137);__w_pdfjs_require__(143);__w_pdfjs_require__(145);__w_pdfjs_require__(175);__w_pdfjs_require__(177);__w_pdfjs_require__(292);__w_pdfjs_require__(302);__w_pdfjs_require__(334);__w_pdfjs_require__(289);__w_pdfjs_require__(2);__w_pdfjs_require__(54);__w_pdfjs_require__(56);__w_pdfjs_require__(104);__w_pdfjs_require__(183);__w_pdfjs_require__(105);__w_pdfjs_require__(370);__w_pdfjs_require__(208);__w_pdfjs_require__(209);__w_pdfjs_require__(212);__w_pdfjs_require__(213);__w_pdfjs_require__(214);__w_pdfjs_require__(218);__w_pdfjs_require__(219);__w_pdfjs_require__(220);__w_pdfjs_require__(222);__w_pdfjs_require__(223);__w_pdfjs_require__(224);__w_pdfjs_require__(225);__w_pdfjs_require__(226);__w_pdfjs_require__(227);__w_pdfjs_require__(228);__w_pdfjs_require__(231);__w_pdfjs_require__(232);__w_pdfjs_require__(234);__w_pdfjs_require__(235);__w_pdfjs_require__(236);__w_pdfjs_require__(237);__w_pdfjs_require__(238);__w_pdfjs_require__(239);__w_pdfjs_require__(244);__w_pdfjs_require__(245);__w_pdfjs_require__(247);__w_pdfjs_require__(248);__w_pdfjs_require__(249);__w_pdfjs_require__(251);__w_pdfjs_require__(254);__w_pdfjs_require__(257);__w_pdfjs_require__(114);__w_pdfjs_require__(371);__w_pdfjs_require__(295);__w_pdfjs_require__(372);__w_pdfjs_require__(308);__w_pdfjs_require__(301);__w_pdfjs_require__(180);__w_pdfjs_require__(182);__w_pdfjs_require__(373);__w_pdfjs_require__(375);__w_pdfjs_require__(123);__w_pdfjs_require__(348);__w_pdfjs_require__(336);__w_pdfjs_require__(361);__w_pdfjs_require__(376);__w_pdfjs_require__(328);__w_pdfjs_require__(329);__w_pdfjs_require__(327);__w_pdfjs_require__(191);var _util=__w_pdfjs_require__(303);var _core_utils=__w_pdfjs_require__(342);var _default_appearance=__w_pdfjs_require__(377);var _primitives=__w_pdfjs_require__(349);var _stream=__w_pdfjs_require__(357);var _writer=__w_pdfjs_require__(448);var _base_stream=__w_pdfjs_require__(353);var _bidi=__w_pdfjs_require__(442);var _catalog=__w_pdfjs_require__(453);var _colorspace=__w_pdfjs_require__(379);var _file_spec=__w_pdfjs_require__(456);var _jpeg_stream=__w_pdfjs_require__(403);var _object_loader=__w_pdfjs_require__(459);var _operator_list=__w_pdfjs_require__(446);var _factory=__w_pdfjs_require__(460);function _get(){if(typeof Reflect!=="undefined"&&Reflect.get){_get=Reflect.get.bind();}else{_get=function _get(target,property,receiver){var base=_superPropBase(target,property);if(!base)return;var desc=Object.getOwnPropertyDescriptor(base,property);if(desc.get){return desc.get.call(arguments.length<3?target:receiver);}return desc.value;};}return _get.apply(this,arguments);}function _superPropBase(object,property){while(!Object.prototype.hasOwnProperty.call(object,property)){object=_getPrototypeOf(object);if(object===null)break;}return object;}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function");}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:true,configurable:true}});Object.defineProperty(subClass,"prototype",{writable:false});if(superClass)_setPrototypeOf(subClass,superClass);}function _setPrototypeOf(o,p){_setPrototypeOf=Object.setPrototypeOf?Object.setPrototypeOf.bind():function _setPrototypeOf(o,p){o.__proto__=p;return o;};return _setPrototypeOf(o,p);}function _createSuper(Derived){var hasNativeReflectConstruct=_isNativeReflectConstruct();return function _createSuperInternal(){var Super=_getPrototypeOf(Derived),result;if(hasNativeReflectConstruct){var NewTarget=_getPrototypeOf(this).constructor;result=Reflect.construct(Super,arguments,NewTarget);}else{result=Super.apply(this,arguments);}return _possibleConstructorReturn(this,result);};}function _possibleConstructorReturn(self,call){if(call&&(_typeof(call)==="object"||typeof call==="function")){return call;}else if(call!==void 0){throw new TypeError("Derived constructors may only return object or undefined");}return _assertThisInitialized(self);}function _assertThisInitialized(self){if(self===void 0){throw new ReferenceError("this hasn't been initialised - super() hasn't been called");}return self;}function _isNativeReflectConstruct(){if(typeof Reflect==="undefined"||!Reflect.construct)return false;if(Reflect.construct.sham)return false;if(typeof Proxy==="function")return true;try{Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}));return true;}catch(e){return false;}}function _getPrototypeOf(o){_getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf.bind():function _getPrototypeOf(o){return o.__proto__||Object.getPrototypeOf(o);};return _getPrototypeOf(o);}function _typeof(obj){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj;}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;},_typeof(obj);}function _regeneratorRuntime(){"use strict";/*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */_regeneratorRuntime=function _regeneratorRuntime(){return exports;};var exports={},Op=Object.prototype,hasOwn=Op.hasOwnProperty,defineProperty=Object.defineProperty||function(obj,key,desc){obj[key]=desc.value;},$Symbol="function"==typeof Symbol?Symbol:{},iteratorSymbol=$Symbol.iterator||"@@iterator",asyncIteratorSymbol=$Symbol.asyncIterator||"@@asyncIterator",toStringTagSymbol=$Symbol.toStringTag||"@@toStringTag";function define(obj,key,value){return Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}),obj[key];}try{define({},"");}catch(err){define=function define(obj,key,value){return obj[key]=value;};}function wrap(innerFn,outerFn,self,tryLocsList){var protoGenerator=outerFn&&outerFn.prototype instanceof Generator?outerFn:Generator,generator=Object.create(protoGenerator.prototype),context=new Context(tryLocsList||[]);return defineProperty(generator,"_invoke",{value:makeInvokeMethod(innerFn,self,context)}),generator;}function tryCatch(fn,obj,arg){try{return{type:"normal",arg:fn.call(obj,arg)};}catch(err){return{type:"throw",arg:err};}}exports.wrap=wrap;var ContinueSentinel={};function Generator(){}function GeneratorFunction(){}function GeneratorFunctionPrototype(){}var IteratorPrototype={};define(IteratorPrototype,iteratorSymbol,function(){return this;});var getProto=Object.getPrototypeOf,NativeIteratorPrototype=getProto&&getProto(getProto(values([])));NativeIteratorPrototype&&NativeIteratorPrototype!==Op&&hasOwn.call(NativeIteratorPrototype,iteratorSymbol)&&(IteratorPrototype=NativeIteratorPrototype);var Gp=GeneratorFunctionPrototype.prototype=Generator.prototype=Object.create(IteratorPrototype);function defineIteratorMethods(prototype){["next","throw","return"].forEach(function(method){define(prototype,method,function(arg){return this._invoke(method,arg);});});}function AsyncIterator(generator,PromiseImpl){function invoke(method,arg,resolve,reject){var record=tryCatch(generator[method],generator,arg);if("throw"!==record.type){var result=record.arg,value=result.value;return value&&"object"==_typeof(value)&&hasOwn.call(value,"__await")?PromiseImpl.resolve(value.__await).then(function(value){invoke("next",value,resolve,reject);},function(err){invoke("throw",err,resolve,reject);}):PromiseImpl.resolve(value).then(function(unwrapped){result.value=unwrapped,resolve(result);},function(error){return invoke("throw",error,resolve,reject);});}reject(record.arg);}var previousPromise;defineProperty(this,"_invoke",{value:function value(method,arg){function callInvokeWithMethodAndArg(){return new PromiseImpl(function(resolve,reject){invoke(method,arg,resolve,reject);});}return previousPromise=previousPromise?previousPromise.then(callInvokeWithMethodAndArg,callInvokeWithMethodAndArg):callInvokeWithMethodAndArg();}});}function makeInvokeMethod(innerFn,self,context){var state="suspendedStart";return function(method,arg){if("executing"===state)throw new Error("Generator is already running");if("completed"===state){if("throw"===method)throw arg;return doneResult();}for(context.method=method,context.arg=arg;;){var delegate=context.delegate;if(delegate){var delegateResult=maybeInvokeDelegate(delegate,context);if(delegateResult){if(delegateResult===ContinueSentinel)continue;return delegateResult;}}if("next"===context.method)context.sent=context._sent=context.arg;else if("throw"===context.method){if("suspendedStart"===state)throw state="completed",context.arg;context.dispatchException(context.arg);}else"return"===context.method&&context.abrupt("return",context.arg);state="executing";var record=tryCatch(innerFn,self,context);if("normal"===record.type){if(state=context.done?"completed":"suspendedYield",record.arg===ContinueSentinel)continue;return{value:record.arg,done:context.done};}"throw"===record.type&&(state="completed",context.method="throw",context.arg=record.arg);}};}function maybeInvokeDelegate(delegate,context){var methodName=context.method,method=delegate.iterator[methodName];if(undefined===method)return context.delegate=null,"throw"===methodName&&delegate.iterator.return&&(context.method="return",context.arg=undefined,maybeInvokeDelegate(delegate,context),"throw"===context.method)||"return"!==methodName&&(context.method="throw",context.arg=new TypeError("The iterator does not provide a '"+methodName+"' method")),ContinueSentinel;var record=tryCatch(method,delegate.iterator,context.arg);if("throw"===record.type)return context.method="throw",context.arg=record.arg,context.delegate=null,ContinueSentinel;var info=record.arg;return info?info.done?(context[delegate.resultName]=info.value,context.next=delegate.nextLoc,"return"!==context.method&&(context.method="next",context.arg=undefined),context.delegate=null,ContinueSentinel):info:(context.method="throw",context.arg=new TypeError("iterator result is not an object"),context.delegate=null,ContinueSentinel);}function pushTryEntry(locs){var entry={tryLoc:locs[0]};1 in locs&&(entry.catchLoc=locs[1]),2 in locs&&(entry.finallyLoc=locs[2],entry.afterLoc=locs[3]),this.tryEntries.push(entry);}function resetTryEntry(entry){var record=entry.completion||{};record.type="normal",delete record.arg,entry.completion=record;}function Context(tryLocsList){this.tryEntries=[{tryLoc:"root"}],tryLocsList.forEach(pushTryEntry,this),this.reset(!0);}function values(iterable){if(iterable){var iteratorMethod=iterable[iteratorSymbol];if(iteratorMethod)return iteratorMethod.call(iterable);if("function"==typeof iterable.next)return iterable;if(!isNaN(iterable.length)){var i=-1,next=function next(){for(;++i<iterable.length;)if(hasOwn.call(iterable,i))return next.value=iterable[i],next.done=!1,next;return next.value=undefined,next.done=!0,next;};return next.next=next;}}return{next:doneResult};}function doneResult(){return{value:undefined,done:!0};}return GeneratorFunction.prototype=GeneratorFunctionPrototype,defineProperty(Gp,"constructor",{value:GeneratorFunctionPrototype,configurable:!0}),defineProperty(GeneratorFunctionPrototype,"constructor",{value:GeneratorFunction,configurable:!0}),GeneratorFunction.displayName=define(GeneratorFunctionPrototype,toStringTagSymbol,"GeneratorFunction"),exports.isGeneratorFunction=function(genFun){var ctor="function"==typeof genFun&&genFun.constructor;return!!ctor&&(ctor===GeneratorFunction||"GeneratorFunction"===(ctor.displayName||ctor.name));},exports.mark=function(genFun){return Object.setPrototypeOf?Object.setPrototypeOf(genFun,GeneratorFunctionPrototype):(genFun.__proto__=GeneratorFunctionPrototype,define(genFun,toStringTagSymbol,"GeneratorFunction")),genFun.prototype=Object.create(Gp),genFun;},exports.awrap=function(arg){return{__await:arg};},defineIteratorMethods(AsyncIterator.prototype),define(AsyncIterator.prototype,asyncIteratorSymbol,function(){return this;}),exports.AsyncIterator=AsyncIterator,exports.async=function(innerFn,outerFn,self,tryLocsList,PromiseImpl){void 0===PromiseImpl&&(PromiseImpl=Promise);var iter=new AsyncIterator(wrap(innerFn,outerFn,self,tryLocsList),PromiseImpl);return exports.isGeneratorFunction(outerFn)?iter:iter.next().then(function(result){return result.done?result.value:iter.next();});},defineIteratorMethods(Gp),define(Gp,toStringTagSymbol,"Generator"),define(Gp,iteratorSymbol,function(){return this;}),define(Gp,"toString",function(){return"[object Generator]";}),exports.keys=function(val){var object=Object(val),keys=[];for(var key in object)keys.push(key);return keys.reverse(),function next(){for(;keys.length;){var key=keys.pop();if(key in object)return next.value=key,next.done=!1,next;}return next.done=!0,next;};},exports.values=values,Context.prototype={constructor:Context,reset:function reset(skipTempReset){if(this.prev=0,this.next=0,this.sent=this._sent=undefined,this.done=!1,this.delegate=null,this.method="next",this.arg=undefined,this.tryEntries.forEach(resetTryEntry),!skipTempReset)for(var name in this)"t"===name.charAt(0)&&hasOwn.call(this,name)&&!isNaN(+name.slice(1))&&(this[name]=undefined);},stop:function stop(){this.done=!0;var rootRecord=this.tryEntries[0].completion;if("throw"===rootRecord.type)throw rootRecord.arg;return this.rval;},dispatchException:function dispatchException(exception){if(this.done)throw exception;var context=this;function handle(loc,caught){return record.type="throw",record.arg=exception,context.next=loc,caught&&(context.method="next",context.arg=undefined),!!caught;}for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i],record=entry.completion;if("root"===entry.tryLoc)return handle("end");if(entry.tryLoc<=this.prev){var hasCatch=hasOwn.call(entry,"catchLoc"),hasFinally=hasOwn.call(entry,"finallyLoc");if(hasCatch&&hasFinally){if(this.prev<entry.catchLoc)return handle(entry.catchLoc,!0);if(this.prev<entry.finallyLoc)return handle(entry.finallyLoc);}else if(hasCatch){if(this.prev<entry.catchLoc)return handle(entry.catchLoc,!0);}else{if(!hasFinally)throw new Error("try statement without catch or finally");if(this.prev<entry.finallyLoc)return handle(entry.finallyLoc);}}}},abrupt:function abrupt(type,arg){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.tryLoc<=this.prev&&hasOwn.call(entry,"finallyLoc")&&this.prev<entry.finallyLoc){var finallyEntry=entry;break;}}finallyEntry&&("break"===type||"continue"===type)&&finallyEntry.tryLoc<=arg&&arg<=finallyEntry.finallyLoc&&(finallyEntry=null);var record=finallyEntry?finallyEntry.completion:{};return record.type=type,record.arg=arg,finallyEntry?(this.method="next",this.next=finallyEntry.finallyLoc,ContinueSentinel):this.complete(record);},complete:function complete(record,afterLoc){if("throw"===record.type)throw record.arg;return"break"===record.type||"continue"===record.type?this.next=record.arg:"return"===record.type?(this.rval=this.arg=record.arg,this.method="return",this.next="end"):"normal"===record.type&&afterLoc&&(this.next=afterLoc),ContinueSentinel;},finish:function finish(finallyLoc){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.finallyLoc===finallyLoc)return this.complete(entry.completion,entry.afterLoc),resetTryEntry(entry),ContinueSentinel;}},catch:function _catch(tryLoc){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.tryLoc===tryLoc){var record=entry.completion;if("throw"===record.type){var thrown=record.arg;resetTryEntry(entry);}return thrown;}}throw new Error("illegal catch attempt");},delegateYield:function delegateYield(iterable,resultName,nextLoc){return this.delegate={iterator:values(iterable),resultName:resultName,nextLoc:nextLoc},"next"===this.method&&(this.arg=undefined),ContinueSentinel;}},exports;}function _createForOfIteratorHelper(o,allowArrayLike){var it=typeof Symbol!=="undefined"&&o[Symbol.iterator]||o["@@iterator"];if(!it){if(Array.isArray(o)||(it=_unsupportedIterableToArray(o))||allowArrayLike&&o&&typeof o.length==="number"){if(it)o=it;var i=0;var F=function F(){};return{s:F,n:function n(){if(i>=o.length)return{done:true};return{done:false,value:o[i++]};},e:function e(_e2){throw _e2;},f:F};}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}var normalCompletion=true,didErr=false,err;return{s:function s(){it=it.call(o);},n:function n(){var step=it.next();normalCompletion=step.done;return step;},e:function e(_e3){didErr=true;err=_e3;},f:function f(){try{if(!normalCompletion&&it.return!=null)it.return();}finally{if(didErr)throw err;}}};}function asyncGeneratorStep(gen,resolve,reject,_next,_throw,key,arg){try{var info=gen[key](arg);var value=info.value;}catch(error){reject(error);return;}if(info.done){resolve(value);}else{Promise.resolve(value).then(_next,_throw);}}function _asyncToGenerator(fn){return function(){var self=this,args=arguments;return new Promise(function(resolve,reject){var gen=fn.apply(self,args);function _next(value){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"next",value);}function _throw(err){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"throw",err);}_next(undefined);});};}function _slicedToArray(arr,i){return _arrayWithHoles(arr)||_iterableToArrayLimit(arr,i)||_unsupportedIterableToArray(arr,i)||_nonIterableRest();}function _nonIterableRest(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}function _unsupportedIterableToArray(o,minLen){if(!o)return;if(typeof o==="string")return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);if(n==="Object"&&o.constructor)n=o.constructor.name;if(n==="Map"||n==="Set")return Array.from(o);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return _arrayLikeToArray(o,minLen);}function _arrayLikeToArray(arr,len){if(len==null||len>arr.length)len=arr.length;for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2;}function _iterableToArrayLimit(arr,i){var _i=null==arr?null:"undefined"!=typeof Symbol&&arr[Symbol.iterator]||arr["@@iterator"];if(null!=_i){var _s,_e,_x,_r,_arr=[],_n=!0,_d=!1;try{if(_x=(_i=_i.call(arr)).next,0===i){if(Object(_i)!==_i)return;_n=!1;}else for(;!(_n=(_s=_x.call(_i)).done)&&(_arr.push(_s.value),_arr.length!==i);_n=!0);}catch(err){_d=!0,_e=err;}finally{try{if(!_n&&null!=_i.return&&(_r=_i.return(),Object(_r)!==_r))return;}finally{if(_d)throw _e;}}return _arr;}}function _arrayWithHoles(arr){if(Array.isArray(arr))return arr;}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}}function _createClass(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);Object.defineProperty(Constructor,"prototype",{writable:false});return Constructor;}function _toPropertyKey(arg){var key=_toPrimitive(arg,"string");return _typeof(key)==="symbol"?key:String(key);}function _toPrimitive(input,hint){if(_typeof(input)!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(_typeof(res)!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.");}return(hint==="string"?String:Number)(input);}var AnnotationFactory=/*#__PURE__*/function(){function AnnotationFactory(){_classCallCheck(this,AnnotationFactory);}_createClass(AnnotationFactory,null,[{key:"create",value:function create(xref,ref,pdfManager,idFactory,collectFields){var _this=this;return Promise.all([pdfManager.ensureCatalog("acroForm"),pdfManager.ensureCatalog("baseUrl"),pdfManager.ensureCatalog("attachments"),pdfManager.ensureDoc("xfaDatasets"),collectFields?this._getPageIndex(xref,ref,pdfManager):-1]).then(function(_ref){var _ref2=_slicedToArray(_ref,5),acroForm=_ref2[0],baseUrl=_ref2[1],attachments=_ref2[2],xfaDatasets=_ref2[3],pageIndex=_ref2[4];return pdfManager.ensure(_this,"_create",[xref,ref,pdfManager,idFactory,acroForm,attachments,xfaDatasets,collectFields,pageIndex]);});}},{key:"_create",value:function _create(xref,ref,pdfManager,idFactory,acroForm){var attachments=arguments.length>5&&arguments[5]!==undefined?arguments[5]:null;var xfaDatasets=arguments.length>6?arguments[6]:undefined;var collectFields=arguments.length>7?arguments[7]:undefined;var pageIndex=arguments.length>8&&arguments[8]!==undefined?arguments[8]:-1;var dict=xref.fetchIfRef(ref);if(!(dict instanceof _primitives.Dict)){return undefined;}var id=ref instanceof _primitives.Ref?ref.toString():"annot_".concat(idFactory.createObjId());var subtype=dict.get("Subtype");subtype=subtype instanceof _primitives.Name?subtype.name:null;var acroFormDict=acroForm instanceof _primitives.Dict?acroForm:_primitives.Dict.empty;var parameters={xref:xref,ref:ref,dict:dict,subtype:subtype,id:id,pdfManager:pdfManager,acroForm:acroFormDict,attachments:attachments,xfaDatasets:xfaDatasets,collectFields:collectFields,needAppearances:!collectFields&&acroFormDict.get("NeedAppearances")===true,pageIndex:pageIndex,evaluatorOptions:pdfManager.evaluatorOptions};switch(subtype){case"Link":return new LinkAnnotation(parameters);case"Text":return new TextAnnotation(parameters);case"Widget":var fieldType=(0,_core_utils.getInheritableProperty)({dict:dict,key:"FT"});fieldType=fieldType instanceof _primitives.Name?fieldType.name:null;switch(fieldType){case"Tx":return new TextWidgetAnnotation(parameters);case"Btn":return new ButtonWidgetAnnotation(parameters);case"Ch":return new ChoiceWidgetAnnotation(parameters);case"Sig":if(self.showUnverifiedSignatures){(0,_util.info)("The PDF file contains a signature. Please take into account that it can't be verified yet. ngx-extended-pdf-viewer also displays forged signatures, so use this feature only if you're sure what you're doing.");return new SignatureWidgetAnnotation(parameters);}}(0,_util.warn)("Unimplemented widget field type \"".concat(fieldType,"\", ")+"falling back to base field type.");return new WidgetAnnotation(parameters);case"Popup":return new PopupAnnotation(parameters);case"FreeText":return new FreeTextAnnotation(parameters);case"Line":return new LineAnnotation(parameters);case"Square":return new SquareAnnotation(parameters);case"Circle":return new CircleAnnotation(parameters);case"PolyLine":return new PolylineAnnotation(parameters);case"Polygon":return new PolygonAnnotation(parameters);case"Caret":return new CaretAnnotation(parameters);case"Ink":return new InkAnnotation(parameters);case"Highlight":return new HighlightAnnotation(parameters);case"Underline":return new UnderlineAnnotation(parameters);case"Squiggly":return new SquigglyAnnotation(parameters);case"StrikeOut":return new StrikeOutAnnotation(parameters);case"Stamp":return new StampAnnotation(parameters);case"FileAttachment":return new FileAttachmentAnnotation(parameters);default:if(!collectFields){if(!subtype){(0,_util.warn)("Annotation is missing the required /Subtype.");}else{(0,_util.warn)("Unimplemented annotation type \"".concat(subtype,"\", ")+"falling back to base annotation.");}}return new Annotation(parameters);}}},{key:"_getPageIndex",value:function(){var _getPageIndex2=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee(xref,ref,pdfManager){var annotDict,pageRef,pageIndex,numPages,_pageIndex,page,annotations,_iterator,_step,annotRef;return _regeneratorRuntime().wrap(function _callee$(_context){while(1)switch(_context.prev=_context.next){case 0:_context.prev=0;_context.next=3;return xref.fetchIfRefAsync(ref);case 3:annotDict=_context.sent;if(annotDict instanceof _primitives.Dict){_context.next=6;break;}return _context.abrupt("return",-1);case 6:pageRef=annotDict.getRaw("P");if(!(pageRef instanceof _primitives.Ref)){_context.next=18;break;}_context.prev=8;_context.next=11;return pdfManager.ensureCatalog("getPageIndex",[pageRef]);case 11:pageIndex=_context.sent;return _context.abrupt("return",pageIndex);case 15:_context.prev=15;_context.t0=_context["catch"](8);(0,_util.info)("_getPageIndex -- not a valid page reference: \"".concat(_context.t0,"\"."));case 18:if(!annotDict.has("Kids")){_context.next=20;break;}return _context.abrupt("return",-1);case 20:_context.next=22;return pdfManager.ensureDoc("numPages");case 22:numPages=_context.sent;_pageIndex=0;case 24:if(!(_pageIndex<numPages)){_context.next=51;break;}_context.next=27;return pdfManager.getPage(_pageIndex);case 27:page=_context.sent;_context.next=30;return pdfManager.ensure(page,"annotations");case 30:annotations=_context.sent;_iterator=_createForOfIteratorHelper(annotations);_context.prev=32;_iterator.s();case 34:if((_step=_iterator.n()).done){_context.next=40;break;}annotRef=_step.value;if(!(annotRef instanceof _primitives.Ref&&(0,_primitives.isRefsEqual)(annotRef,ref))){_context.next=38;break;}return _context.abrupt("return",_pageIndex);case 38:_context.next=34;break;case 40:_context.next=45;break;case 42:_context.prev=42;_context.t1=_context["catch"](32);_iterator.e(_context.t1);case 45:_context.prev=45;_iterator.f();return _context.finish(45);case 48:_pageIndex++;_context.next=24;break;case 51:_context.next=56;break;case 53:_context.prev=53;_context.t2=_context["catch"](0);(0,_util.warn)("_getPageIndex: \"".concat(_context.t2,"\"."));case 56:return _context.abrupt("return",-1);case 57:case"end":return _context.stop();}},_callee,null,[[0,53],[8,15],[32,42,45,48]]);}));function _getPageIndex(_x2,_x3,_x4){return _getPageIndex2.apply(this,arguments);}return _getPageIndex;}()},{key:"generateImages",value:function generateImages(annotations,xref,isOffscreenCanvasSupported){if(!isOffscreenCanvasSupported){(0,_util.warn)("generateImages: OffscreenCanvas is not supported, cannot save or print some annotations with images.");return null;}var imagePromises;var _iterator2=_createForOfIteratorHelper(annotations),_step2;try{for(_iterator2.s();!(_step2=_iterator2.n()).done;){var _step2$value=_step2.value,bitmapId=_step2$value.bitmapId,bitmap=_step2$value.bitmap;if(!bitmap){continue;}imagePromises||(imagePromises=new Map());imagePromises.set(bitmapId,StampAnnotation.createImage(bitmap,xref));}}catch(err){_iterator2.e(err);}finally{_iterator2.f();}return imagePromises;}},{key:"saveNewAnnotations",value:function(){var _saveNewAnnotations=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee2(evaluator,task,annotations,imagePromises){var xref,baseFontRef,dependencies,promises,isOffscreenCanvasSupported,_iterator3,_step3,annotation,baseFont,buffer,transform,image,imageStream,smaskStream,_buffer,smaskRef,_transform,imageRef,_transform2;return _regeneratorRuntime().wrap(function _callee2$(_context2){while(1)switch(_context2.prev=_context2.next){case 0:xref=evaluator.xref;dependencies=[];promises=[];isOffscreenCanvasSupported=evaluator.options.isOffscreenCanvasSupported;_iterator3=_createForOfIteratorHelper(annotations);_context2.prev=5;_iterator3.s();case 7:if((_step3=_iterator3.n()).done){_context2.next=56;break;}annotation=_step3.value;if(!annotation.deleted){_context2.next=11;break;}return _context2.abrupt("continue",54);case 11:_context2.t0=annotation.annotationType;_context2.next=_context2.t0===_util.AnnotationEditorType.FREETEXT?14:_context2.t0===_util.AnnotationEditorType.INK?28:_context2.t0===_util.AnnotationEditorType.STAMP?30:54;break;case 14:if(baseFontRef){_context2.next=26;break;}baseFont=new _primitives.Dict(xref);baseFont.set("BaseFont",_primitives.Name.get("Helvetica"));baseFont.set("Type",_primitives.Name.get("Font"));baseFont.set("Subtype",_primitives.Name.get("Type1"));baseFont.set("Encoding",_primitives.Name.get("WinAnsiEncoding"));buffer=[];baseFontRef=xref.getNewTemporaryRef();transform=xref.encrypt?xref.encrypt.createCipherTransform(baseFontRef.num,baseFontRef.gen):null;_context2.next=25;return(0,_writer.writeObject)(baseFontRef,baseFont,buffer,transform);case 25:dependencies.push({ref:baseFontRef,data:buffer.join("")});case 26:promises.push(FreeTextAnnotation.createNewAnnotation(xref,annotation,dependencies,{evaluator:evaluator,task:task,baseFontRef:baseFontRef}));return _context2.abrupt("break",54);case 28:promises.push(InkAnnotation.createNewAnnotation(xref,annotation,dependencies));return _context2.abrupt("break",54);case 30:if(isOffscreenCanvasSupported){_context2.next=32;break;}return _context2.abrupt("break",54);case 32:_context2.next=34;return imagePromises.get(annotation.bitmapId);case 34:image=_context2.sent;if(!image.imageStream){_context2.next=52;break;}imageStream=image.imageStream,smaskStream=image.smaskStream;_buffer=[];if(!smaskStream){_context2.next=46;break;}smaskRef=xref.getNewTemporaryRef();_transform=xref.encrypt?xref.encrypt.createCipherTransform(smaskRef.num,smaskRef.gen):null;_context2.next=43;return(0,_writer.writeObject)(smaskRef,smaskStream,_buffer,_transform);case 43:dependencies.push({ref:smaskRef,data:_buffer.join("")});imageStream.dict.set("SMask",smaskRef);_buffer.length=0;case 46:imageRef=image.imageRef=xref.getNewTemporaryRef();_transform2=xref.encrypt?xref.encrypt.createCipherTransform(imageRef.num,imageRef.gen):null;_context2.next=50;return(0,_writer.writeObject)(imageRef,imageStream,_buffer,_transform2);case 50:dependencies.push({ref:imageRef,data:_buffer.join("")});image.imageStream=image.smaskStream=null;case 52:promises.push(StampAnnotation.createNewAnnotation(xref,annotation,dependencies,{image:image}));return _context2.abrupt("break",54);case 54:_context2.next=7;break;case 56:_context2.next=61;break;case 58:_context2.prev=58;_context2.t1=_context2["catch"](5);_iterator3.e(_context2.t1);case 61:_context2.prev=61;_iterator3.f();return _context2.finish(61);case 64:_context2.next=66;return Promise.all(promises);case 66:_context2.t2=_context2.sent;_context2.t3=dependencies;return _context2.abrupt("return",{annotations:_context2.t2,dependencies:_context2.t3});case 69:case"end":return _context2.stop();}},_callee2,null,[[5,58,61,64]]);}));function saveNewAnnotations(_x5,_x6,_x7,_x8){return _saveNewAnnotations.apply(this,arguments);}return saveNewAnnotations;}()},{key:"printNewAnnotations",value:function(){var _printNewAnnotations=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee3(evaluator,task,annotations,imagePromises){var options,xref,promises,_iterator4,_step4,annotation,image,imageStream,smaskStream;return _regeneratorRuntime().wrap(function _callee3$(_context3){while(1)switch(_context3.prev=_context3.next){case 0:if(annotations){_context3.next=2;break;}return _context3.abrupt("return",null);case 2:options=evaluator.options,xref=evaluator.xref;promises=[];_iterator4=_createForOfIteratorHelper(annotations);_context3.prev=5;_iterator4.s();case 7:if((_step4=_iterator4.n()).done){_context3.next=28;break;}annotation=_step4.value;if(!annotation.deleted){_context3.next=11;break;}return _context3.abrupt("continue",26);case 11:_context3.t0=annotation.annotationType;_context3.next=_context3.t0===_util.AnnotationEditorType.FREETEXT?14:_context3.t0===_util.AnnotationEditorType.INK?16:_context3.t0===_util.AnnotationEditorType.STAMP?18:26;break;case 14:promises.push(FreeTextAnnotation.createNewPrintAnnotation(xref,annotation,{evaluator:evaluator,task:task,evaluatorOptions:options}));return _context3.abrupt("break",26);case 16:promises.push(InkAnnotation.createNewPrintAnnotation(xref,annotation,{evaluatorOptions:options}));return _context3.abrupt("break",26);case 18:if(options.isOffscreenCanvasSupported){_context3.next=20;break;}return _context3.abrupt("break",26);case 20:_context3.next=22;return imagePromises.get(annotation.bitmapId);case 22:image=_context3.sent;if(image.imageStream){imageStream=image.imageStream,smaskStream=image.smaskStream;if(smaskStream){imageStream.dict.set("SMask",smaskStream);}image.imageRef=new _jpeg_stream.JpegStream(imageStream,imageStream.length);image.imageStream=image.smaskStream=null;}promises.push(StampAnnotation.createNewPrintAnnotation(xref,annotation,{image:image,evaluatorOptions:options}));return _context3.abrupt("break",26);case 26:_context3.next=7;break;case 28:_context3.next=33;break;case 30:_context3.prev=30;_context3.t1=_context3["catch"](5);_iterator4.e(_context3.t1);case 33:_context3.prev=33;_iterator4.f();return _context3.finish(33);case 36:return _context3.abrupt("return",Promise.all(promises));case 37:case"end":return _context3.stop();}},_callee3,null,[[5,30,33,36]]);}));function printNewAnnotations(_x9,_x10,_x11,_x12){return _printNewAnnotations.apply(this,arguments);}return printNewAnnotations;}()}]);return AnnotationFactory;}();exports.AnnotationFactory=AnnotationFactory;function getRgbColor(color){var defaultColor=arguments.length>1&&arguments[1]!==undefined?arguments[1]:new Uint8ClampedArray(3);if(!Array.isArray(color)){return defaultColor;}var rgbColor=defaultColor||new Uint8ClampedArray(3);switch(color.length){case 0:return null;case 1:_colorspace.ColorSpace.singletons.gray.getRgbItem(color,0,rgbColor,0);return rgbColor;case 3:_colorspace.ColorSpace.singletons.rgb.getRgbItem(color,0,rgbColor,0);return rgbColor;case 4:_colorspace.ColorSpace.singletons.cmyk.getRgbItem(color,0,rgbColor,0);return rgbColor;default:return defaultColor;}}function getPdfColorArray(color){return Array.from(color,function(c){return c/255;});}function getQuadPoints(dict,rect){var quadPoints=dict.getArray("QuadPoints");if(!Array.isArray(quadPoints)||quadPoints.length===0||quadPoints.length%8>0){return null;}var quadPointsLists=[];for(var i=0,ii=quadPoints.length/8;i<ii;i++){var minX=Infinity,maxX=-Infinity,minY=Infinity,maxY=-Infinity;for(var j=i*8,jj=i*8+8;j<jj;j+=2){var x=quadPoints[j];var y=quadPoints[j+1];minX=Math.min(x,minX);maxX=Math.max(x,maxX);minY=Math.min(y,minY);maxY=Math.max(y,maxY);}if(rect!==null&&(minX<rect[0]||maxX>rect[2]||minY<rect[1]||maxY>rect[3])){return null;}quadPointsLists.push([{x:minX,y:maxY},{x:maxX,y:maxY},{x:minX,y:minY},{x:maxX,y:minY}]);}return quadPointsLists;}function getTransformMatrix(rect,bbox,matrix){var _Util$getAxialAligned=_util.Util.getAxialAlignedBoundingBox(bbox,matrix),_Util$getAxialAligned2=_slicedToArray(_Util$getAxialAligned,4),minX=_Util$getAxialAligned2[0],minY=_Util$getAxialAligned2[1],maxX=_Util$getAxialAligned2[2],maxY=_Util$getAxialAligned2[3];if(minX===maxX||minY===maxY){return[1,0,0,1,rect[0],rect[1]];}var xRatio=(rect[2]-rect[0])/(maxX-minX);var yRatio=(rect[3]-rect[1])/(maxY-minY);return[xRatio,0,0,yRatio,rect[0]-minX*xRatio,rect[1]-minY*yRatio];}var Annotation=/*#__PURE__*/function(){function Annotation(params){_classCallCheck(this,Annotation);var dict=params.dict,xref=params.xref;this.setTitle(dict.get("T"));this.setContents(dict.get("Contents"));this.setModificationDate(dict.get("M"));this.setFlags(dict.get("F"));this.setRectangle(dict.getArray("Rect"));this.setColor(dict.getArray("C"));this.setBorderStyle(dict);this.setAppearance(dict);this.setOptionalContent(dict);var MK=dict.get("MK");this.setBorderAndBackgroundColors(MK);this.setRotation(MK,dict);this.ref=params.ref instanceof _primitives.Ref?params.ref:null;this._streams=[];if(this.appearance){this._streams.push(this.appearance);}var isLocked=!!(this.flags&_util.AnnotationFlag.LOCKED);var isContentLocked=!!(this.flags&_util.AnnotationFlag.LOCKEDCONTENTS);this.data={annotationFlags:this.flags,borderStyle:this.borderStyle,color:this.color,backgroundColor:this.backgroundColor,borderColor:this.borderColor,rotation:this.rotation,contentsObj:this._contents,hasAppearance:!!this.appearance,id:params.id,modificationDate:this.modificationDate,rect:this.rectangle,subtype:params.subtype,hasOwnCanvas:false,noRotate:!!(this.flags&_util.AnnotationFlag.NOROTATE),noHTML:isLocked&&isContentLocked};if(params.collectFields){var kids=dict.get("Kids");if(Array.isArray(kids)){var kidIds=[];var _iterator5=_createForOfIteratorHelper(kids),_step5;try{for(_iterator5.s();!(_step5=_iterator5.n()).done;){var kid=_step5.value;if(kid instanceof _primitives.Ref){kidIds.push(kid.toString());}}}catch(err){_iterator5.e(err);}finally{_iterator5.f();}if(kidIds.length!==0){this.data.kidIds=kidIds;}}this.data.actions=(0,_core_utils.collectActions)(xref,dict,_util.AnnotationActionEventType);this.data.fieldName=this._constructFieldName(dict);this.data.pageIndex=params.pageIndex;}this._isOffscreenCanvasSupported=params.evaluatorOptions.isOffscreenCanvasSupported;this._fallbackFontDict=null;this._needAppearances=false;}_createClass(Annotation,[{key:"_hasFlag",value:function _hasFlag(flags,flag){return!!(flags&flag);}},{key:"_isViewable",value:function _isViewable(flags){return!this._hasFlag(flags,_util.AnnotationFlag.INVISIBLE)&&!this._hasFlag(flags,_util.AnnotationFlag.NOVIEW);}},{key:"_isPrintable",value:function _isPrintable(flags){return this._hasFlag(flags,_util.AnnotationFlag.PRINT)&&!this._hasFlag(flags,_util.AnnotationFlag.HIDDEN)&&!this._hasFlag(flags,_util.AnnotationFlag.INVISIBLE);}},{key:"mustBeViewed",value:function mustBeViewed(annotationStorage,_renderForms){var _annotationStorage$ge;var noView=annotationStorage===null||annotationStorage===void 0||(_annotationStorage$ge=annotationStorage.get(this.data.id))===null||_annotationStorage$ge===void 0?void 0:_annotationStorage$ge.noView;if(noView!==undefined){return!noView;}return this.viewable&&!this._hasFlag(this.flags,_util.AnnotationFlag.HIDDEN);}},{key:"mustBePrinted",value:function mustBePrinted(annotationStorage){var _annotationStorage$ge2;var noPrint=annotationStorage===null||annotationStorage===void 0||(_annotationStorage$ge2=annotationStorage.get(this.data.id))===null||_annotationStorage$ge2===void 0?void 0:_annotationStorage$ge2.noPrint;if(noPrint!==undefined){return!noPrint;}return this.printable;}},{key:"viewable",get:function get(){if(this.data.quadPoints===null){return false;}if(this.flags===0){return true;}return this._isViewable(this.flags);}},{key:"printable",get:function get(){if(this.data.quadPoints===null){return false;}if(this.flags===0){return false;}return this._isPrintable(this.flags);}},{key:"_parseStringHelper",value:function _parseStringHelper(data){var str=typeof data==="string"?(0,_util.stringToPDFString)(data):"";var dir=str&&(0,_bidi.bidi)(str).dir==="rtl"?"rtl":"ltr";return{str:str,dir:dir};}},{key:"setDefaultAppearance",value:function setDefaultAppearance(params){var defaultAppearance=(0,_core_utils.getInheritableProperty)({dict:params.dict,key:"DA"})||params.acroForm.get("DA");this._defaultAppearance=typeof defaultAppearance==="string"?defaultAppearance:"";this.data.defaultAppearanceData=(0,_default_appearance.parseDefaultAppearance)(this._defaultAppearance);}},{key:"setTitle",value:function setTitle(title){this._title=this._parseStringHelper(title);}},{key:"setContents",value:function setContents(contents){this._contents=this._parseStringHelper(contents);}},{key:"setModificationDate",value:function setModificationDate(modificationDate){this.modificationDate=typeof modificationDate==="string"?modificationDate:null;}},{key:"setFlags",value:function setFlags(flags){this.flags=Number.isInteger(flags)&&flags>0?flags:0;}},{key:"hasFlag",value:function hasFlag(flag){return this._hasFlag(this.flags,flag);}},{key:"setRectangle",value:function setRectangle(rectangle){this.rectangle=Array.isArray(rectangle)&&rectangle.length===4?_util.Util.normalizeRect(rectangle):[0,0,0,0];}},{key:"setColor",value:function setColor(color){this.color=getRgbColor(color);}},{key:"setLineEndings",value:function setLineEndings(lineEndings){this.lineEndings=["None","None"];if(Array.isArray(lineEndings)&&lineEndings.length===2){for(var i=0;i<2;i++){var obj=lineEndings[i];if(obj instanceof _primitives.Name){switch(obj.name){case"None":continue;case"Square":case"Circle":case"Diamond":case"OpenArrow":case"ClosedArrow":case"Butt":case"ROpenArrow":case"RClosedArrow":case"Slash":this.lineEndings[i]=obj.name;continue;}}(0,_util.warn)("Ignoring invalid lineEnding: ".concat(obj));}}}},{key:"setRotation",value:function setRotation(mk,dict){this.rotation=0;var angle=mk instanceof _primitives.Dict?mk.get("R")||0:dict.get("Rotate")||0;if(Number.isInteger(angle)&&angle!==0){angle%=360;if(angle<0){angle+=360;}if(angle%90===0){this.rotation=angle;}}}},{key:"setBorderAndBackgroundColors",value:function setBorderAndBackgroundColors(mk){if(mk instanceof _primitives.Dict){this.borderColor=getRgbColor(mk.getArray("BC"),null);this.backgroundColor=getRgbColor(mk.getArray("BG"),null);}else{this.borderColor=this.backgroundColor=null;}}},{key:"setBorderStyle",value:function setBorderStyle(borderStyle){this.borderStyle=new AnnotationBorderStyle();if(!(borderStyle instanceof _primitives.Dict)){return;}if(borderStyle.has("BS")){var dict=borderStyle.get("BS");var dictType=dict.get("Type");if(!dictType||(0,_primitives.isName)(dictType,"Border")){this.borderStyle.setWidth(dict.get("W"),this.rectangle);this.borderStyle.setStyle(dict.get("S"));this.borderStyle.setDashArray(dict.getArray("D"));}}else if(borderStyle.has("Border")){var array=borderStyle.getArray("Border");if(Array.isArray(array)&&array.length>=3){this.borderStyle.setHorizontalCornerRadius(array[0]);this.borderStyle.setVerticalCornerRadius(array[1]);this.borderStyle.setWidth(array[2],this.rectangle);if(array.length===4){this.borderStyle.setDashArray(array[3],true);}}}else{this.borderStyle.setWidth(0);}}},{key:"setAppearance",value:function setAppearance(dict){this.appearance=null;var appearanceStates=dict.get("AP");if(!(appearanceStates instanceof _primitives.Dict)){return;}var normalAppearanceState=appearanceStates.get("N");if(normalAppearanceState instanceof _base_stream.BaseStream){this.appearance=normalAppearanceState;return;}if(!(normalAppearanceState instanceof _primitives.Dict)){return;}var as=dict.get("AS");if(!(as instanceof _primitives.Name)||!normalAppearanceState.has(as.name)){return;}var appearance=normalAppearanceState.get(as.name);if(appearance instanceof _base_stream.BaseStream){this.appearance=appearance;}}},{key:"setOptionalContent",value:function setOptionalContent(dict){this.oc=null;var oc=dict.get("OC");if(oc instanceof _primitives.Name){(0,_util.warn)("setOptionalContent: Support for /Name-entry is not implemented.");}else if(oc instanceof _primitives.Dict){this.oc=oc;}}},{key:"loadResources",value:function loadResources(keys,appearance){return appearance.dict.getAsync("Resources").then(function(resources){if(!resources){return undefined;}var objectLoader=new _object_loader.ObjectLoader(resources,keys,resources.xref);return objectLoader.load().then(function(){return resources;});});}},{key:"getOperatorList",value:function(){var _getOperatorList=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee4(evaluator,task,intent,renderForms,annotationStorage){var data,appearance,isUsingOwnCanvas,appearanceDict,resources,bbox,matrix,transform,opList,optionalContent;return _regeneratorRuntime().wrap(function _callee4$(_context4){while(1)switch(_context4.prev=_context4.next){case 0:data=this.data;appearance=this.appearance;isUsingOwnCanvas=!!(this.data.hasOwnCanvas&&intent&_util.RenderingIntentFlag.DISPLAY);if(appearance){_context4.next=8;break;}if(isUsingOwnCanvas){_context4.next=6;break;}return _context4.abrupt("return",{opList:new _operator_list.OperatorList(),separateForm:false,separateCanvas:false});case 6:appearance=new _stream.StringStream("");appearance.dict=new _primitives.Dict();case 8:appearanceDict=appearance.dict;_context4.next=11;return this.loadResources(["ExtGState","ColorSpace","Pattern","Shading","XObject","Font"],appearance);case 11:resources=_context4.sent;bbox=appearanceDict.getArray("BBox")||[0,0,1,1];matrix=appearanceDict.getArray("Matrix")||[1,0,0,1,0,0];transform=getTransformMatrix(data.rect,bbox,matrix);opList=new _operator_list.OperatorList();if(!this.oc){_context4.next=20;break;}_context4.next=19;return evaluator.parseMarkedContentProps(this.oc,null);case 19:optionalContent=_context4.sent;case 20:if(optionalContent!==undefined){opList.addOp(_util.OPS.beginMarkedContentProps,["OC",optionalContent]);}opList.addOp(_util.OPS.beginAnnotation,[data.id,data.rect,transform,matrix,isUsingOwnCanvas]);_context4.next=24;return evaluator.getOperatorList({stream:appearance,task:task,resources:resources,operatorList:opList,fallbackFontDict:this._fallbackFontDict});case 24:opList.addOp(_util.OPS.endAnnotation,[]);if(optionalContent!==undefined){opList.addOp(_util.OPS.endMarkedContent,[]);}this.reset();return _context4.abrupt("return",{opList:opList,separateForm:false,separateCanvas:isUsingOwnCanvas});case 28:case"end":return _context4.stop();}},_callee4,this);}));function getOperatorList(_x13,_x14,_x15,_x16,_x17){return _getOperatorList.apply(this,arguments);}return getOperatorList;}()},{key:"save",value:function(){var _save=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee5(evaluator,task,annotationStorage){return _regeneratorRuntime().wrap(function _callee5$(_context5){while(1)switch(_context5.prev=_context5.next){case 0:return _context5.abrupt("return",null);case 1:case"end":return _context5.stop();}},_callee5);}));function save(_x18,_x19,_x20){return _save.apply(this,arguments);}return save;}()},{key:"hasTextContent",get:function get(){return false;}},{key:"extractTextContent",value:function(){var _extractTextContent=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee6(evaluator,task,viewBox){var resources,text,buffer,firstPosition,sink,appearanceDict,bbox,matrix,rect,transform;return _regeneratorRuntime().wrap(function _callee6$(_context6){while(1)switch(_context6.prev=_context6.next){case 0:if(this.appearance){_context6.next=2;break;}return _context6.abrupt("return");case 2:_context6.next=4;return this.loadResources(["ExtGState","Font","Properties","XObject"],this.appearance);case 4:resources=_context6.sent;text=[];buffer=[];firstPosition=null;sink={desiredSize:Math.Infinity,ready:true,enqueue:function enqueue(chunk,size){var _iterator6=_createForOfIteratorHelper(chunk.items),_step6;try{for(_iterator6.s();!(_step6=_iterator6.n()).done;){var item=_step6.value;if(item.str===undefined){continue;}firstPosition||(firstPosition=item.transform.slice(-2));buffer.push(item.str);if(item.hasEOL){text.push(buffer.join(""));buffer.length=0;}}}catch(err){_iterator6.e(err);}finally{_iterator6.f();}}};_context6.next=11;return evaluator.getTextContent({stream:this.appearance,task:task,resources:resources,includeMarkedContent:true,sink:sink,viewBox:viewBox});case 11:this.reset();if(buffer.length){text.push(buffer.join(""));}if(text.length>1||text[0]){appearanceDict=this.appearance.dict;bbox=appearanceDict.getArray("BBox")||[0,0,1,1];matrix=appearanceDict.getArray("Matrix")||[1,0,0,1,0,0];rect=this.data.rect;transform=getTransformMatrix(rect,bbox,matrix);transform[4]-=rect[0];transform[5]-=rect[1];firstPosition=_util.Util.applyTransform(firstPosition,transform);firstPosition=_util.Util.applyTransform(firstPosition,matrix);this.data.textPosition=firstPosition;this.data.textContent=text;}case 14:case"end":return _context6.stop();}},_callee6,this);}));function extractTextContent(_x21,_x22,_x23){return _extractTextContent.apply(this,arguments);}return extractTextContent;}()},{key:"getFieldObject",value:function getFieldObject(){if(this.data.kidIds){return{id:this.data.id,actions:this.data.actions,name:this.data.fieldName,strokeColor:this.data.borderColor,fillColor:this.data.backgroundColor,type:"",kidIds:this.data.kidIds,page:this.data.pageIndex,rotation:this.rotation};}return null;}},{key:"reset",value:function reset(){var _iterator7=_createForOfIteratorHelper(this._streams),_step7;try{for(_iterator7.s();!(_step7=_iterator7.n()).done;){var stream=_step7.value;stream.reset();}}catch(err){_iterator7.e(err);}finally{_iterator7.f();}}},{key:"_constructFieldName",value:function _constructFieldName(dict){if(!dict.has("T")&&!dict.has("Parent")){(0,_util.warn)("Unknown field name, falling back to empty field name.");return"";}if(!dict.has("Parent")){return(0,_util.stringToPDFString)(dict.get("T"));}var fieldName=[];if(dict.has("T")){fieldName.unshift((0,_util.stringToPDFString)(dict.get("T")));}var loopDict=dict;var visited=new _primitives.RefSet();if(dict.objId){visited.put(dict.objId);}while(loopDict.has("Parent")){loopDict=loopDict.get("Parent");if(!(loopDict instanceof _primitives.Dict)||loopDict.objId&&visited.has(loopDict.objId)){break;}if(loopDict.objId){visited.put(loopDict.objId);}if(loopDict.has("T")){var t=(0,_util.stringToPDFString)(loopDict.get("T"));if(!t.startsWith("#")){fieldName.unshift(t);}}}return fieldName.join(".");}}]);return Annotation;}();exports.Annotation=Annotation;var AnnotationBorderStyle=/*#__PURE__*/function(){function AnnotationBorderStyle(){_classCallCheck(this,AnnotationBorderStyle);this.width=1;this.style=_util.AnnotationBorderStyleType.SOLID;this.dashArray=[3];this.horizontalCornerRadius=0;this.verticalCornerRadius=0;}_createClass(AnnotationBorderStyle,[{key:"setWidth",value:function setWidth(width){var rect=arguments.length>1&&arguments[1]!==undefined?arguments[1]:[0,0,0,0];if(width instanceof _primitives.Name){this.width=0;return;}if(typeof width==="number"){if(width>0){var maxWidth=(rect[2]-rect[0])/2;var maxHeight=(rect[3]-rect[1])/2;if(maxWidth>0&&maxHeight>0&&(width>maxWidth||width>maxHeight)){(0,_util.warn)("AnnotationBorderStyle.setWidth - ignoring width: ".concat(width));width=1;}}this.width=width;}}},{key:"setStyle",value:function setStyle(style){if(!(style instanceof _primitives.Name)){return;}switch(style.name){case"S":this.style=_util.AnnotationBorderStyleType.SOLID;break;case"D":this.style=_util.AnnotationBorderStyleType.DASHED;break;case"B":this.style=_util.AnnotationBorderStyleType.BEVELED;break;case"I":this.style=_util.AnnotationBorderStyleType.INSET;break;case"U":this.style=_util.AnnotationBorderStyleType.UNDERLINE;break;default:break;}}},{key:"setDashArray",value:function setDashArray(dashArray){var forceStyle=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;if(Array.isArray(dashArray)&&dashArray.length>0){var isValid=true;var allZeros=true;var _iterator8=_createForOfIteratorHelper(dashArray),_step8;try{for(_iterator8.s();!(_step8=_iterator8.n()).done;){var element=_step8.value;var validNumber=+element>=0;if(!validNumber){isValid=false;break;}else if(element>0){allZeros=false;}}}catch(err){_iterator8.e(err);}finally{_iterator8.f();}if(isValid&&!allZeros){this.dashArray=dashArray;if(forceStyle){this.setStyle(_primitives.Name.get("D"));}}else{this.width=0;}}else if(dashArray){this.width=0;}}},{key:"setHorizontalCornerRadius",value:function setHorizontalCornerRadius(radius){if(Number.isInteger(radius)){this.horizontalCornerRadius=radius;}}},{key:"setVerticalCornerRadius",value:function setVerticalCornerRadius(radius){if(Number.isInteger(radius)){this.verticalCornerRadius=radius;}}}]);return AnnotationBorderStyle;}();exports.AnnotationBorderStyle=AnnotationBorderStyle;var MarkupAnnotation=/*#__PURE__*/function(_Annotation){_inherits(MarkupAnnotation,_Annotation);var _super=_createSuper(MarkupAnnotation);function MarkupAnnotation(params){var _this2;_classCallCheck(this,MarkupAnnotation);_this2=_super.call(this,params);var dict=params.dict;if(dict.has("IRT")){var rawIRT=dict.getRaw("IRT");_this2.data.inReplyTo=rawIRT instanceof _primitives.Ref?rawIRT.toString():null;var rt=dict.get("RT");_this2.data.replyType=rt instanceof _primitives.Name?rt.name:_util.AnnotationReplyType.REPLY;}var popupRef=null;if(_this2.data.replyType===_util.AnnotationReplyType.GROUP){var parent=dict.get("IRT");_this2.setTitle(parent.get("T"));_this2.data.titleObj=_this2._title;_this2.setContents(parent.get("Contents"));_this2.data.contentsObj=_this2._contents;if(!parent.has("CreationDate")){_this2.data.creationDate=null;}else{_this2.setCreationDate(parent.get("CreationDate"));_this2.data.creationDate=_this2.creationDate;}if(!parent.has("M")){_this2.data.modificationDate=null;}else{_this2.setModificationDate(parent.get("M"));_this2.data.modificationDate=_this2.modificationDate;}popupRef=parent.getRaw("Popup");if(!parent.has("C")){_this2.data.color=null;}else{_this2.setColor(parent.getArray("C"));_this2.data.color=_this2.color;}}else{_this2.data.titleObj=_this2._title;_this2.setCreationDate(dict.get("CreationDate"));_this2.data.creationDate=_this2.creationDate;popupRef=dict.getRaw("Popup");if(!dict.has("C")){_this2.data.color=null;}}_this2.data.popupRef=popupRef instanceof _primitives.Ref?popupRef.toString():null;if(dict.has("RC")){_this2.data.richText=_factory.XFAFactory.getRichTextAsHtml(dict.get("RC"));}return _this2;}_createClass(MarkupAnnotation,[{key:"setCreationDate",value:function setCreationDate(creationDate){this.creationDate=typeof creationDate==="string"?creationDate:null;}},{key:"_setDefaultAppearance",value:function _setDefaultAppearance(_ref3){var xref=_ref3.xref,extra=_ref3.extra,strokeColor=_ref3.strokeColor,fillColor=_ref3.fillColor,blendMode=_ref3.blendMode,strokeAlpha=_ref3.strokeAlpha,fillAlpha=_ref3.fillAlpha,pointsCallback=_ref3.pointsCallback;var minX=Number.MAX_VALUE;var minY=Number.MAX_VALUE;var maxX=Number.MIN_VALUE;var maxY=Number.MIN_VALUE;var buffer=["q"];if(extra){buffer.push(extra);}if(strokeColor){buffer.push("".concat(strokeColor[0]," ").concat(strokeColor[1]," ").concat(strokeColor[2]," RG"));}if(fillColor){buffer.push("".concat(fillColor[0]," ").concat(fillColor[1]," ").concat(fillColor[2]," rg"));}var pointsArray=this.data.quadPoints;if(!pointsArray){pointsArray=[[{x:this.rectangle[0],y:this.rectangle[3]},{x:this.rectangle[2],y:this.rectangle[3]},{x:this.rectangle[0],y:this.rectangle[1]},{x:this.rectangle[2],y:this.rectangle[1]}]];}var _iterator9=_createForOfIteratorHelper(pointsArray),_step9;try{for(_iterator9.s();!(_step9=_iterator9.n()).done;){var points=_step9.value;var _pointsCallback=pointsCallback(buffer,points),_pointsCallback2=_slicedToArray(_pointsCallback,4),mX=_pointsCallback2[0],MX=_pointsCallback2[1],mY=_pointsCallback2[2],MY=_pointsCallback2[3];minX=Math.min(minX,mX);maxX=Math.max(maxX,MX);minY=Math.min(minY,mY);maxY=Math.max(maxY,MY);}}catch(err){_iterator9.e(err);}finally{_iterator9.f();}buffer.push("Q");var formDict=new _primitives.Dict(xref);var appearanceStreamDict=new _primitives.Dict(xref);appearanceStreamDict.set("Subtype",_primitives.Name.get("Form"));var appearanceStream=new _stream.StringStream(buffer.join(" "));appearanceStream.dict=appearanceStreamDict;formDict.set("Fm0",appearanceStream);var gsDict=new _primitives.Dict(xref);if(blendMode){gsDict.set("BM",_primitives.Name.get(blendMode));}if(typeof strokeAlpha==="number"){gsDict.set("CA",strokeAlpha);}if(typeof fillAlpha==="number"){gsDict.set("ca",fillAlpha);}var stateDict=new _primitives.Dict(xref);stateDict.set("GS0",gsDict);var resources=new _primitives.Dict(xref);resources.set("ExtGState",stateDict);resources.set("XObject",formDict);var appearanceDict=new _primitives.Dict(xref);appearanceDict.set("Resources",resources);var bbox=this.data.rect=[minX,minY,maxX,maxY];appearanceDict.set("BBox",bbox);this.appearance=new _stream.StringStream("/GS0 gs /Fm0 Do");this.appearance.dict=appearanceDict;this._streams.push(this.appearance,appearanceStream);}}],[{key:"createNewAnnotation",value:function(){var _createNewAnnotation=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee7(xref,annotation,dependencies,params){var annotationRef,ap,buffer,annotationDict,apRef,_transform3,transform;return _regeneratorRuntime().wrap(function _callee7$(_context7){while(1)switch(_context7.prev=_context7.next){case 0:annotationRef=annotation.ref||xref.getNewTemporaryRef();_context7.next=3;return this.createNewAppearanceStream(annotation,xref,params);case 3:ap=_context7.sent;buffer=[];if(!ap){_context7.next=14;break;}apRef=xref.getNewTemporaryRef();annotationDict=this.createNewDict(annotation,xref,{apRef:apRef});_transform3=xref.encrypt?xref.encrypt.createCipherTransform(apRef.num,apRef.gen):null;_context7.next=11;return(0,_writer.writeObject)(apRef,ap,buffer,_transform3);case 11:dependencies.push({ref:apRef,data:buffer.join("")});_context7.next=15;break;case 14:annotationDict=this.createNewDict(annotation,xref,{});case 15:buffer.length=0;transform=xref.encrypt?xref.encrypt.createCipherTransform(annotationRef.num,annotationRef.gen):null;_context7.next=19;return(0,_writer.writeObject)(annotationRef,annotationDict,buffer,transform);case 19:return _context7.abrupt("return",{ref:annotationRef,data:buffer.join("")});case 20:case"end":return _context7.stop();}},_callee7,this);}));function createNewAnnotation(_x24,_x25,_x26,_x27){return _createNewAnnotation.apply(this,arguments);}return createNewAnnotation;}()},{key:"createNewPrintAnnotation",value:function(){var _createNewPrintAnnotation=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee8(xref,annotation,params){var ap,annotationDict,newAnnotation;return _regeneratorRuntime().wrap(function _callee8$(_context8){while(1)switch(_context8.prev=_context8.next){case 0:_context8.next=2;return this.createNewAppearanceStream(annotation,xref,params);case 2:ap=_context8.sent;annotationDict=this.createNewDict(annotation,xref,{ap:ap});newAnnotation=new this.prototype.constructor({dict:annotationDict,xref:xref,evaluatorOptions:params.evaluatorOptions});if(annotation.ref){newAnnotation.ref=newAnnotation.refToReplace=annotation.ref;}return _context8.abrupt("return",newAnnotation);case 7:case"end":return _context8.stop();}},_callee8,this);}));function createNewPrintAnnotation(_x28,_x29,_x30){return _createNewPrintAnnotation.apply(this,arguments);}return createNewPrintAnnotation;}()}]);return MarkupAnnotation;}(Annotation);exports.MarkupAnnotation=MarkupAnnotation;var WidgetAnnotation=/*#__PURE__*/function(_Annotation2){_inherits(WidgetAnnotation,_Annotation2);var _super2=_createSuper(WidgetAnnotation);function WidgetAnnotation(params){var _this3$appearance;var _this3;_classCallCheck(this,WidgetAnnotation);_this3=_super2.call(this,params);var dict=params.dict,xref=params.xref;var data=_this3.data;_this3._needAppearances=params.needAppearances;data.annotationType=_util.AnnotationType.WIDGET;if(data.fieldName===undefined){data.fieldName=_this3._constructFieldName(dict);}if(data.actions===undefined){data.actions=(0,_core_utils.collectActions)(xref,dict,_util.AnnotationActionEventType);}var fieldValue=(0,_core_utils.getInheritableProperty)({dict:dict,key:"V",getArray:true});data.fieldValue=_this3._decodeFormValue(fieldValue);var defaultFieldValue=(0,_core_utils.getInheritableProperty)({dict:dict,key:"DV",getArray:true});data.defaultFieldValue=_this3._decodeFormValue(defaultFieldValue);if(fieldValue===undefined&&params.xfaDatasets){var path=_this3._title.str;if(path){_this3._hasValueFromXFA=true;data.fieldValue=fieldValue=params.xfaDatasets.getValue(path);}}if(fieldValue===undefined&&data.defaultFieldValue!==null){data.fieldValue=data.defaultFieldValue;}data.alternativeText=(0,_util.stringToPDFString)(dict.get("TU")||"");_this3.setDefaultAppearance(params);data.hasAppearance||(data.hasAppearance=_this3._needAppearances&&data.fieldValue!==undefined&&data.fieldValue!==null);var fieldType=(0,_core_utils.getInheritableProperty)({dict:dict,key:"FT"});data.fieldType=fieldType instanceof _primitives.Name?fieldType.name:null;var localResources=(0,_core_utils.getInheritableProperty)({dict:dict,key:"DR"});var acroFormResources=params.acroForm.get("DR");var appearanceResources=(_this3$appearance=_this3.appearance)===null||_this3$appearance===void 0?void 0:_this3$appearance.dict.get("Resources");_this3._fieldResources={localResources:localResources,acroFormResources:acroFormResources,appearanceResources:appearanceResources,mergedResources:_primitives.Dict.merge({xref:xref,dictArray:[localResources,appearanceResources,acroFormResources],mergeSubDicts:true})};data.fieldFlags=(0,_core_utils.getInheritableProperty)({dict:dict,key:"Ff"});if(!Number.isInteger(data.fieldFlags)||data.fieldFlags<0){data.fieldFlags=0;}data.readOnly=_this3.hasFieldFlag(_util.AnnotationFieldFlag.READONLY);data.required=_this3.hasFieldFlag(_util.AnnotationFieldFlag.REQUIRED);data.hidden=_this3._hasFlag(data.annotationFlags,_util.AnnotationFlag.HIDDEN)||_this3._hasFlag(data.annotationFlags,_util.AnnotationFlag.NOVIEW);if(data.fieldType==="Sig"){if(!self.showUnverifiedSignatures){_this3.setFlags(_util.AnnotationFlag.HIDDEN);(0,_util.info)("The PDF file contains a signature. Please take into account that it can't be verified yet. By default, ngx-extended-pdf-viewer hides signatures until you configure it otherwise.");}}return _this3;}_createClass(WidgetAnnotation,[{key:"_decodeFormValue",value:function _decodeFormValue(formValue){if(Array.isArray(formValue)){return formValue.filter(function(item){return typeof item==="string";}).map(function(item){return(0,_util.stringToPDFString)(item);});}else if(formValue instanceof _primitives.Name){return(0,_util.stringToPDFString)(formValue.name);}else if(typeof formValue==="string"){return(0,_util.stringToPDFString)(formValue);}return null;}},{key:"hasFieldFlag",value:function hasFieldFlag(flag){return!!(this.data.fieldFlags&flag);}},{key:"_isViewable",value:function _isViewable(flags){return!this._hasFlag(flags,_util.AnnotationFlag.INVISIBLE);}},{key:"mustBeViewed",value:function mustBeViewed(annotationStorage,renderForms){if(renderForms){return this.viewable;}return _get(_getPrototypeOf(WidgetAnnotation.prototype),"mustBeViewed",this).call(this,annotationStorage,renderForms)&&!this._hasFlag(this.flags,_util.AnnotationFlag.NOVIEW);}},{key:"getRotationMatrix",value:function getRotationMatrix(annotationStorage){var _annotationStorage$ge3;var rotation=annotationStorage===null||annotationStorage===void 0||(_annotationStorage$ge3=annotationStorage.get(this.data.id))===null||_annotationStorage$ge3===void 0?void 0:_annotationStorage$ge3.rotation;if(rotation===undefined){rotation=this.rotation;}if(rotation===0){return _util.IDENTITY_MATRIX;}var width=this.data.rect[2]-this.data.rect[0];var height=this.data.rect[3]-this.data.rect[1];return(0,_core_utils.getRotationMatrix)(rotation,width,height);}},{key:"getBorderAndBackgroundAppearances",value:function getBorderAndBackgroundAppearances(annotationStorage){var _annotationStorage$ge4;var rotation=annotationStorage===null||annotationStorage===void 0||(_annotationStorage$ge4=annotationStorage.get(this.data.id))===null||_annotationStorage$ge4===void 0?void 0:_annotationStorage$ge4.rotation;if(rotation===undefined){rotation=this.rotation;}if(!this.backgroundColor&&!this.borderColor){return"";}var width=this.data.rect[2]-this.data.rect[0];var height=this.data.rect[3]-this.data.rect[1];var rect=rotation===0||rotation===180?"0 0 ".concat(width," ").concat(height," re"):"0 0 ".concat(height," ").concat(width," re");var str="";if(this.backgroundColor){str="".concat((0,_default_appearance.getPdfColor)(this.backgroundColor,true)," ").concat(rect," f ");}if(this.borderColor){var borderWidth=this.borderStyle.width||1;str+="".concat(borderWidth," w ").concat((0,_default_appearance.getPdfColor)(this.borderColor,false)," ").concat(rect," S ");}return str;}},{key:"getOperatorList",value:function(){var _getOperatorList2=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee9(evaluator,task,intent,renderForms,annotationStorage){var content,opList,isUsingOwnCanvas,matrix,bbox,transform,optionalContent,stream;return _regeneratorRuntime().wrap(function _callee9$(_context9){while(1)switch(_context9.prev=_context9.next){case 0:if(!(renderForms&&!(this instanceof SignatureWidgetAnnotation)&&!this.data.noHTML&&!this.data.hasOwnCanvas)){_context9.next=2;break;}return _context9.abrupt("return",{opList:new _operator_list.OperatorList(),separateForm:true,separateCanvas:false});case 2:if(this._hasText){_context9.next=4;break;}return _context9.abrupt("return",_get(_getPrototypeOf(WidgetAnnotation.prototype),"getOperatorList",this).call(this,evaluator,task,intent,renderForms,annotationStorage));case 4:_context9.next=6;return this._getAppearance(evaluator,task,intent,annotationStorage);case 6:content=_context9.sent;if(!(this.appearance&&content===null)){_context9.next=9;break;}return _context9.abrupt("return",_get(_getPrototypeOf(WidgetAnnotation.prototype),"getOperatorList",this).call(this,evaluator,task,intent,renderForms,annotationStorage));case 9:opList=new _operator_list.OperatorList();if(!(!this._defaultAppearance||content===null)){_context9.next=12;break;}return _context9.abrupt("return",{opList:opList,separateForm:false,separateCanvas:false});case 12:isUsingOwnCanvas=!!(this.data.hasOwnCanvas&&intent&_util.RenderingIntentFlag.DISPLAY);matrix=[1,0,0,1,0,0];bbox=[0,0,this.data.rect[2]-this.data.rect[0],this.data.rect[3]-this.data.rect[1]];transform=getTransformMatrix(this.data.rect,bbox,matrix);if(!this.oc){_context9.next=20;break;}_context9.next=19;return evaluator.parseMarkedContentProps(this.oc,null);case 19:optionalContent=_context9.sent;case 20:if(optionalContent!==undefined){opList.addOp(_util.OPS.beginMarkedContentProps,["OC",optionalContent]);}opList.addOp(_util.OPS.beginAnnotation,[this.data.id,this.data.rect,transform,this.getRotationMatrix(annotationStorage),isUsingOwnCanvas]);stream=new _stream.StringStream(content);_context9.next=25;return evaluator.getOperatorList({stream:stream,task:task,resources:this._fieldResources.mergedResources,operatorList:opList});case 25:opList.addOp(_util.OPS.endAnnotation,[]);if(optionalContent!==undefined){opList.addOp(_util.OPS.endMarkedContent,[]);}return _context9.abrupt("return",{opList:opList,separateForm:false,separateCanvas:isUsingOwnCanvas});case 28:case"end":return _context9.stop();}},_callee9,this);}));function getOperatorList(_x31,_x32,_x33,_x34,_x35){return _getOperatorList2.apply(this,arguments);}return getOperatorList;}()},{key:"_getMKDict",value:function _getMKDict(rotation){var mk=new _primitives.Dict(null);if(rotation){mk.set("R",rotation);}if(this.borderColor){mk.set("BC",getPdfColorArray(this.borderColor));}if(this.backgroundColor){mk.set("BG",getPdfColorArray(this.backgroundColor));}return mk.size>0?mk:null;}},{key:"amendSavedDict",value:function amendSavedDict(annotationStorage,dict){}},{key:"save",value:function(){var _save2=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee10(evaluator,task,annotationStorage){var _this4=this,_appearance;var storageEntry,value,rotation,appearance,needAppearances,xref,originalDict,dict,_iterator10,_step10,key,xfa,encoder,maybeMK,encrypt,originalTransform,buffer,changes,newRef,AP,newTransform,resources,appearanceStream,appearanceDict,rotationMatrix;return _regeneratorRuntime().wrap(function _callee10$(_context10){while(1)switch(_context10.prev=_context10.next){case 0:storageEntry=annotationStorage===null||annotationStorage===void 0?void 0:annotationStorage.get(this.data.id);value=storageEntry===null||storageEntry===void 0?void 0:storageEntry.value,rotation=storageEntry===null||storageEntry===void 0?void 0:storageEntry.rotation;if(!(value===this.data.fieldValue||value===undefined)){_context10.next=6;break;}if(!(!this._hasValueFromXFA&&rotation===undefined)){_context10.next=5;break;}return _context10.abrupt("return",null);case 5:value||(value=this.data.fieldValue);case 6:if(!(rotation===undefined&&!this._hasValueFromXFA&&Array.isArray(value)&&Array.isArray(this.data.fieldValue)&&value.length===this.data.fieldValue.length&&value.every(function(x,i){return x===_this4.data.fieldValue[i];}))){_context10.next=8;break;}return _context10.abrupt("return",null);case 8:if(rotation===undefined){rotation=this.rotation;}appearance=null;if(this._needAppearances){_context10.next=18;break;}_context10.next=13;return this._getAppearance(evaluator,task,_util.RenderingIntentFlag.SAVE,annotationStorage);case 13:appearance=_context10.sent;if(!(appearance===null)){_context10.next=16;break;}return _context10.abrupt("return",null);case 16:_context10.next=18;break;case 18:needAppearances=false;if((_appearance=appearance)!==null&&_appearance!==void 0&&_appearance.needAppearances){needAppearances=true;appearance=null;}xref=evaluator.xref;originalDict=xref.fetchIfRef(this.ref);if(originalDict instanceof _primitives.Dict){_context10.next=24;break;}return _context10.abrupt("return",null);case 24:dict=new _primitives.Dict(xref);_iterator10=_createForOfIteratorHelper(originalDict.getKeys());try{for(_iterator10.s();!(_step10=_iterator10.n()).done;){key=_step10.value;if(key!=="AP"){dict.set(key,originalDict.getRaw(key));}}}catch(err){_iterator10.e(err);}finally{_iterator10.f();}xfa={path:this.data.fieldName,value:value};encoder=function encoder(val){return(0,_core_utils.isAscii)(val)?val:(0,_core_utils.stringToUTF16String)(val,true);};dict.set("V",Array.isArray(value)?value.map(encoder):encoder(value));this.amendSavedDict(annotationStorage,dict);maybeMK=this._getMKDict(rotation);if(maybeMK){dict.set("MK",maybeMK);}encrypt=xref.encrypt;originalTransform=encrypt?encrypt.createCipherTransform(this.ref.num,this.ref.gen):null;buffer=[];changes=[{ref:this.ref,data:"",xfa:xfa,needAppearances:needAppearances}];if(!(appearance!==null)){_context10.next=56;break;}newRef=xref.getNewTemporaryRef();AP=new _primitives.Dict(xref);dict.set("AP",AP);AP.set("N",newRef);newTransform=null;if(encrypt){newTransform=encrypt.createCipherTransform(newRef.num,newRef.gen);}resources=this._getSaveFieldResources(xref);appearanceStream=new _stream.StringStream(appearance);appearanceDict=appearanceStream.dict=new _primitives.Dict(xref);appearanceDict.set("Subtype",_primitives.Name.get("Form"));appearanceDict.set("Resources",resources);appearanceDict.set("BBox",[0,0,this.data.rect[2]-this.data.rect[0],this.data.rect[3]-this.data.rect[1]]);rotationMatrix=this.getRotationMatrix(annotationStorage);if(rotationMatrix!==_util.IDENTITY_MATRIX){appearanceDict.set("Matrix",rotationMatrix);}_context10.next=54;return(0,_writer.writeObject)(newRef,appearanceStream,buffer,newTransform);case 54:changes.push({ref:newRef,data:buffer.join(""),xfa:null,needAppearances:false});buffer.length=0;case 56:dict.set("M","D:".concat((0,_util.getModificationDate)()));_context10.next=59;return(0,_writer.writeObject)(this.ref,dict,buffer,originalTransform);case 59:changes[0].data=buffer.join("");return _context10.abrupt("return",changes);case 61:case"end":return _context10.stop();}},_callee10,this);}));function save(_x36,_x37,_x38){return _save2.apply(this,arguments);}return save;}()},{key:"_getAppearance",value:function(){var _getAppearance2=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee11(evaluator,task,intent,annotationStorage){var isPassword,storageEntry,value,rotation,colors,option,lineCount,lines,defaultPadding,defaultHPadding,totalHeight,totalWidth,_ref5,font,defaultAppearance,fontSize,lineHeight,encodedLines,encodingError,_iterator11,_step11,line,encodedString,fontFamily,fakeUnicodeFont,resources,newFont,oldFont,_iterator12,_step12,key,fontName,i,ii,savedDefaultAppearance,_this$_computeFontSiz,_this$_computeFontSiz2,_this$_computeFontSiz3,_this$_computeFontSiz4,descent,defaultVPadding,alignment,bottomPadding,prevInfo,renderedText;return _regeneratorRuntime().wrap(function _callee11$(_context11){while(1)switch(_context11.prev=_context11.next){case 0:isPassword=this.hasFieldFlag(_util.AnnotationFieldFlag.PASSWORD);if(!isPassword){_context11.next=3;break;}return _context11.abrupt("return",null);case 3:storageEntry=annotationStorage===null||annotationStorage===void 0?void 0:annotationStorage.get(this.data.id);if(storageEntry){value=storageEntry.formattedValue||storageEntry.value;rotation=storageEntry.rotation;}if(!(rotation===undefined&&value===undefined&&!this._needAppearances)){_context11.next=8;break;}if(!(!this._hasValueFromXFA||this.appearance)){_context11.next=8;break;}return _context11.abrupt("return",null);case 8:colors=this.getBorderAndBackgroundAppearances(annotationStorage);if(!(value===undefined)){_context11.next=13;break;}value=this.data.fieldValue;if(value){_context11.next=13;break;}return _context11.abrupt("return","/Tx BMC q ".concat(colors,"Q EMC"));case 13:if(Array.isArray(value)&&value.length===1){value=value[0];}(0,_util.assert)(typeof value==="string","Expected `value` to be a string.");value=value.trim();if(this.data.combo){option=this.data.options.find(function(_ref4){var exportValue=_ref4.exportValue;return value===exportValue;});value=(option===null||option===void 0?void 0:option.displayValue)||value;}if(!(value==="")){_context11.next=19;break;}return _context11.abrupt("return","/Tx BMC q ".concat(colors,"Q EMC"));case 19:if(rotation===undefined){rotation=this.rotation;}lineCount=-1;if(this.data.multiLine){lines=value.split(/\r\n?|\n/).map(function(line){return line.normalize("NFC");});lineCount=lines.length;}else{lines=[value.replace(/\r\n?|\n/,"").normalize("NFC")];}defaultPadding=1;defaultHPadding=2;totalHeight=this.data.rect[3]-this.data.rect[1];totalWidth=this.data.rect[2]-this.data.rect[0];if(rotation===90||rotation===270){_ref5=[totalHeight,totalWidth];totalWidth=_ref5[0];totalHeight=_ref5[1];}if(!this._defaultAppearance){this.data.defaultAppearanceData=(0,_default_appearance.parseDefaultAppearance)(this._defaultAppearance="/Helvetica 0 Tf 0 g");}_context11.next=30;return WidgetAnnotation._getFontData(evaluator,task,this.data.defaultAppearanceData,this._fieldResources.mergedResources);case 30:font=_context11.sent;encodedLines=[];encodingError=false;_iterator11=_createForOfIteratorHelper(lines);try{for(_iterator11.s();!(_step11=_iterator11.n()).done;){line=_step11.value;encodedString=font.encodeString(line);if(encodedString.length>1){encodingError=true;}encodedLines.push(encodedString.join(""));}}catch(err){_iterator11.e(err);}finally{_iterator11.f();}if(!(encodingError&&intent&_util.RenderingIntentFlag.SAVE)){_context11.next=37;break;}return _context11.abrupt("return",{needAppearances:true});case 37:if(!(encodingError&&this._isOffscreenCanvasSupported)){_context11.next=59;break;}fontFamily=this.data.comb?"monospace":"sans-serif";fakeUnicodeFont=new _default_appearance.FakeUnicodeFont(evaluator.xref,fontFamily);resources=fakeUnicodeFont.createFontResources(lines.join(""));newFont=resources.getRaw("Font");if(this._fieldResources.mergedResources.has("Font")){oldFont=this._fieldResources.mergedResources.get("Font");_iterator12=_createForOfIteratorHelper(newFont.getKeys());try{for(_iterator12.s();!(_step12=_iterator12.n()).done;){key=_step12.value;oldFont.set(key,newFont.getRaw(key));}}catch(err){_iterator12.e(err);}finally{_iterator12.f();}}else{this._fieldResources.mergedResources.set("Font",newFont);}fontName=fakeUnicodeFont.fontName.name;_context11.next=46;return WidgetAnnotation._getFontData(evaluator,task,{fontName:fontName,fontSize:0},resources);case 46:font=_context11.sent;for(i=0,ii=encodedLines.length;i<ii;i++){encodedLines[i]=(0,_core_utils.stringToUTF16String)(lines[i]);}savedDefaultAppearance=Object.assign(Object.create(null),this.data.defaultAppearanceData);this.data.defaultAppearanceData.fontSize=0;this.data.defaultAppearanceData.fontName=fontName;_this$_computeFontSiz=this._computeFontSize(totalHeight-2*defaultPadding,totalWidth-2*defaultHPadding,value,font,lineCount);_this$_computeFontSiz2=_slicedToArray(_this$_computeFontSiz,3);defaultAppearance=_this$_computeFontSiz2[0];fontSize=_this$_computeFontSiz2[1];lineHeight=_this$_computeFontSiz2[2];this.data.defaultAppearanceData=savedDefaultAppearance;_context11.next=65;break;case 59:if(!this._isOffscreenCanvasSupported){(0,_util.warn)("_getAppearance: OffscreenCanvas is not supported, annotation may not render correctly.");}_this$_computeFontSiz3=this._computeFontSize(totalHeight-2*defaultPadding,totalWidth-2*defaultHPadding,value,font,lineCount);_this$_computeFontSiz4=_slicedToArray(_this$_computeFontSiz3,3);defaultAppearance=_this$_computeFontSiz4[0];fontSize=_this$_computeFontSiz4[1];lineHeight=_this$_computeFontSiz4[2];case 65:descent=font.descent;if(isNaN(descent)){descent=_util.BASELINE_FACTOR*lineHeight;}else{descent=Math.max(_util.BASELINE_FACTOR*lineHeight,Math.abs(descent)*fontSize);}defaultVPadding=Math.min(Math.floor((totalHeight-fontSize)/2),defaultPadding);alignment=this.data.textAlignment;if(!this.data.multiLine){_context11.next=71;break;}return _context11.abrupt("return",this._getMultilineAppearance(defaultAppearance,encodedLines,font,fontSize,totalWidth,totalHeight,alignment,defaultHPadding,defaultVPadding,descent,lineHeight,annotationStorage));case 71:if(!this.data.comb){_context11.next=73;break;}return _context11.abrupt("return",this._getCombAppearance(defaultAppearance,font,encodedLines[0],fontSize,totalWidth,totalHeight,defaultHPadding,defaultVPadding,descent,lineHeight,annotationStorage));case 73:bottomPadding=defaultVPadding+descent;if(!(alignment===0||alignment>2)){_context11.next=76;break;}return _context11.abrupt("return","/Tx BMC q ".concat(colors,"BT ")+defaultAppearance+" 1 0 0 1 ".concat((0,_core_utils.numberToString)(defaultHPadding)," ").concat((0,_core_utils.numberToString)(bottomPadding)," Tm (").concat((0,_core_utils.escapeString)(encodedLines[0]),") Tj")+" ET Q EMC");case 76:prevInfo={shift:0};renderedText=this._renderText(encodedLines[0],font,fontSize,totalWidth,alignment,prevInfo,defaultHPadding,bottomPadding);return _context11.abrupt("return","/Tx BMC q ".concat(colors,"BT ")+defaultAppearance+" 1 0 0 1 0 0 Tm ".concat(renderedText)+" ET Q EMC");case 79:case"end":return _context11.stop();}},_callee11,this);}));function _getAppearance(_x39,_x40,_x41,_x42){return _getAppearance2.apply(this,arguments);}return _getAppearance;}()},{key:"_getTextWidth",value:function _getTextWidth(text,font){return font.charsToGlyphs(text).reduce(function(width,glyph){return width+glyph.width;},0)/1000;}},{key:"_computeFontSize",value:function _computeFontSize(height,width,text,font,lineCount){var _this5=this;var fontSize=this.data.defaultAppearanceData.fontSize;var lineHeight=(fontSize||12)*_util.LINE_FACTOR,numberOfLines=Math.round(height/lineHeight);if(!fontSize){var roundWithTwoDigits=function roundWithTwoDigits(x){return Math.floor(x*100)/100;};if(lineCount===-1){var textWidth=this._getTextWidth(text,font);fontSize=roundWithTwoDigits(Math.min(height/_util.LINE_FACTOR,textWidth>width?width/textWidth:Infinity));numberOfLines=1;}else{var lines=text.split(/\r\n?|\n/);var cachedLines=[];var _iterator13=_createForOfIteratorHelper(lines),_step13;try{for(_iterator13.s();!(_step13=_iterator13.n()).done;){var line=_step13.value;var encoded=font.encodeString(line).join("");var glyphs=font.charsToGlyphs(encoded);var positions=font.getCharPositions(encoded);cachedLines.push({line:encoded,glyphs:glyphs,positions:positions});}}catch(err){_iterator13.e(err);}finally{_iterator13.f();}var isTooBig=function isTooBig(fsize){var totalHeight=0;for(var _i2=0,_cachedLines=cachedLines;_i2<_cachedLines.length;_i2++){var cache=_cachedLines[_i2];var chunks=_this5._splitLine(null,font,fsize,width,cache);totalHeight+=chunks.length*fsize;if(totalHeight>height){return true;}}return false;};numberOfLines=Math.max(numberOfLines,lineCount);while(true){lineHeight=height/numberOfLines;fontSize=roundWithTwoDigits(lineHeight/_util.LINE_FACTOR);if(isTooBig(fontSize)){numberOfLines++;continue;}break;}}var _this$data$defaultApp=this.data.defaultAppearanceData,fontName=_this$data$defaultApp.fontName,fontColor=_this$data$defaultApp.fontColor;this._defaultAppearance=(0,_default_appearance.createDefaultAppearance)({fontSize:fontSize,fontName:fontName,fontColor:fontColor});}return[this._defaultAppearance,fontSize,height/numberOfLines];}},{key:"_renderText",value:function _renderText(text,font,fontSize,totalWidth,alignment,prevInfo,hPadding,vPadding){var shift;if(alignment===1){var width=this._getTextWidth(text,font)*fontSize;shift=(totalWidth-width)/2;}else if(alignment===2){var _width=this._getTextWidth(text,font)*fontSize;shift=totalWidth-_width-hPadding;}else{shift=hPadding;}var shiftStr=(0,_core_utils.numberToString)(shift-prevInfo.shift);prevInfo.shift=shift;vPadding=(0,_core_utils.numberToString)(vPadding);return"".concat(shiftStr," ").concat(vPadding," Td (").concat((0,_core_utils.escapeString)(text),") Tj");}},{key:"_getSaveFieldResources",value:function _getSaveFieldResources(xref){var _this$data$defaultApp2;var _this$_fieldResources=this._fieldResources,localResources=_this$_fieldResources.localResources,appearanceResources=_this$_fieldResources.appearanceResources,acroFormResources=_this$_fieldResources.acroFormResources;var fontName=(_this$data$defaultApp2=this.data.defaultAppearanceData)===null||_this$data$defaultApp2===void 0?void 0:_this$data$defaultApp2.fontName;if(!fontName){return localResources||_primitives.Dict.empty;}for(var _i3=0,_arr2=[localResources,appearanceResources];_i3<_arr2.length;_i3++){var resources=_arr2[_i3];if(resources instanceof _primitives.Dict){var localFont=resources.get("Font");if(localFont instanceof _primitives.Dict&&localFont.has(fontName)){return resources;}}}if(acroFormResources instanceof _primitives.Dict){var acroFormFont=acroFormResources.get("Font");if(acroFormFont instanceof _primitives.Dict&&acroFormFont.has(fontName)){var subFontDict=new _primitives.Dict(xref);subFontDict.set(fontName,acroFormFont.getRaw(fontName));var subResourcesDict=new _primitives.Dict(xref);subResourcesDict.set("Font",subFontDict);return _primitives.Dict.merge({xref:xref,dictArray:[subResourcesDict,localResources],mergeSubDicts:true});}}return localResources||_primitives.Dict.empty;}},{key:"getFieldObject",value:function getFieldObject(){return null;}}],[{key:"_getFontData",value:function(){var _getFontData2=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee12(evaluator,task,appearanceData,resources){var operatorList,initialState,fontName,fontSize;return _regeneratorRuntime().wrap(function _callee12$(_context12){while(1)switch(_context12.prev=_context12.next){case 0:operatorList=new _operator_list.OperatorList();initialState={font:null,clone:function clone(){return this;}};fontName=appearanceData.fontName,fontSize=appearanceData.fontSize;_context12.next=5;return evaluator.handleSetFont(resources,[fontName&&_primitives.Name.get(fontName),fontSize],null,operatorList,task,initialState,null);case 5:return _context12.abrupt("return",initialState.font);case 6:case"end":return _context12.stop();}},_callee12);}));function _getFontData(_x43,_x44,_x45,_x46){return _getFontData2.apply(this,arguments);}return _getFontData;}()}]);return WidgetAnnotation;}(Annotation);var TextWidgetAnnotation=/*#__PURE__*/function(_WidgetAnnotation){_inherits(TextWidgetAnnotation,_WidgetAnnotation);var _super3=_createSuper(TextWidgetAnnotation);function TextWidgetAnnotation(params){var _this6;_classCallCheck(this,TextWidgetAnnotation);_this6=_super3.call(this,params);_this6.data.hasOwnCanvas=_this6.data.readOnly&&!_this6.data.noHTML;_this6._hasText=true;var dict=params.dict;if(typeof _this6.data.fieldValue!=="string"){_this6.data.fieldValue="";}var alignment=(0,_core_utils.getInheritableProperty)({dict:dict,key:"Q"});if(!Number.isInteger(alignment)||alignment<0||alignment>2){alignment=null;}_this6.data.textAlignment=alignment;var maximumLength=(0,_core_utils.getInheritableProperty)({dict:dict,key:"MaxLen"});if(!Number.isInteger(maximumLength)||maximumLength<0){maximumLength=0;}_this6.data.maxLen=maximumLength;_this6.data.multiLine=_this6.hasFieldFlag(_util.AnnotationFieldFlag.MULTILINE);_this6.data.comb=_this6.hasFieldFlag(_util.AnnotationFieldFlag.COMB)&&!_this6.hasFieldFlag(_util.AnnotationFieldFlag.MULTILINE)&&!_this6.hasFieldFlag(_util.AnnotationFieldFlag.PASSWORD)&&!_this6.hasFieldFlag(_util.AnnotationFieldFlag.FILESELECT)&&_this6.data.maxLen!==0;_this6.data.doNotScroll=_this6.hasFieldFlag(_util.AnnotationFieldFlag.DONOTSCROLL);return _this6;}_createClass(TextWidgetAnnotation,[{key:"hasTextContent",get:function get(){return!!this.appearance&&!this._needAppearances;}},{key:"_getCombAppearance",value:function _getCombAppearance(defaultAppearance,font,text,fontSize,width,height,hPadding,vPadding,descent,lineHeight,annotationStorage){var combWidth=width/this.data.maxLen;var colors=this.getBorderAndBackgroundAppearances(annotationStorage);var buf=[];var positions=font.getCharPositions(text);var _iterator14=_createForOfIteratorHelper(positions),_step14;try{for(_iterator14.s();!(_step14=_iterator14.n()).done;){var _step14$value=_slicedToArray(_step14.value,2),start=_step14$value[0],end=_step14$value[1];buf.push("(".concat((0,_core_utils.escapeString)(text.substring(start,end)),") Tj"));}}catch(err){_iterator14.e(err);}finally{_iterator14.f();}var renderedComb=buf.join(" ".concat((0,_core_utils.numberToString)(combWidth)," 0 Td "));return"/Tx BMC q ".concat(colors,"BT ")+defaultAppearance+" 1 0 0 1 ".concat((0,_core_utils.numberToString)(hPadding)," ").concat((0,_core_utils.numberToString)(vPadding+descent)," Tm ").concat(renderedComb)+" ET Q EMC";}},{key:"_getMultilineAppearance",value:function _getMultilineAppearance(defaultAppearance,lines,font,fontSize,width,height,alignment,hPadding,vPadding,descent,lineHeight,annotationStorage){var buf=[];var totalWidth=width-2*hPadding;var prevInfo={shift:0};for(var i=0,ii=lines.length;i<ii;i++){var line=lines[i];var chunks=this._splitLine(line,font,fontSize,totalWidth);for(var j=0,jj=chunks.length;j<jj;j++){var chunk=chunks[j];var vShift=i===0&&j===0?-vPadding-(lineHeight-descent):-lineHeight;buf.push(this._renderText(chunk,font,fontSize,width,alignment,prevInfo,hPadding,vShift));}}var colors=this.getBorderAndBackgroundAppearances(annotationStorage);var renderedText=buf.join("\n");return"/Tx BMC q ".concat(colors,"BT ")+defaultAppearance+" 1 0 0 1 0 ".concat((0,_core_utils.numberToString)(height)," Tm ").concat(renderedText)+" ET Q EMC";}},{key:"_splitLine",value:function _splitLine(line,font,fontSize,width){var cache=arguments.length>4&&arguments[4]!==undefined?arguments[4]:{};line=cache.line||line;var glyphs=cache.glyphs||font.charsToGlyphs(line);if(glyphs.length<=1){return[line];}var positions=cache.positions||font.getCharPositions(line);var scale=fontSize/1000;var chunks=[];var lastSpacePosInStringStart=-1,lastSpacePosInStringEnd=-1,lastSpacePos=-1,startChunk=0,currentWidth=0;for(var i=0,ii=glyphs.length;i<ii;i++){var _positions$i=_slicedToArray(positions[i],2),start=_positions$i[0],end=_positions$i[1];var glyph=glyphs[i];var glyphWidth=glyph.width*scale;if(glyph.unicode===" "){if(currentWidth+glyphWidth>width){chunks.push(line.substring(startChunk,start));startChunk=start;currentWidth=glyphWidth;lastSpacePosInStringStart=-1;lastSpacePos=-1;}else{currentWidth+=glyphWidth;lastSpacePosInStringStart=start;lastSpacePosInStringEnd=end;lastSpacePos=i;}}else if(currentWidth+glyphWidth>width){if(lastSpacePosInStringStart!==-1){chunks.push(line.substring(startChunk,lastSpacePosInStringEnd));startChunk=lastSpacePosInStringEnd;i=lastSpacePos+1;lastSpacePosInStringStart=-1;currentWidth=0;}else{chunks.push(line.substring(startChunk,start));startChunk=start;currentWidth=glyphWidth;}}else{currentWidth+=glyphWidth;}}if(startChunk<line.length){chunks.push(line.substring(startChunk,line.length));}return chunks;}},{key:"getFieldObject",value:function getFieldObject(){return{id:this.data.id,value:this.data.fieldValue,defaultValue:this.data.defaultFieldValue||"",multiline:this.data.multiLine,password:this.hasFieldFlag(_util.AnnotationFieldFlag.PASSWORD),charLimit:this.data.maxLen,comb:this.data.comb,editable:!this.data.readOnly,hidden:this.data.hidden,name:this.data.fieldName,rect:this.data.rect,actions:this.data.actions,page:this.data.pageIndex,strokeColor:this.data.borderColor,fillColor:this.data.backgroundColor,rotation:this.rotation,type:"text"};}}]);return TextWidgetAnnotation;}(WidgetAnnotation);var ButtonWidgetAnnotation=/*#__PURE__*/function(_WidgetAnnotation2){_inherits(ButtonWidgetAnnotation,_WidgetAnnotation2);var _super4=_createSuper(ButtonWidgetAnnotation);function ButtonWidgetAnnotation(params){var _this7;_classCallCheck(this,ButtonWidgetAnnotation);_this7=_super4.call(this,params);_this7.checkedAppearance=null;_this7.uncheckedAppearance=null;_this7.data.checkBox=!_this7.hasFieldFlag(_util.AnnotationFieldFlag.RADIO)&&!_this7.hasFieldFlag(_util.AnnotationFieldFlag.PUSHBUTTON);_this7.data.radioButton=_this7.hasFieldFlag(_util.AnnotationFieldFlag.RADIO)&&!_this7.hasFieldFlag(_util.AnnotationFieldFlag.PUSHBUTTON);_this7.data.pushButton=_this7.hasFieldFlag(_util.AnnotationFieldFlag.PUSHBUTTON);_this7.data.isTooltipOnly=false;if(_this7.data.checkBox){_this7._processCheckBox(params);}else if(_this7.data.radioButton){_this7._processRadioButton(params);}else if(_this7.data.pushButton){_this7.data.hasOwnCanvas=true;_this7._processPushButton(params);}else{(0,_util.warn)("Invalid field flags for button widget annotation");}return _this7;}_createClass(ButtonWidgetAnnotation,[{key:"getOperatorList",value:function(){var _getOperatorList3=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee13(evaluator,task,intent,renderForms,annotationStorage){var value,rotation,storageEntry,appearance,savedAppearance,savedMatrix,operatorList;return _regeneratorRuntime().wrap(function _callee13$(_context13){while(1)switch(_context13.prev=_context13.next){case 0:if(!this.data.pushButton){_context13.next=2;break;}return _context13.abrupt("return",_get(_getPrototypeOf(ButtonWidgetAnnotation.prototype),"getOperatorList",this).call(this,evaluator,task,intent,false,annotationStorage));case 2:value=null;rotation=null;if(annotationStorage){storageEntry=annotationStorage.get(this.data.id);value=storageEntry?storageEntry.value:null;rotation=storageEntry?storageEntry.rotation:null;}if(!(value===null&&this.appearance)){_context13.next=7;break;}return _context13.abrupt("return",_get(_getPrototypeOf(ButtonWidgetAnnotation.prototype),"getOperatorList",this).call(this,evaluator,task,intent,renderForms,annotationStorage));case 7:if(value===null||value===undefined){value=this.data.checkBox?this.data.fieldValue===this.data.exportValue:this.data.fieldValue===this.data.buttonValue;}appearance=value?this.checkedAppearance:this.uncheckedAppearance;if(!appearance){_context13.next=18;break;}savedAppearance=this.appearance;savedMatrix=appearance.dict.getArray("Matrix")||_util.IDENTITY_MATRIX;if(rotation){appearance.dict.set("Matrix",this.getRotationMatrix(annotationStorage));}this.appearance=appearance;operatorList=_get(_getPrototypeOf(ButtonWidgetAnnotation.prototype),"getOperatorList",this).call(this,evaluator,task,intent,renderForms,annotationStorage);this.appearance=savedAppearance;appearance.dict.set("Matrix",savedMatrix);return _context13.abrupt("return",operatorList);case 18:return _context13.abrupt("return",{opList:new _operator_list.OperatorList(),separateForm:false,separateCanvas:false});case 19:case"end":return _context13.stop();}},_callee13,this);}));function getOperatorList(_x47,_x48,_x49,_x50,_x51){return _getOperatorList3.apply(this,arguments);}return getOperatorList;}()},{key:"save",value:function(){var _save3=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee14(evaluator,task,annotationStorage){return _regeneratorRuntime().wrap(function _callee14$(_context14){while(1)switch(_context14.prev=_context14.next){case 0:if(!this.data.checkBox){_context14.next=2;break;}return _context14.abrupt("return",this._saveCheckbox(evaluator,task,annotationStorage));case 2:if(!this.data.radioButton){_context14.next=4;break;}return _context14.abrupt("return",this._saveRadioButton(evaluator,task,annotationStorage));case 4:return _context14.abrupt("return",null);case 5:case"end":return _context14.stop();}},_callee14,this);}));function save(_x52,_x53,_x54){return _save3.apply(this,arguments);}return save;}()},{key:"_saveCheckbox",value:function(){var _saveCheckbox2=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee15(evaluator,task,annotationStorage){var storageEntry,rotation,value,defaultValue,dict,xfa,name,maybeMK,encrypt,originalTransform,buffer;return _regeneratorRuntime().wrap(function _callee15$(_context15){while(1)switch(_context15.prev=_context15.next){case 0:if(annotationStorage){_context15.next=2;break;}return _context15.abrupt("return",null);case 2:storageEntry=annotationStorage.get(this.data.id);rotation=storageEntry===null||storageEntry===void 0?void 0:storageEntry.rotation,value=storageEntry===null||storageEntry===void 0?void 0:storageEntry.value;if(!(rotation===undefined)){_context15.next=10;break;}if(!(value===undefined)){_context15.next=7;break;}return _context15.abrupt("return",null);case 7:defaultValue=this.data.fieldValue===this.data.exportValue;if(!(defaultValue===value)){_context15.next=10;break;}return _context15.abrupt("return",null);case 10:dict=evaluator.xref.fetchIfRef(this.ref);if(dict instanceof _primitives.Dict){_context15.next=13;break;}return _context15.abrupt("return",null);case 13:if(rotation===undefined){rotation=this.rotation;}if(value===undefined){value=this.data.fieldValue===this.data.exportValue;}xfa={path:this.data.fieldName,value:value?this.data.exportValue:""};name=_primitives.Name.get(value?this.data.exportValue:"Off");dict.set("V",name);dict.set("AS",name);dict.set("M","D:".concat((0,_util.getModificationDate)()));maybeMK=this._getMKDict(rotation);if(maybeMK){dict.set("MK",maybeMK);}encrypt=evaluator.xref.encrypt;originalTransform=null;if(encrypt){originalTransform=encrypt.createCipherTransform(this.ref.num,this.ref.gen);}buffer=["".concat(this.ref.num," ").concat(this.ref.gen," obj\n")];_context15.next=28;return(0,_writer.writeDict)(dict,buffer,originalTransform);case 28:buffer.push("\nendobj\n");return _context15.abrupt("return",[{ref:this.ref,data:buffer.join(""),xfa:xfa}]);case 30:case"end":return _context15.stop();}},_callee15,this);}));function _saveCheckbox(_x55,_x56,_x57){return _saveCheckbox2.apply(this,arguments);}return _saveCheckbox;}()},{key:"_saveRadioButton",value:function(){var _saveRadioButton2=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee16(evaluator,task,annotationStorage){var storageEntry,rotation,value,defaultValue,dict,xfa,name,parentBuffer,encrypt,parent,parentTransform,maybeMK,originalTransform,buffer,newRefs;return _regeneratorRuntime().wrap(function _callee16$(_context16){while(1)switch(_context16.prev=_context16.next){case 0:if(annotationStorage){_context16.next=2;break;}return _context16.abrupt("return",null);case 2:storageEntry=annotationStorage.get(this.data.id);rotation=storageEntry===null||storageEntry===void 0?void 0:storageEntry.rotation,value=storageEntry===null||storageEntry===void 0?void 0:storageEntry.value;if(!(rotation===undefined)){_context16.next=10;break;}if(!(value===undefined)){_context16.next=7;break;}return _context16.abrupt("return",null);case 7:defaultValue=this.data.fieldValue===this.data.buttonValue;if(!(defaultValue===value)){_context16.next=10;break;}return _context16.abrupt("return",null);case 10:dict=evaluator.xref.fetchIfRef(this.ref);if(dict instanceof _primitives.Dict){_context16.next=13;break;}return _context16.abrupt("return",null);case 13:if(value===undefined){value=this.data.fieldValue===this.data.buttonValue;}if(rotation===undefined){rotation=this.rotation;}xfa={path:this.data.fieldName,value:value?this.data.buttonValue:""};name=_primitives.Name.get(value?this.data.buttonValue:"Off");parentBuffer=null;encrypt=evaluator.xref.encrypt;if(!value){_context16.next=32;break;}if(!(this.parent instanceof _primitives.Ref)){_context16.next=31;break;}parent=evaluator.xref.fetch(this.parent);parentTransform=null;if(encrypt){parentTransform=encrypt.createCipherTransform(this.parent.num,this.parent.gen);}parent.set("V",name);parentBuffer=["".concat(this.parent.num," ").concat(this.parent.gen," obj\n")];_context16.next=28;return(0,_writer.writeDict)(parent,parentBuffer,parentTransform);case 28:parentBuffer.push("\nendobj\n");_context16.next=32;break;case 31:if(this.parent instanceof _primitives.Dict){this.parent.set("V",name);}case 32:dict.set("AS",name);dict.set("M","D:".concat((0,_util.getModificationDate)()));maybeMK=this._getMKDict(rotation);if(maybeMK){dict.set("MK",maybeMK);}originalTransform=null;if(encrypt){originalTransform=encrypt.createCipherTransform(this.ref.num,this.ref.gen);}buffer=["".concat(this.ref.num," ").concat(this.ref.gen," obj\n")];_context16.next=41;return(0,_writer.writeDict)(dict,buffer,originalTransform);case 41:buffer.push("\nendobj\n");newRefs=[{ref:this.ref,data:buffer.join(""),xfa:xfa}];if(parentBuffer!==null){newRefs.push({ref:this.parent,data:parentBuffer.join(""),xfa:null});}return _context16.abrupt("return",newRefs);case 45:case"end":return _context16.stop();}},_callee16,this);}));function _saveRadioButton(_x58,_x59,_x60){return _saveRadioButton2.apply(this,arguments);}return _saveRadioButton;}()},{key:"_getDefaultCheckedAppearance",value:function _getDefaultCheckedAppearance(params,type){var width=this.data.rect[2]-this.data.rect[0];var height=this.data.rect[3]-this.data.rect[1];var bbox=[0,0,width,height];var FONT_RATIO=0.8;var fontSize=Math.min(width,height)*FONT_RATIO;var metrics,char;if(type==="check"){metrics={width:0.755*fontSize,height:0.705*fontSize};char="\x33";}else if(type==="disc"){metrics={width:0.791*fontSize,height:0.705*fontSize};char="\x6C";}else{(0,_util.unreachable)("_getDefaultCheckedAppearance - unsupported type: ".concat(type));}var xShift=(0,_core_utils.numberToString)((width-metrics.width)/2);var yShift=(0,_core_utils.numberToString)((height-metrics.height)/2);var appearance="q BT /PdfJsZaDb ".concat(fontSize," Tf 0 g ").concat(xShift," ").concat(yShift," Td (").concat(char,") Tj ET Q");var appearanceStreamDict=new _primitives.Dict(params.xref);appearanceStreamDict.set("FormType",1);appearanceStreamDict.set("Subtype",_primitives.Name.get("Form"));appearanceStreamDict.set("Type",_primitives.Name.get("XObject"));appearanceStreamDict.set("BBox",bbox);appearanceStreamDict.set("Matrix",[1,0,0,1,0,0]);appearanceStreamDict.set("Length",appearance.length);var resources=new _primitives.Dict(params.xref);var font=new _primitives.Dict(params.xref);font.set("PdfJsZaDb",this.fallbackFontDict);resources.set("Font",font);appearanceStreamDict.set("Resources",resources);this.checkedAppearance=new _stream.StringStream(appearance);this.checkedAppearance.dict=appearanceStreamDict;this._streams.push(this.checkedAppearance);}},{key:"_processCheckBox",value:function _processCheckBox(params){var customAppearance=params.dict.get("AP");if(!(customAppearance instanceof _primitives.Dict)){return;}var normalAppearance=customAppearance.get("N");if(!(normalAppearance instanceof _primitives.Dict)){return;}var asValue=this._decodeFormValue(params.dict.get("AS"));if(typeof asValue==="string"){this.data.fieldValue=asValue;}var yes=this.data.fieldValue!==null&&this.data.fieldValue!=="Off"?this.data.fieldValue:"Yes";var exportValues=normalAppearance.getKeys();if(exportValues.length===0){exportValues.push("Off",yes);}else if(exportValues.length===1){if(exportValues[0]==="Off"){exportValues.push(yes);}else{exportValues.unshift("Off");}}else if(exportValues.includes(yes)){exportValues.length=0;exportValues.push("Off",yes);}else{var otherYes=exportValues.find(function(v){return v!=="Off";});exportValues.length=0;exportValues.push("Off",otherYes);}if(!exportValues.includes(this.data.fieldValue)){this.data.fieldValue="Off";}this.data.exportValue=exportValues[1];var checkedAppearance=normalAppearance.get(this.data.exportValue);this.checkedAppearance=checkedAppearance instanceof _base_stream.BaseStream?checkedAppearance:null;var uncheckedAppearance=normalAppearance.get("Off");this.uncheckedAppearance=uncheckedAppearance instanceof _base_stream.BaseStream?uncheckedAppearance:null;if(this.checkedAppearance){this._streams.push(this.checkedAppearance);}else{this._getDefaultCheckedAppearance(params,"check");}if(this.uncheckedAppearance){this._streams.push(this.uncheckedAppearance);}this._fallbackFontDict=this.fallbackFontDict;if(this.data.defaultFieldValue===null){this.data.defaultFieldValue="Off";}}},{key:"_processRadioButton",value:function _processRadioButton(params){this.data.fieldValue=this.data.buttonValue=null;var fieldParent=params.dict.get("Parent");if(fieldParent instanceof _primitives.Dict){this.parent=params.dict.getRaw("Parent");var fieldParentValue=fieldParent.get("V");if(fieldParentValue instanceof _primitives.Name){this.data.fieldValue=this._decodeFormValue(fieldParentValue);}}var appearanceStates=params.dict.get("AP");if(!(appearanceStates instanceof _primitives.Dict)){return;}var normalAppearance=appearanceStates.get("N");if(!(normalAppearance instanceof _primitives.Dict)){return;}var _iterator15=_createForOfIteratorHelper(normalAppearance.getKeys()),_step15;try{for(_iterator15.s();!(_step15=_iterator15.n()).done;){var key=_step15.value;if(key!=="Off"){this.data.buttonValue=this._decodeFormValue(key);break;}}}catch(err){_iterator15.e(err);}finally{_iterator15.f();}var checkedAppearance=normalAppearance.get(this.data.buttonValue);this.checkedAppearance=checkedAppearance instanceof _base_stream.BaseStream?checkedAppearance:null;var uncheckedAppearance=normalAppearance.get("Off");this.uncheckedAppearance=uncheckedAppearance instanceof _base_stream.BaseStream?uncheckedAppearance:null;if(this.checkedAppearance){this._streams.push(this.checkedAppearance);}else{this._getDefaultCheckedAppearance(params,"disc");}if(this.uncheckedAppearance){this._streams.push(this.uncheckedAppearance);}this._fallbackFontDict=this.fallbackFontDict;if(this.data.defaultFieldValue===null){this.data.defaultFieldValue="Off";}}},{key:"_processPushButton",value:function _processPushButton(params){if(!params.dict.has("A")&&!params.dict.has("AA")&&!this.data.alternativeText){(0,_util.warn)("Push buttons without action dictionaries are not supported");return;}this.data.isTooltipOnly=!params.dict.has("A")&&!params.dict.has("AA");_catalog.Catalog.parseDestDictionary({destDict:params.dict,resultObj:this.data,docBaseUrl:params.pdfManager.docBaseUrl,docAttachments:params.attachments});}},{key:"getFieldObject",value:function getFieldObject(){var type="button";var exportValues;if(this.data.checkBox){type="checkbox";exportValues=this.data.exportValue;}else if(this.data.radioButton){type="radiobutton";exportValues=this.data.buttonValue;}return{id:this.data.id,value:this.data.fieldValue||"Off",defaultValue:this.data.defaultFieldValue,exportValues:exportValues,editable:!this.data.readOnly,name:this.data.fieldName,rect:this.data.rect,hidden:this.data.hidden,actions:this.data.actions,page:this.data.pageIndex,strokeColor:this.data.borderColor,fillColor:this.data.backgroundColor,rotation:this.rotation,type:type};}},{key:"fallbackFontDict",get:function get(){var dict=new _primitives.Dict();dict.set("BaseFont",_primitives.Name.get("ZapfDingbats"));dict.set("Type",_primitives.Name.get("FallbackType"));dict.set("Subtype",_primitives.Name.get("FallbackType"));dict.set("Encoding",_primitives.Name.get("ZapfDingbatsEncoding"));return(0,_util.shadow)(this,"fallbackFontDict",dict);}}]);return ButtonWidgetAnnotation;}(WidgetAnnotation);var ChoiceWidgetAnnotation=/*#__PURE__*/function(_WidgetAnnotation3){_inherits(ChoiceWidgetAnnotation,_WidgetAnnotation3);var _super5=_createSuper(ChoiceWidgetAnnotation);function ChoiceWidgetAnnotation(params){var _this8;_classCallCheck(this,ChoiceWidgetAnnotation);_this8=_super5.call(this,params);var dict=params.dict,xref=params.xref;_this8.indices=dict.getArray("I");_this8.hasIndices=Array.isArray(_this8.indices)&&_this8.indices.length>0;_this8.data.options=[];var options=(0,_core_utils.getInheritableProperty)({dict:dict,key:"Opt"});if(Array.isArray(options)){for(var i=0,ii=options.length;i<ii;i++){var option=xref.fetchIfRef(options[i]);var isOptionArray=Array.isArray(option);_this8.data.options[i]={exportValue:_this8._decodeFormValue(isOptionArray?xref.fetchIfRef(option[0]):option),displayValue:_this8._decodeFormValue(isOptionArray?xref.fetchIfRef(option[1]):option)};}}if(!_this8.hasIndices){if(typeof _this8.data.fieldValue==="string"){_this8.data.fieldValue=[_this8.data.fieldValue];}else if(!_this8.data.fieldValue){_this8.data.fieldValue=[];}}else{_this8.data.fieldValue=[];var _ii=_this8.data.options.length;var _iterator16=_createForOfIteratorHelper(_this8.indices),_step16;try{for(_iterator16.s();!(_step16=_iterator16.n()).done;){var _i4=_step16.value;if(Number.isInteger(_i4)&&_i4>=0&&_i4<_ii){_this8.data.fieldValue.push(_this8.data.options[_i4].exportValue);}}}catch(err){_iterator16.e(err);}finally{_iterator16.f();}}_this8.data.combo=_this8.hasFieldFlag(_util.AnnotationFieldFlag.COMBO);_this8.data.multiSelect=_this8.hasFieldFlag(_util.AnnotationFieldFlag.MULTISELECT);_this8._hasText=true;return _this8;}_createClass(ChoiceWidgetAnnotation,[{key:"getFieldObject",value:function getFieldObject(){var type=this.data.combo?"combobox":"listbox";var value=this.data.fieldValue.length>0?this.data.fieldValue[0]:null;return{id:this.data.id,value:value,defaultValue:this.data.defaultFieldValue,editable:!this.data.readOnly,name:this.data.fieldName,rect:this.data.rect,numItems:this.data.fieldValue.length,multipleSelection:this.data.multiSelect,hidden:this.data.hidden,actions:this.data.actions,items:this.data.options,page:this.data.pageIndex,strokeColor:this.data.borderColor,fillColor:this.data.backgroundColor,rotation:this.rotation,type:type};}},{key:"amendSavedDict",value:function amendSavedDict(annotationStorage,dict){var _annotationStorage$ge5;if(!this.hasIndices){return;}var values=annotationStorage===null||annotationStorage===void 0||(_annotationStorage$ge5=annotationStorage.get(this.data.id))===null||_annotationStorage$ge5===void 0?void 0:_annotationStorage$ge5.value;if(!Array.isArray(values)){values=[values];}var indices=[];var options=this.data.options;for(var i=0,j=0,ii=options.length;i<ii;i++){if(options[i].exportValue===values[j]){indices.push(i);j+=1;}}dict.set("I",indices);}},{key:"_getAppearance",value:function(){var _getAppearance3=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee17(evaluator,task,intent,annotationStorage){var exportedValue,rotation,storageEntry,defaultPadding,defaultHPadding,totalHeight,totalWidth,_ref6,lineCount,valueIndices,i,exportValue,font,defaultAppearance,fontSize,_lineHeight,lineWidth,value,_iterator17,_step17,displayValue,width,_this$_computeFontSiz5,_this$_computeFontSiz6,lineHeight,vPadding,numberOfVisibleLines,firstIndex,minIndex,maxIndex,end,buf,_iterator18,_step18,index,prevInfo,_i5,_displayValue,vpadding;return _regeneratorRuntime().wrap(function _callee17$(_context17){while(1)switch(_context17.prev=_context17.next){case 0:if(!this.data.combo){_context17.next=2;break;}return _context17.abrupt("return",_get(_getPrototypeOf(ChoiceWidgetAnnotation.prototype),"_getAppearance",this).call(this,evaluator,task,intent,annotationStorage));case 2:storageEntry=annotationStorage===null||annotationStorage===void 0?void 0:annotationStorage.get(this.data.id);if(storageEntry){rotation=storageEntry.rotation;exportedValue=storageEntry.value;}if(!(rotation===undefined&&exportedValue===undefined&&!this._needAppearances)){_context17.next=6;break;}return _context17.abrupt("return",null);case 6:if(exportedValue===undefined){exportedValue=this.data.fieldValue;}else if(!Array.isArray(exportedValue)){exportedValue=[exportedValue];}defaultPadding=1;defaultHPadding=2;totalHeight=this.data.rect[3]-this.data.rect[1];totalWidth=this.data.rect[2]-this.data.rect[0];if(rotation===90||rotation===270){_ref6=[totalHeight,totalWidth];totalWidth=_ref6[0];totalHeight=_ref6[1];}lineCount=this.data.options.length;valueIndices=[];for(i=0;i<lineCount;i++){exportValue=this.data.options[i].exportValue;if(exportedValue.includes(exportValue)){valueIndices.push(i);}}if(!this._defaultAppearance){this.data.defaultAppearanceData=(0,_default_appearance.parseDefaultAppearance)(this._defaultAppearance="/Helvetica 0 Tf 0 g");}_context17.next=18;return WidgetAnnotation._getFontData(evaluator,task,this.data.defaultAppearanceData,this._fieldResources.mergedResources);case 18:font=_context17.sent;fontSize=this.data.defaultAppearanceData.fontSize;if(!fontSize){_lineHeight=(totalHeight-defaultPadding)/lineCount;lineWidth=-1;_iterator17=_createForOfIteratorHelper(this.data.options);try{for(_iterator17.s();!(_step17=_iterator17.n()).done;){displayValue=_step17.value.displayValue;width=this._getTextWidth(displayValue,font);if(width>lineWidth){lineWidth=width;value=displayValue;}}}catch(err){_iterator17.e(err);}finally{_iterator17.f();}_this$_computeFontSiz5=this._computeFontSize(_lineHeight,totalWidth-2*defaultHPadding,value,font,-1);_this$_computeFontSiz6=_slicedToArray(_this$_computeFontSiz5,2);defaultAppearance=_this$_computeFontSiz6[0];fontSize=_this$_computeFontSiz6[1];}else{defaultAppearance=this._defaultAppearance;}lineHeight=fontSize*_util.LINE_FACTOR;vPadding=(lineHeight-fontSize)/2;numberOfVisibleLines=Math.floor(totalHeight/lineHeight);firstIndex=0;if(valueIndices.length>0){minIndex=Math.min.apply(Math,valueIndices);maxIndex=Math.max.apply(Math,valueIndices);firstIndex=Math.max(0,maxIndex-numberOfVisibleLines+1);if(firstIndex>minIndex){firstIndex=minIndex;}}end=Math.min(firstIndex+numberOfVisibleLines+1,lineCount);buf=["/Tx BMC q","1 1 ".concat(totalWidth," ").concat(totalHeight," re W n")];if(valueIndices.length){buf.push("0.600006 0.756866 0.854904 rg");_iterator18=_createForOfIteratorHelper(valueIndices);try{for(_iterator18.s();!(_step18=_iterator18.n()).done;){index=_step18.value;if(firstIndex<=index&&index<end){buf.push("1 ".concat(totalHeight-(index-firstIndex+1)*lineHeight," ").concat(totalWidth," ").concat(lineHeight," re f"));}}}catch(err){_iterator18.e(err);}finally{_iterator18.f();}}buf.push("BT",defaultAppearance,"1 0 0 1 0 ".concat(totalHeight," Tm"));prevInfo={shift:0};for(_i5=firstIndex;_i5<end;_i5++){_displayValue=this.data.options[_i5].displayValue;vpadding=_i5===firstIndex?vPadding:0;buf.push(this._renderText(_displayValue,font,fontSize,totalWidth,0,prevInfo,defaultHPadding,-lineHeight+vpadding));}buf.push("ET Q EMC");return _context17.abrupt("return",buf.join("\n"));case 34:case"end":return _context17.stop();}},_callee17,this);}));function _getAppearance(_x61,_x62,_x63,_x64){return _getAppearance3.apply(this,arguments);}return _getAppearance;}()}]);return ChoiceWidgetAnnotation;}(WidgetAnnotation);var SignatureWidgetAnnotation=/*#__PURE__*/function(_WidgetAnnotation4){_inherits(SignatureWidgetAnnotation,_WidgetAnnotation4);var _super6=_createSuper(SignatureWidgetAnnotation);function SignatureWidgetAnnotation(params){var _this9;_classCallCheck(this,SignatureWidgetAnnotation);_this9=_super6.call(this,params);_this9.data.fieldValue=null;_this9.data.hasOwnCanvas=_this9.data.noRotate;return _this9;}_createClass(SignatureWidgetAnnotation,[{key:"getFieldObject",value:function getFieldObject(){return{id:this.data.id,value:null,page:this.data.pageIndex,type:"signature"};}}]);return SignatureWidgetAnnotation;}(WidgetAnnotation);var TextAnnotation=/*#__PURE__*/function(_MarkupAnnotation){_inherits(TextAnnotation,_MarkupAnnotation);var _super7=_createSuper(TextAnnotation);function TextAnnotation(params){var _this10;_classCallCheck(this,TextAnnotation);var DEFAULT_ICON_SIZE=22;_this10=_super7.call(this,params);_this10.data.noRotate=true;_this10.data.hasOwnCanvas=_this10.data.noRotate;var dict=params.dict;_this10.data.annotationType=_util.AnnotationType.TEXT;if(_this10.data.hasAppearance){_this10.data.name="NoIcon";}else{_this10.data.rect[1]=_this10.data.rect[3]-DEFAULT_ICON_SIZE;_this10.data.rect[2]=_this10.data.rect[0]+DEFAULT_ICON_SIZE;_this10.data.name=dict.has("Name")?dict.get("Name").name:"Note";}if(dict.has("State")){_this10.data.state=dict.get("State")||null;_this10.data.stateModel=dict.get("StateModel")||null;}else{_this10.data.state=null;_this10.data.stateModel=null;}return _this10;}return _createClass(TextAnnotation);}(MarkupAnnotation);var LinkAnnotation=/*#__PURE__*/function(_Annotation3){_inherits(LinkAnnotation,_Annotation3);var _super8=_createSuper(LinkAnnotation);function LinkAnnotation(params){var _this11$data;var _this11;_classCallCheck(this,LinkAnnotation);_this11=_super8.call(this,params);_this11.data.annotationType=_util.AnnotationType.LINK;var quadPoints=getQuadPoints(params.dict,_this11.rectangle);if(quadPoints){_this11.data.quadPoints=quadPoints;}(_this11$data=_this11.data).borderColor||(_this11$data.borderColor=_this11.data.color);_catalog.Catalog.parseDestDictionary({destDict:params.dict,resultObj:_this11.data,docBaseUrl:params.pdfManager.docBaseUrl,docAttachments:params.attachments});return _this11;}return _createClass(LinkAnnotation);}(Annotation);var PopupAnnotation=/*#__PURE__*/function(_Annotation4){_inherits(PopupAnnotation,_Annotation4);var _super9=_createSuper(PopupAnnotation);function PopupAnnotation(params){var _this12;_classCallCheck(this,PopupAnnotation);_this12=_super9.call(this,params);var dict=params.dict;_this12.data.annotationType=_util.AnnotationType.POPUP;if(_this12.data.rect[0]===_this12.data.rect[2]||_this12.data.rect[1]===_this12.data.rect[3]){_this12.data.rect=null;}var parentItem=dict.get("Parent");if(!parentItem){(0,_util.warn)("Popup annotation has a missing or invalid parent annotation.");return _possibleConstructorReturn(_this12);}var parentRect=parentItem.getArray("Rect");_this12.data.parentRect=Array.isArray(parentRect)&&parentRect.length===4?_util.Util.normalizeRect(parentRect):null;var rt=parentItem.get("RT");if((0,_primitives.isName)(rt,_util.AnnotationReplyType.GROUP)){parentItem=parentItem.get("IRT");}if(!parentItem.has("M")){_this12.data.modificationDate=null;}else{_this12.setModificationDate(parentItem.get("M"));_this12.data.modificationDate=_this12.modificationDate;}if(!parentItem.has("C")){_this12.data.color=null;}else{_this12.setColor(parentItem.getArray("C"));_this12.data.color=_this12.color;}if(!_this12.viewable){var parentFlags=parentItem.get("F");if(_this12._isViewable(parentFlags)){_this12.setFlags(parentFlags);}}_this12.setTitle(parentItem.get("T"));_this12.data.titleObj=_this12._title;_this12.setContents(parentItem.get("Contents"));_this12.data.contentsObj=_this12._contents;if(parentItem.has("RC")){_this12.data.richText=_factory.XFAFactory.getRichTextAsHtml(parentItem.get("RC"));}_this12.data.open=!!dict.get("Open");return _this12;}return _createClass(PopupAnnotation);}(Annotation);exports.PopupAnnotation=PopupAnnotation;var FreeTextAnnotation=/*#__PURE__*/function(_MarkupAnnotation2){_inherits(FreeTextAnnotation,_MarkupAnnotation2);var _super10=_createSuper(FreeTextAnnotation);function FreeTextAnnotation(params){var _this13;_classCallCheck(this,FreeTextAnnotation);_this13=_super10.call(this,params);_this13.data.hasOwnCanvas=true;var evaluatorOptions=params.evaluatorOptions,xref=params.xref;_this13.data.annotationType=_util.AnnotationType.FREETEXT;_this13.setDefaultAppearance(params);if(_this13.appearance){var _parseAppearanceStrea=(0,_default_appearance.parseAppearanceStream)(_this13.appearance,evaluatorOptions,xref),fontColor=_parseAppearanceStrea.fontColor,fontSize=_parseAppearanceStrea.fontSize;_this13.data.defaultAppearanceData.fontColor=fontColor;_this13.data.defaultAppearanceData.fontSize=fontSize||10;}else if(_this13._isOffscreenCanvasSupported){var _this13$data$defaultA;var strokeAlpha=params.dict.get("CA");var fakeUnicodeFont=new _default_appearance.FakeUnicodeFont(xref,"sans-serif");(_this13$data$defaultA=_this13.data.defaultAppearanceData).fontSize||(_this13$data$defaultA.fontSize=10);var _this13$data$defaultA2=_this13.data.defaultAppearanceData,_fontColor=_this13$data$defaultA2.fontColor,_fontSize=_this13$data$defaultA2.fontSize;_this13.appearance=fakeUnicodeFont.createAppearance(_this13._contents.str,_this13.rectangle,_this13.rotation,_fontSize,_fontColor,strokeAlpha);_this13._streams.push(_this13.appearance,_default_appearance.FakeUnicodeFont.toUnicodeStream);}else{(0,_util.warn)("FreeTextAnnotation: OffscreenCanvas is not supported, annotation may not render correctly.");}return _this13;}_createClass(FreeTextAnnotation,[{key:"hasTextContent",get:function get(){return!!this.appearance;}}],[{key:"createNewDict",value:function createNewDict(annotation,xref,_ref7){var apRef=_ref7.apRef,ap=_ref7.ap;var color=annotation.color,fontSize=annotation.fontSize,rect=annotation.rect,rotation=annotation.rotation,user=annotation.user,value=annotation.value;var freetext=new _primitives.Dict(xref);freetext.set("Type",_primitives.Name.get("Annot"));freetext.set("Subtype",_primitives.Name.get("FreeText"));freetext.set("CreationDate","D:".concat((0,_util.getModificationDate)()));freetext.set("Rect",rect);var da="/Helv ".concat(fontSize," Tf ").concat((0,_default_appearance.getPdfColor)(color,true));freetext.set("DA",da);freetext.set("Contents",(0,_core_utils.isAscii)(value)?value:(0,_core_utils.stringToUTF16String)(value,true));freetext.set("F",4);freetext.set("Border",[0,0,0]);freetext.set("Rotate",rotation);if(user){freetext.set("T",(0,_core_utils.isAscii)(user)?user:(0,_core_utils.stringToUTF16String)(user,true));}if(apRef||ap){var n=new _primitives.Dict(xref);freetext.set("AP",n);if(apRef){n.set("N",apRef);}else{n.set("N",ap);}}return freetext;}},{key:"createNewAppearanceStream",value:function(){var _createNewAppearanceStream=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee18(annotation,xref,params){var baseFontRef,evaluator,task,color,fontSize,rect,rotation,value,resources,font,baseFont,helv,_rect,x1,y1,x2,y2,w,h,_ref8,lines,scale,totalWidth,encodedLines,_iterator19,_step19,_line,encoded,lineWidth,glyphs,_iterator20,_step20,glyph,hscale,vscale,lineHeight,lineAscent,totalHeight,fscale,newFontSize,firstPoint,clipBox,matrix,buffer,vShift,i,ii,line,appearance,appearanceStreamDict,ap;return _regeneratorRuntime().wrap(function _callee18$(_context18){while(1)switch(_context18.prev=_context18.next){case 0:baseFontRef=params.baseFontRef,evaluator=params.evaluator,task=params.task;color=annotation.color,fontSize=annotation.fontSize,rect=annotation.rect,rotation=annotation.rotation,value=annotation.value;resources=new _primitives.Dict(xref);font=new _primitives.Dict(xref);if(baseFontRef){font.set("Helv",baseFontRef);}else{baseFont=new _primitives.Dict(xref);baseFont.set("BaseFont",_primitives.Name.get("Helvetica"));baseFont.set("Type",_primitives.Name.get("Font"));baseFont.set("Subtype",_primitives.Name.get("Type1"));baseFont.set("Encoding",_primitives.Name.get("WinAnsiEncoding"));font.set("Helv",baseFont);}resources.set("Font",font);_context18.next=8;return WidgetAnnotation._getFontData(evaluator,task,{fontName:"Helv",fontSize:fontSize},resources);case 8:helv=_context18.sent;_rect=_slicedToArray(rect,4),x1=_rect[0],y1=_rect[1],x2=_rect[2],y2=_rect[3];w=x2-x1;h=y2-y1;if(rotation%180!==0){_ref8=[h,w];w=_ref8[0];h=_ref8[1];}lines=value.split("\n");scale=fontSize/1000;totalWidth=-Infinity;encodedLines=[];_iterator19=_createForOfIteratorHelper(lines);_context18.prev=18;_iterator19.s();case 20:if((_step19=_iterator19.n()).done){_context18.next=34;break;}_line=_step19.value;encoded=helv.encodeString(_line);if(!(encoded.length>1)){_context18.next=25;break;}return _context18.abrupt("return",null);case 25:_line=encoded.join("");encodedLines.push(_line);lineWidth=0;glyphs=helv.charsToGlyphs(_line);_iterator20=_createForOfIteratorHelper(glyphs);try{for(_iterator20.s();!(_step20=_iterator20.n()).done;){glyph=_step20.value;lineWidth+=glyph.width*scale;}}catch(err){_iterator20.e(err);}finally{_iterator20.f();}totalWidth=Math.max(totalWidth,lineWidth);case 32:_context18.next=20;break;case 34:_context18.next=39;break;case 36:_context18.prev=36;_context18.t0=_context18["catch"](18);_iterator19.e(_context18.t0);case 39:_context18.prev=39;_iterator19.f();return _context18.finish(39);case 42:hscale=1;if(totalWidth>w){hscale=w/totalWidth;}vscale=1;lineHeight=_util.LINE_FACTOR*fontSize;lineAscent=(_util.LINE_FACTOR-_util.LINE_DESCENT_FACTOR)*fontSize;totalHeight=lineHeight*lines.length;if(totalHeight>h){vscale=h/totalHeight;}fscale=Math.min(hscale,vscale);newFontSize=fontSize*fscale;_context18.t1=rotation;_context18.next=_context18.t1===0?54:_context18.t1===90?58:_context18.t1===180?62:_context18.t1===270?66:70;break;case 54:matrix=[1,0,0,1];clipBox=[rect[0],rect[1],w,h];firstPoint=[rect[0],rect[3]-lineAscent];return _context18.abrupt("break",70);case 58:matrix=[0,1,-1,0];clipBox=[rect[1],-rect[2],w,h];firstPoint=[rect[1],-rect[0]-lineAscent];return _context18.abrupt("break",70);case 62:matrix=[-1,0,0,-1];clipBox=[-rect[2],-rect[3],w,h];firstPoint=[-rect[2],-rect[1]-lineAscent];return _context18.abrupt("break",70);case 66:matrix=[0,-1,1,0];clipBox=[-rect[3],rect[0],w,h];firstPoint=[-rect[3],rect[2]-lineAscent];return _context18.abrupt("break",70);case 70:buffer=["q","".concat(matrix.join(" ")," 0 0 cm"),"".concat(clipBox.join(" ")," re W n"),"BT","".concat((0,_default_appearance.getPdfColor)(color,true)),"0 Tc /Helv ".concat((0,_core_utils.numberToString)(newFontSize)," Tf")];buffer.push("".concat(firstPoint.join(" ")," Td (").concat((0,_core_utils.escapeString)(encodedLines[0]),") Tj"));vShift=(0,_core_utils.numberToString)(lineHeight);for(i=1,ii=encodedLines.length;i<ii;i++){line=encodedLines[i];buffer.push("0 -".concat(vShift," Td (").concat((0,_core_utils.escapeString)(line),") Tj"));}buffer.push("ET","Q");appearance=buffer.join("\n");appearanceStreamDict=new _primitives.Dict(xref);appearanceStreamDict.set("FormType",1);appearanceStreamDict.set("Subtype",_primitives.Name.get("Form"));appearanceStreamDict.set("Type",_primitives.Name.get("XObject"));appearanceStreamDict.set("BBox",rect);appearanceStreamDict.set("Resources",resources);appearanceStreamDict.set("Matrix",[1,0,0,1,-rect[0],-rect[1]]);ap=new _stream.StringStream(appearance);ap.dict=appearanceStreamDict;return _context18.abrupt("return",ap);case 86:case"end":return _context18.stop();}},_callee18,null,[[18,36,39,42]]);}));function createNewAppearanceStream(_x65,_x66,_x67){return _createNewAppearanceStream.apply(this,arguments);}return createNewAppearanceStream;}()}]);return FreeTextAnnotation;}(MarkupAnnotation);var LineAnnotation=/*#__PURE__*/function(_MarkupAnnotation3){_inherits(LineAnnotation,_MarkupAnnotation3);var _super11=_createSuper(LineAnnotation);function LineAnnotation(params){var _this14;_classCallCheck(this,LineAnnotation);_this14=_super11.call(this,params);var dict=params.dict,xref=params.xref;_this14.data.annotationType=_util.AnnotationType.LINE;_this14.data.hasOwnCanvas=_this14.data.noRotate;var lineCoordinates=dict.getArray("L");_this14.data.lineCoordinates=_util.Util.normalizeRect(lineCoordinates);_this14.setLineEndings(dict.getArray("LE"));_this14.data.lineEndings=_this14.lineEndings;if(!_this14.appearance){var strokeColor=_this14.color?getPdfColorArray(_this14.color):[0,0,0];var strokeAlpha=dict.get("CA");var interiorColor=getRgbColor(dict.getArray("IC"),null);var fillColor=interiorColor?getPdfColorArray(interiorColor):null;var fillAlpha=fillColor?strokeAlpha:null;var borderWidth=_this14.borderStyle.width||1,borderAdjust=2*borderWidth;var bbox=[_this14.data.lineCoordinates[0]-borderAdjust,_this14.data.lineCoordinates[1]-borderAdjust,_this14.data.lineCoordinates[2]+borderAdjust,_this14.data.lineCoordinates[3]+borderAdjust];if(!_util.Util.intersect(_this14.rectangle,bbox)){_this14.rectangle=bbox;}_this14._setDefaultAppearance({xref:xref,extra:"".concat(borderWidth," w"),strokeColor:strokeColor,fillColor:fillColor,strokeAlpha:strokeAlpha,fillAlpha:fillAlpha,pointsCallback:function pointsCallback(buffer,points){buffer.push("".concat(lineCoordinates[0]," ").concat(lineCoordinates[1]," m"),"".concat(lineCoordinates[2]," ").concat(lineCoordinates[3]," l"),"S");return[points[0].x-borderWidth,points[1].x+borderWidth,points[3].y-borderWidth,points[1].y+borderWidth];}});}return _this14;}return _createClass(LineAnnotation);}(MarkupAnnotation);var SquareAnnotation=/*#__PURE__*/function(_MarkupAnnotation4){_inherits(SquareAnnotation,_MarkupAnnotation4);var _super12=_createSuper(SquareAnnotation);function SquareAnnotation(params){var _this15;_classCallCheck(this,SquareAnnotation);_this15=_super12.call(this,params);var dict=params.dict,xref=params.xref;_this15.data.annotationType=_util.AnnotationType.SQUARE;_this15.data.hasOwnCanvas=_this15.data.noRotate;if(!_this15.appearance){var strokeColor=_this15.color?getPdfColorArray(_this15.color):[0,0,0];var strokeAlpha=dict.get("CA");var interiorColor=getRgbColor(dict.getArray("IC"),null);var fillColor=interiorColor?getPdfColorArray(interiorColor):null;var fillAlpha=fillColor?strokeAlpha:null;if(_this15.borderStyle.width===0&&!fillColor){return _possibleConstructorReturn(_this15);}_this15._setDefaultAppearance({xref:xref,extra:"".concat(_this15.borderStyle.width," w"),strokeColor:strokeColor,fillColor:fillColor,strokeAlpha:strokeAlpha,fillAlpha:fillAlpha,pointsCallback:function pointsCallback(buffer,points){var x=points[2].x+_this15.borderStyle.width/2;var y=points[2].y+_this15.borderStyle.width/2;var width=points[3].x-points[2].x-_this15.borderStyle.width;var height=points[1].y-points[3].y-_this15.borderStyle.width;buffer.push("".concat(x," ").concat(y," ").concat(width," ").concat(height," re"));if(fillColor){buffer.push("B");}else{buffer.push("S");}return[points[0].x,points[1].x,points[3].y,points[1].y];}});}return _this15;}return _createClass(SquareAnnotation);}(MarkupAnnotation);var CircleAnnotation=/*#__PURE__*/function(_MarkupAnnotation5){_inherits(CircleAnnotation,_MarkupAnnotation5);var _super13=_createSuper(CircleAnnotation);function CircleAnnotation(params){var _this16;_classCallCheck(this,CircleAnnotation);_this16=_super13.call(this,params);var dict=params.dict,xref=params.xref;_this16.data.annotationType=_util.AnnotationType.CIRCLE;if(!_this16.appearance){var strokeColor=_this16.color?getPdfColorArray(_this16.color):[0,0,0];var strokeAlpha=dict.get("CA");var interiorColor=getRgbColor(dict.getArray("IC"),null);var fillColor=interiorColor?getPdfColorArray(interiorColor):null;var fillAlpha=fillColor?strokeAlpha:null;if(_this16.borderStyle.width===0&&!fillColor){return _possibleConstructorReturn(_this16);}var controlPointsDistance=4/3*Math.tan(Math.PI/(2*4));_this16._setDefaultAppearance({xref:xref,extra:"".concat(_this16.borderStyle.width," w"),strokeColor:strokeColor,fillColor:fillColor,strokeAlpha:strokeAlpha,fillAlpha:fillAlpha,pointsCallback:function pointsCallback(buffer,points){var x0=points[0].x+_this16.borderStyle.width/2;var y0=points[0].y-_this16.borderStyle.width/2;var x1=points[3].x-_this16.borderStyle.width/2;var y1=points[3].y+_this16.borderStyle.width/2;var xMid=x0+(x1-x0)/2;var yMid=y0+(y1-y0)/2;var xOffset=(x1-x0)/2*controlPointsDistance;var yOffset=(y1-y0)/2*controlPointsDistance;buffer.push("".concat(xMid," ").concat(y1," m"),"".concat(xMid+xOffset," ").concat(y1," ").concat(x1," ").concat(yMid+yOffset," ").concat(x1," ").concat(yMid," c"),"".concat(x1," ").concat(yMid-yOffset," ").concat(xMid+xOffset," ").concat(y0," ").concat(xMid," ").concat(y0," c"),"".concat(xMid-xOffset," ").concat(y0," ").concat(x0," ").concat(yMid-yOffset," ").concat(x0," ").concat(yMid," c"),"".concat(x0," ").concat(yMid+yOffset," ").concat(xMid-xOffset," ").concat(y1," ").concat(xMid," ").concat(y1," c"),"h");if(fillColor){buffer.push("B");}else{buffer.push("S");}return[points[0].x,points[1].x,points[3].y,points[1].y];}});}return _this16;}return _createClass(CircleAnnotation);}(MarkupAnnotation);var PolylineAnnotation=/*#__PURE__*/function(_MarkupAnnotation6){_inherits(PolylineAnnotation,_MarkupAnnotation6);var _super14=_createSuper(PolylineAnnotation);function PolylineAnnotation(params){var _this17;_classCallCheck(this,PolylineAnnotation);_this17=_super14.call(this,params);var dict=params.dict,xref=params.xref;_this17.data.annotationType=_util.AnnotationType.POLYLINE;_this17.data.hasOwnCanvas=_this17.data.noRotate;_this17.data.vertices=[];if(!(_assertThisInitialized(_this17)instanceof PolygonAnnotation)){_this17.setLineEndings(dict.getArray("LE"));_this17.data.lineEndings=_this17.lineEndings;}var rawVertices=dict.getArray("Vertices");if(!Array.isArray(rawVertices)){return _possibleConstructorReturn(_this17);}for(var i=0,ii=rawVertices.length;i<ii;i+=2){_this17.data.vertices.push({x:rawVertices[i],y:rawVertices[i+1]});}if(!_this17.appearance){var strokeColor=_this17.color?getPdfColorArray(_this17.color):[0,0,0];var strokeAlpha=dict.get("CA");var borderWidth=_this17.borderStyle.width||1,borderAdjust=2*borderWidth;var bbox=[Infinity,Infinity,-Infinity,-Infinity];var _iterator21=_createForOfIteratorHelper(_this17.data.vertices),_step21;try{for(_iterator21.s();!(_step21=_iterator21.n()).done;){var vertex=_step21.value;bbox[0]=Math.min(bbox[0],vertex.x-borderAdjust);bbox[1]=Math.min(bbox[1],vertex.y-borderAdjust);bbox[2]=Math.max(bbox[2],vertex.x+borderAdjust);bbox[3]=Math.max(bbox[3],vertex.y+borderAdjust);}}catch(err){_iterator21.e(err);}finally{_iterator21.f();}if(!_util.Util.intersect(_this17.rectangle,bbox)){_this17.rectangle=bbox;}_this17._setDefaultAppearance({xref:xref,extra:"".concat(borderWidth," w"),strokeColor:strokeColor,strokeAlpha:strokeAlpha,pointsCallback:function pointsCallback(buffer,points){var vertices=_this17.data.vertices;for(var _i6=0,_ii2=vertices.length;_i6<_ii2;_i6++){buffer.push("".concat(vertices[_i6].x," ").concat(vertices[_i6].y," ").concat(_i6===0?"m":"l"));}buffer.push("S");return[points[0].x,points[1].x,points[3].y,points[1].y];}});}return _this17;}return _createClass(PolylineAnnotation);}(MarkupAnnotation);var PolygonAnnotation=/*#__PURE__*/function(_PolylineAnnotation){_inherits(PolygonAnnotation,_PolylineAnnotation);var _super15=_createSuper(PolygonAnnotation);function PolygonAnnotation(params){var _this18;_classCallCheck(this,PolygonAnnotation);_this18=_super15.call(this,params);_this18.data.annotationType=_util.AnnotationType.POLYGON;return _this18;}return _createClass(PolygonAnnotation);}(PolylineAnnotation);var CaretAnnotation=/*#__PURE__*/function(_MarkupAnnotation7){_inherits(CaretAnnotation,_MarkupAnnotation7);var _super16=_createSuper(CaretAnnotation);function CaretAnnotation(params){var _this19;_classCallCheck(this,CaretAnnotation);_this19=_super16.call(this,params);_this19.data.annotationType=_util.AnnotationType.CARET;return _this19;}return _createClass(CaretAnnotation);}(MarkupAnnotation);var InkAnnotation=/*#__PURE__*/function(_MarkupAnnotation8){_inherits(InkAnnotation,_MarkupAnnotation8);var _super17=_createSuper(InkAnnotation);function InkAnnotation(params){var _this20;_classCallCheck(this,InkAnnotation);_this20=_super17.call(this,params);_this20.data.hasOwnCanvas=_this20.data.noRotate;var dict=params.dict,xref=params.xref;_this20.data.annotationType=_util.AnnotationType.INK;_this20.data.inkLists=[];var rawInkLists=dict.getArray("InkList");if(!Array.isArray(rawInkLists)){return _possibleConstructorReturn(_this20);}for(var i=0,ii=rawInkLists.length;i<ii;++i){_this20.data.inkLists.push([]);for(var j=0,jj=rawInkLists[i].length;j<jj;j+=2){_this20.data.inkLists[i].push({x:xref.fetchIfRef(rawInkLists[i][j]),y:xref.fetchIfRef(rawInkLists[i][j+1])});}}if(!_this20.appearance){var strokeColor=_this20.color?getPdfColorArray(_this20.color):[0,0,0];var strokeAlpha=dict.get("CA");var borderWidth=_this20.borderStyle.width||1,borderAdjust=2*borderWidth;var bbox=[Infinity,Infinity,-Infinity,-Infinity];var _iterator22=_createForOfIteratorHelper(_this20.data.inkLists),_step22;try{for(_iterator22.s();!(_step22=_iterator22.n()).done;){var inkLists=_step22.value;var _iterator24=_createForOfIteratorHelper(inkLists),_step24;try{for(_iterator24.s();!(_step24=_iterator24.n()).done;){var vertex=_step24.value;bbox[0]=Math.min(bbox[0],vertex.x-borderAdjust);bbox[1]=Math.min(bbox[1],vertex.y-borderAdjust);bbox[2]=Math.max(bbox[2],vertex.x+borderAdjust);bbox[3]=Math.max(bbox[3],vertex.y+borderAdjust);}}catch(err){_iterator24.e(err);}finally{_iterator24.f();}}}catch(err){_iterator22.e(err);}finally{_iterator22.f();}if(!_util.Util.intersect(_this20.rectangle,bbox)){_this20.rectangle=bbox;}_this20._setDefaultAppearance({xref:xref,extra:"".concat(borderWidth," w"),strokeColor:strokeColor,strokeAlpha:strokeAlpha,pointsCallback:function pointsCallback(buffer,points){var _iterator23=_createForOfIteratorHelper(_this20.data.inkLists),_step23;try{for(_iterator23.s();!(_step23=_iterator23.n()).done;){var inkList=_step23.value;for(var _i7=0,_ii3=inkList.length;_i7<_ii3;_i7++){buffer.push("".concat(inkList[_i7].x," ").concat(inkList[_i7].y," ").concat(_i7===0?"m":"l"));}buffer.push("S");}}catch(err){_iterator23.e(err);}finally{_iterator23.f();}return[points[0].x,points[1].x,points[3].y,points[1].y];}});}return _this20;}_createClass(InkAnnotation,null,[{key:"createNewDict",value:function createNewDict(annotation,xref,_ref9){var apRef=_ref9.apRef,ap=_ref9.ap;var color=annotation.color,opacity=annotation.opacity,paths=annotation.paths,rect=annotation.rect,rotation=annotation.rotation,thickness=annotation.thickness;var ink=new _primitives.Dict(xref);ink.set("Type",_primitives.Name.get("Annot"));ink.set("Subtype",_primitives.Name.get("Ink"));ink.set("CreationDate","D:".concat((0,_util.getModificationDate)()));ink.set("Rect",rect);ink.set("InkList",paths.map(function(p){return p.points;}));ink.set("F",4);ink.set("Rotate",rotation);var bs=new _primitives.Dict(xref);ink.set("BS",bs);bs.set("W",thickness);ink.set("C",Array.from(color,function(c){return c/255;}));ink.set("CA",opacity);var n=new _primitives.Dict(xref);ink.set("AP",n);if(apRef){n.set("N",apRef);}else{n.set("N",ap);}return ink;}},{key:"createNewAppearanceStream",value:function(){var _createNewAppearanceStream2=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee19(annotation,xref,params){var color,rect,paths,thickness,opacity,appearanceBuffer,buffer,_iterator25,_step25,bezier,i,ii,curve,appearance,appearanceStreamDict,resources,extGState,r0,ap;return _regeneratorRuntime().wrap(function _callee19$(_context19){while(1)switch(_context19.prev=_context19.next){case 0:color=annotation.color,rect=annotation.rect,paths=annotation.paths,thickness=annotation.thickness,opacity=annotation.opacity;appearanceBuffer=["".concat(thickness," w 1 J 1 j"),"".concat((0,_default_appearance.getPdfColor)(color,false))];if(opacity!==1){appearanceBuffer.push("/R0 gs");}buffer=[];_iterator25=_createForOfIteratorHelper(paths);try{for(_iterator25.s();!(_step25=_iterator25.n()).done;){bezier=_step25.value.bezier;buffer.length=0;buffer.push("".concat((0,_core_utils.numberToString)(bezier[0])," ").concat((0,_core_utils.numberToString)(bezier[1])," m"));for(i=2,ii=bezier.length;i<ii;i+=6){curve=bezier.slice(i,i+6).map(_core_utils.numberToString).join(" ");buffer.push("".concat(curve," c"));}buffer.push("S");appearanceBuffer.push(buffer.join("\n"));}}catch(err){_iterator25.e(err);}finally{_iterator25.f();}appearance=appearanceBuffer.join("\n");appearanceStreamDict=new _primitives.Dict(xref);appearanceStreamDict.set("FormType",1);appearanceStreamDict.set("Subtype",_primitives.Name.get("Form"));appearanceStreamDict.set("Type",_primitives.Name.get("XObject"));appearanceStreamDict.set("BBox",rect);appearanceStreamDict.set("Length",appearance.length);if(opacity!==1){resources=new _primitives.Dict(xref);extGState=new _primitives.Dict(xref);r0=new _primitives.Dict(xref);r0.set("CA",opacity);r0.set("Type",_primitives.Name.get("ExtGState"));extGState.set("R0",r0);resources.set("ExtGState",extGState);appearanceStreamDict.set("Resources",resources);}ap=new _stream.StringStream(appearance);ap.dict=appearanceStreamDict;return _context19.abrupt("return",ap);case 17:case"end":return _context19.stop();}},_callee19);}));function createNewAppearanceStream(_x68,_x69,_x70){return _createNewAppearanceStream2.apply(this,arguments);}return createNewAppearanceStream;}()}]);return InkAnnotation;}(MarkupAnnotation);var HighlightAnnotation=/*#__PURE__*/function(_MarkupAnnotation9){_inherits(HighlightAnnotation,_MarkupAnnotation9);var _super18=_createSuper(HighlightAnnotation);function HighlightAnnotation(params){var _this21;_classCallCheck(this,HighlightAnnotation);_this21=_super18.call(this,params);var dict=params.dict,xref=params.xref;_this21.data.annotationType=_util.AnnotationType.HIGHLIGHT;var quadPoints=_this21.data.quadPoints=getQuadPoints(dict,null);if(quadPoints){var _this21$appearance;var resources=(_this21$appearance=_this21.appearance)===null||_this21$appearance===void 0?void 0:_this21$appearance.dict.get("Resources");if(!_this21.appearance||!(resources!==null&&resources!==void 0&&resources.has("ExtGState"))){if(_this21.appearance){(0,_util.warn)("HighlightAnnotation - ignoring built-in appearance stream.");}var fillColor=_this21.color?getPdfColorArray(_this21.color):[1,1,0];var fillAlpha=dict.get("CA");_this21._setDefaultAppearance({xref:xref,fillColor:fillColor,blendMode:"Multiply",fillAlpha:fillAlpha,pointsCallback:function pointsCallback(buffer,points){buffer.push("".concat(points[0].x," ").concat(points[0].y," m"),"".concat(points[1].x," ").concat(points[1].y," l"),"".concat(points[3].x," ").concat(points[3].y," l"),"".concat(points[2].x," ").concat(points[2].y," l"),"f");return[points[0].x,points[1].x,points[3].y,points[1].y];}});}}else{_this21.data.popupRef=null;}return _this21;}return _createClass(HighlightAnnotation);}(MarkupAnnotation);var UnderlineAnnotation=/*#__PURE__*/function(_MarkupAnnotation10){_inherits(UnderlineAnnotation,_MarkupAnnotation10);var _super19=_createSuper(UnderlineAnnotation);function UnderlineAnnotation(params){var _this22;_classCallCheck(this,UnderlineAnnotation);_this22=_super19.call(this,params);var dict=params.dict,xref=params.xref;_this22.data.annotationType=_util.AnnotationType.UNDERLINE;var quadPoints=_this22.data.quadPoints=getQuadPoints(dict,null);if(quadPoints){if(!_this22.appearance){var strokeColor=_this22.color?getPdfColorArray(_this22.color):[0,0,0];var strokeAlpha=dict.get("CA");_this22._setDefaultAppearance({xref:xref,extra:"[] 0 d 0.571 w",strokeColor:strokeColor,strokeAlpha:strokeAlpha,pointsCallback:function pointsCallback(buffer,points){buffer.push("".concat(points[2].x," ").concat(points[2].y+1.3," m"),"".concat(points[3].x," ").concat(points[3].y+1.3," l"),"S");return[points[0].x,points[1].x,points[3].y,points[1].y];}});}}else{_this22.data.popupRef=null;}return _this22;}return _createClass(UnderlineAnnotation);}(MarkupAnnotation);var SquigglyAnnotation=/*#__PURE__*/function(_MarkupAnnotation11){_inherits(SquigglyAnnotation,_MarkupAnnotation11);var _super20=_createSuper(SquigglyAnnotation);function SquigglyAnnotation(params){var _this23;_classCallCheck(this,SquigglyAnnotation);_this23=_super20.call(this,params);var dict=params.dict,xref=params.xref;_this23.data.annotationType=_util.AnnotationType.SQUIGGLY;var quadPoints=_this23.data.quadPoints=getQuadPoints(dict,null);if(quadPoints){if(!_this23.appearance){var strokeColor=_this23.color?getPdfColorArray(_this23.color):[0,0,0];var strokeAlpha=dict.get("CA");_this23._setDefaultAppearance({xref:xref,extra:"[] 0 d 1 w",strokeColor:strokeColor,strokeAlpha:strokeAlpha,pointsCallback:function pointsCallback(buffer,points){var dy=(points[0].y-points[2].y)/6;var shift=dy;var x=points[2].x;var y=points[2].y;var xEnd=points[3].x;buffer.push("".concat(x," ").concat(y+shift," m"));do{x+=2;shift=shift===0?dy:0;buffer.push("".concat(x," ").concat(y+shift," l"));}while(x<xEnd);buffer.push("S");return[points[2].x,xEnd,y-2*dy,y+2*dy];}});}}else{_this23.data.popupRef=null;}return _this23;}return _createClass(SquigglyAnnotation);}(MarkupAnnotation);var StrikeOutAnnotation=/*#__PURE__*/function(_MarkupAnnotation12){_inherits(StrikeOutAnnotation,_MarkupAnnotation12);var _super21=_createSuper(StrikeOutAnnotation);function StrikeOutAnnotation(params){var _this24;_classCallCheck(this,StrikeOutAnnotation);_this24=_super21.call(this,params);var dict=params.dict,xref=params.xref;_this24.data.annotationType=_util.AnnotationType.STRIKEOUT;var quadPoints=_this24.data.quadPoints=getQuadPoints(dict,null);if(quadPoints){if(!_this24.appearance){var strokeColor=_this24.color?getPdfColorArray(_this24.color):[0,0,0];var strokeAlpha=dict.get("CA");_this24._setDefaultAppearance({xref:xref,extra:"[] 0 d 1 w",strokeColor:strokeColor,strokeAlpha:strokeAlpha,pointsCallback:function pointsCallback(buffer,points){buffer.push("".concat((points[0].x+points[2].x)/2," ")+"".concat((points[0].y+points[2].y)/2," m"),"".concat((points[1].x+points[3].x)/2," ")+"".concat((points[1].y+points[3].y)/2," l"),"S");return[points[0].x,points[1].x,points[3].y,points[1].y];}});}}else{_this24.data.popupRef=null;}return _this24;}return _createClass(StrikeOutAnnotation);}(MarkupAnnotation);var StampAnnotation=/*#__PURE__*/function(_MarkupAnnotation13){_inherits(StampAnnotation,_MarkupAnnotation13);var _super22=_createSuper(StampAnnotation);function StampAnnotation(params){var _this25;_classCallCheck(this,StampAnnotation);_this25=_super22.call(this,params);_this25.data.annotationType=_util.AnnotationType.STAMP;_this25.data.hasOwnCanvas=_this25.data.noRotate;return _this25;}_createClass(StampAnnotation,null,[{key:"createImage",value:function(){var _createImage=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee20(bitmap,xref){var width,height,canvas,ctx,data,buf32,hasAlpha,jpegBufferPromise,xobjectName,imageName,image,smaskStream,alphaBuffer,i,ii,_i8,_ii4,smask,imageStream;return _regeneratorRuntime().wrap(function _callee20$(_context20){while(1)switch(_context20.prev=_context20.next){case 0:width=bitmap.width,height=bitmap.height;canvas=new OffscreenCanvas(width,height);ctx=canvas.getContext("2d",{alpha:true});ctx.drawImage(bitmap,0,0);data=ctx.getImageData(0,0,width,height).data;buf32=new Uint32Array(data.buffer);hasAlpha=buf32.some(_util.FeatureTest.isLittleEndian?function(x){return x>>>24!==0xff;}:function(x){return(x&0xff)!==0xff;});if(hasAlpha){ctx.fillStyle="white";ctx.fillRect(0,0,width,height);ctx.drawImage(bitmap,0,0);}jpegBufferPromise=canvas.convertToBlob({type:"image/jpeg",quality:1}).then(function(blob){return blob.arrayBuffer();});xobjectName=_primitives.Name.get("XObject");imageName=_primitives.Name.get("Image");image=new _primitives.Dict(xref);image.set("Type",xobjectName);image.set("Subtype",imageName);image.set("BitsPerComponent",8);image.set("ColorSpace",_primitives.Name.get("DeviceRGB"));image.set("Filter",_primitives.Name.get("DCTDecode"));image.set("BBox",[0,0,width,height]);image.set("Width",width);image.set("Height",height);smaskStream=null;if(hasAlpha){alphaBuffer=new Uint8Array(buf32.length);if(_util.FeatureTest.isLittleEndian){for(i=0,ii=buf32.length;i<ii;i++){alphaBuffer[i]=buf32[i]>>>24;}}else{for(_i8=0,_ii4=buf32.length;_i8<_ii4;_i8++){alphaBuffer[_i8]=buf32[_i8]&0xff;}}smask=new _primitives.Dict(xref);smask.set("Type",xobjectName);smask.set("Subtype",imageName);smask.set("BitsPerComponent",8);smask.set("ColorSpace",_primitives.Name.get("DeviceGray"));smask.set("Width",width);smask.set("Height",height);smaskStream=new _stream.Stream(alphaBuffer,0,0,smask);}_context20.t0=_stream.Stream;_context20.next=25;return jpegBufferPromise;case 25:_context20.t1=_context20.sent;_context20.t2=image;imageStream=new _context20.t0(_context20.t1,0,0,_context20.t2);return _context20.abrupt("return",{imageStream:imageStream,smaskStream:smaskStream,width:width,height:height});case 29:case"end":return _context20.stop();}},_callee20);}));function createImage(_x71,_x72){return _createImage.apply(this,arguments);}return createImage;}()},{key:"createNewDict",value:function createNewDict(annotation,xref,_ref10){var apRef=_ref10.apRef,ap=_ref10.ap;var rect=annotation.rect,rotation=annotation.rotation,user=annotation.user;var stamp=new _primitives.Dict(xref);stamp.set("Type",_primitives.Name.get("Annot"));stamp.set("Subtype",_primitives.Name.get("Stamp"));stamp.set("CreationDate","D:".concat((0,_util.getModificationDate)()));stamp.set("Rect",rect);stamp.set("F",4);stamp.set("Border",[0,0,0]);stamp.set("Rotate",rotation);if(user){stamp.set("T",(0,_core_utils.isAscii)(user)?user:(0,_core_utils.stringToUTF16String)(user,true));}if(apRef||ap){var n=new _primitives.Dict(xref);stamp.set("AP",n);if(apRef){n.set("N",apRef);}else{n.set("N",ap);}}return stamp;}},{key:"createNewAppearanceStream",value:function(){var _createNewAppearanceStream3=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee21(annotation,xref,params){var rotation,_params$image,imageRef,width,height,resources,xobject,appearance,appearanceStreamDict,matrix,ap;return _regeneratorRuntime().wrap(function _callee21$(_context21){while(1)switch(_context21.prev=_context21.next){case 0:rotation=annotation.rotation;_params$image=params.image,imageRef=_params$image.imageRef,width=_params$image.width,height=_params$image.height;resources=new _primitives.Dict(xref);xobject=new _primitives.Dict(xref);resources.set("XObject",xobject);xobject.set("Im0",imageRef);appearance="q ".concat(width," 0 0 ").concat(height," 0 0 cm /Im0 Do Q");appearanceStreamDict=new _primitives.Dict(xref);appearanceStreamDict.set("FormType",1);appearanceStreamDict.set("Subtype",_primitives.Name.get("Form"));appearanceStreamDict.set("Type",_primitives.Name.get("XObject"));appearanceStreamDict.set("BBox",[0,0,width,height]);appearanceStreamDict.set("Resources",resources);if(rotation){matrix=(0,_core_utils.getRotationMatrix)(rotation,width,height);appearanceStreamDict.set("Matrix",matrix);}ap=new _stream.StringStream(appearance);ap.dict=appearanceStreamDict;return _context21.abrupt("return",ap);case 17:case"end":return _context21.stop();}},_callee21);}));function createNewAppearanceStream(_x73,_x74,_x75){return _createNewAppearanceStream3.apply(this,arguments);}return createNewAppearanceStream;}()}]);return StampAnnotation;}(MarkupAnnotation);var FileAttachmentAnnotation=/*#__PURE__*/function(_MarkupAnnotation14){_inherits(FileAttachmentAnnotation,_MarkupAnnotation14);var _super23=_createSuper(FileAttachmentAnnotation);function FileAttachmentAnnotation(params){var _this26;_classCallCheck(this,FileAttachmentAnnotation);_this26=_super23.call(this,params);var dict=params.dict,xref=params.xref;var file=new _file_spec.FileSpec(dict.get("FS"),xref);_this26.data.annotationType=_util.AnnotationType.FILEATTACHMENT;_this26.data.hasOwnCanvas=_this26.data.noRotate;_this26.data.file=file.serializable;var name=dict.get("Name");_this26.data.name=name instanceof _primitives.Name?(0,_util.stringToPDFString)(name.name):"PushPin";var fillAlpha=dict.get("ca");_this26.data.fillAlpha=typeof fillAlpha==="number"&&fillAlpha>=0&&fillAlpha<=1?fillAlpha:null;return _this26;}return _createClass(FileAttachmentAnnotation);}(MarkupAnnotation);

/***/ }),
/* 367 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var call = __w_pdfjs_require__(35);
var isObject = __w_pdfjs_require__(28);
var anObject = __w_pdfjs_require__(32);
var isDataDescriptor = __w_pdfjs_require__(368);
var getOwnPropertyDescriptorModule = __w_pdfjs_require__(59);
var getPrototypeOf = __w_pdfjs_require__(135);
function get(target, propertyKey) {
 var receiver = arguments.length < 3 ? target : arguments[2];
 var descriptor, prototype;
 if (anObject(target) === receiver)
  return target[propertyKey];
 descriptor = getOwnPropertyDescriptorModule.f(target, propertyKey);
 if (descriptor)
  return isDataDescriptor(descriptor) ? descriptor.value : descriptor.get === undefined ? undefined : call(descriptor.get, receiver);
 if (isObject(prototype = getPrototypeOf(target)))
  return get(prototype, propertyKey, receiver);
}
$({
 target: 'Reflect',
 stat: true
}, { get: get });

/***/ }),
/* 368 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var hasOwn = __w_pdfjs_require__(6);
module.exports = function (descriptor) {
 return descriptor !== undefined && (hasOwn(descriptor, 'value') || hasOwn(descriptor, 'writable'));
};

/***/ }),
/* 369 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var fails = __w_pdfjs_require__(9);
var toIndexedObject = __w_pdfjs_require__(61);
var nativeGetOwnPropertyDescriptor = (__w_pdfjs_require__(59).f);
var DESCRIPTORS = __w_pdfjs_require__(25);
var FORCED = !DESCRIPTORS || fails(function () {
 nativeGetOwnPropertyDescriptor(1);
});
$({
 target: 'Object',
 stat: true,
 forced: FORCED,
 sham: !DESCRIPTORS
}, {
 getOwnPropertyDescriptor: function getOwnPropertyDescriptor(it, key) {
  return nativeGetOwnPropertyDescriptor(toIndexedObject(it), key);
 }
});

/***/ }),
/* 370 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var createTypedArrayConstructor = __w_pdfjs_require__(192);
createTypedArrayConstructor('Uint8', function (init) {
 return function Uint8ClampedArray(data, byteOffset, length) {
  return init(this, data, byteOffset, length);
 };
}, true);

/***/ }),
/* 371 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var global = __w_pdfjs_require__(5);
var DESCRIPTORS = __w_pdfjs_require__(25);
var defineBuiltInAccessor = __w_pdfjs_require__(87);
var regExpFlags = __w_pdfjs_require__(125);
var fails = __w_pdfjs_require__(9);
var RegExp = global.RegExp;
var RegExpPrototype = RegExp.prototype;
var FORCED = DESCRIPTORS && fails(function () {
 var INDICES_SUPPORT = true;
 try {
  RegExp('.', 'd');
 } catch (error) {
  INDICES_SUPPORT = false;
 }
 var O = {};
 var calls = '';
 var expected = INDICES_SUPPORT ? 'dgimsy' : 'gimsy';
 var addGetter = function (key, chr) {
  Object.defineProperty(O, key, {
   get: function () {
    calls += chr;
    return true;
   }
  });
 };
 var pairs = {
  dotAll: 's',
  global: 'g',
  ignoreCase: 'i',
  multiline: 'm',
  sticky: 'y'
 };
 if (INDICES_SUPPORT)
  pairs.hasIndices = 'd';
 for (var key in pairs)
  addGetter(key, pairs[key]);
 var result = Object.getOwnPropertyDescriptor(RegExpPrototype, 'flags').get.call(O);
 return result !== expected || calls !== expected;
});
if (FORCED)
 defineBuiltInAccessor(RegExpPrototype, 'flags', {
  configurable: true,
  get: regExpFlags
 });

/***/ }),
/* 372 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var toObject = __w_pdfjs_require__(10);
var lengthOfArrayLike = __w_pdfjs_require__(72);
var setArrayLength = __w_pdfjs_require__(290);
var deletePropertyOrThrow = __w_pdfjs_require__(211);
var doesNotExceedSafeInteger = __w_pdfjs_require__(291);
var INCORRECT_RESULT = [].unshift(0) !== 1;
var properErrorOnNonWritableLength = function () {
 try {
  Object.defineProperty([], 'length', { writable: false }).unshift();
 } catch (error) {
  return error instanceof TypeError;
 }
};
var FORCED = INCORRECT_RESULT || !properErrorOnNonWritableLength();
$({
 target: 'Array',
 proto: true,
 arity: 1,
 forced: FORCED
}, {
 unshift: function unshift(item) {
  var O = toObject(this);
  var len = lengthOfArrayLike(O);
  var argCount = arguments.length;
  if (argCount) {
   doesNotExceedSafeInteger(len + argCount);
   var k = len;
   while (k--) {
    var to = k + argCount;
    if (k in O)
     O[to] = O[k];
    else
     deletePropertyOrThrow(O, to);
   }
   for (var j = 0; j < argCount; j++) {
    O[j] = arguments[j];
   }
  }
  return setArrayLength(O, len + argCount);
 }
});

/***/ }),
/* 373 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var $trim = (__w_pdfjs_require__(111).trim);
var forcedStringTrimMethod = __w_pdfjs_require__(374);
$({
 target: 'String',
 proto: true,
 forced: forcedStringTrimMethod('trim')
}, {
 trim: function trim() {
  return $trim(this);
 }
});

/***/ }),
/* 374 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {


var PROPER_FUNCTION_NAME = (__w_pdfjs_require__(46).PROPER);
var fails = __w_pdfjs_require__(9);
var whitespaces = __w_pdfjs_require__(112);
var non = '\u200B\u0085\u180E';
module.exports = function (METHOD_NAME) {
 return fails(function () {
  return !!whitespaces[METHOD_NAME]() || non[METHOD_NAME]() !== non || PROPER_FUNCTION_NAME && whitespaces[METHOD_NAME].name !== METHOD_NAME;
 });
};

/***/ }),
/* 375 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var $find = (__w_pdfjs_require__(89).find);
var addToUnscopables = __w_pdfjs_require__(138);
var FIND = 'find';
var SKIPS_HOLES = true;
if (FIND in [])
 Array(1)[FIND](function () {
  SKIPS_HOLES = false;
 });
$({
 target: 'Array',
 proto: true,
 forced: SKIPS_HOLES
}, {
 find: function find(callbackfn) {
  return $find(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
 }
});
addToUnscopables(FIND);

/***/ }),
/* 376 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var $reduce = (__w_pdfjs_require__(233).left);
var arrayMethodIsStrict = __w_pdfjs_require__(230);
var CHROME_VERSION = __w_pdfjs_require__(21);
var IS_NODE = __w_pdfjs_require__(147);
var CHROME_BUG = !IS_NODE && CHROME_VERSION > 79 && CHROME_VERSION < 83;
var FORCED = CHROME_BUG || !arrayMethodIsStrict('reduce');
$({
 target: 'Array',
 proto: true,
 forced: FORCED
}, {
 reduce: function reduce(callbackfn) {
  var length = arguments.length;
  return $reduce(this, callbackfn, length, length > 1 ? arguments[1] : undefined);
 }
});

/***/ }),
/* 377 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

function _typeof(obj){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj;}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;},_typeof(obj);}__w_pdfjs_require__(304);__w_pdfjs_require__(305);__w_pdfjs_require__(183);__w_pdfjs_require__(2);__w_pdfjs_require__(54);__w_pdfjs_require__(56);__w_pdfjs_require__(104);__w_pdfjs_require__(105);__w_pdfjs_require__(113);__w_pdfjs_require__(292);__w_pdfjs_require__(129);Object.defineProperty(exports, "__esModule", ({value:true}));exports.FakeUnicodeFont=void 0;exports.createDefaultAppearance=createDefaultAppearance;exports.getPdfColor=getPdfColor;exports.parseAppearanceStream=parseAppearanceStream;exports.parseDefaultAppearance=parseDefaultAppearance;__w_pdfjs_require__(137);__w_pdfjs_require__(143);__w_pdfjs_require__(370);__w_pdfjs_require__(208);__w_pdfjs_require__(209);__w_pdfjs_require__(212);__w_pdfjs_require__(213);__w_pdfjs_require__(214);__w_pdfjs_require__(218);__w_pdfjs_require__(219);__w_pdfjs_require__(220);__w_pdfjs_require__(222);__w_pdfjs_require__(223);__w_pdfjs_require__(224);__w_pdfjs_require__(225);__w_pdfjs_require__(226);__w_pdfjs_require__(227);__w_pdfjs_require__(228);__w_pdfjs_require__(231);__w_pdfjs_require__(232);__w_pdfjs_require__(234);__w_pdfjs_require__(235);__w_pdfjs_require__(236);__w_pdfjs_require__(237);__w_pdfjs_require__(238);__w_pdfjs_require__(239);__w_pdfjs_require__(244);__w_pdfjs_require__(245);__w_pdfjs_require__(247);__w_pdfjs_require__(248);__w_pdfjs_require__(249);__w_pdfjs_require__(251);__w_pdfjs_require__(254);__w_pdfjs_require__(257);__w_pdfjs_require__(134);__w_pdfjs_require__(289);__w_pdfjs_require__(295);__w_pdfjs_require__(378);__w_pdfjs_require__(301);__w_pdfjs_require__(114);__w_pdfjs_require__(175);__w_pdfjs_require__(356);__w_pdfjs_require__(177);__w_pdfjs_require__(334);__w_pdfjs_require__(123);__w_pdfjs_require__(348);var _primitives=__w_pdfjs_require__(349);var _core_utils=__w_pdfjs_require__(342);var _util=__w_pdfjs_require__(303);var _colorspace=__w_pdfjs_require__(379);var _evaluator=__w_pdfjs_require__(382);var _image_utils=__w_pdfjs_require__(441);var _function=__w_pdfjs_require__(436);var _stream=__w_pdfjs_require__(357);function _createForOfIteratorHelper(o,allowArrayLike){var it=typeof Symbol!=="undefined"&&o[Symbol.iterator]||o["@@iterator"];if(!it){if(Array.isArray(o)||(it=_unsupportedIterableToArray(o))||allowArrayLike&&o&&typeof o.length==="number"){if(it)o=it;var i=0;var F=function F(){};return{s:F,n:function n(){if(i>=o.length)return{done:true};return{done:false,value:o[i++]};},e:function e(_e2){throw _e2;},f:F};}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}var normalCompletion=true,didErr=false,err;return{s:function s(){it=it.call(o);},n:function n(){var step=it.next();normalCompletion=step.done;return step;},e:function e(_e3){didErr=true;err=_e3;},f:function f(){try{if(!normalCompletion&&it.return!=null)it.return();}finally{if(didErr)throw err;}}};}function _toConsumableArray(arr){return _arrayWithoutHoles(arr)||_iterableToArray(arr)||_unsupportedIterableToArray(arr)||_nonIterableSpread();}function _nonIterableSpread(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}function _iterableToArray(iter){if(typeof Symbol!=="undefined"&&iter[Symbol.iterator]!=null||iter["@@iterator"]!=null)return Array.from(iter);}function _arrayWithoutHoles(arr){if(Array.isArray(arr))return _arrayLikeToArray(arr);}function _slicedToArray(arr,i){return _arrayWithHoles(arr)||_iterableToArrayLimit(arr,i)||_unsupportedIterableToArray(arr,i)||_nonIterableRest();}function _nonIterableRest(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}function _unsupportedIterableToArray(o,minLen){if(!o)return;if(typeof o==="string")return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);if(n==="Object"&&o.constructor)n=o.constructor.name;if(n==="Map"||n==="Set")return Array.from(o);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return _arrayLikeToArray(o,minLen);}function _arrayLikeToArray(arr,len){if(len==null||len>arr.length)len=arr.length;for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2;}function _iterableToArrayLimit(arr,i){var _i=null==arr?null:"undefined"!=typeof Symbol&&arr[Symbol.iterator]||arr["@@iterator"];if(null!=_i){var _s,_e,_x,_r,_arr=[],_n=!0,_d=!1;try{if(_x=(_i=_i.call(arr)).next,0===i){if(Object(_i)!==_i)return;_n=!1;}else for(;!(_n=(_s=_x.call(_i)).done)&&(_arr.push(_s.value),_arr.length!==i);_n=!0);}catch(err){_d=!0,_e=err;}finally{try{if(!_n&&null!=_i.return&&(_r=_i.return(),Object(_r)!==_r))return;}finally{if(_d)throw _e;}}return _arr;}}function _arrayWithHoles(arr){if(Array.isArray(arr))return arr;}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}}function _createClass(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);Object.defineProperty(Constructor,"prototype",{writable:false});return Constructor;}function _toPropertyKey(arg){var key=_toPrimitive(arg,"string");return _typeof(key)==="symbol"?key:String(key);}function _toPrimitive(input,hint){if(_typeof(input)!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(_typeof(res)!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.");}return(hint==="string"?String:Number)(input);}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function");}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:true,configurable:true}});Object.defineProperty(subClass,"prototype",{writable:false});if(superClass)_setPrototypeOf(subClass,superClass);}function _setPrototypeOf(o,p){_setPrototypeOf=Object.setPrototypeOf?Object.setPrototypeOf.bind():function _setPrototypeOf(o,p){o.__proto__=p;return o;};return _setPrototypeOf(o,p);}function _createSuper(Derived){var hasNativeReflectConstruct=_isNativeReflectConstruct();return function _createSuperInternal(){var Super=_getPrototypeOf(Derived),result;if(hasNativeReflectConstruct){var NewTarget=_getPrototypeOf(this).constructor;result=Reflect.construct(Super,arguments,NewTarget);}else{result=Super.apply(this,arguments);}return _possibleConstructorReturn(this,result);};}function _possibleConstructorReturn(self,call){if(call&&(_typeof(call)==="object"||typeof call==="function")){return call;}else if(call!==void 0){throw new TypeError("Derived constructors may only return object or undefined");}return _assertThisInitialized(self);}function _assertThisInitialized(self){if(self===void 0){throw new ReferenceError("this hasn't been initialised - super() hasn't been called");}return self;}function _isNativeReflectConstruct(){if(typeof Reflect==="undefined"||!Reflect.construct)return false;if(Reflect.construct.sham)return false;if(typeof Proxy==="function")return true;try{Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}));return true;}catch(e){return false;}}function _getPrototypeOf(o){_getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf.bind():function _getPrototypeOf(o){return o.__proto__||Object.getPrototypeOf(o);};return _getPrototypeOf(o);}var DefaultAppearanceEvaluator=/*#__PURE__*/function(_EvaluatorPreprocesso){_inherits(DefaultAppearanceEvaluator,_EvaluatorPreprocesso);var _super=_createSuper(DefaultAppearanceEvaluator);function DefaultAppearanceEvaluator(str){_classCallCheck(this,DefaultAppearanceEvaluator);return _super.call(this,new _stream.StringStream(str));}_createClass(DefaultAppearanceEvaluator,[{key:"parse",value:function parse(){var operation={fn:0,args:[]};var result={fontSize:0,fontName:"",fontColor:new Uint8ClampedArray(3)};try{while(true){operation.args.length=0;if(!this.read(operation)){break;}if(this.savedStatesDepth!==0){continue;}var fn=operation.fn,args=operation.args;switch(fn|0){case _util.OPS.setFont:var _args=_slicedToArray(args,2),fontName=_args[0],fontSize=_args[1];if(fontName instanceof _primitives.Name){result.fontName=fontName.name;}if(typeof fontSize==="number"&&fontSize>0){result.fontSize=fontSize;}break;case _util.OPS.setFillRGBColor:_colorspace.ColorSpace.singletons.rgb.getRgbItem(args,0,result.fontColor,0);break;case _util.OPS.setFillGray:_colorspace.ColorSpace.singletons.gray.getRgbItem(args,0,result.fontColor,0);break;case _util.OPS.setFillCMYKColor:_colorspace.ColorSpace.singletons.cmyk.getRgbItem(args,0,result.fontColor,0);break;}}}catch(reason){(0,_util.warn)("parseDefaultAppearance - ignoring errors: \"".concat(reason,"\"."));}return result;}}]);return DefaultAppearanceEvaluator;}(_evaluator.EvaluatorPreprocessor);function parseDefaultAppearance(str){return new DefaultAppearanceEvaluator(str).parse();}var AppearanceStreamEvaluator=/*#__PURE__*/function(_EvaluatorPreprocesso2){_inherits(AppearanceStreamEvaluator,_EvaluatorPreprocesso2);var _super2=_createSuper(AppearanceStreamEvaluator);function AppearanceStreamEvaluator(stream,evaluatorOptions,xref){var _stream$dict;var _this;_classCallCheck(this,AppearanceStreamEvaluator);_this=_super2.call(this,stream);_this.stream=stream;_this.evaluatorOptions=evaluatorOptions;_this.xref=xref;_this.resources=(_stream$dict=stream.dict)===null||_stream$dict===void 0?void 0:_stream$dict.get("Resources");return _this;}_createClass(AppearanceStreamEvaluator,[{key:"parse",value:function parse(){var operation={fn:0,args:[]};var result={scaleFactor:1,fontSize:0,fontName:"",fontColor:new Uint8ClampedArray(3),fillColorSpace:_colorspace.ColorSpace.singletons.gray};var breakLoop=false;var stack=[];try{while(true){operation.args.length=0;if(breakLoop||!this.read(operation)){break;}var fn=operation.fn,args=operation.args;switch(fn|0){case _util.OPS.save:stack.push({scaleFactor:result.scaleFactor,fontSize:result.fontSize,fontName:result.fontName,fontColor:result.fontColor.slice(),fillColorSpace:result.fillColorSpace});break;case _util.OPS.restore:result=stack.pop()||result;break;case _util.OPS.setTextMatrix:result.scaleFactor*=Math.hypot(args[0],args[1]);break;case _util.OPS.setFont:var _args2=_slicedToArray(args,2),fontName=_args2[0],fontSize=_args2[1];if(fontName instanceof _primitives.Name){result.fontName=fontName.name;}if(typeof fontSize==="number"&&fontSize>0){result.fontSize=fontSize*result.scaleFactor;}break;case _util.OPS.setFillColorSpace:result.fillColorSpace=_colorspace.ColorSpace.parse({cs:args[0],xref:this.xref,resources:this.resources,pdfFunctionFactory:this._pdfFunctionFactory,localColorSpaceCache:this._localColorSpaceCache});break;case _util.OPS.setFillColor:var cs=result.fillColorSpace;cs.getRgbItem(args,0,result.fontColor,0);break;case _util.OPS.setFillRGBColor:_colorspace.ColorSpace.singletons.rgb.getRgbItem(args,0,result.fontColor,0);break;case _util.OPS.setFillGray:_colorspace.ColorSpace.singletons.gray.getRgbItem(args,0,result.fontColor,0);break;case _util.OPS.setFillCMYKColor:_colorspace.ColorSpace.singletons.cmyk.getRgbItem(args,0,result.fontColor,0);break;case _util.OPS.showText:case _util.OPS.showSpacedText:case _util.OPS.nextLineShowText:case _util.OPS.nextLineSetSpacingShowText:breakLoop=true;break;}}}catch(reason){(0,_util.warn)("parseAppearanceStream - ignoring errors: \"".concat(reason,"\"."));}this.stream.reset();delete result.scaleFactor;delete result.fillColorSpace;return result;}},{key:"_localColorSpaceCache",get:function get(){return(0,_util.shadow)(this,"_localColorSpaceCache",new _image_utils.LocalColorSpaceCache());}},{key:"_pdfFunctionFactory",get:function get(){var pdfFunctionFactory=new _function.PDFFunctionFactory({xref:this.xref,isEvalSupported:this.evaluatorOptions.isEvalSupported});return(0,_util.shadow)(this,"_pdfFunctionFactory",pdfFunctionFactory);}}]);return AppearanceStreamEvaluator;}(_evaluator.EvaluatorPreprocessor);function parseAppearanceStream(stream,evaluatorOptions,xref){return new AppearanceStreamEvaluator(stream,evaluatorOptions,xref).parse();}function getPdfColor(color,isFill){if(color[0]===color[1]&&color[1]===color[2]){var gray=color[0]/255;return"".concat((0,_core_utils.numberToString)(gray)," ").concat(isFill?"g":"G");}return Array.from(color,function(c){return(0,_core_utils.numberToString)(c/255);}).join(" ")+" ".concat(isFill?"rg":"RG");}function createDefaultAppearance(_ref){var fontSize=_ref.fontSize,fontName=_ref.fontName,fontColor=_ref.fontColor;return"/".concat((0,_core_utils.escapePDFName)(fontName)," ").concat(fontSize," Tf ").concat(getPdfColor(fontColor,true));}var FakeUnicodeFont=/*#__PURE__*/function(){function FakeUnicodeFont(xref,fontFamily){_classCallCheck(this,FakeUnicodeFont);this.xref=xref;this.widths=null;this.firstChar=Infinity;this.lastChar=-Infinity;this.fontFamily=fontFamily;var canvas=new OffscreenCanvas(1,1);this.ctxMeasure=canvas.getContext("2d");if(!FakeUnicodeFont._fontNameId){FakeUnicodeFont._fontNameId=1;}this.fontName=_primitives.Name.get("InvalidPDFjsFont_".concat(fontFamily,"_").concat(FakeUnicodeFont._fontNameId++));}_createClass(FakeUnicodeFont,[{key:"toUnicodeRef",get:function get(){if(!FakeUnicodeFont._toUnicodeRef){var toUnicode="/CIDInit /ProcSet findresource begin\n12 dict begin\nbegincmap\n/CIDSystemInfo\n<< /Registry (Adobe)\n/Ordering (UCS) /Supplement 0 >> def\n/CMapName /Adobe-Identity-UCS def\n/CMapType 2 def\n1 begincodespacerange\n<0000> <FFFF>\nendcodespacerange\n1 beginbfrange\n<0000> <FFFF> <0000>\nendbfrange\nendcmap CMapName currentdict /CMap defineresource pop end end";var toUnicodeStream=FakeUnicodeFont.toUnicodeStream=new _stream.StringStream(toUnicode);var toUnicodeDict=new _primitives.Dict(this.xref);toUnicodeStream.dict=toUnicodeDict;toUnicodeDict.set("Length",toUnicode.length);FakeUnicodeFont._toUnicodeRef=this.xref.getNewPersistentRef(toUnicodeStream);}return FakeUnicodeFont._toUnicodeRef;}},{key:"fontDescriptorRef",get:function get(){if(!FakeUnicodeFont._fontDescriptorRef){var fontDescriptor=new _primitives.Dict(this.xref);fontDescriptor.set("Type",_primitives.Name.get("FontDescriptor"));fontDescriptor.set("FontName",this.fontName);fontDescriptor.set("FontFamily","MyriadPro Regular");fontDescriptor.set("FontBBox",[0,0,0,0]);fontDescriptor.set("FontStretch",_primitives.Name.get("Normal"));fontDescriptor.set("FontWeight",400);fontDescriptor.set("ItalicAngle",0);FakeUnicodeFont._fontDescriptorRef=this.xref.getNewPersistentRef(fontDescriptor);}return FakeUnicodeFont._fontDescriptorRef;}},{key:"descendantFontRef",get:function get(){var descendantFont=new _primitives.Dict(this.xref);descendantFont.set("BaseFont",this.fontName);descendantFont.set("Type",_primitives.Name.get("Font"));descendantFont.set("Subtype",_primitives.Name.get("CIDFontType0"));descendantFont.set("CIDToGIDMap",_primitives.Name.get("Identity"));descendantFont.set("FirstChar",this.firstChar);descendantFont.set("LastChar",this.lastChar);descendantFont.set("FontDescriptor",this.fontDescriptorRef);descendantFont.set("DW",1000);var widths=[];var chars=_toConsumableArray(this.widths.entries()).sort();var currentChar=null;var currentWidths=null;var _iterator=_createForOfIteratorHelper(chars),_step;try{for(_iterator.s();!(_step=_iterator.n()).done;){var _step$value=_slicedToArray(_step.value,2),char=_step$value[0],width=_step$value[1];if(!currentChar){currentChar=char;currentWidths=[width];continue;}if(char===currentChar+currentWidths.length){currentWidths.push(width);}else{widths.push(currentChar,currentWidths);currentChar=char;currentWidths=[width];}}}catch(err){_iterator.e(err);}finally{_iterator.f();}if(currentChar){widths.push(currentChar,currentWidths);}descendantFont.set("W",widths);var cidSystemInfo=new _primitives.Dict(this.xref);cidSystemInfo.set("Ordering","Identity");cidSystemInfo.set("Registry","Adobe");cidSystemInfo.set("Supplement",0);descendantFont.set("CIDSystemInfo",cidSystemInfo);return this.xref.getNewPersistentRef(descendantFont);}},{key:"baseFontRef",get:function get(){var baseFont=new _primitives.Dict(this.xref);baseFont.set("BaseFont",this.fontName);baseFont.set("Type",_primitives.Name.get("Font"));baseFont.set("Subtype",_primitives.Name.get("Type0"));baseFont.set("Encoding",_primitives.Name.get("Identity-H"));baseFont.set("DescendantFonts",[this.descendantFontRef]);baseFont.set("ToUnicode",this.toUnicodeRef);return this.xref.getNewPersistentRef(baseFont);}},{key:"resources",get:function get(){var resources=new _primitives.Dict(this.xref);var font=new _primitives.Dict(this.xref);font.set(this.fontName.name,this.baseFontRef);resources.set("Font",font);return resources;}},{key:"_createContext",value:function _createContext(){this.widths=new Map();this.ctxMeasure.font="1000px ".concat(this.fontFamily);return this.ctxMeasure;}},{key:"createFontResources",value:function createFontResources(text){var ctx=this._createContext();var _iterator2=_createForOfIteratorHelper(text.split(/\r\n?|\n/)),_step2;try{for(_iterator2.s();!(_step2=_iterator2.n()).done;){var line=_step2.value;var _iterator3=_createForOfIteratorHelper(line.split("")),_step3;try{for(_iterator3.s();!(_step3=_iterator3.n()).done;){var char=_step3.value;var code=char.charCodeAt(0);if(this.widths.has(code)){continue;}var metrics=ctx.measureText(char);var width=Math.ceil(metrics.width);this.widths.set(code,width);this.firstChar=Math.min(code,this.firstChar);this.lastChar=Math.max(code,this.lastChar);}}catch(err){_iterator3.e(err);}finally{_iterator3.f();}}}catch(err){_iterator2.e(err);}finally{_iterator2.f();}return this.resources;}},{key:"createAppearance",value:function createAppearance(text,rect,rotation,fontSize,bgColor,strokeAlpha){var ctx=this._createContext();var lines=[];var maxWidth=-Infinity;var _iterator4=_createForOfIteratorHelper(text.split(/\r\n?|\n/)),_step4;try{for(_iterator4.s();!(_step4=_iterator4.n()).done;){var _line=_step4.value;lines.push(_line);var lineWidth=ctx.measureText(_line).width;maxWidth=Math.max(maxWidth,lineWidth);var _iterator5=_createForOfIteratorHelper(_line.split("")),_step5;try{for(_iterator5.s();!(_step5=_iterator5.n()).done;){var char=_step5.value;var code=char.charCodeAt(0);var width=this.widths.get(code);if(width===undefined){var metrics=ctx.measureText(char);width=Math.ceil(metrics.width);this.widths.set(code,width);this.firstChar=Math.min(code,this.firstChar);this.lastChar=Math.max(code,this.lastChar);}}}catch(err){_iterator5.e(err);}finally{_iterator5.f();}}}catch(err){_iterator4.e(err);}finally{_iterator4.f();}maxWidth*=fontSize/1000;var _rect=_slicedToArray(rect,4),x1=_rect[0],y1=_rect[1],x2=_rect[2],y2=_rect[3];var w=x2-x1;var h=y2-y1;if(rotation%180!==0){var _ref2=[h,w];w=_ref2[0];h=_ref2[1];}var hscale=1;if(maxWidth>w){hscale=w/maxWidth;}var vscale=1;var lineHeight=_util.LINE_FACTOR*fontSize;var lineDescent=_util.LINE_DESCENT_FACTOR*fontSize;var maxHeight=lineHeight*lines.length;if(maxHeight>h){vscale=h/maxHeight;}var fscale=Math.min(hscale,vscale);var newFontSize=fontSize*fscale;var buffer=["q","0 0 ".concat((0,_core_utils.numberToString)(w)," ").concat((0,_core_utils.numberToString)(h)," re W n"),"BT","1 0 0 1 0 ".concat((0,_core_utils.numberToString)(h+lineDescent)," Tm 0 Tc ").concat(getPdfColor(bgColor,true)),"/".concat(this.fontName.name," ").concat((0,_core_utils.numberToString)(newFontSize)," Tf")];var resources=this.resources;strokeAlpha=typeof strokeAlpha==="number"&&strokeAlpha>=0&&strokeAlpha<=1?strokeAlpha:1;if(strokeAlpha!==1){buffer.push("/R0 gs");var extGState=new _primitives.Dict(this.xref);var r0=new _primitives.Dict(this.xref);r0.set("ca",strokeAlpha);r0.set("CA",strokeAlpha);r0.set("Type",_primitives.Name.get("ExtGState"));extGState.set("R0",r0);resources.set("ExtGState",extGState);}var vShift=(0,_core_utils.numberToString)(lineHeight);for(var _i2=0,_lines=lines;_i2<_lines.length;_i2++){var line=_lines[_i2];buffer.push("0 -".concat(vShift," Td <").concat((0,_core_utils.stringToUTF16HexString)(line),"> Tj"));}buffer.push("ET","Q");var appearance=buffer.join("\n");var appearanceStreamDict=new _primitives.Dict(this.xref);appearanceStreamDict.set("Subtype",_primitives.Name.get("Form"));appearanceStreamDict.set("Type",_primitives.Name.get("XObject"));appearanceStreamDict.set("BBox",[0,0,w,h]);appearanceStreamDict.set("Length",appearance.length);appearanceStreamDict.set("Resources",resources);if(rotation){var matrix=(0,_core_utils.getRotationMatrix)(rotation,w,h);appearanceStreamDict.set("Matrix",matrix);}var ap=new _stream.StringStream(appearance);ap.dict=appearanceStreamDict;return ap;}}]);return FakeUnicodeFont;}();exports.FakeUnicodeFont=FakeUnicodeFont;

/***/ }),
/* 378 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var $hypot = Math.hypot;
var abs = Math.abs;
var sqrt = Math.sqrt;
var FORCED = !!$hypot && $hypot(Infinity, NaN) !== Infinity;
$({
 target: 'Math',
 stat: true,
 arity: 2,
 forced: FORCED
}, {
 hypot: function hypot(value1, value2) {
  var sum = 0;
  var i = 0;
  var aLen = arguments.length;
  var larg = 0;
  var arg, div;
  while (i < aLen) {
   arg = abs(arguments[i++]);
   if (larg < arg) {
    div = larg / arg;
    sum = sum * div * div + 1;
    larg = arg;
   } else if (arg > 0) {
    div = arg / larg;
    sum += div * div;
   } else
    sum += arg;
  }
  return larg === Infinity ? Infinity : larg * sqrt(sum);
 }
});

/***/ }),
/* 379 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

__w_pdfjs_require__(2);__w_pdfjs_require__(54);__w_pdfjs_require__(56);__w_pdfjs_require__(104);__w_pdfjs_require__(145);__w_pdfjs_require__(113);__w_pdfjs_require__(175);__w_pdfjs_require__(177);__w_pdfjs_require__(130);__w_pdfjs_require__(131);__w_pdfjs_require__(132);__w_pdfjs_require__(133);__w_pdfjs_require__(134);__w_pdfjs_require__(289);__w_pdfjs_require__(299);__w_pdfjs_require__(295);__w_pdfjs_require__(304);__w_pdfjs_require__(305);function _typeof(obj){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj;}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;},_typeof(obj);}Object.defineProperty(exports, "__esModule", ({value:true}));exports.ColorSpace=void 0;__w_pdfjs_require__(137);__w_pdfjs_require__(143);__w_pdfjs_require__(380);__w_pdfjs_require__(208);__w_pdfjs_require__(209);__w_pdfjs_require__(212);__w_pdfjs_require__(213);__w_pdfjs_require__(214);__w_pdfjs_require__(218);__w_pdfjs_require__(219);__w_pdfjs_require__(220);__w_pdfjs_require__(222);__w_pdfjs_require__(223);__w_pdfjs_require__(224);__w_pdfjs_require__(225);__w_pdfjs_require__(226);__w_pdfjs_require__(227);__w_pdfjs_require__(228);__w_pdfjs_require__(231);__w_pdfjs_require__(232);__w_pdfjs_require__(234);__w_pdfjs_require__(235);__w_pdfjs_require__(236);__w_pdfjs_require__(237);__w_pdfjs_require__(238);__w_pdfjs_require__(239);__w_pdfjs_require__(244);__w_pdfjs_require__(245);__w_pdfjs_require__(247);__w_pdfjs_require__(248);__w_pdfjs_require__(249);__w_pdfjs_require__(251);__w_pdfjs_require__(254);__w_pdfjs_require__(257);__w_pdfjs_require__(370);__w_pdfjs_require__(191);__w_pdfjs_require__(183);__w_pdfjs_require__(381);__w_pdfjs_require__(105);__w_pdfjs_require__(301);var _util=__w_pdfjs_require__(303);var _primitives=__w_pdfjs_require__(349);var _base_stream=__w_pdfjs_require__(353);var _core_utils=__w_pdfjs_require__(342);function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function");}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:true,configurable:true}});Object.defineProperty(subClass,"prototype",{writable:false});if(superClass)_setPrototypeOf(subClass,superClass);}function _setPrototypeOf(o,p){_setPrototypeOf=Object.setPrototypeOf?Object.setPrototypeOf.bind():function _setPrototypeOf(o,p){o.__proto__=p;return o;};return _setPrototypeOf(o,p);}function _createSuper(Derived){var hasNativeReflectConstruct=_isNativeReflectConstruct();return function _createSuperInternal(){var Super=_getPrototypeOf(Derived),result;if(hasNativeReflectConstruct){var NewTarget=_getPrototypeOf(this).constructor;result=Reflect.construct(Super,arguments,NewTarget);}else{result=Super.apply(this,arguments);}return _possibleConstructorReturn(this,result);};}function _possibleConstructorReturn(self,call){if(call&&(_typeof(call)==="object"||typeof call==="function")){return call;}else if(call!==void 0){throw new TypeError("Derived constructors may only return object or undefined");}return _assertThisInitialized(self);}function _assertThisInitialized(self){if(self===void 0){throw new ReferenceError("this hasn't been initialised - super() hasn't been called");}return self;}function _isNativeReflectConstruct(){if(typeof Reflect==="undefined"||!Reflect.construct)return false;if(Reflect.construct.sham)return false;if(typeof Proxy==="function")return true;try{Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}));return true;}catch(e){return false;}}function _getPrototypeOf(o){_getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf.bind():function _getPrototypeOf(o){return o.__proto__||Object.getPrototypeOf(o);};return _getPrototypeOf(o);}function _regeneratorRuntime(){"use strict";/*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */_regeneratorRuntime=function _regeneratorRuntime(){return exports;};var exports={},Op=Object.prototype,hasOwn=Op.hasOwnProperty,defineProperty=Object.defineProperty||function(obj,key,desc){obj[key]=desc.value;},$Symbol="function"==typeof Symbol?Symbol:{},iteratorSymbol=$Symbol.iterator||"@@iterator",asyncIteratorSymbol=$Symbol.asyncIterator||"@@asyncIterator",toStringTagSymbol=$Symbol.toStringTag||"@@toStringTag";function define(obj,key,value){return Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}),obj[key];}try{define({},"");}catch(err){define=function define(obj,key,value){return obj[key]=value;};}function wrap(innerFn,outerFn,self,tryLocsList){var protoGenerator=outerFn&&outerFn.prototype instanceof Generator?outerFn:Generator,generator=Object.create(protoGenerator.prototype),context=new Context(tryLocsList||[]);return defineProperty(generator,"_invoke",{value:makeInvokeMethod(innerFn,self,context)}),generator;}function tryCatch(fn,obj,arg){try{return{type:"normal",arg:fn.call(obj,arg)};}catch(err){return{type:"throw",arg:err};}}exports.wrap=wrap;var ContinueSentinel={};function Generator(){}function GeneratorFunction(){}function GeneratorFunctionPrototype(){}var IteratorPrototype={};define(IteratorPrototype,iteratorSymbol,function(){return this;});var getProto=Object.getPrototypeOf,NativeIteratorPrototype=getProto&&getProto(getProto(values([])));NativeIteratorPrototype&&NativeIteratorPrototype!==Op&&hasOwn.call(NativeIteratorPrototype,iteratorSymbol)&&(IteratorPrototype=NativeIteratorPrototype);var Gp=GeneratorFunctionPrototype.prototype=Generator.prototype=Object.create(IteratorPrototype);function defineIteratorMethods(prototype){["next","throw","return"].forEach(function(method){define(prototype,method,function(arg){return this._invoke(method,arg);});});}function AsyncIterator(generator,PromiseImpl){function invoke(method,arg,resolve,reject){var record=tryCatch(generator[method],generator,arg);if("throw"!==record.type){var result=record.arg,value=result.value;return value&&"object"==_typeof(value)&&hasOwn.call(value,"__await")?PromiseImpl.resolve(value.__await).then(function(value){invoke("next",value,resolve,reject);},function(err){invoke("throw",err,resolve,reject);}):PromiseImpl.resolve(value).then(function(unwrapped){result.value=unwrapped,resolve(result);},function(error){return invoke("throw",error,resolve,reject);});}reject(record.arg);}var previousPromise;defineProperty(this,"_invoke",{value:function value(method,arg){function callInvokeWithMethodAndArg(){return new PromiseImpl(function(resolve,reject){invoke(method,arg,resolve,reject);});}return previousPromise=previousPromise?previousPromise.then(callInvokeWithMethodAndArg,callInvokeWithMethodAndArg):callInvokeWithMethodAndArg();}});}function makeInvokeMethod(innerFn,self,context){var state="suspendedStart";return function(method,arg){if("executing"===state)throw new Error("Generator is already running");if("completed"===state){if("throw"===method)throw arg;return doneResult();}for(context.method=method,context.arg=arg;;){var delegate=context.delegate;if(delegate){var delegateResult=maybeInvokeDelegate(delegate,context);if(delegateResult){if(delegateResult===ContinueSentinel)continue;return delegateResult;}}if("next"===context.method)context.sent=context._sent=context.arg;else if("throw"===context.method){if("suspendedStart"===state)throw state="completed",context.arg;context.dispatchException(context.arg);}else"return"===context.method&&context.abrupt("return",context.arg);state="executing";var record=tryCatch(innerFn,self,context);if("normal"===record.type){if(state=context.done?"completed":"suspendedYield",record.arg===ContinueSentinel)continue;return{value:record.arg,done:context.done};}"throw"===record.type&&(state="completed",context.method="throw",context.arg=record.arg);}};}function maybeInvokeDelegate(delegate,context){var methodName=context.method,method=delegate.iterator[methodName];if(undefined===method)return context.delegate=null,"throw"===methodName&&delegate.iterator.return&&(context.method="return",context.arg=undefined,maybeInvokeDelegate(delegate,context),"throw"===context.method)||"return"!==methodName&&(context.method="throw",context.arg=new TypeError("The iterator does not provide a '"+methodName+"' method")),ContinueSentinel;var record=tryCatch(method,delegate.iterator,context.arg);if("throw"===record.type)return context.method="throw",context.arg=record.arg,context.delegate=null,ContinueSentinel;var info=record.arg;return info?info.done?(context[delegate.resultName]=info.value,context.next=delegate.nextLoc,"return"!==context.method&&(context.method="next",context.arg=undefined),context.delegate=null,ContinueSentinel):info:(context.method="throw",context.arg=new TypeError("iterator result is not an object"),context.delegate=null,ContinueSentinel);}function pushTryEntry(locs){var entry={tryLoc:locs[0]};1 in locs&&(entry.catchLoc=locs[1]),2 in locs&&(entry.finallyLoc=locs[2],entry.afterLoc=locs[3]),this.tryEntries.push(entry);}function resetTryEntry(entry){var record=entry.completion||{};record.type="normal",delete record.arg,entry.completion=record;}function Context(tryLocsList){this.tryEntries=[{tryLoc:"root"}],tryLocsList.forEach(pushTryEntry,this),this.reset(!0);}function values(iterable){if(iterable){var iteratorMethod=iterable[iteratorSymbol];if(iteratorMethod)return iteratorMethod.call(iterable);if("function"==typeof iterable.next)return iterable;if(!isNaN(iterable.length)){var i=-1,next=function next(){for(;++i<iterable.length;)if(hasOwn.call(iterable,i))return next.value=iterable[i],next.done=!1,next;return next.value=undefined,next.done=!0,next;};return next.next=next;}}return{next:doneResult};}function doneResult(){return{value:undefined,done:!0};}return GeneratorFunction.prototype=GeneratorFunctionPrototype,defineProperty(Gp,"constructor",{value:GeneratorFunctionPrototype,configurable:!0}),defineProperty(GeneratorFunctionPrototype,"constructor",{value:GeneratorFunction,configurable:!0}),GeneratorFunction.displayName=define(GeneratorFunctionPrototype,toStringTagSymbol,"GeneratorFunction"),exports.isGeneratorFunction=function(genFun){var ctor="function"==typeof genFun&&genFun.constructor;return!!ctor&&(ctor===GeneratorFunction||"GeneratorFunction"===(ctor.displayName||ctor.name));},exports.mark=function(genFun){return Object.setPrototypeOf?Object.setPrototypeOf(genFun,GeneratorFunctionPrototype):(genFun.__proto__=GeneratorFunctionPrototype,define(genFun,toStringTagSymbol,"GeneratorFunction")),genFun.prototype=Object.create(Gp),genFun;},exports.awrap=function(arg){return{__await:arg};},defineIteratorMethods(AsyncIterator.prototype),define(AsyncIterator.prototype,asyncIteratorSymbol,function(){return this;}),exports.AsyncIterator=AsyncIterator,exports.async=function(innerFn,outerFn,self,tryLocsList,PromiseImpl){void 0===PromiseImpl&&(PromiseImpl=Promise);var iter=new AsyncIterator(wrap(innerFn,outerFn,self,tryLocsList),PromiseImpl);return exports.isGeneratorFunction(outerFn)?iter:iter.next().then(function(result){return result.done?result.value:iter.next();});},defineIteratorMethods(Gp),define(Gp,toStringTagSymbol,"Generator"),define(Gp,iteratorSymbol,function(){return this;}),define(Gp,"toString",function(){return"[object Generator]";}),exports.keys=function(val){var object=Object(val),keys=[];for(var key in object)keys.push(key);return keys.reverse(),function next(){for(;keys.length;){var key=keys.pop();if(key in object)return next.value=key,next.done=!1,next;}return next.done=!0,next;};},exports.values=values,Context.prototype={constructor:Context,reset:function reset(skipTempReset){if(this.prev=0,this.next=0,this.sent=this._sent=undefined,this.done=!1,this.delegate=null,this.method="next",this.arg=undefined,this.tryEntries.forEach(resetTryEntry),!skipTempReset)for(var name in this)"t"===name.charAt(0)&&hasOwn.call(this,name)&&!isNaN(+name.slice(1))&&(this[name]=undefined);},stop:function stop(){this.done=!0;var rootRecord=this.tryEntries[0].completion;if("throw"===rootRecord.type)throw rootRecord.arg;return this.rval;},dispatchException:function dispatchException(exception){if(this.done)throw exception;var context=this;function handle(loc,caught){return record.type="throw",record.arg=exception,context.next=loc,caught&&(context.method="next",context.arg=undefined),!!caught;}for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i],record=entry.completion;if("root"===entry.tryLoc)return handle("end");if(entry.tryLoc<=this.prev){var hasCatch=hasOwn.call(entry,"catchLoc"),hasFinally=hasOwn.call(entry,"finallyLoc");if(hasCatch&&hasFinally){if(this.prev<entry.catchLoc)return handle(entry.catchLoc,!0);if(this.prev<entry.finallyLoc)return handle(entry.finallyLoc);}else if(hasCatch){if(this.prev<entry.catchLoc)return handle(entry.catchLoc,!0);}else{if(!hasFinally)throw new Error("try statement without catch or finally");if(this.prev<entry.finallyLoc)return handle(entry.finallyLoc);}}}},abrupt:function abrupt(type,arg){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.tryLoc<=this.prev&&hasOwn.call(entry,"finallyLoc")&&this.prev<entry.finallyLoc){var finallyEntry=entry;break;}}finallyEntry&&("break"===type||"continue"===type)&&finallyEntry.tryLoc<=arg&&arg<=finallyEntry.finallyLoc&&(finallyEntry=null);var record=finallyEntry?finallyEntry.completion:{};return record.type=type,record.arg=arg,finallyEntry?(this.method="next",this.next=finallyEntry.finallyLoc,ContinueSentinel):this.complete(record);},complete:function complete(record,afterLoc){if("throw"===record.type)throw record.arg;return"break"===record.type||"continue"===record.type?this.next=record.arg:"return"===record.type?(this.rval=this.arg=record.arg,this.method="return",this.next="end"):"normal"===record.type&&afterLoc&&(this.next=afterLoc),ContinueSentinel;},finish:function finish(finallyLoc){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.finallyLoc===finallyLoc)return this.complete(entry.completion,entry.afterLoc),resetTryEntry(entry),ContinueSentinel;}},catch:function _catch(tryLoc){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.tryLoc===tryLoc){var record=entry.completion;if("throw"===record.type){var thrown=record.arg;resetTryEntry(entry);}return thrown;}}throw new Error("illegal catch attempt");},delegateYield:function delegateYield(iterable,resultName,nextLoc){return this.delegate={iterator:values(iterable),resultName:resultName,nextLoc:nextLoc},"next"===this.method&&(this.arg=undefined),ContinueSentinel;}},exports;}function asyncGeneratorStep(gen,resolve,reject,_next,_throw,key,arg){try{var info=gen[key](arg);var value=info.value;}catch(error){reject(error);return;}if(info.done){resolve(value);}else{Promise.resolve(value).then(_next,_throw);}}function _asyncToGenerator(fn){return function(){var self=this,args=arguments;return new Promise(function(resolve,reject){var gen=fn.apply(self,args);function _next(value){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"next",value);}function _throw(err){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"throw",err);}_next(undefined);});};}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}}function _createClass(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);Object.defineProperty(Constructor,"prototype",{writable:false});return Constructor;}function _toPropertyKey(arg){var key=_toPrimitive(arg,"string");return _typeof(key)==="symbol"?key:String(key);}function _toPrimitive(input,hint){if(_typeof(input)!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(_typeof(res)!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.");}return(hint==="string"?String:Number)(input);}function resizeRgbImage(src,dest,w1,h1,w2,h2,alpha01){var COMPONENTS=3;alpha01=alpha01!==1?0:alpha01;var xRatio=w1/w2;var yRatio=h1/h2;var newIndex=0,oldIndex;var xScaled=new Uint16Array(w2);var w1Scanline=w1*COMPONENTS;for(var i=0;i<w2;i++){xScaled[i]=Math.floor(i*xRatio)*COMPONENTS;}for(var _i=0;_i<h2;_i++){var py=Math.floor(_i*yRatio)*w1Scanline;for(var j=0;j<w2;j++){oldIndex=py+xScaled[j];dest[newIndex++]=src[oldIndex++];dest[newIndex++]=src[oldIndex++];dest[newIndex++]=src[oldIndex++];newIndex+=alpha01;}}}var ColorSpace=/*#__PURE__*/function(){function ColorSpace(name,numComps){_classCallCheck(this,ColorSpace);if(this.constructor===ColorSpace){(0,_util.unreachable)("Cannot initialize ColorSpace.");}this.name=name;this.numComps=numComps;}_createClass(ColorSpace,[{key:"getRgb",value:function getRgb(src,srcOffset){var rgb=new Uint8ClampedArray(3);this.getRgbItem(src,srcOffset,rgb,0);return rgb;}},{key:"getRgbItem",value:function getRgbItem(src,srcOffset,dest,destOffset){(0,_util.unreachable)("Should not call ColorSpace.getRgbItem");}},{key:"getRgbBuffer",value:function getRgbBuffer(src,srcOffset,count,dest,destOffset,bits,alpha01){(0,_util.unreachable)("Should not call ColorSpace.getRgbBuffer");}},{key:"getOutputLength",value:function getOutputLength(inputLength,alpha01){(0,_util.unreachable)("Should not call ColorSpace.getOutputLength");}},{key:"isPassthrough",value:function isPassthrough(bits){return false;}},{key:"isDefaultDecode",value:function isDefaultDecode(decodeMap,bpc){return ColorSpace.isDefaultDecode(decodeMap,this.numComps);}},{key:"fillRgb",value:function fillRgb(dest,originalWidth,originalHeight,width,height,actualHeight,bpc,comps,alpha01){var count=originalWidth*originalHeight;var rgbBuf=null;var numComponentColors=1<<bpc;var needsResizing=originalHeight!==height||originalWidth!==width;if(this.isPassthrough(bpc)){rgbBuf=comps;}else if(this.numComps===1&&count>numComponentColors&&this.name!=="DeviceGray"&&this.name!=="DeviceRGB"){var allColors=bpc<=8?new Uint8Array(numComponentColors):new Uint16Array(numComponentColors);for(var i=0;i<numComponentColors;i++){allColors[i]=i;}var colorMap=new Uint8ClampedArray(numComponentColors*3);this.getRgbBuffer(allColors,0,numComponentColors,colorMap,0,bpc,0);if(!needsResizing){var destPos=0;for(var _i2=0;_i2<count;++_i2){var key=comps[_i2]*3;dest[destPos++]=colorMap[key];dest[destPos++]=colorMap[key+1];dest[destPos++]=colorMap[key+2];destPos+=alpha01;}}else{rgbBuf=new Uint8Array(count*3);var rgbPos=0;for(var _i3=0;_i3<count;++_i3){var _key=comps[_i3]*3;rgbBuf[rgbPos++]=colorMap[_key];rgbBuf[rgbPos++]=colorMap[_key+1];rgbBuf[rgbPos++]=colorMap[_key+2];}}}else if(!needsResizing){this.getRgbBuffer(comps,0,width*actualHeight,dest,0,bpc,alpha01);}else{rgbBuf=new Uint8ClampedArray(count*3);this.getRgbBuffer(comps,0,count,rgbBuf,0,bpc,0);}if(rgbBuf){if(needsResizing){resizeRgbImage(rgbBuf,dest,originalWidth,originalHeight,width,height,alpha01);}else{var _destPos=0,_rgbPos=0;for(var _i4=0,ii=width*actualHeight;_i4<ii;_i4++){dest[_destPos++]=rgbBuf[_rgbPos++];dest[_destPos++]=rgbBuf[_rgbPos++];dest[_destPos++]=rgbBuf[_rgbPos++];_destPos+=alpha01;}}}}},{key:"usesZeroToOneRange",get:function get(){return(0,_util.shadow)(this,"usesZeroToOneRange",true);}}],[{key:"_cache",value:function _cache(cacheKey,xref,localColorSpaceCache,parsedColorSpace){if(!localColorSpaceCache){throw new Error('ColorSpace._cache - expected "localColorSpaceCache" argument.');}if(!parsedColorSpace){throw new Error('ColorSpace._cache - expected "parsedColorSpace" argument.');}var csName,csRef;if(cacheKey instanceof _primitives.Ref){csRef=cacheKey;cacheKey=xref.fetch(cacheKey);}if(cacheKey instanceof _primitives.Name){csName=cacheKey.name;}if(csName||csRef){localColorSpaceCache.set(csName,csRef,parsedColorSpace);}}},{key:"getCached",value:function getCached(cacheKey,xref,localColorSpaceCache){if(!localColorSpaceCache){throw new Error('ColorSpace.getCached - expected "localColorSpaceCache" argument.');}if(cacheKey instanceof _primitives.Ref){var localColorSpace=localColorSpaceCache.getByRef(cacheKey);if(localColorSpace){return localColorSpace;}try{cacheKey=xref.fetch(cacheKey);}catch(ex){if(ex instanceof _core_utils.MissingDataException){throw ex;}}}if(cacheKey instanceof _primitives.Name){var _localColorSpace=localColorSpaceCache.getByName(cacheKey.name);if(_localColorSpace){return _localColorSpace;}}return null;}},{key:"parseAsync",value:function(){var _parseAsync=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee(_ref){var cs,xref,_ref$resources,resources,pdfFunctionFactory,localColorSpaceCache,parsedColorSpace;return _regeneratorRuntime().wrap(function _callee$(_context){while(1)switch(_context.prev=_context.next){case 0:cs=_ref.cs,xref=_ref.xref,_ref$resources=_ref.resources,resources=_ref$resources===void 0?null:_ref$resources,pdfFunctionFactory=_ref.pdfFunctionFactory,localColorSpaceCache=_ref.localColorSpaceCache;parsedColorSpace=this._parse(cs,xref,resources,pdfFunctionFactory);this._cache(cs,xref,localColorSpaceCache,parsedColorSpace);return _context.abrupt("return",parsedColorSpace);case 4:case"end":return _context.stop();}},_callee,this);}));function parseAsync(_x){return _parseAsync.apply(this,arguments);}return parseAsync;}()},{key:"parse",value:function parse(_ref2){var cs=_ref2.cs,xref=_ref2.xref,_ref2$resources=_ref2.resources,resources=_ref2$resources===void 0?null:_ref2$resources,pdfFunctionFactory=_ref2.pdfFunctionFactory,localColorSpaceCache=_ref2.localColorSpaceCache;var cachedColorSpace=this.getCached(cs,xref,localColorSpaceCache);if(cachedColorSpace){return cachedColorSpace;}var parsedColorSpace=this._parse(cs,xref,resources,pdfFunctionFactory);this._cache(cs,xref,localColorSpaceCache,parsedColorSpace);return parsedColorSpace;}},{key:"_parse",value:function _parse(cs,xref){var resources=arguments.length>2&&arguments[2]!==undefined?arguments[2]:null;var pdfFunctionFactory=arguments.length>3?arguments[3]:undefined;cs=xref.fetchIfRef(cs);if(cs instanceof _primitives.Name){switch(cs.name){case"G":case"DeviceGray":return this.singletons.gray;case"RGB":case"DeviceRGB":return this.singletons.rgb;case"CMYK":case"DeviceCMYK":return this.singletons.cmyk;case"Pattern":return new PatternCS(null);default:if(resources instanceof _primitives.Dict){var colorSpaces=resources.get("ColorSpace");if(colorSpaces instanceof _primitives.Dict){var resourcesCS=colorSpaces.get(cs.name);if(resourcesCS){if(resourcesCS instanceof _primitives.Name){return this._parse(resourcesCS,xref,resources,pdfFunctionFactory);}cs=resourcesCS;break;}}}throw new _util.FormatError("Unrecognized ColorSpace: ".concat(cs.name));}}if(Array.isArray(cs)){var mode=xref.fetchIfRef(cs[0]).name;var params,numComps,baseCS,whitePoint,blackPoint,gamma;switch(mode){case"G":case"DeviceGray":return this.singletons.gray;case"RGB":case"DeviceRGB":return this.singletons.rgb;case"CMYK":case"DeviceCMYK":return this.singletons.cmyk;case"CalGray":params=xref.fetchIfRef(cs[1]);whitePoint=params.getArray("WhitePoint");blackPoint=params.getArray("BlackPoint");gamma=params.get("Gamma");return new CalGrayCS(whitePoint,blackPoint,gamma);case"CalRGB":params=xref.fetchIfRef(cs[1]);whitePoint=params.getArray("WhitePoint");blackPoint=params.getArray("BlackPoint");gamma=params.getArray("Gamma");var matrix=params.getArray("Matrix");return new CalRGBCS(whitePoint,blackPoint,gamma,matrix);case"ICCBased":var stream=xref.fetchIfRef(cs[1]);var dict=stream.dict;numComps=dict.get("N");var alt=dict.get("Alternate");if(alt){var altCS=this._parse(alt,xref,resources,pdfFunctionFactory);if(altCS.numComps===numComps){return altCS;}(0,_util.warn)("ICCBased color space: Ignoring incorrect /Alternate entry.");}if(numComps===1){return this.singletons.gray;}else if(numComps===3){return this.singletons.rgb;}else if(numComps===4){return this.singletons.cmyk;}break;case"Pattern":baseCS=cs[1]||null;if(baseCS){baseCS=this._parse(baseCS,xref,resources,pdfFunctionFactory);}return new PatternCS(baseCS);case"I":case"Indexed":baseCS=this._parse(cs[1],xref,resources,pdfFunctionFactory);var hiVal=xref.fetchIfRef(cs[2])+1;var lookup=xref.fetchIfRef(cs[3]);return new IndexedCS(baseCS,hiVal,lookup);case"Separation":case"DeviceN":var name=xref.fetchIfRef(cs[1]);numComps=Array.isArray(name)?name.length:1;baseCS=this._parse(cs[2],xref,resources,pdfFunctionFactory);var tintFn=pdfFunctionFactory.create(cs[3]);return new AlternateCS(numComps,baseCS,tintFn);case"Lab":params=xref.fetchIfRef(cs[1]);whitePoint=params.getArray("WhitePoint");blackPoint=params.getArray("BlackPoint");var range=params.getArray("Range");return new LabCS(whitePoint,blackPoint,range);default:throw new _util.FormatError("Unimplemented ColorSpace object: ".concat(mode));}}throw new _util.FormatError("Unrecognized ColorSpace object: ".concat(cs));}},{key:"isDefaultDecode",value:function isDefaultDecode(decode,numComps){if(!Array.isArray(decode)){return true;}if(numComps*2!==decode.length){(0,_util.warn)("The decode map is not the correct length");return true;}for(var i=0,ii=decode.length;i<ii;i+=2){if(decode[i]!==0||decode[i+1]!==1){return false;}}return true;}},{key:"singletons",get:function get(){return(0,_util.shadow)(this,"singletons",{get gray(){return(0,_util.shadow)(this,"gray",new DeviceGrayCS());},get rgb(){return(0,_util.shadow)(this,"rgb",new DeviceRgbCS());},get cmyk(){return(0,_util.shadow)(this,"cmyk",new DeviceCmykCS());}});}}]);return ColorSpace;}();exports.ColorSpace=ColorSpace;var AlternateCS=/*#__PURE__*/function(_ColorSpace){_inherits(AlternateCS,_ColorSpace);var _super=_createSuper(AlternateCS);function AlternateCS(numComps,base,tintFn){var _this;_classCallCheck(this,AlternateCS);_this=_super.call(this,"Alternate",numComps);_this.base=base;_this.tintFn=tintFn;_this.tmpBuf=new Float32Array(base.numComps);return _this;}_createClass(AlternateCS,[{key:"getRgbItem",value:function getRgbItem(src,srcOffset,dest,destOffset){var tmpBuf=this.tmpBuf;this.tintFn(src,srcOffset,tmpBuf,0);this.base.getRgbItem(tmpBuf,0,dest,destOffset);}},{key:"getRgbBuffer",value:function getRgbBuffer(src,srcOffset,count,dest,destOffset,bits,alpha01){var tintFn=this.tintFn;var base=this.base;var scale=1/((1<<bits)-1);var baseNumComps=base.numComps;var usesZeroToOneRange=base.usesZeroToOneRange;var isPassthrough=(base.isPassthrough(8)||!usesZeroToOneRange)&&alpha01===0;var pos=isPassthrough?destOffset:0;var baseBuf=isPassthrough?dest:new Uint8ClampedArray(baseNumComps*count);var numComps=this.numComps;var scaled=new Float32Array(numComps);var tinted=new Float32Array(baseNumComps);var i,j;for(i=0;i<count;i++){for(j=0;j<numComps;j++){scaled[j]=src[srcOffset++]*scale;}tintFn(scaled,0,tinted,0);if(usesZeroToOneRange){for(j=0;j<baseNumComps;j++){baseBuf[pos++]=tinted[j]*255;}}else{base.getRgbItem(tinted,0,baseBuf,pos);pos+=baseNumComps;}}if(!isPassthrough){base.getRgbBuffer(baseBuf,0,count,dest,destOffset,8,alpha01);}}},{key:"getOutputLength",value:function getOutputLength(inputLength,alpha01){return this.base.getOutputLength(inputLength*this.base.numComps/this.numComps,alpha01);}}]);return AlternateCS;}(ColorSpace);var PatternCS=/*#__PURE__*/function(_ColorSpace2){_inherits(PatternCS,_ColorSpace2);var _super2=_createSuper(PatternCS);function PatternCS(baseCS){var _this2;_classCallCheck(this,PatternCS);_this2=_super2.call(this,"Pattern",null);_this2.base=baseCS;return _this2;}_createClass(PatternCS,[{key:"isDefaultDecode",value:function isDefaultDecode(decodeMap,bpc){(0,_util.unreachable)("Should not call PatternCS.isDefaultDecode");}}]);return PatternCS;}(ColorSpace);var IndexedCS=/*#__PURE__*/function(_ColorSpace3){_inherits(IndexedCS,_ColorSpace3);var _super3=_createSuper(IndexedCS);function IndexedCS(base,highVal,lookup){var _this3;_classCallCheck(this,IndexedCS);_this3=_super3.call(this,"Indexed",1);_this3.base=base;_this3.highVal=highVal;var length=base.numComps*highVal;_this3.lookup=new Uint8Array(length);if(lookup instanceof _base_stream.BaseStream){var bytes=lookup.getBytes(length);_this3.lookup.set(bytes);}else if(typeof lookup==="string"){for(var i=0;i<length;++i){_this3.lookup[i]=lookup.charCodeAt(i)&0xff;}}else{throw new _util.FormatError("IndexedCS - unrecognized lookup table: ".concat(lookup));}return _this3;}_createClass(IndexedCS,[{key:"getRgbItem",value:function getRgbItem(src,srcOffset,dest,destOffset){var numComps=this.base.numComps;var start=src[srcOffset]*numComps;this.base.getRgbBuffer(this.lookup,start,1,dest,destOffset,8,0);}},{key:"getRgbBuffer",value:function getRgbBuffer(src,srcOffset,count,dest,destOffset,bits,alpha01){var base=this.base;var numComps=base.numComps;var outputDelta=base.getOutputLength(numComps,alpha01);var lookup=this.lookup;for(var i=0;i<count;++i){var lookupPos=src[srcOffset++]*numComps;base.getRgbBuffer(lookup,lookupPos,1,dest,destOffset,8,alpha01);destOffset+=outputDelta;}}},{key:"getOutputLength",value:function getOutputLength(inputLength,alpha01){return this.base.getOutputLength(inputLength*this.base.numComps,alpha01);}},{key:"isDefaultDecode",value:function isDefaultDecode(decodeMap,bpc){if(!Array.isArray(decodeMap)){return true;}if(decodeMap.length!==2){(0,_util.warn)("Decode map length is not correct");return true;}if(!Number.isInteger(bpc)||bpc<1){(0,_util.warn)("Bits per component is not correct");return true;}return decodeMap[0]===0&&decodeMap[1]===(1<<bpc)-1;}}]);return IndexedCS;}(ColorSpace);var DeviceGrayCS=/*#__PURE__*/function(_ColorSpace4){_inherits(DeviceGrayCS,_ColorSpace4);var _super4=_createSuper(DeviceGrayCS);function DeviceGrayCS(){_classCallCheck(this,DeviceGrayCS);return _super4.call(this,"DeviceGray",1);}_createClass(DeviceGrayCS,[{key:"getRgbItem",value:function getRgbItem(src,srcOffset,dest,destOffset){var c=src[srcOffset]*255;dest[destOffset]=dest[destOffset+1]=dest[destOffset+2]=c;}},{key:"getRgbBuffer",value:function getRgbBuffer(src,srcOffset,count,dest,destOffset,bits,alpha01){var scale=255/((1<<bits)-1);var j=srcOffset,q=destOffset;for(var i=0;i<count;++i){var c=scale*src[j++];dest[q++]=c;dest[q++]=c;dest[q++]=c;q+=alpha01;}}},{key:"getOutputLength",value:function getOutputLength(inputLength,alpha01){return inputLength*(3+alpha01);}}]);return DeviceGrayCS;}(ColorSpace);var DeviceRgbCS=/*#__PURE__*/function(_ColorSpace5){_inherits(DeviceRgbCS,_ColorSpace5);var _super5=_createSuper(DeviceRgbCS);function DeviceRgbCS(){_classCallCheck(this,DeviceRgbCS);return _super5.call(this,"DeviceRGB",3);}_createClass(DeviceRgbCS,[{key:"getRgbItem",value:function getRgbItem(src,srcOffset,dest,destOffset){dest[destOffset]=src[srcOffset]*255;dest[destOffset+1]=src[srcOffset+1]*255;dest[destOffset+2]=src[srcOffset+2]*255;}},{key:"getRgbBuffer",value:function getRgbBuffer(src,srcOffset,count,dest,destOffset,bits,alpha01){if(bits===8&&alpha01===0){dest.set(src.subarray(srcOffset,srcOffset+count*3),destOffset);return;}var scale=255/((1<<bits)-1);var j=srcOffset,q=destOffset;for(var i=0;i<count;++i){dest[q++]=scale*src[j++];dest[q++]=scale*src[j++];dest[q++]=scale*src[j++];q+=alpha01;}}},{key:"getOutputLength",value:function getOutputLength(inputLength,alpha01){return inputLength*(3+alpha01)/3|0;}},{key:"isPassthrough",value:function isPassthrough(bits){return bits===8;}}]);return DeviceRgbCS;}(ColorSpace);var DeviceCmykCS=function DeviceCmykCSClosure(){function convertToRgb(src,srcOffset,srcScale,dest,destOffset){var c=src[srcOffset]*srcScale;var m=src[srcOffset+1]*srcScale;var y=src[srcOffset+2]*srcScale;var k=src[srcOffset+3]*srcScale;dest[destOffset]=255+c*(-4.387332384609988*c+54.48615194189176*m+18.82290502165302*y+212.25662451639585*k+-285.2331026137004)+m*(1.7149763477362134*m-5.6096736904047315*y+-17.873870861415444*k-5.497006427196366)+y*(-2.5217340131683033*y-21.248923337353073*k+17.5119270841813)+k*(-21.86122147463605*k-189.48180835922747);dest[destOffset+1]=255+c*(8.841041422036149*c+60.118027045597366*m+6.871425592049007*y+31.159100130055922*k+-79.2970844816548)+m*(-15.310361306967817*m+17.575251261109482*y+131.35250912493976*k-190.9453302588951)+y*(4.444339102852739*y+9.8632861493405*k-24.86741582555878)+k*(-20.737325471181034*k-187.80453709719578);dest[destOffset+2]=255+c*(0.8842522430003296*c+8.078677503112928*m+30.89978309703729*y-0.23883238689178934*k+-14.183576799673286)+m*(10.49593273432072*m+63.02378494754052*y+50.606957656360734*k-112.23884253719248)+y*(0.03296041114873217*y+115.60384449646641*k+-193.58209356861505)+k*(-22.33816807309886*k-180.12613974708367);}var DeviceCmykCS=/*#__PURE__*/function(_ColorSpace6){_inherits(DeviceCmykCS,_ColorSpace6);var _super6=_createSuper(DeviceCmykCS);function DeviceCmykCS(){_classCallCheck(this,DeviceCmykCS);return _super6.call(this,"DeviceCMYK",4);}_createClass(DeviceCmykCS,[{key:"getRgbItem",value:function getRgbItem(src,srcOffset,dest,destOffset){convertToRgb(src,srcOffset,1,dest,destOffset);}},{key:"getRgbBuffer",value:function getRgbBuffer(src,srcOffset,count,dest,destOffset,bits,alpha01){var scale=1/((1<<bits)-1);for(var i=0;i<count;i++){convertToRgb(src,srcOffset,scale,dest,destOffset);srcOffset+=4;destOffset+=3+alpha01;}}},{key:"getOutputLength",value:function getOutputLength(inputLength,alpha01){return inputLength/4*(3+alpha01)|0;}}]);return DeviceCmykCS;}(ColorSpace);return DeviceCmykCS;}();var CalGrayCS=function CalGrayCSClosure(){function convertToRgb(cs,src,srcOffset,dest,destOffset,scale){var A=src[srcOffset]*scale;var AG=Math.pow(A,cs.G);var L=cs.YW*AG;var val=Math.max(295.8*Math.pow(L,0.3333333333333333)-40.8,0);dest[destOffset]=val;dest[destOffset+1]=val;dest[destOffset+2]=val;}var CalGrayCS=/*#__PURE__*/function(_ColorSpace7){_inherits(CalGrayCS,_ColorSpace7);var _super7=_createSuper(CalGrayCS);function CalGrayCS(whitePoint,blackPoint,gamma){var _this4;_classCallCheck(this,CalGrayCS);_this4=_super7.call(this,"CalGray",1);if(!whitePoint){throw new _util.FormatError("WhitePoint missing - required for color space CalGray");}blackPoint||(blackPoint=[0,0,0]);gamma||(gamma=1);_this4.XW=whitePoint[0];_this4.YW=whitePoint[1];_this4.ZW=whitePoint[2];_this4.XB=blackPoint[0];_this4.YB=blackPoint[1];_this4.ZB=blackPoint[2];_this4.G=gamma;if(_this4.XW<0||_this4.ZW<0||_this4.YW!==1){throw new _util.FormatError("Invalid WhitePoint components for ".concat(_this4.name)+", no fallback available");}if(_this4.XB<0||_this4.YB<0||_this4.ZB<0){(0,_util.info)("Invalid BlackPoint for ".concat(_this4.name,", falling back to default."));_this4.XB=_this4.YB=_this4.ZB=0;}if(_this4.XB!==0||_this4.YB!==0||_this4.ZB!==0){(0,_util.warn)("".concat(_this4.name,", BlackPoint: XB: ").concat(_this4.XB,", YB: ").concat(_this4.YB,", ")+"ZB: ".concat(_this4.ZB,", only default values are supported."));}if(_this4.G<1){(0,_util.info)("Invalid Gamma: ".concat(_this4.G," for ").concat(_this4.name,", ")+"falling back to default.");_this4.G=1;}return _this4;}_createClass(CalGrayCS,[{key:"getRgbItem",value:function getRgbItem(src,srcOffset,dest,destOffset){convertToRgb(this,src,srcOffset,dest,destOffset,1);}},{key:"getRgbBuffer",value:function getRgbBuffer(src,srcOffset,count,dest,destOffset,bits,alpha01){var scale=1/((1<<bits)-1);for(var i=0;i<count;++i){convertToRgb(this,src,srcOffset,dest,destOffset,scale);srcOffset+=1;destOffset+=3+alpha01;}}},{key:"getOutputLength",value:function getOutputLength(inputLength,alpha01){return inputLength*(3+alpha01);}}]);return CalGrayCS;}(ColorSpace);return CalGrayCS;}();var CalRGBCS=function CalRGBCSClosure(){var BRADFORD_SCALE_MATRIX=new Float32Array([0.8951,0.2664,-0.1614,-0.7502,1.7135,0.0367,0.0389,-0.0685,1.0296]);var BRADFORD_SCALE_INVERSE_MATRIX=new Float32Array([0.9869929,-0.1470543,0.1599627,0.4323053,0.5183603,0.0492912,-0.0085287,0.0400428,0.9684867]);var SRGB_D65_XYZ_TO_RGB_MATRIX=new Float32Array([3.2404542,-1.5371385,-0.4985314,-0.9692660,1.8760108,0.0415560,0.0556434,-0.2040259,1.0572252]);var FLAT_WHITEPOINT_MATRIX=new Float32Array([1,1,1]);var tempNormalizeMatrix=new Float32Array(3);var tempConvertMatrix1=new Float32Array(3);var tempConvertMatrix2=new Float32Array(3);var DECODE_L_CONSTANT=Math.pow((8+16)/116,3)/8.0;function matrixProduct(a,b,result){result[0]=a[0]*b[0]+a[1]*b[1]+a[2]*b[2];result[1]=a[3]*b[0]+a[4]*b[1]+a[5]*b[2];result[2]=a[6]*b[0]+a[7]*b[1]+a[8]*b[2];}function convertToFlat(sourceWhitePoint,LMS,result){result[0]=LMS[0]*1/sourceWhitePoint[0];result[1]=LMS[1]*1/sourceWhitePoint[1];result[2]=LMS[2]*1/sourceWhitePoint[2];}function convertToD65(sourceWhitePoint,LMS,result){var D65X=0.95047;var D65Y=1;var D65Z=1.08883;result[0]=LMS[0]*D65X/sourceWhitePoint[0];result[1]=LMS[1]*D65Y/sourceWhitePoint[1];result[2]=LMS[2]*D65Z/sourceWhitePoint[2];}function sRGBTransferFunction(color){if(color<=0.0031308){return adjustToRange(0,1,12.92*color);}if(color>=0.99554525){return 1;}return adjustToRange(0,1,(1+0.055)*Math.pow(color,1/2.4)-0.055);}function adjustToRange(min,max,value){return Math.max(min,Math.min(max,value));}function decodeL(L){if(L<0){return-decodeL(-L);}if(L>8.0){return Math.pow((L+16)/116,3);}return L*DECODE_L_CONSTANT;}function compensateBlackPoint(sourceBlackPoint,XYZ_Flat,result){if(sourceBlackPoint[0]===0&&sourceBlackPoint[1]===0&&sourceBlackPoint[2]===0){result[0]=XYZ_Flat[0];result[1]=XYZ_Flat[1];result[2]=XYZ_Flat[2];return;}var zeroDecodeL=decodeL(0);var X_DST=zeroDecodeL;var X_SRC=decodeL(sourceBlackPoint[0]);var Y_DST=zeroDecodeL;var Y_SRC=decodeL(sourceBlackPoint[1]);var Z_DST=zeroDecodeL;var Z_SRC=decodeL(sourceBlackPoint[2]);var X_Scale=(1-X_DST)/(1-X_SRC);var X_Offset=1-X_Scale;var Y_Scale=(1-Y_DST)/(1-Y_SRC);var Y_Offset=1-Y_Scale;var Z_Scale=(1-Z_DST)/(1-Z_SRC);var Z_Offset=1-Z_Scale;result[0]=XYZ_Flat[0]*X_Scale+X_Offset;result[1]=XYZ_Flat[1]*Y_Scale+Y_Offset;result[2]=XYZ_Flat[2]*Z_Scale+Z_Offset;}function normalizeWhitePointToFlat(sourceWhitePoint,XYZ_In,result){if(sourceWhitePoint[0]===1&&sourceWhitePoint[2]===1){result[0]=XYZ_In[0];result[1]=XYZ_In[1];result[2]=XYZ_In[2];return;}var LMS=result;matrixProduct(BRADFORD_SCALE_MATRIX,XYZ_In,LMS);var LMS_Flat=tempNormalizeMatrix;convertToFlat(sourceWhitePoint,LMS,LMS_Flat);matrixProduct(BRADFORD_SCALE_INVERSE_MATRIX,LMS_Flat,result);}function normalizeWhitePointToD65(sourceWhitePoint,XYZ_In,result){var LMS=result;matrixProduct(BRADFORD_SCALE_MATRIX,XYZ_In,LMS);var LMS_D65=tempNormalizeMatrix;convertToD65(sourceWhitePoint,LMS,LMS_D65);matrixProduct(BRADFORD_SCALE_INVERSE_MATRIX,LMS_D65,result);}function convertToRgb(cs,src,srcOffset,dest,destOffset,scale){var A=adjustToRange(0,1,src[srcOffset]*scale);var B=adjustToRange(0,1,src[srcOffset+1]*scale);var C=adjustToRange(0,1,src[srcOffset+2]*scale);var AGR=A===1?1:Math.pow(A,cs.GR);var BGG=B===1?1:Math.pow(B,cs.GG);var CGB=C===1?1:Math.pow(C,cs.GB);var X=cs.MXA*AGR+cs.MXB*BGG+cs.MXC*CGB;var Y=cs.MYA*AGR+cs.MYB*BGG+cs.MYC*CGB;var Z=cs.MZA*AGR+cs.MZB*BGG+cs.MZC*CGB;var XYZ=tempConvertMatrix1;XYZ[0]=X;XYZ[1]=Y;XYZ[2]=Z;var XYZ_Flat=tempConvertMatrix2;normalizeWhitePointToFlat(cs.whitePoint,XYZ,XYZ_Flat);var XYZ_Black=tempConvertMatrix1;compensateBlackPoint(cs.blackPoint,XYZ_Flat,XYZ_Black);var XYZ_D65=tempConvertMatrix2;normalizeWhitePointToD65(FLAT_WHITEPOINT_MATRIX,XYZ_Black,XYZ_D65);var SRGB=tempConvertMatrix1;matrixProduct(SRGB_D65_XYZ_TO_RGB_MATRIX,XYZ_D65,SRGB);dest[destOffset]=sRGBTransferFunction(SRGB[0])*255;dest[destOffset+1]=sRGBTransferFunction(SRGB[1])*255;dest[destOffset+2]=sRGBTransferFunction(SRGB[2])*255;}var CalRGBCS=/*#__PURE__*/function(_ColorSpace8){_inherits(CalRGBCS,_ColorSpace8);var _super8=_createSuper(CalRGBCS);function CalRGBCS(whitePoint,blackPoint,gamma,matrix){var _this5;_classCallCheck(this,CalRGBCS);_this5=_super8.call(this,"CalRGB",3);if(!whitePoint){throw new _util.FormatError("WhitePoint missing - required for color space CalRGB");}blackPoint||(blackPoint=new Float32Array(3));gamma||(gamma=new Float32Array([1,1,1]));matrix||(matrix=new Float32Array([1,0,0,0,1,0,0,0,1]));var XW=whitePoint[0];var YW=whitePoint[1];var ZW=whitePoint[2];_this5.whitePoint=whitePoint;var XB=blackPoint[0];var YB=blackPoint[1];var ZB=blackPoint[2];_this5.blackPoint=blackPoint;_this5.GR=gamma[0];_this5.GG=gamma[1];_this5.GB=gamma[2];_this5.MXA=matrix[0];_this5.MYA=matrix[1];_this5.MZA=matrix[2];_this5.MXB=matrix[3];_this5.MYB=matrix[4];_this5.MZB=matrix[5];_this5.MXC=matrix[6];_this5.MYC=matrix[7];_this5.MZC=matrix[8];if(XW<0||ZW<0||YW!==1){throw new _util.FormatError("Invalid WhitePoint components for ".concat(_this5.name)+", no fallback available");}if(XB<0||YB<0||ZB<0){(0,_util.info)("Invalid BlackPoint for ".concat(_this5.name," [").concat(XB,", ").concat(YB,", ").concat(ZB,"], ")+"falling back to default.");_this5.blackPoint=new Float32Array(3);}if(_this5.GR<0||_this5.GG<0||_this5.GB<0){(0,_util.info)("Invalid Gamma [".concat(_this5.GR,", ").concat(_this5.GG,", ").concat(_this5.GB,"] for ")+"".concat(_this5.name,", falling back to default."));_this5.GR=_this5.GG=_this5.GB=1;}return _this5;}_createClass(CalRGBCS,[{key:"getRgbItem",value:function getRgbItem(src,srcOffset,dest,destOffset){convertToRgb(this,src,srcOffset,dest,destOffset,1);}},{key:"getRgbBuffer",value:function getRgbBuffer(src,srcOffset,count,dest,destOffset,bits,alpha01){var scale=1/((1<<bits)-1);for(var i=0;i<count;++i){convertToRgb(this,src,srcOffset,dest,destOffset,scale);srcOffset+=3;destOffset+=3+alpha01;}}},{key:"getOutputLength",value:function getOutputLength(inputLength,alpha01){return inputLength*(3+alpha01)/3|0;}}]);return CalRGBCS;}(ColorSpace);return CalRGBCS;}();var LabCS=function LabCSClosure(){function fn_g(x){return x>=6/29?Math.pow(x,3):108/841*(x-4/29);}function decode(value,high1,low2,high2){return low2+value*(high2-low2)/high1;}function convertToRgb(cs,src,srcOffset,maxVal,dest,destOffset){var Ls=src[srcOffset];var as=src[srcOffset+1];var bs=src[srcOffset+2];if(maxVal!==false){Ls=decode(Ls,maxVal,0,100);as=decode(as,maxVal,cs.amin,cs.amax);bs=decode(bs,maxVal,cs.bmin,cs.bmax);}if(as>cs.amax){as=cs.amax;}else if(as<cs.amin){as=cs.amin;}if(bs>cs.bmax){bs=cs.bmax;}else if(bs<cs.bmin){bs=cs.bmin;}var M=(Ls+16)/116;var L=M+as/500;var N=M-bs/200;var X=cs.XW*fn_g(L);var Y=cs.YW*fn_g(M);var Z=cs.ZW*fn_g(N);var r,g,b;if(cs.ZW<1){r=X*3.1339+Y*-1.617+Z*-0.4906;g=X*-0.9785+Y*1.916+Z*0.0333;b=X*0.072+Y*-0.229+Z*1.4057;}else{r=X*3.2406+Y*-1.5372+Z*-0.4986;g=X*-0.9689+Y*1.8758+Z*0.0415;b=X*0.0557+Y*-0.204+Z*1.057;}dest[destOffset]=Math.sqrt(r)*255;dest[destOffset+1]=Math.sqrt(g)*255;dest[destOffset+2]=Math.sqrt(b)*255;}var LabCS=/*#__PURE__*/function(_ColorSpace9){_inherits(LabCS,_ColorSpace9);var _super9=_createSuper(LabCS);function LabCS(whitePoint,blackPoint,range){var _this6;_classCallCheck(this,LabCS);_this6=_super9.call(this,"Lab",3);if(!whitePoint){throw new _util.FormatError("WhitePoint missing - required for color space Lab");}blackPoint||(blackPoint=[0,0,0]);range||(range=[-100,100,-100,100]);_this6.XW=whitePoint[0];_this6.YW=whitePoint[1];_this6.ZW=whitePoint[2];_this6.amin=range[0];_this6.amax=range[1];_this6.bmin=range[2];_this6.bmax=range[3];_this6.XB=blackPoint[0];_this6.YB=blackPoint[1];_this6.ZB=blackPoint[2];if(_this6.XW<0||_this6.ZW<0||_this6.YW!==1){throw new _util.FormatError("Invalid WhitePoint components, no fallback available");}if(_this6.XB<0||_this6.YB<0||_this6.ZB<0){(0,_util.info)("Invalid BlackPoint, falling back to default");_this6.XB=_this6.YB=_this6.ZB=0;}if(_this6.amin>_this6.amax||_this6.bmin>_this6.bmax){(0,_util.info)("Invalid Range, falling back to defaults");_this6.amin=-100;_this6.amax=100;_this6.bmin=-100;_this6.bmax=100;}return _this6;}_createClass(LabCS,[{key:"getRgbItem",value:function getRgbItem(src,srcOffset,dest,destOffset){convertToRgb(this,src,srcOffset,false,dest,destOffset);}},{key:"getRgbBuffer",value:function getRgbBuffer(src,srcOffset,count,dest,destOffset,bits,alpha01){var maxVal=(1<<bits)-1;for(var i=0;i<count;i++){convertToRgb(this,src,srcOffset,maxVal,dest,destOffset);srcOffset+=3;destOffset+=3+alpha01;}}},{key:"getOutputLength",value:function getOutputLength(inputLength,alpha01){return inputLength*(3+alpha01)/3|0;}},{key:"isDefaultDecode",value:function isDefaultDecode(decodeMap,bpc){return true;}},{key:"usesZeroToOneRange",get:function get(){return(0,_util.shadow)(this,"usesZeroToOneRange",false);}}]);return LabCS;}(ColorSpace);return LabCS;}();

/***/ }),
/* 380 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var createTypedArrayConstructor = __w_pdfjs_require__(192);
createTypedArrayConstructor('Uint16', function (init) {
 return function Uint16Array(data, byteOffset, length) {
  return init(this, data, byteOffset, length);
 };
});

/***/ }),
/* 381 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var createTypedArrayConstructor = __w_pdfjs_require__(192);
createTypedArrayConstructor('Float32', function (init) {
 return function Float32Array(data, byteOffset, length) {
  return init(this, data, byteOffset, length);
 };
});

/***/ }),
/* 382 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

function _typeof(obj){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj;}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;},_typeof(obj);}__w_pdfjs_require__(114);__w_pdfjs_require__(56);__w_pdfjs_require__(104);__w_pdfjs_require__(113);__w_pdfjs_require__(2);__w_pdfjs_require__(54);__w_pdfjs_require__(130);__w_pdfjs_require__(131);__w_pdfjs_require__(132);__w_pdfjs_require__(133);__w_pdfjs_require__(134);Object.defineProperty(exports, "__esModule", ({value:true}));exports.PartialEvaluator=exports.EvaluatorPreprocessor=void 0;__w_pdfjs_require__(383);__w_pdfjs_require__(143);__w_pdfjs_require__(145);__w_pdfjs_require__(361);__w_pdfjs_require__(289);__w_pdfjs_require__(301);__w_pdfjs_require__(183);__w_pdfjs_require__(137);__w_pdfjs_require__(191);__w_pdfjs_require__(208);__w_pdfjs_require__(209);__w_pdfjs_require__(212);__w_pdfjs_require__(213);__w_pdfjs_require__(214);__w_pdfjs_require__(218);__w_pdfjs_require__(219);__w_pdfjs_require__(220);__w_pdfjs_require__(222);__w_pdfjs_require__(223);__w_pdfjs_require__(224);__w_pdfjs_require__(225);__w_pdfjs_require__(226);__w_pdfjs_require__(227);__w_pdfjs_require__(228);__w_pdfjs_require__(231);__w_pdfjs_require__(232);__w_pdfjs_require__(234);__w_pdfjs_require__(235);__w_pdfjs_require__(236);__w_pdfjs_require__(237);__w_pdfjs_require__(238);__w_pdfjs_require__(239);__w_pdfjs_require__(244);__w_pdfjs_require__(245);__w_pdfjs_require__(247);__w_pdfjs_require__(248);__w_pdfjs_require__(249);__w_pdfjs_require__(251);__w_pdfjs_require__(254);__w_pdfjs_require__(257);__w_pdfjs_require__(381);__w_pdfjs_require__(175);__w_pdfjs_require__(177);__w_pdfjs_require__(308);__w_pdfjs_require__(292);__w_pdfjs_require__(334);__w_pdfjs_require__(258);__w_pdfjs_require__(266);__w_pdfjs_require__(277);__w_pdfjs_require__(279);__w_pdfjs_require__(281);__w_pdfjs_require__(283);__w_pdfjs_require__(285);__w_pdfjs_require__(287);__w_pdfjs_require__(378);__w_pdfjs_require__(384);__w_pdfjs_require__(295);__w_pdfjs_require__(105);__w_pdfjs_require__(371);__w_pdfjs_require__(123);__w_pdfjs_require__(129);__w_pdfjs_require__(336);__w_pdfjs_require__(338);__w_pdfjs_require__(386);__w_pdfjs_require__(299);__w_pdfjs_require__(360);__w_pdfjs_require__(372);__w_pdfjs_require__(387);var _util=__w_pdfjs_require__(303);var _cmap=__w_pdfjs_require__(388);var _primitives=__w_pdfjs_require__(349);var _fonts=__w_pdfjs_require__(412);var _encodings=__w_pdfjs_require__(416);var _standard_fonts=__w_pdfjs_require__(420);var _pattern=__w_pdfjs_require__(429);var _xfa_fonts=__w_pdfjs_require__(430);var _to_unicode_map=__w_pdfjs_require__(421);var _function=__w_pdfjs_require__(436);var _parser=__w_pdfjs_require__(391);var _image_utils=__w_pdfjs_require__(441);var _stream=__w_pdfjs_require__(357);var _base_stream=__w_pdfjs_require__(353);var _bidi=__w_pdfjs_require__(442);var _colorspace=__w_pdfjs_require__(379);var _decode_stream=__w_pdfjs_require__(393);var _fonts_utils=__w_pdfjs_require__(417);var _font_substitutions=__w_pdfjs_require__(443);var _glyphlist=__w_pdfjs_require__(418);var _core_utils=__w_pdfjs_require__(342);var _metrics=__w_pdfjs_require__(424);var _unicode=__w_pdfjs_require__(419);var _image_resizer=__w_pdfjs_require__(444);var _murmurhash=__w_pdfjs_require__(445);var _operator_list=__w_pdfjs_require__(446);var _image=__w_pdfjs_require__(447);function _slicedToArray(arr,i){return _arrayWithHoles(arr)||_iterableToArrayLimit(arr,i)||_unsupportedIterableToArray(arr,i)||_nonIterableRest();}function _nonIterableRest(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}function _iterableToArrayLimit(arr,i){var _i=null==arr?null:"undefined"!=typeof Symbol&&arr[Symbol.iterator]||arr["@@iterator"];if(null!=_i){var _s,_e,_x,_r,_arr=[],_n=!0,_d=!1;try{if(_x=(_i=_i.call(arr)).next,0===i){if(Object(_i)!==_i)return;_n=!1;}else for(;!(_n=(_s=_x.call(_i)).done)&&(_arr.push(_s.value),_arr.length!==i);_n=!0);}catch(err){_d=!0,_e=err;}finally{try{if(!_n&&null!=_i.return&&(_r=_i.return(),Object(_r)!==_r))return;}finally{if(_d)throw _e;}}return _arr;}}function _arrayWithHoles(arr){if(Array.isArray(arr))return arr;}function _toConsumableArray(arr){return _arrayWithoutHoles(arr)||_iterableToArray(arr)||_unsupportedIterableToArray(arr)||_nonIterableSpread();}function _nonIterableSpread(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}function _iterableToArray(iter){if(typeof Symbol!=="undefined"&&iter[Symbol.iterator]!=null||iter["@@iterator"]!=null)return Array.from(iter);}function _arrayWithoutHoles(arr){if(Array.isArray(arr))return _arrayLikeToArray(arr);}function _regeneratorRuntime(){"use strict";/*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */_regeneratorRuntime=function _regeneratorRuntime(){return exports;};var exports={},Op=Object.prototype,hasOwn=Op.hasOwnProperty,defineProperty=Object.defineProperty||function(obj,key,desc){obj[key]=desc.value;},$Symbol="function"==typeof Symbol?Symbol:{},iteratorSymbol=$Symbol.iterator||"@@iterator",asyncIteratorSymbol=$Symbol.asyncIterator||"@@asyncIterator",toStringTagSymbol=$Symbol.toStringTag||"@@toStringTag";function define(obj,key,value){return Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}),obj[key];}try{define({},"");}catch(err){define=function define(obj,key,value){return obj[key]=value;};}function wrap(innerFn,outerFn,self,tryLocsList){var protoGenerator=outerFn&&outerFn.prototype instanceof Generator?outerFn:Generator,generator=Object.create(protoGenerator.prototype),context=new Context(tryLocsList||[]);return defineProperty(generator,"_invoke",{value:makeInvokeMethod(innerFn,self,context)}),generator;}function tryCatch(fn,obj,arg){try{return{type:"normal",arg:fn.call(obj,arg)};}catch(err){return{type:"throw",arg:err};}}exports.wrap=wrap;var ContinueSentinel={};function Generator(){}function GeneratorFunction(){}function GeneratorFunctionPrototype(){}var IteratorPrototype={};define(IteratorPrototype,iteratorSymbol,function(){return this;});var getProto=Object.getPrototypeOf,NativeIteratorPrototype=getProto&&getProto(getProto(values([])));NativeIteratorPrototype&&NativeIteratorPrototype!==Op&&hasOwn.call(NativeIteratorPrototype,iteratorSymbol)&&(IteratorPrototype=NativeIteratorPrototype);var Gp=GeneratorFunctionPrototype.prototype=Generator.prototype=Object.create(IteratorPrototype);function defineIteratorMethods(prototype){["next","throw","return"].forEach(function(method){define(prototype,method,function(arg){return this._invoke(method,arg);});});}function AsyncIterator(generator,PromiseImpl){function invoke(method,arg,resolve,reject){var record=tryCatch(generator[method],generator,arg);if("throw"!==record.type){var result=record.arg,value=result.value;return value&&"object"==_typeof(value)&&hasOwn.call(value,"__await")?PromiseImpl.resolve(value.__await).then(function(value){invoke("next",value,resolve,reject);},function(err){invoke("throw",err,resolve,reject);}):PromiseImpl.resolve(value).then(function(unwrapped){result.value=unwrapped,resolve(result);},function(error){return invoke("throw",error,resolve,reject);});}reject(record.arg);}var previousPromise;defineProperty(this,"_invoke",{value:function value(method,arg){function callInvokeWithMethodAndArg(){return new PromiseImpl(function(resolve,reject){invoke(method,arg,resolve,reject);});}return previousPromise=previousPromise?previousPromise.then(callInvokeWithMethodAndArg,callInvokeWithMethodAndArg):callInvokeWithMethodAndArg();}});}function makeInvokeMethod(innerFn,self,context){var state="suspendedStart";return function(method,arg){if("executing"===state)throw new Error("Generator is already running");if("completed"===state){if("throw"===method)throw arg;return doneResult();}for(context.method=method,context.arg=arg;;){var delegate=context.delegate;if(delegate){var delegateResult=maybeInvokeDelegate(delegate,context);if(delegateResult){if(delegateResult===ContinueSentinel)continue;return delegateResult;}}if("next"===context.method)context.sent=context._sent=context.arg;else if("throw"===context.method){if("suspendedStart"===state)throw state="completed",context.arg;context.dispatchException(context.arg);}else"return"===context.method&&context.abrupt("return",context.arg);state="executing";var record=tryCatch(innerFn,self,context);if("normal"===record.type){if(state=context.done?"completed":"suspendedYield",record.arg===ContinueSentinel)continue;return{value:record.arg,done:context.done};}"throw"===record.type&&(state="completed",context.method="throw",context.arg=record.arg);}};}function maybeInvokeDelegate(delegate,context){var methodName=context.method,method=delegate.iterator[methodName];if(undefined===method)return context.delegate=null,"throw"===methodName&&delegate.iterator.return&&(context.method="return",context.arg=undefined,maybeInvokeDelegate(delegate,context),"throw"===context.method)||"return"!==methodName&&(context.method="throw",context.arg=new TypeError("The iterator does not provide a '"+methodName+"' method")),ContinueSentinel;var record=tryCatch(method,delegate.iterator,context.arg);if("throw"===record.type)return context.method="throw",context.arg=record.arg,context.delegate=null,ContinueSentinel;var info=record.arg;return info?info.done?(context[delegate.resultName]=info.value,context.next=delegate.nextLoc,"return"!==context.method&&(context.method="next",context.arg=undefined),context.delegate=null,ContinueSentinel):info:(context.method="throw",context.arg=new TypeError("iterator result is not an object"),context.delegate=null,ContinueSentinel);}function pushTryEntry(locs){var entry={tryLoc:locs[0]};1 in locs&&(entry.catchLoc=locs[1]),2 in locs&&(entry.finallyLoc=locs[2],entry.afterLoc=locs[3]),this.tryEntries.push(entry);}function resetTryEntry(entry){var record=entry.completion||{};record.type="normal",delete record.arg,entry.completion=record;}function Context(tryLocsList){this.tryEntries=[{tryLoc:"root"}],tryLocsList.forEach(pushTryEntry,this),this.reset(!0);}function values(iterable){if(iterable){var iteratorMethod=iterable[iteratorSymbol];if(iteratorMethod)return iteratorMethod.call(iterable);if("function"==typeof iterable.next)return iterable;if(!isNaN(iterable.length)){var i=-1,next=function next(){for(;++i<iterable.length;)if(hasOwn.call(iterable,i))return next.value=iterable[i],next.done=!1,next;return next.value=undefined,next.done=!0,next;};return next.next=next;}}return{next:doneResult};}function doneResult(){return{value:undefined,done:!0};}return GeneratorFunction.prototype=GeneratorFunctionPrototype,defineProperty(Gp,"constructor",{value:GeneratorFunctionPrototype,configurable:!0}),defineProperty(GeneratorFunctionPrototype,"constructor",{value:GeneratorFunction,configurable:!0}),GeneratorFunction.displayName=define(GeneratorFunctionPrototype,toStringTagSymbol,"GeneratorFunction"),exports.isGeneratorFunction=function(genFun){var ctor="function"==typeof genFun&&genFun.constructor;return!!ctor&&(ctor===GeneratorFunction||"GeneratorFunction"===(ctor.displayName||ctor.name));},exports.mark=function(genFun){return Object.setPrototypeOf?Object.setPrototypeOf(genFun,GeneratorFunctionPrototype):(genFun.__proto__=GeneratorFunctionPrototype,define(genFun,toStringTagSymbol,"GeneratorFunction")),genFun.prototype=Object.create(Gp),genFun;},exports.awrap=function(arg){return{__await:arg};},defineIteratorMethods(AsyncIterator.prototype),define(AsyncIterator.prototype,asyncIteratorSymbol,function(){return this;}),exports.AsyncIterator=AsyncIterator,exports.async=function(innerFn,outerFn,self,tryLocsList,PromiseImpl){void 0===PromiseImpl&&(PromiseImpl=Promise);var iter=new AsyncIterator(wrap(innerFn,outerFn,self,tryLocsList),PromiseImpl);return exports.isGeneratorFunction(outerFn)?iter:iter.next().then(function(result){return result.done?result.value:iter.next();});},defineIteratorMethods(Gp),define(Gp,toStringTagSymbol,"Generator"),define(Gp,iteratorSymbol,function(){return this;}),define(Gp,"toString",function(){return"[object Generator]";}),exports.keys=function(val){var object=Object(val),keys=[];for(var key in object)keys.push(key);return keys.reverse(),function next(){for(;keys.length;){var key=keys.pop();if(key in object)return next.value=key,next.done=!1,next;}return next.done=!0,next;};},exports.values=values,Context.prototype={constructor:Context,reset:function reset(skipTempReset){if(this.prev=0,this.next=0,this.sent=this._sent=undefined,this.done=!1,this.delegate=null,this.method="next",this.arg=undefined,this.tryEntries.forEach(resetTryEntry),!skipTempReset)for(var name in this)"t"===name.charAt(0)&&hasOwn.call(this,name)&&!isNaN(+name.slice(1))&&(this[name]=undefined);},stop:function stop(){this.done=!0;var rootRecord=this.tryEntries[0].completion;if("throw"===rootRecord.type)throw rootRecord.arg;return this.rval;},dispatchException:function dispatchException(exception){if(this.done)throw exception;var context=this;function handle(loc,caught){return record.type="throw",record.arg=exception,context.next=loc,caught&&(context.method="next",context.arg=undefined),!!caught;}for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i],record=entry.completion;if("root"===entry.tryLoc)return handle("end");if(entry.tryLoc<=this.prev){var hasCatch=hasOwn.call(entry,"catchLoc"),hasFinally=hasOwn.call(entry,"finallyLoc");if(hasCatch&&hasFinally){if(this.prev<entry.catchLoc)return handle(entry.catchLoc,!0);if(this.prev<entry.finallyLoc)return handle(entry.finallyLoc);}else if(hasCatch){if(this.prev<entry.catchLoc)return handle(entry.catchLoc,!0);}else{if(!hasFinally)throw new Error("try statement without catch or finally");if(this.prev<entry.finallyLoc)return handle(entry.finallyLoc);}}}},abrupt:function abrupt(type,arg){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.tryLoc<=this.prev&&hasOwn.call(entry,"finallyLoc")&&this.prev<entry.finallyLoc){var finallyEntry=entry;break;}}finallyEntry&&("break"===type||"continue"===type)&&finallyEntry.tryLoc<=arg&&arg<=finallyEntry.finallyLoc&&(finallyEntry=null);var record=finallyEntry?finallyEntry.completion:{};return record.type=type,record.arg=arg,finallyEntry?(this.method="next",this.next=finallyEntry.finallyLoc,ContinueSentinel):this.complete(record);},complete:function complete(record,afterLoc){if("throw"===record.type)throw record.arg;return"break"===record.type||"continue"===record.type?this.next=record.arg:"return"===record.type?(this.rval=this.arg=record.arg,this.method="return",this.next="end"):"normal"===record.type&&afterLoc&&(this.next=afterLoc),ContinueSentinel;},finish:function finish(finallyLoc){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.finallyLoc===finallyLoc)return this.complete(entry.completion,entry.afterLoc),resetTryEntry(entry),ContinueSentinel;}},catch:function _catch(tryLoc){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.tryLoc===tryLoc){var record=entry.completion;if("throw"===record.type){var thrown=record.arg;resetTryEntry(entry);}return thrown;}}throw new Error("illegal catch attempt");},delegateYield:function delegateYield(iterable,resultName,nextLoc){return this.delegate={iterator:values(iterable),resultName:resultName,nextLoc:nextLoc},"next"===this.method&&(this.arg=undefined),ContinueSentinel;}},exports;}function asyncGeneratorStep(gen,resolve,reject,_next,_throw,key,arg){try{var info=gen[key](arg);var value=info.value;}catch(error){reject(error);return;}if(info.done){resolve(value);}else{Promise.resolve(value).then(_next,_throw);}}function _asyncToGenerator(fn){return function(){var self=this,args=arguments;return new Promise(function(resolve,reject){var gen=fn.apply(self,args);function _next(value){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"next",value);}function _throw(err){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"throw",err);}_next(undefined);});};}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}}function _createClass(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);Object.defineProperty(Constructor,"prototype",{writable:false});return Constructor;}function _defineProperty(obj,key,value){key=_toPropertyKey(key);if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true});}else{obj[key]=value;}return obj;}function _toPropertyKey(arg){var key=_toPrimitive(arg,"string");return _typeof(key)==="symbol"?key:String(key);}function _toPrimitive(input,hint){if(_typeof(input)!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(_typeof(res)!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.");}return(hint==="string"?String:Number)(input);}function _createForOfIteratorHelper(o,allowArrayLike){var it=typeof Symbol!=="undefined"&&o[Symbol.iterator]||o["@@iterator"];if(!it){if(Array.isArray(o)||(it=_unsupportedIterableToArray(o))||allowArrayLike&&o&&typeof o.length==="number"){if(it)o=it;var i=0;var F=function F(){};return{s:F,n:function n(){if(i>=o.length)return{done:true};return{done:false,value:o[i++]};},e:function e(_e2){throw _e2;},f:F};}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}var normalCompletion=true,didErr=false,err;return{s:function s(){it=it.call(o);},n:function n(){var step=it.next();normalCompletion=step.done;return step;},e:function e(_e3){didErr=true;err=_e3;},f:function f(){try{if(!normalCompletion&&it.return!=null)it.return();}finally{if(didErr)throw err;}}};}function _unsupportedIterableToArray(o,minLen){if(!o)return;if(typeof o==="string")return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);if(n==="Object"&&o.constructor)n=o.constructor.name;if(n==="Map"||n==="Set")return Array.from(o);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return _arrayLikeToArray(o,minLen);}function _arrayLikeToArray(arr,len){if(len==null||len>arr.length)len=arr.length;for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2;}var DefaultPartialEvaluatorOptions=Object.freeze({maxImageSize:-1,disableFontFace:false,ignoreErrors:false,isEvalSupported:true,isOffscreenCanvasSupported:false,canvasMaxAreaInBytes:-1,fontExtraProperties:false,useSystemFonts:true,cMapUrl:null,standardFontDataUrl:null});var PatternType={TILING:1,SHADING:2};var TEXT_CHUNK_BATCH_SIZE=10;var deferred=Promise.resolve();function normalizeBlendMode(value){var parsingArray=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;if(Array.isArray(value)){var _iterator=_createForOfIteratorHelper(value),_step;try{for(_iterator.s();!(_step=_iterator.n()).done;){var val=_step.value;var maybeBM=normalizeBlendMode(val,true);if(maybeBM){return maybeBM;}}}catch(err){_iterator.e(err);}finally{_iterator.f();}(0,_util.warn)("Unsupported blend mode Array: ".concat(value));return"source-over";}if(!(value instanceof _primitives.Name)){if(parsingArray){return null;}return"source-over";}switch(value.name){case"Normal":case"Compatible":return"source-over";case"Multiply":return"multiply";case"Screen":return"screen";case"Overlay":return"overlay";case"Darken":return"darken";case"Lighten":return"lighten";case"ColorDodge":return"color-dodge";case"ColorBurn":return"color-burn";case"HardLight":return"hard-light";case"SoftLight":return"soft-light";case"Difference":return"difference";case"Exclusion":return"exclusion";case"Hue":return"hue";case"Saturation":return"saturation";case"Color":return"color";case"Luminosity":return"luminosity";}if(parsingArray){return null;}(0,_util.warn)("Unsupported blend mode: ".concat(value.name));return"source-over";}function incrementCachedImageMaskCount(data){var _data$args$;if(data.fn===_util.OPS.paintImageMaskXObject&&((_data$args$=data.args[0])===null||_data$args$===void 0?void 0:_data$args$.count)>0){data.args[0].count++;}}var TimeSlotManager=/*#__PURE__*/function(){function TimeSlotManager(){_classCallCheck(this,TimeSlotManager);this.reset();}_createClass(TimeSlotManager,[{key:"check",value:function check(){if(++this.checked<TimeSlotManager.CHECK_TIME_EVERY){return false;}this.checked=0;return this.endTime<=Date.now();}},{key:"reset",value:function reset(){this.endTime=Date.now()+TimeSlotManager.TIME_SLOT_DURATION_MS;this.checked=0;}}]);return TimeSlotManager;}();_defineProperty(TimeSlotManager,"TIME_SLOT_DURATION_MS",20);_defineProperty(TimeSlotManager,"CHECK_TIME_EVERY",100);var PartialEvaluator=/*#__PURE__*/function(){function PartialEvaluator(_ref){var xref=_ref.xref,handler=_ref.handler,pageIndex=_ref.pageIndex,idFactory=_ref.idFactory,fontCache=_ref.fontCache,builtInCMapCache=_ref.builtInCMapCache,standardFontDataCache=_ref.standardFontDataCache,globalImageCache=_ref.globalImageCache,systemFontCache=_ref.systemFontCache,_ref$options=_ref.options,options=_ref$options===void 0?null:_ref$options;_classCallCheck(this,PartialEvaluator);this.xref=xref;this.handler=handler;this.pageIndex=pageIndex;this.idFactory=idFactory;this.fontCache=fontCache;this.builtInCMapCache=builtInCMapCache;this.standardFontDataCache=standardFontDataCache;this.globalImageCache=globalImageCache;this.systemFontCache=systemFontCache;this.options=options||DefaultPartialEvaluatorOptions;this.parsingType3Font=false;this._regionalImageCache=new _image_utils.RegionalImageCache();this._fetchBuiltInCMapBound=this.fetchBuiltInCMap.bind(this);_image_resizer.ImageResizer.setMaxArea(this.options.canvasMaxAreaInBytes);}_createClass(PartialEvaluator,[{key:"_pdfFunctionFactory",get:function get(){var pdfFunctionFactory=new _function.PDFFunctionFactory({xref:this.xref,isEvalSupported:this.options.isEvalSupported});return(0,_util.shadow)(this,"_pdfFunctionFactory",pdfFunctionFactory);}},{key:"clone",value:function clone(){var newOptions=arguments.length>0&&arguments[0]!==undefined?arguments[0]:null;var newEvaluator=Object.create(this);newEvaluator.options=Object.assign(Object.create(null),this.options,newOptions);return newEvaluator;}},{key:"hasBlendModes",value:function hasBlendModes(resources,nonBlendModesSet){if(!(resources instanceof _primitives.Dict)){return false;}if(resources.objId&&nonBlendModesSet.has(resources.objId)){return false;}var processed=new _primitives.RefSet(nonBlendModesSet);if(resources.objId){processed.put(resources.objId);}var nodes=[resources],xref=this.xref;while(nodes.length){var node=nodes.shift();var graphicStates=node.get("ExtGState");if(graphicStates instanceof _primitives.Dict){var _iterator2=_createForOfIteratorHelper(graphicStates.getRawValues()),_step2;try{for(_iterator2.s();!(_step2=_iterator2.n()).done;){var graphicState=_step2.value;if(graphicState instanceof _primitives.Ref){if(processed.has(graphicState)){continue;}try{graphicState=xref.fetch(graphicState);}catch(ex){processed.put(graphicState);(0,_util.info)("hasBlendModes - ignoring ExtGState: \"".concat(ex,"\"."));continue;}}if(!(graphicState instanceof _primitives.Dict)){continue;}if(graphicState.objId){processed.put(graphicState.objId);}var bm=graphicState.get("BM");if(bm instanceof _primitives.Name){if(bm.name!=="Normal"){return true;}continue;}if(bm!==undefined&&Array.isArray(bm)){var _iterator3=_createForOfIteratorHelper(bm),_step3;try{for(_iterator3.s();!(_step3=_iterator3.n()).done;){var element=_step3.value;if(element instanceof _primitives.Name&&element.name!=="Normal"){return true;}}}catch(err){_iterator3.e(err);}finally{_iterator3.f();}}}}catch(err){_iterator2.e(err);}finally{_iterator2.f();}}var xObjects=node.get("XObject");if(!(xObjects instanceof _primitives.Dict)){continue;}var _iterator4=_createForOfIteratorHelper(xObjects.getRawValues()),_step4;try{for(_iterator4.s();!(_step4=_iterator4.n()).done;){var xObject=_step4.value;if(xObject instanceof _primitives.Ref){if(processed.has(xObject)){continue;}try{xObject=xref.fetch(xObject);}catch(ex){processed.put(xObject);(0,_util.info)("hasBlendModes - ignoring XObject: \"".concat(ex,"\"."));continue;}}if(!(xObject instanceof _base_stream.BaseStream)){continue;}if(xObject.dict.objId){processed.put(xObject.dict.objId);}var xResources=xObject.dict.get("Resources");if(!(xResources instanceof _primitives.Dict)){continue;}if(xResources.objId&&processed.has(xResources.objId)){continue;}nodes.push(xResources);if(xResources.objId){processed.put(xResources.objId);}}}catch(err){_iterator4.e(err);}finally{_iterator4.f();}}var _iterator5=_createForOfIteratorHelper(processed),_step5;try{for(_iterator5.s();!(_step5=_iterator5.n()).done;){var ref=_step5.value;nonBlendModesSet.put(ref);}}catch(err){_iterator5.e(err);}finally{_iterator5.f();}return false;}},{key:"fetchBuiltInCMap",value:function(){var _fetchBuiltInCMap=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee(name){var _cMapUrl;var cachedData,data,cMapUrl,url,response;return _regeneratorRuntime().wrap(function _callee$(_context){while(1)switch(_context.prev=_context.next){case 0:cachedData=this.builtInCMapCache.get(name);if(!cachedData){_context.next=3;break;}return _context.abrupt("return",cachedData);case 3:cMapUrl=this.options.cMapUrl;if(((_cMapUrl=cMapUrl)===null||_cMapUrl===void 0?void 0:_cMapUrl.constructor.name)==="Function"){cMapUrl=cMapUrl();}if(!(cMapUrl!==null)){_context.next=21;break;}url="".concat(cMapUrl).concat(name,".bcmap");_context.next=9;return fetch(url);case 9:response=_context.sent;if(response.ok){_context.next=12;break;}throw new Error("fetchBuiltInCMap: failed to fetch file \"".concat(url,"\" with \"").concat(response.statusText,"\"."));case 12:_context.t0=Uint8Array;_context.next=15;return response.arrayBuffer();case 15:_context.t1=_context.sent;_context.t2=new _context.t0(_context.t1);_context.t3=_util.CMapCompressionType.BINARY;data={cMapData:_context.t2,compressionType:_context.t3};_context.next=24;break;case 21:_context.next=23;return this.handler.sendWithPromise("FetchBuiltInCMap",{name:name});case 23:data=_context.sent;case 24:if(data.compressionType!==_util.CMapCompressionType.NONE){this.builtInCMapCache.set(name,data);}return _context.abrupt("return",data);case 26:case"end":return _context.stop();}},_callee,this);}));function fetchBuiltInCMap(_x){return _fetchBuiltInCMap.apply(this,arguments);}return fetchBuiltInCMap;}()},{key:"fetchStandardFontData",value:function(){var _fetchStandardFontData=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee2(name){var cachedData,standardFontNameToFileName,filename,data,url,response;return _regeneratorRuntime().wrap(function _callee2$(_context2){while(1)switch(_context2.prev=_context2.next){case 0:cachedData=this.standardFontDataCache.get(name);if(!cachedData){_context2.next=3;break;}return _context2.abrupt("return",new _stream.Stream(cachedData));case 3:if(!(this.options.useSystemFonts&&name!=="Symbol"&&name!=="ZapfDingbats")){_context2.next=5;break;}return _context2.abrupt("return",null);case 5:standardFontNameToFileName=(0,_standard_fonts.getFontNameToFileMap)(),filename=standardFontNameToFileName[name];if(!(this.options.standardFontDataUrl!==null)){_context2.next=20;break;}url="".concat(this.options.standardFontDataUrl).concat(filename);_context2.next=10;return fetch(url);case 10:response=_context2.sent;if(response.ok){_context2.next=15;break;}(0,_util.warn)("fetchStandardFontData: failed to fetch file \"".concat(url,"\" with \"").concat(response.statusText,"\"."));_context2.next=18;break;case 15:_context2.next=17;return response.arrayBuffer();case 17:data=_context2.sent;case 18:_context2.next=29;break;case 20:_context2.prev=20;_context2.next=23;return this.handler.sendWithPromise("FetchStandardFontData",{filename:filename});case 23:data=_context2.sent;_context2.next=29;break;case 26:_context2.prev=26;_context2.t0=_context2["catch"](20);(0,_util.warn)("fetchStandardFontData: failed to fetch file \"".concat(filename,"\" with \"").concat(_context2.t0,"\"."));case 29:if(data){_context2.next=31;break;}return _context2.abrupt("return",null);case 31:this.standardFontDataCache.set(name,data);return _context2.abrupt("return",new _stream.Stream(data));case 33:case"end":return _context2.stop();}},_callee2,this,[[20,26]]);}));function fetchStandardFontData(_x2){return _fetchStandardFontData.apply(this,arguments);}return fetchStandardFontData;}()},{key:"buildFormXObject",value:function(){var _buildFormXObject=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee3(resources,xobj,smask,operatorList,task,initialState,localColorSpaceCache){var dict,matrix,bbox,optionalContent,groupOptions,group,groupSubtype,colorSpace,cs,cachedColorSpace,args;return _regeneratorRuntime().wrap(function _callee3$(_context3){while(1)switch(_context3.prev=_context3.next){case 0:dict=xobj.dict;matrix=dict.getArray("Matrix");bbox=dict.getArray("BBox");bbox=Array.isArray(bbox)&&bbox.length===4?_util.Util.normalizeRect(bbox):null;if(!dict.has("OC")){_context3.next=8;break;}_context3.next=7;return this.parseMarkedContentProps(dict.get("OC"),resources);case 7:optionalContent=_context3.sent;case 8:if(optionalContent!==undefined){operatorList.addOp(_util.OPS.beginMarkedContentProps,["OC",optionalContent]);}group=dict.get("Group");if(!group){_context3.next=29;break;}groupOptions={matrix:matrix,bbox:bbox,smask:smask,isolated:false,knockout:false};groupSubtype=group.get("S");colorSpace=null;if(!(0,_primitives.isName)(groupSubtype,"Transparency")){_context3.next=27;break;}groupOptions.isolated=group.get("I")||false;groupOptions.knockout=group.get("K")||false;if(!group.has("CS")){_context3.next=27;break;}cs=group.getRaw("CS");cachedColorSpace=_colorspace.ColorSpace.getCached(cs,this.xref,localColorSpaceCache);if(!cachedColorSpace){_context3.next=24;break;}colorSpace=cachedColorSpace;_context3.next=27;break;case 24:_context3.next=26;return this.parseColorSpace({cs:cs,resources:resources,localColorSpaceCache:localColorSpaceCache});case 26:colorSpace=_context3.sent;case 27:if(smask!==null&&smask!==void 0&&smask.backdrop){colorSpace||(colorSpace=_colorspace.ColorSpace.singletons.rgb);smask.backdrop=colorSpace.getRgb(smask.backdrop,0);}operatorList.addOp(_util.OPS.beginGroup,[groupOptions]);case 29:args=group?[matrix,null]:[matrix,bbox];operatorList.addOp(_util.OPS.paintFormXObjectBegin,args);return _context3.abrupt("return",this.getOperatorList({stream:xobj,task:task,resources:dict.get("Resources")||resources,operatorList:operatorList,initialState:initialState}).then(function(){operatorList.addOp(_util.OPS.paintFormXObjectEnd,[]);if(group){operatorList.addOp(_util.OPS.endGroup,[groupOptions]);}if(optionalContent!==undefined){operatorList.addOp(_util.OPS.endMarkedContent,[]);}}));case 32:case"end":return _context3.stop();}},_callee3,this);}));function buildFormXObject(_x3,_x4,_x5,_x6,_x7,_x8,_x9){return _buildFormXObject.apply(this,arguments);}return buildFormXObject;}()},{key:"_sendImgData",value:function _sendImgData(objId,imgData){var cacheGlobally=arguments.length>2&&arguments[2]!==undefined?arguments[2]:false;var transfers=imgData?[imgData.bitmap||imgData.data.buffer]:null;if(this.parsingType3Font||cacheGlobally){return this.handler.send("commonobj",[objId,"Image",imgData],transfers);}return this.handler.send("obj",[objId,this.pageIndex,"Image",imgData],transfers);}},{key:"buildPaintImageXObject",value:function(){var _buildPaintImageXObject=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee5(_ref2){var _this=this;var resources,image,_ref2$isInline,isInline,operatorList,cacheKey,localImageCache,localColorSpaceCache,dict,imageRef,w,h,maxImageSize,msg,optionalContent,imageMask,imgData,args,interpolate,bitStrideLength,imgArray,decode,cacheData,_cacheData,_objId,_cacheData2,SMALL_IMAGE_DIMENSIONS,imageObj,objId,cacheGlobally,_cacheData3;return _regeneratorRuntime().wrap(function _callee5$(_context5){while(1)switch(_context5.prev=_context5.next){case 0:resources=_ref2.resources,image=_ref2.image,_ref2$isInline=_ref2.isInline,isInline=_ref2$isInline===void 0?false:_ref2$isInline,operatorList=_ref2.operatorList,cacheKey=_ref2.cacheKey,localImageCache=_ref2.localImageCache,localColorSpaceCache=_ref2.localColorSpaceCache;dict=image.dict;imageRef=dict.objId;w=dict.get("W","Width");h=dict.get("H","Height");if(!(!(w&&typeof w==="number")||!(h&&typeof h==="number"))){_context5.next=8;break;}(0,_util.warn)("Image dimensions are missing, or not numbers.");return _context5.abrupt("return");case 8:maxImageSize=this.options.maxImageSize;if(!(maxImageSize!==-1&&w*h>maxImageSize)){_context5.next=15;break;}msg="Image exceeded maximum allowed size and was removed.";if(!this.options.ignoreErrors){_context5.next=14;break;}(0,_util.warn)(msg);return _context5.abrupt("return");case 14:throw new Error(msg);case 15:if(!dict.has("OC")){_context5.next=19;break;}_context5.next=18;return this.parseMarkedContentProps(dict.get("OC"),resources);case 18:optionalContent=_context5.sent;case 19:imageMask=dict.get("IM","ImageMask")||false;if(!imageMask){_context5.next=46;break;}interpolate=dict.get("I","Interpolate");bitStrideLength=w+7>>3;imgArray=image.getBytes(bitStrideLength*h);decode=dict.getArray("D","Decode");if(!this.parsingType3Font){_context5.next=32;break;}imgData=_image.PDFImage.createRawMask({imgArray:imgArray,width:w,height:h,imageIsFromDecodeStream:image instanceof _decode_stream.DecodeStream,inverseDecode:(decode===null||decode===void 0?void 0:decode[0])>0,interpolate:interpolate});imgData.cached=!!cacheKey;args=[imgData];operatorList.addImageOps(_util.OPS.paintImageMaskXObject,args,optionalContent);if(cacheKey){cacheData={fn:_util.OPS.paintImageMaskXObject,args:args,optionalContent:optionalContent};localImageCache.set(cacheKey,imageRef,cacheData);if(imageRef){this._regionalImageCache.set(null,imageRef,cacheData);}}return _context5.abrupt("return");case 32:_context5.next=34;return _image.PDFImage.createMask({imgArray:imgArray,width:w,height:h,imageIsFromDecodeStream:image instanceof _decode_stream.DecodeStream,inverseDecode:(decode===null||decode===void 0?void 0:decode[0])>0,interpolate:interpolate,isOffscreenCanvasSupported:this.options.isOffscreenCanvasSupported});case 34:imgData=_context5.sent;if(!imgData.isSingleOpaquePixel){_context5.next=39;break;}operatorList.addImageOps(_util.OPS.paintSolidColorImageMask,[],optionalContent);if(cacheKey){_cacheData={fn:_util.OPS.paintSolidColorImageMask,args:[],optionalContent:optionalContent};localImageCache.set(cacheKey,imageRef,_cacheData);if(imageRef){this._regionalImageCache.set(null,imageRef,_cacheData);}}return _context5.abrupt("return");case 39:_objId="mask_".concat(this.idFactory.createObjId());operatorList.addDependency(_objId);this._sendImgData(_objId,imgData);args=[{data:_objId,width:imgData.width,height:imgData.height,interpolate:imgData.interpolate,count:1}];operatorList.addImageOps(_util.OPS.paintImageMaskXObject,args,optionalContent);if(cacheKey){_cacheData2={fn:_util.OPS.paintImageMaskXObject,args:args,optionalContent:optionalContent};localImageCache.set(cacheKey,imageRef,_cacheData2);if(imageRef){this._regionalImageCache.set(null,imageRef,_cacheData2);}}return _context5.abrupt("return");case 46:SMALL_IMAGE_DIMENSIONS=200;if(!(isInline&&!dict.has("SMask")&&!dict.has("Mask")&&w+h<SMALL_IMAGE_DIMENSIONS)){_context5.next=55;break;}imageObj=new _image.PDFImage({xref:this.xref,res:resources,image:image,isInline:isInline,pdfFunctionFactory:this._pdfFunctionFactory,localColorSpaceCache:localColorSpaceCache});_context5.next=51;return imageObj.createImageData(true,false);case 51:imgData=_context5.sent;operatorList.isOffscreenCanvasSupported=this.options.isOffscreenCanvasSupported;operatorList.addImageOps(_util.OPS.paintInlineImageXObject,[imgData],optionalContent);return _context5.abrupt("return");case 55:objId="img_".concat(this.idFactory.createObjId()),cacheGlobally=false;if(this.parsingType3Font){objId="".concat(this.idFactory.getDocId(),"_type3_").concat(objId);}else if(imageRef){cacheGlobally=this.globalImageCache.shouldCache(imageRef,this.pageIndex);if(cacheGlobally){objId="".concat(this.idFactory.getDocId(),"_").concat(objId);}}operatorList.addDependency(objId);args=[objId,w,h];_image.PDFImage.buildImage({xref:this.xref,res:resources,image:image,isInline:isInline,pdfFunctionFactory:this._pdfFunctionFactory,localColorSpaceCache:localColorSpaceCache}).then(/*#__PURE__*/function(){var _ref3=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee4(imageObj){var length;return _regeneratorRuntime().wrap(function _callee4$(_context4){while(1)switch(_context4.prev=_context4.next){case 0:_context4.next=2;return imageObj.createImageData(false,_this.options.isOffscreenCanvasSupported);case 2:imgData=_context4.sent;if(cacheKey&&imageRef&&cacheGlobally){length=imgData.bitmap?imgData.width*imgData.height*4:imgData.data.length;_this.globalImageCache.addByteSize(imageRef,length);}return _context4.abrupt("return",_this._sendImgData(objId,imgData,cacheGlobally));case 5:case"end":return _context4.stop();}},_callee4);}));return function(_x11){return _ref3.apply(this,arguments);};}()).catch(function(reason){(0,_util.warn)("Unable to decode image \"".concat(objId,"\": \"").concat(reason,"\"."));return _this._sendImgData(objId,null,cacheGlobally);});operatorList.addImageOps(_util.OPS.paintImageXObject,args,optionalContent);if(cacheKey){_cacheData3={fn:_util.OPS.paintImageXObject,args:args,optionalContent:optionalContent};localImageCache.set(cacheKey,imageRef,_cacheData3);if(imageRef){this._regionalImageCache.set(null,imageRef,_cacheData3);if(cacheGlobally){(0,_util.assert)(!isInline,"Cannot cache an inline image globally.");this.globalImageCache.setData(imageRef,{objId:objId,fn:_util.OPS.paintImageXObject,args:args,optionalContent:optionalContent,byteSize:0});}}}case 62:case"end":return _context5.stop();}},_callee5,this);}));function buildPaintImageXObject(_x10){return _buildPaintImageXObject.apply(this,arguments);}return buildPaintImageXObject;}()},{key:"handleSMask",value:function handleSMask(smask,resources,operatorList,task,stateManager,localColorSpaceCache){var smaskContent=smask.get("G");var smaskOptions={subtype:smask.get("S").name,backdrop:smask.get("BC")};var transferObj=smask.get("TR");if((0,_function.isPDFFunction)(transferObj)){var transferFn=this._pdfFunctionFactory.create(transferObj);var transferMap=new Uint8Array(256);var tmp=new Float32Array(1);for(var i=0;i<256;i++){tmp[0]=i/255;transferFn(tmp,0,tmp,0);transferMap[i]=tmp[0]*255|0;}smaskOptions.transferMap=transferMap;}return this.buildFormXObject(resources,smaskContent,smaskOptions,operatorList,task,stateManager.state.clone(),localColorSpaceCache);}},{key:"handleTransferFunction",value:function handleTransferFunction(tr){var transferArray;if(Array.isArray(tr)){transferArray=tr;}else if((0,_function.isPDFFunction)(tr)){transferArray=[tr];}else{return null;}var transferMaps=[];var numFns=0,numEffectfulFns=0;var _iterator6=_createForOfIteratorHelper(transferArray),_step6;try{for(_iterator6.s();!(_step6=_iterator6.n()).done;){var entry=_step6.value;var transferObj=this.xref.fetchIfRef(entry);numFns++;if((0,_primitives.isName)(transferObj,"Identity")){transferMaps.push(null);continue;}else if(!(0,_function.isPDFFunction)(transferObj)){return null;}var transferFn=this._pdfFunctionFactory.create(transferObj);var transferMap=new Uint8Array(256),tmp=new Float32Array(1);for(var j=0;j<256;j++){tmp[0]=j/255;transferFn(tmp,0,tmp,0);transferMap[j]=tmp[0]*255|0;}transferMaps.push(transferMap);numEffectfulFns++;}}catch(err){_iterator6.e(err);}finally{_iterator6.f();}if(!(numFns===1||numFns===4)){return null;}if(numEffectfulFns===0){return null;}return transferMaps;}},{key:"handleTilingType",value:function handleTilingType(fn,color,resources,pattern,patternDict,operatorList,task,localTilingPatternCache){var _this2=this;var tilingOpList=new _operator_list.OperatorList();var patternResources=_primitives.Dict.merge({xref:this.xref,dictArray:[patternDict.get("Resources"),resources]});return this.getOperatorList({stream:pattern,task:task,resources:patternResources,operatorList:tilingOpList}).then(function(){var operatorListIR=tilingOpList.getIR();var tilingPatternIR=(0,_pattern.getTilingPatternIR)(operatorListIR,patternDict,color);operatorList.addDependencies(tilingOpList.dependencies);operatorList.addOp(fn,tilingPatternIR);if(patternDict.objId){localTilingPatternCache.set(null,patternDict.objId,{operatorListIR:operatorListIR,dict:patternDict});}}).catch(function(reason){if(reason instanceof _util.AbortException){return;}if(_this2.options.ignoreErrors){(0,_util.warn)("handleTilingType - ignoring pattern: \"".concat(reason,"\"."));return;}throw reason;});}},{key:"handleSetFont",value:function handleSetFont(resources,fontArgs,fontRef,operatorList,task,state){var _this3=this;var fallbackFontDict=arguments.length>6&&arguments[6]!==undefined?arguments[6]:null;var cssFontInfo=arguments.length>7&&arguments[7]!==undefined?arguments[7]:null;var fontName=(fontArgs===null||fontArgs===void 0?void 0:fontArgs[0])instanceof _primitives.Name?fontArgs[0].name:null;return this.loadFont(fontName,fontRef,resources,fallbackFontDict,cssFontInfo).then(function(translated){if(!translated.font.isType3Font){return translated;}return translated.loadType3Data(_this3,resources,task).then(function(){operatorList.addDependencies(translated.type3Dependencies);return translated;}).catch(function(reason){return new TranslatedFont({loadedName:"g_font_error",font:new _fonts.ErrorFont("Type3 font load error: ".concat(reason)),dict:translated.font,evaluatorOptions:_this3.options});});}).then(function(translated){state.font=translated.font;translated.send(_this3.handler);return translated.loadedName;});}},{key:"handleText",value:function handleText(chars,state){var font=state.font;var glyphs=font.charsToGlyphs(chars);if(font.data){var isAddToPathSet=!!(state.textRenderingMode&_util.TextRenderingMode.ADD_TO_PATH_FLAG);if(isAddToPathSet||state.fillColorSpace.name==="Pattern"||font.disableFontFace||this.options.disableFontFace){PartialEvaluator.buildFontPaths(font,glyphs,this.handler,this.options);}}return glyphs;}},{key:"ensureStateFont",value:function ensureStateFont(state){if(state.font){return;}var reason=new _util.FormatError("Missing setFont (Tf) operator before text rendering operator.");if(this.options.ignoreErrors){(0,_util.warn)("ensureStateFont: \"".concat(reason,"\"."));return;}throw reason;}},{key:"setGState",value:function(){var _setGState=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee6(_ref4){var _this4=this;var resources,gState,operatorList,cacheKey,task,stateManager,localGStateCache,localColorSpaceCache,gStateRef,isSimpleGState,gStateObj,promise,_iterator7,_step7,_loop;return _regeneratorRuntime().wrap(function _callee6$(_context7){while(1)switch(_context7.prev=_context7.next){case 0:resources=_ref4.resources,gState=_ref4.gState,operatorList=_ref4.operatorList,cacheKey=_ref4.cacheKey,task=_ref4.task,stateManager=_ref4.stateManager,localGStateCache=_ref4.localGStateCache,localColorSpaceCache=_ref4.localColorSpaceCache;gStateRef=gState.objId;isSimpleGState=true;gStateObj=[];promise=Promise.resolve();_iterator7=_createForOfIteratorHelper(gState.getKeys());_context7.prev=6;_loop=/*#__PURE__*/_regeneratorRuntime().mark(function _loop(){var key,value,transferMaps;return _regeneratorRuntime().wrap(function _loop$(_context6){while(1)switch(_context6.prev=_context6.next){case 0:key=_step7.value;value=gState.get(key);_context6.t0=key;_context6.next=_context6.t0==="Type"?5:_context6.t0==="LW"?6:_context6.t0==="LC"?6:_context6.t0==="LJ"?6:_context6.t0==="ML"?6:_context6.t0==="D"?6:_context6.t0==="RI"?6:_context6.t0==="FL"?6:_context6.t0==="CA"?6:_context6.t0==="ca"?6:_context6.t0==="Font"?8:_context6.t0==="BM"?11:_context6.t0==="SMask"?13:_context6.t0==="TR"?18:_context6.t0==="OP"?21:_context6.t0==="op"?21:_context6.t0==="OPM"?21:_context6.t0==="BG"?21:_context6.t0==="BG2"?21:_context6.t0==="UCR"?21:_context6.t0==="UCR2"?21:_context6.t0==="TR2"?21:_context6.t0==="HT"?21:_context6.t0==="SM"?21:_context6.t0==="SA"?21:_context6.t0==="AIS"?21:_context6.t0==="TK"?21:23;break;case 5:return _context6.abrupt("break",25);case 6:gStateObj.push([key,value]);return _context6.abrupt("break",25);case 8:isSimpleGState=false;promise=promise.then(function(){return _this4.handleSetFont(resources,null,value[0],operatorList,task,stateManager.state).then(function(loadedName){operatorList.addDependency(loadedName);gStateObj.push([key,[loadedName,value[1]]]);});});return _context6.abrupt("break",25);case 11:gStateObj.push([key,normalizeBlendMode(value)]);return _context6.abrupt("break",25);case 13:if(!(0,_primitives.isName)(value,"None")){_context6.next=16;break;}gStateObj.push([key,false]);return _context6.abrupt("break",25);case 16:if(value instanceof _primitives.Dict){isSimpleGState=false;promise=promise.then(function(){return _this4.handleSMask(value,resources,operatorList,task,stateManager,localColorSpaceCache);});gStateObj.push([key,true]);}else{(0,_util.warn)("Unsupported SMask type");}return _context6.abrupt("break",25);case 18:transferMaps=_this4.handleTransferFunction(value);gStateObj.push([key,transferMaps]);return _context6.abrupt("break",25);case 21:(0,_util.info)("graphic state operator "+key);return _context6.abrupt("break",25);case 23:(0,_util.info)("Unknown graphic state operator "+key);return _context6.abrupt("break",25);case 25:case"end":return _context6.stop();}},_loop);});_iterator7.s();case 9:if((_step7=_iterator7.n()).done){_context7.next=13;break;}return _context7.delegateYield(_loop(),"t0",11);case 11:_context7.next=9;break;case 13:_context7.next=18;break;case 15:_context7.prev=15;_context7.t1=_context7["catch"](6);_iterator7.e(_context7.t1);case 18:_context7.prev=18;_iterator7.f();return _context7.finish(18);case 21:return _context7.abrupt("return",promise.then(function(){if(gStateObj.length>0){operatorList.addOp(_util.OPS.setGState,[gStateObj]);}if(isSimpleGState){localGStateCache.set(cacheKey,gStateRef,gStateObj);}}));case 22:case"end":return _context7.stop();}},_callee6,null,[[6,15,18,21]]);}));function setGState(_x12){return _setGState.apply(this,arguments);}return setGState;}()},{key:"loadFont",value:function loadFont(fontName,font,resources){var _this5=this,_fontID;var fallbackFontDict=arguments.length>3&&arguments[3]!==undefined?arguments[3]:null;var cssFontInfo=arguments.length>4&&arguments[4]!==undefined?arguments[4]:null;var errorFont=/*#__PURE__*/function(){var _ref5=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee7(){return _regeneratorRuntime().wrap(function _callee7$(_context8){while(1)switch(_context8.prev=_context8.next){case 0:return _context8.abrupt("return",new TranslatedFont({loadedName:"g_font_error",font:new _fonts.ErrorFont("Font \"".concat(fontName,"\" is not available.")),dict:font,evaluatorOptions:_this5.options}));case 1:case"end":return _context8.stop();}},_callee7);}));return function errorFont(){return _ref5.apply(this,arguments);};}();var fontRef;if(font){if(font instanceof _primitives.Ref){fontRef=font;}}else{var fontRes=resources.get("Font");if(fontRes){fontRef=fontRes.getRaw(fontName);}}if(fontRef){if(this.parsingType3Font&&this.type3FontRefs.has(fontRef)){return errorFont();}if(this.fontCache.has(fontRef)){return this.fontCache.get(fontRef);}font=this.xref.fetchIfRef(fontRef);}if(!(font instanceof _primitives.Dict)){if(!this.options.ignoreErrors&&!this.parsingType3Font){(0,_util.warn)("Font \"".concat(fontName,"\" is not available."));return errorFont();}(0,_util.warn)("Font \"".concat(fontName,"\" is not available -- attempting to fallback to a default font."));font=fallbackFontDict||PartialEvaluator.fallbackFontDict;}if(font.cacheKey&&this.fontCache.has(font.cacheKey)){return this.fontCache.get(font.cacheKey);}var fontCapability=new _util.PromiseCapability();var preEvaluatedFont;try{preEvaluatedFont=this.preEvaluateFont(font);preEvaluatedFont.cssFontInfo=cssFontInfo;}catch(reason){(0,_util.warn)("loadFont - preEvaluateFont failed: \"".concat(reason,"\"."));return errorFont();}var _preEvaluatedFont=preEvaluatedFont,descriptor=_preEvaluatedFont.descriptor,hash=_preEvaluatedFont.hash;var fontRefIsRef=fontRef instanceof _primitives.Ref;var fontID;if(hash&&descriptor instanceof _primitives.Dict){var fontAliases=descriptor.fontAliases||(descriptor.fontAliases=Object.create(null));if(fontAliases[hash]){var aliasFontRef=fontAliases[hash].aliasRef;if(fontRefIsRef&&aliasFontRef&&this.fontCache.has(aliasFontRef)){this.fontCache.putAlias(fontRef,aliasFontRef);return this.fontCache.get(fontRef);}}else{fontAliases[hash]={fontID:this.idFactory.createFontId()};}if(fontRefIsRef){fontAliases[hash].aliasRef=fontRef;}fontID=fontAliases[hash].fontID;}else{fontID=this.idFactory.createFontId();}(0,_util.assert)((_fontID=fontID)===null||_fontID===void 0?void 0:_fontID.startsWith("f"),'The "fontID" must be (correctly) defined.');if(fontRefIsRef){this.fontCache.put(fontRef,fontCapability.promise);}else{font.cacheKey="cacheKey_".concat(fontID);this.fontCache.put(font.cacheKey,fontCapability.promise);}font.loadedName="".concat(this.idFactory.getDocId(),"_").concat(fontID);this.translateFont(preEvaluatedFont).then(function(translatedFont){fontCapability.resolve(new TranslatedFont({loadedName:font.loadedName,font:translatedFont,dict:font,evaluatorOptions:_this5.options}));}).catch(function(reason){(0,_util.warn)("loadFont - translateFont failed: \"".concat(reason,"\"."));fontCapability.resolve(new TranslatedFont({loadedName:font.loadedName,font:new _fonts.ErrorFont(reason instanceof Error?reason.message:reason),dict:font,evaluatorOptions:_this5.options}));});return fontCapability.promise;}},{key:"buildPath",value:function buildPath(operatorList,fn,args){var parsingText=arguments.length>3&&arguments[3]!==undefined?arguments[3]:false;var lastIndex=operatorList.length-1;if(!args){args=[];}if(lastIndex<0||operatorList.fnArray[lastIndex]!==_util.OPS.constructPath){if(parsingText){(0,_util.warn)("Encountered path operator \"".concat(fn,"\" inside of a text object."));operatorList.addOp(_util.OPS.save,null);}var minMax;switch(fn){case _util.OPS.rectangle:var x=args[0]+args[2];var y=args[1]+args[3];minMax=[Math.min(args[0],x),Math.max(args[0],x),Math.min(args[1],y),Math.max(args[1],y)];break;case _util.OPS.moveTo:case _util.OPS.lineTo:minMax=[args[0],args[0],args[1],args[1]];break;default:minMax=[Infinity,-Infinity,Infinity,-Infinity];break;}operatorList.addOp(_util.OPS.constructPath,[[fn],args,minMax]);if(parsingText){operatorList.addOp(_util.OPS.restore,null);}}else{var _opArgs$;var opArgs=operatorList.argsArray[lastIndex];opArgs[0].push(fn);(_opArgs$=opArgs[1]).push.apply(_opArgs$,_toConsumableArray(args));var _minMax=opArgs[2];switch(fn){case _util.OPS.rectangle:var _x13=args[0]+args[2];var _y=args[1]+args[3];_minMax[0]=Math.min(_minMax[0],args[0],_x13);_minMax[1]=Math.max(_minMax[1],args[0],_x13);_minMax[2]=Math.min(_minMax[2],args[1],_y);_minMax[3]=Math.max(_minMax[3],args[1],_y);break;case _util.OPS.moveTo:case _util.OPS.lineTo:_minMax[0]=Math.min(_minMax[0],args[0]);_minMax[1]=Math.max(_minMax[1],args[0]);_minMax[2]=Math.min(_minMax[2],args[1]);_minMax[3]=Math.max(_minMax[3],args[1]);break;}}}},{key:"parseColorSpace",value:function parseColorSpace(_ref6){var _this6=this;var cs=_ref6.cs,resources=_ref6.resources,localColorSpaceCache=_ref6.localColorSpaceCache;return _colorspace.ColorSpace.parseAsync({cs:cs,xref:this.xref,resources:resources,pdfFunctionFactory:this._pdfFunctionFactory,localColorSpaceCache:localColorSpaceCache}).catch(function(reason){if(reason instanceof _util.AbortException){return null;}if(_this6.options.ignoreErrors){(0,_util.warn)("parseColorSpace - ignoring ColorSpace: \"".concat(reason,"\"."));return null;}throw reason;});}},{key:"parseShading",value:function parseShading(_ref7){var shading=_ref7.shading,resources=_ref7.resources,localColorSpaceCache=_ref7.localColorSpaceCache,localShadingPatternCache=_ref7.localShadingPatternCache;var id=localShadingPatternCache.get(shading);if(!id){var shadingFill=_pattern.Pattern.parseShading(shading,this.xref,resources,this._pdfFunctionFactory,localColorSpaceCache);var patternIR=shadingFill.getIR();id="pattern_".concat(this.idFactory.createObjId());if(this.parsingType3Font){id="".concat(this.idFactory.getDocId(),"_type3_").concat(id);}localShadingPatternCache.set(shading,id);if(this.parsingType3Font){this.handler.send("commonobj",[id,"Pattern",patternIR]);}else{this.handler.send("obj",[id,this.pageIndex,"Pattern",patternIR]);}}return id;}},{key:"handleColorN",value:function handleColorN(operatorList,fn,args,cs,patterns,resources,task,localColorSpaceCache,localTilingPatternCache,localShadingPatternCache){var patternName=args.pop();if(patternName instanceof _primitives.Name){var rawPattern=patterns.getRaw(patternName.name);var localTilingPattern=rawPattern instanceof _primitives.Ref&&localTilingPatternCache.getByRef(rawPattern);if(localTilingPattern){try{var color=cs.base?cs.base.getRgb(args,0):null;var tilingPatternIR=(0,_pattern.getTilingPatternIR)(localTilingPattern.operatorListIR,localTilingPattern.dict,color);operatorList.addOp(fn,tilingPatternIR);return undefined;}catch(_unused){}}var pattern=this.xref.fetchIfRef(rawPattern);if(pattern){var dict=pattern instanceof _base_stream.BaseStream?pattern.dict:pattern;var typeNum=dict.get("PatternType");if(typeNum===PatternType.TILING){var _color=cs.base?cs.base.getRgb(args,0):null;return this.handleTilingType(fn,_color,resources,pattern,dict,operatorList,task,localTilingPatternCache);}else if(typeNum===PatternType.SHADING){var shading=dict.get("Shading");var matrix=dict.getArray("Matrix");var objId=this.parseShading({shading:shading,resources:resources,localColorSpaceCache:localColorSpaceCache,localShadingPatternCache:localShadingPatternCache});operatorList.addOp(fn,["Shading",objId,matrix]);return undefined;}throw new _util.FormatError("Unknown PatternType: ".concat(typeNum));}}throw new _util.FormatError("Unknown PatternName: ".concat(patternName));}},{key:"_parseVisibilityExpression",value:function _parseVisibilityExpression(array,nestingCounter,currentResult){var MAX_NESTING=10;if(++nestingCounter>MAX_NESTING){(0,_util.warn)("Visibility expression is too deeply nested");return;}var length=array.length;var operator=this.xref.fetchIfRef(array[0]);if(length<2||!(operator instanceof _primitives.Name)){(0,_util.warn)("Invalid visibility expression");return;}switch(operator.name){case"And":case"Or":case"Not":currentResult.push(operator.name);break;default:(0,_util.warn)("Invalid operator ".concat(operator.name," in visibility expression"));return;}for(var i=1;i<length;i++){var raw=array[i];var object=this.xref.fetchIfRef(raw);if(Array.isArray(object)){var nestedResult=[];currentResult.push(nestedResult);this._parseVisibilityExpression(object,nestingCounter,nestedResult);}else if(raw instanceof _primitives.Ref){currentResult.push(raw.toString());}}}},{key:"parseMarkedContentProps",value:function(){var _parseMarkedContentProps=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee8(contentProperties,resources){var optionalContent,properties,optionalContentType,expression,result,optionalContentGroups,groupIds,_iterator8,_step8,ocg;return _regeneratorRuntime().wrap(function _callee8$(_context9){while(1)switch(_context9.prev=_context9.next){case 0:if(!(contentProperties instanceof _primitives.Name)){_context9.next=5;break;}properties=resources.get("Properties");optionalContent=properties.get(contentProperties.name);_context9.next=10;break;case 5:if(!(contentProperties instanceof _primitives.Dict)){_context9.next=9;break;}optionalContent=contentProperties;_context9.next=10;break;case 9:throw new _util.FormatError("Optional content properties malformed.");case 10:optionalContentType=optionalContent.get("Type").name;if(!(optionalContentType==="OCG")){_context9.next=15;break;}return _context9.abrupt("return",{type:optionalContentType,id:optionalContent.objId});case 15:if(!(optionalContentType==="OCMD")){_context9.next=31;break;}expression=optionalContent.get("VE");if(!Array.isArray(expression)){_context9.next=22;break;}result=[];this._parseVisibilityExpression(expression,0,result);if(!(result.length>0)){_context9.next=22;break;}return _context9.abrupt("return",{type:"OCMD",expression:result});case 22:optionalContentGroups=optionalContent.get("OCGs");if(!(Array.isArray(optionalContentGroups)||optionalContentGroups instanceof _primitives.Dict)){_context9.next=29;break;}groupIds=[];if(Array.isArray(optionalContentGroups)){_iterator8=_createForOfIteratorHelper(optionalContentGroups);try{for(_iterator8.s();!(_step8=_iterator8.n()).done;){ocg=_step8.value;groupIds.push(ocg.toString());}}catch(err){_iterator8.e(err);}finally{_iterator8.f();}}else{groupIds.push(optionalContentGroups.objId);}return _context9.abrupt("return",{type:optionalContentType,ids:groupIds,policy:optionalContent.get("P")instanceof _primitives.Name?optionalContent.get("P").name:null,expression:null});case 29:if(!(optionalContentGroups instanceof _primitives.Ref)){_context9.next=31;break;}return _context9.abrupt("return",{type:optionalContentType,id:optionalContentGroups.toString()});case 31:return _context9.abrupt("return",null);case 32:case"end":return _context9.stop();}},_callee8,this);}));function parseMarkedContentProps(_x14,_x15){return _parseMarkedContentProps.apply(this,arguments);}return parseMarkedContentProps;}()},{key:"getOperatorList",value:function getOperatorList(_ref8){var _this7=this;var stream=_ref8.stream,task=_ref8.task,resources=_ref8.resources,operatorList=_ref8.operatorList,_ref8$initialState=_ref8.initialState,initialState=_ref8$initialState===void 0?null:_ref8$initialState,_ref8$fallbackFontDic=_ref8.fallbackFontDict,fallbackFontDict=_ref8$fallbackFontDic===void 0?null:_ref8$fallbackFontDic;resources||(resources=_primitives.Dict.empty);initialState||(initialState=new EvalState());if(!operatorList){throw new Error('getOperatorList: missing "operatorList" parameter');}var self=this;var xref=this.xref;var parsingText=false;var localImageCache=new _image_utils.LocalImageCache();var localColorSpaceCache=new _image_utils.LocalColorSpaceCache();var localGStateCache=new _image_utils.LocalGStateCache();var localTilingPatternCache=new _image_utils.LocalTilingPatternCache();var localShadingPatternCache=new Map();var xobjs=resources.get("XObject")||_primitives.Dict.empty;var patterns=resources.get("Pattern")||_primitives.Dict.empty;var stateManager=new StateManager(initialState);var preprocessor=new EvaluatorPreprocessor(stream,xref,stateManager);var timeSlotManager=new TimeSlotManager();function closePendingRestoreOPS(argument){for(var i=0,ii=preprocessor.savedStatesDepth;i<ii;i++){operatorList.addOp(_util.OPS.restore,[]);}}return new Promise(function promiseBody(resolve,reject){var next=function next(promise){Promise.all([promise,operatorList.ready]).then(function(){try{promiseBody(resolve,reject);}catch(ex){reject(ex);}},reject);};task.ensureNotTerminated();timeSlotManager.reset();var operation={};var stop,i,ii,cs,name,isValidName;while(!(stop=timeSlotManager.check())){operation.args=null;if(!preprocessor.read(operation)){break;}var args=operation.args;var fn=operation.fn;switch(fn|0){case _util.OPS.paintXObject:isValidName=args[0]instanceof _primitives.Name;name=args[0].name;if(isValidName){var localImage=localImageCache.getByName(name);if(localImage){operatorList.addImageOps(localImage.fn,localImage.args,localImage.optionalContent);incrementCachedImageMaskCount(localImage);args=null;continue;}}next(new Promise(function(resolveXObject,rejectXObject){if(!isValidName){throw new _util.FormatError("XObject must be referred to by name.");}var xobj=xobjs.getRaw(name);if(xobj instanceof _primitives.Ref){var _localImage=localImageCache.getByRef(xobj)||self._regionalImageCache.getByRef(xobj);if(_localImage){operatorList.addImageOps(_localImage.fn,_localImage.args,_localImage.optionalContent);incrementCachedImageMaskCount(_localImage);resolveXObject();return;}var globalImage=self.globalImageCache.getData(xobj,self.pageIndex);if(globalImage){operatorList.addDependency(globalImage.objId);operatorList.addImageOps(globalImage.fn,globalImage.args,globalImage.optionalContent);resolveXObject();return;}xobj=xref.fetch(xobj);}if(!(xobj instanceof _base_stream.BaseStream)){throw new _util.FormatError("XObject should be a stream");}var type=xobj.dict.get("Subtype");if(!(type instanceof _primitives.Name)){throw new _util.FormatError("XObject should have a Name subtype");}if(type.name==="Form"){stateManager.save();self.buildFormXObject(resources,xobj,null,operatorList,task,stateManager.state.clone(),localColorSpaceCache).then(function(){stateManager.restore();resolveXObject();},rejectXObject);return;}else if(type.name==="Image"){self.buildPaintImageXObject({resources:resources,image:xobj,operatorList:operatorList,cacheKey:name,localImageCache:localImageCache,localColorSpaceCache:localColorSpaceCache}).then(resolveXObject,rejectXObject);return;}else if(type.name==="PS"){(0,_util.info)("Ignored XObject subtype PS");}else{throw new _util.FormatError("Unhandled XObject subtype ".concat(type.name));}resolveXObject();}).catch(function(reason){if(reason instanceof _util.AbortException){return;}if(self.options.ignoreErrors){(0,_util.warn)("getOperatorList - ignoring XObject: \"".concat(reason,"\"."));return;}throw reason;}));return;case _util.OPS.setFont:var fontSize=args[1];next(self.handleSetFont(resources,args,null,operatorList,task,stateManager.state,fallbackFontDict).then(function(loadedName){operatorList.addDependency(loadedName);operatorList.addOp(_util.OPS.setFont,[loadedName,fontSize]);}));return;case _util.OPS.beginText:parsingText=true;break;case _util.OPS.endText:parsingText=false;break;case _util.OPS.endInlineImage:var cacheKey=args[0].cacheKey;if(cacheKey){var _localImage2=localImageCache.getByName(cacheKey);if(_localImage2){operatorList.addImageOps(_localImage2.fn,_localImage2.args,_localImage2.optionalContent);incrementCachedImageMaskCount(_localImage2);args=null;continue;}}next(self.buildPaintImageXObject({resources:resources,image:args[0],isInline:true,operatorList:operatorList,cacheKey:cacheKey,localImageCache:localImageCache,localColorSpaceCache:localColorSpaceCache}));return;case _util.OPS.showText:if(!stateManager.state.font){self.ensureStateFont(stateManager.state);continue;}args[0]=self.handleText(args[0],stateManager.state);break;case _util.OPS.showSpacedText:if(!stateManager.state.font){self.ensureStateFont(stateManager.state);continue;}var combinedGlyphs=[];var state=stateManager.state;var _iterator9=_createForOfIteratorHelper(args[0]),_step9;try{for(_iterator9.s();!(_step9=_iterator9.n()).done;){var arrItem=_step9.value;if(typeof arrItem==="string"){var _combinedGlyphs;(_combinedGlyphs=combinedGlyphs).push.apply(_combinedGlyphs,_toConsumableArray(self.handleText(arrItem,state)));}else if(typeof arrItem==="number"){combinedGlyphs.push(arrItem);}}}catch(err){_iterator9.e(err);}finally{_iterator9.f();}args[0]=combinedGlyphs;fn=_util.OPS.showText;break;case _util.OPS.nextLineShowText:if(!stateManager.state.font){self.ensureStateFont(stateManager.state);continue;}operatorList.addOp(_util.OPS.nextLine);args[0]=self.handleText(args[0],stateManager.state);fn=_util.OPS.showText;break;case _util.OPS.nextLineSetSpacingShowText:if(!stateManager.state.font){self.ensureStateFont(stateManager.state);continue;}operatorList.addOp(_util.OPS.nextLine);operatorList.addOp(_util.OPS.setWordSpacing,[args.shift()]);operatorList.addOp(_util.OPS.setCharSpacing,[args.shift()]);args[0]=self.handleText(args[0],stateManager.state);fn=_util.OPS.showText;break;case _util.OPS.setTextRenderingMode:stateManager.state.textRenderingMode=args[0];break;case _util.OPS.setFillColorSpace:{var cachedColorSpace=_colorspace.ColorSpace.getCached(args[0],xref,localColorSpaceCache);if(cachedColorSpace){stateManager.state.fillColorSpace=cachedColorSpace;continue;}next(self.parseColorSpace({cs:args[0],resources:resources,localColorSpaceCache:localColorSpaceCache}).then(function(colorSpace){if(colorSpace){stateManager.state.fillColorSpace=colorSpace;}}));return;}case _util.OPS.setStrokeColorSpace:{var _cachedColorSpace=_colorspace.ColorSpace.getCached(args[0],xref,localColorSpaceCache);if(_cachedColorSpace){stateManager.state.strokeColorSpace=_cachedColorSpace;continue;}next(self.parseColorSpace({cs:args[0],resources:resources,localColorSpaceCache:localColorSpaceCache}).then(function(colorSpace){if(colorSpace){stateManager.state.strokeColorSpace=colorSpace;}}));return;}case _util.OPS.setFillColor:cs=stateManager.state.fillColorSpace;args=cs.getRgb(args,0);fn=_util.OPS.setFillRGBColor;break;case _util.OPS.setStrokeColor:cs=stateManager.state.strokeColorSpace;args=cs.getRgb(args,0);fn=_util.OPS.setStrokeRGBColor;break;case _util.OPS.setFillGray:stateManager.state.fillColorSpace=_colorspace.ColorSpace.singletons.gray;args=_colorspace.ColorSpace.singletons.gray.getRgb(args,0);fn=_util.OPS.setFillRGBColor;break;case _util.OPS.setStrokeGray:stateManager.state.strokeColorSpace=_colorspace.ColorSpace.singletons.gray;args=_colorspace.ColorSpace.singletons.gray.getRgb(args,0);fn=_util.OPS.setStrokeRGBColor;break;case _util.OPS.setFillCMYKColor:stateManager.state.fillColorSpace=_colorspace.ColorSpace.singletons.cmyk;args=_colorspace.ColorSpace.singletons.cmyk.getRgb(args,0);fn=_util.OPS.setFillRGBColor;break;case _util.OPS.setStrokeCMYKColor:stateManager.state.strokeColorSpace=_colorspace.ColorSpace.singletons.cmyk;args=_colorspace.ColorSpace.singletons.cmyk.getRgb(args,0);fn=_util.OPS.setStrokeRGBColor;break;case _util.OPS.setFillRGBColor:stateManager.state.fillColorSpace=_colorspace.ColorSpace.singletons.rgb;args=_colorspace.ColorSpace.singletons.rgb.getRgb(args,0);break;case _util.OPS.setStrokeRGBColor:stateManager.state.strokeColorSpace=_colorspace.ColorSpace.singletons.rgb;args=_colorspace.ColorSpace.singletons.rgb.getRgb(args,0);break;case _util.OPS.setFillColorN:cs=stateManager.state.fillColorSpace;if(cs.name==="Pattern"){next(self.handleColorN(operatorList,_util.OPS.setFillColorN,args,cs,patterns,resources,task,localColorSpaceCache,localTilingPatternCache,localShadingPatternCache));return;}args=cs.getRgb(args,0);fn=_util.OPS.setFillRGBColor;break;case _util.OPS.setStrokeColorN:cs=stateManager.state.strokeColorSpace;if(cs.name==="Pattern"){next(self.handleColorN(operatorList,_util.OPS.setStrokeColorN,args,cs,patterns,resources,task,localColorSpaceCache,localTilingPatternCache,localShadingPatternCache));return;}args=cs.getRgb(args,0);fn=_util.OPS.setStrokeRGBColor;break;case _util.OPS.shadingFill:var shadingRes=resources.get("Shading");if(!shadingRes){throw new _util.FormatError("No shading resource found");}var shading=shadingRes.get(args[0].name);if(!shading){throw new _util.FormatError("No shading object found");}var patternId=self.parseShading({shading:shading,resources:resources,localColorSpaceCache:localColorSpaceCache,localShadingPatternCache:localShadingPatternCache});args=[patternId];fn=_util.OPS.shadingFill;break;case _util.OPS.setGState:isValidName=args[0]instanceof _primitives.Name;name=args[0].name;if(isValidName){var localGStateObj=localGStateCache.getByName(name);if(localGStateObj){if(localGStateObj.length>0){operatorList.addOp(_util.OPS.setGState,[localGStateObj]);}args=null;continue;}}next(new Promise(function(resolveGState,rejectGState){if(!isValidName){throw new _util.FormatError("GState must be referred to by name.");}var extGState=resources.get("ExtGState");if(!(extGState instanceof _primitives.Dict)){throw new _util.FormatError("ExtGState should be a dictionary.");}var gState=extGState.get(name);if(!(gState instanceof _primitives.Dict)){throw new _util.FormatError("GState should be a dictionary.");}self.setGState({resources:resources,gState:gState,operatorList:operatorList,cacheKey:name,task:task,stateManager:stateManager,localGStateCache:localGStateCache,localColorSpaceCache:localColorSpaceCache}).then(resolveGState,rejectGState);}).catch(function(reason){if(reason instanceof _util.AbortException){return;}if(self.options.ignoreErrors){(0,_util.warn)("getOperatorList - ignoring ExtGState: \"".concat(reason,"\"."));return;}throw reason;}));return;case _util.OPS.moveTo:case _util.OPS.lineTo:case _util.OPS.curveTo:case _util.OPS.curveTo2:case _util.OPS.curveTo3:case _util.OPS.closePath:case _util.OPS.rectangle:self.buildPath(operatorList,fn,args,parsingText);continue;case _util.OPS.markPoint:case _util.OPS.markPointProps:case _util.OPS.beginCompat:case _util.OPS.endCompat:continue;case _util.OPS.beginMarkedContentProps:if(!(args[0]instanceof _primitives.Name)){(0,_util.warn)("Expected name for beginMarkedContentProps arg0=".concat(args[0]));continue;}if(args[0].name==="OC"){next(self.parseMarkedContentProps(args[1],resources).then(function(data){operatorList.addOp(_util.OPS.beginMarkedContentProps,["OC",data]);}).catch(function(reason){if(reason instanceof _util.AbortException){return;}if(self.options.ignoreErrors){(0,_util.warn)("getOperatorList - ignoring beginMarkedContentProps: \"".concat(reason,"\"."));return;}throw reason;}));return;}args=[args[0].name,args[1]instanceof _primitives.Dict?args[1].get("MCID"):null];break;case _util.OPS.beginMarkedContent:case _util.OPS.endMarkedContent:default:if(args!==null){for(i=0,ii=args.length;i<ii;i++){if(args[i]instanceof _primitives.Dict){break;}}if(i<ii){(0,_util.warn)("getOperatorList - ignoring operator: "+fn);continue;}}}operatorList.addOp(fn,args);}if(stop){next(deferred);return;}closePendingRestoreOPS();resolve();}).catch(function(reason){if(reason instanceof _util.AbortException){return;}if(_this7.options.ignoreErrors){(0,_util.warn)("getOperatorList - ignoring errors during \"".concat(task.name,"\" ")+"task: \"".concat(reason,"\"."));closePendingRestoreOPS();return;}throw reason;});}},{key:"getTextContent",value:function getTextContent(_ref9){var _this8=this;var stream=_ref9.stream,task=_ref9.task,resources=_ref9.resources,_ref9$stateManager=_ref9.stateManager,stateManager=_ref9$stateManager===void 0?null:_ref9$stateManager,_ref9$includeMarkedCo=_ref9.includeMarkedContent,includeMarkedContent=_ref9$includeMarkedCo===void 0?false:_ref9$includeMarkedCo,sink=_ref9.sink,_ref9$seenStyles=_ref9.seenStyles,seenStyles=_ref9$seenStyles===void 0?new Set():_ref9$seenStyles,viewBox=_ref9.viewBox,_ref9$markedContentDa=_ref9.markedContentData,markedContentData=_ref9$markedContentDa===void 0?null:_ref9$markedContentDa,_ref9$disableNormaliz=_ref9.disableNormalization,disableNormalization=_ref9$disableNormaliz===void 0?false:_ref9$disableNormaliz;resources||(resources=_primitives.Dict.empty);stateManager||(stateManager=new StateManager(new TextState()));if(includeMarkedContent){markedContentData||(markedContentData={level:0});}var textContent={items:[],styles:Object.create(null)};var textContentItem={initialized:false,str:[],totalWidth:0,totalHeight:0,width:0,height:0,vertical:false,prevTransform:null,textAdvanceScale:0,spaceInFlowMin:0,spaceInFlowMax:0,trackingSpaceMin:Infinity,negativeSpaceMax:-Infinity,notASpace:-Infinity,transform:null,fontName:null,hasEOL:false};var twoLastChars=[" "," "];var twoLastCharsPos=0;function saveLastChar(char){var nextPos=(twoLastCharsPos+1)%2;var ret=twoLastChars[twoLastCharsPos]!==" "&&twoLastChars[nextPos]===" ";twoLastChars[twoLastCharsPos]=char;twoLastCharsPos=nextPos;return ret;}function shouldAddWhitepsace(){return twoLastChars[twoLastCharsPos]!==" "&&twoLastChars[(twoLastCharsPos+1)%2]===" ";}function resetLastChars(){twoLastChars[0]=twoLastChars[1]=" ";twoLastCharsPos=0;}var TRACKING_SPACE_FACTOR=0.102;var NOT_A_SPACE_FACTOR=0.03;var NEGATIVE_SPACE_FACTOR=-0.2;var SPACE_IN_FLOW_MIN_FACTOR=0.102;var SPACE_IN_FLOW_MAX_FACTOR=0.6;var VERTICAL_SHIFT_RATIO=0.25;var self=this;var xref=this.xref;var showSpacedTextBuffer=[];var xobjs=null;var emptyXObjectCache=new _image_utils.LocalImageCache();var emptyGStateCache=new _image_utils.LocalGStateCache();var preprocessor=new EvaluatorPreprocessor(stream,xref,stateManager);var textState;function pushWhitespace(_ref10){var _ref10$width=_ref10.width,width=_ref10$width===void 0?0:_ref10$width,_ref10$height=_ref10.height,height=_ref10$height===void 0?0:_ref10$height,_ref10$transform=_ref10.transform,transform=_ref10$transform===void 0?textContentItem.prevTransform:_ref10$transform,_ref10$fontName=_ref10.fontName,fontName=_ref10$fontName===void 0?textContentItem.fontName:_ref10$fontName;textContent.items.push({str:" ",dir:"ltr",width:width,height:height,transform:transform,fontName:fontName,hasEOL:false});}function getCurrentTextTransform(){var font=textState.font;var tsm=[textState.fontSize*textState.textHScale,0,0,textState.fontSize,0,textState.textRise];if(font.isType3Font&&(textState.fontSize<=1||font.isCharBBox)&&!(0,_util.isArrayEqual)(textState.fontMatrix,_util.FONT_IDENTITY_MATRIX)){var glyphHeight=font.bbox[3]-font.bbox[1];if(glyphHeight>0){tsm[3]*=glyphHeight*textState.fontMatrix[3];}}return _util.Util.transform(textState.ctm,_util.Util.transform(textState.textMatrix,tsm));}function ensureTextContentItem(){if(textContentItem.initialized){return textContentItem;}var _textState=textState,font=_textState.font,loadedName=_textState.loadedName;if(!seenStyles.has(loadedName)){seenStyles.add(loadedName);textContent.styles[loadedName]={fontFamily:font.fallbackName,ascent:font.ascent,descent:font.descent,vertical:font.vertical};}textContentItem.fontName=loadedName;var trm=textContentItem.transform=getCurrentTextTransform();if(!font.vertical){textContentItem.width=textContentItem.totalWidth=0;textContentItem.height=textContentItem.totalHeight=Math.hypot(trm[2],trm[3]);textContentItem.vertical=false;}else{textContentItem.width=textContentItem.totalWidth=Math.hypot(trm[0],trm[1]);textContentItem.height=textContentItem.totalHeight=0;textContentItem.vertical=true;}var scaleLineX=Math.hypot(textState.textLineMatrix[0],textState.textLineMatrix[1]);var scaleCtmX=Math.hypot(textState.ctm[0],textState.ctm[1]);textContentItem.textAdvanceScale=scaleCtmX*scaleLineX;var _textState2=textState,fontSize=_textState2.fontSize;textContentItem.trackingSpaceMin=fontSize*TRACKING_SPACE_FACTOR;textContentItem.notASpace=fontSize*NOT_A_SPACE_FACTOR;textContentItem.negativeSpaceMax=fontSize*NEGATIVE_SPACE_FACTOR;textContentItem.spaceInFlowMin=fontSize*SPACE_IN_FLOW_MIN_FACTOR;textContentItem.spaceInFlowMax=fontSize*SPACE_IN_FLOW_MAX_FACTOR;textContentItem.hasEOL=false;textContentItem.initialized=true;return textContentItem;}function updateAdvanceScale(){if(!textContentItem.initialized){return;}var scaleLineX=Math.hypot(textState.textLineMatrix[0],textState.textLineMatrix[1]);var scaleCtmX=Math.hypot(textState.ctm[0],textState.ctm[1]);var scaleFactor=scaleCtmX*scaleLineX;if(scaleFactor===textContentItem.textAdvanceScale){return;}if(!textContentItem.vertical){textContentItem.totalWidth+=textContentItem.width*textContentItem.textAdvanceScale;textContentItem.width=0;}else{textContentItem.totalHeight+=textContentItem.height*textContentItem.textAdvanceScale;textContentItem.height=0;}textContentItem.textAdvanceScale=scaleFactor;}function runBidiTransform(textChunk){var text=textChunk.str.join("");if(!disableNormalization){text=(0,_util.normalizeUnicode)(text);}var bidiResult=(0,_bidi.bidi)(text,-1,textChunk.vertical);return{str:bidiResult.str,dir:bidiResult.dir,width:Math.abs(textChunk.totalWidth),height:Math.abs(textChunk.totalHeight),transform:textChunk.transform,fontName:textChunk.fontName,hasEOL:textChunk.hasEOL};}function handleSetFont(fontName,fontRef){return self.loadFont(fontName,fontRef,resources).then(function(translated){if(!translated.font.isType3Font){return translated;}return translated.loadType3Data(self,resources,task).catch(function(){}).then(function(){return translated;});}).then(function(translated){textState.loadedName=translated.loadedName;textState.font=translated.font;textState.fontMatrix=translated.font.fontMatrix||_util.FONT_IDENTITY_MATRIX;});}function applyInverseRotation(x,y,matrix){var scale=Math.hypot(matrix[0],matrix[1]);return[(matrix[0]*x+matrix[1]*y)/scale,(matrix[2]*x+matrix[3]*y)/scale];}function compareWithLastPosition(glyphWidth){var _textState$font;var currentTransform=getCurrentTextTransform();var posX=currentTransform[4];var posY=currentTransform[5];if((_textState$font=textState.font)!==null&&_textState$font!==void 0&&_textState$font.vertical){if(posX<viewBox[0]||posX>viewBox[2]||posY+glyphWidth<viewBox[1]||posY>viewBox[3]){return false;}}else if(posX+glyphWidth<viewBox[0]||posX>viewBox[2]||posY<viewBox[1]||posY>viewBox[3]){return false;}if(!textState.font||!textContentItem.prevTransform){return true;}var lastPosX=textContentItem.prevTransform[4];var lastPosY=textContentItem.prevTransform[5];if(lastPosX===posX&&lastPosY===posY){return true;}var rotate=-1;if(currentTransform[0]&&currentTransform[1]===0&&currentTransform[2]===0){rotate=currentTransform[0]>0?0:180;}else if(currentTransform[1]&&currentTransform[0]===0&&currentTransform[3]===0){rotate=currentTransform[1]>0?90:270;}switch(rotate){case 0:break;case 90:var _ref11=[posY,posX];posX=_ref11[0];posY=_ref11[1];var _ref12=[lastPosY,lastPosX];lastPosX=_ref12[0];lastPosY=_ref12[1];break;case 180:var _ref13=[-posX,-posY,-lastPosX,-lastPosY];posX=_ref13[0];posY=_ref13[1];lastPosX=_ref13[2];lastPosY=_ref13[3];break;case 270:var _ref14=[-posY,-posX];posX=_ref14[0];posY=_ref14[1];var _ref15=[-lastPosY,-lastPosX];lastPosX=_ref15[0];lastPosY=_ref15[1];break;default:var _applyInverseRotation=applyInverseRotation(posX,posY,currentTransform);var _applyInverseRotation2=_slicedToArray(_applyInverseRotation,2);posX=_applyInverseRotation2[0];posY=_applyInverseRotation2[1];var _applyInverseRotation3=applyInverseRotation(lastPosX,lastPosY,textContentItem.prevTransform);var _applyInverseRotation4=_slicedToArray(_applyInverseRotation3,2);lastPosX=_applyInverseRotation4[0];lastPosY=_applyInverseRotation4[1];}if(textState.font.vertical){var _advanceY=(lastPosY-posY)/textContentItem.textAdvanceScale;var _advanceX=posX-lastPosX;var _textOrientation=Math.sign(textContentItem.height);if(_advanceY<_textOrientation*textContentItem.negativeSpaceMax){if(Math.abs(_advanceX)>0.5*textContentItem.width){appendEOL();return true;}resetLastChars();flushTextContentItem();return true;}if(Math.abs(_advanceX)>textContentItem.width){appendEOL();return true;}if(_advanceY<=_textOrientation*textContentItem.notASpace){resetLastChars();}if(_advanceY<=_textOrientation*textContentItem.trackingSpaceMin){if(shouldAddWhitepsace()){resetLastChars();flushTextContentItem();pushWhitespace({height:Math.abs(_advanceY)});}else{textContentItem.height+=_advanceY;}}else if(!addFakeSpaces(_advanceY,textContentItem.prevTransform,_textOrientation)){if(textContentItem.str.length===0){resetLastChars();pushWhitespace({height:Math.abs(_advanceY)});}else{textContentItem.height+=_advanceY;}}if(Math.abs(_advanceX)>textContentItem.width*VERTICAL_SHIFT_RATIO){flushTextContentItem();}return true;}var advanceX=(posX-lastPosX)/textContentItem.textAdvanceScale;var advanceY=posY-lastPosY;var textOrientation=Math.sign(textContentItem.width);if(advanceX<textOrientation*textContentItem.negativeSpaceMax){if(Math.abs(advanceY)>0.5*textContentItem.height){appendEOL();return true;}resetLastChars();flushTextContentItem();return true;}if(Math.abs(advanceY)>textContentItem.height){appendEOL();return true;}if(advanceX<=textOrientation*textContentItem.notASpace){resetLastChars();}if(advanceX<=textOrientation*textContentItem.trackingSpaceMin){if(shouldAddWhitepsace()){resetLastChars();flushTextContentItem();pushWhitespace({width:Math.abs(advanceX)});}else{textContentItem.width+=advanceX;}}else if(!addFakeSpaces(advanceX,textContentItem.prevTransform,textOrientation)){if(textContentItem.str.length===0){resetLastChars();pushWhitespace({width:Math.abs(advanceX)});}else{textContentItem.width+=advanceX;}}if(Math.abs(advanceY)>textContentItem.height*VERTICAL_SHIFT_RATIO){flushTextContentItem();}return true;}function buildTextContentItem(_ref16){var chars=_ref16.chars,extraSpacing=_ref16.extraSpacing;var font=textState.font;if(!chars){var charSpacing=textState.charSpacing+extraSpacing;if(charSpacing){if(!font.vertical){textState.translateTextMatrix(charSpacing*textState.textHScale,0);}else{textState.translateTextMatrix(0,-charSpacing);}}return;}var glyphs=font.charsToGlyphs(chars);var scale=textState.fontMatrix[0]*textState.fontSize;for(var i=0,ii=glyphs.length;i<ii;i++){var glyph=glyphs[i];var category=glyph.category;if(category.isInvisibleFormatMark){continue;}var _charSpacing=textState.charSpacing+(i+1===ii?extraSpacing:0);var glyphWidth=glyph.width;if(font.vertical){glyphWidth=glyph.vmetric?glyph.vmetric[0]:-glyphWidth;}var scaledDim=glyphWidth*scale;if(category.isWhitespace){if(!font.vertical){_charSpacing+=scaledDim+textState.wordSpacing;textState.translateTextMatrix(_charSpacing*textState.textHScale,0);}else{_charSpacing+=-scaledDim+textState.wordSpacing;textState.translateTextMatrix(0,-_charSpacing);}saveLastChar(" ");continue;}if(!category.isZeroWidthDiacritic&&!compareWithLastPosition(scaledDim)){if(!font.vertical){textState.translateTextMatrix(scaledDim*textState.textHScale,0);}else{textState.translateTextMatrix(0,scaledDim);}continue;}var textChunk=ensureTextContentItem();if(category.isZeroWidthDiacritic){scaledDim=0;}if(!font.vertical){scaledDim*=textState.textHScale;textState.translateTextMatrix(scaledDim,0);textChunk.width+=scaledDim;}else{textState.translateTextMatrix(0,scaledDim);scaledDim=Math.abs(scaledDim);textChunk.height+=scaledDim;}if(scaledDim){textChunk.prevTransform=getCurrentTextTransform();}var glyphUnicode=glyph.unicode;if(saveLastChar(glyphUnicode)){textChunk.str.push(" ");}textChunk.str.push(glyphUnicode);if(_charSpacing){if(!font.vertical){textState.translateTextMatrix(_charSpacing*textState.textHScale,0);}else{textState.translateTextMatrix(0,-_charSpacing);}}}}function appendEOL(){resetLastChars();if(textContentItem.initialized){textContentItem.hasEOL=true;flushTextContentItem();}else{textContent.items.push({str:"",dir:"ltr",width:0,height:0,transform:getCurrentTextTransform(),fontName:textState.loadedName,hasEOL:true});}}function addFakeSpaces(width,transf,textOrientation){if(textOrientation*textContentItem.spaceInFlowMin<=width&&width<=textOrientation*textContentItem.spaceInFlowMax){if(textContentItem.initialized){resetLastChars();textContentItem.str.push(" ");}return false;}var fontName=textContentItem.fontName;var height=0;if(textContentItem.vertical){height=width;width=0;}flushTextContentItem();resetLastChars();pushWhitespace({width:Math.abs(width),height:Math.abs(height),transform:transf||getCurrentTextTransform(),fontName:fontName});return true;}function flushTextContentItem(){if(!textContentItem.initialized||!textContentItem.str){return;}if(!textContentItem.vertical){textContentItem.totalWidth+=textContentItem.width*textContentItem.textAdvanceScale;}else{textContentItem.totalHeight+=textContentItem.height*textContentItem.textAdvanceScale;}textContent.items.push(runBidiTransform(textContentItem));textContentItem.initialized=false;textContentItem.str.length=0;}function enqueueChunk(){var batch=arguments.length>0&&arguments[0]!==undefined?arguments[0]:false;var length=textContent.items.length;if(length===0){return;}if(batch&&length<TEXT_CHUNK_BATCH_SIZE){return;}sink.enqueue(textContent,length);textContent.items=[];textContent.styles=Object.create(null);}var timeSlotManager=new TimeSlotManager();return new Promise(function promiseBody(resolve,reject){var next=function next(promise){enqueueChunk(true);Promise.all([promise,sink.ready]).then(function(){try{promiseBody(resolve,reject);}catch(ex){reject(ex);}},reject);};task.ensureNotTerminated();timeSlotManager.reset();var operation={};var stop,args=[];while(!(stop=timeSlotManager.check())){args.length=0;operation.args=args;if(!preprocessor.read(operation)){break;}var previousState=textState;textState=stateManager.state;var fn=operation.fn;args=operation.args;switch(fn|0){case _util.OPS.setFont:var fontNameArg=args[0].name,fontSizeArg=args[1];if(textState.font&&fontNameArg===textState.fontName&&fontSizeArg===textState.fontSize){break;}flushTextContentItem();textState.fontName=fontNameArg;textState.fontSize=fontSizeArg;next(handleSetFont(fontNameArg,null));return;case _util.OPS.setTextRise:textState.textRise=args[0];break;case _util.OPS.setHScale:textState.textHScale=args[0]/100;break;case _util.OPS.setLeading:textState.leading=args[0];break;case _util.OPS.moveText:textState.translateTextLineMatrix(args[0],args[1]);textState.textMatrix=textState.textLineMatrix.slice();break;case _util.OPS.setLeadingMoveText:textState.leading=-args[1];textState.translateTextLineMatrix(args[0],args[1]);textState.textMatrix=textState.textLineMatrix.slice();break;case _util.OPS.nextLine:textState.carriageReturn();break;case _util.OPS.setTextMatrix:textState.setTextMatrix(args[0],args[1],args[2],args[3],args[4],args[5]);textState.setTextLineMatrix(args[0],args[1],args[2],args[3],args[4],args[5]);updateAdvanceScale();break;case _util.OPS.setCharSpacing:textState.charSpacing=args[0];break;case _util.OPS.setWordSpacing:textState.wordSpacing=args[0];break;case _util.OPS.beginText:textState.textMatrix=_util.IDENTITY_MATRIX.slice();textState.textLineMatrix=_util.IDENTITY_MATRIX.slice();break;case _util.OPS.showSpacedText:if(!stateManager.state.font){self.ensureStateFont(stateManager.state);continue;}var spaceFactor=(textState.font.vertical?1:-1)*textState.fontSize/1000;var elements=args[0];for(var i=0,ii=elements.length;i<ii;i++){var item=elements[i];if(typeof item==="string"){showSpacedTextBuffer.push(item);}else if(typeof item==="number"&&item!==0){var str=showSpacedTextBuffer.join("");showSpacedTextBuffer.length=0;buildTextContentItem({chars:str,extraSpacing:item*spaceFactor});}}if(showSpacedTextBuffer.length>0){var _str=showSpacedTextBuffer.join("");showSpacedTextBuffer.length=0;buildTextContentItem({chars:_str,extraSpacing:0});}break;case _util.OPS.showText:if(!stateManager.state.font){self.ensureStateFont(stateManager.state);continue;}buildTextContentItem({chars:args[0],extraSpacing:0});break;case _util.OPS.nextLineShowText:if(!stateManager.state.font){self.ensureStateFont(stateManager.state);continue;}textState.carriageReturn();buildTextContentItem({chars:args[0],extraSpacing:0});break;case _util.OPS.nextLineSetSpacingShowText:if(!stateManager.state.font){self.ensureStateFont(stateManager.state);continue;}textState.wordSpacing=args[0];textState.charSpacing=args[1];textState.carriageReturn();buildTextContentItem({chars:args[2],extraSpacing:0});break;case _util.OPS.paintXObject:flushTextContentItem();if(!xobjs){xobjs=resources.get("XObject")||_primitives.Dict.empty;}var isValidName=args[0]instanceof _primitives.Name;var name=args[0].name;if(isValidName&&emptyXObjectCache.getByName(name)){break;}next(new Promise(function(resolveXObject,rejectXObject){if(!isValidName){throw new _util.FormatError("XObject must be referred to by name.");}var xobj=xobjs.getRaw(name);if(xobj instanceof _primitives.Ref){if(emptyXObjectCache.getByRef(xobj)){resolveXObject();return;}var globalImage=self.globalImageCache.getData(xobj,self.pageIndex);if(globalImage){resolveXObject();return;}xobj=xref.fetch(xobj);}if(!(xobj instanceof _base_stream.BaseStream)){throw new _util.FormatError("XObject should be a stream");}var type=xobj.dict.get("Subtype");if(!(type instanceof _primitives.Name)){throw new _util.FormatError("XObject should have a Name subtype");}if(type.name!=="Form"){emptyXObjectCache.set(name,xobj.dict.objId,true);resolveXObject();return;}var currentState=stateManager.state.clone();var xObjStateManager=new StateManager(currentState);var matrix=xobj.dict.getArray("Matrix");if(Array.isArray(matrix)&&matrix.length===6){xObjStateManager.transform(matrix);}enqueueChunk();var sinkWrapper={enqueueInvoked:false,enqueue:function enqueue(chunk,size){this.enqueueInvoked=true;sink.enqueue(chunk,size);},get desiredSize(){return sink.desiredSize;},get ready(){return sink.ready;}};self.getTextContent({stream:xobj,task:task,resources:xobj.dict.get("Resources")||resources,stateManager:xObjStateManager,includeMarkedContent:includeMarkedContent,sink:sinkWrapper,seenStyles:seenStyles,viewBox:viewBox,markedContentData:markedContentData,disableNormalization:disableNormalization}).then(function(){if(!sinkWrapper.enqueueInvoked){emptyXObjectCache.set(name,xobj.dict.objId,true);}resolveXObject();},rejectXObject);}).catch(function(reason){if(reason instanceof _util.AbortException){return;}if(self.options.ignoreErrors){(0,_util.warn)("getTextContent - ignoring XObject: \"".concat(reason,"\"."));return;}throw reason;}));return;case _util.OPS.setGState:isValidName=args[0]instanceof _primitives.Name;name=args[0].name;if(isValidName&&emptyGStateCache.getByName(name)){break;}next(new Promise(function(resolveGState,rejectGState){if(!isValidName){throw new _util.FormatError("GState must be referred to by name.");}var extGState=resources.get("ExtGState");if(!(extGState instanceof _primitives.Dict)){throw new _util.FormatError("ExtGState should be a dictionary.");}var gState=extGState.get(name);if(!(gState instanceof _primitives.Dict)){throw new _util.FormatError("GState should be a dictionary.");}var gStateFont=gState.get("Font");if(!gStateFont){emptyGStateCache.set(name,gState.objId,true);resolveGState();return;}flushTextContentItem();textState.fontName=null;textState.fontSize=gStateFont[1];handleSetFont(null,gStateFont[0]).then(resolveGState,rejectGState);}).catch(function(reason){if(reason instanceof _util.AbortException){return;}if(self.options.ignoreErrors){(0,_util.warn)("getTextContent - ignoring ExtGState: \"".concat(reason,"\"."));return;}throw reason;}));return;case _util.OPS.beginMarkedContent:flushTextContentItem();if(includeMarkedContent){markedContentData.level++;textContent.items.push({type:"beginMarkedContent",tag:args[0]instanceof _primitives.Name?args[0].name:null});}break;case _util.OPS.beginMarkedContentProps:flushTextContentItem();if(includeMarkedContent){markedContentData.level++;var mcid=null;if(args[1]instanceof _primitives.Dict){mcid=args[1].get("MCID");}textContent.items.push({type:"beginMarkedContentProps",id:Number.isInteger(mcid)?"".concat(self.idFactory.getPageObjId(),"_mc").concat(mcid):null,tag:args[0]instanceof _primitives.Name?args[0].name:null});}break;case _util.OPS.endMarkedContent:flushTextContentItem();if(includeMarkedContent){if(markedContentData.level===0){break;}markedContentData.level--;textContent.items.push({type:"endMarkedContent"});}break;case _util.OPS.restore:if(previousState&&(previousState.font!==textState.font||previousState.fontSize!==textState.fontSize||previousState.fontName!==textState.fontName)){flushTextContentItem();}break;}if(textContent.items.length>=sink.desiredSize){stop=true;break;}}if(stop){next(deferred);return;}flushTextContentItem();enqueueChunk();resolve();}).catch(function(reason){if(reason instanceof _util.AbortException){return;}if(_this8.options.ignoreErrors){(0,_util.warn)("getTextContent - ignoring errors during \"".concat(task.name,"\" ")+"task: \"".concat(reason,"\"."));flushTextContentItem();enqueueChunk();return;}throw reason;});}},{key:"extractDataStructures",value:function extractDataStructures(dict,baseDict,properties){var _this9=this;var xref=this.xref;var cidToGidBytes;var toUnicodePromise=this.readToUnicode(properties.toUnicode||dict.get("ToUnicode")||baseDict.get("ToUnicode"));if(properties.composite){var cidSystemInfo=dict.get("CIDSystemInfo");if(cidSystemInfo instanceof _primitives.Dict){properties.cidSystemInfo={registry:(0,_util.stringToPDFString)(cidSystemInfo.get("Registry")),ordering:(0,_util.stringToPDFString)(cidSystemInfo.get("Ordering")),supplement:cidSystemInfo.get("Supplement")};}try{var cidToGidMap=dict.get("CIDToGIDMap");if(cidToGidMap instanceof _base_stream.BaseStream){cidToGidBytes=cidToGidMap.getBytes();}}catch(ex){if(!this.options.ignoreErrors){throw ex;}(0,_util.warn)("extractDataStructures - ignoring CIDToGIDMap data: \"".concat(ex,"\"."));}}var differences=[];var baseEncodingName=null;var encoding;if(dict.has("Encoding")){encoding=dict.get("Encoding");if(encoding instanceof _primitives.Dict){baseEncodingName=encoding.get("BaseEncoding");baseEncodingName=baseEncodingName instanceof _primitives.Name?baseEncodingName.name:null;if(encoding.has("Differences")){var diffEncoding=encoding.get("Differences");var index=0;var _iterator10=_createForOfIteratorHelper(diffEncoding),_step10;try{for(_iterator10.s();!(_step10=_iterator10.n()).done;){var entry=_step10.value;var data=xref.fetchIfRef(entry);if(typeof data==="number"){index=data;}else if(data instanceof _primitives.Name){differences[index++]=data.name;}else{throw new _util.FormatError("Invalid entry in 'Differences' array: ".concat(data));}}}catch(err){_iterator10.e(err);}finally{_iterator10.f();}}}else if(encoding instanceof _primitives.Name){baseEncodingName=encoding.name;}else{var msg="Encoding is not a Name nor a Dict";if(!this.options.ignoreErrors){throw new _util.FormatError(msg);}(0,_util.warn)(msg);}if(baseEncodingName!=="MacRomanEncoding"&&baseEncodingName!=="MacExpertEncoding"&&baseEncodingName!=="WinAnsiEncoding"){baseEncodingName=null;}}var nonEmbeddedFont=!properties.file||properties.isInternalFont,isSymbolsFontName=(0,_standard_fonts.getSymbolsFonts)()[properties.name];if(baseEncodingName&&nonEmbeddedFont&&isSymbolsFontName){baseEncodingName=null;}if(baseEncodingName){properties.defaultEncoding=(0,_encodings.getEncoding)(baseEncodingName);}else{var isSymbolicFont=!!(properties.flags&_fonts_utils.FontFlags.Symbolic);var isNonsymbolicFont=!!(properties.flags&_fonts_utils.FontFlags.Nonsymbolic);encoding=_encodings.StandardEncoding;if(properties.type==="TrueType"&&!isNonsymbolicFont){encoding=_encodings.WinAnsiEncoding;}if(isSymbolicFont||isSymbolsFontName){encoding=_encodings.MacRomanEncoding;if(nonEmbeddedFont){if(/Symbol/i.test(properties.name)){encoding=_encodings.SymbolSetEncoding;}else if(/Dingbats/i.test(properties.name)){encoding=_encodings.ZapfDingbatsEncoding;}else if(/Wingdings/i.test(properties.name)){encoding=_encodings.WinAnsiEncoding;}}}properties.defaultEncoding=encoding;}properties.differences=differences;properties.baseEncodingName=baseEncodingName;properties.hasEncoding=!!baseEncodingName||differences.length>0;properties.dict=dict;return toUnicodePromise.then(function(readToUnicode){properties.toUnicode=readToUnicode;return _this9.buildToUnicode(properties);}).then(function(builtToUnicode){properties.toUnicode=builtToUnicode;if(cidToGidBytes){properties.cidToGidMap=_this9.readCidToGidMap(cidToGidBytes,builtToUnicode);}return properties;});}},{key:"_simpleFontToUnicode",value:function _simpleFontToUnicode(properties){var forceGlyphs=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;(0,_util.assert)(!properties.composite,"Must be a simple font.");var toUnicode=[];var encoding=properties.defaultEncoding.slice();var baseEncodingName=properties.baseEncodingName;var differences=properties.differences;for(var charcode in differences){var glyphName=differences[charcode];if(glyphName===".notdef"){continue;}encoding[charcode]=glyphName;}var glyphsUnicodeMap=(0,_glyphlist.getGlyphsUnicode)();for(var _charcode in encoding){var _glyphName=encoding[_charcode];if(_glyphName===""){continue;}var unicode=glyphsUnicodeMap[_glyphName];if(unicode!==undefined){toUnicode[_charcode]=String.fromCharCode(unicode);continue;}var code=0;switch(_glyphName[0]){case"G":if(_glyphName.length===3){code=parseInt(_glyphName.substring(1),16);}break;case"g":if(_glyphName.length===5){code=parseInt(_glyphName.substring(1),16);}break;case"C":case"c":if(_glyphName.length>=3&&_glyphName.length<=4){var codeStr=_glyphName.substring(1);if(forceGlyphs){code=parseInt(codeStr,16);break;}code=+codeStr;if(Number.isNaN(code)&&Number.isInteger(parseInt(codeStr,16))){return this._simpleFontToUnicode(properties,true);}}break;case"u":unicode=(0,_unicode.getUnicodeForGlyph)(_glyphName,glyphsUnicodeMap);if(unicode!==-1){code=unicode;}break;default:switch(_glyphName){case"f_h":case"f_t":case"T_h":toUnicode[_charcode]=_glyphName.replaceAll("_","");continue;}break;}if(code>0&&code<=0x10ffff&&Number.isInteger(code)){if(baseEncodingName&&code===+_charcode){var baseEncoding=(0,_encodings.getEncoding)(baseEncodingName);if(baseEncoding&&(_glyphName=baseEncoding[_charcode])){toUnicode[_charcode]=String.fromCharCode(glyphsUnicodeMap[_glyphName]);continue;}}toUnicode[_charcode]=String.fromCodePoint(code);}}return toUnicode;}},{key:"buildToUnicode",value:function(){var _buildToUnicode=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee9(properties){var _properties$toUnicode;var _properties$cidSystem,registry,ordering,ucs2CMapName,ucs2CMap,toUnicode,buf;return _regeneratorRuntime().wrap(function _callee9$(_context10){while(1)switch(_context10.prev=_context10.next){case 0:properties.hasIncludedToUnicodeMap=((_properties$toUnicode=properties.toUnicode)===null||_properties$toUnicode===void 0?void 0:_properties$toUnicode.length)>0;if(!properties.hasIncludedToUnicodeMap){_context10.next=4;break;}if(!properties.composite&&properties.hasEncoding){properties.fallbackToUnicode=this._simpleFontToUnicode(properties);}return _context10.abrupt("return",properties.toUnicode);case 4:if(properties.composite){_context10.next=6;break;}return _context10.abrupt("return",new _to_unicode_map.ToUnicodeMap(this._simpleFontToUnicode(properties)));case 6:if(!(properties.composite&&(properties.cMap.builtInCMap&&!(properties.cMap instanceof _cmap.IdentityCMap)||properties.cidSystemInfo.registry==="Adobe"&&(properties.cidSystemInfo.ordering==="GB1"||properties.cidSystemInfo.ordering==="CNS1"||properties.cidSystemInfo.ordering==="Japan1"||properties.cidSystemInfo.ordering==="Korea1")))){_context10.next=15;break;}_properties$cidSystem=properties.cidSystemInfo,registry=_properties$cidSystem.registry,ordering=_properties$cidSystem.ordering;ucs2CMapName=_primitives.Name.get("".concat(registry,"-").concat(ordering,"-UCS2"));_context10.next=11;return _cmap.CMapFactory.create({encoding:ucs2CMapName,fetchBuiltInCMap:this._fetchBuiltInCMapBound,useCMap:null});case 11:ucs2CMap=_context10.sent;toUnicode=[],buf=[];properties.cMap.forEach(function(charcode,cid){if(cid>0xffff){throw new _util.FormatError("Max size of CID is 65,535");}var ucs2=ucs2CMap.lookup(cid);if(ucs2){buf.length=0;for(var i=0,ii=ucs2.length;i<ii;i+=2){buf.push((ucs2.charCodeAt(i)<<8)+ucs2.charCodeAt(i+1));}toUnicode[charcode]=String.fromCharCode.apply(String,buf);}});return _context10.abrupt("return",new _to_unicode_map.ToUnicodeMap(toUnicode));case 15:return _context10.abrupt("return",new _to_unicode_map.IdentityToUnicodeMap(properties.firstChar,properties.lastChar));case 16:case"end":return _context10.stop();}},_callee9,this);}));function buildToUnicode(_x16){return _buildToUnicode.apply(this,arguments);}return buildToUnicode;}()},{key:"readToUnicode",value:function readToUnicode(cmapObj){var _this10=this;if(!cmapObj){return Promise.resolve(null);}if(cmapObj instanceof _primitives.Name){return _cmap.CMapFactory.create({encoding:cmapObj,fetchBuiltInCMap:this._fetchBuiltInCMapBound,useCMap:null}).then(function(cmap){if(cmap instanceof _cmap.IdentityCMap){return new _to_unicode_map.IdentityToUnicodeMap(0,0xffff);}return new _to_unicode_map.ToUnicodeMap(cmap.getMap());});}else if(cmapObj instanceof _base_stream.BaseStream){return _cmap.CMapFactory.create({encoding:cmapObj,fetchBuiltInCMap:this._fetchBuiltInCMapBound,useCMap:null}).then(function(cmap){if(cmap instanceof _cmap.IdentityCMap){return new _to_unicode_map.IdentityToUnicodeMap(0,0xffff);}var map=new Array(cmap.length);cmap.forEach(function(charCode,token){if(typeof token==="number"){map[charCode]=String.fromCodePoint(token);return;}var str=[];for(var k=0;k<token.length;k+=2){var w1=token.charCodeAt(k)<<8|token.charCodeAt(k+1);if((w1&0xf800)!==0xd800){str.push(w1);continue;}k+=2;var w2=token.charCodeAt(k)<<8|token.charCodeAt(k+1);str.push(((w1&0x3ff)<<10)+(w2&0x3ff)+0x10000);}map[charCode]=String.fromCodePoint.apply(String,str);});return new _to_unicode_map.ToUnicodeMap(map);},function(reason){if(reason instanceof _util.AbortException){return null;}if(_this10.options.ignoreErrors){(0,_util.warn)("readToUnicode - ignoring ToUnicode data: \"".concat(reason,"\"."));return null;}throw reason;});}return Promise.resolve(null);}},{key:"readCidToGidMap",value:function readCidToGidMap(glyphsData,toUnicode){var result=[];for(var j=0,jj=glyphsData.length;j<jj;j++){var glyphID=glyphsData[j++]<<8|glyphsData[j];var code=j>>1;if(glyphID===0&&!toUnicode.has(code)){continue;}result[code]=glyphID;}return result;}},{key:"extractWidths",value:function extractWidths(dict,descriptor,properties){var xref=this.xref;var glyphsWidths=[];var defaultWidth=0;var glyphsVMetrics=[];var defaultVMetrics;var i,ii,j,jj,start,code,widths;if(properties.composite){defaultWidth=dict.has("DW")?dict.get("DW"):1000;widths=dict.get("W");if(widths){for(i=0,ii=widths.length;i<ii;i++){start=xref.fetchIfRef(widths[i++]);code=xref.fetchIfRef(widths[i]);if(Array.isArray(code)){for(j=0,jj=code.length;j<jj;j++){glyphsWidths[start++]=xref.fetchIfRef(code[j]);}}else{var width=xref.fetchIfRef(widths[++i]);for(j=start;j<=code;j++){glyphsWidths[j]=width;}}}}if(properties.vertical){var vmetrics=dict.getArray("DW2")||[880,-1000];defaultVMetrics=[vmetrics[1],defaultWidth*0.5,vmetrics[0]];vmetrics=dict.get("W2");if(vmetrics){for(i=0,ii=vmetrics.length;i<ii;i++){start=xref.fetchIfRef(vmetrics[i++]);code=xref.fetchIfRef(vmetrics[i]);if(Array.isArray(code)){for(j=0,jj=code.length;j<jj;j++){glyphsVMetrics[start++]=[xref.fetchIfRef(code[j++]),xref.fetchIfRef(code[j++]),xref.fetchIfRef(code[j])];}}else{var vmetric=[xref.fetchIfRef(vmetrics[++i]),xref.fetchIfRef(vmetrics[++i]),xref.fetchIfRef(vmetrics[++i])];for(j=start;j<=code;j++){glyphsVMetrics[j]=vmetric;}}}}}}else{var firstChar=properties.firstChar;widths=dict.get("Widths");if(widths){j=firstChar;for(i=0,ii=widths.length;i<ii;i++){glyphsWidths[j++]=xref.fetchIfRef(widths[i]);}defaultWidth=parseFloat(descriptor.get("MissingWidth"))||0;}else{var baseFontName=dict.get("BaseFont");if(baseFontName instanceof _primitives.Name){var metrics=this.getBaseFontMetrics(baseFontName.name);glyphsWidths=this.buildCharCodeToWidth(metrics.widths,properties);defaultWidth=metrics.defaultWidth;}}}var isMonospace=true;var firstWidth=defaultWidth;for(var glyph in glyphsWidths){var glyphWidth=glyphsWidths[glyph];if(!glyphWidth){continue;}if(!firstWidth){firstWidth=glyphWidth;continue;}if(firstWidth!==glyphWidth){isMonospace=false;break;}}if(isMonospace){properties.flags|=_fonts_utils.FontFlags.FixedPitch;}else{properties.flags&=~_fonts_utils.FontFlags.FixedPitch;}properties.defaultWidth=defaultWidth;properties.widths=glyphsWidths;properties.defaultVMetrics=defaultVMetrics;properties.vmetrics=glyphsVMetrics;}},{key:"isSerifFont",value:function isSerifFont(baseFontName){var fontNameWoStyle=baseFontName.split("-")[0];return fontNameWoStyle in(0,_standard_fonts.getSerifFonts)()||/serif/gi.test(fontNameWoStyle);}},{key:"getBaseFontMetrics",value:function getBaseFontMetrics(name){var defaultWidth=0;var widths=Object.create(null);var monospace=false;var stdFontMap=(0,_standard_fonts.getStdFontMap)();var lookupName=stdFontMap[name]||name;var Metrics=(0,_metrics.getMetrics)();if(!(lookupName in Metrics)){lookupName=this.isSerifFont(name)?"Times-Roman":"Helvetica";}var glyphWidths=Metrics[lookupName];if(typeof glyphWidths==="number"){defaultWidth=glyphWidths;monospace=true;}else{widths=glyphWidths();}return{defaultWidth:defaultWidth,monospace:monospace,widths:widths};}},{key:"buildCharCodeToWidth",value:function buildCharCodeToWidth(widthsByGlyphName,properties){var widths=Object.create(null);var differences=properties.differences;var encoding=properties.defaultEncoding;for(var charCode=0;charCode<256;charCode++){if(charCode in differences&&widthsByGlyphName[differences[charCode]]){widths[charCode]=widthsByGlyphName[differences[charCode]];continue;}if(charCode in encoding&&widthsByGlyphName[encoding[charCode]]){widths[charCode]=widthsByGlyphName[encoding[charCode]];continue;}}return widths;}},{key:"preEvaluateFont",value:function preEvaluateFont(dict){var baseDict=dict;var type=dict.get("Subtype");if(!(type instanceof _primitives.Name)){throw new _util.FormatError("invalid font Subtype");}var composite=false;var hash,toUnicode;if(type.name==="Type0"){var df=dict.get("DescendantFonts");if(!df){throw new _util.FormatError("Descendant fonts are not specified");}dict=Array.isArray(df)?this.xref.fetchIfRef(df[0]):df;if(!(dict instanceof _primitives.Dict)){throw new _util.FormatError("Descendant font is not a dictionary.");}type=dict.get("Subtype");if(!(type instanceof _primitives.Name)){throw new _util.FormatError("invalid font Subtype");}composite=true;}var firstChar=dict.get("FirstChar")||0,lastChar=dict.get("LastChar")||(composite?0xffff:0xff);var descriptor=dict.get("FontDescriptor");if(descriptor){hash=new _murmurhash.MurmurHash3_64();var encoding=baseDict.getRaw("Encoding");if(encoding instanceof _primitives.Name){hash.update(encoding.name);}else if(encoding instanceof _primitives.Ref){hash.update(encoding.toString());}else if(encoding instanceof _primitives.Dict){var _iterator11=_createForOfIteratorHelper(encoding.getRawValues()),_step11;try{for(_iterator11.s();!(_step11=_iterator11.n()).done;){var entry=_step11.value;if(entry instanceof _primitives.Name){hash.update(entry.name);}else if(entry instanceof _primitives.Ref){hash.update(entry.toString());}else if(Array.isArray(entry)){var diffLength=entry.length,diffBuf=new Array(diffLength);for(var j=0;j<diffLength;j++){var diffEntry=entry[j];if(diffEntry instanceof _primitives.Name){diffBuf[j]=diffEntry.name;}else if(typeof diffEntry==="number"||diffEntry instanceof _primitives.Ref){diffBuf[j]=diffEntry.toString();}}hash.update(diffBuf.join());}}}catch(err){_iterator11.e(err);}finally{_iterator11.f();}}hash.update("".concat(firstChar,"-").concat(lastChar));toUnicode=dict.get("ToUnicode")||baseDict.get("ToUnicode");if(toUnicode instanceof _base_stream.BaseStream){var stream=toUnicode.str||toUnicode;var uint8array=stream.buffer?new Uint8Array(stream.buffer.buffer,0,stream.bufferLength):new Uint8Array(stream.bytes.buffer,stream.start,stream.end-stream.start);hash.update(uint8array);}else if(toUnicode instanceof _primitives.Name){hash.update(toUnicode.name);}var widths=dict.get("Widths")||baseDict.get("Widths");if(Array.isArray(widths)){var widthsBuf=[];var _iterator12=_createForOfIteratorHelper(widths),_step12;try{for(_iterator12.s();!(_step12=_iterator12.n()).done;){var _entry=_step12.value;if(typeof _entry==="number"||_entry instanceof _primitives.Ref){widthsBuf.push(_entry.toString());}}}catch(err){_iterator12.e(err);}finally{_iterator12.f();}hash.update(widthsBuf.join());}if(composite){hash.update("compositeFont");var compositeWidths=dict.get("W")||baseDict.get("W");if(Array.isArray(compositeWidths)){var _widthsBuf=[];var _iterator13=_createForOfIteratorHelper(compositeWidths),_step13;try{for(_iterator13.s();!(_step13=_iterator13.n()).done;){var _entry2=_step13.value;if(typeof _entry2==="number"||_entry2 instanceof _primitives.Ref){_widthsBuf.push(_entry2.toString());}else if(Array.isArray(_entry2)){var subWidthsBuf=[];var _iterator14=_createForOfIteratorHelper(_entry2),_step14;try{for(_iterator14.s();!(_step14=_iterator14.n()).done;){var element=_step14.value;if(typeof element==="number"||element instanceof _primitives.Ref){subWidthsBuf.push(element.toString());}}}catch(err){_iterator14.e(err);}finally{_iterator14.f();}_widthsBuf.push("[".concat(subWidthsBuf.join(),"]"));}}}catch(err){_iterator13.e(err);}finally{_iterator13.f();}hash.update(_widthsBuf.join());}var cidToGidMap=dict.getRaw("CIDToGIDMap")||baseDict.getRaw("CIDToGIDMap");if(cidToGidMap instanceof _primitives.Name){hash.update(cidToGidMap.name);}else if(cidToGidMap instanceof _primitives.Ref){hash.update(cidToGidMap.toString());}else if(cidToGidMap instanceof _base_stream.BaseStream){hash.update(cidToGidMap.peekBytes());}}}return{descriptor:descriptor,dict:dict,baseDict:baseDict,composite:composite,type:type.name,firstChar:firstChar,lastChar:lastChar,toUnicode:toUnicode,hash:hash?hash.hexdigest():""};}},{key:"translateFont",value:function(){var _translateFont=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee10(_ref17){var _this11=this,_fontName,_baseFont;var descriptor,dict,baseDict,composite,type,firstChar,lastChar,toUnicode,cssFontInfo,isType3Font,properties,baseFontName,metrics,fontNameWoStyle,flags,widths,standardFontName,file,fontName,baseFont,fontNameStr,baseFontStr,fontFile,subtype,length1,length2,length3,isInternalFont,glyphScaleFactors,systemFontInfo,subtypeEntry,_standardFontName,_standardFontName2,cidEncoding,cMap;return _regeneratorRuntime().wrap(function _callee10$(_context11){while(1)switch(_context11.prev=_context11.next){case 0:descriptor=_ref17.descriptor,dict=_ref17.dict,baseDict=_ref17.baseDict,composite=_ref17.composite,type=_ref17.type,firstChar=_ref17.firstChar,lastChar=_ref17.lastChar,toUnicode=_ref17.toUnicode,cssFontInfo=_ref17.cssFontInfo;isType3Font=type==="Type3";if(descriptor){_context11.next=27;break;}if(!isType3Font){_context11.next=9;break;}descriptor=new _primitives.Dict(null);descriptor.set("FontName",_primitives.Name.get(type));descriptor.set("FontBBox",dict.getArray("FontBBox")||[0,0,0,0]);_context11.next=27;break;case 9:baseFontName=dict.get("BaseFont");if(baseFontName instanceof _primitives.Name){_context11.next=12;break;}throw new _util.FormatError("Base font is not specified");case 12:baseFontName=baseFontName.name.replaceAll(/[,_]/g,"-");metrics=this.getBaseFontMetrics(baseFontName);fontNameWoStyle=baseFontName.split("-")[0];flags=(this.isSerifFont(fontNameWoStyle)?_fonts_utils.FontFlags.Serif:0)|(metrics.monospace?_fonts_utils.FontFlags.FixedPitch:0)|((0,_standard_fonts.getSymbolsFonts)()[fontNameWoStyle]?_fonts_utils.FontFlags.Symbolic:_fonts_utils.FontFlags.Nonsymbolic);properties={type:type,name:baseFontName,loadedName:baseDict.loadedName,systemFontInfo:null,widths:metrics.widths,defaultWidth:metrics.defaultWidth,isSimulatedFlags:true,flags:flags,firstChar:firstChar,lastChar:lastChar,toUnicode:toUnicode,xHeight:0,capHeight:0,italicAngle:0,isType3Font:isType3Font};widths=dict.get("Widths");standardFontName=(0,_standard_fonts.getStandardFontName)(baseFontName);file=null;if(!standardFontName){_context11.next=25;break;}_context11.next=23;return this.fetchStandardFontData(standardFontName);case 23:file=_context11.sent;properties.isInternalFont=!!file;case 25:if(!properties.isInternalFont&&this.options.useSystemFonts){properties.systemFontInfo=(0,_font_substitutions.getFontSubstitution)(this.systemFontCache,this.idFactory,this.options.standardFontDataUrl,baseFontName,standardFontName);}return _context11.abrupt("return",this.extractDataStructures(dict,dict,properties).then(function(newProperties){if(widths){var glyphWidths=[];var j=firstChar;var _iterator15=_createForOfIteratorHelper(widths),_step15;try{for(_iterator15.s();!(_step15=_iterator15.n()).done;){var width=_step15.value;glyphWidths[j++]=_this11.xref.fetchIfRef(width);}}catch(err){_iterator15.e(err);}finally{_iterator15.f();}newProperties.widths=glyphWidths;}else{newProperties.widths=_this11.buildCharCodeToWidth(metrics.widths,newProperties);}return new _fonts.Font(baseFontName,file,newProperties);}));case 27:fontName=descriptor.get("FontName");baseFont=dict.get("BaseFont");if(typeof fontName==="string"){fontName=_primitives.Name.get(fontName);}if(typeof baseFont==="string"){baseFont=_primitives.Name.get(baseFont);}fontNameStr=(_fontName=fontName)===null||_fontName===void 0?void 0:_fontName.name;baseFontStr=(_baseFont=baseFont)===null||_baseFont===void 0?void 0:_baseFont.name;if(!isType3Font&&fontNameStr!==baseFontStr){(0,_util.info)("The FontDescriptor's FontName is \"".concat(fontNameStr,"\" but ")+"should be the same as the Font's BaseFont \"".concat(baseFontStr,"\"."));if(fontNameStr&&baseFontStr&&(baseFontStr.startsWith(fontNameStr)||!(0,_standard_fonts.isKnownFontName)(fontNameStr)&&(0,_standard_fonts.isKnownFontName)(baseFontStr))){fontName=null;}}fontName||(fontName=baseFont);if(fontName instanceof _primitives.Name){_context11.next=37;break;}throw new _util.FormatError("invalid font name");case 37:_context11.prev=37;fontFile=descriptor.get("FontFile","FontFile2","FontFile3");_context11.next=47;break;case 41:_context11.prev=41;_context11.t0=_context11["catch"](37);if(this.options.ignoreErrors){_context11.next=45;break;}throw _context11.t0;case 45:(0,_util.warn)("translateFont - fetching \"".concat(fontName.name,"\" font file: \"").concat(_context11.t0,"\"."));fontFile=new _stream.NullStream();case 47:isInternalFont=false;glyphScaleFactors=null;systemFontInfo=null;if(!fontFile){_context11.next=54;break;}if(fontFile.dict){subtypeEntry=fontFile.dict.get("Subtype");if(subtypeEntry instanceof _primitives.Name){subtype=subtypeEntry.name;}length1=fontFile.dict.get("Length1");length2=fontFile.dict.get("Length2");length3=fontFile.dict.get("Length3");}_context11.next=76;break;case 54:if(!cssFontInfo){_context11.next=68;break;}_standardFontName=(0,_xfa_fonts.getXfaFontName)(fontName.name);if(!_standardFontName){_context11.next=66;break;}cssFontInfo.fontFamily="".concat(cssFontInfo.fontFamily,"-PdfJS-XFA");cssFontInfo.metrics=_standardFontName.metrics||null;glyphScaleFactors=_standardFontName.factors||null;_context11.next=62;return this.fetchStandardFontData(_standardFontName.name);case 62:fontFile=_context11.sent;isInternalFont=!!fontFile;baseDict=dict=(0,_xfa_fonts.getXfaFontDict)(fontName.name);composite=true;case 66:_context11.next=76;break;case 68:if(isType3Font){_context11.next=76;break;}_standardFontName2=(0,_standard_fonts.getStandardFontName)(fontName.name);if(!_standardFontName2){_context11.next=75;break;}_context11.next=73;return this.fetchStandardFontData(_standardFontName2);case 73:fontFile=_context11.sent;isInternalFont=!!fontFile;case 75:if(!isInternalFont&&this.options.useSystemFonts){systemFontInfo=(0,_font_substitutions.getFontSubstitution)(this.systemFontCache,this.idFactory,this.options.standardFontDataUrl,fontName.name,_standardFontName2);}case 76:properties={type:type,name:fontName.name,subtype:subtype,file:fontFile,length1:length1,length2:length2,length3:length3,isInternalFont:isInternalFont,loadedName:baseDict.loadedName,composite:composite,fixedPitch:false,fontMatrix:dict.getArray("FontMatrix")||_util.FONT_IDENTITY_MATRIX,firstChar:firstChar,lastChar:lastChar,toUnicode:toUnicode,bbox:descriptor.getArray("FontBBox")||dict.getArray("FontBBox"),ascent:descriptor.get("Ascent"),descent:descriptor.get("Descent"),xHeight:descriptor.get("XHeight")||0,capHeight:descriptor.get("CapHeight")||0,flags:descriptor.get("Flags"),italicAngle:descriptor.get("ItalicAngle")||0,isType3Font:isType3Font,cssFontInfo:cssFontInfo,scaleFactors:glyphScaleFactors,systemFontInfo:systemFontInfo};if(!composite){_context11.next=85;break;}cidEncoding=baseDict.get("Encoding");if(cidEncoding instanceof _primitives.Name){properties.cidEncoding=cidEncoding.name;}_context11.next=82;return _cmap.CMapFactory.create({encoding:cidEncoding,fetchBuiltInCMap:this._fetchBuiltInCMapBound,useCMap:null});case 82:cMap=_context11.sent;properties.cMap=cMap;properties.vertical=properties.cMap.vertical;case 85:return _context11.abrupt("return",this.extractDataStructures(dict,baseDict,properties).then(function(newProperties){_this11.extractWidths(dict,descriptor,newProperties);return new _fonts.Font(fontName.name,fontFile,newProperties);}));case 86:case"end":return _context11.stop();}},_callee10,this,[[37,41]]);}));function translateFont(_x17){return _translateFont.apply(this,arguments);}return translateFont;}()}],[{key:"buildFontPaths",value:function buildFontPaths(font,glyphs,handler,evaluatorOptions){function buildPath(fontChar){var glyphName="".concat(font.loadedName,"_path_").concat(fontChar);try{if(font.renderer.hasBuiltPath(fontChar)){return;}handler.send("commonobj",[glyphName,"FontPath",font.renderer.getPathJs(fontChar)]);}catch(reason){if(evaluatorOptions.ignoreErrors){(0,_util.warn)("buildFontPaths - ignoring ".concat(glyphName," glyph: \"").concat(reason,"\"."));return;}throw reason;}}var _iterator16=_createForOfIteratorHelper(glyphs),_step16;try{for(_iterator16.s();!(_step16=_iterator16.n()).done;){var glyph=_step16.value;buildPath(glyph.fontChar);var accent=glyph.accent;if(accent!==null&&accent!==void 0&&accent.fontChar){buildPath(accent.fontChar);}}}catch(err){_iterator16.e(err);}finally{_iterator16.f();}}},{key:"fallbackFontDict",get:function get(){var dict=new _primitives.Dict();dict.set("BaseFont",_primitives.Name.get("Helvetica"));dict.set("Type",_primitives.Name.get("FallbackType"));dict.set("Subtype",_primitives.Name.get("FallbackType"));dict.set("Encoding",_primitives.Name.get("WinAnsiEncoding"));return(0,_util.shadow)(this,"fallbackFontDict",dict);}}]);return PartialEvaluator;}();exports.PartialEvaluator=PartialEvaluator;var TranslatedFont=/*#__PURE__*/function(){function TranslatedFont(_ref18){var loadedName=_ref18.loadedName,font=_ref18.font,dict=_ref18.dict,evaluatorOptions=_ref18.evaluatorOptions;_classCallCheck(this,TranslatedFont);this.loadedName=loadedName;this.font=font;this.dict=dict;this._evaluatorOptions=evaluatorOptions||DefaultPartialEvaluatorOptions;this.type3Loaded=null;this.type3Dependencies=font.isType3Font?new Set():null;this.sent=false;}_createClass(TranslatedFont,[{key:"send",value:function send(handler){if(this.sent){return;}this.sent=true;handler.send("commonobj",[this.loadedName,"Font",this.font.exportData(this._evaluatorOptions.fontExtraProperties)]);}},{key:"fallback",value:function fallback(handler){if(!this.font.data){return;}this.font.disableFontFace=true;PartialEvaluator.buildFontPaths(this.font,this.font.glyphCacheValues,handler,this._evaluatorOptions);}},{key:"loadType3Data",value:function loadType3Data(evaluator,resources,task){var _this12=this;if(this.type3Loaded){return this.type3Loaded;}if(!this.font.isType3Font){throw new Error("Must be a Type3 font.");}var type3Evaluator=evaluator.clone({ignoreErrors:false});type3Evaluator.parsingType3Font=true;var type3FontRefs=new _primitives.RefSet(evaluator.type3FontRefs);if(this.dict.objId&&!type3FontRefs.has(this.dict.objId)){type3FontRefs.put(this.dict.objId);}type3Evaluator.type3FontRefs=type3FontRefs;var translatedFont=this.font,type3Dependencies=this.type3Dependencies;var loadCharProcsPromise=Promise.resolve();var charProcs=this.dict.get("CharProcs");var fontResources=this.dict.get("Resources")||resources;var charProcOperatorList=Object.create(null);var fontBBox=_util.Util.normalizeRect(translatedFont.bbox||[0,0,0,0]),width=fontBBox[2]-fontBBox[0],height=fontBBox[3]-fontBBox[1];var fontBBoxSize=Math.hypot(width,height);var _iterator17=_createForOfIteratorHelper(charProcs.getKeys()),_step17;try{var _loop2=function _loop2(){var key=_step17.value;loadCharProcsPromise=loadCharProcsPromise.then(function(){var glyphStream=charProcs.get(key);var operatorList=new _operator_list.OperatorList();return type3Evaluator.getOperatorList({stream:glyphStream,task:task,resources:fontResources,operatorList:operatorList}).then(function(){if(operatorList.fnArray[0]===_util.OPS.setCharWidthAndBounds){_this12._removeType3ColorOperators(operatorList,fontBBoxSize);}charProcOperatorList[key]=operatorList.getIR();var _iterator18=_createForOfIteratorHelper(operatorList.dependencies),_step18;try{for(_iterator18.s();!(_step18=_iterator18.n()).done;){var dependency=_step18.value;type3Dependencies.add(dependency);}}catch(err){_iterator18.e(err);}finally{_iterator18.f();}}).catch(function(reason){(0,_util.warn)("Type3 font resource \"".concat(key,"\" is not available."));var dummyOperatorList=new _operator_list.OperatorList();charProcOperatorList[key]=dummyOperatorList.getIR();});});};for(_iterator17.s();!(_step17=_iterator17.n()).done;){_loop2();}}catch(err){_iterator17.e(err);}finally{_iterator17.f();}this.type3Loaded=loadCharProcsPromise.then(function(){translatedFont.charProcOperatorList=charProcOperatorList;if(_this12._bbox){translatedFont.isCharBBox=true;translatedFont.bbox=_this12._bbox;}});return this.type3Loaded;}},{key:"_removeType3ColorOperators",value:function _removeType3ColorOperators(operatorList){var fontBBoxSize=arguments.length>1&&arguments[1]!==undefined?arguments[1]:NaN;var charBBox=_util.Util.normalizeRect(operatorList.argsArray[0].slice(2)),width=charBBox[2]-charBBox[0],height=charBBox[3]-charBBox[1];var charBBoxSize=Math.hypot(width,height);if(width===0||height===0){operatorList.fnArray.splice(0,1);operatorList.argsArray.splice(0,1);}else if(fontBBoxSize===0||Math.round(charBBoxSize/fontBBoxSize)>=10){if(!this._bbox){this._bbox=[Infinity,Infinity,-Infinity,-Infinity];}this._bbox[0]=Math.min(this._bbox[0],charBBox[0]);this._bbox[1]=Math.min(this._bbox[1],charBBox[1]);this._bbox[2]=Math.max(this._bbox[2],charBBox[2]);this._bbox[3]=Math.max(this._bbox[3],charBBox[3]);}var i=0,ii=operatorList.length;while(i<ii){switch(operatorList.fnArray[i]){case _util.OPS.setCharWidthAndBounds:break;case _util.OPS.setStrokeColorSpace:case _util.OPS.setFillColorSpace:case _util.OPS.setStrokeColor:case _util.OPS.setStrokeColorN:case _util.OPS.setFillColor:case _util.OPS.setFillColorN:case _util.OPS.setStrokeGray:case _util.OPS.setFillGray:case _util.OPS.setStrokeRGBColor:case _util.OPS.setFillRGBColor:case _util.OPS.setStrokeCMYKColor:case _util.OPS.setFillCMYKColor:case _util.OPS.shadingFill:case _util.OPS.setRenderingIntent:operatorList.fnArray.splice(i,1);operatorList.argsArray.splice(i,1);ii--;continue;case _util.OPS.setGState:var _operatorList$argsArr=_slicedToArray(operatorList.argsArray[i],1),gStateObj=_operatorList$argsArr[0];var j=0,jj=gStateObj.length;while(j<jj){var _gStateObj$j=_slicedToArray(gStateObj[j],1),gStateKey=_gStateObj$j[0];switch(gStateKey){case"TR":case"TR2":case"HT":case"BG":case"BG2":case"UCR":case"UCR2":gStateObj.splice(j,1);jj--;continue;}j++;}break;}i++;}}}]);return TranslatedFont;}();var StateManager=/*#__PURE__*/function(){function StateManager(){var initialState=arguments.length>0&&arguments[0]!==undefined?arguments[0]:new EvalState();_classCallCheck(this,StateManager);this.state=initialState;this.stateStack=[];}_createClass(StateManager,[{key:"save",value:function save(){var old=this.state;this.stateStack.push(this.state);this.state=old.clone();}},{key:"restore",value:function restore(){var prev=this.stateStack.pop();if(prev){this.state=prev;}}},{key:"transform",value:function transform(args){this.state.ctm=_util.Util.transform(this.state.ctm,args);}}]);return StateManager;}();var TextState=/*#__PURE__*/function(){function TextState(){_classCallCheck(this,TextState);this.ctm=new Float32Array(_util.IDENTITY_MATRIX);this.fontName=null;this.fontSize=0;this.loadedName=null;this.font=null;this.fontMatrix=_util.FONT_IDENTITY_MATRIX;this.textMatrix=_util.IDENTITY_MATRIX.slice();this.textLineMatrix=_util.IDENTITY_MATRIX.slice();this.charSpacing=0;this.wordSpacing=0;this.leading=0;this.textHScale=1;this.textRise=0;}_createClass(TextState,[{key:"setTextMatrix",value:function setTextMatrix(a,b,c,d,e,f){var m=this.textMatrix;m[0]=a;m[1]=b;m[2]=c;m[3]=d;m[4]=e;m[5]=f;}},{key:"setTextLineMatrix",value:function setTextLineMatrix(a,b,c,d,e,f){var m=this.textLineMatrix;m[0]=a;m[1]=b;m[2]=c;m[3]=d;m[4]=e;m[5]=f;}},{key:"translateTextMatrix",value:function translateTextMatrix(x,y){var m=this.textMatrix;m[4]=m[0]*x+m[2]*y+m[4];m[5]=m[1]*x+m[3]*y+m[5];}},{key:"translateTextLineMatrix",value:function translateTextLineMatrix(x,y){var m=this.textLineMatrix;m[4]=m[0]*x+m[2]*y+m[4];m[5]=m[1]*x+m[3]*y+m[5];}},{key:"carriageReturn",value:function carriageReturn(){this.translateTextLineMatrix(0,-this.leading);this.textMatrix=this.textLineMatrix.slice();}},{key:"clone",value:function clone(){var clone=Object.create(this);clone.textMatrix=this.textMatrix.slice();clone.textLineMatrix=this.textLineMatrix.slice();clone.fontMatrix=this.fontMatrix.slice();return clone;}}]);return TextState;}();var EvalState=/*#__PURE__*/function(){function EvalState(){_classCallCheck(this,EvalState);this.ctm=new Float32Array(_util.IDENTITY_MATRIX);this.font=null;this.textRenderingMode=_util.TextRenderingMode.FILL;this.fillColorSpace=_colorspace.ColorSpace.singletons.gray;this.strokeColorSpace=_colorspace.ColorSpace.singletons.gray;}_createClass(EvalState,[{key:"clone",value:function clone(){return Object.create(this);}}]);return EvalState;}();var EvaluatorPreprocessor=/*#__PURE__*/function(){function EvaluatorPreprocessor(stream,xref){var stateManager=arguments.length>2&&arguments[2]!==undefined?arguments[2]:new StateManager();_classCallCheck(this,EvaluatorPreprocessor);this.parser=new _parser.Parser({lexer:new _parser.Lexer(stream,EvaluatorPreprocessor.opMap),xref:xref});this.stateManager=stateManager;this.nonProcessedArgs=[];this._isPathOp=false;this._numInvalidPathOPS=0;}_createClass(EvaluatorPreprocessor,[{key:"savedStatesDepth",get:function get(){return this.stateManager.stateStack.length;}},{key:"read",value:function read(operation){var args=operation.args;while(true){var obj=this.parser.getObj();if(obj instanceof _primitives.Cmd){var cmd=obj.cmd;var opSpec=EvaluatorPreprocessor.opMap[cmd];if(!opSpec){(0,_util.warn)("Unknown command \"".concat(cmd,"\"."));continue;}var fn=opSpec.id;var numArgs=opSpec.numArgs;var argsLength=args!==null?args.length:0;if(!this._isPathOp){this._numInvalidPathOPS=0;}this._isPathOp=fn>=_util.OPS.moveTo&&fn<=_util.OPS.endPath;if(!opSpec.variableArgs){if(argsLength!==numArgs){var nonProcessedArgs=this.nonProcessedArgs;while(argsLength>numArgs){nonProcessedArgs.push(args.shift());argsLength--;}while(argsLength<numArgs&&nonProcessedArgs.length!==0){if(args===null){args=[];}args.unshift(nonProcessedArgs.pop());argsLength++;}}if(argsLength<numArgs){var partialMsg="command ".concat(cmd,": expected ").concat(numArgs," args, ")+"but received ".concat(argsLength," args.");if(this._isPathOp&&++this._numInvalidPathOPS>EvaluatorPreprocessor.MAX_INVALID_PATH_OPS){throw new _util.FormatError("Invalid ".concat(partialMsg));}(0,_util.warn)("Skipping ".concat(partialMsg));if(args!==null){args.length=0;}continue;}}else if(argsLength>numArgs){(0,_util.info)("Command ".concat(cmd,": expected [0, ").concat(numArgs,"] args, ")+"but received ".concat(argsLength," args."));}this.preprocessCommand(fn,args);operation.fn=fn;operation.args=args;return true;}if(obj===_primitives.EOF){return false;}if(obj!==null){if(args===null){args=[];}args.push(obj);if(args.length>33){throw new _util.FormatError("Too many arguments");}}}}},{key:"preprocessCommand",value:function preprocessCommand(fn,args){switch(fn|0){case _util.OPS.save:this.stateManager.save();break;case _util.OPS.restore:this.stateManager.restore();break;case _util.OPS.transform:this.stateManager.transform(args);break;}}}],[{key:"opMap",get:function get(){var getOPMap=(0,_core_utils.getLookupTableFactory)(function(t){t.w={id:_util.OPS.setLineWidth,numArgs:1,variableArgs:false};t.J={id:_util.OPS.setLineCap,numArgs:1,variableArgs:false};t.j={id:_util.OPS.setLineJoin,numArgs:1,variableArgs:false};t.M={id:_util.OPS.setMiterLimit,numArgs:1,variableArgs:false};t.d={id:_util.OPS.setDash,numArgs:2,variableArgs:false};t.ri={id:_util.OPS.setRenderingIntent,numArgs:1,variableArgs:false};t.i={id:_util.OPS.setFlatness,numArgs:1,variableArgs:false};t.gs={id:_util.OPS.setGState,numArgs:1,variableArgs:false};t.q={id:_util.OPS.save,numArgs:0,variableArgs:false};t.Q={id:_util.OPS.restore,numArgs:0,variableArgs:false};t.cm={id:_util.OPS.transform,numArgs:6,variableArgs:false};t.m={id:_util.OPS.moveTo,numArgs:2,variableArgs:false};t.l={id:_util.OPS.lineTo,numArgs:2,variableArgs:false};t.c={id:_util.OPS.curveTo,numArgs:6,variableArgs:false};t.v={id:_util.OPS.curveTo2,numArgs:4,variableArgs:false};t.y={id:_util.OPS.curveTo3,numArgs:4,variableArgs:false};t.h={id:_util.OPS.closePath,numArgs:0,variableArgs:false};t.re={id:_util.OPS.rectangle,numArgs:4,variableArgs:false};t.S={id:_util.OPS.stroke,numArgs:0,variableArgs:false};t.s={id:_util.OPS.closeStroke,numArgs:0,variableArgs:false};t.f={id:_util.OPS.fill,numArgs:0,variableArgs:false};t.F={id:_util.OPS.fill,numArgs:0,variableArgs:false};t["f*"]={id:_util.OPS.eoFill,numArgs:0,variableArgs:false};t.B={id:_util.OPS.fillStroke,numArgs:0,variableArgs:false};t["B*"]={id:_util.OPS.eoFillStroke,numArgs:0,variableArgs:false};t.b={id:_util.OPS.closeFillStroke,numArgs:0,variableArgs:false};t["b*"]={id:_util.OPS.closeEOFillStroke,numArgs:0,variableArgs:false};t.n={id:_util.OPS.endPath,numArgs:0,variableArgs:false};t.W={id:_util.OPS.clip,numArgs:0,variableArgs:false};t["W*"]={id:_util.OPS.eoClip,numArgs:0,variableArgs:false};t.BT={id:_util.OPS.beginText,numArgs:0,variableArgs:false};t.ET={id:_util.OPS.endText,numArgs:0,variableArgs:false};t.Tc={id:_util.OPS.setCharSpacing,numArgs:1,variableArgs:false};t.Tw={id:_util.OPS.setWordSpacing,numArgs:1,variableArgs:false};t.Tz={id:_util.OPS.setHScale,numArgs:1,variableArgs:false};t.TL={id:_util.OPS.setLeading,numArgs:1,variableArgs:false};t.Tf={id:_util.OPS.setFont,numArgs:2,variableArgs:false};t.Tr={id:_util.OPS.setTextRenderingMode,numArgs:1,variableArgs:false};t.Ts={id:_util.OPS.setTextRise,numArgs:1,variableArgs:false};t.Td={id:_util.OPS.moveText,numArgs:2,variableArgs:false};t.TD={id:_util.OPS.setLeadingMoveText,numArgs:2,variableArgs:false};t.Tm={id:_util.OPS.setTextMatrix,numArgs:6,variableArgs:false};t["T*"]={id:_util.OPS.nextLine,numArgs:0,variableArgs:false};t.Tj={id:_util.OPS.showText,numArgs:1,variableArgs:false};t.TJ={id:_util.OPS.showSpacedText,numArgs:1,variableArgs:false};t["'"]={id:_util.OPS.nextLineShowText,numArgs:1,variableArgs:false};t['"']={id:_util.OPS.nextLineSetSpacingShowText,numArgs:3,variableArgs:false};t.d0={id:_util.OPS.setCharWidth,numArgs:2,variableArgs:false};t.d1={id:_util.OPS.setCharWidthAndBounds,numArgs:6,variableArgs:false};t.CS={id:_util.OPS.setStrokeColorSpace,numArgs:1,variableArgs:false};t.cs={id:_util.OPS.setFillColorSpace,numArgs:1,variableArgs:false};t.SC={id:_util.OPS.setStrokeColor,numArgs:4,variableArgs:true};t.SCN={id:_util.OPS.setStrokeColorN,numArgs:33,variableArgs:true};t.sc={id:_util.OPS.setFillColor,numArgs:4,variableArgs:true};t.scn={id:_util.OPS.setFillColorN,numArgs:33,variableArgs:true};t.G={id:_util.OPS.setStrokeGray,numArgs:1,variableArgs:false};t.g={id:_util.OPS.setFillGray,numArgs:1,variableArgs:false};t.RG={id:_util.OPS.setStrokeRGBColor,numArgs:3,variableArgs:false};t.rg={id:_util.OPS.setFillRGBColor,numArgs:3,variableArgs:false};t.K={id:_util.OPS.setStrokeCMYKColor,numArgs:4,variableArgs:false};t.k={id:_util.OPS.setFillCMYKColor,numArgs:4,variableArgs:false};t.sh={id:_util.OPS.shadingFill,numArgs:1,variableArgs:false};t.BI={id:_util.OPS.beginInlineImage,numArgs:0,variableArgs:false};t.ID={id:_util.OPS.beginImageData,numArgs:0,variableArgs:false};t.EI={id:_util.OPS.endInlineImage,numArgs:1,variableArgs:false};t.Do={id:_util.OPS.paintXObject,numArgs:1,variableArgs:false};t.MP={id:_util.OPS.markPoint,numArgs:1,variableArgs:false};t.DP={id:_util.OPS.markPointProps,numArgs:2,variableArgs:false};t.BMC={id:_util.OPS.beginMarkedContent,numArgs:1,variableArgs:false};t.BDC={id:_util.OPS.beginMarkedContentProps,numArgs:2,variableArgs:false};t.EMC={id:_util.OPS.endMarkedContent,numArgs:0,variableArgs:false};t.BX={id:_util.OPS.beginCompat,numArgs:0,variableArgs:false};t.EX={id:_util.OPS.endCompat,numArgs:0,variableArgs:false};t.BM=null;t.BD=null;t.true=null;t.fa=null;t.fal=null;t.fals=null;t.false=null;t.nu=null;t.nul=null;t.null=null;});return(0,_util.shadow)(this,"opMap",getOPMap());}}]);return EvaluatorPreprocessor;}();exports.EvaluatorPreprocessor=EvaluatorPreprocessor;_defineProperty(EvaluatorPreprocessor,"MAX_INVALID_PATH_OPS",10);

/***/ }),
/* 383 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var FREEZING = __w_pdfjs_require__(264);
var fails = __w_pdfjs_require__(9);
var isObject = __w_pdfjs_require__(28);
var onFreeze = (__w_pdfjs_require__(261).onFreeze);
var $freeze = Object.freeze;
var FAILS_ON_PRIMITIVES = fails(function () {
 $freeze(1);
});
$({
 target: 'Object',
 stat: true,
 forced: FAILS_ON_PRIMITIVES,
 sham: !FREEZING
}, {
 freeze: function freeze(it) {
  return $freeze && isObject(it) ? $freeze(onFreeze(it)) : it;
 }
});

/***/ }),
/* 384 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var sign = __w_pdfjs_require__(385);
$({
 target: 'Math',
 stat: true
}, { sign: sign });

/***/ }),
/* 385 */
/***/ ((module) => {


module.exports = Math.sign || function sign(x) {
 var n = +x;
 return n == 0 || n != n ? n : n < 0 ? -1 : 1;
};

/***/ }),
/* 386 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var uncurryThis = __w_pdfjs_require__(7);
var toAbsoluteIndex = __w_pdfjs_require__(69);
var $RangeError = RangeError;
var fromCharCode = String.fromCharCode;
var $fromCodePoint = String.fromCodePoint;
var join = uncurryThis([].join);
var INCORRECT_LENGTH = !!$fromCodePoint && $fromCodePoint.length != 1;
$({
 target: 'String',
 stat: true,
 arity: 1,
 forced: INCORRECT_LENGTH
}, {
 fromCodePoint: function fromCodePoint(x) {
  var elements = [];
  var length = arguments.length;
  var i = 0;
  var code;
  while (length > i) {
   code = +arguments[i++];
   if (toAbsoluteIndex(code, 0x10FFFF) !== code)
    throw $RangeError(code + ' is not a valid code point');
   elements[i] = code < 0x10000 ? fromCharCode(code) : fromCharCode(((code -= 0x10000) >> 10) + 0xD800, code % 0x400 + 0xDC00);
  }
  return join(elements, '');
 }
});

/***/ }),
/* 387 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var fill = __w_pdfjs_require__(200);
var addToUnscopables = __w_pdfjs_require__(138);
$({
 target: 'Array',
 proto: true
}, { fill: fill });
addToUnscopables('fill');

/***/ }),
/* 388 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

__w_pdfjs_require__(113);__w_pdfjs_require__(137);__w_pdfjs_require__(175);__w_pdfjs_require__(177);__w_pdfjs_require__(134);__w_pdfjs_require__(304);__w_pdfjs_require__(305);__w_pdfjs_require__(145);__w_pdfjs_require__(130);__w_pdfjs_require__(131);__w_pdfjs_require__(132);__w_pdfjs_require__(133);Object.defineProperty(exports, "__esModule", ({value:true}));exports.IdentityCMap=exports.CMapFactory=exports.CMap=void 0;__w_pdfjs_require__(289);__w_pdfjs_require__(183);__w_pdfjs_require__(389);__w_pdfjs_require__(2);__w_pdfjs_require__(54);__w_pdfjs_require__(56);__w_pdfjs_require__(104);__w_pdfjs_require__(143);__w_pdfjs_require__(105);__w_pdfjs_require__(295);__w_pdfjs_require__(299);__w_pdfjs_require__(328);var _util=__w_pdfjs_require__(303);var _primitives=__w_pdfjs_require__(349);var _base_stream=__w_pdfjs_require__(353);var _binary_cmap=__w_pdfjs_require__(390);var _parser=__w_pdfjs_require__(391);var _core_utils=__w_pdfjs_require__(342);var _stream=__w_pdfjs_require__(357);function _regeneratorRuntime(){"use strict";/*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */_regeneratorRuntime=function _regeneratorRuntime(){return exports;};var exports={},Op=Object.prototype,hasOwn=Op.hasOwnProperty,defineProperty=Object.defineProperty||function(obj,key,desc){obj[key]=desc.value;},$Symbol="function"==typeof Symbol?Symbol:{},iteratorSymbol=$Symbol.iterator||"@@iterator",asyncIteratorSymbol=$Symbol.asyncIterator||"@@asyncIterator",toStringTagSymbol=$Symbol.toStringTag||"@@toStringTag";function define(obj,key,value){return Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}),obj[key];}try{define({},"");}catch(err){define=function define(obj,key,value){return obj[key]=value;};}function wrap(innerFn,outerFn,self,tryLocsList){var protoGenerator=outerFn&&outerFn.prototype instanceof Generator?outerFn:Generator,generator=Object.create(protoGenerator.prototype),context=new Context(tryLocsList||[]);return defineProperty(generator,"_invoke",{value:makeInvokeMethod(innerFn,self,context)}),generator;}function tryCatch(fn,obj,arg){try{return{type:"normal",arg:fn.call(obj,arg)};}catch(err){return{type:"throw",arg:err};}}exports.wrap=wrap;var ContinueSentinel={};function Generator(){}function GeneratorFunction(){}function GeneratorFunctionPrototype(){}var IteratorPrototype={};define(IteratorPrototype,iteratorSymbol,function(){return this;});var getProto=Object.getPrototypeOf,NativeIteratorPrototype=getProto&&getProto(getProto(values([])));NativeIteratorPrototype&&NativeIteratorPrototype!==Op&&hasOwn.call(NativeIteratorPrototype,iteratorSymbol)&&(IteratorPrototype=NativeIteratorPrototype);var Gp=GeneratorFunctionPrototype.prototype=Generator.prototype=Object.create(IteratorPrototype);function defineIteratorMethods(prototype){["next","throw","return"].forEach(function(method){define(prototype,method,function(arg){return this._invoke(method,arg);});});}function AsyncIterator(generator,PromiseImpl){function invoke(method,arg,resolve,reject){var record=tryCatch(generator[method],generator,arg);if("throw"!==record.type){var result=record.arg,value=result.value;return value&&"object"==_typeof(value)&&hasOwn.call(value,"__await")?PromiseImpl.resolve(value.__await).then(function(value){invoke("next",value,resolve,reject);},function(err){invoke("throw",err,resolve,reject);}):PromiseImpl.resolve(value).then(function(unwrapped){result.value=unwrapped,resolve(result);},function(error){return invoke("throw",error,resolve,reject);});}reject(record.arg);}var previousPromise;defineProperty(this,"_invoke",{value:function value(method,arg){function callInvokeWithMethodAndArg(){return new PromiseImpl(function(resolve,reject){invoke(method,arg,resolve,reject);});}return previousPromise=previousPromise?previousPromise.then(callInvokeWithMethodAndArg,callInvokeWithMethodAndArg):callInvokeWithMethodAndArg();}});}function makeInvokeMethod(innerFn,self,context){var state="suspendedStart";return function(method,arg){if("executing"===state)throw new Error("Generator is already running");if("completed"===state){if("throw"===method)throw arg;return doneResult();}for(context.method=method,context.arg=arg;;){var delegate=context.delegate;if(delegate){var delegateResult=maybeInvokeDelegate(delegate,context);if(delegateResult){if(delegateResult===ContinueSentinel)continue;return delegateResult;}}if("next"===context.method)context.sent=context._sent=context.arg;else if("throw"===context.method){if("suspendedStart"===state)throw state="completed",context.arg;context.dispatchException(context.arg);}else"return"===context.method&&context.abrupt("return",context.arg);state="executing";var record=tryCatch(innerFn,self,context);if("normal"===record.type){if(state=context.done?"completed":"suspendedYield",record.arg===ContinueSentinel)continue;return{value:record.arg,done:context.done};}"throw"===record.type&&(state="completed",context.method="throw",context.arg=record.arg);}};}function maybeInvokeDelegate(delegate,context){var methodName=context.method,method=delegate.iterator[methodName];if(undefined===method)return context.delegate=null,"throw"===methodName&&delegate.iterator.return&&(context.method="return",context.arg=undefined,maybeInvokeDelegate(delegate,context),"throw"===context.method)||"return"!==methodName&&(context.method="throw",context.arg=new TypeError("The iterator does not provide a '"+methodName+"' method")),ContinueSentinel;var record=tryCatch(method,delegate.iterator,context.arg);if("throw"===record.type)return context.method="throw",context.arg=record.arg,context.delegate=null,ContinueSentinel;var info=record.arg;return info?info.done?(context[delegate.resultName]=info.value,context.next=delegate.nextLoc,"return"!==context.method&&(context.method="next",context.arg=undefined),context.delegate=null,ContinueSentinel):info:(context.method="throw",context.arg=new TypeError("iterator result is not an object"),context.delegate=null,ContinueSentinel);}function pushTryEntry(locs){var entry={tryLoc:locs[0]};1 in locs&&(entry.catchLoc=locs[1]),2 in locs&&(entry.finallyLoc=locs[2],entry.afterLoc=locs[3]),this.tryEntries.push(entry);}function resetTryEntry(entry){var record=entry.completion||{};record.type="normal",delete record.arg,entry.completion=record;}function Context(tryLocsList){this.tryEntries=[{tryLoc:"root"}],tryLocsList.forEach(pushTryEntry,this),this.reset(!0);}function values(iterable){if(iterable){var iteratorMethod=iterable[iteratorSymbol];if(iteratorMethod)return iteratorMethod.call(iterable);if("function"==typeof iterable.next)return iterable;if(!isNaN(iterable.length)){var i=-1,next=function next(){for(;++i<iterable.length;)if(hasOwn.call(iterable,i))return next.value=iterable[i],next.done=!1,next;return next.value=undefined,next.done=!0,next;};return next.next=next;}}return{next:doneResult};}function doneResult(){return{value:undefined,done:!0};}return GeneratorFunction.prototype=GeneratorFunctionPrototype,defineProperty(Gp,"constructor",{value:GeneratorFunctionPrototype,configurable:!0}),defineProperty(GeneratorFunctionPrototype,"constructor",{value:GeneratorFunction,configurable:!0}),GeneratorFunction.displayName=define(GeneratorFunctionPrototype,toStringTagSymbol,"GeneratorFunction"),exports.isGeneratorFunction=function(genFun){var ctor="function"==typeof genFun&&genFun.constructor;return!!ctor&&(ctor===GeneratorFunction||"GeneratorFunction"===(ctor.displayName||ctor.name));},exports.mark=function(genFun){return Object.setPrototypeOf?Object.setPrototypeOf(genFun,GeneratorFunctionPrototype):(genFun.__proto__=GeneratorFunctionPrototype,define(genFun,toStringTagSymbol,"GeneratorFunction")),genFun.prototype=Object.create(Gp),genFun;},exports.awrap=function(arg){return{__await:arg};},defineIteratorMethods(AsyncIterator.prototype),define(AsyncIterator.prototype,asyncIteratorSymbol,function(){return this;}),exports.AsyncIterator=AsyncIterator,exports.async=function(innerFn,outerFn,self,tryLocsList,PromiseImpl){void 0===PromiseImpl&&(PromiseImpl=Promise);var iter=new AsyncIterator(wrap(innerFn,outerFn,self,tryLocsList),PromiseImpl);return exports.isGeneratorFunction(outerFn)?iter:iter.next().then(function(result){return result.done?result.value:iter.next();});},defineIteratorMethods(Gp),define(Gp,toStringTagSymbol,"Generator"),define(Gp,iteratorSymbol,function(){return this;}),define(Gp,"toString",function(){return"[object Generator]";}),exports.keys=function(val){var object=Object(val),keys=[];for(var key in object)keys.push(key);return keys.reverse(),function next(){for(;keys.length;){var key=keys.pop();if(key in object)return next.value=key,next.done=!1,next;}return next.done=!0,next;};},exports.values=values,Context.prototype={constructor:Context,reset:function reset(skipTempReset){if(this.prev=0,this.next=0,this.sent=this._sent=undefined,this.done=!1,this.delegate=null,this.method="next",this.arg=undefined,this.tryEntries.forEach(resetTryEntry),!skipTempReset)for(var name in this)"t"===name.charAt(0)&&hasOwn.call(this,name)&&!isNaN(+name.slice(1))&&(this[name]=undefined);},stop:function stop(){this.done=!0;var rootRecord=this.tryEntries[0].completion;if("throw"===rootRecord.type)throw rootRecord.arg;return this.rval;},dispatchException:function dispatchException(exception){if(this.done)throw exception;var context=this;function handle(loc,caught){return record.type="throw",record.arg=exception,context.next=loc,caught&&(context.method="next",context.arg=undefined),!!caught;}for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i],record=entry.completion;if("root"===entry.tryLoc)return handle("end");if(entry.tryLoc<=this.prev){var hasCatch=hasOwn.call(entry,"catchLoc"),hasFinally=hasOwn.call(entry,"finallyLoc");if(hasCatch&&hasFinally){if(this.prev<entry.catchLoc)return handle(entry.catchLoc,!0);if(this.prev<entry.finallyLoc)return handle(entry.finallyLoc);}else if(hasCatch){if(this.prev<entry.catchLoc)return handle(entry.catchLoc,!0);}else{if(!hasFinally)throw new Error("try statement without catch or finally");if(this.prev<entry.finallyLoc)return handle(entry.finallyLoc);}}}},abrupt:function abrupt(type,arg){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.tryLoc<=this.prev&&hasOwn.call(entry,"finallyLoc")&&this.prev<entry.finallyLoc){var finallyEntry=entry;break;}}finallyEntry&&("break"===type||"continue"===type)&&finallyEntry.tryLoc<=arg&&arg<=finallyEntry.finallyLoc&&(finallyEntry=null);var record=finallyEntry?finallyEntry.completion:{};return record.type=type,record.arg=arg,finallyEntry?(this.method="next",this.next=finallyEntry.finallyLoc,ContinueSentinel):this.complete(record);},complete:function complete(record,afterLoc){if("throw"===record.type)throw record.arg;return"break"===record.type||"continue"===record.type?this.next=record.arg:"return"===record.type?(this.rval=this.arg=record.arg,this.method="return",this.next="end"):"normal"===record.type&&afterLoc&&(this.next=afterLoc),ContinueSentinel;},finish:function finish(finallyLoc){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.finallyLoc===finallyLoc)return this.complete(entry.completion,entry.afterLoc),resetTryEntry(entry),ContinueSentinel;}},catch:function _catch(tryLoc){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.tryLoc===tryLoc){var record=entry.completion;if("throw"===record.type){var thrown=record.arg;resetTryEntry(entry);}return thrown;}}throw new Error("illegal catch attempt");},delegateYield:function delegateYield(iterable,resultName,nextLoc){return this.delegate={iterator:values(iterable),resultName:resultName,nextLoc:nextLoc},"next"===this.method&&(this.arg=undefined),ContinueSentinel;}},exports;}function asyncGeneratorStep(gen,resolve,reject,_next,_throw,key,arg){try{var info=gen[key](arg);var value=info.value;}catch(error){reject(error);return;}if(info.done){resolve(value);}else{Promise.resolve(value).then(_next,_throw);}}function _asyncToGenerator(fn){return function(){var self=this,args=arguments;return new Promise(function(resolve,reject){var gen=fn.apply(self,args);function _next(value){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"next",value);}function _throw(err){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"throw",err);}_next(undefined);});};}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function");}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:true,configurable:true}});Object.defineProperty(subClass,"prototype",{writable:false});if(superClass)_setPrototypeOf(subClass,superClass);}function _setPrototypeOf(o,p){_setPrototypeOf=Object.setPrototypeOf?Object.setPrototypeOf.bind():function _setPrototypeOf(o,p){o.__proto__=p;return o;};return _setPrototypeOf(o,p);}function _createSuper(Derived){var hasNativeReflectConstruct=_isNativeReflectConstruct();return function _createSuperInternal(){var Super=_getPrototypeOf(Derived),result;if(hasNativeReflectConstruct){var NewTarget=_getPrototypeOf(this).constructor;result=Reflect.construct(Super,arguments,NewTarget);}else{result=Super.apply(this,arguments);}return _possibleConstructorReturn(this,result);};}function _possibleConstructorReturn(self,call){if(call&&(_typeof(call)==="object"||typeof call==="function")){return call;}else if(call!==void 0){throw new TypeError("Derived constructors may only return object or undefined");}return _assertThisInitialized(self);}function _assertThisInitialized(self){if(self===void 0){throw new ReferenceError("this hasn't been initialised - super() hasn't been called");}return self;}function _isNativeReflectConstruct(){if(typeof Reflect==="undefined"||!Reflect.construct)return false;if(Reflect.construct.sham)return false;if(typeof Proxy==="function")return true;try{Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}));return true;}catch(e){return false;}}function _getPrototypeOf(o){_getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf.bind():function _getPrototypeOf(o){return o.__proto__||Object.getPrototypeOf(o);};return _getPrototypeOf(o);}function _typeof(obj){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj;}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;},_typeof(obj);}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}}function _createClass(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);Object.defineProperty(Constructor,"prototype",{writable:false});return Constructor;}function _toPropertyKey(arg){var key=_toPrimitive(arg,"string");return _typeof(key)==="symbol"?key:String(key);}function _toPrimitive(input,hint){if(_typeof(input)!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(_typeof(res)!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.");}return(hint==="string"?String:Number)(input);}var BUILT_IN_CMAPS=["Adobe-GB1-UCS2","Adobe-CNS1-UCS2","Adobe-Japan1-UCS2","Adobe-Korea1-UCS2","78-EUC-H","78-EUC-V","78-H","78-RKSJ-H","78-RKSJ-V","78-V","78ms-RKSJ-H","78ms-RKSJ-V","83pv-RKSJ-H","90ms-RKSJ-H","90ms-RKSJ-V","90msp-RKSJ-H","90msp-RKSJ-V","90pv-RKSJ-H","90pv-RKSJ-V","Add-H","Add-RKSJ-H","Add-RKSJ-V","Add-V","Adobe-CNS1-0","Adobe-CNS1-1","Adobe-CNS1-2","Adobe-CNS1-3","Adobe-CNS1-4","Adobe-CNS1-5","Adobe-CNS1-6","Adobe-GB1-0","Adobe-GB1-1","Adobe-GB1-2","Adobe-GB1-3","Adobe-GB1-4","Adobe-GB1-5","Adobe-Japan1-0","Adobe-Japan1-1","Adobe-Japan1-2","Adobe-Japan1-3","Adobe-Japan1-4","Adobe-Japan1-5","Adobe-Japan1-6","Adobe-Korea1-0","Adobe-Korea1-1","Adobe-Korea1-2","B5-H","B5-V","B5pc-H","B5pc-V","CNS-EUC-H","CNS-EUC-V","CNS1-H","CNS1-V","CNS2-H","CNS2-V","ETHK-B5-H","ETHK-B5-V","ETen-B5-H","ETen-B5-V","ETenms-B5-H","ETenms-B5-V","EUC-H","EUC-V","Ext-H","Ext-RKSJ-H","Ext-RKSJ-V","Ext-V","GB-EUC-H","GB-EUC-V","GB-H","GB-V","GBK-EUC-H","GBK-EUC-V","GBK2K-H","GBK2K-V","GBKp-EUC-H","GBKp-EUC-V","GBT-EUC-H","GBT-EUC-V","GBT-H","GBT-V","GBTpc-EUC-H","GBTpc-EUC-V","GBpc-EUC-H","GBpc-EUC-V","H","HKdla-B5-H","HKdla-B5-V","HKdlb-B5-H","HKdlb-B5-V","HKgccs-B5-H","HKgccs-B5-V","HKm314-B5-H","HKm314-B5-V","HKm471-B5-H","HKm471-B5-V","HKscs-B5-H","HKscs-B5-V","Hankaku","Hiragana","KSC-EUC-H","KSC-EUC-V","KSC-H","KSC-Johab-H","KSC-Johab-V","KSC-V","KSCms-UHC-H","KSCms-UHC-HW-H","KSCms-UHC-HW-V","KSCms-UHC-V","KSCpc-EUC-H","KSCpc-EUC-V","Katakana","NWP-H","NWP-V","RKSJ-H","RKSJ-V","Roman","UniCNS-UCS2-H","UniCNS-UCS2-V","UniCNS-UTF16-H","UniCNS-UTF16-V","UniCNS-UTF32-H","UniCNS-UTF32-V","UniCNS-UTF8-H","UniCNS-UTF8-V","UniGB-UCS2-H","UniGB-UCS2-V","UniGB-UTF16-H","UniGB-UTF16-V","UniGB-UTF32-H","UniGB-UTF32-V","UniGB-UTF8-H","UniGB-UTF8-V","UniJIS-UCS2-H","UniJIS-UCS2-HW-H","UniJIS-UCS2-HW-V","UniJIS-UCS2-V","UniJIS-UTF16-H","UniJIS-UTF16-V","UniJIS-UTF32-H","UniJIS-UTF32-V","UniJIS-UTF8-H","UniJIS-UTF8-V","UniJIS2004-UTF16-H","UniJIS2004-UTF16-V","UniJIS2004-UTF32-H","UniJIS2004-UTF32-V","UniJIS2004-UTF8-H","UniJIS2004-UTF8-V","UniJISPro-UCS2-HW-V","UniJISPro-UCS2-V","UniJISPro-UTF8-V","UniJISX0213-UTF32-H","UniJISX0213-UTF32-V","UniJISX02132004-UTF32-H","UniJISX02132004-UTF32-V","UniKS-UCS2-H","UniKS-UCS2-V","UniKS-UTF16-H","UniKS-UTF16-V","UniKS-UTF32-H","UniKS-UTF32-V","UniKS-UTF8-H","UniKS-UTF8-V","V","WP-Symbol"];var MAX_MAP_RANGE=Math.pow(2,24)-1;var CMap=/*#__PURE__*/function(){function CMap(){var builtInCMap=arguments.length>0&&arguments[0]!==undefined?arguments[0]:false;_classCallCheck(this,CMap);this.codespaceRanges=[[],[],[],[]];this.numCodespaceRanges=0;this._map=[];this.name="";this.vertical=false;this.useCMap=null;this.builtInCMap=builtInCMap;}_createClass(CMap,[{key:"addCodespaceRange",value:function addCodespaceRange(n,low,high){this.codespaceRanges[n-1].push(low,high);this.numCodespaceRanges++;}},{key:"mapCidRange",value:function mapCidRange(low,high,dstLow){if(high-low>MAX_MAP_RANGE){throw new Error("mapCidRange - ignoring data above MAX_MAP_RANGE.");}while(low<=high){this._map[low++]=dstLow++;}}},{key:"mapBfRange",value:function mapBfRange(low,high,dstLow){if(high-low>MAX_MAP_RANGE){throw new Error("mapBfRange - ignoring data above MAX_MAP_RANGE.");}var lastByte=dstLow.length-1;while(low<=high){this._map[low++]=dstLow;var nextCharCode=dstLow.charCodeAt(lastByte)+1;if(nextCharCode>0xff){dstLow=dstLow.substring(0,lastByte-1)+String.fromCharCode(dstLow.charCodeAt(lastByte-1)+1)+"\x00";continue;}dstLow=dstLow.substring(0,lastByte)+String.fromCharCode(nextCharCode);}}},{key:"mapBfRangeToArray",value:function mapBfRangeToArray(low,high,array){if(high-low>MAX_MAP_RANGE){throw new Error("mapBfRangeToArray - ignoring data above MAX_MAP_RANGE.");}var ii=array.length;var i=0;while(low<=high&&i<ii){this._map[low]=array[i++];++low;}}},{key:"mapOne",value:function mapOne(src,dst){this._map[src]=dst;}},{key:"lookup",value:function lookup(code){return this._map[code];}},{key:"contains",value:function contains(code){return this._map[code]!==undefined;}},{key:"forEach",value:function forEach(callback){var map=this._map;var length=map.length;if(length<=0x10000){for(var i=0;i<length;i++){if(map[i]!==undefined){callback(i,map[i]);}}}else{for(var _i in map){callback(_i,map[_i]);}}}},{key:"charCodeOf",value:function charCodeOf(value){var map=this._map;if(map.length<=0x10000){return map.indexOf(value);}for(var charCode in map){if(map[charCode]===value){return charCode|0;}}return-1;}},{key:"getMap",value:function getMap(){return this._map;}},{key:"readCharCode",value:function readCharCode(str,offset,out){var c=0;var codespaceRanges=this.codespaceRanges;for(var n=0,nn=codespaceRanges.length;n<nn;n++){c=(c<<8|str.charCodeAt(offset+n))>>>0;var codespaceRange=codespaceRanges[n];for(var k=0,kk=codespaceRange.length;k<kk;){var low=codespaceRange[k++];var high=codespaceRange[k++];if(c>=low&&c<=high){out.charcode=c;out.length=n+1;return;}}}out.charcode=0;out.length=1;}},{key:"getCharCodeLength",value:function getCharCodeLength(charCode){var codespaceRanges=this.codespaceRanges;for(var n=0,nn=codespaceRanges.length;n<nn;n++){var codespaceRange=codespaceRanges[n];for(var k=0,kk=codespaceRange.length;k<kk;){var low=codespaceRange[k++];var high=codespaceRange[k++];if(charCode>=low&&charCode<=high){return n+1;}}}return 1;}},{key:"length",get:function get(){return this._map.length;}},{key:"isIdentityCMap",get:function get(){if(!(this.name==="Identity-H"||this.name==="Identity-V")){return false;}if(this._map.length!==0x10000){return false;}for(var i=0;i<0x10000;i++){if(this._map[i]!==i){return false;}}return true;}}]);return CMap;}();exports.CMap=CMap;var IdentityCMap=/*#__PURE__*/function(_CMap){_inherits(IdentityCMap,_CMap);var _super=_createSuper(IdentityCMap);function IdentityCMap(vertical,n){var _this;_classCallCheck(this,IdentityCMap);_this=_super.call(this);_this.vertical=vertical;_this.addCodespaceRange(n,0,0xffff);return _this;}_createClass(IdentityCMap,[{key:"mapCidRange",value:function mapCidRange(low,high,dstLow){(0,_util.unreachable)("should not call mapCidRange");}},{key:"mapBfRange",value:function mapBfRange(low,high,dstLow){(0,_util.unreachable)("should not call mapBfRange");}},{key:"mapBfRangeToArray",value:function mapBfRangeToArray(low,high,array){(0,_util.unreachable)("should not call mapBfRangeToArray");}},{key:"mapOne",value:function mapOne(src,dst){(0,_util.unreachable)("should not call mapCidOne");}},{key:"lookup",value:function lookup(code){return Number.isInteger(code)&&code<=0xffff?code:undefined;}},{key:"contains",value:function contains(code){return Number.isInteger(code)&&code<=0xffff;}},{key:"forEach",value:function forEach(callback){for(var i=0;i<=0xffff;i++){callback(i,i);}}},{key:"charCodeOf",value:function charCodeOf(value){return Number.isInteger(value)&&value<=0xffff?value:-1;}},{key:"getMap",value:function getMap(){var map=new Array(0x10000);for(var i=0;i<=0xffff;i++){map[i]=i;}return map;}},{key:"length",get:function get(){return 0x10000;}},{key:"isIdentityCMap",get:function get(){(0,_util.unreachable)("should not access .isIdentityCMap");}}]);return IdentityCMap;}(CMap);exports.IdentityCMap=IdentityCMap;function strToInt(str){var a=0;for(var i=0;i<str.length;i++){a=a<<8|str.charCodeAt(i);}return a>>>0;}function expectString(obj){if(typeof obj!=="string"){throw new _util.FormatError("Malformed CMap: expected string.");}}function expectInt(obj){if(!Number.isInteger(obj)){throw new _util.FormatError("Malformed CMap: expected int.");}}function parseBfChar(cMap,lexer){while(true){var obj=lexer.getObj();if(obj===_primitives.EOF){break;}if((0,_primitives.isCmd)(obj,"endbfchar")){return;}expectString(obj);var src=strToInt(obj);obj=lexer.getObj();expectString(obj);var dst=obj;cMap.mapOne(src,dst);}}function parseBfRange(cMap,lexer){while(true){var obj=lexer.getObj();if(obj===_primitives.EOF){break;}if((0,_primitives.isCmd)(obj,"endbfrange")){return;}expectString(obj);var low=strToInt(obj);obj=lexer.getObj();expectString(obj);var high=strToInt(obj);obj=lexer.getObj();if(Number.isInteger(obj)||typeof obj==="string"){var dstLow=Number.isInteger(obj)?String.fromCharCode(obj):obj;cMap.mapBfRange(low,high,dstLow);}else if((0,_primitives.isCmd)(obj,"[")){obj=lexer.getObj();var array=[];while(!(0,_primitives.isCmd)(obj,"]")&&obj!==_primitives.EOF){array.push(obj);obj=lexer.getObj();}cMap.mapBfRangeToArray(low,high,array);}else{break;}}throw new _util.FormatError("Invalid bf range.");}function parseCidChar(cMap,lexer){while(true){var obj=lexer.getObj();if(obj===_primitives.EOF){break;}if((0,_primitives.isCmd)(obj,"endcidchar")){return;}expectString(obj);var src=strToInt(obj);obj=lexer.getObj();expectInt(obj);var dst=obj;cMap.mapOne(src,dst);}}function parseCidRange(cMap,lexer){while(true){var obj=lexer.getObj();if(obj===_primitives.EOF){break;}if((0,_primitives.isCmd)(obj,"endcidrange")){return;}expectString(obj);var low=strToInt(obj);obj=lexer.getObj();expectString(obj);var high=strToInt(obj);obj=lexer.getObj();expectInt(obj);var dstLow=obj;cMap.mapCidRange(low,high,dstLow);}}function parseCodespaceRange(cMap,lexer){while(true){var obj=lexer.getObj();if(obj===_primitives.EOF){break;}if((0,_primitives.isCmd)(obj,"endcodespacerange")){return;}if(typeof obj!=="string"){break;}var low=strToInt(obj);obj=lexer.getObj();if(typeof obj!=="string"){break;}var high=strToInt(obj);cMap.addCodespaceRange(obj.length,low,high);}throw new _util.FormatError("Invalid codespace range.");}function parseWMode(cMap,lexer){var obj=lexer.getObj();if(Number.isInteger(obj)){cMap.vertical=!!obj;}}function parseCMapName(cMap,lexer){var obj=lexer.getObj();if(obj instanceof _primitives.Name){cMap.name=obj.name;}}function parseCMap(_x,_x2,_x3,_x4){return _parseCMap.apply(this,arguments);}function _parseCMap(){_parseCMap=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee2(cMap,lexer,fetchBuiltInCMap,useCMap){var previous,embeddedUseCMap,obj;return _regeneratorRuntime().wrap(function _callee2$(_context2){while(1)switch(_context2.prev=_context2.next){case 0:if(false){}_context2.prev=1;obj=lexer.getObj();if(!(obj===_primitives.EOF)){_context2.next=7;break;}return _context2.abrupt("break",39);case 7:if(!(obj instanceof _primitives.Name)){_context2.next=12;break;}if(obj.name==="WMode"){parseWMode(cMap,lexer);}else if(obj.name==="CMapName"){parseCMapName(cMap,lexer);}previous=obj;_context2.next=29;break;case 12:if(!(obj instanceof _primitives.Cmd)){_context2.next=29;break;}_context2.t0=obj.cmd;_context2.next=_context2.t0==="endcmap"?16:_context2.t0==="usecmap"?17:_context2.t0==="begincodespacerange"?19:_context2.t0==="beginbfchar"?21:_context2.t0==="begincidchar"?23:_context2.t0==="beginbfrange"?25:_context2.t0==="begincidrange"?27:29;break;case 16:return _context2.abrupt("break",39);case 17:if(previous instanceof _primitives.Name){embeddedUseCMap=previous.name;}return _context2.abrupt("break",29);case 19:parseCodespaceRange(cMap,lexer);return _context2.abrupt("break",29);case 21:parseBfChar(cMap,lexer);return _context2.abrupt("break",29);case 23:parseCidChar(cMap,lexer);return _context2.abrupt("break",29);case 25:parseBfRange(cMap,lexer);return _context2.abrupt("break",29);case 27:parseCidRange(cMap,lexer);return _context2.abrupt("break",29);case 29:_context2.next=37;break;case 31:_context2.prev=31;_context2.t1=_context2["catch"](1);if(!(_context2.t1 instanceof _core_utils.MissingDataException)){_context2.next=35;break;}throw _context2.t1;case 35:(0,_util.warn)("Invalid cMap data: "+_context2.t1);return _context2.abrupt("continue",0);case 37:_context2.next=0;break;case 39:if(!useCMap&&embeddedUseCMap){useCMap=embeddedUseCMap;}if(!useCMap){_context2.next=42;break;}return _context2.abrupt("return",extendCMap(cMap,fetchBuiltInCMap,useCMap));case 42:return _context2.abrupt("return",cMap);case 43:case"end":return _context2.stop();}},_callee2,null,[[1,31]]);}));return _parseCMap.apply(this,arguments);}function extendCMap(_x5,_x6,_x7){return _extendCMap.apply(this,arguments);}function _extendCMap(){_extendCMap=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee3(cMap,fetchBuiltInCMap,useCMap){var useCodespaceRanges,i;return _regeneratorRuntime().wrap(function _callee3$(_context3){while(1)switch(_context3.prev=_context3.next){case 0:_context3.next=2;return createBuiltInCMap(useCMap,fetchBuiltInCMap);case 2:cMap.useCMap=_context3.sent;if(cMap.numCodespaceRanges===0){useCodespaceRanges=cMap.useCMap.codespaceRanges;for(i=0;i<useCodespaceRanges.length;i++){cMap.codespaceRanges[i]=useCodespaceRanges[i].slice();}cMap.numCodespaceRanges=cMap.useCMap.numCodespaceRanges;}cMap.useCMap.forEach(function(key,value){if(!cMap.contains(key)){cMap.mapOne(key,cMap.useCMap.lookup(key));}});return _context3.abrupt("return",cMap);case 6:case"end":return _context3.stop();}},_callee3);}));return _extendCMap.apply(this,arguments);}function createBuiltInCMap(_x8,_x9){return _createBuiltInCMap.apply(this,arguments);}function _createBuiltInCMap(){_createBuiltInCMap=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee4(name,fetchBuiltInCMap){var _yield$fetchBuiltInCM,cMapData,compressionType,cMap,lexer;return _regeneratorRuntime().wrap(function _callee4$(_context4){while(1)switch(_context4.prev=_context4.next){case 0:if(!(name==="Identity-H")){_context4.next=4;break;}return _context4.abrupt("return",new IdentityCMap(false,2));case 4:if(!(name==="Identity-V")){_context4.next=6;break;}return _context4.abrupt("return",new IdentityCMap(true,2));case 6:if(BUILT_IN_CMAPS.includes(name)){_context4.next=8;break;}throw new Error("Unknown CMap name: "+name);case 8:if(fetchBuiltInCMap){_context4.next=10;break;}throw new Error("Built-in CMap parameters are not provided.");case 10:_context4.next=12;return fetchBuiltInCMap(name);case 12:_yield$fetchBuiltInCM=_context4.sent;cMapData=_yield$fetchBuiltInCM.cMapData;compressionType=_yield$fetchBuiltInCM.compressionType;cMap=new CMap(true);if(!(compressionType===_util.CMapCompressionType.BINARY)){_context4.next=18;break;}return _context4.abrupt("return",new _binary_cmap.BinaryCMapReader().process(cMapData,cMap,function(useCMap){return extendCMap(cMap,fetchBuiltInCMap,useCMap);}));case 18:if(!(compressionType===_util.CMapCompressionType.NONE)){_context4.next=21;break;}lexer=new _parser.Lexer(new _stream.Stream(cMapData));return _context4.abrupt("return",parseCMap(cMap,lexer,fetchBuiltInCMap,null));case 21:throw new Error("Invalid CMap \"compressionType\" value: ".concat(compressionType));case 22:case"end":return _context4.stop();}},_callee4);}));return _createBuiltInCMap.apply(this,arguments);}var CMapFactory=/*#__PURE__*/function(){function CMapFactory(){_classCallCheck(this,CMapFactory);}_createClass(CMapFactory,null,[{key:"create",value:function(){var _create=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee(_ref){var encoding,fetchBuiltInCMap,useCMap,parsedCMap;return _regeneratorRuntime().wrap(function _callee$(_context){while(1)switch(_context.prev=_context.next){case 0:encoding=_ref.encoding,fetchBuiltInCMap=_ref.fetchBuiltInCMap,useCMap=_ref.useCMap;if(!(encoding instanceof _primitives.Name)){_context.next=5;break;}return _context.abrupt("return",createBuiltInCMap(encoding.name,fetchBuiltInCMap));case 5:if(!(encoding instanceof _base_stream.BaseStream)){_context.next=12;break;}_context.next=8;return parseCMap(new CMap(),new _parser.Lexer(encoding),fetchBuiltInCMap,useCMap);case 8:parsedCMap=_context.sent;if(!parsedCMap.isIdentityCMap){_context.next=11;break;}return _context.abrupt("return",createBuiltInCMap(parsedCMap.name,fetchBuiltInCMap));case 11:return _context.abrupt("return",parsedCMap);case 12:throw new Error("Encoding required.");case 13:case"end":return _context.stop();}},_callee);}));function create(_x10){return _create.apply(this,arguments);}return create;}()}]);return CMapFactory;}();exports.CMapFactory=CMapFactory;

/***/ }),
/* 389 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {


var $ = __w_pdfjs_require__(58);
var uncurryThis = __w_pdfjs_require__(91);
var $indexOf = (__w_pdfjs_require__(68).indexOf);
var arrayMethodIsStrict = __w_pdfjs_require__(230);
var nativeIndexOf = uncurryThis([].indexOf);
var NEGATIVE_ZERO = !!nativeIndexOf && 1 / nativeIndexOf([1], 1, -0) < 0;
var FORCED = NEGATIVE_ZERO || !arrayMethodIsStrict('indexOf');
$({
 target: 'Array',
 proto: true,
 forced: FORCED
}, {
 indexOf: function indexOf(searchElement) {
  var fromIndex = arguments.length > 1 ? arguments[1] : undefined;
  return NEGATIVE_ZERO ? nativeIndexOf(this, searchElement, fromIndex) || 0 : $indexOf(this, searchElement, fromIndex);
 }
});

/***/ }),
/* 390 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

function _typeof(obj){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj;}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;},_typeof(obj);}__w_pdfjs_require__(56);__w_pdfjs_require__(104);__w_pdfjs_require__(113);__w_pdfjs_require__(175);__w_pdfjs_require__(177);__w_pdfjs_require__(114);__w_pdfjs_require__(295);__w_pdfjs_require__(292);__w_pdfjs_require__(123);__w_pdfjs_require__(129);__w_pdfjs_require__(2);__w_pdfjs_require__(54);__w_pdfjs_require__(105);__w_pdfjs_require__(145);__w_pdfjs_require__(130);__w_pdfjs_require__(131);__w_pdfjs_require__(132);__w_pdfjs_require__(133);__w_pdfjs_require__(134);__w_pdfjs_require__(289);__w_pdfjs_require__(299);Object.defineProperty(exports, "__esModule", ({value:true}));exports.BinaryCMapReader=void 0;__w_pdfjs_require__(137);__w_pdfjs_require__(143);__w_pdfjs_require__(191);__w_pdfjs_require__(208);__w_pdfjs_require__(209);__w_pdfjs_require__(212);__w_pdfjs_require__(213);__w_pdfjs_require__(214);__w_pdfjs_require__(218);__w_pdfjs_require__(219);__w_pdfjs_require__(220);__w_pdfjs_require__(222);__w_pdfjs_require__(223);__w_pdfjs_require__(224);__w_pdfjs_require__(225);__w_pdfjs_require__(226);__w_pdfjs_require__(227);__w_pdfjs_require__(228);__w_pdfjs_require__(231);__w_pdfjs_require__(232);__w_pdfjs_require__(234);__w_pdfjs_require__(235);__w_pdfjs_require__(236);__w_pdfjs_require__(237);__w_pdfjs_require__(238);__w_pdfjs_require__(239);__w_pdfjs_require__(244);__w_pdfjs_require__(245);__w_pdfjs_require__(247);__w_pdfjs_require__(248);__w_pdfjs_require__(249);__w_pdfjs_require__(251);__w_pdfjs_require__(254);__w_pdfjs_require__(257);__w_pdfjs_require__(183);var _util=__w_pdfjs_require__(303);function _regeneratorRuntime(){"use strict";/*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */_regeneratorRuntime=function _regeneratorRuntime(){return exports;};var exports={},Op=Object.prototype,hasOwn=Op.hasOwnProperty,defineProperty=Object.defineProperty||function(obj,key,desc){obj[key]=desc.value;},$Symbol="function"==typeof Symbol?Symbol:{},iteratorSymbol=$Symbol.iterator||"@@iterator",asyncIteratorSymbol=$Symbol.asyncIterator||"@@asyncIterator",toStringTagSymbol=$Symbol.toStringTag||"@@toStringTag";function define(obj,key,value){return Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}),obj[key];}try{define({},"");}catch(err){define=function define(obj,key,value){return obj[key]=value;};}function wrap(innerFn,outerFn,self,tryLocsList){var protoGenerator=outerFn&&outerFn.prototype instanceof Generator?outerFn:Generator,generator=Object.create(protoGenerator.prototype),context=new Context(tryLocsList||[]);return defineProperty(generator,"_invoke",{value:makeInvokeMethod(innerFn,self,context)}),generator;}function tryCatch(fn,obj,arg){try{return{type:"normal",arg:fn.call(obj,arg)};}catch(err){return{type:"throw",arg:err};}}exports.wrap=wrap;var ContinueSentinel={};function Generator(){}function GeneratorFunction(){}function GeneratorFunctionPrototype(){}var IteratorPrototype={};define(IteratorPrototype,iteratorSymbol,function(){return this;});var getProto=Object.getPrototypeOf,NativeIteratorPrototype=getProto&&getProto(getProto(values([])));NativeIteratorPrototype&&NativeIteratorPrototype!==Op&&hasOwn.call(NativeIteratorPrototype,iteratorSymbol)&&(IteratorPrototype=NativeIteratorPrototype);var Gp=GeneratorFunctionPrototype.prototype=Generator.prototype=Object.create(IteratorPrototype);function defineIteratorMethods(prototype){["next","throw","return"].forEach(function(method){define(prototype,method,function(arg){return this._invoke(method,arg);});});}function AsyncIterator(generator,PromiseImpl){function invoke(method,arg,resolve,reject){var record=tryCatch(generator[method],generator,arg);if("throw"!==record.type){var result=record.arg,value=result.value;return value&&"object"==_typeof(value)&&hasOwn.call(value,"__await")?PromiseImpl.resolve(value.__await).then(function(value){invoke("next",value,resolve,reject);},function(err){invoke("throw",err,resolve,reject);}):PromiseImpl.resolve(value).then(function(unwrapped){result.value=unwrapped,resolve(result);},function(error){return invoke("throw",error,resolve,reject);});}reject(record.arg);}var previousPromise;defineProperty(this,"_invoke",{value:function value(method,arg){function callInvokeWithMethodAndArg(){return new PromiseImpl(function(resolve,reject){invoke(method,arg,resolve,reject);});}return previousPromise=previousPromise?previousPromise.then(callInvokeWithMethodAndArg,callInvokeWithMethodAndArg):callInvokeWithMethodAndArg();}});}function makeInvokeMethod(innerFn,self,context){var state="suspendedStart";return function(method,arg){if("executing"===state)throw new Error("Generator is already running");if("completed"===state){if("throw"===method)throw arg;return doneResult();}for(context.method=method,context.arg=arg;;){var delegate=context.delegate;if(delegate){var delegateResult=maybeInvokeDelegate(delegate,context);if(delegateResult){if(delegateResult===ContinueSentinel)continue;return delegateResult;}}if("next"===context.method)context.sent=context._sent=context.arg;else if("throw"===context.method){if("suspendedStart"===state)throw state="completed",context.arg;context.dispatchException(context.arg);}else"return"===context.method&&context.abrupt("return",context.arg);state="executing";var record=tryCatch(innerFn,self,context);if("normal"===record.type){if(state=context.done?"completed":"suspendedYield",record.arg===ContinueSentinel)continue;return{value:record.arg,done:context.done};}"throw"===record.type&&(state="completed",context.method="throw",context.arg=record.arg);}};}function maybeInvokeDelegate(delegate,context){var methodName=context.method,method=delegate.iterator[methodName];if(undefined===method)return context.delegate=null,"throw"===methodName&&delegate.iterator.return&&(context.method="return",context.arg=undefined,maybeInvokeDelegate(delegate,context),"throw"===context.method)||"return"!==methodName&&(context.method="throw",context.arg=new TypeError("The iterator does not provide a '"+methodName+"' method")),ContinueSentinel;var record=tryCatch(method,delegate.iterator,context.arg);if("throw"===record.type)return context.method="throw",context.arg=record.arg,context.delegate=null,ContinueSentinel;var info=record.arg;return info?info.done?(context[delegate.resultName]=info.value,context.next=delegate.nextLoc,"return"!==context.method&&(context.method="next",context.arg=undefined),context.delegate=null,ContinueSentinel):info:(context.method="throw",context.arg=new TypeError("iterator result is not an object"),context.delegate=null,ContinueSentinel);}function pushTryEntry(locs){var entry={tryLoc:locs[0]};1 in locs&&(entry.catchLoc=locs[1]),2 in locs&&(entry.finallyLoc=locs[2],entry.afterLoc=locs[3]),this.tryEntries.push(entry);}function resetTryEntry(entry){var record=entry.completion||{};record.type="normal",delete record.arg,entry.completion=record;}function Context(tryLocsList){this.tryEntries=[{tryLoc:"root"}],tryLocsList.forEach(pushTryEntry,this),this.reset(!0);}function values(iterable){if(iterable){var iteratorMethod=iterable[iteratorSymbol];if(iteratorMethod)return iteratorMethod.call(iterable);if("function"==typeof iterable.next)return iterable;if(!isNaN(iterable.length)){var i=-1,next=function next(){for(;++i<iterable.length;)if(hasOwn.call(iterable,i))return next.value=iterable[i],next.done=!1,next;return next.value=undefined,next.done=!0,next;};return next.next=next;}}return{next:doneResult};}function doneResult(){return{value:undefined,done:!0};}return GeneratorFunction.prototype=GeneratorFunctionPrototype,defineProperty(Gp,"constructor",{value:GeneratorFunctionPrototype,configurable:!0}),defineProperty(GeneratorFunctionPrototype,"constructor",{value:GeneratorFunction,configurable:!0}),GeneratorFunction.displayName=define(GeneratorFunctionPrototype,toStringTagSymbol,"GeneratorFunction"),exports.isGeneratorFunction=function(genFun){var ctor="function"==typeof genFun&&genFun.constructor;return!!ctor&&(ctor===GeneratorFunction||"GeneratorFunction"===(ctor.displayName||ctor.name));},exports.mark=function(genFun){return Object.setPrototypeOf?Object.setPrototypeOf(genFun,GeneratorFunctionPrototype):(genFun.__proto__=GeneratorFunctionPrototype,define(genFun,toStringTagSymbol,"GeneratorFunction")),genFun.prototype=Object.create(Gp),genFun;},exports.awrap=function(arg){return{__await:arg};},defineIteratorMethods(AsyncIterator.prototype),define(AsyncIterator.prototype,asyncIteratorSymbol,function(){return this;}),exports.AsyncIterator=AsyncIterator,exports.async=function(innerFn,outerFn,self,tryLocsList,PromiseImpl){void 0===PromiseImpl&&(PromiseImpl=Promise);var iter=new AsyncIterator(wrap(innerFn,outerFn,self,tryLocsList),PromiseImpl);return exports.isGeneratorFunction(outerFn)?iter:iter.next().then(function(result){return result.done?result.value:iter.next();});},defineIteratorMethods(Gp),define(Gp,toStringTagSymbol,"Generator"),define(Gp,iteratorSymbol,function(){return this;}),define(Gp,"toString",function(){return"[object Generator]";}),exports.keys=function(val){var object=Object(val),keys=[];for(var key in object)keys.push(key);return keys.reverse(),function next(){for(;keys.length;){var key=keys.pop();if(key in object)return next.value=key,next.done=!1,next;}return next.done=!0,next;};},exports.values=values,Context.prototype={constructor:Context,reset:function reset(skipTempReset){if(this.prev=0,this.next=0,this.sent=this._sent=undefined,this.done=!1,this.delegate=null,this.method="next",this.arg=undefined,this.tryEntries.forEach(resetTryEntry),!skipTempReset)for(var name in this)"t"===name.charAt(0)&&hasOwn.call(this,name)&&!isNaN(+name.slice(1))&&(this[name]=undefined);},stop:function stop(){this.done=!0;var rootRecord=this.tryEntries[0].completion;if("throw"===rootRecord.type)throw rootRecord.arg;return this.rval;},dispatchException:function dispatchException(exception){if(this.done)throw exception;var context=this;function handle(loc,caught){return record.type="throw",record.arg=exception,context.next=loc,caught&&(context.method="next",context.arg=undefined),!!caught;}for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i],record=entry.completion;if("root"===entry.tryLoc)return handle("end");if(entry.tryLoc<=this.prev){var hasCatch=hasOwn.call(entry,"catchLoc"),hasFinally=hasOwn.call(entry,"finallyLoc");if(hasCatch&&hasFinally){if(this.prev<entry.catchLoc)return handle(entry.catchLoc,!0);if(this.prev<entry.finallyLoc)return handle(entry.finallyLoc);}else if(hasCatch){if(this.prev<entry.catchLoc)return handle(entry.catchLoc,!0);}else{if(!hasFinally)throw new Error("try statement without catch or finally");if(this.prev<entry.finallyLoc)return handle(entry.finallyLoc);}}}},abrupt:function abrupt(type,arg){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.tryLoc<=this.prev&&hasOwn.call(entry,"finallyLoc")&&this.prev<entry.finallyLoc){var finallyEntry=entry;break;}}finallyEntry&&("break"===type||"continue"===type)&&finallyEntry.tryLoc<=arg&&arg<=finallyEntry.finallyLoc&&(finallyEntry=null);var record=finallyEntry?finallyEntry.completion:{};return record.type=type,record.arg=arg,finallyEntry?(this.method="next",this.next=finallyEntry.finallyLoc,ContinueSentinel):this.complete(record);},complete:function complete(record,afterLoc){if("throw"===record.type)throw record.arg;return"break"===record.type||"continue"===record.type?this.next=record.arg:"return"===record.type?(this.rval=this.arg=record.arg,this.method="return",this.next="end"):"normal"===record.type&&afterLoc&&(this.next=afterLoc),ContinueSentinel;},finish:function finish(finallyLoc){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.finallyLoc===finallyLoc)return this.complete(entry.completion,entry.afterLoc),resetTryEntry(entry),ContinueSentinel;}},catch:function _catch(tryLoc){for(var i=this.tryEntries.length-1;i>=0;--i){var entry=this.tryEntries[i];if(entry.tryLoc===tryLoc){var record=entry.completion;if("throw"===record.type){var thrown=record.arg;resetTryEntry(entry);}return thrown;}}throw new Error("illegal catch attempt");},delegateYield:function delegateYield(iterable,resultName,nextLoc){return this.delegate={iterator:values(iterable),resultName:resultName,nextLoc:nextLoc},"next"===this.method&&(this.arg=undefined),ContinueSentinel;}},exports;}function asyncGeneratorStep(gen,resolve,reject,_next,_throw,key,arg){try{var info=gen[key](arg);var value=info.value;}catch(error){reject(error);return;}if(info.done){resolve(value);}else{Promise.resolve(value).then(_next,_throw);}}function _asyncToGenerator(fn){return function(){var self=this,args=arguments;return new Promise(function(resolve,reject){var gen=fn.apply(self,args);function _next(value){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"next",value);}function _throw(err){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"throw",err);}_next(undefined);});};}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}}function _createClass(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);Object.defineProperty(Constructor,"prototype",{writable:false});return Constructor;}function _toPropertyKey(arg){var key=_toPrimitive(arg,"string");return _typeof(key)==="symbol"?key:String(key);}function _toPrimitive(input,hint){if(_typeof(input)!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(_typeof(res)!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.");}return(hint==="string"?String:Number)(input);}function _toConsumableArray(arr){return _arrayWithoutHoles(arr)||_iterableToArray(arr)||_unsupportedIterableToArray(arr)||_nonIterableSpread();}function _nonIterableSpread(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}function _unsupportedIterableToArray(o,minLen){if(!o)return;if(typeof o==="string")return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);if(n==="Object"&&o.constructor)n=o.constructor.name;if(n==="Map"||n==="Set")return Array.from(o);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return _arrayLikeToArray(o,minLen);}function _iterableToArray(iter){if(typeof Symbol!=="undefined"&&iter[Symbol.iterator]!=null||iter["@@iterator"]!=null)return Array.from(iter);}function _arrayWithoutHoles(arr){if(Array.isArray(arr))return _arrayLikeToArray(arr);}function _arrayLikeToArray(arr,len){if(len==null||len>arr.length)len=arr.length;for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2;}function hexToInt(a,size){var n=0;for(var i=0;i<=size;i++){n=n<<8|a[i];}return n>>>0;}function hexToStr(a,size){if(size===1){return String.fromCharCode(a[0],a[1]);}if(size===3){return String.fromCharCode(a[0],a[1],a[2],a[3]);}return String.fromCharCode.apply(String,_toConsumableArray(a.subarray(0,size+1)));}function addHex(a,b,size){var c=0;for(var i=size;i>=0;i--){c+=a[i]+b[i];a[i]=c&255;c>>=8;}}function incHex(a,size){var c=1;for(var i=size;i>=0&&c>0;i--){c+=a[i];a[i]=c&255;c>>=8;}}var MAX_NUM_SIZE=16;var MAX_ENCODED_NUM_SIZE=19;var BinaryCMapStream=/*#__PURE__*/function(){function BinaryCMapStream(data){_classCallCheck(this,BinaryCMapStream);this.buffer=data;this.pos=0;this.end=data.length;this.tmpBuf=new Uint8Array(MAX_ENCODED_NUM_SIZE);}_createClass(BinaryCMapStream,[{key:"readByte",value:function readByte(){if(this.pos>=this.end){return-1;}return this.buffer[this.pos++];}},{key:"readNumber",value:function readNumber(){var n=0;var last;do{var b=this.readByte();if(b<0){throw new _util.FormatError("unexpected EOF in bcmap");}last=!(b&0x80);n=n<<7|b&0x7f;}while(!last);return n;}},{key:"readSigned",value:function readSigned(){var n=this.readNumber();return n&1?~(n>>>1):n>>>1;}},{key:"readHex",value:function readHex(num,size){num.set(this.buffer.subarray(this.pos,this.pos+size+1));this.pos+=size+1;}},{key:"readHexNumber",value:function readHexNumber(num,size){var last;var stack=this.tmpBuf;var sp=0;do{var b=this.readByte();if(b<0){throw new _util.FormatError("unexpected EOF in bcmap");}last=!(b&0x80);stack[sp++]=b&0x7f;}while(!last);var i=size,buffer=0,bufferSize=0;while(i>=0){while(bufferSize<8&&stack.length>0){buffer|=stack[--sp]<<bufferSize;bufferSize+=7;}num[i]=buffer&255;i--;buffer>>=8;bufferSize-=8;}}},{key:"readHexSigned",value:function readHexSigned(num,size){this.readHexNumber(num,size);var sign=num[size]&1?255:0;var c=0;for(var i=0;i<=size;i++){c=(c&1)<<8|num[i];num[i]=c>>1^sign;}}},{key:"readString",value:function readString(){var len=this.readNumber(),buf=new Array(len);for(var i=0;i<len;i++){buf[i]=this.readNumber();}return String.fromCharCode.apply(String,buf);}}]);return BinaryCMapStream;}();var BinaryCMapReader=/*#__PURE__*/function(){function BinaryCMapReader(){_classCallCheck(this,BinaryCMapReader);}_createClass(BinaryCMapReader,[{key:"process",value:function(){var _process=_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee(data,cMap,extend){var stream,header,useCMap,start,end,char,charCode,tmp,code,b,type,sequence,dataSize,ucs2DataSize,subitemsCount,i,_i,_i2,_i3,_i4,_i5;return _regeneratorRuntime().wrap(function _callee$(_context){while(1)switch(_context.prev=_context.next){case 0:stream=new BinaryCMapStream(data);header=stream.readByte();cMap.vertical=!!(header&1);useCMap=null;start=new Uint8Array(MAX_NUM_SIZE);end=new Uint8Array(MAX_NUM_SIZE);char=new Uint8Array(MAX_NUM_SIZE);charCode=new Uint8Array(MAX_NUM_SIZE);tmp=new Uint8Array(MAX_NUM_SIZE);case 9:if(!((b=stream.readByte())>=0)){_context.next=68;break;}type=b>>5;if(!(type===7)){_context.next=20;break;}_context.t0=b&0x1f;_context.next=_context.t0===0?15:_context.t0===1?17:19;break;case 15:stream.readString();return _context.abrupt("break",19);case 17:useCMap=stream.readString();return _context.abrupt("break",19);case 19:return _context.abrupt("continue",9);case 20:sequence=!!(b&0x10);dataSize=b&15;if(!(dataSize+1>MAX_NUM_SIZE)){_context.next=24;break;}throw new Error("BinaryCMapReader.process: Invalid dataSize.");case 24:ucs2DataSize=1;subitemsCount=stream.readNumber();_context.t1=type;_context.next=_context.t1===0?29:_context.t1===1?35:_context.t1===2?41:_context.t1===3?46:_context.t1===4?53:_context.t1===5?58:65;break;case 29:stream.readHex(start,dataSize);stream.readHexNumber(en